/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ImmunizationEvaluationDoseStatus {
    VALID,
    NOTVALID,
    NULL;


    public static ImmunizationEvaluationDoseStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("valid".equals(codeString)) {
            return VALID;
        }
        if ("notvalid".equals(codeString)) {
            return NOTVALID;
        }
        throw new FHIRException("Unknown ImmunizationEvaluationDoseStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case VALID: {
                return "valid";
            }
            case NOTVALID: {
                return "notvalid";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/immunization-evaluation-dose-status";
    }

    public String getDefinition() {
        switch (this) {
            case VALID: {
                return "The dose counts toward fulfilling a path to immunity for a patient, providing protection against the target disease.";
            }
            case NOTVALID: {
                return "The dose does not count toward fulfilling a path to immunity for a patient.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case VALID: {
                return "Valid";
            }
            case NOTVALID: {
                return "Not valid";
            }
        }
        return "?";
    }
}

