/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum HistoryAbsentReason {
    SUBJECTUNKNOWN,
    WITHHELD,
    UNABLETOOBTAIN,
    DEFERRED,
    NULL;


    public static HistoryAbsentReason fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("subject-unknown".equals(codeString)) {
            return SUBJECTUNKNOWN;
        }
        if ("withheld".equals(codeString)) {
            return WITHHELD;
        }
        if ("unable-to-obtain".equals(codeString)) {
            return UNABLETOOBTAIN;
        }
        if ("deferred".equals(codeString)) {
            return DEFERRED;
        }
        throw new FHIRException("Unknown HistoryAbsentReason code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case SUBJECTUNKNOWN: {
                return "subject-unknown";
            }
            case WITHHELD: {
                return "withheld";
            }
            case UNABLETOOBTAIN: {
                return "unable-to-obtain";
            }
            case DEFERRED: {
                return "deferred";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/history-absent-reason";
    }

    public String getDefinition() {
        switch (this) {
            case SUBJECTUNKNOWN: {
                return "Patient does not know the subject, e.g. the biological parent of an adopted patient.";
            }
            case WITHHELD: {
                return "The patient withheld or refused to share the information.";
            }
            case UNABLETOOBTAIN: {
                return "Information cannot be obtained; e.g. unconscious patient";
            }
            case DEFERRED: {
                return "Patient does not have the information now, but can provide the information at a later date.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case SUBJECTUNKNOWN: {
                return "Subject Unknown";
            }
            case WITHHELD: {
                return "Information Withheld";
            }
            case UNABLETOOBTAIN: {
                return "Unable To Obtain";
            }
            case DEFERRED: {
                return "Deferred";
            }
        }
        return "?";
    }
}

