/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum GuideParameterCode {
    APPLYBUSINESSVERSION,
    APPLYJURISDICTION,
    PATHRESOURCE,
    PATHPAGES,
    PATHTXCACHE,
    EXPANSIONPROFILE,
    RULEBROKENLINKS,
    GENERATEXML,
    GENERATEJSON,
    GENERATETURTLE,
    HTMLTEMPLATE,
    NULL;


    public static GuideParameterCode fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("apply-business-version".equals(codeString)) {
            return APPLYBUSINESSVERSION;
        }
        if ("apply-jurisdiction".equals(codeString)) {
            return APPLYJURISDICTION;
        }
        if ("path-resource".equals(codeString)) {
            return PATHRESOURCE;
        }
        if ("path-pages".equals(codeString)) {
            return PATHPAGES;
        }
        if ("path-tx-cache".equals(codeString)) {
            return PATHTXCACHE;
        }
        if ("expansion-profile".equals(codeString)) {
            return EXPANSIONPROFILE;
        }
        if ("rule-broken-links".equals(codeString)) {
            return RULEBROKENLINKS;
        }
        if ("generate-xml".equals(codeString)) {
            return GENERATEXML;
        }
        if ("generate-json".equals(codeString)) {
            return GENERATEJSON;
        }
        if ("generate-turtle".equals(codeString)) {
            return GENERATETURTLE;
        }
        if ("html-template".equals(codeString)) {
            return HTMLTEMPLATE;
        }
        throw new FHIRException("Unknown GuideParameterCode code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case APPLYBUSINESSVERSION: {
                return "apply-business-version";
            }
            case APPLYJURISDICTION: {
                return "apply-jurisdiction";
            }
            case PATHRESOURCE: {
                return "path-resource";
            }
            case PATHPAGES: {
                return "path-pages";
            }
            case PATHTXCACHE: {
                return "path-tx-cache";
            }
            case EXPANSIONPROFILE: {
                return "expansion-profile";
            }
            case RULEBROKENLINKS: {
                return "rule-broken-links";
            }
            case GENERATEXML: {
                return "generate-xml";
            }
            case GENERATEJSON: {
                return "generate-json";
            }
            case GENERATETURTLE: {
                return "generate-turtle";
            }
            case HTMLTEMPLATE: {
                return "html-template";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/guide-parameter-code";
    }

    public String getDefinition() {
        switch (this) {
            case APPLYBUSINESSVERSION: {
                return "If the value of this boolean 0..1 parameter is \"true\" then all conformance resources will have any specified [Resource].version overwritten with the ImplementationGuide.version";
            }
            case APPLYJURISDICTION: {
                return "If the value of this boolean 0..1 parameter is \"true\" then all conformance resources will have any specified [Resource].jurisdiction overwritten with the ImplementationGuide.jurisdiction";
            }
            case PATHRESOURCE: {
                return "The value of this string 0..* parameter is a subfolder of the build context's location that is to be scanned to load resources. Scope is (if present) a particular resource type";
            }
            case PATHPAGES: {
                return "The value of this string 0..1 parameter is a subfolder of the build context's location that contains files that are part of the html content processed by the builder";
            }
            case PATHTXCACHE: {
                return "The value of this string 0..1 parameter is a subfolder of the build context's location that is used as the terminology cache. If this is not present, the terminology cache is on the local system, not under version control";
            }
            case EXPANSIONPROFILE: {
                return "The value of this string 0..1 parameter is a path to the ExpansionProfile used when expanding value sets for this implementation guide. This is particularly used to specify the versions of published terminologies such as SNOMED CT";
            }
            case RULEBROKENLINKS: {
                return "The value of this string 0..1 parameter is either \"warning\" or \"error\" (default = \"error\"). If the value is \"warning\" then IG build tools allow the IG to be considered successfully build even when there is no internal broken links";
            }
            case GENERATEXML: {
                return "The value of this boolean 0..1 parameter specifies whether the IG publisher creates examples in XML format. If not present, the Publication Tool decides whether to generate XML";
            }
            case GENERATEJSON: {
                return "The value of this boolean 0..1 parameter specifies whether the IG publisher creates examples in JSON format. If not present, the Publication Tool decides whether to generate JSON";
            }
            case GENERATETURTLE: {
                return "The value of this boolean 0..1 parameter specifies whether the IG publisher creates examples in Turtle format. If not present, the Publication Tool decides whether to generate Turtle";
            }
            case HTMLTEMPLATE: {
                return "The value of this string singleton parameter is the name of the file to use as the builder template for each generated page (see templating)";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case APPLYBUSINESSVERSION: {
                return "Apply Business Version";
            }
            case APPLYJURISDICTION: {
                return "Apply Jurisdiction";
            }
            case PATHRESOURCE: {
                return "Resource Path";
            }
            case PATHPAGES: {
                return "Pages Path";
            }
            case PATHTXCACHE: {
                return "Terminology Cache Path";
            }
            case EXPANSIONPROFILE: {
                return "Expansion Profile";
            }
            case RULEBROKENLINKS: {
                return "Broken Links Rule";
            }
            case GENERATEXML: {
                return "Generate XML";
            }
            case GENERATEJSON: {
                return "Generate JSON";
            }
            case GENERATETURTLE: {
                return "Generate Turtle";
            }
            case HTMLTEMPLATE: {
                return "HTML Template";
            }
        }
        return "?";
    }
}

