/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum GoalPriority {
    HIGHPRIORITY,
    MEDIUMPRIORITY,
    LOWPRIORITY,
    NULL;


    public static GoalPriority fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("high-priority".equals(codeString)) {
            return HIGHPRIORITY;
        }
        if ("medium-priority".equals(codeString)) {
            return MEDIUMPRIORITY;
        }
        if ("low-priority".equals(codeString)) {
            return LOWPRIORITY;
        }
        throw new FHIRException("Unknown GoalPriority code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case HIGHPRIORITY: {
                return "high-priority";
            }
            case MEDIUMPRIORITY: {
                return "medium-priority";
            }
            case LOWPRIORITY: {
                return "low-priority";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/goal-priority";
    }

    public String getDefinition() {
        switch (this) {
            case HIGHPRIORITY: {
                return "Indicates that the goal is of considerable importance and should be a primary focus of care delivery.";
            }
            case MEDIUMPRIORITY: {
                return "Indicates that the goal has a reasonable degree of importance and that concrete action should be taken towards the goal.  Attainment is not as critical as high-priority goals.";
            }
            case LOWPRIORITY: {
                return "The goal is desirable but is not sufficiently important to devote significant resources to.  Achievement of the goal may be sought when incidental to achieving other goals.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case HIGHPRIORITY: {
                return "High Priority";
            }
            case MEDIUMPRIORITY: {
                return "Medium Priority";
            }
            case LOWPRIORITY: {
                return "Low Priority";
            }
        }
        return "?";
    }
}

