/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ExpressionLanguage {
    TEXT_CQL,
    TEXT_FHIRPATH,
    NULL;


    public static ExpressionLanguage fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("text/cql".equals(codeString)) {
            return TEXT_CQL;
        }
        if ("text/fhirpath".equals(codeString)) {
            return TEXT_FHIRPATH;
        }
        throw new FHIRException("Unknown ExpressionLanguage code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case TEXT_CQL: {
                return "text/cql";
            }
            case TEXT_FHIRPATH: {
                return "text/fhirpath";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/expression-language";
    }

    public String getDefinition() {
        switch (this) {
            case TEXT_CQL: {
                return "Clinical Quality Language";
            }
            case TEXT_FHIRPATH: {
                return "FHIRPath";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case TEXT_CQL: {
                return "CQL";
            }
            case TEXT_FHIRPATH: {
                return "FHIRPath";
            }
        }
        return "?";
    }
}

