/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum EventTiming {
    MORN,
    MORN_EARLY,
    MORN_LATE,
    NOON,
    AFT,
    AFT_EARLY,
    AFT_LATE,
    EVE,
    EVE_EARLY,
    EVE_LATE,
    NIGHT,
    PHS,
    NULL;


    public static EventTiming fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("MORN".equals(codeString)) {
            return MORN;
        }
        if ("MORN.early".equals(codeString)) {
            return MORN_EARLY;
        }
        if ("MORN.late".equals(codeString)) {
            return MORN_LATE;
        }
        if ("NOON".equals(codeString)) {
            return NOON;
        }
        if ("AFT".equals(codeString)) {
            return AFT;
        }
        if ("AFT.early".equals(codeString)) {
            return AFT_EARLY;
        }
        if ("AFT.late".equals(codeString)) {
            return AFT_LATE;
        }
        if ("EVE".equals(codeString)) {
            return EVE;
        }
        if ("EVE.early".equals(codeString)) {
            return EVE_EARLY;
        }
        if ("EVE.late".equals(codeString)) {
            return EVE_LATE;
        }
        if ("NIGHT".equals(codeString)) {
            return NIGHT;
        }
        if ("PHS".equals(codeString)) {
            return PHS;
        }
        throw new FHIRException("Unknown EventTiming code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case MORN: {
                return "MORN";
            }
            case MORN_EARLY: {
                return "MORN.early";
            }
            case MORN_LATE: {
                return "MORN.late";
            }
            case NOON: {
                return "NOON";
            }
            case AFT: {
                return "AFT";
            }
            case AFT_EARLY: {
                return "AFT.early";
            }
            case AFT_LATE: {
                return "AFT.late";
            }
            case EVE: {
                return "EVE";
            }
            case EVE_EARLY: {
                return "EVE.early";
            }
            case EVE_LATE: {
                return "EVE.late";
            }
            case NIGHT: {
                return "NIGHT";
            }
            case PHS: {
                return "PHS";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/event-timing";
    }

    public String getDefinition() {
        switch (this) {
            case MORN: {
                return "Event occurs during the morning. The exact time is unspecified and established by institution convention or patient interpretation";
            }
            case MORN_EARLY: {
                return "Event occurs during the early morning. The exact time is unspecified and established by institution convention or patient interpretation";
            }
            case MORN_LATE: {
                return "Event occurs during the late morning. The exact time is unspecified and established by institution convention or patient interpretation";
            }
            case NOON: {
                return "Event occurs around 12:00pm. The exact time is unspecified and established by institution convention or patient interpretation";
            }
            case AFT: {
                return "Event occurs during the afternoon. The exact time is unspecified and established by institution convention or patient interpretation";
            }
            case AFT_EARLY: {
                return "Event occurs during the early afternoon. The exact time is unspecified and established by institution convention or patient interpretation";
            }
            case AFT_LATE: {
                return "Event occurs during the late afternoon. The exact time is unspecified and established by institution convention or patient interpretation";
            }
            case EVE: {
                return "Event occurs during the evening. The exact time is unspecified and established by institution convention or patient interpretation";
            }
            case EVE_EARLY: {
                return "Event occurs during the early evening. The exact time is unspecified and established by institution convention or patient interpretation";
            }
            case EVE_LATE: {
                return "Event occurs during the late evening. The exact time is unspecified and established by institution convention or patient interpretation";
            }
            case NIGHT: {
                return "Event occurs during the night. The exact time is unspecified and established by institution convention or patient interpretation";
            }
            case PHS: {
                return "Event occurs [offset] after subject goes to sleep. The exact time is unspecified and established by institution convention or patient interpretation";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case MORN: {
                return "Morning";
            }
            case MORN_EARLY: {
                return "Early Morning";
            }
            case MORN_LATE: {
                return "Late Morning";
            }
            case NOON: {
                return "Noon";
            }
            case AFT: {
                return "Afternoon";
            }
            case AFT_EARLY: {
                return "Early Afternoon";
            }
            case AFT_LATE: {
                return "Late Afternoon";
            }
            case EVE: {
                return "Evening";
            }
            case EVE_EARLY: {
                return "Early Evening";
            }
            case EVE_LATE: {
                return "Late Evening";
            }
            case NIGHT: {
                return "Night";
            }
            case PHS: {
                return "After Sleep";
            }
        }
        return "?";
    }
}

