/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum DetectedissueSeverity {
    HIGH,
    MODERATE,
    LOW,
    NULL;


    public static DetectedissueSeverity fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("high".equals(codeString)) {
            return HIGH;
        }
        if ("moderate".equals(codeString)) {
            return MODERATE;
        }
        if ("low".equals(codeString)) {
            return LOW;
        }
        throw new FHIRException("Unknown DetectedissueSeverity code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case HIGH: {
                return "high";
            }
            case MODERATE: {
                return "moderate";
            }
            case LOW: {
                return "low";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/detectedissue-severity";
    }

    public String getDefinition() {
        switch (this) {
            case HIGH: {
                return "Indicates the issue may be life-threatening or has the potential to cause permanent injury.";
            }
            case MODERATE: {
                return "Indicates the issue may result in noticeable adverse consequences but is unlikely to be life-threatening or cause permanent injury.";
            }
            case LOW: {
                return "Indicates the issue may result in some adverse consequences but is unlikely to substantially affect the situation of the subject.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case HIGH: {
                return "High";
            }
            case MODERATE: {
                return "Moderate";
            }
            case LOW: {
                return "Low";
            }
        }
        return "?";
    }
}

