/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ContractTermType {
    STATUTORY,
    SUBJECTTO,
    NULL;


    public static ContractTermType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("statutory".equals(codeString)) {
            return STATUTORY;
        }
        if ("subject-to".equals(codeString)) {
            return SUBJECTTO;
        }
        throw new FHIRException("Unknown ContractTermType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case STATUTORY: {
                return "statutory";
            }
            case SUBJECTTO: {
                return "subject-to";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/contracttermtypecodes";
    }

    public String getDefinition() {
        switch (this) {
            case STATUTORY: {
                return "Based on specialized statutes that deal with particular subjects.";
            }
            case SUBJECTTO: {
                return "Execution of the term in the contract is conditional on the execution of other actions.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case STATUTORY: {
                return "Statutory";
            }
            case SUBJECTTO: {
                return "Subject To";
            }
        }
        return "?";
    }
}

