/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ConsentCategory {
    ACD,
    DNR,
    EMRGONLY,
    HCD,
    NPP,
    POLST,
    RESEARCH,
    RSDID,
    RSREID,
    NULL;


    public static ConsentCategory fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("acd".equals(codeString)) {
            return ACD;
        }
        if ("dnr".equals(codeString)) {
            return DNR;
        }
        if ("emrgonly".equals(codeString)) {
            return EMRGONLY;
        }
        if ("hcd".equals(codeString)) {
            return HCD;
        }
        if ("npp".equals(codeString)) {
            return NPP;
        }
        if ("polst".equals(codeString)) {
            return POLST;
        }
        if ("research".equals(codeString)) {
            return RESEARCH;
        }
        if ("rsdid".equals(codeString)) {
            return RSDID;
        }
        if ("rsreid".equals(codeString)) {
            return RSREID;
        }
        throw new FHIRException("Unknown ConsentCategory code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ACD: {
                return "acd";
            }
            case DNR: {
                return "dnr";
            }
            case EMRGONLY: {
                return "emrgonly";
            }
            case HCD: {
                return "hcd";
            }
            case NPP: {
                return "npp";
            }
            case POLST: {
                return "polst";
            }
            case RESEARCH: {
                return "research";
            }
            case RSDID: {
                return "rsdid";
            }
            case RSREID: {
                return "rsreid";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/consentcategorycodes";
    }

    public String getDefinition() {
        switch (this) {
            case ACD: {
                return "Any instructions, written or given verbally by a patient to a health care provider in anticipation of potential need for medical treatment. [2005 Honor My Wishes]";
            }
            case DNR: {
                return "A legal document, signed by both the patient and their provider, stating a desire not to have CPR initiated in case of a cardiac event. Note: This form was replaced in 2003 with the Physician Orders for Life-Sustaining Treatment [POLST].";
            }
            case EMRGONLY: {
                return "Opt-in to disclosure of health information for emergency only consent directive. Comment: This general consent directive specifically limits disclosure of health information for purpose of emergency treatment. Additional parameters may further limit the disclosure to specific users, roles, duration, types of information, and impose uses obligations. [ActConsentDirective (2.16.840.1.113883.1.11.20425)]";
            }
            case HCD: {
                return "Patient's document telling patient's health care provider what the patient wants or does not want if the patient is diagnosed as being terminally ill and in a persistent vegetative state or in a permanently unconscious condition.[2005 Honor My Wishes]";
            }
            case NPP: {
                return "Acknowledgement of custodian notice of privacy practices. Usage Notes: This type of consent directive acknowledges a custodian's notice of privacy practices including its permitted collection, access, use and disclosure of health information to users and for purposes of use specified. [ActConsentDirective (2.16.840.1.113883.1.11.20425)]";
            }
            case POLST: {
                return "The Physician Order for Life-Sustaining Treatment form records a person's health care wishes for end of life emergency treatment and translates them into an order by the physician. It must be reviewed and signed by both the patient and the physician, Advanced Registered Nurse Practitioner or Physician Assistant. [2005 Honor My Wishes] Comment: Opt-in Consent Directive with restrictions.";
            }
            case RESEARCH: {
                return "Consent to have healthcare information in an electronic health record accessed for research purposes. [VALUE SET: ActConsentType (2.16.840.1.113883.1.11.19897)]";
            }
            case RSDID: {
                return "Consent to have de-identified healthcare information in an electronic health record that is accessed for research purposes, but without consent to re-identify the information under any circumstance. [VALUE SET: ActConsentType (2.16.840.1.113883.1.11.19897)";
            }
            case RSREID: {
                return "Consent to have de-identified healthcare information in an electronic health record that is accessed for research purposes re-identified under specific circumstances outlined in the consent. [VALUE SET: ActConsentType (2.16.840.1.113883.1.11.19897)]";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ACD: {
                return "Advance Directive";
            }
            case DNR: {
                return "Do Not Resuscitate";
            }
            case EMRGONLY: {
                return "Emergency Only";
            }
            case HCD: {
                return "Health Care Directive";
            }
            case NPP: {
                return "Notice of Privacy Practices";
            }
            case POLST: {
                return "POLST";
            }
            case RESEARCH: {
                return "Research Information Access";
            }
            case RSDID: {
                return "De-identified Information Access";
            }
            case RSREID: {
                return "Re-identifiable Information Access";
            }
        }
        return "?";
    }
}

