/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ClaimModifiers {
    A,
    B,
    C,
    E,
    ROOH,
    X,
    NULL;


    public static ClaimModifiers fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("a".equals(codeString)) {
            return A;
        }
        if ("b".equals(codeString)) {
            return B;
        }
        if ("c".equals(codeString)) {
            return C;
        }
        if ("e".equals(codeString)) {
            return E;
        }
        if ("rooh".equals(codeString)) {
            return ROOH;
        }
        if ("x".equals(codeString)) {
            return X;
        }
        throw new FHIRException("Unknown ClaimModifiers code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case A: {
                return "a";
            }
            case B: {
                return "b";
            }
            case C: {
                return "c";
            }
            case E: {
                return "e";
            }
            case ROOH: {
                return "rooh";
            }
            case X: {
                return "x";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/modifiers";
    }

    public String getDefinition() {
        switch (this) {
            case A: {
                return "Repair of prior service or installation.";
            }
            case B: {
                return "Temporary service or installation.";
            }
            case C: {
                return "Treatment associated with TMJ.";
            }
            case E: {
                return "Implant or associated with an implant.";
            }
            case ROOH: {
                return "A Rush service or service performed outside of normal office hours.";
            }
            case X: {
                return "None.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case A: {
                return "Repair of prior service or installation";
            }
            case B: {
                return "Temporary service or installation";
            }
            case C: {
                return "TMJ treatment";
            }
            case E: {
                return "Implant or associated with an implant";
            }
            case ROOH: {
                return "Rush or Outside of office hours";
            }
            case X: {
                return "None";
            }
        }
        return "?";
    }
}

