/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.Applicability;

public class ApplicabilityEnumFactory
implements EnumFactory<Applicability> {
    @Override
    public Applicability fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("in-network".equals(codeString)) {
            return Applicability.INNETWORK;
        }
        if ("out-of-network".equals(codeString)) {
            return Applicability.OUTOFNETWORK;
        }
        if ("other".equals(codeString)) {
            return Applicability.OTHER;
        }
        throw new IllegalArgumentException("Unknown Applicability code '" + codeString + "'");
    }

    @Override
    public String toCode(Applicability code) {
        if (code == Applicability.INNETWORK) {
            return "in-network";
        }
        if (code == Applicability.OUTOFNETWORK) {
            return "out-of-network";
        }
        if (code == Applicability.OTHER) {
            return "other";
        }
        return "?";
    }

    @Override
    public String toSystem(Applicability code) {
        return code.getSystem();
    }
}

