/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum AllergIntolSubstanceExpRisk {
    KNOWNREACTIONRISK,
    NOKNOWNREACTIONRISK,
    NULL;


    public static AllergIntolSubstanceExpRisk fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("known-reaction-risk".equals(codeString)) {
            return KNOWNREACTIONRISK;
        }
        if ("no-known-reaction-risk".equals(codeString)) {
            return NOKNOWNREACTIONRISK;
        }
        throw new FHIRException("Unknown AllergIntolSubstanceExpRisk code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case KNOWNREACTIONRISK: {
                return "known-reaction-risk";
            }
            case NOKNOWNREACTIONRISK: {
                return "no-known-reaction-risk";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/allerg-intol-substance-exp-risk";
    }

    public String getDefinition() {
        switch (this) {
            case KNOWNREACTIONRISK: {
                return "Known risk of allergy or intolerance reaction upon exposure to the specified substance.";
            }
            case NOKNOWNREACTIONRISK: {
                return "No known risk of allergy or intolerance reaction upon exposure to the specified substance.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case KNOWNREACTIONRISK: {
                return "Known Reaction Risk";
            }
            case NOKNOWNREACTIONRISK: {
                return "No Known Reaction Risk";
            }
        }
        return "?";
    }
}

