/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.ChildOrder;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.ContactDetail;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.MarkdownType;
import org.hl7.fhir.r4.model.MetadataResource;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.model.UsageContext;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="TerminologyCapabilities", profile="http://hl7.org/fhir/Profile/TerminologyCapabilities")
@ChildOrder(names={"url", "version", "name", "title", "status", "experimental", "date", "publisher", "contact", "description", "useContext", "jurisdiction", "purpose", "copyright", "lockedDate", "codeSystem", "expansion", "codeSearch", "validateCode", "translation", "closure"})
public class TerminologyCapabilities
extends MetadataResource {
    @Child(name="purpose", type={MarkdownType.class}, order=0, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why this terminology capabilities is defined", formalDefinition="Explanation of why this terminology capabilities is needed and why it has been designed as it has.")
    protected MarkdownType purpose;
    @Child(name="copyright", type={MarkdownType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the terminology capabilities and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the terminology capabilities.")
    protected MarkdownType copyright;
    @Child(name="lockedDate", type={BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Whether lockedDate is supported", formalDefinition="Whether the server supports lockedDate.")
    protected BooleanType lockedDate;
    @Child(name="codeSystem", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A code system supported by the server", formalDefinition="Identifies a code system that is supported by the server. If there is a no code system URL, then this declares the general assumptions a client can make about support for any CodeSystem resource.")
    protected List<TerminologyCapabilitiesCodeSystemComponent> codeSystem;
    @Child(name="expansion", type={}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Information about the $expansion operation", formalDefinition="Information about the $expansion operation.")
    protected TerminologyCapabilitiesExpansionComponent expansion;
    @Child(name="codeSearch", type={CodeType.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="explicit | all", formalDefinition="The degree to which the server supports the code search parameter on ValueSet, if it is supported.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/code-search-support")
    protected Enumeration<CodeSearchSupport> codeSearch;
    @Child(name="validateCode", type={}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Information about the $validation operation", formalDefinition="Information about the $validation operation.")
    protected TerminologyCapabilitiesValidateCodeComponent validateCode;
    @Child(name="translation", type={}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Information about the $translation operation", formalDefinition="Information about the $translation operation.")
    protected TerminologyCapabilitiesTranslationComponent translation;
    @Child(name="closure", type={}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Information about the $closure operation", formalDefinition="Whether the $closure operation is supported.")
    protected TerminologyCapabilitiesClosureComponent closure;
    private static final long serialVersionUID = 2013682721L;
    @SearchParamDefinition(name="date", path="TerminologyCapabilities.date", description="The terminology capabilities publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="jurisdiction", path="TerminologyCapabilities.jurisdiction", description="Intended jurisdiction for the terminology capabilities", type="token")
    public static final String SP_JURISDICTION = "jurisdiction";
    public static final TokenClientParam JURISDICTION = new TokenClientParam("jurisdiction");
    @SearchParamDefinition(name="name", path="TerminologyCapabilities.name", description="Computationally friendly name of the terminology capabilities", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="description", path="TerminologyCapabilities.description", description="The description of the terminology capabilities", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="publisher", path="TerminologyCapabilities.publisher", description="Name of the publisher of the terminology capabilities", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="title", path="TerminologyCapabilities.title", description="The human-friendly name of the terminology capabilities", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="version", path="TerminologyCapabilities.version", description="The business version of the terminology capabilities", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");
    @SearchParamDefinition(name="url", path="TerminologyCapabilities.url", description="The uri that identifies the terminology capabilities", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="status", path="TerminologyCapabilities.status", description="The current status of the terminology capabilities", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public TerminologyCapabilities() {
    }

    public TerminologyCapabilities(Enumeration<Enumerations.PublicationStatus> status, DateTimeType date) {
        this.status = status;
        this.date = date;
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TerminologyCapabilities.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public TerminologyCapabilities setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public TerminologyCapabilities setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TerminologyCapabilities.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public TerminologyCapabilities setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public TerminologyCapabilities setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TerminologyCapabilities.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public TerminologyCapabilities setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public TerminologyCapabilities setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TerminologyCapabilities.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    @Override
    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public TerminologyCapabilities setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    @Override
    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    @Override
    public TerminologyCapabilities setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TerminologyCapabilities.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public TerminologyCapabilities setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public TerminologyCapabilities setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TerminologyCapabilities.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    @Override
    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public TerminologyCapabilities setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    @Override
    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    @Override
    public TerminologyCapabilities setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TerminologyCapabilities.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public TerminologyCapabilities setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public TerminologyCapabilities setDate(Date value) {
        if (this.date == null) {
            this.date = new DateTimeType();
        }
        this.date.setValue(value);
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TerminologyCapabilities.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public TerminologyCapabilities setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public TerminologyCapabilities setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        return this.contact;
    }

    @Override
    public TerminologyCapabilities setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public TerminologyCapabilities addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    @Override
    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TerminologyCapabilities.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    @Override
    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public TerminologyCapabilities setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    @Override
    public TerminologyCapabilities setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        return this.useContext;
    }

    @Override
    public TerminologyCapabilities setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public TerminologyCapabilities addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        return this.jurisdiction;
    }

    @Override
    public TerminologyCapabilities setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    @Override
    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return t;
    }

    @Override
    public TerminologyCapabilities addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return this;
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    public MarkdownType getPurposeElement() {
        if (this.purpose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TerminologyCapabilities.purpose");
            }
            if (Configuration.doAutoCreate()) {
                this.purpose = new MarkdownType();
            }
        }
        return this.purpose;
    }

    public boolean hasPurposeElement() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public TerminologyCapabilities setPurposeElement(MarkdownType value) {
        this.purpose = value;
        return this;
    }

    public String getPurpose() {
        return this.purpose == null ? null : (String)this.purpose.getValue();
    }

    public TerminologyCapabilities setPurpose(String value) {
        if (value == null) {
            this.purpose = null;
        } else {
            if (this.purpose == null) {
                this.purpose = new MarkdownType();
            }
            this.purpose.setValue(value);
        }
        return this;
    }

    public MarkdownType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TerminologyCapabilities.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new MarkdownType();
            }
        }
        return this.copyright;
    }

    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public TerminologyCapabilities setCopyrightElement(MarkdownType value) {
        this.copyright = value;
        return this;
    }

    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    public TerminologyCapabilities setCopyright(String value) {
        if (value == null) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new MarkdownType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    public BooleanType getLockedDateElement() {
        if (this.lockedDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TerminologyCapabilities.lockedDate");
            }
            if (Configuration.doAutoCreate()) {
                this.lockedDate = new BooleanType();
            }
        }
        return this.lockedDate;
    }

    public boolean hasLockedDateElement() {
        return this.lockedDate != null && !this.lockedDate.isEmpty();
    }

    public boolean hasLockedDate() {
        return this.lockedDate != null && !this.lockedDate.isEmpty();
    }

    public TerminologyCapabilities setLockedDateElement(BooleanType value) {
        this.lockedDate = value;
        return this;
    }

    public boolean getLockedDate() {
        return this.lockedDate == null || this.lockedDate.isEmpty() ? false : (Boolean)this.lockedDate.getValue();
    }

    public TerminologyCapabilities setLockedDate(boolean value) {
        if (this.lockedDate == null) {
            this.lockedDate = new BooleanType();
        }
        this.lockedDate.setValue((Object)value);
        return this;
    }

    public List<TerminologyCapabilitiesCodeSystemComponent> getCodeSystem() {
        if (this.codeSystem == null) {
            this.codeSystem = new ArrayList<TerminologyCapabilitiesCodeSystemComponent>();
        }
        return this.codeSystem;
    }

    public TerminologyCapabilities setCodeSystem(List<TerminologyCapabilitiesCodeSystemComponent> theCodeSystem) {
        this.codeSystem = theCodeSystem;
        return this;
    }

    public boolean hasCodeSystem() {
        if (this.codeSystem == null) {
            return false;
        }
        for (TerminologyCapabilitiesCodeSystemComponent item : this.codeSystem) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public TerminologyCapabilitiesCodeSystemComponent addCodeSystem() {
        TerminologyCapabilitiesCodeSystemComponent t = new TerminologyCapabilitiesCodeSystemComponent();
        if (this.codeSystem == null) {
            this.codeSystem = new ArrayList<TerminologyCapabilitiesCodeSystemComponent>();
        }
        this.codeSystem.add(t);
        return t;
    }

    public TerminologyCapabilities addCodeSystem(TerminologyCapabilitiesCodeSystemComponent t) {
        if (t == null) {
            return this;
        }
        if (this.codeSystem == null) {
            this.codeSystem = new ArrayList<TerminologyCapabilitiesCodeSystemComponent>();
        }
        this.codeSystem.add(t);
        return this;
    }

    public TerminologyCapabilitiesCodeSystemComponent getCodeSystemFirstRep() {
        if (this.getCodeSystem().isEmpty()) {
            this.addCodeSystem();
        }
        return this.getCodeSystem().get(0);
    }

    public TerminologyCapabilitiesExpansionComponent getExpansion() {
        if (this.expansion == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TerminologyCapabilities.expansion");
            }
            if (Configuration.doAutoCreate()) {
                this.expansion = new TerminologyCapabilitiesExpansionComponent();
            }
        }
        return this.expansion;
    }

    public boolean hasExpansion() {
        return this.expansion != null && !this.expansion.isEmpty();
    }

    public TerminologyCapabilities setExpansion(TerminologyCapabilitiesExpansionComponent value) {
        this.expansion = value;
        return this;
    }

    public Enumeration<CodeSearchSupport> getCodeSearchElement() {
        if (this.codeSearch == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TerminologyCapabilities.codeSearch");
            }
            if (Configuration.doAutoCreate()) {
                this.codeSearch = new Enumeration<CodeSearchSupport>(new CodeSearchSupportEnumFactory());
            }
        }
        return this.codeSearch;
    }

    public boolean hasCodeSearchElement() {
        return this.codeSearch != null && !this.codeSearch.isEmpty();
    }

    public boolean hasCodeSearch() {
        return this.codeSearch != null && !this.codeSearch.isEmpty();
    }

    public TerminologyCapabilities setCodeSearchElement(Enumeration<CodeSearchSupport> value) {
        this.codeSearch = value;
        return this;
    }

    public CodeSearchSupport getCodeSearch() {
        return this.codeSearch == null ? null : (CodeSearchSupport)((Object)this.codeSearch.getValue());
    }

    public TerminologyCapabilities setCodeSearch(CodeSearchSupport value) {
        if (value == null) {
            this.codeSearch = null;
        } else {
            if (this.codeSearch == null) {
                this.codeSearch = new Enumeration<CodeSearchSupport>(new CodeSearchSupportEnumFactory());
            }
            this.codeSearch.setValue((Object)value);
        }
        return this;
    }

    public TerminologyCapabilitiesValidateCodeComponent getValidateCode() {
        if (this.validateCode == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TerminologyCapabilities.validateCode");
            }
            if (Configuration.doAutoCreate()) {
                this.validateCode = new TerminologyCapabilitiesValidateCodeComponent();
            }
        }
        return this.validateCode;
    }

    public boolean hasValidateCode() {
        return this.validateCode != null && !this.validateCode.isEmpty();
    }

    public TerminologyCapabilities setValidateCode(TerminologyCapabilitiesValidateCodeComponent value) {
        this.validateCode = value;
        return this;
    }

    public TerminologyCapabilitiesTranslationComponent getTranslation() {
        if (this.translation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TerminologyCapabilities.translation");
            }
            if (Configuration.doAutoCreate()) {
                this.translation = new TerminologyCapabilitiesTranslationComponent();
            }
        }
        return this.translation;
    }

    public boolean hasTranslation() {
        return this.translation != null && !this.translation.isEmpty();
    }

    public TerminologyCapabilities setTranslation(TerminologyCapabilitiesTranslationComponent value) {
        this.translation = value;
        return this;
    }

    public TerminologyCapabilitiesClosureComponent getClosure() {
        if (this.closure == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TerminologyCapabilities.closure");
            }
            if (Configuration.doAutoCreate()) {
                this.closure = new TerminologyCapabilitiesClosureComponent();
            }
        }
        return this.closure;
    }

    public boolean hasClosure() {
        return this.closure != null && !this.closure.isEmpty();
    }

    public TerminologyCapabilities setClosure(TerminologyCapabilitiesClosureComponent value) {
        this.closure = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this terminology capabilities when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which this terminology capabilities is (or will be) published.", 0, 1, this.url));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the terminology capabilities when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the terminology capabilities author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version));
        children.add(new Property(SP_NAME, "string", "A natural language name identifying the terminology capabilities. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the terminology capabilities.", 0, 1, this.title));
        children.add(new Property(SP_STATUS, "code", "The status of this terminology capabilities. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property("experimental", "boolean", "A Boolean value to indicate that this terminology capabilities is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the terminology capabilities was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the terminology capabilities changes.", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the terminology capabilities.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the terminology capabilities from a consumer's perspective. Typically, this is used when the capability statement describes a desired rather than an actual solution, for example as a formal expression of requirements as part of an RFP.", 0, 1, this.description));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching for appropriate terminology capabilities instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the terminology capabilities is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("purpose", "markdown", "Explanation of why this terminology capabilities is needed and why it has been designed as it has.", 0, 1, this.purpose));
        children.add(new Property("copyright", "markdown", "A copyright statement relating to the terminology capabilities and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the terminology capabilities.", 0, 1, this.copyright));
        children.add(new Property("lockedDate", "boolean", "Whether the server supports lockedDate.", 0, 1, this.lockedDate));
        children.add(new Property("codeSystem", "", "Identifies a code system that is supported by the server. If there is a no code system URL, then this declares the general assumptions a client can make about support for any CodeSystem resource.", 0, Integer.MAX_VALUE, this.codeSystem));
        children.add(new Property("expansion", "", "Information about the $expansion operation.", 0, 1, this.expansion));
        children.add(new Property("codeSearch", "code", "The degree to which the server supports the code search parameter on ValueSet, if it is supported.", 0, 1, this.codeSearch));
        children.add(new Property("validateCode", "", "Information about the $validation operation.", 0, 1, this.validateCode));
        children.add(new Property("translation", "", "Information about the $translation operation.", 0, 1, this.translation));
        children.add(new Property("closure", "", "Whether the $closure operation is supported.", 0, 1, this.closure));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this terminology capabilities when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which this terminology capabilities is (or will be) published.", 0, 1, this.url);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the terminology capabilities when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the terminology capabilities author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A natural language name identifying the terminology capabilities. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the terminology capabilities.", 0, 1, this.title);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of this terminology capabilities. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property("experimental", "boolean", "A Boolean value to indicate that this terminology capabilities is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the terminology capabilities was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the terminology capabilities changes.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the terminology capabilities.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the terminology capabilities from a consumer's perspective. Typically, this is used when the capability statement describes a desired rather than an actual solution, for example as a formal expression of requirements as part of an RFP.", 0, 1, this.description);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching for appropriate terminology capabilities instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the terminology capabilities is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case -220463842: {
                return new Property("purpose", "markdown", "Explanation of why this terminology capabilities is needed and why it has been designed as it has.", 0, 1, this.purpose);
            }
            case 1522889671: {
                return new Property("copyright", "markdown", "A copyright statement relating to the terminology capabilities and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the terminology capabilities.", 0, 1, this.copyright);
            }
            case 1391591896: {
                return new Property("lockedDate", "boolean", "Whether the server supports lockedDate.", 0, 1, this.lockedDate);
            }
            case -916511108: {
                return new Property("codeSystem", "", "Identifies a code system that is supported by the server. If there is a no code system URL, then this declares the general assumptions a client can make about support for any CodeSystem resource.", 0, Integer.MAX_VALUE, this.codeSystem);
            }
            case 17878207: {
                return new Property("expansion", "", "Information about the $expansion operation.", 0, 1, this.expansion);
            }
            case -935519755: {
                return new Property("codeSearch", "code", "The degree to which the server supports the code search parameter on ValueSet, if it is supported.", 0, 1, this.codeSearch);
            }
            case 1080737827: {
                return new Property("validateCode", "", "Information about the $validation operation.", 0, 1, this.validateCode);
            }
            case -1840647503: {
                return new Property("translation", "", "Information about the $translation operation.", 0, 1, this.translation);
            }
            case 866552379: {
                return new Property("closure", "", "Whether the $closure operation is supported.", 0, 1, this.closure);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.title;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.experimental;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case -220463842: {
                Base[] baseArray;
                if (this.purpose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.purpose;
                }
                return baseArray;
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.copyright;
                }
                return baseArray;
            }
            case 1391591896: {
                Base[] baseArray;
                if (this.lockedDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.lockedDate;
                }
                return baseArray;
            }
            case -916511108: {
                return this.codeSystem == null ? new Base[]{} : this.codeSystem.toArray(new Base[this.codeSystem.size()]);
            }
            case 17878207: {
                Base[] baseArray;
                if (this.expansion == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.expansion;
                }
                return baseArray;
            }
            case -935519755: {
                Base[] baseArray;
                if (this.codeSearch == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.codeSearch;
                }
                return baseArray;
            }
            case 1080737827: {
                Base[] baseArray;
                if (this.validateCode == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.validateCode;
                }
                return baseArray;
            }
            case -1840647503: {
                Base[] baseArray;
                if (this.translation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray17 = new Base[1];
                    baseArray = baseArray17;
                    baseArray17[0] = this.translation;
                }
                return baseArray;
            }
            case 866552379: {
                Base[] baseArray;
                if (this.closure == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray18 = new Base[1];
                    baseArray = baseArray18;
                    baseArray18[0] = this.closure;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = this.castToUri(value);
                return value;
            }
            case 351608024: {
                this.version = this.castToString(value);
                return value;
            }
            case 3373707: {
                this.name = this.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = this.castToString(value);
                return value;
            }
            case -892481550: {
                this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
                return value;
            }
            case -404562712: {
                this.experimental = this.castToBoolean(value);
                return value;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = this.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(this.castToContactDetail(value));
                return value;
            }
            case -1724546052: {
                this.description = this.castToMarkdown(value);
                return value;
            }
            case -669707736: {
                this.getUseContext().add(this.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(this.castToCodeableConcept(value));
                return value;
            }
            case -220463842: {
                this.purpose = this.castToMarkdown(value);
                return value;
            }
            case 1522889671: {
                this.copyright = this.castToMarkdown(value);
                return value;
            }
            case 1391591896: {
                this.lockedDate = this.castToBoolean(value);
                return value;
            }
            case -916511108: {
                this.getCodeSystem().add((TerminologyCapabilitiesCodeSystemComponent)((Object)value));
                return value;
            }
            case 17878207: {
                this.expansion = (TerminologyCapabilitiesExpansionComponent)((Object)value);
                return value;
            }
            case -935519755: {
                value = new CodeSearchSupportEnumFactory().fromType(this.castToCode(value));
                this.codeSearch = value;
                return value;
            }
            case 1080737827: {
                this.validateCode = (TerminologyCapabilitiesValidateCodeComponent)((Object)value);
                return value;
            }
            case -1840647503: {
                this.translation = (TerminologyCapabilitiesTranslationComponent)((Object)value);
                return value;
            }
            case 866552379: {
                this.closure = (TerminologyCapabilitiesClosureComponent)((Object)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = this.castToUri(value);
        } else if (name.equals(SP_VERSION)) {
            this.version = this.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = this.castToString(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = this.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
        } else if (name.equals("experimental")) {
            this.experimental = this.castToBoolean(value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = this.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(this.castToContactDetail(value));
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = this.castToMarkdown(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(this.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().add(this.castToCodeableConcept(value));
        } else if (name.equals("purpose")) {
            this.purpose = this.castToMarkdown(value);
        } else if (name.equals("copyright")) {
            this.copyright = this.castToMarkdown(value);
        } else if (name.equals("lockedDate")) {
            this.lockedDate = this.castToBoolean(value);
        } else if (name.equals("codeSystem")) {
            this.getCodeSystem().add((TerminologyCapabilitiesCodeSystemComponent)((Object)value));
        } else if (name.equals("expansion")) {
            this.expansion = (TerminologyCapabilitiesExpansionComponent)((Object)value);
        } else if (name.equals("codeSearch")) {
            value = new CodeSearchSupportEnumFactory().fromType(this.castToCode(value));
            this.codeSearch = value;
        } else if (name.equals("validateCode")) {
            this.validateCode = (TerminologyCapabilitiesValidateCodeComponent)((Object)value);
        } else if (name.equals("translation")) {
            this.translation = (TerminologyCapabilitiesTranslationComponent)((Object)value);
        } else if (name.equals("closure")) {
            this.closure = (TerminologyCapabilitiesClosureComponent)((Object)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case -220463842: {
                return this.getPurposeElement();
            }
            case 1522889671: {
                return this.getCopyrightElement();
            }
            case 1391591896: {
                return this.getLockedDateElement();
            }
            case -916511108: {
                return this.addCodeSystem();
            }
            case 17878207: {
                return this.getExpansion();
            }
            case -935519755: {
                return this.getCodeSearchElement();
            }
            case 1080737827: {
                return this.getValidateCode();
            }
            case -1840647503: {
                return this.getTranslation();
            }
            case 866552379: {
                return this.getClosure();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case -220463842: {
                return new String[]{"markdown"};
            }
            case 1522889671: {
                return new String[]{"markdown"};
            }
            case 1391591896: {
                return new String[]{"boolean"};
            }
            case -916511108: {
                return new String[0];
            }
            case 17878207: {
                return new String[0];
            }
            case -935519755: {
                return new String[]{"code"};
            }
            case 1080737827: {
                return new String[0];
            }
            case -1840647503: {
                return new String[0];
            }
            case 866552379: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.url");
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.version");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.name");
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.title");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.experimental");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_JURISDICTION)) {
            return this.addJurisdiction();
        }
        if (name.equals("purpose")) {
            throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.purpose");
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.copyright");
        }
        if (name.equals("lockedDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.lockedDate");
        }
        if (name.equals("codeSystem")) {
            return this.addCodeSystem();
        }
        if (name.equals("expansion")) {
            this.expansion = new TerminologyCapabilitiesExpansionComponent();
            return this.expansion;
        }
        if (name.equals("codeSearch")) {
            throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.codeSearch");
        }
        if (name.equals("validateCode")) {
            this.validateCode = new TerminologyCapabilitiesValidateCodeComponent();
            return this.validateCode;
        }
        if (name.equals("translation")) {
            this.translation = new TerminologyCapabilitiesTranslationComponent();
            return this.translation;
        }
        if (name.equals("closure")) {
            this.closure = new TerminologyCapabilitiesClosureComponent();
            return this.closure;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "TerminologyCapabilities";
    }

    @Override
    public TerminologyCapabilities copy() {
        TerminologyCapabilities dst = new TerminologyCapabilities();
        this.copyValues(dst);
        dst.url = this.url == null ? null : this.url.copy();
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.title = this.title == null ? null : this.title.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.purpose = this.purpose == null ? null : this.purpose.copy();
        dst.copyright = this.copyright == null ? null : this.copyright.copy();
        BooleanType booleanType = dst.lockedDate = this.lockedDate == null ? null : this.lockedDate.copy();
        if (this.codeSystem != null) {
            dst.codeSystem = new ArrayList<TerminologyCapabilitiesCodeSystemComponent>();
            for (TerminologyCapabilitiesCodeSystemComponent terminologyCapabilitiesCodeSystemComponent : this.codeSystem) {
                dst.codeSystem.add(terminologyCapabilitiesCodeSystemComponent.copy());
            }
        }
        dst.expansion = this.expansion == null ? null : this.expansion.copy();
        dst.codeSearch = this.codeSearch == null ? null : this.codeSearch.copy();
        dst.validateCode = this.validateCode == null ? null : this.validateCode.copy();
        dst.translation = this.translation == null ? null : this.translation.copy();
        dst.closure = this.closure == null ? null : this.closure.copy();
        return dst;
    }

    protected TerminologyCapabilities typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof TerminologyCapabilities)) {
            return false;
        }
        TerminologyCapabilities o = (TerminologyCapabilities)other_;
        return TerminologyCapabilities.compareDeep(this.purpose, o.purpose, true) && TerminologyCapabilities.compareDeep(this.copyright, o.copyright, true) && TerminologyCapabilities.compareDeep(this.lockedDate, o.lockedDate, true) && TerminologyCapabilities.compareDeep(this.codeSystem, o.codeSystem, true) && TerminologyCapabilities.compareDeep(this.expansion, o.expansion, true) && TerminologyCapabilities.compareDeep(this.codeSearch, o.codeSearch, true) && TerminologyCapabilities.compareDeep(this.validateCode, o.validateCode, true) && TerminologyCapabilities.compareDeep(this.translation, o.translation, true) && TerminologyCapabilities.compareDeep(this.closure, o.closure, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof TerminologyCapabilities)) {
            return false;
        }
        TerminologyCapabilities o = (TerminologyCapabilities)other_;
        return TerminologyCapabilities.compareValues(this.purpose, o.purpose, true) && TerminologyCapabilities.compareValues(this.copyright, o.copyright, true) && TerminologyCapabilities.compareValues(this.lockedDate, o.lockedDate, true) && TerminologyCapabilities.compareValues(this.codeSearch, o.codeSearch, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.purpose, this.copyright, this.lockedDate, this.codeSystem, this.expansion, this.codeSearch, this.validateCode, this.translation, this.closure});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.TerminologyCapabilities;
    }

    @Block
    public static class TerminologyCapabilitiesClosureComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="translation", type={BooleanType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="If cross-system closure is supported", formalDefinition="If cross-system closure is supported.")
        protected BooleanType translation;
        private static final long serialVersionUID = 1900484343L;

        public BooleanType getTranslationElement() {
            if (this.translation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TerminologyCapabilitiesClosureComponent.translation");
                }
                if (Configuration.doAutoCreate()) {
                    this.translation = new BooleanType();
                }
            }
            return this.translation;
        }

        public boolean hasTranslationElement() {
            return this.translation != null && !this.translation.isEmpty();
        }

        public boolean hasTranslation() {
            return this.translation != null && !this.translation.isEmpty();
        }

        public TerminologyCapabilitiesClosureComponent setTranslationElement(BooleanType value) {
            this.translation = value;
            return this;
        }

        public boolean getTranslation() {
            return this.translation == null || this.translation.isEmpty() ? false : (Boolean)this.translation.getValue();
        }

        public TerminologyCapabilitiesClosureComponent setTranslation(boolean value) {
            if (this.translation == null) {
                this.translation = new BooleanType();
            }
            this.translation.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("translation", "boolean", "If cross-system closure is supported.", 0, 1, this.translation));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1840647503: {
                    return new Property("translation", "boolean", "If cross-system closure is supported.", 0, 1, this.translation);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1840647503: {
                    Base[] baseArray;
                    if (this.translation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.translation;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1840647503: {
                    this.translation = this.castToBoolean(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (!name.equals("translation")) {
                return super.setProperty(name, value);
            }
            this.translation = this.castToBoolean(value);
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1840647503: {
                    return this.getTranslationElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1840647503: {
                    return new String[]{"boolean"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("translation")) {
                throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.translation");
            }
            return super.addChild(name);
        }

        @Override
        public TerminologyCapabilitiesClosureComponent copy() {
            TerminologyCapabilitiesClosureComponent dst = new TerminologyCapabilitiesClosureComponent();
            this.copyValues(dst);
            dst.translation = this.translation == null ? null : this.translation.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TerminologyCapabilitiesClosureComponent)) {
                return false;
            }
            TerminologyCapabilitiesClosureComponent o = (TerminologyCapabilitiesClosureComponent)other_;
            return TerminologyCapabilitiesClosureComponent.compareDeep(this.translation, o.translation, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TerminologyCapabilitiesClosureComponent)) {
                return false;
            }
            TerminologyCapabilitiesClosureComponent o = (TerminologyCapabilitiesClosureComponent)other_;
            return TerminologyCapabilitiesClosureComponent.compareValues(this.translation, o.translation, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.translation});
        }

        @Override
        public String fhirType() {
            return "TerminologyCapabilities.closure";
        }
    }

    @Block
    public static class TerminologyCapabilitiesTranslationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="needsMap", type={BooleanType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Whether the client must identify the map", formalDefinition="Whether the client must identify the map.")
        protected BooleanType needsMap;
        private static final long serialVersionUID = -1727843575L;

        public TerminologyCapabilitiesTranslationComponent() {
        }

        public TerminologyCapabilitiesTranslationComponent(BooleanType needsMap) {
            this.needsMap = needsMap;
        }

        public BooleanType getNeedsMapElement() {
            if (this.needsMap == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TerminologyCapabilitiesTranslationComponent.needsMap");
                }
                if (Configuration.doAutoCreate()) {
                    this.needsMap = new BooleanType();
                }
            }
            return this.needsMap;
        }

        public boolean hasNeedsMapElement() {
            return this.needsMap != null && !this.needsMap.isEmpty();
        }

        public boolean hasNeedsMap() {
            return this.needsMap != null && !this.needsMap.isEmpty();
        }

        public TerminologyCapabilitiesTranslationComponent setNeedsMapElement(BooleanType value) {
            this.needsMap = value;
            return this;
        }

        public boolean getNeedsMap() {
            return this.needsMap == null || this.needsMap.isEmpty() ? false : (Boolean)this.needsMap.getValue();
        }

        public TerminologyCapabilitiesTranslationComponent setNeedsMap(boolean value) {
            if (this.needsMap == null) {
                this.needsMap = new BooleanType();
            }
            this.needsMap.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("needsMap", "boolean", "Whether the client must identify the map.", 0, 1, this.needsMap));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 866566527: {
                    return new Property("needsMap", "boolean", "Whether the client must identify the map.", 0, 1, this.needsMap);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 866566527: {
                    Base[] baseArray;
                    if (this.needsMap == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.needsMap;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 866566527: {
                    this.needsMap = this.castToBoolean(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (!name.equals("needsMap")) {
                return super.setProperty(name, value);
            }
            this.needsMap = this.castToBoolean(value);
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 866566527: {
                    return this.getNeedsMapElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 866566527: {
                    return new String[]{"boolean"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("needsMap")) {
                throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.needsMap");
            }
            return super.addChild(name);
        }

        @Override
        public TerminologyCapabilitiesTranslationComponent copy() {
            TerminologyCapabilitiesTranslationComponent dst = new TerminologyCapabilitiesTranslationComponent();
            this.copyValues(dst);
            dst.needsMap = this.needsMap == null ? null : this.needsMap.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TerminologyCapabilitiesTranslationComponent)) {
                return false;
            }
            TerminologyCapabilitiesTranslationComponent o = (TerminologyCapabilitiesTranslationComponent)other_;
            return TerminologyCapabilitiesTranslationComponent.compareDeep(this.needsMap, o.needsMap, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TerminologyCapabilitiesTranslationComponent)) {
                return false;
            }
            TerminologyCapabilitiesTranslationComponent o = (TerminologyCapabilitiesTranslationComponent)other_;
            return TerminologyCapabilitiesTranslationComponent.compareValues(this.needsMap, o.needsMap, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.needsMap});
        }

        @Override
        public String fhirType() {
            return "TerminologyCapabilities.translation";
        }
    }

    @Block
    public static class TerminologyCapabilitiesValidateCodeComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="translations", type={BooleanType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Whether translations are validated", formalDefinition="Whether translations are validated.")
        protected BooleanType translations;
        private static final long serialVersionUID = -1212814906L;

        public TerminologyCapabilitiesValidateCodeComponent() {
        }

        public TerminologyCapabilitiesValidateCodeComponent(BooleanType translations) {
            this.translations = translations;
        }

        public BooleanType getTranslationsElement() {
            if (this.translations == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TerminologyCapabilitiesValidateCodeComponent.translations");
                }
                if (Configuration.doAutoCreate()) {
                    this.translations = new BooleanType();
                }
            }
            return this.translations;
        }

        public boolean hasTranslationsElement() {
            return this.translations != null && !this.translations.isEmpty();
        }

        public boolean hasTranslations() {
            return this.translations != null && !this.translations.isEmpty();
        }

        public TerminologyCapabilitiesValidateCodeComponent setTranslationsElement(BooleanType value) {
            this.translations = value;
            return this;
        }

        public boolean getTranslations() {
            return this.translations == null || this.translations.isEmpty() ? false : (Boolean)this.translations.getValue();
        }

        public TerminologyCapabilitiesValidateCodeComponent setTranslations(boolean value) {
            if (this.translations == null) {
                this.translations = new BooleanType();
            }
            this.translations.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("translations", "boolean", "Whether translations are validated.", 0, 1, this.translations));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1225497630: {
                    return new Property("translations", "boolean", "Whether translations are validated.", 0, 1, this.translations);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1225497630: {
                    Base[] baseArray;
                    if (this.translations == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.translations;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1225497630: {
                    this.translations = this.castToBoolean(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (!name.equals("translations")) {
                return super.setProperty(name, value);
            }
            this.translations = this.castToBoolean(value);
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1225497630: {
                    return this.getTranslationsElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1225497630: {
                    return new String[]{"boolean"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("translations")) {
                throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.translations");
            }
            return super.addChild(name);
        }

        @Override
        public TerminologyCapabilitiesValidateCodeComponent copy() {
            TerminologyCapabilitiesValidateCodeComponent dst = new TerminologyCapabilitiesValidateCodeComponent();
            this.copyValues(dst);
            dst.translations = this.translations == null ? null : this.translations.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TerminologyCapabilitiesValidateCodeComponent)) {
                return false;
            }
            TerminologyCapabilitiesValidateCodeComponent o = (TerminologyCapabilitiesValidateCodeComponent)other_;
            return TerminologyCapabilitiesValidateCodeComponent.compareDeep(this.translations, o.translations, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TerminologyCapabilitiesValidateCodeComponent)) {
                return false;
            }
            TerminologyCapabilitiesValidateCodeComponent o = (TerminologyCapabilitiesValidateCodeComponent)other_;
            return TerminologyCapabilitiesValidateCodeComponent.compareValues(this.translations, o.translations, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.translations});
        }

        @Override
        public String fhirType() {
            return "TerminologyCapabilities.validateCode";
        }
    }

    @Block
    public static class TerminologyCapabilitiesExpansionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="hierarchical", type={BooleanType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Whether the server can return nested value sets", formalDefinition="Whether the server can return nested value sets.")
        protected BooleanType hierarchical;
        @Child(name="paging", type={BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Whether the server supports paging on expansion", formalDefinition="Whether the server supports paging on expansion.")
        protected BooleanType paging;
        @Child(name="incomplete", type={BooleanType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Allow request for incomplete expansions?", formalDefinition="Allow request for incomplete expansions?")
        protected BooleanType incomplete;
        @Child(name="definition", type={CanonicalType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Supported fields on ExpansionProfile", formalDefinition="Supported fields on ExpansionProfile.")
        protected CanonicalType definition;
        @Child(name="profile", type={CanonicalType.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Supported expansion profiles", formalDefinition="Supported expansion profiles.")
        protected List<CanonicalType> profile;
        @Child(name="textFilter", type={MarkdownType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Documentation about text searching works", formalDefinition="Documentation about text searching works.")
        protected MarkdownType textFilter;
        private static final long serialVersionUID = 1275156533L;

        public BooleanType getHierarchicalElement() {
            if (this.hierarchical == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TerminologyCapabilitiesExpansionComponent.hierarchical");
                }
                if (Configuration.doAutoCreate()) {
                    this.hierarchical = new BooleanType();
                }
            }
            return this.hierarchical;
        }

        public boolean hasHierarchicalElement() {
            return this.hierarchical != null && !this.hierarchical.isEmpty();
        }

        public boolean hasHierarchical() {
            return this.hierarchical != null && !this.hierarchical.isEmpty();
        }

        public TerminologyCapabilitiesExpansionComponent setHierarchicalElement(BooleanType value) {
            this.hierarchical = value;
            return this;
        }

        public boolean getHierarchical() {
            return this.hierarchical == null || this.hierarchical.isEmpty() ? false : (Boolean)this.hierarchical.getValue();
        }

        public TerminologyCapabilitiesExpansionComponent setHierarchical(boolean value) {
            if (this.hierarchical == null) {
                this.hierarchical = new BooleanType();
            }
            this.hierarchical.setValue((Object)value);
            return this;
        }

        public BooleanType getPagingElement() {
            if (this.paging == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TerminologyCapabilitiesExpansionComponent.paging");
                }
                if (Configuration.doAutoCreate()) {
                    this.paging = new BooleanType();
                }
            }
            return this.paging;
        }

        public boolean hasPagingElement() {
            return this.paging != null && !this.paging.isEmpty();
        }

        public boolean hasPaging() {
            return this.paging != null && !this.paging.isEmpty();
        }

        public TerminologyCapabilitiesExpansionComponent setPagingElement(BooleanType value) {
            this.paging = value;
            return this;
        }

        public boolean getPaging() {
            return this.paging == null || this.paging.isEmpty() ? false : (Boolean)this.paging.getValue();
        }

        public TerminologyCapabilitiesExpansionComponent setPaging(boolean value) {
            if (this.paging == null) {
                this.paging = new BooleanType();
            }
            this.paging.setValue((Object)value);
            return this;
        }

        public BooleanType getIncompleteElement() {
            if (this.incomplete == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TerminologyCapabilitiesExpansionComponent.incomplete");
                }
                if (Configuration.doAutoCreate()) {
                    this.incomplete = new BooleanType();
                }
            }
            return this.incomplete;
        }

        public boolean hasIncompleteElement() {
            return this.incomplete != null && !this.incomplete.isEmpty();
        }

        public boolean hasIncomplete() {
            return this.incomplete != null && !this.incomplete.isEmpty();
        }

        public TerminologyCapabilitiesExpansionComponent setIncompleteElement(BooleanType value) {
            this.incomplete = value;
            return this;
        }

        public boolean getIncomplete() {
            return this.incomplete == null || this.incomplete.isEmpty() ? false : (Boolean)this.incomplete.getValue();
        }

        public TerminologyCapabilitiesExpansionComponent setIncomplete(boolean value) {
            if (this.incomplete == null) {
                this.incomplete = new BooleanType();
            }
            this.incomplete.setValue((Object)value);
            return this;
        }

        public CanonicalType getDefinitionElement() {
            if (this.definition == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TerminologyCapabilitiesExpansionComponent.definition");
                }
                if (Configuration.doAutoCreate()) {
                    this.definition = new CanonicalType();
                }
            }
            return this.definition;
        }

        public boolean hasDefinitionElement() {
            return this.definition != null && !this.definition.isEmpty();
        }

        public boolean hasDefinition() {
            return this.definition != null && !this.definition.isEmpty();
        }

        public TerminologyCapabilitiesExpansionComponent setDefinitionElement(CanonicalType value) {
            this.definition = value;
            return this;
        }

        public String getDefinition() {
            return this.definition == null ? null : (String)this.definition.getValue();
        }

        public TerminologyCapabilitiesExpansionComponent setDefinition(String value) {
            if (Utilities.noString((String)value)) {
                this.definition = null;
            } else {
                if (this.definition == null) {
                    this.definition = new CanonicalType();
                }
                this.definition.setValue(value);
            }
            return this;
        }

        public List<CanonicalType> getProfile() {
            if (this.profile == null) {
                this.profile = new ArrayList<CanonicalType>();
            }
            return this.profile;
        }

        public TerminologyCapabilitiesExpansionComponent setProfile(List<CanonicalType> theProfile) {
            this.profile = theProfile;
            return this;
        }

        public boolean hasProfile() {
            if (this.profile == null) {
                return false;
            }
            for (CanonicalType item : this.profile) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CanonicalType addProfileElement() {
            CanonicalType t = new CanonicalType();
            if (this.profile == null) {
                this.profile = new ArrayList<CanonicalType>();
            }
            this.profile.add(t);
            return t;
        }

        public TerminologyCapabilitiesExpansionComponent addProfile(String value) {
            CanonicalType t = new CanonicalType();
            t.setValue(value);
            if (this.profile == null) {
                this.profile = new ArrayList<CanonicalType>();
            }
            this.profile.add(t);
            return this;
        }

        public boolean hasProfile(String value) {
            if (this.profile == null) {
                return false;
            }
            for (CanonicalType v : this.profile) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public MarkdownType getTextFilterElement() {
            if (this.textFilter == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TerminologyCapabilitiesExpansionComponent.textFilter");
                }
                if (Configuration.doAutoCreate()) {
                    this.textFilter = new MarkdownType();
                }
            }
            return this.textFilter;
        }

        public boolean hasTextFilterElement() {
            return this.textFilter != null && !this.textFilter.isEmpty();
        }

        public boolean hasTextFilter() {
            return this.textFilter != null && !this.textFilter.isEmpty();
        }

        public TerminologyCapabilitiesExpansionComponent setTextFilterElement(MarkdownType value) {
            this.textFilter = value;
            return this;
        }

        public String getTextFilter() {
            return this.textFilter == null ? null : (String)this.textFilter.getValue();
        }

        public TerminologyCapabilitiesExpansionComponent setTextFilter(String value) {
            if (value == null) {
                this.textFilter = null;
            } else {
                if (this.textFilter == null) {
                    this.textFilter = new MarkdownType();
                }
                this.textFilter.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("hierarchical", "boolean", "Whether the server can return nested value sets.", 0, 1, this.hierarchical));
            children.add(new Property("paging", "boolean", "Whether the server supports paging on expansion.", 0, 1, this.paging));
            children.add(new Property("incomplete", "boolean", "Allow request for incomplete expansions?", 0, 1, this.incomplete));
            children.add(new Property("definition", "canonical(StructureDefinition)", "Supported fields on ExpansionProfile.", 0, 1, this.definition));
            children.add(new Property("profile", "canonical(ExpansionProfile)", "Supported expansion profiles.", 0, Integer.MAX_VALUE, this.profile));
            children.add(new Property("textFilter", "markdown", "Documentation about text searching works.", 0, 1, this.textFilter));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 857636745: {
                    return new Property("hierarchical", "boolean", "Whether the server can return nested value sets.", 0, 1, this.hierarchical);
                }
                case -995747956: {
                    return new Property("paging", "boolean", "Whether the server supports paging on expansion.", 0, 1, this.paging);
                }
                case -1010022050: {
                    return new Property("incomplete", "boolean", "Allow request for incomplete expansions?", 0, 1, this.incomplete);
                }
                case -1014418093: {
                    return new Property("definition", "canonical(StructureDefinition)", "Supported fields on ExpansionProfile.", 0, 1, this.definition);
                }
                case -309425751: {
                    return new Property("profile", "canonical(ExpansionProfile)", "Supported expansion profiles.", 0, Integer.MAX_VALUE, this.profile);
                }
                case 1469359877: {
                    return new Property("textFilter", "markdown", "Documentation about text searching works.", 0, 1, this.textFilter);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 857636745: {
                    Base[] baseArray;
                    if (this.hierarchical == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.hierarchical;
                    }
                    return baseArray;
                }
                case -995747956: {
                    Base[] baseArray;
                    if (this.paging == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.paging;
                    }
                    return baseArray;
                }
                case -1010022050: {
                    Base[] baseArray;
                    if (this.incomplete == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.incomplete;
                    }
                    return baseArray;
                }
                case -1014418093: {
                    Base[] baseArray;
                    if (this.definition == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.definition;
                    }
                    return baseArray;
                }
                case -309425751: {
                    return this.profile == null ? new Base[]{} : this.profile.toArray(new Base[this.profile.size()]);
                }
                case 1469359877: {
                    Base[] baseArray;
                    if (this.textFilter == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.textFilter;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 857636745: {
                    this.hierarchical = this.castToBoolean(value);
                    return value;
                }
                case -995747956: {
                    this.paging = this.castToBoolean(value);
                    return value;
                }
                case -1010022050: {
                    this.incomplete = this.castToBoolean(value);
                    return value;
                }
                case -1014418093: {
                    this.definition = this.castToCanonical(value);
                    return value;
                }
                case -309425751: {
                    this.getProfile().add(this.castToCanonical(value));
                    return value;
                }
                case 1469359877: {
                    this.textFilter = this.castToMarkdown(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("hierarchical")) {
                this.hierarchical = this.castToBoolean(value);
            } else if (name.equals("paging")) {
                this.paging = this.castToBoolean(value);
            } else if (name.equals("incomplete")) {
                this.incomplete = this.castToBoolean(value);
            } else if (name.equals("definition")) {
                this.definition = this.castToCanonical(value);
            } else if (name.equals("profile")) {
                this.getProfile().add(this.castToCanonical(value));
            } else if (name.equals("textFilter")) {
                this.textFilter = this.castToMarkdown(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 857636745: {
                    return this.getHierarchicalElement();
                }
                case -995747956: {
                    return this.getPagingElement();
                }
                case -1010022050: {
                    return this.getIncompleteElement();
                }
                case -1014418093: {
                    return this.getDefinitionElement();
                }
                case -309425751: {
                    return this.addProfileElement();
                }
                case 1469359877: {
                    return this.getTextFilterElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 857636745: {
                    return new String[]{"boolean"};
                }
                case -995747956: {
                    return new String[]{"boolean"};
                }
                case -1010022050: {
                    return new String[]{"boolean"};
                }
                case -1014418093: {
                    return new String[]{"canonical"};
                }
                case -309425751: {
                    return new String[]{"canonical"};
                }
                case 1469359877: {
                    return new String[]{"markdown"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("hierarchical")) {
                throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.hierarchical");
            }
            if (name.equals("paging")) {
                throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.paging");
            }
            if (name.equals("incomplete")) {
                throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.incomplete");
            }
            if (name.equals("definition")) {
                throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.definition");
            }
            if (name.equals("profile")) {
                throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.profile");
            }
            if (name.equals("textFilter")) {
                throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.textFilter");
            }
            return super.addChild(name);
        }

        @Override
        public TerminologyCapabilitiesExpansionComponent copy() {
            TerminologyCapabilitiesExpansionComponent dst = new TerminologyCapabilitiesExpansionComponent();
            this.copyValues(dst);
            dst.hierarchical = this.hierarchical == null ? null : this.hierarchical.copy();
            dst.paging = this.paging == null ? null : this.paging.copy();
            dst.incomplete = this.incomplete == null ? null : this.incomplete.copy();
            CanonicalType canonicalType = dst.definition = this.definition == null ? null : this.definition.copy();
            if (this.profile != null) {
                dst.profile = new ArrayList<CanonicalType>();
                for (CanonicalType i : this.profile) {
                    dst.profile.add(i.copy());
                }
            }
            dst.textFilter = this.textFilter == null ? null : this.textFilter.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TerminologyCapabilitiesExpansionComponent)) {
                return false;
            }
            TerminologyCapabilitiesExpansionComponent o = (TerminologyCapabilitiesExpansionComponent)other_;
            return TerminologyCapabilitiesExpansionComponent.compareDeep(this.hierarchical, o.hierarchical, true) && TerminologyCapabilitiesExpansionComponent.compareDeep(this.paging, o.paging, true) && TerminologyCapabilitiesExpansionComponent.compareDeep(this.incomplete, o.incomplete, true) && TerminologyCapabilitiesExpansionComponent.compareDeep(this.definition, o.definition, true) && TerminologyCapabilitiesExpansionComponent.compareDeep(this.profile, o.profile, true) && TerminologyCapabilitiesExpansionComponent.compareDeep(this.textFilter, o.textFilter, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TerminologyCapabilitiesExpansionComponent)) {
                return false;
            }
            TerminologyCapabilitiesExpansionComponent o = (TerminologyCapabilitiesExpansionComponent)other_;
            return TerminologyCapabilitiesExpansionComponent.compareValues(this.hierarchical, o.hierarchical, true) && TerminologyCapabilitiesExpansionComponent.compareValues(this.paging, o.paging, true) && TerminologyCapabilitiesExpansionComponent.compareValues(this.incomplete, o.incomplete, true) && TerminologyCapabilitiesExpansionComponent.compareValues(this.textFilter, o.textFilter, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.hierarchical, this.paging, this.incomplete, this.definition, this.profile, this.textFilter});
        }

        @Override
        public String fhirType() {
            return "TerminologyCapabilities.expansion";
        }
    }

    @Block
    public static class TerminologyCapabilitiesCodeSystemVersionFilterComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code of the property supported", formalDefinition="Code of the property supported.")
        protected CodeType code;
        @Child(name="op", type={CodeType.class}, order=2, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Operations supported for the property", formalDefinition="Operations supported for the property.")
        protected List<CodeType> op;
        private static final long serialVersionUID = -489160282L;

        public TerminologyCapabilitiesCodeSystemVersionFilterComponent() {
        }

        public TerminologyCapabilitiesCodeSystemVersionFilterComponent(CodeType code) {
            this.code = code;
        }

        public CodeType getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TerminologyCapabilitiesCodeSystemVersionFilterComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeType();
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public TerminologyCapabilitiesCodeSystemVersionFilterComponent setCodeElement(CodeType value) {
            this.code = value;
            return this;
        }

        public String getCode() {
            return this.code == null ? null : (String)this.code.getValue();
        }

        public TerminologyCapabilitiesCodeSystemVersionFilterComponent setCode(String value) {
            if (this.code == null) {
                this.code = new CodeType();
            }
            this.code.setValue(value);
            return this;
        }

        public List<CodeType> getOp() {
            if (this.op == null) {
                this.op = new ArrayList<CodeType>();
            }
            return this.op;
        }

        public TerminologyCapabilitiesCodeSystemVersionFilterComponent setOp(List<CodeType> theOp) {
            this.op = theOp;
            return this;
        }

        public boolean hasOp() {
            if (this.op == null) {
                return false;
            }
            for (CodeType item : this.op) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeType addOpElement() {
            CodeType t = new CodeType();
            if (this.op == null) {
                this.op = new ArrayList<CodeType>();
            }
            this.op.add(t);
            return t;
        }

        public TerminologyCapabilitiesCodeSystemVersionFilterComponent addOp(String value) {
            CodeType t = new CodeType();
            t.setValue(value);
            if (this.op == null) {
                this.op = new ArrayList<CodeType>();
            }
            this.op.add(t);
            return this;
        }

        public boolean hasOp(String value) {
            if (this.op == null) {
                return false;
            }
            for (CodeType v : this.op) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "code", "Code of the property supported.", 0, 1, this.code));
            children.add(new Property("op", "code", "Operations supported for the property.", 0, Integer.MAX_VALUE, this.op));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "code", "Code of the property supported.", 0, 1, this.code);
                }
                case 3553: {
                    return new Property("op", "code", "Operations supported for the property.", 0, Integer.MAX_VALUE, this.op);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 3553: {
                    return this.op == null ? new Base[]{} : this.op.toArray(new Base[this.op.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = this.castToCode(value);
                    return value;
                }
                case 3553: {
                    this.getOp().add(this.castToCode(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = this.castToCode(value);
            } else if (name.equals("op")) {
                this.getOp().add(this.castToCode(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCodeElement();
                }
                case 3553: {
                    return this.addOpElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"code"};
                }
                case 3553: {
                    return new String[]{"code"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.code");
            }
            if (name.equals("op")) {
                throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.op");
            }
            return super.addChild(name);
        }

        @Override
        public TerminologyCapabilitiesCodeSystemVersionFilterComponent copy() {
            TerminologyCapabilitiesCodeSystemVersionFilterComponent dst = new TerminologyCapabilitiesCodeSystemVersionFilterComponent();
            this.copyValues(dst);
            CodeType codeType = dst.code = this.code == null ? null : this.code.copy();
            if (this.op != null) {
                dst.op = new ArrayList<CodeType>();
                for (CodeType i : this.op) {
                    dst.op.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TerminologyCapabilitiesCodeSystemVersionFilterComponent)) {
                return false;
            }
            TerminologyCapabilitiesCodeSystemVersionFilterComponent o = (TerminologyCapabilitiesCodeSystemVersionFilterComponent)other_;
            return TerminologyCapabilitiesCodeSystemVersionFilterComponent.compareDeep(this.code, o.code, true) && TerminologyCapabilitiesCodeSystemVersionFilterComponent.compareDeep(this.op, o.op, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TerminologyCapabilitiesCodeSystemVersionFilterComponent)) {
                return false;
            }
            TerminologyCapabilitiesCodeSystemVersionFilterComponent o = (TerminologyCapabilitiesCodeSystemVersionFilterComponent)other_;
            return TerminologyCapabilitiesCodeSystemVersionFilterComponent.compareValues(this.code, o.code, true) && TerminologyCapabilitiesCodeSystemVersionFilterComponent.compareValues(this.op, o.op, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.code, this.op});
        }

        @Override
        public String fhirType() {
            return "TerminologyCapabilities.codeSystem.version.filter";
        }
    }

    @Block
    public static class TerminologyCapabilitiesCodeSystemVersionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Version identifier for this version", formalDefinition="For version-less code systems, there should be a single version with no identifier.")
        protected StringType code;
        @Child(name="isDefault", type={BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="If this is the default version for this code system", formalDefinition="If this is the default version for this code system.")
        protected BooleanType isDefault;
        @Child(name="compositional", type={BooleanType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="If compositional grammar is supported", formalDefinition="If the compositional grammar defined by the code system is supported.")
        protected BooleanType compositional;
        @Child(name="language", type={CodeType.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Language Displays supported", formalDefinition="Language Displays supported.")
        protected List<CodeType> language;
        @Child(name="filter", type={}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Filter Properties supported", formalDefinition="Filter Properties supported.")
        protected List<TerminologyCapabilitiesCodeSystemVersionFilterComponent> filter;
        @Child(name="property", type={CodeType.class}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Properties supported for $lookup", formalDefinition="Properties supported for $lookup.")
        protected List<CodeType> property;
        private static final long serialVersionUID = 1857571343L;

        public StringType getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TerminologyCapabilitiesCodeSystemVersionComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new StringType();
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public TerminologyCapabilitiesCodeSystemVersionComponent setCodeElement(StringType value) {
            this.code = value;
            return this;
        }

        public String getCode() {
            return this.code == null ? null : (String)this.code.getValue();
        }

        public TerminologyCapabilitiesCodeSystemVersionComponent setCode(String value) {
            if (Utilities.noString((String)value)) {
                this.code = null;
            } else {
                if (this.code == null) {
                    this.code = new StringType();
                }
                this.code.setValue(value);
            }
            return this;
        }

        public BooleanType getIsDefaultElement() {
            if (this.isDefault == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TerminologyCapabilitiesCodeSystemVersionComponent.isDefault");
                }
                if (Configuration.doAutoCreate()) {
                    this.isDefault = new BooleanType();
                }
            }
            return this.isDefault;
        }

        public boolean hasIsDefaultElement() {
            return this.isDefault != null && !this.isDefault.isEmpty();
        }

        public boolean hasIsDefault() {
            return this.isDefault != null && !this.isDefault.isEmpty();
        }

        public TerminologyCapabilitiesCodeSystemVersionComponent setIsDefaultElement(BooleanType value) {
            this.isDefault = value;
            return this;
        }

        public boolean getIsDefault() {
            return this.isDefault == null || this.isDefault.isEmpty() ? false : (Boolean)this.isDefault.getValue();
        }

        public TerminologyCapabilitiesCodeSystemVersionComponent setIsDefault(boolean value) {
            if (this.isDefault == null) {
                this.isDefault = new BooleanType();
            }
            this.isDefault.setValue((Object)value);
            return this;
        }

        public BooleanType getCompositionalElement() {
            if (this.compositional == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TerminologyCapabilitiesCodeSystemVersionComponent.compositional");
                }
                if (Configuration.doAutoCreate()) {
                    this.compositional = new BooleanType();
                }
            }
            return this.compositional;
        }

        public boolean hasCompositionalElement() {
            return this.compositional != null && !this.compositional.isEmpty();
        }

        public boolean hasCompositional() {
            return this.compositional != null && !this.compositional.isEmpty();
        }

        public TerminologyCapabilitiesCodeSystemVersionComponent setCompositionalElement(BooleanType value) {
            this.compositional = value;
            return this;
        }

        public boolean getCompositional() {
            return this.compositional == null || this.compositional.isEmpty() ? false : (Boolean)this.compositional.getValue();
        }

        public TerminologyCapabilitiesCodeSystemVersionComponent setCompositional(boolean value) {
            if (this.compositional == null) {
                this.compositional = new BooleanType();
            }
            this.compositional.setValue((Object)value);
            return this;
        }

        public List<CodeType> getLanguage() {
            if (this.language == null) {
                this.language = new ArrayList<CodeType>();
            }
            return this.language;
        }

        public TerminologyCapabilitiesCodeSystemVersionComponent setLanguage(List<CodeType> theLanguage) {
            this.language = theLanguage;
            return this;
        }

        public boolean hasLanguage() {
            if (this.language == null) {
                return false;
            }
            for (CodeType item : this.language) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeType addLanguageElement() {
            CodeType t = new CodeType();
            if (this.language == null) {
                this.language = new ArrayList<CodeType>();
            }
            this.language.add(t);
            return t;
        }

        public TerminologyCapabilitiesCodeSystemVersionComponent addLanguage(String value) {
            CodeType t = new CodeType();
            t.setValue(value);
            if (this.language == null) {
                this.language = new ArrayList<CodeType>();
            }
            this.language.add(t);
            return this;
        }

        public boolean hasLanguage(String value) {
            if (this.language == null) {
                return false;
            }
            for (CodeType v : this.language) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<TerminologyCapabilitiesCodeSystemVersionFilterComponent> getFilter() {
            if (this.filter == null) {
                this.filter = new ArrayList<TerminologyCapabilitiesCodeSystemVersionFilterComponent>();
            }
            return this.filter;
        }

        public TerminologyCapabilitiesCodeSystemVersionComponent setFilter(List<TerminologyCapabilitiesCodeSystemVersionFilterComponent> theFilter) {
            this.filter = theFilter;
            return this;
        }

        public boolean hasFilter() {
            if (this.filter == null) {
                return false;
            }
            for (TerminologyCapabilitiesCodeSystemVersionFilterComponent item : this.filter) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public TerminologyCapabilitiesCodeSystemVersionFilterComponent addFilter() {
            TerminologyCapabilitiesCodeSystemVersionFilterComponent t = new TerminologyCapabilitiesCodeSystemVersionFilterComponent();
            if (this.filter == null) {
                this.filter = new ArrayList<TerminologyCapabilitiesCodeSystemVersionFilterComponent>();
            }
            this.filter.add(t);
            return t;
        }

        public TerminologyCapabilitiesCodeSystemVersionComponent addFilter(TerminologyCapabilitiesCodeSystemVersionFilterComponent t) {
            if (t == null) {
                return this;
            }
            if (this.filter == null) {
                this.filter = new ArrayList<TerminologyCapabilitiesCodeSystemVersionFilterComponent>();
            }
            this.filter.add(t);
            return this;
        }

        public TerminologyCapabilitiesCodeSystemVersionFilterComponent getFilterFirstRep() {
            if (this.getFilter().isEmpty()) {
                this.addFilter();
            }
            return this.getFilter().get(0);
        }

        public List<CodeType> getProperty() {
            if (this.property == null) {
                this.property = new ArrayList<CodeType>();
            }
            return this.property;
        }

        public TerminologyCapabilitiesCodeSystemVersionComponent setProperty(List<CodeType> theProperty) {
            this.property = theProperty;
            return this;
        }

        public boolean hasProperty() {
            if (this.property == null) {
                return false;
            }
            for (CodeType item : this.property) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeType addPropertyElement() {
            CodeType t = new CodeType();
            if (this.property == null) {
                this.property = new ArrayList<CodeType>();
            }
            this.property.add(t);
            return t;
        }

        public TerminologyCapabilitiesCodeSystemVersionComponent addProperty(String value) {
            CodeType t = new CodeType();
            t.setValue(value);
            if (this.property == null) {
                this.property = new ArrayList<CodeType>();
            }
            this.property.add(t);
            return this;
        }

        public boolean hasProperty(String value) {
            if (this.property == null) {
                return false;
            }
            for (CodeType v : this.property) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "string", "For version-less code systems, there should be a single version with no identifier.", 0, 1, this.code));
            children.add(new Property("isDefault", "boolean", "If this is the default version for this code system.", 0, 1, this.isDefault));
            children.add(new Property("compositional", "boolean", "If the compositional grammar defined by the code system is supported.", 0, 1, this.compositional));
            children.add(new Property("language", "code", "Language Displays supported.", 0, Integer.MAX_VALUE, this.language));
            children.add(new Property("filter", "", "Filter Properties supported.", 0, Integer.MAX_VALUE, this.filter));
            children.add(new Property("property", "code", "Properties supported for $lookup.", 0, Integer.MAX_VALUE, this.property));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "string", "For version-less code systems, there should be a single version with no identifier.", 0, 1, this.code);
                }
                case 965025207: {
                    return new Property("isDefault", "boolean", "If this is the default version for this code system.", 0, 1, this.isDefault);
                }
                case 1248023381: {
                    return new Property("compositional", "boolean", "If the compositional grammar defined by the code system is supported.", 0, 1, this.compositional);
                }
                case -1613589672: {
                    return new Property("language", "code", "Language Displays supported.", 0, Integer.MAX_VALUE, this.language);
                }
                case -1274492040: {
                    return new Property("filter", "", "Filter Properties supported.", 0, Integer.MAX_VALUE, this.filter);
                }
                case -993141291: {
                    return new Property("property", "code", "Properties supported for $lookup.", 0, Integer.MAX_VALUE, this.property);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 965025207: {
                    Base[] baseArray;
                    if (this.isDefault == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.isDefault;
                    }
                    return baseArray;
                }
                case 1248023381: {
                    Base[] baseArray;
                    if (this.compositional == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.compositional;
                    }
                    return baseArray;
                }
                case -1613589672: {
                    return this.language == null ? new Base[]{} : this.language.toArray(new Base[this.language.size()]);
                }
                case -1274492040: {
                    return this.filter == null ? new Base[]{} : this.filter.toArray(new Base[this.filter.size()]);
                }
                case -993141291: {
                    return this.property == null ? new Base[]{} : this.property.toArray(new Base[this.property.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = this.castToString(value);
                    return value;
                }
                case 965025207: {
                    this.isDefault = this.castToBoolean(value);
                    return value;
                }
                case 1248023381: {
                    this.compositional = this.castToBoolean(value);
                    return value;
                }
                case -1613589672: {
                    this.getLanguage().add(this.castToCode(value));
                    return value;
                }
                case -1274492040: {
                    this.getFilter().add((TerminologyCapabilitiesCodeSystemVersionFilterComponent)value);
                    return value;
                }
                case -993141291: {
                    this.getProperty().add(this.castToCode(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = this.castToString(value);
            } else if (name.equals("isDefault")) {
                this.isDefault = this.castToBoolean(value);
            } else if (name.equals("compositional")) {
                this.compositional = this.castToBoolean(value);
            } else if (name.equals("language")) {
                this.getLanguage().add(this.castToCode(value));
            } else if (name.equals("filter")) {
                this.getFilter().add((TerminologyCapabilitiesCodeSystemVersionFilterComponent)value);
            } else if (name.equals("property")) {
                this.getProperty().add(this.castToCode(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCodeElement();
                }
                case 965025207: {
                    return this.getIsDefaultElement();
                }
                case 1248023381: {
                    return this.getCompositionalElement();
                }
                case -1613589672: {
                    return this.addLanguageElement();
                }
                case -1274492040: {
                    return this.addFilter();
                }
                case -993141291: {
                    return this.addPropertyElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"string"};
                }
                case 965025207: {
                    return new String[]{"boolean"};
                }
                case 1248023381: {
                    return new String[]{"boolean"};
                }
                case -1613589672: {
                    return new String[]{"code"};
                }
                case -1274492040: {
                    return new String[0];
                }
                case -993141291: {
                    return new String[]{"code"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.code");
            }
            if (name.equals("isDefault")) {
                throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.isDefault");
            }
            if (name.equals("compositional")) {
                throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.compositional");
            }
            if (name.equals("language")) {
                throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.language");
            }
            if (name.equals("filter")) {
                return this.addFilter();
            }
            if (name.equals("property")) {
                throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.property");
            }
            return super.addChild(name);
        }

        @Override
        public TerminologyCapabilitiesCodeSystemVersionComponent copy() {
            TerminologyCapabilitiesCodeSystemVersionComponent dst = new TerminologyCapabilitiesCodeSystemVersionComponent();
            this.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.isDefault = this.isDefault == null ? null : this.isDefault.copy();
            BooleanType booleanType = dst.compositional = this.compositional == null ? null : this.compositional.copy();
            if (this.language != null) {
                dst.language = new ArrayList<CodeType>();
                for (CodeType codeType : this.language) {
                    dst.language.add(codeType.copy());
                }
            }
            if (this.filter != null) {
                dst.filter = new ArrayList<TerminologyCapabilitiesCodeSystemVersionFilterComponent>();
                for (TerminologyCapabilitiesCodeSystemVersionFilterComponent terminologyCapabilitiesCodeSystemVersionFilterComponent : this.filter) {
                    dst.filter.add(terminologyCapabilitiesCodeSystemVersionFilterComponent.copy());
                }
            }
            if (this.property != null) {
                dst.property = new ArrayList<CodeType>();
                for (CodeType codeType : this.property) {
                    dst.property.add(codeType.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TerminologyCapabilitiesCodeSystemVersionComponent)) {
                return false;
            }
            TerminologyCapabilitiesCodeSystemVersionComponent o = (TerminologyCapabilitiesCodeSystemVersionComponent)other_;
            return TerminologyCapabilitiesCodeSystemVersionComponent.compareDeep(this.code, o.code, true) && TerminologyCapabilitiesCodeSystemVersionComponent.compareDeep(this.isDefault, o.isDefault, true) && TerminologyCapabilitiesCodeSystemVersionComponent.compareDeep(this.compositional, o.compositional, true) && TerminologyCapabilitiesCodeSystemVersionComponent.compareDeep(this.language, o.language, true) && TerminologyCapabilitiesCodeSystemVersionComponent.compareDeep(this.filter, o.filter, true) && TerminologyCapabilitiesCodeSystemVersionComponent.compareDeep(this.property, o.property, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TerminologyCapabilitiesCodeSystemVersionComponent)) {
                return false;
            }
            TerminologyCapabilitiesCodeSystemVersionComponent o = (TerminologyCapabilitiesCodeSystemVersionComponent)other_;
            return TerminologyCapabilitiesCodeSystemVersionComponent.compareValues(this.code, o.code, true) && TerminologyCapabilitiesCodeSystemVersionComponent.compareValues(this.isDefault, o.isDefault, true) && TerminologyCapabilitiesCodeSystemVersionComponent.compareValues(this.compositional, o.compositional, true) && TerminologyCapabilitiesCodeSystemVersionComponent.compareValues(this.language, o.language, true) && TerminologyCapabilitiesCodeSystemVersionComponent.compareValues(this.property, o.property, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.code, this.isDefault, this.compositional, this.language, this.filter, this.property});
        }

        @Override
        public String fhirType() {
            return "TerminologyCapabilities.codeSystem.version";
        }
    }

    @Block
    public static class TerminologyCapabilitiesCodeSystemComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="uri", type={CanonicalType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="URI for the Code System", formalDefinition="URI for the Code System.")
        protected CanonicalType uri;
        @Child(name="version", type={}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Version of Code System supported", formalDefinition="For the code system, a list of versions that are supported by the server.")
        protected List<TerminologyCapabilitiesCodeSystemVersionComponent> version;
        private static final long serialVersionUID = 1023500432L;

        public CanonicalType getUriElement() {
            if (this.uri == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TerminologyCapabilitiesCodeSystemComponent.uri");
                }
                if (Configuration.doAutoCreate()) {
                    this.uri = new CanonicalType();
                }
            }
            return this.uri;
        }

        public boolean hasUriElement() {
            return this.uri != null && !this.uri.isEmpty();
        }

        public boolean hasUri() {
            return this.uri != null && !this.uri.isEmpty();
        }

        public TerminologyCapabilitiesCodeSystemComponent setUriElement(CanonicalType value) {
            this.uri = value;
            return this;
        }

        public String getUri() {
            return this.uri == null ? null : (String)this.uri.getValue();
        }

        public TerminologyCapabilitiesCodeSystemComponent setUri(String value) {
            if (Utilities.noString((String)value)) {
                this.uri = null;
            } else {
                if (this.uri == null) {
                    this.uri = new CanonicalType();
                }
                this.uri.setValue(value);
            }
            return this;
        }

        public List<TerminologyCapabilitiesCodeSystemVersionComponent> getVersion() {
            if (this.version == null) {
                this.version = new ArrayList<TerminologyCapabilitiesCodeSystemVersionComponent>();
            }
            return this.version;
        }

        public TerminologyCapabilitiesCodeSystemComponent setVersion(List<TerminologyCapabilitiesCodeSystemVersionComponent> theVersion) {
            this.version = theVersion;
            return this;
        }

        public boolean hasVersion() {
            if (this.version == null) {
                return false;
            }
            for (TerminologyCapabilitiesCodeSystemVersionComponent item : this.version) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public TerminologyCapabilitiesCodeSystemVersionComponent addVersion() {
            TerminologyCapabilitiesCodeSystemVersionComponent t = new TerminologyCapabilitiesCodeSystemVersionComponent();
            if (this.version == null) {
                this.version = new ArrayList<TerminologyCapabilitiesCodeSystemVersionComponent>();
            }
            this.version.add(t);
            return t;
        }

        public TerminologyCapabilitiesCodeSystemComponent addVersion(TerminologyCapabilitiesCodeSystemVersionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.version == null) {
                this.version = new ArrayList<TerminologyCapabilitiesCodeSystemVersionComponent>();
            }
            this.version.add(t);
            return this;
        }

        public TerminologyCapabilitiesCodeSystemVersionComponent getVersionFirstRep() {
            if (this.getVersion().isEmpty()) {
                this.addVersion();
            }
            return this.getVersion().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("uri", "canonical(CodeSystem)", "URI for the Code System.", 0, 1, this.uri));
            children.add(new Property(TerminologyCapabilities.SP_VERSION, "", "For the code system, a list of versions that are supported by the server.", 0, Integer.MAX_VALUE, this.version));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 116076: {
                    return new Property("uri", "canonical(CodeSystem)", "URI for the Code System.", 0, 1, this.uri);
                }
                case 351608024: {
                    return new Property(TerminologyCapabilities.SP_VERSION, "", "For the code system, a list of versions that are supported by the server.", 0, Integer.MAX_VALUE, this.version);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 116076: {
                    Base[] baseArray;
                    if (this.uri == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.uri;
                    }
                    return baseArray;
                }
                case 351608024: {
                    return this.version == null ? new Base[]{} : this.version.toArray(new Base[this.version.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 116076: {
                    this.uri = this.castToCanonical(value);
                    return value;
                }
                case 351608024: {
                    this.getVersion().add((TerminologyCapabilitiesCodeSystemVersionComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("uri")) {
                this.uri = this.castToCanonical(value);
            } else if (name.equals(TerminologyCapabilities.SP_VERSION)) {
                this.getVersion().add((TerminologyCapabilitiesCodeSystemVersionComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 116076: {
                    return this.getUriElement();
                }
                case 351608024: {
                    return this.addVersion();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 116076: {
                    return new String[]{"canonical"};
                }
                case 351608024: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("uri")) {
                throw new FHIRException("Cannot call addChild on a primitive type TerminologyCapabilities.uri");
            }
            if (name.equals(TerminologyCapabilities.SP_VERSION)) {
                return this.addVersion();
            }
            return super.addChild(name);
        }

        @Override
        public TerminologyCapabilitiesCodeSystemComponent copy() {
            TerminologyCapabilitiesCodeSystemComponent dst = new TerminologyCapabilitiesCodeSystemComponent();
            this.copyValues(dst);
            CanonicalType canonicalType = dst.uri = this.uri == null ? null : this.uri.copy();
            if (this.version != null) {
                dst.version = new ArrayList<TerminologyCapabilitiesCodeSystemVersionComponent>();
                for (TerminologyCapabilitiesCodeSystemVersionComponent i : this.version) {
                    dst.version.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TerminologyCapabilitiesCodeSystemComponent)) {
                return false;
            }
            TerminologyCapabilitiesCodeSystemComponent o = (TerminologyCapabilitiesCodeSystemComponent)other_;
            return TerminologyCapabilitiesCodeSystemComponent.compareDeep(this.uri, o.uri, true) && TerminologyCapabilitiesCodeSystemComponent.compareDeep(this.version, o.version, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TerminologyCapabilitiesCodeSystemComponent)) {
                return false;
            }
            TerminologyCapabilitiesCodeSystemComponent o = (TerminologyCapabilitiesCodeSystemComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.uri, this.version});
        }

        @Override
        public String fhirType() {
            return "TerminologyCapabilities.codeSystem";
        }
    }

    public static class CodeSearchSupportEnumFactory
    implements EnumFactory<CodeSearchSupport> {
        @Override
        public CodeSearchSupport fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("explicit".equals(codeString)) {
                return CodeSearchSupport.EXPLICIT;
            }
            if ("all".equals(codeString)) {
                return CodeSearchSupport.ALL;
            }
            throw new IllegalArgumentException("Unknown CodeSearchSupport code '" + codeString + "'");
        }

        public Enumeration<CodeSearchSupport> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<CodeSearchSupport>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("explicit".equals(codeString)) {
                return new Enumeration<CodeSearchSupport>(this, CodeSearchSupport.EXPLICIT);
            }
            if ("all".equals(codeString)) {
                return new Enumeration<CodeSearchSupport>(this, CodeSearchSupport.ALL);
            }
            throw new FHIRException("Unknown CodeSearchSupport code '" + codeString + "'");
        }

        @Override
        public String toCode(CodeSearchSupport code) {
            if (code == CodeSearchSupport.EXPLICIT) {
                return "explicit";
            }
            if (code == CodeSearchSupport.ALL) {
                return "all";
            }
            return "?";
        }

        @Override
        public String toSystem(CodeSearchSupport code) {
            return code.getSystem();
        }
    }

    public static enum CodeSearchSupport {
        EXPLICIT,
        ALL,
        NULL;


        public static CodeSearchSupport fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("explicit".equals(codeString)) {
                return EXPLICIT;
            }
            if ("all".equals(codeString)) {
                return ALL;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown CodeSearchSupport code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case EXPLICIT: {
                    return "explicit";
                }
                case ALL: {
                    return "all";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case EXPLICIT: {
                    return "http://hl7.org/fhir/code-search-support";
                }
                case ALL: {
                    return "http://hl7.org/fhir/code-search-support";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case EXPLICIT: {
                    return "The search for code on ValueSet only includes codes explicitly detailed on includes or expansions";
                }
                case ALL: {
                    return "The search for code on ValueSet only includes all codes based on the expansion of the value set";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case EXPLICIT: {
                    return "Explicit Codes";
                }
                case ALL: {
                    return "Implicit Codes";
                }
            }
            return "?";
        }
    }
}

