/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.Attachment;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DocumentReference;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.SubstancePolymer;
import org.hl7.fhir.r4.model.SubstanceReferenceInformation;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="SubstanceSpecification", profile="http://hl7.org/fhir/Profile/SubstanceSpecification")
public class SubstanceSpecification
extends DomainResource {
    @Child(name="comment", type={StringType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Textual comment", formalDefinition="Textual comment.")
    protected StringType comment;
    @Child(name="stoichiometric", type={BooleanType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Chemicals may be stoichiometric or non-stoichiometric", formalDefinition="Chemicals may be stoichiometric or non-stoichiometric.")
    protected BooleanType stoichiometric;
    @Child(name="identifier", type={Identifier.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Identifier by which this substance is known", formalDefinition="Identifier by which this substance is known.")
    protected Identifier identifier;
    @Child(name="type", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="High level categorization, e.g. polymer or nucleic acid", formalDefinition="High level categorization, e.g. polymer or nucleic acid.")
    protected CodeableConcept type;
    @Child(name="referenceSource", type={StringType.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Supporting literature", formalDefinition="Supporting literature.")
    protected List<StringType> referenceSource;
    @Child(name="moiety", type={}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Moiety, for structural modifications", formalDefinition="Moiety, for structural modifications.")
    protected List<SubstanceSpecificationMoietyComponent> moiety;
    @Child(name="property", type={}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="General specifications for this substance, including how it is related to other substances", formalDefinition="General specifications for this substance, including how it is related to other substances.")
    protected List<SubstanceSpecificationPropertyComponent> property;
    @Child(name="referenceInformation", type={SubstanceReferenceInformation.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="General information detailing this substance", formalDefinition="General information detailing this substance.")
    protected Reference referenceInformation;
    protected SubstanceReferenceInformation referenceInformationTarget;
    @Child(name="structure", type={}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Structural information", formalDefinition="Structural information.")
    protected SubstanceSpecificationStructureComponent structure;
    @Child(name="substanceCode", type={}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Codes associated with the substance", formalDefinition="Codes associated with the substance.")
    protected List<SubstanceSpecificationSubstanceCodeComponent> substanceCode;
    @Child(name="substanceName", type={}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Names applicable to this substence", formalDefinition="Names applicable to this substence.")
    protected List<SubstanceSpecificationSubstanceNameComponent> substanceName;
    @Child(name="molecularWeight", type={SubstanceSpecificationStructureIsotopeMolecularWeightComponent.class}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The molecular weight or weight range (for proteins, polymers or nucleic acids)", formalDefinition="The molecular weight or weight range (for proteins, polymers or nucleic acids).")
    protected List<SubstanceSpecificationStructureIsotopeMolecularWeightComponent> molecularWeight;
    @Child(name="polymer", type={SubstancePolymer.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Data items specific to polymers", formalDefinition="Data items specific to polymers.")
    protected Reference polymer;
    protected SubstancePolymer polymerTarget;
    private static final long serialVersionUID = -55630281L;

    public StringType getCommentElement() {
        if (this.comment == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceSpecification.comment");
            }
            if (Configuration.doAutoCreate()) {
                this.comment = new StringType();
            }
        }
        return this.comment;
    }

    public boolean hasCommentElement() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public boolean hasComment() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public SubstanceSpecification setCommentElement(StringType value) {
        this.comment = value;
        return this;
    }

    public String getComment() {
        return this.comment == null ? null : (String)this.comment.getValue();
    }

    public SubstanceSpecification setComment(String value) {
        if (Utilities.noString((String)value)) {
            this.comment = null;
        } else {
            if (this.comment == null) {
                this.comment = new StringType();
            }
            this.comment.setValue(value);
        }
        return this;
    }

    public BooleanType getStoichiometricElement() {
        if (this.stoichiometric == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceSpecification.stoichiometric");
            }
            if (Configuration.doAutoCreate()) {
                this.stoichiometric = new BooleanType();
            }
        }
        return this.stoichiometric;
    }

    public boolean hasStoichiometricElement() {
        return this.stoichiometric != null && !this.stoichiometric.isEmpty();
    }

    public boolean hasStoichiometric() {
        return this.stoichiometric != null && !this.stoichiometric.isEmpty();
    }

    public SubstanceSpecification setStoichiometricElement(BooleanType value) {
        this.stoichiometric = value;
        return this;
    }

    public boolean getStoichiometric() {
        return this.stoichiometric == null || this.stoichiometric.isEmpty() ? false : (Boolean)this.stoichiometric.getValue();
    }

    public SubstanceSpecification setStoichiometric(boolean value) {
        if (this.stoichiometric == null) {
            this.stoichiometric = new BooleanType();
        }
        this.stoichiometric.setValue((Object)value);
        return this;
    }

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceSpecification.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public SubstanceSpecification setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceSpecification.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public SubstanceSpecification setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public List<StringType> getReferenceSource() {
        if (this.referenceSource == null) {
            this.referenceSource = new ArrayList<StringType>();
        }
        return this.referenceSource;
    }

    public SubstanceSpecification setReferenceSource(List<StringType> theReferenceSource) {
        this.referenceSource = theReferenceSource;
        return this;
    }

    public boolean hasReferenceSource() {
        if (this.referenceSource == null) {
            return false;
        }
        for (StringType item : this.referenceSource) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addReferenceSourceElement() {
        StringType t = new StringType();
        if (this.referenceSource == null) {
            this.referenceSource = new ArrayList<StringType>();
        }
        this.referenceSource.add(t);
        return t;
    }

    public SubstanceSpecification addReferenceSource(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.referenceSource == null) {
            this.referenceSource = new ArrayList<StringType>();
        }
        this.referenceSource.add(t);
        return this;
    }

    public boolean hasReferenceSource(String value) {
        if (this.referenceSource == null) {
            return false;
        }
        for (StringType v : this.referenceSource) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<SubstanceSpecificationMoietyComponent> getMoiety() {
        if (this.moiety == null) {
            this.moiety = new ArrayList<SubstanceSpecificationMoietyComponent>();
        }
        return this.moiety;
    }

    public SubstanceSpecification setMoiety(List<SubstanceSpecificationMoietyComponent> theMoiety) {
        this.moiety = theMoiety;
        return this;
    }

    public boolean hasMoiety() {
        if (this.moiety == null) {
            return false;
        }
        for (SubstanceSpecificationMoietyComponent item : this.moiety) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SubstanceSpecificationMoietyComponent addMoiety() {
        SubstanceSpecificationMoietyComponent t = new SubstanceSpecificationMoietyComponent();
        if (this.moiety == null) {
            this.moiety = new ArrayList<SubstanceSpecificationMoietyComponent>();
        }
        this.moiety.add(t);
        return t;
    }

    public SubstanceSpecification addMoiety(SubstanceSpecificationMoietyComponent t) {
        if (t == null) {
            return this;
        }
        if (this.moiety == null) {
            this.moiety = new ArrayList<SubstanceSpecificationMoietyComponent>();
        }
        this.moiety.add(t);
        return this;
    }

    public SubstanceSpecificationMoietyComponent getMoietyFirstRep() {
        if (this.getMoiety().isEmpty()) {
            this.addMoiety();
        }
        return this.getMoiety().get(0);
    }

    public List<SubstanceSpecificationPropertyComponent> getProperty() {
        if (this.property == null) {
            this.property = new ArrayList<SubstanceSpecificationPropertyComponent>();
        }
        return this.property;
    }

    public SubstanceSpecification setProperty(List<SubstanceSpecificationPropertyComponent> theProperty) {
        this.property = theProperty;
        return this;
    }

    public boolean hasProperty() {
        if (this.property == null) {
            return false;
        }
        for (SubstanceSpecificationPropertyComponent item : this.property) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SubstanceSpecificationPropertyComponent addProperty() {
        SubstanceSpecificationPropertyComponent t = new SubstanceSpecificationPropertyComponent();
        if (this.property == null) {
            this.property = new ArrayList<SubstanceSpecificationPropertyComponent>();
        }
        this.property.add(t);
        return t;
    }

    public SubstanceSpecification addProperty(SubstanceSpecificationPropertyComponent t) {
        if (t == null) {
            return this;
        }
        if (this.property == null) {
            this.property = new ArrayList<SubstanceSpecificationPropertyComponent>();
        }
        this.property.add(t);
        return this;
    }

    public SubstanceSpecificationPropertyComponent getPropertyFirstRep() {
        if (this.getProperty().isEmpty()) {
            this.addProperty();
        }
        return this.getProperty().get(0);
    }

    public Reference getReferenceInformation() {
        if (this.referenceInformation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceSpecification.referenceInformation");
            }
            if (Configuration.doAutoCreate()) {
                this.referenceInformation = new Reference();
            }
        }
        return this.referenceInformation;
    }

    public boolean hasReferenceInformation() {
        return this.referenceInformation != null && !this.referenceInformation.isEmpty();
    }

    public SubstanceSpecification setReferenceInformation(Reference value) {
        this.referenceInformation = value;
        return this;
    }

    public SubstanceReferenceInformation getReferenceInformationTarget() {
        if (this.referenceInformationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceSpecification.referenceInformation");
            }
            if (Configuration.doAutoCreate()) {
                this.referenceInformationTarget = new SubstanceReferenceInformation();
            }
        }
        return this.referenceInformationTarget;
    }

    public SubstanceSpecification setReferenceInformationTarget(SubstanceReferenceInformation value) {
        this.referenceInformationTarget = value;
        return this;
    }

    public SubstanceSpecificationStructureComponent getStructure() {
        if (this.structure == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceSpecification.structure");
            }
            if (Configuration.doAutoCreate()) {
                this.structure = new SubstanceSpecificationStructureComponent();
            }
        }
        return this.structure;
    }

    public boolean hasStructure() {
        return this.structure != null && !this.structure.isEmpty();
    }

    public SubstanceSpecification setStructure(SubstanceSpecificationStructureComponent value) {
        this.structure = value;
        return this;
    }

    public List<SubstanceSpecificationSubstanceCodeComponent> getSubstanceCode() {
        if (this.substanceCode == null) {
            this.substanceCode = new ArrayList<SubstanceSpecificationSubstanceCodeComponent>();
        }
        return this.substanceCode;
    }

    public SubstanceSpecification setSubstanceCode(List<SubstanceSpecificationSubstanceCodeComponent> theSubstanceCode) {
        this.substanceCode = theSubstanceCode;
        return this;
    }

    public boolean hasSubstanceCode() {
        if (this.substanceCode == null) {
            return false;
        }
        for (SubstanceSpecificationSubstanceCodeComponent item : this.substanceCode) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SubstanceSpecificationSubstanceCodeComponent addSubstanceCode() {
        SubstanceSpecificationSubstanceCodeComponent t = new SubstanceSpecificationSubstanceCodeComponent();
        if (this.substanceCode == null) {
            this.substanceCode = new ArrayList<SubstanceSpecificationSubstanceCodeComponent>();
        }
        this.substanceCode.add(t);
        return t;
    }

    public SubstanceSpecification addSubstanceCode(SubstanceSpecificationSubstanceCodeComponent t) {
        if (t == null) {
            return this;
        }
        if (this.substanceCode == null) {
            this.substanceCode = new ArrayList<SubstanceSpecificationSubstanceCodeComponent>();
        }
        this.substanceCode.add(t);
        return this;
    }

    public SubstanceSpecificationSubstanceCodeComponent getSubstanceCodeFirstRep() {
        if (this.getSubstanceCode().isEmpty()) {
            this.addSubstanceCode();
        }
        return this.getSubstanceCode().get(0);
    }

    public List<SubstanceSpecificationSubstanceNameComponent> getSubstanceName() {
        if (this.substanceName == null) {
            this.substanceName = new ArrayList<SubstanceSpecificationSubstanceNameComponent>();
        }
        return this.substanceName;
    }

    public SubstanceSpecification setSubstanceName(List<SubstanceSpecificationSubstanceNameComponent> theSubstanceName) {
        this.substanceName = theSubstanceName;
        return this;
    }

    public boolean hasSubstanceName() {
        if (this.substanceName == null) {
            return false;
        }
        for (SubstanceSpecificationSubstanceNameComponent item : this.substanceName) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SubstanceSpecificationSubstanceNameComponent addSubstanceName() {
        SubstanceSpecificationSubstanceNameComponent t = new SubstanceSpecificationSubstanceNameComponent();
        if (this.substanceName == null) {
            this.substanceName = new ArrayList<SubstanceSpecificationSubstanceNameComponent>();
        }
        this.substanceName.add(t);
        return t;
    }

    public SubstanceSpecification addSubstanceName(SubstanceSpecificationSubstanceNameComponent t) {
        if (t == null) {
            return this;
        }
        if (this.substanceName == null) {
            this.substanceName = new ArrayList<SubstanceSpecificationSubstanceNameComponent>();
        }
        this.substanceName.add(t);
        return this;
    }

    public SubstanceSpecificationSubstanceNameComponent getSubstanceNameFirstRep() {
        if (this.getSubstanceName().isEmpty()) {
            this.addSubstanceName();
        }
        return this.getSubstanceName().get(0);
    }

    public List<SubstanceSpecificationStructureIsotopeMolecularWeightComponent> getMolecularWeight() {
        if (this.molecularWeight == null) {
            this.molecularWeight = new ArrayList<SubstanceSpecificationStructureIsotopeMolecularWeightComponent>();
        }
        return this.molecularWeight;
    }

    public SubstanceSpecification setMolecularWeight(List<SubstanceSpecificationStructureIsotopeMolecularWeightComponent> theMolecularWeight) {
        this.molecularWeight = theMolecularWeight;
        return this;
    }

    public boolean hasMolecularWeight() {
        if (this.molecularWeight == null) {
            return false;
        }
        for (SubstanceSpecificationStructureIsotopeMolecularWeightComponent item : this.molecularWeight) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SubstanceSpecificationStructureIsotopeMolecularWeightComponent addMolecularWeight() {
        SubstanceSpecificationStructureIsotopeMolecularWeightComponent t = new SubstanceSpecificationStructureIsotopeMolecularWeightComponent();
        if (this.molecularWeight == null) {
            this.molecularWeight = new ArrayList<SubstanceSpecificationStructureIsotopeMolecularWeightComponent>();
        }
        this.molecularWeight.add(t);
        return t;
    }

    public SubstanceSpecification addMolecularWeight(SubstanceSpecificationStructureIsotopeMolecularWeightComponent t) {
        if (t == null) {
            return this;
        }
        if (this.molecularWeight == null) {
            this.molecularWeight = new ArrayList<SubstanceSpecificationStructureIsotopeMolecularWeightComponent>();
        }
        this.molecularWeight.add(t);
        return this;
    }

    public SubstanceSpecificationStructureIsotopeMolecularWeightComponent getMolecularWeightFirstRep() {
        if (this.getMolecularWeight().isEmpty()) {
            this.addMolecularWeight();
        }
        return this.getMolecularWeight().get(0);
    }

    public Reference getPolymer() {
        if (this.polymer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceSpecification.polymer");
            }
            if (Configuration.doAutoCreate()) {
                this.polymer = new Reference();
            }
        }
        return this.polymer;
    }

    public boolean hasPolymer() {
        return this.polymer != null && !this.polymer.isEmpty();
    }

    public SubstanceSpecification setPolymer(Reference value) {
        this.polymer = value;
        return this;
    }

    public SubstancePolymer getPolymerTarget() {
        if (this.polymerTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SubstanceSpecification.polymer");
            }
            if (Configuration.doAutoCreate()) {
                this.polymerTarget = new SubstancePolymer();
            }
        }
        return this.polymerTarget;
    }

    public SubstanceSpecification setPolymerTarget(SubstancePolymer value) {
        this.polymerTarget = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("comment", "string", "Textual comment.", 0, 1, this.comment));
        children.add(new Property("stoichiometric", "boolean", "Chemicals may be stoichiometric or non-stoichiometric.", 0, 1, this.stoichiometric));
        children.add(new Property("identifier", "Identifier", "Identifier by which this substance is known.", 0, 1, this.identifier));
        children.add(new Property("type", "CodeableConcept", "High level categorization, e.g. polymer or nucleic acid.", 0, 1, this.type));
        children.add(new Property("referenceSource", "string", "Supporting literature.", 0, Integer.MAX_VALUE, this.referenceSource));
        children.add(new Property("moiety", "", "Moiety, for structural modifications.", 0, Integer.MAX_VALUE, this.moiety));
        children.add(new Property("property", "", "General specifications for this substance, including how it is related to other substances.", 0, Integer.MAX_VALUE, this.property));
        children.add(new Property("referenceInformation", "Reference(SubstanceReferenceInformation)", "General information detailing this substance.", 0, 1, this.referenceInformation));
        children.add(new Property("structure", "", "Structural information.", 0, 1, this.structure));
        children.add(new Property("substanceCode", "", "Codes associated with the substance.", 0, Integer.MAX_VALUE, this.substanceCode));
        children.add(new Property("substanceName", "", "Names applicable to this substence.", 0, Integer.MAX_VALUE, this.substanceName));
        children.add(new Property("molecularWeight", "@SubstanceSpecification.structure.isotope.molecularWeight", "The molecular weight or weight range (for proteins, polymers or nucleic acids).", 0, Integer.MAX_VALUE, this.molecularWeight));
        children.add(new Property("polymer", "Reference(SubstancePolymer)", "Data items specific to polymers.", 0, 1, this.polymer));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 950398559: {
                return new Property("comment", "string", "Textual comment.", 0, 1, this.comment);
            }
            case -251826186: {
                return new Property("stoichiometric", "boolean", "Chemicals may be stoichiometric or non-stoichiometric.", 0, 1, this.stoichiometric);
            }
            case -1618432855: {
                return new Property("identifier", "Identifier", "Identifier by which this substance is known.", 0, 1, this.identifier);
            }
            case 3575610: {
                return new Property("type", "CodeableConcept", "High level categorization, e.g. polymer or nucleic acid.", 0, 1, this.type);
            }
            case 882421574: {
                return new Property("referenceSource", "string", "Supporting literature.", 0, Integer.MAX_VALUE, this.referenceSource);
            }
            case -1068650173: {
                return new Property("moiety", "", "Moiety, for structural modifications.", 0, Integer.MAX_VALUE, this.moiety);
            }
            case -993141291: {
                return new Property("property", "", "General specifications for this substance, including how it is related to other substances.", 0, Integer.MAX_VALUE, this.property);
            }
            case -2117930783: {
                return new Property("referenceInformation", "Reference(SubstanceReferenceInformation)", "General information detailing this substance.", 0, 1, this.referenceInformation);
            }
            case 144518515: {
                return new Property("structure", "", "Structural information.", 0, 1, this.structure);
            }
            case 1517793149: {
                return new Property("substanceCode", "", "Codes associated with the substance.", 0, Integer.MAX_VALUE, this.substanceCode);
            }
            case 1518107675: {
                return new Property("substanceName", "", "Names applicable to this substence.", 0, Integer.MAX_VALUE, this.substanceName);
            }
            case 635625672: {
                return new Property("molecularWeight", "@SubstanceSpecification.structure.isotope.molecularWeight", "The molecular weight or weight range (for proteins, polymers or nucleic acids).", 0, Integer.MAX_VALUE, this.molecularWeight);
            }
            case -397514098: {
                return new Property("polymer", "Reference(SubstancePolymer)", "Data items specific to polymers.", 0, 1, this.polymer);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 950398559: {
                Base[] baseArray;
                if (this.comment == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.comment;
                }
                return baseArray;
            }
            case -251826186: {
                Base[] baseArray;
                if (this.stoichiometric == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.stoichiometric;
                }
                return baseArray;
            }
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.identifier;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.type;
                }
                return baseArray;
            }
            case 882421574: {
                return this.referenceSource == null ? new Base[]{} : this.referenceSource.toArray(new Base[this.referenceSource.size()]);
            }
            case -1068650173: {
                return this.moiety == null ? new Base[]{} : this.moiety.toArray(new Base[this.moiety.size()]);
            }
            case -993141291: {
                return this.property == null ? new Base[]{} : this.property.toArray(new Base[this.property.size()]);
            }
            case -2117930783: {
                Base[] baseArray;
                if (this.referenceInformation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.referenceInformation;
                }
                return baseArray;
            }
            case 144518515: {
                Base[] baseArray;
                if (this.structure == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.structure;
                }
                return baseArray;
            }
            case 1517793149: {
                return this.substanceCode == null ? new Base[]{} : this.substanceCode.toArray(new Base[this.substanceCode.size()]);
            }
            case 1518107675: {
                return this.substanceName == null ? new Base[]{} : this.substanceName.toArray(new Base[this.substanceName.size()]);
            }
            case 635625672: {
                return this.molecularWeight == null ? new Base[]{} : this.molecularWeight.toArray(new Base[this.molecularWeight.size()]);
            }
            case -397514098: {
                Base[] baseArray;
                if (this.polymer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.polymer;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 950398559: {
                this.comment = this.castToString(value);
                return value;
            }
            case -251826186: {
                this.stoichiometric = this.castToBoolean(value);
                return value;
            }
            case -1618432855: {
                this.identifier = this.castToIdentifier(value);
                return value;
            }
            case 3575610: {
                this.type = this.castToCodeableConcept(value);
                return value;
            }
            case 882421574: {
                this.getReferenceSource().add(this.castToString(value));
                return value;
            }
            case -1068650173: {
                this.getMoiety().add((SubstanceSpecificationMoietyComponent)value);
                return value;
            }
            case -993141291: {
                this.getProperty().add((SubstanceSpecificationPropertyComponent)value);
                return value;
            }
            case -2117930783: {
                this.referenceInformation = this.castToReference(value);
                return value;
            }
            case 144518515: {
                this.structure = (SubstanceSpecificationStructureComponent)value;
                return value;
            }
            case 1517793149: {
                this.getSubstanceCode().add((SubstanceSpecificationSubstanceCodeComponent)value);
                return value;
            }
            case 1518107675: {
                this.getSubstanceName().add((SubstanceSpecificationSubstanceNameComponent)value);
                return value;
            }
            case 635625672: {
                this.getMolecularWeight().add((SubstanceSpecificationStructureIsotopeMolecularWeightComponent)value);
                return value;
            }
            case -397514098: {
                this.polymer = this.castToReference(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("comment")) {
            this.comment = this.castToString(value);
        } else if (name.equals("stoichiometric")) {
            this.stoichiometric = this.castToBoolean(value);
        } else if (name.equals("identifier")) {
            this.identifier = this.castToIdentifier(value);
        } else if (name.equals("type")) {
            this.type = this.castToCodeableConcept(value);
        } else if (name.equals("referenceSource")) {
            this.getReferenceSource().add(this.castToString(value));
        } else if (name.equals("moiety")) {
            this.getMoiety().add((SubstanceSpecificationMoietyComponent)value);
        } else if (name.equals("property")) {
            this.getProperty().add((SubstanceSpecificationPropertyComponent)value);
        } else if (name.equals("referenceInformation")) {
            this.referenceInformation = this.castToReference(value);
        } else if (name.equals("structure")) {
            this.structure = (SubstanceSpecificationStructureComponent)value;
        } else if (name.equals("substanceCode")) {
            this.getSubstanceCode().add((SubstanceSpecificationSubstanceCodeComponent)value);
        } else if (name.equals("substanceName")) {
            this.getSubstanceName().add((SubstanceSpecificationSubstanceNameComponent)value);
        } else if (name.equals("molecularWeight")) {
            this.getMolecularWeight().add((SubstanceSpecificationStructureIsotopeMolecularWeightComponent)value);
        } else if (name.equals("polymer")) {
            this.polymer = this.castToReference(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 950398559: {
                return this.getCommentElement();
            }
            case -251826186: {
                return this.getStoichiometricElement();
            }
            case -1618432855: {
                return this.getIdentifier();
            }
            case 3575610: {
                return this.getType();
            }
            case 882421574: {
                return this.addReferenceSourceElement();
            }
            case -1068650173: {
                return this.addMoiety();
            }
            case -993141291: {
                return this.addProperty();
            }
            case -2117930783: {
                return this.getReferenceInformation();
            }
            case 144518515: {
                return this.getStructure();
            }
            case 1517793149: {
                return this.addSubstanceCode();
            }
            case 1518107675: {
                return this.addSubstanceName();
            }
            case 635625672: {
                return this.addMolecularWeight();
            }
            case -397514098: {
                return this.getPolymer();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 950398559: {
                return new String[]{"string"};
            }
            case -251826186: {
                return new String[]{"boolean"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case 882421574: {
                return new String[]{"string"};
            }
            case -1068650173: {
                return new String[0];
            }
            case -993141291: {
                return new String[0];
            }
            case -2117930783: {
                return new String[]{"Reference"};
            }
            case 144518515: {
                return new String[0];
            }
            case 1517793149: {
                return new String[0];
            }
            case 1518107675: {
                return new String[0];
            }
            case 635625672: {
                return new String[]{"@SubstanceSpecification.structure.isotope.molecularWeight"};
            }
            case -397514098: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("comment")) {
            throw new FHIRException("Cannot call addChild on a primitive type SubstanceSpecification.comment");
        }
        if (name.equals("stoichiometric")) {
            throw new FHIRException("Cannot call addChild on a primitive type SubstanceSpecification.stoichiometric");
        }
        if (name.equals("identifier")) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals("type")) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals("referenceSource")) {
            throw new FHIRException("Cannot call addChild on a primitive type SubstanceSpecification.referenceSource");
        }
        if (name.equals("moiety")) {
            return this.addMoiety();
        }
        if (name.equals("property")) {
            return this.addProperty();
        }
        if (name.equals("referenceInformation")) {
            this.referenceInformation = new Reference();
            return this.referenceInformation;
        }
        if (name.equals("structure")) {
            this.structure = new SubstanceSpecificationStructureComponent();
            return this.structure;
        }
        if (name.equals("substanceCode")) {
            return this.addSubstanceCode();
        }
        if (name.equals("substanceName")) {
            return this.addSubstanceName();
        }
        if (name.equals("molecularWeight")) {
            return this.addMolecularWeight();
        }
        if (name.equals("polymer")) {
            this.polymer = new Reference();
            return this.polymer;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "SubstanceSpecification";
    }

    @Override
    public SubstanceSpecification copy() {
        SubstanceSpecification dst = new SubstanceSpecification();
        this.copyValues(dst);
        dst.comment = this.comment == null ? null : this.comment.copy();
        dst.stoichiometric = this.stoichiometric == null ? null : this.stoichiometric.copy();
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
        if (this.referenceSource != null) {
            dst.referenceSource = new ArrayList<StringType>();
            for (StringType stringType : this.referenceSource) {
                dst.referenceSource.add(stringType.copy());
            }
        }
        if (this.moiety != null) {
            dst.moiety = new ArrayList<SubstanceSpecificationMoietyComponent>();
            for (SubstanceSpecificationMoietyComponent substanceSpecificationMoietyComponent : this.moiety) {
                dst.moiety.add(substanceSpecificationMoietyComponent.copy());
            }
        }
        if (this.property != null) {
            dst.property = new ArrayList<SubstanceSpecificationPropertyComponent>();
            for (SubstanceSpecificationPropertyComponent substanceSpecificationPropertyComponent : this.property) {
                dst.property.add(substanceSpecificationPropertyComponent.copy());
            }
        }
        dst.referenceInformation = this.referenceInformation == null ? null : this.referenceInformation.copy();
        SubstanceSpecificationStructureComponent substanceSpecificationStructureComponent = dst.structure = this.structure == null ? null : this.structure.copy();
        if (this.substanceCode != null) {
            dst.substanceCode = new ArrayList<SubstanceSpecificationSubstanceCodeComponent>();
            for (SubstanceSpecificationSubstanceCodeComponent substanceSpecificationSubstanceCodeComponent : this.substanceCode) {
                dst.substanceCode.add(substanceSpecificationSubstanceCodeComponent.copy());
            }
        }
        if (this.substanceName != null) {
            dst.substanceName = new ArrayList<SubstanceSpecificationSubstanceNameComponent>();
            for (SubstanceSpecificationSubstanceNameComponent substanceSpecificationSubstanceNameComponent : this.substanceName) {
                dst.substanceName.add(substanceSpecificationSubstanceNameComponent.copy());
            }
        }
        if (this.molecularWeight != null) {
            dst.molecularWeight = new ArrayList<SubstanceSpecificationStructureIsotopeMolecularWeightComponent>();
            for (SubstanceSpecificationStructureIsotopeMolecularWeightComponent substanceSpecificationStructureIsotopeMolecularWeightComponent : this.molecularWeight) {
                dst.molecularWeight.add(substanceSpecificationStructureIsotopeMolecularWeightComponent.copy());
            }
        }
        dst.polymer = this.polymer == null ? null : this.polymer.copy();
        return dst;
    }

    protected SubstanceSpecification typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof SubstanceSpecification)) {
            return false;
        }
        SubstanceSpecification o = (SubstanceSpecification)other_;
        return SubstanceSpecification.compareDeep(this.comment, o.comment, true) && SubstanceSpecification.compareDeep(this.stoichiometric, o.stoichiometric, true) && SubstanceSpecification.compareDeep(this.identifier, o.identifier, true) && SubstanceSpecification.compareDeep(this.type, o.type, true) && SubstanceSpecification.compareDeep(this.referenceSource, o.referenceSource, true) && SubstanceSpecification.compareDeep(this.moiety, o.moiety, true) && SubstanceSpecification.compareDeep(this.property, o.property, true) && SubstanceSpecification.compareDeep(this.referenceInformation, o.referenceInformation, true) && SubstanceSpecification.compareDeep(this.structure, o.structure, true) && SubstanceSpecification.compareDeep(this.substanceCode, o.substanceCode, true) && SubstanceSpecification.compareDeep(this.substanceName, o.substanceName, true) && SubstanceSpecification.compareDeep(this.molecularWeight, o.molecularWeight, true) && SubstanceSpecification.compareDeep(this.polymer, o.polymer, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof SubstanceSpecification)) {
            return false;
        }
        SubstanceSpecification o = (SubstanceSpecification)other_;
        return SubstanceSpecification.compareValues(this.comment, o.comment, true) && SubstanceSpecification.compareValues(this.stoichiometric, o.stoichiometric, true) && SubstanceSpecification.compareValues(this.referenceSource, o.referenceSource, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.comment, this.stoichiometric, this.identifier, this.type, this.referenceSource, this.moiety, this.property, this.referenceInformation, this.structure, this.substanceCode, this.substanceName, this.molecularWeight, this.polymer});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.SubstanceSpecification;
    }

    @Block
    public static class SubstanceSpecificationSubstanceNameOfficialNameComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="authority", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Which authority uses this official name", formalDefinition="Which authority uses this official name.")
        protected CodeableConcept authority;
        @Child(name="status", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The status of the official name", formalDefinition="The status of the official name.")
        protected CodeableConcept status;
        @Child(name="date", type={DateTimeType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Date of official name change", formalDefinition="Date of official name change.")
        protected DateTimeType date;
        private static final long serialVersionUID = -2040011008L;

        public CodeableConcept getAuthority() {
            if (this.authority == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationSubstanceNameOfficialNameComponent.authority");
                }
                if (Configuration.doAutoCreate()) {
                    this.authority = new CodeableConcept();
                }
            }
            return this.authority;
        }

        public boolean hasAuthority() {
            return this.authority != null && !this.authority.isEmpty();
        }

        public SubstanceSpecificationSubstanceNameOfficialNameComponent setAuthority(CodeableConcept value) {
            this.authority = value;
            return this;
        }

        public CodeableConcept getStatus() {
            if (this.status == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationSubstanceNameOfficialNameComponent.status");
                }
                if (Configuration.doAutoCreate()) {
                    this.status = new CodeableConcept();
                }
            }
            return this.status;
        }

        public boolean hasStatus() {
            return this.status != null && !this.status.isEmpty();
        }

        public SubstanceSpecificationSubstanceNameOfficialNameComponent setStatus(CodeableConcept value) {
            this.status = value;
            return this;
        }

        public DateTimeType getDateElement() {
            if (this.date == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationSubstanceNameOfficialNameComponent.date");
                }
                if (Configuration.doAutoCreate()) {
                    this.date = new DateTimeType();
                }
            }
            return this.date;
        }

        public boolean hasDateElement() {
            return this.date != null && !this.date.isEmpty();
        }

        public boolean hasDate() {
            return this.date != null && !this.date.isEmpty();
        }

        public SubstanceSpecificationSubstanceNameOfficialNameComponent setDateElement(DateTimeType value) {
            this.date = value;
            return this;
        }

        public Date getDate() {
            return this.date == null ? null : (Date)this.date.getValue();
        }

        public SubstanceSpecificationSubstanceNameOfficialNameComponent setDate(Date value) {
            if (value == null) {
                this.date = null;
            } else {
                if (this.date == null) {
                    this.date = new DateTimeType();
                }
                this.date.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("authority", "CodeableConcept", "Which authority uses this official name.", 0, 1, this.authority));
            children.add(new Property("status", "CodeableConcept", "The status of the official name.", 0, 1, this.status));
            children.add(new Property("date", "dateTime", "Date of official name change.", 0, 1, this.date));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1475610435: {
                    return new Property("authority", "CodeableConcept", "Which authority uses this official name.", 0, 1, this.authority);
                }
                case -892481550: {
                    return new Property("status", "CodeableConcept", "The status of the official name.", 0, 1, this.status);
                }
                case 3076014: {
                    return new Property("date", "dateTime", "Date of official name change.", 0, 1, this.date);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1475610435: {
                    Base[] baseArray;
                    if (this.authority == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.authority;
                    }
                    return baseArray;
                }
                case -892481550: {
                    Base[] baseArray;
                    if (this.status == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.status;
                    }
                    return baseArray;
                }
                case 3076014: {
                    Base[] baseArray;
                    if (this.date == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.date;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1475610435: {
                    this.authority = this.castToCodeableConcept(value);
                    return value;
                }
                case -892481550: {
                    this.status = this.castToCodeableConcept(value);
                    return value;
                }
                case 3076014: {
                    this.date = this.castToDateTime(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("authority")) {
                this.authority = this.castToCodeableConcept(value);
            } else if (name.equals("status")) {
                this.status = this.castToCodeableConcept(value);
            } else if (name.equals("date")) {
                this.date = this.castToDateTime(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1475610435: {
                    return this.getAuthority();
                }
                case -892481550: {
                    return this.getStatus();
                }
                case 3076014: {
                    return this.getDateElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1475610435: {
                    return new String[]{"CodeableConcept"};
                }
                case -892481550: {
                    return new String[]{"CodeableConcept"};
                }
                case 3076014: {
                    return new String[]{"dateTime"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("authority")) {
                this.authority = new CodeableConcept();
                return this.authority;
            }
            if (name.equals("status")) {
                this.status = new CodeableConcept();
                return this.status;
            }
            if (name.equals("date")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceSpecification.date");
            }
            return super.addChild(name);
        }

        @Override
        public SubstanceSpecificationSubstanceNameOfficialNameComponent copy() {
            SubstanceSpecificationSubstanceNameOfficialNameComponent dst = new SubstanceSpecificationSubstanceNameOfficialNameComponent();
            this.copyValues(dst);
            dst.authority = this.authority == null ? null : this.authority.copy();
            dst.status = this.status == null ? null : this.status.copy();
            dst.date = this.date == null ? null : this.date.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSpecificationSubstanceNameOfficialNameComponent)) {
                return false;
            }
            SubstanceSpecificationSubstanceNameOfficialNameComponent o = (SubstanceSpecificationSubstanceNameOfficialNameComponent)other_;
            return SubstanceSpecificationSubstanceNameOfficialNameComponent.compareDeep(this.authority, o.authority, true) && SubstanceSpecificationSubstanceNameOfficialNameComponent.compareDeep(this.status, o.status, true) && SubstanceSpecificationSubstanceNameOfficialNameComponent.compareDeep(this.date, o.date, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSpecificationSubstanceNameOfficialNameComponent)) {
                return false;
            }
            SubstanceSpecificationSubstanceNameOfficialNameComponent o = (SubstanceSpecificationSubstanceNameOfficialNameComponent)other_;
            return SubstanceSpecificationSubstanceNameOfficialNameComponent.compareValues(this.date, o.date, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.authority, this.status, this.date});
        }

        @Override
        public String fhirType() {
            return "SubstanceSpecification.substanceName.officialName";
        }
    }

    @Block
    public static class SubstanceSpecificationSubstanceNameComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The actual name", formalDefinition="The actual name.")
        protected StringType name;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Name type", formalDefinition="Name type.")
        protected CodeableConcept type;
        @Child(name="language", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Language of the name", formalDefinition="Language of the name.")
        protected List<CodeableConcept> language;
        @Child(name="domain", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The use context of this name for example if there is a different name a drug active ingredient as opposed to a food colour additive", formalDefinition="The use context of this name for example if there is a different name a drug active ingredient as opposed to a food colour additive.")
        protected List<CodeableConcept> domain;
        @Child(name="jurisdiction", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The jurisdiction where this name applies", formalDefinition="The jurisdiction where this name applies.")
        protected List<CodeableConcept> jurisdiction;
        @Child(name="officialName", type={}, order=6, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Details of the official nature of this name", formalDefinition="Details of the official nature of this name.")
        protected List<SubstanceSpecificationSubstanceNameOfficialNameComponent> officialName;
        @Child(name="referenceSource", type={StringType.class}, order=7, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Supporting literature", formalDefinition="Supporting literature.")
        protected List<StringType> referenceSource;
        private static final long serialVersionUID = -1690760755L;

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationSubstanceNameComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public SubstanceSpecificationSubstanceNameComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public SubstanceSpecificationSubstanceNameComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationSubstanceNameComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public SubstanceSpecificationSubstanceNameComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public List<CodeableConcept> getLanguage() {
            if (this.language == null) {
                this.language = new ArrayList<CodeableConcept>();
            }
            return this.language;
        }

        public SubstanceSpecificationSubstanceNameComponent setLanguage(List<CodeableConcept> theLanguage) {
            this.language = theLanguage;
            return this;
        }

        public boolean hasLanguage() {
            if (this.language == null) {
                return false;
            }
            for (CodeableConcept item : this.language) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addLanguage() {
            CodeableConcept t = new CodeableConcept();
            if (this.language == null) {
                this.language = new ArrayList<CodeableConcept>();
            }
            this.language.add(t);
            return t;
        }

        public SubstanceSpecificationSubstanceNameComponent addLanguage(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.language == null) {
                this.language = new ArrayList<CodeableConcept>();
            }
            this.language.add(t);
            return this;
        }

        public CodeableConcept getLanguageFirstRep() {
            if (this.getLanguage().isEmpty()) {
                this.addLanguage();
            }
            return this.getLanguage().get(0);
        }

        public List<CodeableConcept> getDomain() {
            if (this.domain == null) {
                this.domain = new ArrayList<CodeableConcept>();
            }
            return this.domain;
        }

        public SubstanceSpecificationSubstanceNameComponent setDomain(List<CodeableConcept> theDomain) {
            this.domain = theDomain;
            return this;
        }

        public boolean hasDomain() {
            if (this.domain == null) {
                return false;
            }
            for (CodeableConcept item : this.domain) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addDomain() {
            CodeableConcept t = new CodeableConcept();
            if (this.domain == null) {
                this.domain = new ArrayList<CodeableConcept>();
            }
            this.domain.add(t);
            return t;
        }

        public SubstanceSpecificationSubstanceNameComponent addDomain(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.domain == null) {
                this.domain = new ArrayList<CodeableConcept>();
            }
            this.domain.add(t);
            return this;
        }

        public CodeableConcept getDomainFirstRep() {
            if (this.getDomain().isEmpty()) {
                this.addDomain();
            }
            return this.getDomain().get(0);
        }

        public List<CodeableConcept> getJurisdiction() {
            if (this.jurisdiction == null) {
                this.jurisdiction = new ArrayList<CodeableConcept>();
            }
            return this.jurisdiction;
        }

        public SubstanceSpecificationSubstanceNameComponent setJurisdiction(List<CodeableConcept> theJurisdiction) {
            this.jurisdiction = theJurisdiction;
            return this;
        }

        public boolean hasJurisdiction() {
            if (this.jurisdiction == null) {
                return false;
            }
            for (CodeableConcept item : this.jurisdiction) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addJurisdiction() {
            CodeableConcept t = new CodeableConcept();
            if (this.jurisdiction == null) {
                this.jurisdiction = new ArrayList<CodeableConcept>();
            }
            this.jurisdiction.add(t);
            return t;
        }

        public SubstanceSpecificationSubstanceNameComponent addJurisdiction(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.jurisdiction == null) {
                this.jurisdiction = new ArrayList<CodeableConcept>();
            }
            this.jurisdiction.add(t);
            return this;
        }

        public CodeableConcept getJurisdictionFirstRep() {
            if (this.getJurisdiction().isEmpty()) {
                this.addJurisdiction();
            }
            return this.getJurisdiction().get(0);
        }

        public List<SubstanceSpecificationSubstanceNameOfficialNameComponent> getOfficialName() {
            if (this.officialName == null) {
                this.officialName = new ArrayList<SubstanceSpecificationSubstanceNameOfficialNameComponent>();
            }
            return this.officialName;
        }

        public SubstanceSpecificationSubstanceNameComponent setOfficialName(List<SubstanceSpecificationSubstanceNameOfficialNameComponent> theOfficialName) {
            this.officialName = theOfficialName;
            return this;
        }

        public boolean hasOfficialName() {
            if (this.officialName == null) {
                return false;
            }
            for (SubstanceSpecificationSubstanceNameOfficialNameComponent item : this.officialName) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SubstanceSpecificationSubstanceNameOfficialNameComponent addOfficialName() {
            SubstanceSpecificationSubstanceNameOfficialNameComponent t = new SubstanceSpecificationSubstanceNameOfficialNameComponent();
            if (this.officialName == null) {
                this.officialName = new ArrayList<SubstanceSpecificationSubstanceNameOfficialNameComponent>();
            }
            this.officialName.add(t);
            return t;
        }

        public SubstanceSpecificationSubstanceNameComponent addOfficialName(SubstanceSpecificationSubstanceNameOfficialNameComponent t) {
            if (t == null) {
                return this;
            }
            if (this.officialName == null) {
                this.officialName = new ArrayList<SubstanceSpecificationSubstanceNameOfficialNameComponent>();
            }
            this.officialName.add(t);
            return this;
        }

        public SubstanceSpecificationSubstanceNameOfficialNameComponent getOfficialNameFirstRep() {
            if (this.getOfficialName().isEmpty()) {
                this.addOfficialName();
            }
            return this.getOfficialName().get(0);
        }

        public List<StringType> getReferenceSource() {
            if (this.referenceSource == null) {
                this.referenceSource = new ArrayList<StringType>();
            }
            return this.referenceSource;
        }

        public SubstanceSpecificationSubstanceNameComponent setReferenceSource(List<StringType> theReferenceSource) {
            this.referenceSource = theReferenceSource;
            return this;
        }

        public boolean hasReferenceSource() {
            if (this.referenceSource == null) {
                return false;
            }
            for (StringType item : this.referenceSource) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addReferenceSourceElement() {
            StringType t = new StringType();
            if (this.referenceSource == null) {
                this.referenceSource = new ArrayList<StringType>();
            }
            this.referenceSource.add(t);
            return t;
        }

        public SubstanceSpecificationSubstanceNameComponent addReferenceSource(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.referenceSource == null) {
                this.referenceSource = new ArrayList<StringType>();
            }
            this.referenceSource.add(t);
            return this;
        }

        public boolean hasReferenceSource(String value) {
            if (this.referenceSource == null) {
                return false;
            }
            for (StringType v : this.referenceSource) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("name", "string", "The actual name.", 0, 1, this.name));
            children.add(new Property("type", "CodeableConcept", "Name type.", 0, 1, this.type));
            children.add(new Property("language", "CodeableConcept", "Language of the name.", 0, Integer.MAX_VALUE, this.language));
            children.add(new Property("domain", "CodeableConcept", "The use context of this name for example if there is a different name a drug active ingredient as opposed to a food colour additive.", 0, Integer.MAX_VALUE, this.domain));
            children.add(new Property("jurisdiction", "CodeableConcept", "The jurisdiction where this name applies.", 0, Integer.MAX_VALUE, this.jurisdiction));
            children.add(new Property("officialName", "", "Details of the official nature of this name.", 0, Integer.MAX_VALUE, this.officialName));
            children.add(new Property("referenceSource", "string", "Supporting literature.", 0, Integer.MAX_VALUE, this.referenceSource));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property("name", "string", "The actual name.", 0, 1, this.name);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Name type.", 0, 1, this.type);
                }
                case -1613589672: {
                    return new Property("language", "CodeableConcept", "Language of the name.", 0, Integer.MAX_VALUE, this.language);
                }
                case -1326197564: {
                    return new Property("domain", "CodeableConcept", "The use context of this name for example if there is a different name a drug active ingredient as opposed to a food colour additive.", 0, Integer.MAX_VALUE, this.domain);
                }
                case -507075711: {
                    return new Property("jurisdiction", "CodeableConcept", "The jurisdiction where this name applies.", 0, Integer.MAX_VALUE, this.jurisdiction);
                }
                case 1486494742: {
                    return new Property("officialName", "", "Details of the official nature of this name.", 0, Integer.MAX_VALUE, this.officialName);
                }
                case 882421574: {
                    return new Property("referenceSource", "string", "Supporting literature.", 0, Integer.MAX_VALUE, this.referenceSource);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case -1613589672: {
                    return this.language == null ? new Base[]{} : this.language.toArray(new Base[this.language.size()]);
                }
                case -1326197564: {
                    return this.domain == null ? new Base[]{} : this.domain.toArray(new Base[this.domain.size()]);
                }
                case -507075711: {
                    return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
                }
                case 1486494742: {
                    return this.officialName == null ? new Base[]{} : this.officialName.toArray(new Base[this.officialName.size()]);
                }
                case 882421574: {
                    return this.referenceSource == null ? new Base[]{} : this.referenceSource.toArray(new Base[this.referenceSource.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    return value;
                }
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case -1613589672: {
                    this.getLanguage().add(this.castToCodeableConcept(value));
                    return value;
                }
                case -1326197564: {
                    this.getDomain().add(this.castToCodeableConcept(value));
                    return value;
                }
                case -507075711: {
                    this.getJurisdiction().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 1486494742: {
                    this.getOfficialName().add((SubstanceSpecificationSubstanceNameOfficialNameComponent)value);
                    return value;
                }
                case 882421574: {
                    this.getReferenceSource().add(this.castToString(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("name")) {
                this.name = this.castToString(value);
            } else if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("language")) {
                this.getLanguage().add(this.castToCodeableConcept(value));
            } else if (name.equals("domain")) {
                this.getDomain().add(this.castToCodeableConcept(value));
            } else if (name.equals("jurisdiction")) {
                this.getJurisdiction().add(this.castToCodeableConcept(value));
            } else if (name.equals("officialName")) {
                this.getOfficialName().add((SubstanceSpecificationSubstanceNameOfficialNameComponent)value);
            } else if (name.equals("referenceSource")) {
                this.getReferenceSource().add(this.castToString(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case 3575610: {
                    return this.getType();
                }
                case -1613589672: {
                    return this.addLanguage();
                }
                case -1326197564: {
                    return this.addDomain();
                }
                case -507075711: {
                    return this.addJurisdiction();
                }
                case 1486494742: {
                    return this.addOfficialName();
                }
                case 882421574: {
                    return this.addReferenceSourceElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"string"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1613589672: {
                    return new String[]{"CodeableConcept"};
                }
                case -1326197564: {
                    return new String[]{"CodeableConcept"};
                }
                case -507075711: {
                    return new String[]{"CodeableConcept"};
                }
                case 1486494742: {
                    return new String[0];
                }
                case 882421574: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceSpecification.name");
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("language")) {
                return this.addLanguage();
            }
            if (name.equals("domain")) {
                return this.addDomain();
            }
            if (name.equals("jurisdiction")) {
                return this.addJurisdiction();
            }
            if (name.equals("officialName")) {
                return this.addOfficialName();
            }
            if (name.equals("referenceSource")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceSpecification.referenceSource");
            }
            return super.addChild(name);
        }

        @Override
        public SubstanceSpecificationSubstanceNameComponent copy() {
            SubstanceSpecificationSubstanceNameComponent dst = new SubstanceSpecificationSubstanceNameComponent();
            this.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
            if (this.language != null) {
                dst.language = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.language) {
                    dst.language.add(codeableConcept2.copy());
                }
            }
            if (this.domain != null) {
                dst.domain = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept3 : this.domain) {
                    dst.domain.add(codeableConcept3.copy());
                }
            }
            if (this.jurisdiction != null) {
                dst.jurisdiction = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept4 : this.jurisdiction) {
                    dst.jurisdiction.add(codeableConcept4.copy());
                }
            }
            if (this.officialName != null) {
                dst.officialName = new ArrayList<SubstanceSpecificationSubstanceNameOfficialNameComponent>();
                for (SubstanceSpecificationSubstanceNameOfficialNameComponent substanceSpecificationSubstanceNameOfficialNameComponent : this.officialName) {
                    dst.officialName.add(substanceSpecificationSubstanceNameOfficialNameComponent.copy());
                }
            }
            if (this.referenceSource != null) {
                dst.referenceSource = new ArrayList<StringType>();
                for (StringType stringType : this.referenceSource) {
                    dst.referenceSource.add(stringType.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSpecificationSubstanceNameComponent)) {
                return false;
            }
            SubstanceSpecificationSubstanceNameComponent o = (SubstanceSpecificationSubstanceNameComponent)other_;
            return SubstanceSpecificationSubstanceNameComponent.compareDeep(this.name, o.name, true) && SubstanceSpecificationSubstanceNameComponent.compareDeep(this.type, o.type, true) && SubstanceSpecificationSubstanceNameComponent.compareDeep(this.language, o.language, true) && SubstanceSpecificationSubstanceNameComponent.compareDeep(this.domain, o.domain, true) && SubstanceSpecificationSubstanceNameComponent.compareDeep(this.jurisdiction, o.jurisdiction, true) && SubstanceSpecificationSubstanceNameComponent.compareDeep(this.officialName, o.officialName, true) && SubstanceSpecificationSubstanceNameComponent.compareDeep(this.referenceSource, o.referenceSource, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSpecificationSubstanceNameComponent)) {
                return false;
            }
            SubstanceSpecificationSubstanceNameComponent o = (SubstanceSpecificationSubstanceNameComponent)other_;
            return SubstanceSpecificationSubstanceNameComponent.compareValues(this.name, o.name, true) && SubstanceSpecificationSubstanceNameComponent.compareValues(this.referenceSource, o.referenceSource, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.name, this.type, this.language, this.domain, this.jurisdiction, this.officialName, this.referenceSource});
        }

        @Override
        public String fhirType() {
            return "SubstanceSpecification.substanceName";
        }
    }

    @Block
    public static class SubstanceSpecificationSubstanceCodeComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The specific code", formalDefinition="The specific code.")
        protected CodeableConcept code;
        @Child(name="status", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Status of the code assignment", formalDefinition="Status of the code assignment.")
        protected CodeableConcept status;
        @Child(name="statusDate", type={DateTimeType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The date at which the code status is changed as part of the terminology maintenance", formalDefinition="The date at which the code status is changed as part of the terminology maintenance.")
        protected DateTimeType statusDate;
        @Child(name="comment", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Any comment can be provided in this field, if necessary", formalDefinition="Any comment can be provided in this field, if necessary.")
        protected StringType comment;
        @Child(name="referenceSource", type={StringType.class}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Supporting literature", formalDefinition="Supporting literature.")
        protected List<StringType> referenceSource;
        private static final long serialVersionUID = 1936663817L;

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationSubstanceCodeComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public SubstanceSpecificationSubstanceCodeComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public CodeableConcept getStatus() {
            if (this.status == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationSubstanceCodeComponent.status");
                }
                if (Configuration.doAutoCreate()) {
                    this.status = new CodeableConcept();
                }
            }
            return this.status;
        }

        public boolean hasStatus() {
            return this.status != null && !this.status.isEmpty();
        }

        public SubstanceSpecificationSubstanceCodeComponent setStatus(CodeableConcept value) {
            this.status = value;
            return this;
        }

        public DateTimeType getStatusDateElement() {
            if (this.statusDate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationSubstanceCodeComponent.statusDate");
                }
                if (Configuration.doAutoCreate()) {
                    this.statusDate = new DateTimeType();
                }
            }
            return this.statusDate;
        }

        public boolean hasStatusDateElement() {
            return this.statusDate != null && !this.statusDate.isEmpty();
        }

        public boolean hasStatusDate() {
            return this.statusDate != null && !this.statusDate.isEmpty();
        }

        public SubstanceSpecificationSubstanceCodeComponent setStatusDateElement(DateTimeType value) {
            this.statusDate = value;
            return this;
        }

        public Date getStatusDate() {
            return this.statusDate == null ? null : (Date)this.statusDate.getValue();
        }

        public SubstanceSpecificationSubstanceCodeComponent setStatusDate(Date value) {
            if (value == null) {
                this.statusDate = null;
            } else {
                if (this.statusDate == null) {
                    this.statusDate = new DateTimeType();
                }
                this.statusDate.setValue(value);
            }
            return this;
        }

        public StringType getCommentElement() {
            if (this.comment == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationSubstanceCodeComponent.comment");
                }
                if (Configuration.doAutoCreate()) {
                    this.comment = new StringType();
                }
            }
            return this.comment;
        }

        public boolean hasCommentElement() {
            return this.comment != null && !this.comment.isEmpty();
        }

        public boolean hasComment() {
            return this.comment != null && !this.comment.isEmpty();
        }

        public SubstanceSpecificationSubstanceCodeComponent setCommentElement(StringType value) {
            this.comment = value;
            return this;
        }

        public String getComment() {
            return this.comment == null ? null : (String)this.comment.getValue();
        }

        public SubstanceSpecificationSubstanceCodeComponent setComment(String value) {
            if (Utilities.noString((String)value)) {
                this.comment = null;
            } else {
                if (this.comment == null) {
                    this.comment = new StringType();
                }
                this.comment.setValue(value);
            }
            return this;
        }

        public List<StringType> getReferenceSource() {
            if (this.referenceSource == null) {
                this.referenceSource = new ArrayList<StringType>();
            }
            return this.referenceSource;
        }

        public SubstanceSpecificationSubstanceCodeComponent setReferenceSource(List<StringType> theReferenceSource) {
            this.referenceSource = theReferenceSource;
            return this;
        }

        public boolean hasReferenceSource() {
            if (this.referenceSource == null) {
                return false;
            }
            for (StringType item : this.referenceSource) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addReferenceSourceElement() {
            StringType t = new StringType();
            if (this.referenceSource == null) {
                this.referenceSource = new ArrayList<StringType>();
            }
            this.referenceSource.add(t);
            return t;
        }

        public SubstanceSpecificationSubstanceCodeComponent addReferenceSource(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.referenceSource == null) {
                this.referenceSource = new ArrayList<StringType>();
            }
            this.referenceSource.add(t);
            return this;
        }

        public boolean hasReferenceSource(String value) {
            if (this.referenceSource == null) {
                return false;
            }
            for (StringType v : this.referenceSource) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "CodeableConcept", "The specific code.", 0, 1, this.code));
            children.add(new Property("status", "CodeableConcept", "Status of the code assignment.", 0, 1, this.status));
            children.add(new Property("statusDate", "dateTime", "The date at which the code status is changed as part of the terminology maintenance.", 0, 1, this.statusDate));
            children.add(new Property("comment", "string", "Any comment can be provided in this field, if necessary.", 0, 1, this.comment));
            children.add(new Property("referenceSource", "string", "Supporting literature.", 0, Integer.MAX_VALUE, this.referenceSource));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "CodeableConcept", "The specific code.", 0, 1, this.code);
                }
                case -892481550: {
                    return new Property("status", "CodeableConcept", "Status of the code assignment.", 0, 1, this.status);
                }
                case 247524032: {
                    return new Property("statusDate", "dateTime", "The date at which the code status is changed as part of the terminology maintenance.", 0, 1, this.statusDate);
                }
                case 950398559: {
                    return new Property("comment", "string", "Any comment can be provided in this field, if necessary.", 0, 1, this.comment);
                }
                case 882421574: {
                    return new Property("referenceSource", "string", "Supporting literature.", 0, Integer.MAX_VALUE, this.referenceSource);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case -892481550: {
                    Base[] baseArray;
                    if (this.status == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.status;
                    }
                    return baseArray;
                }
                case 247524032: {
                    Base[] baseArray;
                    if (this.statusDate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.statusDate;
                    }
                    return baseArray;
                }
                case 950398559: {
                    Base[] baseArray;
                    if (this.comment == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.comment;
                    }
                    return baseArray;
                }
                case 882421574: {
                    return this.referenceSource == null ? new Base[]{} : this.referenceSource.toArray(new Base[this.referenceSource.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = this.castToCodeableConcept(value);
                    return value;
                }
                case -892481550: {
                    this.status = this.castToCodeableConcept(value);
                    return value;
                }
                case 247524032: {
                    this.statusDate = this.castToDateTime(value);
                    return value;
                }
                case 950398559: {
                    this.comment = this.castToString(value);
                    return value;
                }
                case 882421574: {
                    this.getReferenceSource().add(this.castToString(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = this.castToCodeableConcept(value);
            } else if (name.equals("status")) {
                this.status = this.castToCodeableConcept(value);
            } else if (name.equals("statusDate")) {
                this.statusDate = this.castToDateTime(value);
            } else if (name.equals("comment")) {
                this.comment = this.castToString(value);
            } else if (name.equals("referenceSource")) {
                this.getReferenceSource().add(this.castToString(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case -892481550: {
                    return this.getStatus();
                }
                case 247524032: {
                    return this.getStatusDateElement();
                }
                case 950398559: {
                    return this.getCommentElement();
                }
                case 882421574: {
                    return this.addReferenceSourceElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case -892481550: {
                    return new String[]{"CodeableConcept"};
                }
                case 247524032: {
                    return new String[]{"dateTime"};
                }
                case 950398559: {
                    return new String[]{"string"};
                }
                case 882421574: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("status")) {
                this.status = new CodeableConcept();
                return this.status;
            }
            if (name.equals("statusDate")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceSpecification.statusDate");
            }
            if (name.equals("comment")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceSpecification.comment");
            }
            if (name.equals("referenceSource")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceSpecification.referenceSource");
            }
            return super.addChild(name);
        }

        @Override
        public SubstanceSpecificationSubstanceCodeComponent copy() {
            SubstanceSpecificationSubstanceCodeComponent dst = new SubstanceSpecificationSubstanceCodeComponent();
            this.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.status = this.status == null ? null : this.status.copy();
            dst.statusDate = this.statusDate == null ? null : this.statusDate.copy();
            StringType stringType = dst.comment = this.comment == null ? null : this.comment.copy();
            if (this.referenceSource != null) {
                dst.referenceSource = new ArrayList<StringType>();
                for (StringType i : this.referenceSource) {
                    dst.referenceSource.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSpecificationSubstanceCodeComponent)) {
                return false;
            }
            SubstanceSpecificationSubstanceCodeComponent o = (SubstanceSpecificationSubstanceCodeComponent)other_;
            return SubstanceSpecificationSubstanceCodeComponent.compareDeep(this.code, o.code, true) && SubstanceSpecificationSubstanceCodeComponent.compareDeep(this.status, o.status, true) && SubstanceSpecificationSubstanceCodeComponent.compareDeep(this.statusDate, o.statusDate, true) && SubstanceSpecificationSubstanceCodeComponent.compareDeep(this.comment, o.comment, true) && SubstanceSpecificationSubstanceCodeComponent.compareDeep(this.referenceSource, o.referenceSource, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSpecificationSubstanceCodeComponent)) {
                return false;
            }
            SubstanceSpecificationSubstanceCodeComponent o = (SubstanceSpecificationSubstanceCodeComponent)other_;
            return SubstanceSpecificationSubstanceCodeComponent.compareValues(this.statusDate, o.statusDate, true) && SubstanceSpecificationSubstanceCodeComponent.compareValues(this.comment, o.comment, true) && SubstanceSpecificationSubstanceCodeComponent.compareValues(this.referenceSource, o.referenceSource, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.code, this.status, this.statusDate, this.comment, this.referenceSource});
        }

        @Override
        public String fhirType() {
            return "SubstanceSpecification.substanceCode";
        }
    }

    @Block
    public static class SubstanceSpecificationStructureStructuralRepresentationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The type of structure (e.g. Full, Partial, Representative)", formalDefinition="The type of structure (e.g. Full, Partial, Representative).")
        protected CodeableConcept type;
        @Child(name="representation", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The structural representation as text string in a format e.g. InChI, SMILES, MOLFILE, CDX", formalDefinition="The structural representation as text string in a format e.g. InChI, SMILES, MOLFILE, CDX.")
        protected StringType representation;
        @Child(name="attachment", type={Attachment.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="An attached file with the structural representation", formalDefinition="An attached file with the structural representation.")
        protected Attachment attachment;
        private static final long serialVersionUID = 167954495L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationStructureStructuralRepresentationComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public SubstanceSpecificationStructureStructuralRepresentationComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public StringType getRepresentationElement() {
            if (this.representation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationStructureStructuralRepresentationComponent.representation");
                }
                if (Configuration.doAutoCreate()) {
                    this.representation = new StringType();
                }
            }
            return this.representation;
        }

        public boolean hasRepresentationElement() {
            return this.representation != null && !this.representation.isEmpty();
        }

        public boolean hasRepresentation() {
            return this.representation != null && !this.representation.isEmpty();
        }

        public SubstanceSpecificationStructureStructuralRepresentationComponent setRepresentationElement(StringType value) {
            this.representation = value;
            return this;
        }

        public String getRepresentation() {
            return this.representation == null ? null : (String)this.representation.getValue();
        }

        public SubstanceSpecificationStructureStructuralRepresentationComponent setRepresentation(String value) {
            if (Utilities.noString((String)value)) {
                this.representation = null;
            } else {
                if (this.representation == null) {
                    this.representation = new StringType();
                }
                this.representation.setValue(value);
            }
            return this;
        }

        public Attachment getAttachment() {
            if (this.attachment == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationStructureStructuralRepresentationComponent.attachment");
                }
                if (Configuration.doAutoCreate()) {
                    this.attachment = new Attachment();
                }
            }
            return this.attachment;
        }

        public boolean hasAttachment() {
            return this.attachment != null && !this.attachment.isEmpty();
        }

        public SubstanceSpecificationStructureStructuralRepresentationComponent setAttachment(Attachment value) {
            this.attachment = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "The type of structure (e.g. Full, Partial, Representative).", 0, 1, this.type));
            children.add(new Property("representation", "string", "The structural representation as text string in a format e.g. InChI, SMILES, MOLFILE, CDX.", 0, 1, this.representation));
            children.add(new Property("attachment", "Attachment", "An attached file with the structural representation.", 0, 1, this.attachment));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The type of structure (e.g. Full, Partial, Representative).", 0, 1, this.type);
                }
                case -671065907: {
                    return new Property("representation", "string", "The structural representation as text string in a format e.g. InChI, SMILES, MOLFILE, CDX.", 0, 1, this.representation);
                }
                case -1963501277: {
                    return new Property("attachment", "Attachment", "An attached file with the structural representation.", 0, 1, this.attachment);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -671065907: {
                    Base[] baseArray;
                    if (this.representation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.representation;
                    }
                    return baseArray;
                }
                case -1963501277: {
                    Base[] baseArray;
                    if (this.attachment == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.attachment;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case -671065907: {
                    this.representation = this.castToString(value);
                    return value;
                }
                case -1963501277: {
                    this.attachment = this.castToAttachment(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("representation")) {
                this.representation = this.castToString(value);
            } else if (name.equals("attachment")) {
                this.attachment = this.castToAttachment(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -671065907: {
                    return this.getRepresentationElement();
                }
                case -1963501277: {
                    return this.getAttachment();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -671065907: {
                    return new String[]{"string"};
                }
                case -1963501277: {
                    return new String[]{"Attachment"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("representation")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceSpecification.representation");
            }
            if (name.equals("attachment")) {
                this.attachment = new Attachment();
                return this.attachment;
            }
            return super.addChild(name);
        }

        @Override
        public SubstanceSpecificationStructureStructuralRepresentationComponent copy() {
            SubstanceSpecificationStructureStructuralRepresentationComponent dst = new SubstanceSpecificationStructureStructuralRepresentationComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.representation = this.representation == null ? null : this.representation.copy();
            dst.attachment = this.attachment == null ? null : this.attachment.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSpecificationStructureStructuralRepresentationComponent)) {
                return false;
            }
            SubstanceSpecificationStructureStructuralRepresentationComponent o = (SubstanceSpecificationStructureStructuralRepresentationComponent)other_;
            return SubstanceSpecificationStructureStructuralRepresentationComponent.compareDeep(this.type, o.type, true) && SubstanceSpecificationStructureStructuralRepresentationComponent.compareDeep(this.representation, o.representation, true) && SubstanceSpecificationStructureStructuralRepresentationComponent.compareDeep(this.attachment, o.attachment, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSpecificationStructureStructuralRepresentationComponent)) {
                return false;
            }
            SubstanceSpecificationStructureStructuralRepresentationComponent o = (SubstanceSpecificationStructureStructuralRepresentationComponent)other_;
            return SubstanceSpecificationStructureStructuralRepresentationComponent.compareValues(this.representation, o.representation, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.representation, this.attachment});
        }

        @Override
        public String fhirType() {
            return "SubstanceSpecification.structure.structuralRepresentation";
        }
    }

    @Block
    public static class SubstanceSpecificationStructureIsotopeMolecularWeightComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="method", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The method by which the molecular weight was determined", formalDefinition="The method by which the molecular weight was determined.")
        protected CodeableConcept method;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type of molecular weight such as exact, average (also known as. number average), weight average", formalDefinition="Type of molecular weight such as exact, average (also known as. number average), weight average.")
        protected CodeableConcept type;
        @Child(name="amount", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Used to capture quantitative values for a variety of elements. If only limits are given, the arithmetic mean would be the average. If only a single definite value for a given element is given, it would be captured in this field", formalDefinition="Used to capture quantitative values for a variety of elements. If only limits are given, the arithmetic mean would be the average. If only a single definite value for a given element is given, it would be captured in this field.")
        protected StringType amount;
        private static final long serialVersionUID = -1221185948L;

        public CodeableConcept getMethod() {
            if (this.method == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationStructureIsotopeMolecularWeightComponent.method");
                }
                if (Configuration.doAutoCreate()) {
                    this.method = new CodeableConcept();
                }
            }
            return this.method;
        }

        public boolean hasMethod() {
            return this.method != null && !this.method.isEmpty();
        }

        public SubstanceSpecificationStructureIsotopeMolecularWeightComponent setMethod(CodeableConcept value) {
            this.method = value;
            return this;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationStructureIsotopeMolecularWeightComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public SubstanceSpecificationStructureIsotopeMolecularWeightComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public StringType getAmountElement() {
            if (this.amount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationStructureIsotopeMolecularWeightComponent.amount");
                }
                if (Configuration.doAutoCreate()) {
                    this.amount = new StringType();
                }
            }
            return this.amount;
        }

        public boolean hasAmountElement() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public SubstanceSpecificationStructureIsotopeMolecularWeightComponent setAmountElement(StringType value) {
            this.amount = value;
            return this;
        }

        public String getAmount() {
            return this.amount == null ? null : (String)this.amount.getValue();
        }

        public SubstanceSpecificationStructureIsotopeMolecularWeightComponent setAmount(String value) {
            if (Utilities.noString((String)value)) {
                this.amount = null;
            } else {
                if (this.amount == null) {
                    this.amount = new StringType();
                }
                this.amount.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("method", "CodeableConcept", "The method by which the molecular weight was determined.", 0, 1, this.method));
            children.add(new Property("type", "CodeableConcept", "Type of molecular weight such as exact, average (also known as. number average), weight average.", 0, 1, this.type));
            children.add(new Property("amount", "string", "Used to capture quantitative values for a variety of elements. If only limits are given, the arithmetic mean would be the average. If only a single definite value for a given element is given, it would be captured in this field.", 0, 1, this.amount));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1077554975: {
                    return new Property("method", "CodeableConcept", "The method by which the molecular weight was determined.", 0, 1, this.method);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Type of molecular weight such as exact, average (also known as. number average), weight average.", 0, 1, this.type);
                }
                case -1413853096: {
                    return new Property("amount", "string", "Used to capture quantitative values for a variety of elements. If only limits are given, the arithmetic mean would be the average. If only a single definite value for a given element is given, it would be captured in this field.", 0, 1, this.amount);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1077554975: {
                    Base[] baseArray;
                    if (this.method == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.method;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.amount;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1077554975: {
                    this.method = this.castToCodeableConcept(value);
                    return value;
                }
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case -1413853096: {
                    this.amount = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("method")) {
                this.method = this.castToCodeableConcept(value);
            } else if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("amount")) {
                this.amount = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1077554975: {
                    return this.getMethod();
                }
                case 3575610: {
                    return this.getType();
                }
                case -1413853096: {
                    return this.getAmountElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1077554975: {
                    return new String[]{"CodeableConcept"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1413853096: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("method")) {
                this.method = new CodeableConcept();
                return this.method;
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("amount")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceSpecification.amount");
            }
            return super.addChild(name);
        }

        @Override
        public SubstanceSpecificationStructureIsotopeMolecularWeightComponent copy() {
            SubstanceSpecificationStructureIsotopeMolecularWeightComponent dst = new SubstanceSpecificationStructureIsotopeMolecularWeightComponent();
            this.copyValues(dst);
            dst.method = this.method == null ? null : this.method.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSpecificationStructureIsotopeMolecularWeightComponent)) {
                return false;
            }
            SubstanceSpecificationStructureIsotopeMolecularWeightComponent o = (SubstanceSpecificationStructureIsotopeMolecularWeightComponent)other_;
            return SubstanceSpecificationStructureIsotopeMolecularWeightComponent.compareDeep(this.method, o.method, true) && SubstanceSpecificationStructureIsotopeMolecularWeightComponent.compareDeep(this.type, o.type, true) && SubstanceSpecificationStructureIsotopeMolecularWeightComponent.compareDeep(this.amount, o.amount, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSpecificationStructureIsotopeMolecularWeightComponent)) {
                return false;
            }
            SubstanceSpecificationStructureIsotopeMolecularWeightComponent o = (SubstanceSpecificationStructureIsotopeMolecularWeightComponent)other_;
            return SubstanceSpecificationStructureIsotopeMolecularWeightComponent.compareValues(this.amount, o.amount, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.method, this.type, this.amount});
        }

        @Override
        public String fhirType() {
            return "SubstanceSpecification.structure.isotope.molecularWeight";
        }
    }

    @Block
    public static class SubstanceSpecificationStructureIsotopeComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="nuclideId", type={Identifier.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Substance identifier for each non-natural or radioisotope", formalDefinition="Substance identifier for each non-natural or radioisotope.")
        protected Identifier nuclideId;
        @Child(name="nuclideName", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Substance name for each non-natural or radioisotope", formalDefinition="Substance name for each non-natural or radioisotope.")
        protected CodeableConcept nuclideName;
        @Child(name="substitutionType", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The type of isotopic substitution present in a single substance", formalDefinition="The type of isotopic substitution present in a single substance.")
        protected CodeableConcept substitutionType;
        @Child(name="nuclideHalfLife", type={Quantity.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Half life - for a non-natural nuclide", formalDefinition="Half life - for a non-natural nuclide.")
        protected Quantity nuclideHalfLife;
        @Child(name="amount", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Quantitative values for this isotope", formalDefinition="Quantitative values for this isotope.")
        protected StringType amount;
        @Child(name="molecularWeight", type={}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The molecular weight or weight range (for proteins, polymers or nucleic acids)", formalDefinition="The molecular weight or weight range (for proteins, polymers or nucleic acids).")
        protected SubstanceSpecificationStructureIsotopeMolecularWeightComponent molecularWeight;
        private static final long serialVersionUID = -654404311L;

        public Identifier getNuclideId() {
            if (this.nuclideId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationStructureIsotopeComponent.nuclideId");
                }
                if (Configuration.doAutoCreate()) {
                    this.nuclideId = new Identifier();
                }
            }
            return this.nuclideId;
        }

        public boolean hasNuclideId() {
            return this.nuclideId != null && !this.nuclideId.isEmpty();
        }

        public SubstanceSpecificationStructureIsotopeComponent setNuclideId(Identifier value) {
            this.nuclideId = value;
            return this;
        }

        public CodeableConcept getNuclideName() {
            if (this.nuclideName == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationStructureIsotopeComponent.nuclideName");
                }
                if (Configuration.doAutoCreate()) {
                    this.nuclideName = new CodeableConcept();
                }
            }
            return this.nuclideName;
        }

        public boolean hasNuclideName() {
            return this.nuclideName != null && !this.nuclideName.isEmpty();
        }

        public SubstanceSpecificationStructureIsotopeComponent setNuclideName(CodeableConcept value) {
            this.nuclideName = value;
            return this;
        }

        public CodeableConcept getSubstitutionType() {
            if (this.substitutionType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationStructureIsotopeComponent.substitutionType");
                }
                if (Configuration.doAutoCreate()) {
                    this.substitutionType = new CodeableConcept();
                }
            }
            return this.substitutionType;
        }

        public boolean hasSubstitutionType() {
            return this.substitutionType != null && !this.substitutionType.isEmpty();
        }

        public SubstanceSpecificationStructureIsotopeComponent setSubstitutionType(CodeableConcept value) {
            this.substitutionType = value;
            return this;
        }

        public Quantity getNuclideHalfLife() {
            if (this.nuclideHalfLife == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationStructureIsotopeComponent.nuclideHalfLife");
                }
                if (Configuration.doAutoCreate()) {
                    this.nuclideHalfLife = new Quantity();
                }
            }
            return this.nuclideHalfLife;
        }

        public boolean hasNuclideHalfLife() {
            return this.nuclideHalfLife != null && !this.nuclideHalfLife.isEmpty();
        }

        public SubstanceSpecificationStructureIsotopeComponent setNuclideHalfLife(Quantity value) {
            this.nuclideHalfLife = value;
            return this;
        }

        public StringType getAmountElement() {
            if (this.amount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationStructureIsotopeComponent.amount");
                }
                if (Configuration.doAutoCreate()) {
                    this.amount = new StringType();
                }
            }
            return this.amount;
        }

        public boolean hasAmountElement() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public SubstanceSpecificationStructureIsotopeComponent setAmountElement(StringType value) {
            this.amount = value;
            return this;
        }

        public String getAmount() {
            return this.amount == null ? null : (String)this.amount.getValue();
        }

        public SubstanceSpecificationStructureIsotopeComponent setAmount(String value) {
            if (Utilities.noString((String)value)) {
                this.amount = null;
            } else {
                if (this.amount == null) {
                    this.amount = new StringType();
                }
                this.amount.setValue(value);
            }
            return this;
        }

        public SubstanceSpecificationStructureIsotopeMolecularWeightComponent getMolecularWeight() {
            if (this.molecularWeight == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationStructureIsotopeComponent.molecularWeight");
                }
                if (Configuration.doAutoCreate()) {
                    this.molecularWeight = new SubstanceSpecificationStructureIsotopeMolecularWeightComponent();
                }
            }
            return this.molecularWeight;
        }

        public boolean hasMolecularWeight() {
            return this.molecularWeight != null && !this.molecularWeight.isEmpty();
        }

        public SubstanceSpecificationStructureIsotopeComponent setMolecularWeight(SubstanceSpecificationStructureIsotopeMolecularWeightComponent value) {
            this.molecularWeight = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("nuclideId", "Identifier", "Substance identifier for each non-natural or radioisotope.", 0, 1, this.nuclideId));
            children.add(new Property("nuclideName", "CodeableConcept", "Substance name for each non-natural or radioisotope.", 0, 1, this.nuclideName));
            children.add(new Property("substitutionType", "CodeableConcept", "The type of isotopic substitution present in a single substance.", 0, 1, this.substitutionType));
            children.add(new Property("nuclideHalfLife", "Quantity", "Half life - for a non-natural nuclide.", 0, 1, this.nuclideHalfLife));
            children.add(new Property("amount", "string", "Quantitative values for this isotope.", 0, 1, this.amount));
            children.add(new Property("molecularWeight", "", "The molecular weight or weight range (for proteins, polymers or nucleic acids).", 0, 1, this.molecularWeight));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1654398709: {
                    return new Property("nuclideId", "Identifier", "Substance identifier for each non-natural or radioisotope.", 0, 1, this.nuclideId);
                }
                case 739409381: {
                    return new Property("nuclideName", "CodeableConcept", "Substance name for each non-natural or radioisotope.", 0, 1, this.nuclideName);
                }
                case -1937621033: {
                    return new Property("substitutionType", "CodeableConcept", "The type of isotopic substitution present in a single substance.", 0, 1, this.substitutionType);
                }
                case 1348294697: {
                    return new Property("nuclideHalfLife", "Quantity", "Half life - for a non-natural nuclide.", 0, 1, this.nuclideHalfLife);
                }
                case -1413853096: {
                    return new Property("amount", "string", "Quantitative values for this isotope.", 0, 1, this.amount);
                }
                case 635625672: {
                    return new Property("molecularWeight", "", "The molecular weight or weight range (for proteins, polymers or nucleic acids).", 0, 1, this.molecularWeight);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1654398709: {
                    Base[] baseArray;
                    if (this.nuclideId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.nuclideId;
                    }
                    return baseArray;
                }
                case 739409381: {
                    Base[] baseArray;
                    if (this.nuclideName == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.nuclideName;
                    }
                    return baseArray;
                }
                case -1937621033: {
                    Base[] baseArray;
                    if (this.substitutionType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.substitutionType;
                    }
                    return baseArray;
                }
                case 1348294697: {
                    Base[] baseArray;
                    if (this.nuclideHalfLife == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.nuclideHalfLife;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.amount;
                    }
                    return baseArray;
                }
                case 635625672: {
                    Base[] baseArray;
                    if (this.molecularWeight == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.molecularWeight;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1654398709: {
                    this.nuclideId = this.castToIdentifier(value);
                    return value;
                }
                case 739409381: {
                    this.nuclideName = this.castToCodeableConcept(value);
                    return value;
                }
                case -1937621033: {
                    this.substitutionType = this.castToCodeableConcept(value);
                    return value;
                }
                case 1348294697: {
                    this.nuclideHalfLife = this.castToQuantity(value);
                    return value;
                }
                case -1413853096: {
                    this.amount = this.castToString(value);
                    return value;
                }
                case 635625672: {
                    this.molecularWeight = (SubstanceSpecificationStructureIsotopeMolecularWeightComponent)value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("nuclideId")) {
                this.nuclideId = this.castToIdentifier(value);
            } else if (name.equals("nuclideName")) {
                this.nuclideName = this.castToCodeableConcept(value);
            } else if (name.equals("substitutionType")) {
                this.substitutionType = this.castToCodeableConcept(value);
            } else if (name.equals("nuclideHalfLife")) {
                this.nuclideHalfLife = this.castToQuantity(value);
            } else if (name.equals("amount")) {
                this.amount = this.castToString(value);
            } else if (name.equals("molecularWeight")) {
                this.molecularWeight = (SubstanceSpecificationStructureIsotopeMolecularWeightComponent)value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1654398709: {
                    return this.getNuclideId();
                }
                case 739409381: {
                    return this.getNuclideName();
                }
                case -1937621033: {
                    return this.getSubstitutionType();
                }
                case 1348294697: {
                    return this.getNuclideHalfLife();
                }
                case -1413853096: {
                    return this.getAmountElement();
                }
                case 635625672: {
                    return this.getMolecularWeight();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1654398709: {
                    return new String[]{"Identifier"};
                }
                case 739409381: {
                    return new String[]{"CodeableConcept"};
                }
                case -1937621033: {
                    return new String[]{"CodeableConcept"};
                }
                case 1348294697: {
                    return new String[]{"Quantity"};
                }
                case -1413853096: {
                    return new String[]{"string"};
                }
                case 635625672: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("nuclideId")) {
                this.nuclideId = new Identifier();
                return this.nuclideId;
            }
            if (name.equals("nuclideName")) {
                this.nuclideName = new CodeableConcept();
                return this.nuclideName;
            }
            if (name.equals("substitutionType")) {
                this.substitutionType = new CodeableConcept();
                return this.substitutionType;
            }
            if (name.equals("nuclideHalfLife")) {
                this.nuclideHalfLife = new Quantity();
                return this.nuclideHalfLife;
            }
            if (name.equals("amount")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceSpecification.amount");
            }
            if (name.equals("molecularWeight")) {
                this.molecularWeight = new SubstanceSpecificationStructureIsotopeMolecularWeightComponent();
                return this.molecularWeight;
            }
            return super.addChild(name);
        }

        @Override
        public SubstanceSpecificationStructureIsotopeComponent copy() {
            SubstanceSpecificationStructureIsotopeComponent dst = new SubstanceSpecificationStructureIsotopeComponent();
            this.copyValues(dst);
            dst.nuclideId = this.nuclideId == null ? null : this.nuclideId.copy();
            dst.nuclideName = this.nuclideName == null ? null : this.nuclideName.copy();
            dst.substitutionType = this.substitutionType == null ? null : this.substitutionType.copy();
            dst.nuclideHalfLife = this.nuclideHalfLife == null ? null : this.nuclideHalfLife.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
            dst.molecularWeight = this.molecularWeight == null ? null : this.molecularWeight.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSpecificationStructureIsotopeComponent)) {
                return false;
            }
            SubstanceSpecificationStructureIsotopeComponent o = (SubstanceSpecificationStructureIsotopeComponent)other_;
            return SubstanceSpecificationStructureIsotopeComponent.compareDeep(this.nuclideId, o.nuclideId, true) && SubstanceSpecificationStructureIsotopeComponent.compareDeep(this.nuclideName, o.nuclideName, true) && SubstanceSpecificationStructureIsotopeComponent.compareDeep(this.substitutionType, o.substitutionType, true) && SubstanceSpecificationStructureIsotopeComponent.compareDeep(this.nuclideHalfLife, o.nuclideHalfLife, true) && SubstanceSpecificationStructureIsotopeComponent.compareDeep(this.amount, o.amount, true) && SubstanceSpecificationStructureIsotopeComponent.compareDeep(this.molecularWeight, o.molecularWeight, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSpecificationStructureIsotopeComponent)) {
                return false;
            }
            SubstanceSpecificationStructureIsotopeComponent o = (SubstanceSpecificationStructureIsotopeComponent)other_;
            return SubstanceSpecificationStructureIsotopeComponent.compareValues(this.amount, o.amount, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.nuclideId, this.nuclideName, this.substitutionType, this.nuclideHalfLife, this.amount, this.molecularWeight});
        }

        @Override
        public String fhirType() {
            return "SubstanceSpecification.structure.isotope";
        }
    }

    @Block
    public static class SubstanceSpecificationStructureComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="stereochemistry", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Stereochemistry type", formalDefinition="Stereochemistry type.")
        protected CodeableConcept stereochemistry;
        @Child(name="opticalActivity", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Optical activity type", formalDefinition="Optical activity type.")
        protected CodeableConcept opticalActivity;
        @Child(name="molecularFormula", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Molecular formula", formalDefinition="Molecular formula.")
        protected StringType molecularFormula;
        @Child(name="molecularFormulaByMoiety", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Specified per moiety according to the Hill system, i.e. first C, then H, then alphabetical. and each moiety separated by a dot", formalDefinition="Specified per moiety according to the Hill system, i.e. first C, then H, then alphabetical. and each moiety separated by a dot.")
        protected StringType molecularFormulaByMoiety;
        @Child(name="isotope", type={}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Applicable for single substances that contain a radionuclide or a non-natural isotopic ratio", formalDefinition="Applicable for single substances that contain a radionuclide or a non-natural isotopic ratio.")
        protected List<SubstanceSpecificationStructureIsotopeComponent> isotope;
        @Child(name="molecularWeight", type={SubstanceSpecificationStructureIsotopeMolecularWeightComponent.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The molecular weight or weight range (for proteins, polymers or nucleic acids)", formalDefinition="The molecular weight or weight range (for proteins, polymers or nucleic acids).")
        protected SubstanceSpecificationStructureIsotopeMolecularWeightComponent molecularWeight;
        @Child(name="referenceSource", type={DocumentReference.class}, order=7, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Supporting literature", formalDefinition="Supporting literature.")
        protected List<Reference> referenceSource;
        protected List<DocumentReference> referenceSourceTarget;
        @Child(name="structuralRepresentation", type={}, order=8, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Molectular structural representation", formalDefinition="Molectular structural representation.")
        protected List<SubstanceSpecificationStructureStructuralRepresentationComponent> structuralRepresentation;
        private static final long serialVersionUID = -2087062825L;

        public CodeableConcept getStereochemistry() {
            if (this.stereochemistry == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationStructureComponent.stereochemistry");
                }
                if (Configuration.doAutoCreate()) {
                    this.stereochemistry = new CodeableConcept();
                }
            }
            return this.stereochemistry;
        }

        public boolean hasStereochemistry() {
            return this.stereochemistry != null && !this.stereochemistry.isEmpty();
        }

        public SubstanceSpecificationStructureComponent setStereochemistry(CodeableConcept value) {
            this.stereochemistry = value;
            return this;
        }

        public CodeableConcept getOpticalActivity() {
            if (this.opticalActivity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationStructureComponent.opticalActivity");
                }
                if (Configuration.doAutoCreate()) {
                    this.opticalActivity = new CodeableConcept();
                }
            }
            return this.opticalActivity;
        }

        public boolean hasOpticalActivity() {
            return this.opticalActivity != null && !this.opticalActivity.isEmpty();
        }

        public SubstanceSpecificationStructureComponent setOpticalActivity(CodeableConcept value) {
            this.opticalActivity = value;
            return this;
        }

        public StringType getMolecularFormulaElement() {
            if (this.molecularFormula == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationStructureComponent.molecularFormula");
                }
                if (Configuration.doAutoCreate()) {
                    this.molecularFormula = new StringType();
                }
            }
            return this.molecularFormula;
        }

        public boolean hasMolecularFormulaElement() {
            return this.molecularFormula != null && !this.molecularFormula.isEmpty();
        }

        public boolean hasMolecularFormula() {
            return this.molecularFormula != null && !this.molecularFormula.isEmpty();
        }

        public SubstanceSpecificationStructureComponent setMolecularFormulaElement(StringType value) {
            this.molecularFormula = value;
            return this;
        }

        public String getMolecularFormula() {
            return this.molecularFormula == null ? null : (String)this.molecularFormula.getValue();
        }

        public SubstanceSpecificationStructureComponent setMolecularFormula(String value) {
            if (Utilities.noString((String)value)) {
                this.molecularFormula = null;
            } else {
                if (this.molecularFormula == null) {
                    this.molecularFormula = new StringType();
                }
                this.molecularFormula.setValue(value);
            }
            return this;
        }

        public StringType getMolecularFormulaByMoietyElement() {
            if (this.molecularFormulaByMoiety == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationStructureComponent.molecularFormulaByMoiety");
                }
                if (Configuration.doAutoCreate()) {
                    this.molecularFormulaByMoiety = new StringType();
                }
            }
            return this.molecularFormulaByMoiety;
        }

        public boolean hasMolecularFormulaByMoietyElement() {
            return this.molecularFormulaByMoiety != null && !this.molecularFormulaByMoiety.isEmpty();
        }

        public boolean hasMolecularFormulaByMoiety() {
            return this.molecularFormulaByMoiety != null && !this.molecularFormulaByMoiety.isEmpty();
        }

        public SubstanceSpecificationStructureComponent setMolecularFormulaByMoietyElement(StringType value) {
            this.molecularFormulaByMoiety = value;
            return this;
        }

        public String getMolecularFormulaByMoiety() {
            return this.molecularFormulaByMoiety == null ? null : (String)this.molecularFormulaByMoiety.getValue();
        }

        public SubstanceSpecificationStructureComponent setMolecularFormulaByMoiety(String value) {
            if (Utilities.noString((String)value)) {
                this.molecularFormulaByMoiety = null;
            } else {
                if (this.molecularFormulaByMoiety == null) {
                    this.molecularFormulaByMoiety = new StringType();
                }
                this.molecularFormulaByMoiety.setValue(value);
            }
            return this;
        }

        public List<SubstanceSpecificationStructureIsotopeComponent> getIsotope() {
            if (this.isotope == null) {
                this.isotope = new ArrayList<SubstanceSpecificationStructureIsotopeComponent>();
            }
            return this.isotope;
        }

        public SubstanceSpecificationStructureComponent setIsotope(List<SubstanceSpecificationStructureIsotopeComponent> theIsotope) {
            this.isotope = theIsotope;
            return this;
        }

        public boolean hasIsotope() {
            if (this.isotope == null) {
                return false;
            }
            for (SubstanceSpecificationStructureIsotopeComponent item : this.isotope) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SubstanceSpecificationStructureIsotopeComponent addIsotope() {
            SubstanceSpecificationStructureIsotopeComponent t = new SubstanceSpecificationStructureIsotopeComponent();
            if (this.isotope == null) {
                this.isotope = new ArrayList<SubstanceSpecificationStructureIsotopeComponent>();
            }
            this.isotope.add(t);
            return t;
        }

        public SubstanceSpecificationStructureComponent addIsotope(SubstanceSpecificationStructureIsotopeComponent t) {
            if (t == null) {
                return this;
            }
            if (this.isotope == null) {
                this.isotope = new ArrayList<SubstanceSpecificationStructureIsotopeComponent>();
            }
            this.isotope.add(t);
            return this;
        }

        public SubstanceSpecificationStructureIsotopeComponent getIsotopeFirstRep() {
            if (this.getIsotope().isEmpty()) {
                this.addIsotope();
            }
            return this.getIsotope().get(0);
        }

        public SubstanceSpecificationStructureIsotopeMolecularWeightComponent getMolecularWeight() {
            if (this.molecularWeight == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationStructureComponent.molecularWeight");
                }
                if (Configuration.doAutoCreate()) {
                    this.molecularWeight = new SubstanceSpecificationStructureIsotopeMolecularWeightComponent();
                }
            }
            return this.molecularWeight;
        }

        public boolean hasMolecularWeight() {
            return this.molecularWeight != null && !this.molecularWeight.isEmpty();
        }

        public SubstanceSpecificationStructureComponent setMolecularWeight(SubstanceSpecificationStructureIsotopeMolecularWeightComponent value) {
            this.molecularWeight = value;
            return this;
        }

        public List<Reference> getReferenceSource() {
            if (this.referenceSource == null) {
                this.referenceSource = new ArrayList<Reference>();
            }
            return this.referenceSource;
        }

        public SubstanceSpecificationStructureComponent setReferenceSource(List<Reference> theReferenceSource) {
            this.referenceSource = theReferenceSource;
            return this;
        }

        public boolean hasReferenceSource() {
            if (this.referenceSource == null) {
                return false;
            }
            for (Reference item : this.referenceSource) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addReferenceSource() {
            Reference t = new Reference();
            if (this.referenceSource == null) {
                this.referenceSource = new ArrayList<Reference>();
            }
            this.referenceSource.add(t);
            return t;
        }

        public SubstanceSpecificationStructureComponent addReferenceSource(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.referenceSource == null) {
                this.referenceSource = new ArrayList<Reference>();
            }
            this.referenceSource.add(t);
            return this;
        }

        public Reference getReferenceSourceFirstRep() {
            if (this.getReferenceSource().isEmpty()) {
                this.addReferenceSource();
            }
            return this.getReferenceSource().get(0);
        }

        @Deprecated
        public List<DocumentReference> getReferenceSourceTarget() {
            if (this.referenceSourceTarget == null) {
                this.referenceSourceTarget = new ArrayList<DocumentReference>();
            }
            return this.referenceSourceTarget;
        }

        @Deprecated
        public DocumentReference addReferenceSourceTarget() {
            DocumentReference r = new DocumentReference();
            if (this.referenceSourceTarget == null) {
                this.referenceSourceTarget = new ArrayList<DocumentReference>();
            }
            this.referenceSourceTarget.add(r);
            return r;
        }

        public List<SubstanceSpecificationStructureStructuralRepresentationComponent> getStructuralRepresentation() {
            if (this.structuralRepresentation == null) {
                this.structuralRepresentation = new ArrayList<SubstanceSpecificationStructureStructuralRepresentationComponent>();
            }
            return this.structuralRepresentation;
        }

        public SubstanceSpecificationStructureComponent setStructuralRepresentation(List<SubstanceSpecificationStructureStructuralRepresentationComponent> theStructuralRepresentation) {
            this.structuralRepresentation = theStructuralRepresentation;
            return this;
        }

        public boolean hasStructuralRepresentation() {
            if (this.structuralRepresentation == null) {
                return false;
            }
            for (SubstanceSpecificationStructureStructuralRepresentationComponent item : this.structuralRepresentation) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SubstanceSpecificationStructureStructuralRepresentationComponent addStructuralRepresentation() {
            SubstanceSpecificationStructureStructuralRepresentationComponent t = new SubstanceSpecificationStructureStructuralRepresentationComponent();
            if (this.structuralRepresentation == null) {
                this.structuralRepresentation = new ArrayList<SubstanceSpecificationStructureStructuralRepresentationComponent>();
            }
            this.structuralRepresentation.add(t);
            return t;
        }

        public SubstanceSpecificationStructureComponent addStructuralRepresentation(SubstanceSpecificationStructureStructuralRepresentationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.structuralRepresentation == null) {
                this.structuralRepresentation = new ArrayList<SubstanceSpecificationStructureStructuralRepresentationComponent>();
            }
            this.structuralRepresentation.add(t);
            return this;
        }

        public SubstanceSpecificationStructureStructuralRepresentationComponent getStructuralRepresentationFirstRep() {
            if (this.getStructuralRepresentation().isEmpty()) {
                this.addStructuralRepresentation();
            }
            return this.getStructuralRepresentation().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("stereochemistry", "CodeableConcept", "Stereochemistry type.", 0, 1, this.stereochemistry));
            children.add(new Property("opticalActivity", "CodeableConcept", "Optical activity type.", 0, 1, this.opticalActivity));
            children.add(new Property("molecularFormula", "string", "Molecular formula.", 0, 1, this.molecularFormula));
            children.add(new Property("molecularFormulaByMoiety", "string", "Specified per moiety according to the Hill system, i.e. first C, then H, then alphabetical. and each moiety separated by a dot.", 0, 1, this.molecularFormulaByMoiety));
            children.add(new Property("isotope", "", "Applicable for single substances that contain a radionuclide or a non-natural isotopic ratio.", 0, Integer.MAX_VALUE, this.isotope));
            children.add(new Property("molecularWeight", "@SubstanceSpecification.structure.isotope.molecularWeight", "The molecular weight or weight range (for proteins, polymers or nucleic acids).", 0, 1, this.molecularWeight));
            children.add(new Property("referenceSource", "Reference(DocumentReference)", "Supporting literature.", 0, Integer.MAX_VALUE, this.referenceSource));
            children.add(new Property("structuralRepresentation", "", "Molectular structural representation.", 0, Integer.MAX_VALUE, this.structuralRepresentation));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 263475116: {
                    return new Property("stereochemistry", "CodeableConcept", "Stereochemistry type.", 0, 1, this.stereochemistry);
                }
                case 1420900135: {
                    return new Property("opticalActivity", "CodeableConcept", "Optical activity type.", 0, 1, this.opticalActivity);
                }
                case 616660246: {
                    return new Property("molecularFormula", "string", "Molecular formula.", 0, 1, this.molecularFormula);
                }
                case 1315452848: {
                    return new Property("molecularFormulaByMoiety", "string", "Specified per moiety according to the Hill system, i.e. first C, then H, then alphabetical. and each moiety separated by a dot.", 0, 1, this.molecularFormulaByMoiety);
                }
                case 2097035189: {
                    return new Property("isotope", "", "Applicable for single substances that contain a radionuclide or a non-natural isotopic ratio.", 0, Integer.MAX_VALUE, this.isotope);
                }
                case 635625672: {
                    return new Property("molecularWeight", "@SubstanceSpecification.structure.isotope.molecularWeight", "The molecular weight or weight range (for proteins, polymers or nucleic acids).", 0, 1, this.molecularWeight);
                }
                case 882421574: {
                    return new Property("referenceSource", "Reference(DocumentReference)", "Supporting literature.", 0, Integer.MAX_VALUE, this.referenceSource);
                }
                case 14311178: {
                    return new Property("structuralRepresentation", "", "Molectular structural representation.", 0, Integer.MAX_VALUE, this.structuralRepresentation);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 263475116: {
                    Base[] baseArray;
                    if (this.stereochemistry == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.stereochemistry;
                    }
                    return baseArray;
                }
                case 1420900135: {
                    Base[] baseArray;
                    if (this.opticalActivity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.opticalActivity;
                    }
                    return baseArray;
                }
                case 616660246: {
                    Base[] baseArray;
                    if (this.molecularFormula == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.molecularFormula;
                    }
                    return baseArray;
                }
                case 1315452848: {
                    Base[] baseArray;
                    if (this.molecularFormulaByMoiety == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.molecularFormulaByMoiety;
                    }
                    return baseArray;
                }
                case 2097035189: {
                    return this.isotope == null ? new Base[]{} : this.isotope.toArray(new Base[this.isotope.size()]);
                }
                case 635625672: {
                    Base[] baseArray;
                    if (this.molecularWeight == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.molecularWeight;
                    }
                    return baseArray;
                }
                case 882421574: {
                    return this.referenceSource == null ? new Base[]{} : this.referenceSource.toArray(new Base[this.referenceSource.size()]);
                }
                case 14311178: {
                    return this.structuralRepresentation == null ? new Base[]{} : this.structuralRepresentation.toArray(new Base[this.structuralRepresentation.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 263475116: {
                    this.stereochemistry = this.castToCodeableConcept(value);
                    return value;
                }
                case 1420900135: {
                    this.opticalActivity = this.castToCodeableConcept(value);
                    return value;
                }
                case 616660246: {
                    this.molecularFormula = this.castToString(value);
                    return value;
                }
                case 1315452848: {
                    this.molecularFormulaByMoiety = this.castToString(value);
                    return value;
                }
                case 2097035189: {
                    this.getIsotope().add((SubstanceSpecificationStructureIsotopeComponent)value);
                    return value;
                }
                case 635625672: {
                    this.molecularWeight = (SubstanceSpecificationStructureIsotopeMolecularWeightComponent)value;
                    return value;
                }
                case 882421574: {
                    this.getReferenceSource().add(this.castToReference(value));
                    return value;
                }
                case 14311178: {
                    this.getStructuralRepresentation().add((SubstanceSpecificationStructureStructuralRepresentationComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("stereochemistry")) {
                this.stereochemistry = this.castToCodeableConcept(value);
            } else if (name.equals("opticalActivity")) {
                this.opticalActivity = this.castToCodeableConcept(value);
            } else if (name.equals("molecularFormula")) {
                this.molecularFormula = this.castToString(value);
            } else if (name.equals("molecularFormulaByMoiety")) {
                this.molecularFormulaByMoiety = this.castToString(value);
            } else if (name.equals("isotope")) {
                this.getIsotope().add((SubstanceSpecificationStructureIsotopeComponent)value);
            } else if (name.equals("molecularWeight")) {
                this.molecularWeight = (SubstanceSpecificationStructureIsotopeMolecularWeightComponent)value;
            } else if (name.equals("referenceSource")) {
                this.getReferenceSource().add(this.castToReference(value));
            } else if (name.equals("structuralRepresentation")) {
                this.getStructuralRepresentation().add((SubstanceSpecificationStructureStructuralRepresentationComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 263475116: {
                    return this.getStereochemistry();
                }
                case 1420900135: {
                    return this.getOpticalActivity();
                }
                case 616660246: {
                    return this.getMolecularFormulaElement();
                }
                case 1315452848: {
                    return this.getMolecularFormulaByMoietyElement();
                }
                case 2097035189: {
                    return this.addIsotope();
                }
                case 635625672: {
                    return this.getMolecularWeight();
                }
                case 882421574: {
                    return this.addReferenceSource();
                }
                case 14311178: {
                    return this.addStructuralRepresentation();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 263475116: {
                    return new String[]{"CodeableConcept"};
                }
                case 1420900135: {
                    return new String[]{"CodeableConcept"};
                }
                case 616660246: {
                    return new String[]{"string"};
                }
                case 1315452848: {
                    return new String[]{"string"};
                }
                case 2097035189: {
                    return new String[0];
                }
                case 635625672: {
                    return new String[]{"@SubstanceSpecification.structure.isotope.molecularWeight"};
                }
                case 882421574: {
                    return new String[]{"Reference"};
                }
                case 14311178: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("stereochemistry")) {
                this.stereochemistry = new CodeableConcept();
                return this.stereochemistry;
            }
            if (name.equals("opticalActivity")) {
                this.opticalActivity = new CodeableConcept();
                return this.opticalActivity;
            }
            if (name.equals("molecularFormula")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceSpecification.molecularFormula");
            }
            if (name.equals("molecularFormulaByMoiety")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceSpecification.molecularFormulaByMoiety");
            }
            if (name.equals("isotope")) {
                return this.addIsotope();
            }
            if (name.equals("molecularWeight")) {
                this.molecularWeight = new SubstanceSpecificationStructureIsotopeMolecularWeightComponent();
                return this.molecularWeight;
            }
            if (name.equals("referenceSource")) {
                return this.addReferenceSource();
            }
            if (name.equals("structuralRepresentation")) {
                return this.addStructuralRepresentation();
            }
            return super.addChild(name);
        }

        @Override
        public SubstanceSpecificationStructureComponent copy() {
            SubstanceSpecificationStructureComponent dst = new SubstanceSpecificationStructureComponent();
            this.copyValues(dst);
            dst.stereochemistry = this.stereochemistry == null ? null : this.stereochemistry.copy();
            dst.opticalActivity = this.opticalActivity == null ? null : this.opticalActivity.copy();
            dst.molecularFormula = this.molecularFormula == null ? null : this.molecularFormula.copy();
            StringType stringType = dst.molecularFormulaByMoiety = this.molecularFormulaByMoiety == null ? null : this.molecularFormulaByMoiety.copy();
            if (this.isotope != null) {
                dst.isotope = new ArrayList<SubstanceSpecificationStructureIsotopeComponent>();
                for (SubstanceSpecificationStructureIsotopeComponent substanceSpecificationStructureIsotopeComponent : this.isotope) {
                    dst.isotope.add(substanceSpecificationStructureIsotopeComponent.copy());
                }
            }
            SubstanceSpecificationStructureIsotopeMolecularWeightComponent substanceSpecificationStructureIsotopeMolecularWeightComponent = dst.molecularWeight = this.molecularWeight == null ? null : this.molecularWeight.copy();
            if (this.referenceSource != null) {
                dst.referenceSource = new ArrayList<Reference>();
                for (Reference reference : this.referenceSource) {
                    dst.referenceSource.add(reference.copy());
                }
            }
            if (this.structuralRepresentation != null) {
                dst.structuralRepresentation = new ArrayList<SubstanceSpecificationStructureStructuralRepresentationComponent>();
                for (SubstanceSpecificationStructureStructuralRepresentationComponent substanceSpecificationStructureStructuralRepresentationComponent : this.structuralRepresentation) {
                    dst.structuralRepresentation.add(substanceSpecificationStructureStructuralRepresentationComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSpecificationStructureComponent)) {
                return false;
            }
            SubstanceSpecificationStructureComponent o = (SubstanceSpecificationStructureComponent)other_;
            return SubstanceSpecificationStructureComponent.compareDeep(this.stereochemistry, o.stereochemistry, true) && SubstanceSpecificationStructureComponent.compareDeep(this.opticalActivity, o.opticalActivity, true) && SubstanceSpecificationStructureComponent.compareDeep(this.molecularFormula, o.molecularFormula, true) && SubstanceSpecificationStructureComponent.compareDeep(this.molecularFormulaByMoiety, o.molecularFormulaByMoiety, true) && SubstanceSpecificationStructureComponent.compareDeep(this.isotope, o.isotope, true) && SubstanceSpecificationStructureComponent.compareDeep(this.molecularWeight, o.molecularWeight, true) && SubstanceSpecificationStructureComponent.compareDeep(this.referenceSource, o.referenceSource, true) && SubstanceSpecificationStructureComponent.compareDeep(this.structuralRepresentation, o.structuralRepresentation, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSpecificationStructureComponent)) {
                return false;
            }
            SubstanceSpecificationStructureComponent o = (SubstanceSpecificationStructureComponent)other_;
            return SubstanceSpecificationStructureComponent.compareValues(this.molecularFormula, o.molecularFormula, true) && SubstanceSpecificationStructureComponent.compareValues(this.molecularFormulaByMoiety, o.molecularFormulaByMoiety, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.stereochemistry, this.opticalActivity, this.molecularFormula, this.molecularFormulaByMoiety, this.isotope, this.molecularWeight, this.referenceSource, this.structuralRepresentation});
        }

        @Override
        public String fhirType() {
            return "SubstanceSpecification.structure";
        }
    }

    @Block
    public static class SubstanceSpecificationPropertyComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Description todo", formalDefinition="Description todo.")
        protected CodeableConcept type;
        @Child(name="name", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Description todo", formalDefinition="Description todo.")
        protected CodeableConcept name;
        @Child(name="parameters", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A field that should be used to capture parameters that were used in the measurement of a property", formalDefinition="A field that should be used to capture parameters that were used in the measurement of a property.")
        protected StringType parameters;
        @Child(name="substanceId", type={Identifier.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Identifier for a substance upon which a defining property depends", formalDefinition="Identifier for a substance upon which a defining property depends.")
        protected Identifier substanceId;
        @Child(name="substanceName", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Description todo", formalDefinition="Description todo.")
        protected StringType substanceName;
        @Child(name="amount", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Quantitative value for this property", formalDefinition="Quantitative value for this property.")
        protected StringType amount;
        private static final long serialVersionUID = 83235941L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationPropertyComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public SubstanceSpecificationPropertyComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public CodeableConcept getName() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationPropertyComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new CodeableConcept();
                }
            }
            return this.name;
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public SubstanceSpecificationPropertyComponent setName(CodeableConcept value) {
            this.name = value;
            return this;
        }

        public StringType getParametersElement() {
            if (this.parameters == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationPropertyComponent.parameters");
                }
                if (Configuration.doAutoCreate()) {
                    this.parameters = new StringType();
                }
            }
            return this.parameters;
        }

        public boolean hasParametersElement() {
            return this.parameters != null && !this.parameters.isEmpty();
        }

        public boolean hasParameters() {
            return this.parameters != null && !this.parameters.isEmpty();
        }

        public SubstanceSpecificationPropertyComponent setParametersElement(StringType value) {
            this.parameters = value;
            return this;
        }

        public String getParameters() {
            return this.parameters == null ? null : (String)this.parameters.getValue();
        }

        public SubstanceSpecificationPropertyComponent setParameters(String value) {
            if (Utilities.noString((String)value)) {
                this.parameters = null;
            } else {
                if (this.parameters == null) {
                    this.parameters = new StringType();
                }
                this.parameters.setValue(value);
            }
            return this;
        }

        public Identifier getSubstanceId() {
            if (this.substanceId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationPropertyComponent.substanceId");
                }
                if (Configuration.doAutoCreate()) {
                    this.substanceId = new Identifier();
                }
            }
            return this.substanceId;
        }

        public boolean hasSubstanceId() {
            return this.substanceId != null && !this.substanceId.isEmpty();
        }

        public SubstanceSpecificationPropertyComponent setSubstanceId(Identifier value) {
            this.substanceId = value;
            return this;
        }

        public StringType getSubstanceNameElement() {
            if (this.substanceName == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationPropertyComponent.substanceName");
                }
                if (Configuration.doAutoCreate()) {
                    this.substanceName = new StringType();
                }
            }
            return this.substanceName;
        }

        public boolean hasSubstanceNameElement() {
            return this.substanceName != null && !this.substanceName.isEmpty();
        }

        public boolean hasSubstanceName() {
            return this.substanceName != null && !this.substanceName.isEmpty();
        }

        public SubstanceSpecificationPropertyComponent setSubstanceNameElement(StringType value) {
            this.substanceName = value;
            return this;
        }

        public String getSubstanceName() {
            return this.substanceName == null ? null : (String)this.substanceName.getValue();
        }

        public SubstanceSpecificationPropertyComponent setSubstanceName(String value) {
            if (Utilities.noString((String)value)) {
                this.substanceName = null;
            } else {
                if (this.substanceName == null) {
                    this.substanceName = new StringType();
                }
                this.substanceName.setValue(value);
            }
            return this;
        }

        public StringType getAmountElement() {
            if (this.amount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationPropertyComponent.amount");
                }
                if (Configuration.doAutoCreate()) {
                    this.amount = new StringType();
                }
            }
            return this.amount;
        }

        public boolean hasAmountElement() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public SubstanceSpecificationPropertyComponent setAmountElement(StringType value) {
            this.amount = value;
            return this;
        }

        public String getAmount() {
            return this.amount == null ? null : (String)this.amount.getValue();
        }

        public SubstanceSpecificationPropertyComponent setAmount(String value) {
            if (Utilities.noString((String)value)) {
                this.amount = null;
            } else {
                if (this.amount == null) {
                    this.amount = new StringType();
                }
                this.amount.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "Description todo.", 0, 1, this.type));
            children.add(new Property("name", "CodeableConcept", "Description todo.", 0, 1, this.name));
            children.add(new Property("parameters", "string", "A field that should be used to capture parameters that were used in the measurement of a property.", 0, 1, this.parameters));
            children.add(new Property("substanceId", "Identifier", "Identifier for a substance upon which a defining property depends.", 0, 1, this.substanceId));
            children.add(new Property("substanceName", "string", "Description todo.", 0, 1, this.substanceName));
            children.add(new Property("amount", "string", "Quantitative value for this property.", 0, 1, this.amount));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Description todo.", 0, 1, this.type);
                }
                case 3373707: {
                    return new Property("name", "CodeableConcept", "Description todo.", 0, 1, this.name);
                }
                case 458736106: {
                    return new Property("parameters", "string", "A field that should be used to capture parameters that were used in the measurement of a property.", 0, 1, this.parameters);
                }
                case -1732496725: {
                    return new Property("substanceId", "Identifier", "Identifier for a substance upon which a defining property depends.", 0, 1, this.substanceId);
                }
                case 1518107675: {
                    return new Property("substanceName", "string", "Description todo.", 0, 1, this.substanceName);
                }
                case -1413853096: {
                    return new Property("amount", "string", "Quantitative value for this property.", 0, 1, this.amount);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.name;
                    }
                    return baseArray;
                }
                case 458736106: {
                    Base[] baseArray;
                    if (this.parameters == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.parameters;
                    }
                    return baseArray;
                }
                case -1732496725: {
                    Base[] baseArray;
                    if (this.substanceId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.substanceId;
                    }
                    return baseArray;
                }
                case 1518107675: {
                    Base[] baseArray;
                    if (this.substanceName == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.substanceName;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.amount;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case 3373707: {
                    this.name = this.castToCodeableConcept(value);
                    return value;
                }
                case 458736106: {
                    this.parameters = this.castToString(value);
                    return value;
                }
                case -1732496725: {
                    this.substanceId = this.castToIdentifier(value);
                    return value;
                }
                case 1518107675: {
                    this.substanceName = this.castToString(value);
                    return value;
                }
                case -1413853096: {
                    this.amount = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("name")) {
                this.name = this.castToCodeableConcept(value);
            } else if (name.equals("parameters")) {
                this.parameters = this.castToString(value);
            } else if (name.equals("substanceId")) {
                this.substanceId = this.castToIdentifier(value);
            } else if (name.equals("substanceName")) {
                this.substanceName = this.castToString(value);
            } else if (name.equals("amount")) {
                this.amount = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 3373707: {
                    return this.getName();
                }
                case 458736106: {
                    return this.getParametersElement();
                }
                case -1732496725: {
                    return this.getSubstanceId();
                }
                case 1518107675: {
                    return this.getSubstanceNameElement();
                }
                case -1413853096: {
                    return this.getAmountElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 3373707: {
                    return new String[]{"CodeableConcept"};
                }
                case 458736106: {
                    return new String[]{"string"};
                }
                case -1732496725: {
                    return new String[]{"Identifier"};
                }
                case 1518107675: {
                    return new String[]{"string"};
                }
                case -1413853096: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("name")) {
                this.name = new CodeableConcept();
                return this.name;
            }
            if (name.equals("parameters")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceSpecification.parameters");
            }
            if (name.equals("substanceId")) {
                this.substanceId = new Identifier();
                return this.substanceId;
            }
            if (name.equals("substanceName")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceSpecification.substanceName");
            }
            if (name.equals("amount")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceSpecification.amount");
            }
            return super.addChild(name);
        }

        @Override
        public SubstanceSpecificationPropertyComponent copy() {
            SubstanceSpecificationPropertyComponent dst = new SubstanceSpecificationPropertyComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.name = this.name == null ? null : this.name.copy();
            dst.parameters = this.parameters == null ? null : this.parameters.copy();
            dst.substanceId = this.substanceId == null ? null : this.substanceId.copy();
            dst.substanceName = this.substanceName == null ? null : this.substanceName.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSpecificationPropertyComponent)) {
                return false;
            }
            SubstanceSpecificationPropertyComponent o = (SubstanceSpecificationPropertyComponent)other_;
            return SubstanceSpecificationPropertyComponent.compareDeep(this.type, o.type, true) && SubstanceSpecificationPropertyComponent.compareDeep(this.name, o.name, true) && SubstanceSpecificationPropertyComponent.compareDeep(this.parameters, o.parameters, true) && SubstanceSpecificationPropertyComponent.compareDeep(this.substanceId, o.substanceId, true) && SubstanceSpecificationPropertyComponent.compareDeep(this.substanceName, o.substanceName, true) && SubstanceSpecificationPropertyComponent.compareDeep(this.amount, o.amount, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSpecificationPropertyComponent)) {
                return false;
            }
            SubstanceSpecificationPropertyComponent o = (SubstanceSpecificationPropertyComponent)other_;
            return SubstanceSpecificationPropertyComponent.compareValues(this.parameters, o.parameters, true) && SubstanceSpecificationPropertyComponent.compareValues(this.substanceName, o.substanceName, true) && SubstanceSpecificationPropertyComponent.compareValues(this.amount, o.amount, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.name, this.parameters, this.substanceId, this.substanceName, this.amount});
        }

        @Override
        public String fhirType() {
            return "SubstanceSpecification.property";
        }
    }

    @Block
    public static class SubstanceSpecificationMoietyComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="role", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Role that the moiety is playing", formalDefinition="Role that the moiety is playing.")
        protected CodeableConcept role;
        @Child(name="identifier", type={Identifier.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Identifier by which this moiety substance is known", formalDefinition="Identifier by which this moiety substance is known.")
        protected Identifier identifier;
        @Child(name="name", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Textual name for this moiety substance", formalDefinition="Textual name for this moiety substance.")
        protected StringType name;
        @Child(name="stereochemistry", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Stereochemistry type", formalDefinition="Stereochemistry type.")
        protected CodeableConcept stereochemistry;
        @Child(name="opticalActivity", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Optical activity type", formalDefinition="Optical activity type.")
        protected CodeableConcept opticalActivity;
        @Child(name="molecularFormula", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Molecular formula", formalDefinition="Molecular formula.")
        protected StringType molecularFormula;
        @Child(name="amount", type={StringType.class}, order=7, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Quantitative value for this moiety", formalDefinition="Quantitative value for this moiety.")
        protected StringType amount;
        private static final long serialVersionUID = 45594592L;

        public CodeableConcept getRole() {
            if (this.role == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationMoietyComponent.role");
                }
                if (Configuration.doAutoCreate()) {
                    this.role = new CodeableConcept();
                }
            }
            return this.role;
        }

        public boolean hasRole() {
            return this.role != null && !this.role.isEmpty();
        }

        public SubstanceSpecificationMoietyComponent setRole(CodeableConcept value) {
            this.role = value;
            return this;
        }

        public Identifier getIdentifier() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationMoietyComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new Identifier();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public SubstanceSpecificationMoietyComponent setIdentifier(Identifier value) {
            this.identifier = value;
            return this;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationMoietyComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public SubstanceSpecificationMoietyComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public SubstanceSpecificationMoietyComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public CodeableConcept getStereochemistry() {
            if (this.stereochemistry == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationMoietyComponent.stereochemistry");
                }
                if (Configuration.doAutoCreate()) {
                    this.stereochemistry = new CodeableConcept();
                }
            }
            return this.stereochemistry;
        }

        public boolean hasStereochemistry() {
            return this.stereochemistry != null && !this.stereochemistry.isEmpty();
        }

        public SubstanceSpecificationMoietyComponent setStereochemistry(CodeableConcept value) {
            this.stereochemistry = value;
            return this;
        }

        public CodeableConcept getOpticalActivity() {
            if (this.opticalActivity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationMoietyComponent.opticalActivity");
                }
                if (Configuration.doAutoCreate()) {
                    this.opticalActivity = new CodeableConcept();
                }
            }
            return this.opticalActivity;
        }

        public boolean hasOpticalActivity() {
            return this.opticalActivity != null && !this.opticalActivity.isEmpty();
        }

        public SubstanceSpecificationMoietyComponent setOpticalActivity(CodeableConcept value) {
            this.opticalActivity = value;
            return this;
        }

        public StringType getMolecularFormulaElement() {
            if (this.molecularFormula == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationMoietyComponent.molecularFormula");
                }
                if (Configuration.doAutoCreate()) {
                    this.molecularFormula = new StringType();
                }
            }
            return this.molecularFormula;
        }

        public boolean hasMolecularFormulaElement() {
            return this.molecularFormula != null && !this.molecularFormula.isEmpty();
        }

        public boolean hasMolecularFormula() {
            return this.molecularFormula != null && !this.molecularFormula.isEmpty();
        }

        public SubstanceSpecificationMoietyComponent setMolecularFormulaElement(StringType value) {
            this.molecularFormula = value;
            return this;
        }

        public String getMolecularFormula() {
            return this.molecularFormula == null ? null : (String)this.molecularFormula.getValue();
        }

        public SubstanceSpecificationMoietyComponent setMolecularFormula(String value) {
            if (Utilities.noString((String)value)) {
                this.molecularFormula = null;
            } else {
                if (this.molecularFormula == null) {
                    this.molecularFormula = new StringType();
                }
                this.molecularFormula.setValue(value);
            }
            return this;
        }

        public StringType getAmountElement() {
            if (this.amount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubstanceSpecificationMoietyComponent.amount");
                }
                if (Configuration.doAutoCreate()) {
                    this.amount = new StringType();
                }
            }
            return this.amount;
        }

        public boolean hasAmountElement() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public SubstanceSpecificationMoietyComponent setAmountElement(StringType value) {
            this.amount = value;
            return this;
        }

        public String getAmount() {
            return this.amount == null ? null : (String)this.amount.getValue();
        }

        public SubstanceSpecificationMoietyComponent setAmount(String value) {
            if (Utilities.noString((String)value)) {
                this.amount = null;
            } else {
                if (this.amount == null) {
                    this.amount = new StringType();
                }
                this.amount.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("role", "CodeableConcept", "Role that the moiety is playing.", 0, 1, this.role));
            children.add(new Property("identifier", "Identifier", "Identifier by which this moiety substance is known.", 0, 1, this.identifier));
            children.add(new Property("name", "string", "Textual name for this moiety substance.", 0, 1, this.name));
            children.add(new Property("stereochemistry", "CodeableConcept", "Stereochemistry type.", 0, 1, this.stereochemistry));
            children.add(new Property("opticalActivity", "CodeableConcept", "Optical activity type.", 0, 1, this.opticalActivity));
            children.add(new Property("molecularFormula", "string", "Molecular formula.", 0, 1, this.molecularFormula));
            children.add(new Property("amount", "string", "Quantitative value for this moiety.", 0, 1, this.amount));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3506294: {
                    return new Property("role", "CodeableConcept", "Role that the moiety is playing.", 0, 1, this.role);
                }
                case -1618432855: {
                    return new Property("identifier", "Identifier", "Identifier by which this moiety substance is known.", 0, 1, this.identifier);
                }
                case 3373707: {
                    return new Property("name", "string", "Textual name for this moiety substance.", 0, 1, this.name);
                }
                case 263475116: {
                    return new Property("stereochemistry", "CodeableConcept", "Stereochemistry type.", 0, 1, this.stereochemistry);
                }
                case 1420900135: {
                    return new Property("opticalActivity", "CodeableConcept", "Optical activity type.", 0, 1, this.opticalActivity);
                }
                case 616660246: {
                    return new Property("molecularFormula", "string", "Molecular formula.", 0, 1, this.molecularFormula);
                }
                case -1413853096: {
                    return new Property("amount", "string", "Quantitative value for this moiety.", 0, 1, this.amount);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    Base[] baseArray;
                    if (this.role == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.role;
                    }
                    return baseArray;
                }
                case -1618432855: {
                    Base[] baseArray;
                    if (this.identifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.identifier;
                    }
                    return baseArray;
                }
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.name;
                    }
                    return baseArray;
                }
                case 263475116: {
                    Base[] baseArray;
                    if (this.stereochemistry == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.stereochemistry;
                    }
                    return baseArray;
                }
                case 1420900135: {
                    Base[] baseArray;
                    if (this.opticalActivity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.opticalActivity;
                    }
                    return baseArray;
                }
                case 616660246: {
                    Base[] baseArray;
                    if (this.molecularFormula == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.molecularFormula;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.amount;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    this.role = this.castToCodeableConcept(value);
                    return value;
                }
                case -1618432855: {
                    this.identifier = this.castToIdentifier(value);
                    return value;
                }
                case 3373707: {
                    this.name = this.castToString(value);
                    return value;
                }
                case 263475116: {
                    this.stereochemistry = this.castToCodeableConcept(value);
                    return value;
                }
                case 1420900135: {
                    this.opticalActivity = this.castToCodeableConcept(value);
                    return value;
                }
                case 616660246: {
                    this.molecularFormula = this.castToString(value);
                    return value;
                }
                case -1413853096: {
                    this.amount = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("role")) {
                this.role = this.castToCodeableConcept(value);
            } else if (name.equals("identifier")) {
                this.identifier = this.castToIdentifier(value);
            } else if (name.equals("name")) {
                this.name = this.castToString(value);
            } else if (name.equals("stereochemistry")) {
                this.stereochemistry = this.castToCodeableConcept(value);
            } else if (name.equals("opticalActivity")) {
                this.opticalActivity = this.castToCodeableConcept(value);
            } else if (name.equals("molecularFormula")) {
                this.molecularFormula = this.castToString(value);
            } else if (name.equals("amount")) {
                this.amount = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    return this.getRole();
                }
                case -1618432855: {
                    return this.getIdentifier();
                }
                case 3373707: {
                    return this.getNameElement();
                }
                case 263475116: {
                    return this.getStereochemistry();
                }
                case 1420900135: {
                    return this.getOpticalActivity();
                }
                case 616660246: {
                    return this.getMolecularFormulaElement();
                }
                case -1413853096: {
                    return this.getAmountElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    return new String[]{"CodeableConcept"};
                }
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
                case 3373707: {
                    return new String[]{"string"};
                }
                case 263475116: {
                    return new String[]{"CodeableConcept"};
                }
                case 1420900135: {
                    return new String[]{"CodeableConcept"};
                }
                case 616660246: {
                    return new String[]{"string"};
                }
                case -1413853096: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("role")) {
                this.role = new CodeableConcept();
                return this.role;
            }
            if (name.equals("identifier")) {
                this.identifier = new Identifier();
                return this.identifier;
            }
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceSpecification.name");
            }
            if (name.equals("stereochemistry")) {
                this.stereochemistry = new CodeableConcept();
                return this.stereochemistry;
            }
            if (name.equals("opticalActivity")) {
                this.opticalActivity = new CodeableConcept();
                return this.opticalActivity;
            }
            if (name.equals("molecularFormula")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceSpecification.molecularFormula");
            }
            if (name.equals("amount")) {
                throw new FHIRException("Cannot call addChild on a primitive type SubstanceSpecification.amount");
            }
            return super.addChild(name);
        }

        @Override
        public SubstanceSpecificationMoietyComponent copy() {
            SubstanceSpecificationMoietyComponent dst = new SubstanceSpecificationMoietyComponent();
            this.copyValues(dst);
            dst.role = this.role == null ? null : this.role.copy();
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
            dst.name = this.name == null ? null : this.name.copy();
            dst.stereochemistry = this.stereochemistry == null ? null : this.stereochemistry.copy();
            dst.opticalActivity = this.opticalActivity == null ? null : this.opticalActivity.copy();
            dst.molecularFormula = this.molecularFormula == null ? null : this.molecularFormula.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSpecificationMoietyComponent)) {
                return false;
            }
            SubstanceSpecificationMoietyComponent o = (SubstanceSpecificationMoietyComponent)other_;
            return SubstanceSpecificationMoietyComponent.compareDeep(this.role, o.role, true) && SubstanceSpecificationMoietyComponent.compareDeep(this.identifier, o.identifier, true) && SubstanceSpecificationMoietyComponent.compareDeep(this.name, o.name, true) && SubstanceSpecificationMoietyComponent.compareDeep(this.stereochemistry, o.stereochemistry, true) && SubstanceSpecificationMoietyComponent.compareDeep(this.opticalActivity, o.opticalActivity, true) && SubstanceSpecificationMoietyComponent.compareDeep(this.molecularFormula, o.molecularFormula, true) && SubstanceSpecificationMoietyComponent.compareDeep(this.amount, o.amount, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubstanceSpecificationMoietyComponent)) {
                return false;
            }
            SubstanceSpecificationMoietyComponent o = (SubstanceSpecificationMoietyComponent)other_;
            return SubstanceSpecificationMoietyComponent.compareValues(this.name, o.name, true) && SubstanceSpecificationMoietyComponent.compareValues(this.molecularFormula, o.molecularFormula, true) && SubstanceSpecificationMoietyComponent.compareValues(this.amount, o.amount, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.role, this.identifier, this.name, this.stereochemistry, this.opticalActivity, this.molecularFormula, this.amount});
        }

        @Override
        public String fhirType() {
            return "SubstanceSpecification.moiety";
        }
    }
}

