/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.utils.ToolingExtensions;

@DatatypeDef(name="string")
public class StringType
extends PrimitiveType<String> {
    private static final long serialVersionUID = 3L;

    public StringType() {
    }

    public StringType(String theValue) {
        this.setValue(theValue);
    }

    public String getValueNotNull() {
        return StringUtils.defaultString((String)((String)this.getValue()));
    }

    @Override
    public String toString() {
        return (String)this.getValue();
    }

    @Override
    protected String parse(String theValue) {
        return theValue;
    }

    @Override
    protected String encode(String theValue) {
        return theValue;
    }

    @Override
    public StringType copy() {
        return new StringType((String)this.getValue());
    }

    @Override
    public String fhirType() {
        return "string";
    }

    public String getTranslation(String l) throws FHIRException {
        for (Extension e : this.getExtension()) {
            String lang;
            if (!e.getUrl().equals("http://hl7.org/fhir/StructureDefinition/translation") || !(lang = ToolingExtensions.readStringExtension(e, "lang")).equals(l)) continue;
            return e.getExtensionString("content");
        }
        return null;
    }
}

