/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Endpoint;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.HealthcareService;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Location;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.TimeType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="OrganizationRole", profile="http://hl7.org/fhir/Profile/OrganizationRole")
public class OrganizationRole
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business Identifiers that are specific to a role/location", formalDefinition="Business Identifiers that are specific to a role/location.")
    protected List<Identifier> identifier;
    @Child(name="active", type={BooleanType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Whether this practitioner role record is in active use", formalDefinition="Whether this practitioner role record is in active use.")
    protected BooleanType active;
    @Child(name="period", type={Period.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The period during which the practitioner is authorized to perform in these role(s)", formalDefinition="The period during which the person is authorized to act as a practitioner in these role(s) for the organization.")
    protected Period period;
    @Child(name="organization", type={Organization.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Organization where the roles are available", formalDefinition="The organization where the Practitioner performs the roles associated.")
    protected Reference organization;
    protected Organization organizationTarget;
    @Child(name="participatingOrganization", type={Organization.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Practitioner that is able to provide the defined services for the organization", formalDefinition="Practitioner that is able to provide the defined services for the organization.")
    protected Reference participatingOrganization;
    protected Organization participatingOrganizationTarget;
    @Child(name="network", type={Organization.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The network(s) this association applies to", formalDefinition="The network(s) this association applies to (if any).")
    protected List<Reference> network;
    protected List<Organization> networkTarget;
    @Child(name="code", type={CodeableConcept.class}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Roles which this practitioner may perform", formalDefinition="Roles which this practitioner is authorized to perform for the organization.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/organization-role")
    protected List<CodeableConcept> code;
    @Child(name="specialty", type={CodeableConcept.class}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Specific specialty of the practitioner", formalDefinition="Specific specialty of the practitioner.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/c80-practice-codes")
    protected List<CodeableConcept> specialty;
    @Child(name="location", type={Location.class}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The location(s) at which this practitioner provides care", formalDefinition="The location(s) at which this practitioner provides care.")
    protected List<Reference> location;
    protected List<Location> locationTarget;
    @Child(name="healthcareService", type={HealthcareService.class}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The list of healthcare services that this worker provides for this role's Organization/Location(s)", formalDefinition="The list of healthcare services that this worker provides for this role's Organization/Location(s).")
    protected List<Reference> healthcareService;
    protected List<HealthcareService> healthcareServiceTarget;
    @Child(name="telecom", type={ContactPoint.class}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details that are specific to the role/location/service", formalDefinition="Contact details that are specific to the role/location/service.")
    protected List<ContactPoint> telecom;
    @Child(name="availableTime", type={}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Times the Service Site is available", formalDefinition="A collection of times that the Service Site is available.")
    protected List<OrganizationRoleAvailableTimeComponent> availableTime;
    @Child(name="notAvailable", type={}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Not available during this time due to provided reason", formalDefinition="The HealthcareService is not available during this period of time due to the provided reason.")
    protected List<OrganizationRoleNotAvailableComponent> notAvailable;
    @Child(name="availabilityExceptions", type={StringType.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Description of availability exceptions", formalDefinition="A description of site availability exceptions, e.g. public holiday availability. Succinctly describing all possible exceptions to normal site availability as details in the available Times and not available Times.")
    protected StringType availabilityExceptions;
    @Child(name="endpoint", type={Endpoint.class}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Technical endpoints providing access to services operated for the practitioner with this role", formalDefinition="Technical endpoints providing access to services operated for the practitioner with this role.")
    protected List<Reference> endpoint;
    protected List<Endpoint> endpointTarget;
    private static final long serialVersionUID = 1850231735L;
    @SearchParamDefinition(name="date", path="OrganizationRole.period", description="The period during which the practitioner is authorized to perform in these role(s)", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="OrganizationRole.identifier", description="A practitioner's Identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="specialty", path="OrganizationRole.specialty", description="The practitioner has this specialty at an organization", type="token")
    public static final String SP_SPECIALTY = "specialty";
    public static final TokenClientParam SPECIALTY = new TokenClientParam("specialty");
    @SearchParamDefinition(name="role", path="OrganizationRole.code", description="The practitioner can perform this role at for the organization", type="token")
    public static final String SP_ROLE = "role";
    public static final TokenClientParam ROLE = new TokenClientParam("role");
    @SearchParamDefinition(name="active", path="OrganizationRole.active", description="Whether this practitioner role record is in active use", type="token")
    public static final String SP_ACTIVE = "active";
    public static final TokenClientParam ACTIVE = new TokenClientParam("active");
    @SearchParamDefinition(name="primary-organization", path="OrganizationRole.organization", description="The identity of the organization the practitioner represents / acts on behalf of", type="reference", target={Organization.class})
    public static final String SP_PRIMARY_ORGANIZATION = "primary-organization";
    public static final ReferenceClientParam PRIMARY_ORGANIZATION = new ReferenceClientParam("primary-organization");
    public static final Include INCLUDE_PRIMARY_ORGANIZATION = new Include("OrganizationRole:primary-organization").toLocked();
    @SearchParamDefinition(name="network", path="OrganizationRole.network", description="One of the locations at which this practitioner provides care", type="reference", target={Organization.class})
    public static final String SP_NETWORK = "network";
    public static final ReferenceClientParam NETWORK = new ReferenceClientParam("network");
    public static final Include INCLUDE_NETWORK = new Include("OrganizationRole:network").toLocked();
    @SearchParamDefinition(name="endpoint", path="OrganizationRole.endpoint", description="Technical endpoints providing access to services operated for the practitioner with this role", type="reference", target={Endpoint.class})
    public static final String SP_ENDPOINT = "endpoint";
    public static final ReferenceClientParam ENDPOINT = new ReferenceClientParam("endpoint");
    public static final Include INCLUDE_ENDPOINT = new Include("OrganizationRole:endpoint").toLocked();
    @SearchParamDefinition(name="phone", path="OrganizationRole.telecom.where(system='phone')", description="A value in a phone contact", type="token")
    public static final String SP_PHONE = "phone";
    public static final TokenClientParam PHONE = new TokenClientParam("phone");
    @SearchParamDefinition(name="service", path="OrganizationRole.healthcareService", description="The list of healthcare services that this worker provides for this role's Organization/Location(s)", type="reference", target={HealthcareService.class})
    public static final String SP_SERVICE = "service";
    public static final ReferenceClientParam SERVICE = new ReferenceClientParam("service");
    public static final Include INCLUDE_SERVICE = new Include("OrganizationRole:service").toLocked();
    @SearchParamDefinition(name="participating-organization", path="OrganizationRole.participatingOrganization", description="Practitioner that is able to provide the defined services for the organization", type="reference", target={Organization.class})
    public static final String SP_PARTICIPATING_ORGANIZATION = "participating-organization";
    public static final ReferenceClientParam PARTICIPATING_ORGANIZATION = new ReferenceClientParam("participating-organization");
    public static final Include INCLUDE_PARTICIPATING_ORGANIZATION = new Include("OrganizationRole:participating-organization").toLocked();
    @SearchParamDefinition(name="telecom", path="OrganizationRole.telecom", description="The value in any kind of contact", type="token")
    public static final String SP_TELECOM = "telecom";
    public static final TokenClientParam TELECOM = new TokenClientParam("telecom");
    @SearchParamDefinition(name="location", path="OrganizationRole.location", description="One of the locations at which this practitioner provides care", type="reference", target={Location.class})
    public static final String SP_LOCATION = "location";
    public static final ReferenceClientParam LOCATION = new ReferenceClientParam("location");
    public static final Include INCLUDE_LOCATION = new Include("OrganizationRole:location").toLocked();
    @SearchParamDefinition(name="email", path="OrganizationRole.telecom.where(system='email')", description="A value in an email contact", type="token")
    public static final String SP_EMAIL = "email";
    public static final TokenClientParam EMAIL = new TokenClientParam("email");

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public OrganizationRole setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public OrganizationRole addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public BooleanType getActiveElement() {
        if (this.active == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OrganizationRole.active");
            }
            if (Configuration.doAutoCreate()) {
                this.active = new BooleanType();
            }
        }
        return this.active;
    }

    public boolean hasActiveElement() {
        return this.active != null && !this.active.isEmpty();
    }

    public boolean hasActive() {
        return this.active != null && !this.active.isEmpty();
    }

    public OrganizationRole setActiveElement(BooleanType value) {
        this.active = value;
        return this;
    }

    public boolean getActive() {
        return this.active == null || this.active.isEmpty() ? false : (Boolean)this.active.getValue();
    }

    public OrganizationRole setActive(boolean value) {
        if (this.active == null) {
            this.active = new BooleanType();
        }
        this.active.setValue((Object)value);
        return this;
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OrganizationRole.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public OrganizationRole setPeriod(Period value) {
        this.period = value;
        return this;
    }

    public Reference getOrganization() {
        if (this.organization == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OrganizationRole.organization");
            }
            if (Configuration.doAutoCreate()) {
                this.organization = new Reference();
            }
        }
        return this.organization;
    }

    public boolean hasOrganization() {
        return this.organization != null && !this.organization.isEmpty();
    }

    public OrganizationRole setOrganization(Reference value) {
        this.organization = value;
        return this;
    }

    public Organization getOrganizationTarget() {
        if (this.organizationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OrganizationRole.organization");
            }
            if (Configuration.doAutoCreate()) {
                this.organizationTarget = new Organization();
            }
        }
        return this.organizationTarget;
    }

    public OrganizationRole setOrganizationTarget(Organization value) {
        this.organizationTarget = value;
        return this;
    }

    public Reference getParticipatingOrganization() {
        if (this.participatingOrganization == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OrganizationRole.participatingOrganization");
            }
            if (Configuration.doAutoCreate()) {
                this.participatingOrganization = new Reference();
            }
        }
        return this.participatingOrganization;
    }

    public boolean hasParticipatingOrganization() {
        return this.participatingOrganization != null && !this.participatingOrganization.isEmpty();
    }

    public OrganizationRole setParticipatingOrganization(Reference value) {
        this.participatingOrganization = value;
        return this;
    }

    public Organization getParticipatingOrganizationTarget() {
        if (this.participatingOrganizationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OrganizationRole.participatingOrganization");
            }
            if (Configuration.doAutoCreate()) {
                this.participatingOrganizationTarget = new Organization();
            }
        }
        return this.participatingOrganizationTarget;
    }

    public OrganizationRole setParticipatingOrganizationTarget(Organization value) {
        this.participatingOrganizationTarget = value;
        return this;
    }

    public List<Reference> getNetwork() {
        if (this.network == null) {
            this.network = new ArrayList<Reference>();
        }
        return this.network;
    }

    public OrganizationRole setNetwork(List<Reference> theNetwork) {
        this.network = theNetwork;
        return this;
    }

    public boolean hasNetwork() {
        if (this.network == null) {
            return false;
        }
        for (Reference item : this.network) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addNetwork() {
        Reference t = new Reference();
        if (this.network == null) {
            this.network = new ArrayList<Reference>();
        }
        this.network.add(t);
        return t;
    }

    public OrganizationRole addNetwork(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.network == null) {
            this.network = new ArrayList<Reference>();
        }
        this.network.add(t);
        return this;
    }

    public Reference getNetworkFirstRep() {
        if (this.getNetwork().isEmpty()) {
            this.addNetwork();
        }
        return this.getNetwork().get(0);
    }

    @Deprecated
    public List<Organization> getNetworkTarget() {
        if (this.networkTarget == null) {
            this.networkTarget = new ArrayList<Organization>();
        }
        return this.networkTarget;
    }

    @Deprecated
    public Organization addNetworkTarget() {
        Organization r = new Organization();
        if (this.networkTarget == null) {
            this.networkTarget = new ArrayList<Organization>();
        }
        this.networkTarget.add(r);
        return r;
    }

    public List<CodeableConcept> getCode() {
        if (this.code == null) {
            this.code = new ArrayList<CodeableConcept>();
        }
        return this.code;
    }

    public OrganizationRole setCode(List<CodeableConcept> theCode) {
        this.code = theCode;
        return this;
    }

    public boolean hasCode() {
        if (this.code == null) {
            return false;
        }
        for (CodeableConcept item : this.code) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCode() {
        CodeableConcept t = new CodeableConcept();
        if (this.code == null) {
            this.code = new ArrayList<CodeableConcept>();
        }
        this.code.add(t);
        return t;
    }

    public OrganizationRole addCode(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.code == null) {
            this.code = new ArrayList<CodeableConcept>();
        }
        this.code.add(t);
        return this;
    }

    public CodeableConcept getCodeFirstRep() {
        if (this.getCode().isEmpty()) {
            this.addCode();
        }
        return this.getCode().get(0);
    }

    public List<CodeableConcept> getSpecialty() {
        if (this.specialty == null) {
            this.specialty = new ArrayList<CodeableConcept>();
        }
        return this.specialty;
    }

    public OrganizationRole setSpecialty(List<CodeableConcept> theSpecialty) {
        this.specialty = theSpecialty;
        return this;
    }

    public boolean hasSpecialty() {
        if (this.specialty == null) {
            return false;
        }
        for (CodeableConcept item : this.specialty) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addSpecialty() {
        CodeableConcept t = new CodeableConcept();
        if (this.specialty == null) {
            this.specialty = new ArrayList<CodeableConcept>();
        }
        this.specialty.add(t);
        return t;
    }

    public OrganizationRole addSpecialty(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.specialty == null) {
            this.specialty = new ArrayList<CodeableConcept>();
        }
        this.specialty.add(t);
        return this;
    }

    public CodeableConcept getSpecialtyFirstRep() {
        if (this.getSpecialty().isEmpty()) {
            this.addSpecialty();
        }
        return this.getSpecialty().get(0);
    }

    public List<Reference> getLocation() {
        if (this.location == null) {
            this.location = new ArrayList<Reference>();
        }
        return this.location;
    }

    public OrganizationRole setLocation(List<Reference> theLocation) {
        this.location = theLocation;
        return this;
    }

    public boolean hasLocation() {
        if (this.location == null) {
            return false;
        }
        for (Reference item : this.location) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addLocation() {
        Reference t = new Reference();
        if (this.location == null) {
            this.location = new ArrayList<Reference>();
        }
        this.location.add(t);
        return t;
    }

    public OrganizationRole addLocation(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.location == null) {
            this.location = new ArrayList<Reference>();
        }
        this.location.add(t);
        return this;
    }

    public Reference getLocationFirstRep() {
        if (this.getLocation().isEmpty()) {
            this.addLocation();
        }
        return this.getLocation().get(0);
    }

    @Deprecated
    public List<Location> getLocationTarget() {
        if (this.locationTarget == null) {
            this.locationTarget = new ArrayList<Location>();
        }
        return this.locationTarget;
    }

    @Deprecated
    public Location addLocationTarget() {
        Location r = new Location();
        if (this.locationTarget == null) {
            this.locationTarget = new ArrayList<Location>();
        }
        this.locationTarget.add(r);
        return r;
    }

    public List<Reference> getHealthcareService() {
        if (this.healthcareService == null) {
            this.healthcareService = new ArrayList<Reference>();
        }
        return this.healthcareService;
    }

    public OrganizationRole setHealthcareService(List<Reference> theHealthcareService) {
        this.healthcareService = theHealthcareService;
        return this;
    }

    public boolean hasHealthcareService() {
        if (this.healthcareService == null) {
            return false;
        }
        for (Reference item : this.healthcareService) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addHealthcareService() {
        Reference t = new Reference();
        if (this.healthcareService == null) {
            this.healthcareService = new ArrayList<Reference>();
        }
        this.healthcareService.add(t);
        return t;
    }

    public OrganizationRole addHealthcareService(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.healthcareService == null) {
            this.healthcareService = new ArrayList<Reference>();
        }
        this.healthcareService.add(t);
        return this;
    }

    public Reference getHealthcareServiceFirstRep() {
        if (this.getHealthcareService().isEmpty()) {
            this.addHealthcareService();
        }
        return this.getHealthcareService().get(0);
    }

    @Deprecated
    public List<HealthcareService> getHealthcareServiceTarget() {
        if (this.healthcareServiceTarget == null) {
            this.healthcareServiceTarget = new ArrayList<HealthcareService>();
        }
        return this.healthcareServiceTarget;
    }

    @Deprecated
    public HealthcareService addHealthcareServiceTarget() {
        HealthcareService r = new HealthcareService();
        if (this.healthcareServiceTarget == null) {
            this.healthcareServiceTarget = new ArrayList<HealthcareService>();
        }
        this.healthcareServiceTarget.add(r);
        return r;
    }

    public List<ContactPoint> getTelecom() {
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        return this.telecom;
    }

    public OrganizationRole setTelecom(List<ContactPoint> theTelecom) {
        this.telecom = theTelecom;
        return this;
    }

    public boolean hasTelecom() {
        if (this.telecom == null) {
            return false;
        }
        for (ContactPoint item : this.telecom) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactPoint addTelecom() {
        ContactPoint t = new ContactPoint();
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        this.telecom.add(t);
        return t;
    }

    public OrganizationRole addTelecom(ContactPoint t) {
        if (t == null) {
            return this;
        }
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        this.telecom.add(t);
        return this;
    }

    public ContactPoint getTelecomFirstRep() {
        if (this.getTelecom().isEmpty()) {
            this.addTelecom();
        }
        return this.getTelecom().get(0);
    }

    public List<OrganizationRoleAvailableTimeComponent> getAvailableTime() {
        if (this.availableTime == null) {
            this.availableTime = new ArrayList<OrganizationRoleAvailableTimeComponent>();
        }
        return this.availableTime;
    }

    public OrganizationRole setAvailableTime(List<OrganizationRoleAvailableTimeComponent> theAvailableTime) {
        this.availableTime = theAvailableTime;
        return this;
    }

    public boolean hasAvailableTime() {
        if (this.availableTime == null) {
            return false;
        }
        for (OrganizationRoleAvailableTimeComponent item : this.availableTime) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public OrganizationRoleAvailableTimeComponent addAvailableTime() {
        OrganizationRoleAvailableTimeComponent t = new OrganizationRoleAvailableTimeComponent();
        if (this.availableTime == null) {
            this.availableTime = new ArrayList<OrganizationRoleAvailableTimeComponent>();
        }
        this.availableTime.add(t);
        return t;
    }

    public OrganizationRole addAvailableTime(OrganizationRoleAvailableTimeComponent t) {
        if (t == null) {
            return this;
        }
        if (this.availableTime == null) {
            this.availableTime = new ArrayList<OrganizationRoleAvailableTimeComponent>();
        }
        this.availableTime.add(t);
        return this;
    }

    public OrganizationRoleAvailableTimeComponent getAvailableTimeFirstRep() {
        if (this.getAvailableTime().isEmpty()) {
            this.addAvailableTime();
        }
        return this.getAvailableTime().get(0);
    }

    public List<OrganizationRoleNotAvailableComponent> getNotAvailable() {
        if (this.notAvailable == null) {
            this.notAvailable = new ArrayList<OrganizationRoleNotAvailableComponent>();
        }
        return this.notAvailable;
    }

    public OrganizationRole setNotAvailable(List<OrganizationRoleNotAvailableComponent> theNotAvailable) {
        this.notAvailable = theNotAvailable;
        return this;
    }

    public boolean hasNotAvailable() {
        if (this.notAvailable == null) {
            return false;
        }
        for (OrganizationRoleNotAvailableComponent item : this.notAvailable) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public OrganizationRoleNotAvailableComponent addNotAvailable() {
        OrganizationRoleNotAvailableComponent t = new OrganizationRoleNotAvailableComponent();
        if (this.notAvailable == null) {
            this.notAvailable = new ArrayList<OrganizationRoleNotAvailableComponent>();
        }
        this.notAvailable.add(t);
        return t;
    }

    public OrganizationRole addNotAvailable(OrganizationRoleNotAvailableComponent t) {
        if (t == null) {
            return this;
        }
        if (this.notAvailable == null) {
            this.notAvailable = new ArrayList<OrganizationRoleNotAvailableComponent>();
        }
        this.notAvailable.add(t);
        return this;
    }

    public OrganizationRoleNotAvailableComponent getNotAvailableFirstRep() {
        if (this.getNotAvailable().isEmpty()) {
            this.addNotAvailable();
        }
        return this.getNotAvailable().get(0);
    }

    public StringType getAvailabilityExceptionsElement() {
        if (this.availabilityExceptions == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OrganizationRole.availabilityExceptions");
            }
            if (Configuration.doAutoCreate()) {
                this.availabilityExceptions = new StringType();
            }
        }
        return this.availabilityExceptions;
    }

    public boolean hasAvailabilityExceptionsElement() {
        return this.availabilityExceptions != null && !this.availabilityExceptions.isEmpty();
    }

    public boolean hasAvailabilityExceptions() {
        return this.availabilityExceptions != null && !this.availabilityExceptions.isEmpty();
    }

    public OrganizationRole setAvailabilityExceptionsElement(StringType value) {
        this.availabilityExceptions = value;
        return this;
    }

    public String getAvailabilityExceptions() {
        return this.availabilityExceptions == null ? null : (String)this.availabilityExceptions.getValue();
    }

    public OrganizationRole setAvailabilityExceptions(String value) {
        if (Utilities.noString((String)value)) {
            this.availabilityExceptions = null;
        } else {
            if (this.availabilityExceptions == null) {
                this.availabilityExceptions = new StringType();
            }
            this.availabilityExceptions.setValue(value);
        }
        return this;
    }

    public List<Reference> getEndpoint() {
        if (this.endpoint == null) {
            this.endpoint = new ArrayList<Reference>();
        }
        return this.endpoint;
    }

    public OrganizationRole setEndpoint(List<Reference> theEndpoint) {
        this.endpoint = theEndpoint;
        return this;
    }

    public boolean hasEndpoint() {
        if (this.endpoint == null) {
            return false;
        }
        for (Reference item : this.endpoint) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addEndpoint() {
        Reference t = new Reference();
        if (this.endpoint == null) {
            this.endpoint = new ArrayList<Reference>();
        }
        this.endpoint.add(t);
        return t;
    }

    public OrganizationRole addEndpoint(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.endpoint == null) {
            this.endpoint = new ArrayList<Reference>();
        }
        this.endpoint.add(t);
        return this;
    }

    public Reference getEndpointFirstRep() {
        if (this.getEndpoint().isEmpty()) {
            this.addEndpoint();
        }
        return this.getEndpoint().get(0);
    }

    @Deprecated
    public List<Endpoint> getEndpointTarget() {
        if (this.endpointTarget == null) {
            this.endpointTarget = new ArrayList<Endpoint>();
        }
        return this.endpointTarget;
    }

    @Deprecated
    public Endpoint addEndpointTarget() {
        Endpoint r = new Endpoint();
        if (this.endpointTarget == null) {
            this.endpointTarget = new ArrayList<Endpoint>();
        }
        this.endpointTarget.add(r);
        return r;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Business Identifiers that are specific to a role/location.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_ACTIVE, "boolean", "Whether this practitioner role record is in active use.", 0, 1, this.active));
        children.add(new Property("period", "Period", "The period during which the person is authorized to act as a practitioner in these role(s) for the organization.", 0, 1, this.period));
        children.add(new Property("organization", "Reference(Organization)", "The organization where the Practitioner performs the roles associated.", 0, 1, this.organization));
        children.add(new Property("participatingOrganization", "Reference(Organization)", "Practitioner that is able to provide the defined services for the organization.", 0, 1, this.participatingOrganization));
        children.add(new Property(SP_NETWORK, "Reference(Organization)", "The network(s) this association applies to (if any).", 0, Integer.MAX_VALUE, this.network));
        children.add(new Property("code", "CodeableConcept", "Roles which this practitioner is authorized to perform for the organization.", 0, Integer.MAX_VALUE, this.code));
        children.add(new Property(SP_SPECIALTY, "CodeableConcept", "Specific specialty of the practitioner.", 0, Integer.MAX_VALUE, this.specialty));
        children.add(new Property(SP_LOCATION, "Reference(Location)", "The location(s) at which this practitioner provides care.", 0, Integer.MAX_VALUE, this.location));
        children.add(new Property("healthcareService", "Reference(HealthcareService)", "The list of healthcare services that this worker provides for this role's Organization/Location(s).", 0, Integer.MAX_VALUE, this.healthcareService));
        children.add(new Property(SP_TELECOM, "ContactPoint", "Contact details that are specific to the role/location/service.", 0, Integer.MAX_VALUE, this.telecom));
        children.add(new Property("availableTime", "", "A collection of times that the Service Site is available.", 0, Integer.MAX_VALUE, this.availableTime));
        children.add(new Property("notAvailable", "", "The HealthcareService is not available during this period of time due to the provided reason.", 0, Integer.MAX_VALUE, this.notAvailable));
        children.add(new Property("availabilityExceptions", "string", "A description of site availability exceptions, e.g. public holiday availability. Succinctly describing all possible exceptions to normal site availability as details in the available Times and not available Times.", 0, 1, this.availabilityExceptions));
        children.add(new Property(SP_ENDPOINT, "Reference(Endpoint)", "Technical endpoints providing access to services operated for the practitioner with this role.", 0, Integer.MAX_VALUE, this.endpoint));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Business Identifiers that are specific to a role/location.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -1422950650: {
                return new Property(SP_ACTIVE, "boolean", "Whether this practitioner role record is in active use.", 0, 1, this.active);
            }
            case -991726143: {
                return new Property("period", "Period", "The period during which the person is authorized to act as a practitioner in these role(s) for the organization.", 0, 1, this.period);
            }
            case 1178922291: {
                return new Property("organization", "Reference(Organization)", "The organization where the Practitioner performs the roles associated.", 0, 1, this.organization);
            }
            case 1593310702: {
                return new Property("participatingOrganization", "Reference(Organization)", "Practitioner that is able to provide the defined services for the organization.", 0, 1, this.participatingOrganization);
            }
            case 1843485230: {
                return new Property(SP_NETWORK, "Reference(Organization)", "The network(s) this association applies to (if any).", 0, Integer.MAX_VALUE, this.network);
            }
            case 3059181: {
                return new Property("code", "CodeableConcept", "Roles which this practitioner is authorized to perform for the organization.", 0, Integer.MAX_VALUE, this.code);
            }
            case -1694759682: {
                return new Property(SP_SPECIALTY, "CodeableConcept", "Specific specialty of the practitioner.", 0, Integer.MAX_VALUE, this.specialty);
            }
            case 1901043637: {
                return new Property(SP_LOCATION, "Reference(Location)", "The location(s) at which this practitioner provides care.", 0, Integer.MAX_VALUE, this.location);
            }
            case 1289661064: {
                return new Property("healthcareService", "Reference(HealthcareService)", "The list of healthcare services that this worker provides for this role's Organization/Location(s).", 0, Integer.MAX_VALUE, this.healthcareService);
            }
            case -1429363305: {
                return new Property(SP_TELECOM, "ContactPoint", "Contact details that are specific to the role/location/service.", 0, Integer.MAX_VALUE, this.telecom);
            }
            case 1873069366: {
                return new Property("availableTime", "", "A collection of times that the Service Site is available.", 0, Integer.MAX_VALUE, this.availableTime);
            }
            case -629572298: {
                return new Property("notAvailable", "", "The HealthcareService is not available during this period of time due to the provided reason.", 0, Integer.MAX_VALUE, this.notAvailable);
            }
            case -1149143617: {
                return new Property("availabilityExceptions", "string", "A description of site availability exceptions, e.g. public holiday availability. Succinctly describing all possible exceptions to normal site availability as details in the available Times and not available Times.", 0, 1, this.availabilityExceptions);
            }
            case 1741102485: {
                return new Property(SP_ENDPOINT, "Reference(Endpoint)", "Technical endpoints providing access to services operated for the practitioner with this role.", 0, Integer.MAX_VALUE, this.endpoint);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -1422950650: {
                Base[] baseArray;
                if (this.active == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.active;
                }
                return baseArray;
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.period;
                }
                return baseArray;
            }
            case 1178922291: {
                Base[] baseArray;
                if (this.organization == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.organization;
                }
                return baseArray;
            }
            case 1593310702: {
                Base[] baseArray;
                if (this.participatingOrganization == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.participatingOrganization;
                }
                return baseArray;
            }
            case 1843485230: {
                return this.network == null ? new Base[]{} : this.network.toArray(new Base[this.network.size()]);
            }
            case 3059181: {
                return this.code == null ? new Base[]{} : this.code.toArray(new Base[this.code.size()]);
            }
            case -1694759682: {
                return this.specialty == null ? new Base[]{} : this.specialty.toArray(new Base[this.specialty.size()]);
            }
            case 1901043637: {
                return this.location == null ? new Base[]{} : this.location.toArray(new Base[this.location.size()]);
            }
            case 1289661064: {
                return this.healthcareService == null ? new Base[]{} : this.healthcareService.toArray(new Base[this.healthcareService.size()]);
            }
            case -1429363305: {
                return this.telecom == null ? new Base[]{} : this.telecom.toArray(new Base[this.telecom.size()]);
            }
            case 1873069366: {
                return this.availableTime == null ? new Base[]{} : this.availableTime.toArray(new Base[this.availableTime.size()]);
            }
            case -629572298: {
                return this.notAvailable == null ? new Base[]{} : this.notAvailable.toArray(new Base[this.notAvailable.size()]);
            }
            case -1149143617: {
                Base[] baseArray;
                if (this.availabilityExceptions == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.availabilityExceptions;
                }
                return baseArray;
            }
            case 1741102485: {
                return this.endpoint == null ? new Base[]{} : this.endpoint.toArray(new Base[this.endpoint.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -1422950650: {
                this.active = this.castToBoolean(value);
                return value;
            }
            case -991726143: {
                this.period = this.castToPeriod(value);
                return value;
            }
            case 1178922291: {
                this.organization = this.castToReference(value);
                return value;
            }
            case 1593310702: {
                this.participatingOrganization = this.castToReference(value);
                return value;
            }
            case 1843485230: {
                this.getNetwork().add(this.castToReference(value));
                return value;
            }
            case 3059181: {
                this.getCode().add(this.castToCodeableConcept(value));
                return value;
            }
            case -1694759682: {
                this.getSpecialty().add(this.castToCodeableConcept(value));
                return value;
            }
            case 1901043637: {
                this.getLocation().add(this.castToReference(value));
                return value;
            }
            case 1289661064: {
                this.getHealthcareService().add(this.castToReference(value));
                return value;
            }
            case -1429363305: {
                this.getTelecom().add(this.castToContactPoint(value));
                return value;
            }
            case 1873069366: {
                this.getAvailableTime().add((OrganizationRoleAvailableTimeComponent)value);
                return value;
            }
            case -629572298: {
                this.getNotAvailable().add((OrganizationRoleNotAvailableComponent)value);
                return value;
            }
            case -1149143617: {
                this.availabilityExceptions = this.castToString(value);
                return value;
            }
            case 1741102485: {
                this.getEndpoint().add(this.castToReference(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_ACTIVE)) {
            this.active = this.castToBoolean(value);
        } else if (name.equals("period")) {
            this.period = this.castToPeriod(value);
        } else if (name.equals("organization")) {
            this.organization = this.castToReference(value);
        } else if (name.equals("participatingOrganization")) {
            this.participatingOrganization = this.castToReference(value);
        } else if (name.equals(SP_NETWORK)) {
            this.getNetwork().add(this.castToReference(value));
        } else if (name.equals("code")) {
            this.getCode().add(this.castToCodeableConcept(value));
        } else if (name.equals(SP_SPECIALTY)) {
            this.getSpecialty().add(this.castToCodeableConcept(value));
        } else if (name.equals(SP_LOCATION)) {
            this.getLocation().add(this.castToReference(value));
        } else if (name.equals("healthcareService")) {
            this.getHealthcareService().add(this.castToReference(value));
        } else if (name.equals(SP_TELECOM)) {
            this.getTelecom().add(this.castToContactPoint(value));
        } else if (name.equals("availableTime")) {
            this.getAvailableTime().add((OrganizationRoleAvailableTimeComponent)value);
        } else if (name.equals("notAvailable")) {
            this.getNotAvailable().add((OrganizationRoleNotAvailableComponent)value);
        } else if (name.equals("availabilityExceptions")) {
            this.availabilityExceptions = this.castToString(value);
        } else if (name.equals(SP_ENDPOINT)) {
            this.getEndpoint().add(this.castToReference(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -1422950650: {
                return this.getActiveElement();
            }
            case -991726143: {
                return this.getPeriod();
            }
            case 1178922291: {
                return this.getOrganization();
            }
            case 1593310702: {
                return this.getParticipatingOrganization();
            }
            case 1843485230: {
                return this.addNetwork();
            }
            case 3059181: {
                return this.addCode();
            }
            case -1694759682: {
                return this.addSpecialty();
            }
            case 1901043637: {
                return this.addLocation();
            }
            case 1289661064: {
                return this.addHealthcareService();
            }
            case -1429363305: {
                return this.addTelecom();
            }
            case 1873069366: {
                return this.addAvailableTime();
            }
            case -629572298: {
                return this.addNotAvailable();
            }
            case -1149143617: {
                return this.getAvailabilityExceptionsElement();
            }
            case 1741102485: {
                return this.addEndpoint();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -1422950650: {
                return new String[]{"boolean"};
            }
            case -991726143: {
                return new String[]{"Period"};
            }
            case 1178922291: {
                return new String[]{"Reference"};
            }
            case 1593310702: {
                return new String[]{"Reference"};
            }
            case 1843485230: {
                return new String[]{"Reference"};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case -1694759682: {
                return new String[]{"CodeableConcept"};
            }
            case 1901043637: {
                return new String[]{"Reference"};
            }
            case 1289661064: {
                return new String[]{"Reference"};
            }
            case -1429363305: {
                return new String[]{"ContactPoint"};
            }
            case 1873069366: {
                return new String[0];
            }
            case -629572298: {
                return new String[0];
            }
            case -1149143617: {
                return new String[]{"string"};
            }
            case 1741102485: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_ACTIVE)) {
            throw new FHIRException("Cannot call addChild on a primitive type OrganizationRole.active");
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        if (name.equals("organization")) {
            this.organization = new Reference();
            return this.organization;
        }
        if (name.equals("participatingOrganization")) {
            this.participatingOrganization = new Reference();
            return this.participatingOrganization;
        }
        if (name.equals(SP_NETWORK)) {
            return this.addNetwork();
        }
        if (name.equals("code")) {
            return this.addCode();
        }
        if (name.equals(SP_SPECIALTY)) {
            return this.addSpecialty();
        }
        if (name.equals(SP_LOCATION)) {
            return this.addLocation();
        }
        if (name.equals("healthcareService")) {
            return this.addHealthcareService();
        }
        if (name.equals(SP_TELECOM)) {
            return this.addTelecom();
        }
        if (name.equals("availableTime")) {
            return this.addAvailableTime();
        }
        if (name.equals("notAvailable")) {
            return this.addNotAvailable();
        }
        if (name.equals("availabilityExceptions")) {
            throw new FHIRException("Cannot call addChild on a primitive type OrganizationRole.availabilityExceptions");
        }
        if (name.equals(SP_ENDPOINT)) {
            return this.addEndpoint();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "OrganizationRole";
    }

    @Override
    public OrganizationRole copy() {
        OrganizationRole dst = new OrganizationRole();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.active = this.active == null ? null : this.active.copy();
        dst.period = this.period == null ? null : this.period.copy();
        dst.organization = this.organization == null ? null : this.organization.copy();
        Reference reference = dst.participatingOrganization = this.participatingOrganization == null ? null : this.participatingOrganization.copy();
        if (this.network != null) {
            dst.network = new ArrayList<Reference>();
            for (Reference reference2 : this.network) {
                dst.network.add(reference2.copy());
            }
        }
        if (this.code != null) {
            dst.code = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.code) {
                dst.code.add(codeableConcept.copy());
            }
        }
        if (this.specialty != null) {
            dst.specialty = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.specialty) {
                dst.specialty.add(codeableConcept.copy());
            }
        }
        if (this.location != null) {
            dst.location = new ArrayList<Reference>();
            for (Reference reference3 : this.location) {
                dst.location.add(reference3.copy());
            }
        }
        if (this.healthcareService != null) {
            dst.healthcareService = new ArrayList<Reference>();
            for (Reference reference4 : this.healthcareService) {
                dst.healthcareService.add(reference4.copy());
            }
        }
        if (this.telecom != null) {
            dst.telecom = new ArrayList<ContactPoint>();
            for (ContactPoint contactPoint : this.telecom) {
                dst.telecom.add(contactPoint.copy());
            }
        }
        if (this.availableTime != null) {
            dst.availableTime = new ArrayList<OrganizationRoleAvailableTimeComponent>();
            for (OrganizationRoleAvailableTimeComponent organizationRoleAvailableTimeComponent : this.availableTime) {
                dst.availableTime.add(organizationRoleAvailableTimeComponent.copy());
            }
        }
        if (this.notAvailable != null) {
            dst.notAvailable = new ArrayList<OrganizationRoleNotAvailableComponent>();
            for (OrganizationRoleNotAvailableComponent organizationRoleNotAvailableComponent : this.notAvailable) {
                dst.notAvailable.add(organizationRoleNotAvailableComponent.copy());
            }
        }
        StringType stringType = dst.availabilityExceptions = this.availabilityExceptions == null ? null : this.availabilityExceptions.copy();
        if (this.endpoint != null) {
            dst.endpoint = new ArrayList<Reference>();
            for (Reference reference5 : this.endpoint) {
                dst.endpoint.add(reference5.copy());
            }
        }
        return dst;
    }

    protected OrganizationRole typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof OrganizationRole)) {
            return false;
        }
        OrganizationRole o = (OrganizationRole)other_;
        return OrganizationRole.compareDeep(this.identifier, o.identifier, true) && OrganizationRole.compareDeep(this.active, o.active, true) && OrganizationRole.compareDeep(this.period, o.period, true) && OrganizationRole.compareDeep(this.organization, o.organization, true) && OrganizationRole.compareDeep(this.participatingOrganization, o.participatingOrganization, true) && OrganizationRole.compareDeep(this.network, o.network, true) && OrganizationRole.compareDeep(this.code, o.code, true) && OrganizationRole.compareDeep(this.specialty, o.specialty, true) && OrganizationRole.compareDeep(this.location, o.location, true) && OrganizationRole.compareDeep(this.healthcareService, o.healthcareService, true) && OrganizationRole.compareDeep(this.telecom, o.telecom, true) && OrganizationRole.compareDeep(this.availableTime, o.availableTime, true) && OrganizationRole.compareDeep(this.notAvailable, o.notAvailable, true) && OrganizationRole.compareDeep(this.availabilityExceptions, o.availabilityExceptions, true) && OrganizationRole.compareDeep(this.endpoint, o.endpoint, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof OrganizationRole)) {
            return false;
        }
        OrganizationRole o = (OrganizationRole)other_;
        return OrganizationRole.compareValues(this.active, o.active, true) && OrganizationRole.compareValues(this.availabilityExceptions, o.availabilityExceptions, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.active, this.period, this.organization, this.participatingOrganization, this.network, this.code, this.specialty, this.location, this.healthcareService, this.telecom, this.availableTime, this.notAvailable, this.availabilityExceptions, this.endpoint});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.OrganizationRole;
    }

    @Block
    public static class OrganizationRoleNotAvailableComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="description", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reason presented to the user explaining why time not available", formalDefinition="The reason that can be presented to the user as to why this time is not available.")
        protected StringType description;
        @Child(name="during", type={Period.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Service not available from this date", formalDefinition="Service is not available (seasonally or for a public holiday) from this date.")
        protected Period during;
        private static final long serialVersionUID = 310849929L;

        public OrganizationRoleNotAvailableComponent() {
        }

        public OrganizationRoleNotAvailableComponent(StringType description) {
            this.description = description;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OrganizationRoleNotAvailableComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public OrganizationRoleNotAvailableComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public OrganizationRoleNotAvailableComponent setDescription(String value) {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
            return this;
        }

        public Period getDuring() {
            if (this.during == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OrganizationRoleNotAvailableComponent.during");
                }
                if (Configuration.doAutoCreate()) {
                    this.during = new Period();
                }
            }
            return this.during;
        }

        public boolean hasDuring() {
            return this.during != null && !this.during.isEmpty();
        }

        public OrganizationRoleNotAvailableComponent setDuring(Period value) {
            this.during = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("description", "string", "The reason that can be presented to the user as to why this time is not available.", 0, 1, this.description));
            children.add(new Property("during", "Period", "Service is not available (seasonally or for a public holiday) from this date.", 0, 1, this.during));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1724546052: {
                    return new Property("description", "string", "The reason that can be presented to the user as to why this time is not available.", 0, 1, this.description);
                }
                case -1320499647: {
                    return new Property("during", "Period", "Service is not available (seasonally or for a public holiday) from this date.", 0, 1, this.during);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case -1320499647: {
                    Base[] baseArray;
                    if (this.during == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.during;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = this.castToString(value);
                    return value;
                }
                case -1320499647: {
                    this.during = this.castToPeriod(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("description")) {
                this.description = this.castToString(value);
            } else if (name.equals("during")) {
                this.during = this.castToPeriod(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -1320499647: {
                    return this.getDuring();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return new String[]{"string"};
                }
                case -1320499647: {
                    return new String[]{"Period"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type OrganizationRole.description");
            }
            if (name.equals("during")) {
                this.during = new Period();
                return this.during;
            }
            return super.addChild(name);
        }

        @Override
        public OrganizationRoleNotAvailableComponent copy() {
            OrganizationRoleNotAvailableComponent dst = new OrganizationRoleNotAvailableComponent();
            this.copyValues(dst);
            dst.description = this.description == null ? null : this.description.copy();
            dst.during = this.during == null ? null : this.during.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof OrganizationRoleNotAvailableComponent)) {
                return false;
            }
            OrganizationRoleNotAvailableComponent o = (OrganizationRoleNotAvailableComponent)other_;
            return OrganizationRoleNotAvailableComponent.compareDeep(this.description, o.description, true) && OrganizationRoleNotAvailableComponent.compareDeep(this.during, o.during, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof OrganizationRoleNotAvailableComponent)) {
                return false;
            }
            OrganizationRoleNotAvailableComponent o = (OrganizationRoleNotAvailableComponent)other_;
            return OrganizationRoleNotAvailableComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.description, this.during});
        }

        @Override
        public String fhirType() {
            return "OrganizationRole.notAvailable";
        }
    }

    @Block
    public static class OrganizationRoleAvailableTimeComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="daysOfWeek", type={CodeType.class}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="mon | tue | wed | thu | fri | sat | sun", formalDefinition="Indicates which days of the week are available between the start and end Times.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/days-of-week")
        protected List<Enumeration<DaysOfWeek>> daysOfWeek;
        @Child(name="allDay", type={BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Always available? e.g. 24-hour service", formalDefinition="Is this always available? (hence times are irrelevant) e.g. 24-hour service.")
        protected BooleanType allDay;
        @Child(name="availableStartTime", type={TimeType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Opening time of day (ignored if allDay = true)", formalDefinition="The opening time of day. Note: If the AllDay flag is set, then this time is ignored.")
        protected TimeType availableStartTime;
        @Child(name="availableEndTime", type={TimeType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Closing time of day (ignored if allDay = true)", formalDefinition="The closing time of day. Note: If the AllDay flag is set, then this time is ignored.")
        protected TimeType availableEndTime;
        private static final long serialVersionUID = -2139510127L;

        public List<Enumeration<DaysOfWeek>> getDaysOfWeek() {
            if (this.daysOfWeek == null) {
                this.daysOfWeek = new ArrayList<Enumeration<DaysOfWeek>>();
            }
            return this.daysOfWeek;
        }

        public OrganizationRoleAvailableTimeComponent setDaysOfWeek(List<Enumeration<DaysOfWeek>> theDaysOfWeek) {
            this.daysOfWeek = theDaysOfWeek;
            return this;
        }

        public boolean hasDaysOfWeek() {
            if (this.daysOfWeek == null) {
                return false;
            }
            for (Enumeration<DaysOfWeek> item : this.daysOfWeek) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Enumeration<DaysOfWeek> addDaysOfWeekElement() {
            Enumeration<DaysOfWeek> t = new Enumeration<DaysOfWeek>(new DaysOfWeekEnumFactory());
            if (this.daysOfWeek == null) {
                this.daysOfWeek = new ArrayList<Enumeration<DaysOfWeek>>();
            }
            this.daysOfWeek.add(t);
            return t;
        }

        public OrganizationRoleAvailableTimeComponent addDaysOfWeek(DaysOfWeek value) {
            Enumeration<DaysOfWeek> t = new Enumeration<DaysOfWeek>(new DaysOfWeekEnumFactory());
            t.setValue((Object)value);
            if (this.daysOfWeek == null) {
                this.daysOfWeek = new ArrayList<Enumeration<DaysOfWeek>>();
            }
            this.daysOfWeek.add(t);
            return this;
        }

        public boolean hasDaysOfWeek(DaysOfWeek value) {
            if (this.daysOfWeek == null) {
                return false;
            }
            for (Enumeration<DaysOfWeek> v : this.daysOfWeek) {
                if (!((DaysOfWeek)((Object)v.getValue())).equals((Object)value)) continue;
                return true;
            }
            return false;
        }

        public BooleanType getAllDayElement() {
            if (this.allDay == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OrganizationRoleAvailableTimeComponent.allDay");
                }
                if (Configuration.doAutoCreate()) {
                    this.allDay = new BooleanType();
                }
            }
            return this.allDay;
        }

        public boolean hasAllDayElement() {
            return this.allDay != null && !this.allDay.isEmpty();
        }

        public boolean hasAllDay() {
            return this.allDay != null && !this.allDay.isEmpty();
        }

        public OrganizationRoleAvailableTimeComponent setAllDayElement(BooleanType value) {
            this.allDay = value;
            return this;
        }

        public boolean getAllDay() {
            return this.allDay == null || this.allDay.isEmpty() ? false : (Boolean)this.allDay.getValue();
        }

        public OrganizationRoleAvailableTimeComponent setAllDay(boolean value) {
            if (this.allDay == null) {
                this.allDay = new BooleanType();
            }
            this.allDay.setValue((Object)value);
            return this;
        }

        public TimeType getAvailableStartTimeElement() {
            if (this.availableStartTime == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OrganizationRoleAvailableTimeComponent.availableStartTime");
                }
                if (Configuration.doAutoCreate()) {
                    this.availableStartTime = new TimeType();
                }
            }
            return this.availableStartTime;
        }

        public boolean hasAvailableStartTimeElement() {
            return this.availableStartTime != null && !this.availableStartTime.isEmpty();
        }

        public boolean hasAvailableStartTime() {
            return this.availableStartTime != null && !this.availableStartTime.isEmpty();
        }

        public OrganizationRoleAvailableTimeComponent setAvailableStartTimeElement(TimeType value) {
            this.availableStartTime = value;
            return this;
        }

        public String getAvailableStartTime() {
            return this.availableStartTime == null ? null : (String)this.availableStartTime.getValue();
        }

        public OrganizationRoleAvailableTimeComponent setAvailableStartTime(String value) {
            if (value == null) {
                this.availableStartTime = null;
            } else {
                if (this.availableStartTime == null) {
                    this.availableStartTime = new TimeType();
                }
                this.availableStartTime.setValue(value);
            }
            return this;
        }

        public TimeType getAvailableEndTimeElement() {
            if (this.availableEndTime == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OrganizationRoleAvailableTimeComponent.availableEndTime");
                }
                if (Configuration.doAutoCreate()) {
                    this.availableEndTime = new TimeType();
                }
            }
            return this.availableEndTime;
        }

        public boolean hasAvailableEndTimeElement() {
            return this.availableEndTime != null && !this.availableEndTime.isEmpty();
        }

        public boolean hasAvailableEndTime() {
            return this.availableEndTime != null && !this.availableEndTime.isEmpty();
        }

        public OrganizationRoleAvailableTimeComponent setAvailableEndTimeElement(TimeType value) {
            this.availableEndTime = value;
            return this;
        }

        public String getAvailableEndTime() {
            return this.availableEndTime == null ? null : (String)this.availableEndTime.getValue();
        }

        public OrganizationRoleAvailableTimeComponent setAvailableEndTime(String value) {
            if (value == null) {
                this.availableEndTime = null;
            } else {
                if (this.availableEndTime == null) {
                    this.availableEndTime = new TimeType();
                }
                this.availableEndTime.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("daysOfWeek", "code", "Indicates which days of the week are available between the start and end Times.", 0, Integer.MAX_VALUE, this.daysOfWeek));
            children.add(new Property("allDay", "boolean", "Is this always available? (hence times are irrelevant) e.g. 24-hour service.", 0, 1, this.allDay));
            children.add(new Property("availableStartTime", "time", "The opening time of day. Note: If the AllDay flag is set, then this time is ignored.", 0, 1, this.availableStartTime));
            children.add(new Property("availableEndTime", "time", "The closing time of day. Note: If the AllDay flag is set, then this time is ignored.", 0, 1, this.availableEndTime));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 68050338: {
                    return new Property("daysOfWeek", "code", "Indicates which days of the week are available between the start and end Times.", 0, Integer.MAX_VALUE, this.daysOfWeek);
                }
                case -1414913477: {
                    return new Property("allDay", "boolean", "Is this always available? (hence times are irrelevant) e.g. 24-hour service.", 0, 1, this.allDay);
                }
                case -1039453818: {
                    return new Property("availableStartTime", "time", "The opening time of day. Note: If the AllDay flag is set, then this time is ignored.", 0, 1, this.availableStartTime);
                }
                case 101151551: {
                    return new Property("availableEndTime", "time", "The closing time of day. Note: If the AllDay flag is set, then this time is ignored.", 0, 1, this.availableEndTime);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 68050338: {
                    return this.daysOfWeek == null ? new Base[]{} : this.daysOfWeek.toArray(new Base[this.daysOfWeek.size()]);
                }
                case -1414913477: {
                    Base[] baseArray;
                    if (this.allDay == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.allDay;
                    }
                    return baseArray;
                }
                case -1039453818: {
                    Base[] baseArray;
                    if (this.availableStartTime == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.availableStartTime;
                    }
                    return baseArray;
                }
                case 101151551: {
                    Base[] baseArray;
                    if (this.availableEndTime == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.availableEndTime;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 68050338: {
                    value = new DaysOfWeekEnumFactory().fromType(this.castToCode(value));
                    this.getDaysOfWeek().add(value);
                    return value;
                }
                case -1414913477: {
                    this.allDay = this.castToBoolean(value);
                    return value;
                }
                case -1039453818: {
                    this.availableStartTime = this.castToTime(value);
                    return value;
                }
                case 101151551: {
                    this.availableEndTime = this.castToTime(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("daysOfWeek")) {
                value = new DaysOfWeekEnumFactory().fromType(this.castToCode(value));
                this.getDaysOfWeek().add(value);
            } else if (name.equals("allDay")) {
                this.allDay = this.castToBoolean(value);
            } else if (name.equals("availableStartTime")) {
                this.availableStartTime = this.castToTime(value);
            } else if (name.equals("availableEndTime")) {
                this.availableEndTime = this.castToTime(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 68050338: {
                    return this.addDaysOfWeekElement();
                }
                case -1414913477: {
                    return this.getAllDayElement();
                }
                case -1039453818: {
                    return this.getAvailableStartTimeElement();
                }
                case 101151551: {
                    return this.getAvailableEndTimeElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 68050338: {
                    return new String[]{"code"};
                }
                case -1414913477: {
                    return new String[]{"boolean"};
                }
                case -1039453818: {
                    return new String[]{"time"};
                }
                case 101151551: {
                    return new String[]{"time"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("daysOfWeek")) {
                throw new FHIRException("Cannot call addChild on a primitive type OrganizationRole.daysOfWeek");
            }
            if (name.equals("allDay")) {
                throw new FHIRException("Cannot call addChild on a primitive type OrganizationRole.allDay");
            }
            if (name.equals("availableStartTime")) {
                throw new FHIRException("Cannot call addChild on a primitive type OrganizationRole.availableStartTime");
            }
            if (name.equals("availableEndTime")) {
                throw new FHIRException("Cannot call addChild on a primitive type OrganizationRole.availableEndTime");
            }
            return super.addChild(name);
        }

        @Override
        public OrganizationRoleAvailableTimeComponent copy() {
            OrganizationRoleAvailableTimeComponent dst = new OrganizationRoleAvailableTimeComponent();
            this.copyValues(dst);
            if (this.daysOfWeek != null) {
                dst.daysOfWeek = new ArrayList<Enumeration<DaysOfWeek>>();
                for (Enumeration<DaysOfWeek> i : this.daysOfWeek) {
                    dst.daysOfWeek.add((Enumeration<DaysOfWeek>)i.copy());
                }
            }
            dst.allDay = this.allDay == null ? null : this.allDay.copy();
            dst.availableStartTime = this.availableStartTime == null ? null : this.availableStartTime.copy();
            dst.availableEndTime = this.availableEndTime == null ? null : this.availableEndTime.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof OrganizationRoleAvailableTimeComponent)) {
                return false;
            }
            OrganizationRoleAvailableTimeComponent o = (OrganizationRoleAvailableTimeComponent)other_;
            return OrganizationRoleAvailableTimeComponent.compareDeep(this.daysOfWeek, o.daysOfWeek, true) && OrganizationRoleAvailableTimeComponent.compareDeep(this.allDay, o.allDay, true) && OrganizationRoleAvailableTimeComponent.compareDeep(this.availableStartTime, o.availableStartTime, true) && OrganizationRoleAvailableTimeComponent.compareDeep(this.availableEndTime, o.availableEndTime, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof OrganizationRoleAvailableTimeComponent)) {
                return false;
            }
            OrganizationRoleAvailableTimeComponent o = (OrganizationRoleAvailableTimeComponent)other_;
            return OrganizationRoleAvailableTimeComponent.compareValues(this.daysOfWeek, o.daysOfWeek, true) && OrganizationRoleAvailableTimeComponent.compareValues(this.allDay, o.allDay, true) && OrganizationRoleAvailableTimeComponent.compareValues(this.availableStartTime, o.availableStartTime, true) && OrganizationRoleAvailableTimeComponent.compareValues(this.availableEndTime, o.availableEndTime, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.daysOfWeek, this.allDay, this.availableStartTime, this.availableEndTime});
        }

        @Override
        public String fhirType() {
            return "OrganizationRole.availableTime";
        }
    }

    public static class DaysOfWeekEnumFactory
    implements EnumFactory<DaysOfWeek> {
        @Override
        public DaysOfWeek fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("mon".equals(codeString)) {
                return DaysOfWeek.MON;
            }
            if ("tue".equals(codeString)) {
                return DaysOfWeek.TUE;
            }
            if ("wed".equals(codeString)) {
                return DaysOfWeek.WED;
            }
            if ("thu".equals(codeString)) {
                return DaysOfWeek.THU;
            }
            if ("fri".equals(codeString)) {
                return DaysOfWeek.FRI;
            }
            if ("sat".equals(codeString)) {
                return DaysOfWeek.SAT;
            }
            if ("sun".equals(codeString)) {
                return DaysOfWeek.SUN;
            }
            throw new IllegalArgumentException("Unknown DaysOfWeek code '" + codeString + "'");
        }

        public Enumeration<DaysOfWeek> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<DaysOfWeek>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("mon".equals(codeString)) {
                return new Enumeration<DaysOfWeek>(this, DaysOfWeek.MON);
            }
            if ("tue".equals(codeString)) {
                return new Enumeration<DaysOfWeek>(this, DaysOfWeek.TUE);
            }
            if ("wed".equals(codeString)) {
                return new Enumeration<DaysOfWeek>(this, DaysOfWeek.WED);
            }
            if ("thu".equals(codeString)) {
                return new Enumeration<DaysOfWeek>(this, DaysOfWeek.THU);
            }
            if ("fri".equals(codeString)) {
                return new Enumeration<DaysOfWeek>(this, DaysOfWeek.FRI);
            }
            if ("sat".equals(codeString)) {
                return new Enumeration<DaysOfWeek>(this, DaysOfWeek.SAT);
            }
            if ("sun".equals(codeString)) {
                return new Enumeration<DaysOfWeek>(this, DaysOfWeek.SUN);
            }
            throw new FHIRException("Unknown DaysOfWeek code '" + codeString + "'");
        }

        @Override
        public String toCode(DaysOfWeek code) {
            if (code == DaysOfWeek.MON) {
                return "mon";
            }
            if (code == DaysOfWeek.TUE) {
                return "tue";
            }
            if (code == DaysOfWeek.WED) {
                return "wed";
            }
            if (code == DaysOfWeek.THU) {
                return "thu";
            }
            if (code == DaysOfWeek.FRI) {
                return "fri";
            }
            if (code == DaysOfWeek.SAT) {
                return "sat";
            }
            if (code == DaysOfWeek.SUN) {
                return "sun";
            }
            return "?";
        }

        @Override
        public String toSystem(DaysOfWeek code) {
            return code.getSystem();
        }
    }

    public static enum DaysOfWeek {
        MON,
        TUE,
        WED,
        THU,
        FRI,
        SAT,
        SUN,
        NULL;


        public static DaysOfWeek fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("mon".equals(codeString)) {
                return MON;
            }
            if ("tue".equals(codeString)) {
                return TUE;
            }
            if ("wed".equals(codeString)) {
                return WED;
            }
            if ("thu".equals(codeString)) {
                return THU;
            }
            if ("fri".equals(codeString)) {
                return FRI;
            }
            if ("sat".equals(codeString)) {
                return SAT;
            }
            if ("sun".equals(codeString)) {
                return SUN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown DaysOfWeek code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case MON: {
                    return "mon";
                }
                case TUE: {
                    return "tue";
                }
                case WED: {
                    return "wed";
                }
                case THU: {
                    return "thu";
                }
                case FRI: {
                    return "fri";
                }
                case SAT: {
                    return "sat";
                }
                case SUN: {
                    return "sun";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case MON: {
                    return "http://hl7.org/fhir/days-of-week";
                }
                case TUE: {
                    return "http://hl7.org/fhir/days-of-week";
                }
                case WED: {
                    return "http://hl7.org/fhir/days-of-week";
                }
                case THU: {
                    return "http://hl7.org/fhir/days-of-week";
                }
                case FRI: {
                    return "http://hl7.org/fhir/days-of-week";
                }
                case SAT: {
                    return "http://hl7.org/fhir/days-of-week";
                }
                case SUN: {
                    return "http://hl7.org/fhir/days-of-week";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case MON: {
                    return "Monday";
                }
                case TUE: {
                    return "Tuesday";
                }
                case WED: {
                    return "Wednesday";
                }
                case THU: {
                    return "Thursday";
                }
                case FRI: {
                    return "Friday";
                }
                case SAT: {
                    return "Saturday";
                }
                case SUN: {
                    return "Sunday";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case MON: {
                    return "Monday";
                }
                case TUE: {
                    return "Tuesday";
                }
                case WED: {
                    return "Wednesday";
                }
                case THU: {
                    return "Thursday";
                }
                case FRI: {
                    return "Friday";
                }
                case SAT: {
                    return "Saturday";
                }
                case SUN: {
                    return "Sunday";
                }
            }
            return "?";
        }
    }
}

