/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.ChildOrder;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.ContactDetail;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.IntegerType;
import org.hl7.fhir.r4.model.MarkdownType;
import org.hl7.fhir.r4.model.MetadataResource;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.model.UsageContext;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="OperationDefinition", profile="http://hl7.org/fhir/Profile/OperationDefinition")
@ChildOrder(names={"url", "version", "name", "status", "kind", "experimental", "date", "publisher", "contact", "description", "useContext", "jurisdiction", "purpose", "affectsState", "code", "comment", "base", "resource", "system", "type", "instance", "inputProfile", "outputProfile", "parameter", "overload"})
public class OperationDefinition
extends MetadataResource {
    @Child(name="kind", type={CodeType.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="operation | query", formalDefinition="Whether this is an operation or a named query.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/operation-kind")
    protected Enumeration<OperationKind> kind;
    @Child(name="purpose", type={MarkdownType.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why this operation definition is defined", formalDefinition="Explanation of why this operation definition is needed and why it has been designed as it has.")
    protected MarkdownType purpose;
    @Child(name="affectsState", type={BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Whether content is unchanged by the operation", formalDefinition="Operations that have affects state = false (see [HTTP specification definition of idempotent](http://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html)) may be invoked by performing an HTTP GET operation instead of a POST.")
    protected BooleanType affectsState;
    @Child(name="code", type={CodeType.class}, order=3, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name used to invoke the operation", formalDefinition="The name used to invoke the operation.")
    protected CodeType code;
    @Child(name="comment", type={MarkdownType.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Additional information about use", formalDefinition="Additional information about how to use this operation or named query.")
    protected MarkdownType comment;
    @Child(name="base", type={CanonicalType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Marks this as a profile of the base", formalDefinition="Indicates that this operation definition is a constraining profile on the base.")
    protected CanonicalType base;
    @Child(name="resource", type={CodeType.class}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Types this operation applies to", formalDefinition="The types on which this operation can be executed.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/resource-types")
    protected List<CodeType> resource;
    @Child(name="system", type={BooleanType.class}, order=7, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Invoke at the system level?", formalDefinition="Indicates whether this operation or named query can be invoked at the system level (e.g. without needing to choose a resource type for the context).")
    protected BooleanType system;
    @Child(name="type", type={BooleanType.class}, order=8, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Invoke at the type level?", formalDefinition="Indicates whether this operation or named query can be invoked at the resource type level for any given resource type level (e.g. without needing to choose a specific resource id for the context).")
    protected BooleanType type;
    @Child(name="instance", type={BooleanType.class}, order=9, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Invoke on an instance?", formalDefinition="Indicates whether this operation can be invoked on a particular instance of one of the given types.")
    protected BooleanType instance;
    @Child(name="inputProfile", type={CanonicalType.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Validation information for in parameters", formalDefinition="Additional validation information for the in parameters. The profile is a constraint on the parameters resource.")
    protected CanonicalType inputProfile;
    @Child(name="outputProfile", type={CanonicalType.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Validation information for out parameters", formalDefinition="Additional validation information for the out parameters. The profile is a constraint on the parameters resource.")
    protected CanonicalType outputProfile;
    @Child(name="parameter", type={}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Parameters for the operation/query", formalDefinition="The parameters for the operation/query.")
    protected List<OperationDefinitionParameterComponent> parameter;
    @Child(name="overload", type={}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Define overloaded variants for when  generating code", formalDefinition="Defines an appropriate combination of parameters to use when invoking this operation, to help code generators when generating overloaded parameter sets for this operation.")
    protected List<OperationDefinitionOverloadComponent> overload;
    private static final long serialVersionUID = 149113671L;
    @SearchParamDefinition(name="date", path="OperationDefinition.date", description="The operation definition publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="code", path="OperationDefinition.code", description="Name used to invoke the operation", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="instance", path="OperationDefinition.instance", description="Invoke on an instance?", type="token")
    public static final String SP_INSTANCE = "instance";
    public static final TokenClientParam INSTANCE = new TokenClientParam("instance");
    @SearchParamDefinition(name="kind", path="OperationDefinition.kind", description="operation | query", type="token")
    public static final String SP_KIND = "kind";
    public static final TokenClientParam KIND = new TokenClientParam("kind");
    @SearchParamDefinition(name="jurisdiction", path="OperationDefinition.jurisdiction", description="Intended jurisdiction for the operation definition", type="token")
    public static final String SP_JURISDICTION = "jurisdiction";
    public static final TokenClientParam JURISDICTION = new TokenClientParam("jurisdiction");
    @SearchParamDefinition(name="description", path="OperationDefinition.description", description="The description of the operation definition", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="context-type", path="OperationDefinition.useContext.code", description="A type of use context assigned to the operation definition", type="token")
    public static final String SP_CONTEXT_TYPE = "context-type";
    public static final TokenClientParam CONTEXT_TYPE = new TokenClientParam("context-type");
    @SearchParamDefinition(name="type", path="OperationDefinition.type", description="Invoke at the type level?", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="version", path="OperationDefinition.version", description="The business version of the operation definition", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");
    @SearchParamDefinition(name="url", path="OperationDefinition.url", description="The uri that identifies the operation definition", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="input-profile", path="OperationDefinition.inputProfile", description="Validation information for in parameters", type="reference", target={StructureDefinition.class})
    public static final String SP_INPUT_PROFILE = "input-profile";
    public static final ReferenceClientParam INPUT_PROFILE = new ReferenceClientParam("input-profile");
    public static final Include INCLUDE_INPUT_PROFILE = new Include("OperationDefinition:input-profile").toLocked();
    @SearchParamDefinition(name="output-profile", path="OperationDefinition.outputProfile", description="Validation information for out parameters", type="reference", target={StructureDefinition.class})
    public static final String SP_OUTPUT_PROFILE = "output-profile";
    public static final ReferenceClientParam OUTPUT_PROFILE = new ReferenceClientParam("output-profile");
    public static final Include INCLUDE_OUTPUT_PROFILE = new Include("OperationDefinition:output-profile").toLocked();
    @SearchParamDefinition(name="system", path="OperationDefinition.system", description="Invoke at the system level?", type="token")
    public static final String SP_SYSTEM = "system";
    public static final TokenClientParam SYSTEM = new TokenClientParam("system");
    @SearchParamDefinition(name="name", path="OperationDefinition.name", description="Computationally friendly name of the operation definition", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="publisher", path="OperationDefinition.publisher", description="Name of the publisher of the operation definition", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="status", path="OperationDefinition.status", description="The current status of the operation definition", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="base", path="OperationDefinition.base", description="Marks this as a profile of the base", type="reference", target={OperationDefinition.class})
    public static final String SP_BASE = "base";
    public static final ReferenceClientParam BASE = new ReferenceClientParam("base");
    public static final Include INCLUDE_BASE = new Include("OperationDefinition:base").toLocked();

    public OperationDefinition() {
    }

    public OperationDefinition(StringType name, Enumeration<Enumerations.PublicationStatus> status, Enumeration<OperationKind> kind, CodeType code, BooleanType system, BooleanType type, BooleanType instance) {
        this.name = name;
        this.status = status;
        this.kind = kind;
        this.code = code;
        this.system = system;
        this.type = type;
        this.instance = instance;
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public OperationDefinition setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public OperationDefinition setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public OperationDefinition setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public OperationDefinition setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public OperationDefinition setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public OperationDefinition setName(String value) {
        if (this.name == null) {
            this.name = new StringType();
        }
        this.name.setValue(value);
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public OperationDefinition setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public OperationDefinition setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public Enumeration<OperationKind> getKindElement() {
        if (this.kind == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.kind");
            }
            if (Configuration.doAutoCreate()) {
                this.kind = new Enumeration<OperationKind>(new OperationKindEnumFactory());
            }
        }
        return this.kind;
    }

    public boolean hasKindElement() {
        return this.kind != null && !this.kind.isEmpty();
    }

    public boolean hasKind() {
        return this.kind != null && !this.kind.isEmpty();
    }

    public OperationDefinition setKindElement(Enumeration<OperationKind> value) {
        this.kind = value;
        return this;
    }

    public OperationKind getKind() {
        return this.kind == null ? null : (OperationKind)((Object)this.kind.getValue());
    }

    public OperationDefinition setKind(OperationKind value) {
        if (this.kind == null) {
            this.kind = new Enumeration<OperationKind>(new OperationKindEnumFactory());
        }
        this.kind.setValue((Object)value);
        return this;
    }

    @Override
    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    @Override
    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public OperationDefinition setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    @Override
    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    @Override
    public OperationDefinition setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public OperationDefinition setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public OperationDefinition setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public OperationDefinition setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public OperationDefinition setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        return this.contact;
    }

    @Override
    public OperationDefinition setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public OperationDefinition addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    @Override
    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    @Override
    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public OperationDefinition setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    @Override
    public OperationDefinition setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        return this.useContext;
    }

    @Override
    public OperationDefinition setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public OperationDefinition addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        return this.jurisdiction;
    }

    @Override
    public OperationDefinition setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    @Override
    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return t;
    }

    @Override
    public OperationDefinition addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return this;
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    public MarkdownType getPurposeElement() {
        if (this.purpose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.purpose");
            }
            if (Configuration.doAutoCreate()) {
                this.purpose = new MarkdownType();
            }
        }
        return this.purpose;
    }

    public boolean hasPurposeElement() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public OperationDefinition setPurposeElement(MarkdownType value) {
        this.purpose = value;
        return this;
    }

    public String getPurpose() {
        return this.purpose == null ? null : (String)this.purpose.getValue();
    }

    public OperationDefinition setPurpose(String value) {
        if (value == null) {
            this.purpose = null;
        } else {
            if (this.purpose == null) {
                this.purpose = new MarkdownType();
            }
            this.purpose.setValue(value);
        }
        return this;
    }

    public BooleanType getAffectsStateElement() {
        if (this.affectsState == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.affectsState");
            }
            if (Configuration.doAutoCreate()) {
                this.affectsState = new BooleanType();
            }
        }
        return this.affectsState;
    }

    public boolean hasAffectsStateElement() {
        return this.affectsState != null && !this.affectsState.isEmpty();
    }

    public boolean hasAffectsState() {
        return this.affectsState != null && !this.affectsState.isEmpty();
    }

    public OperationDefinition setAffectsStateElement(BooleanType value) {
        this.affectsState = value;
        return this;
    }

    public boolean getAffectsState() {
        return this.affectsState == null || this.affectsState.isEmpty() ? false : (Boolean)this.affectsState.getValue();
    }

    public OperationDefinition setAffectsState(boolean value) {
        if (this.affectsState == null) {
            this.affectsState = new BooleanType();
        }
        this.affectsState.setValue((Object)value);
        return this;
    }

    public CodeType getCodeElement() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeType();
            }
        }
        return this.code;
    }

    public boolean hasCodeElement() {
        return this.code != null && !this.code.isEmpty();
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public OperationDefinition setCodeElement(CodeType value) {
        this.code = value;
        return this;
    }

    public String getCode() {
        return this.code == null ? null : (String)this.code.getValue();
    }

    public OperationDefinition setCode(String value) {
        if (this.code == null) {
            this.code = new CodeType();
        }
        this.code.setValue(value);
        return this;
    }

    public MarkdownType getCommentElement() {
        if (this.comment == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.comment");
            }
            if (Configuration.doAutoCreate()) {
                this.comment = new MarkdownType();
            }
        }
        return this.comment;
    }

    public boolean hasCommentElement() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public boolean hasComment() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public OperationDefinition setCommentElement(MarkdownType value) {
        this.comment = value;
        return this;
    }

    public String getComment() {
        return this.comment == null ? null : (String)this.comment.getValue();
    }

    public OperationDefinition setComment(String value) {
        if (value == null) {
            this.comment = null;
        } else {
            if (this.comment == null) {
                this.comment = new MarkdownType();
            }
            this.comment.setValue(value);
        }
        return this;
    }

    public CanonicalType getBaseElement() {
        if (this.base == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.base");
            }
            if (Configuration.doAutoCreate()) {
                this.base = new CanonicalType();
            }
        }
        return this.base;
    }

    public boolean hasBaseElement() {
        return this.base != null && !this.base.isEmpty();
    }

    public boolean hasBase() {
        return this.base != null && !this.base.isEmpty();
    }

    public OperationDefinition setBaseElement(CanonicalType value) {
        this.base = value;
        return this;
    }

    public String getBase() {
        return this.base == null ? null : (String)this.base.getValue();
    }

    public OperationDefinition setBase(String value) {
        if (Utilities.noString((String)value)) {
            this.base = null;
        } else {
            if (this.base == null) {
                this.base = new CanonicalType();
            }
            this.base.setValue(value);
        }
        return this;
    }

    public List<CodeType> getResource() {
        if (this.resource == null) {
            this.resource = new ArrayList<CodeType>();
        }
        return this.resource;
    }

    public OperationDefinition setResource(List<CodeType> theResource) {
        this.resource = theResource;
        return this;
    }

    public boolean hasResource() {
        if (this.resource == null) {
            return false;
        }
        for (CodeType item : this.resource) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeType addResourceElement() {
        CodeType t = new CodeType();
        if (this.resource == null) {
            this.resource = new ArrayList<CodeType>();
        }
        this.resource.add(t);
        return t;
    }

    public OperationDefinition addResource(String value) {
        CodeType t = new CodeType();
        t.setValue(value);
        if (this.resource == null) {
            this.resource = new ArrayList<CodeType>();
        }
        this.resource.add(t);
        return this;
    }

    public boolean hasResource(String value) {
        if (this.resource == null) {
            return false;
        }
        for (CodeType v : this.resource) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public BooleanType getSystemElement() {
        if (this.system == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.system");
            }
            if (Configuration.doAutoCreate()) {
                this.system = new BooleanType();
            }
        }
        return this.system;
    }

    public boolean hasSystemElement() {
        return this.system != null && !this.system.isEmpty();
    }

    public boolean hasSystem() {
        return this.system != null && !this.system.isEmpty();
    }

    public OperationDefinition setSystemElement(BooleanType value) {
        this.system = value;
        return this;
    }

    public boolean getSystem() {
        return this.system == null || this.system.isEmpty() ? false : (Boolean)this.system.getValue();
    }

    public OperationDefinition setSystem(boolean value) {
        if (this.system == null) {
            this.system = new BooleanType();
        }
        this.system.setValue((Object)value);
        return this;
    }

    public BooleanType getTypeElement() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new BooleanType();
            }
        }
        return this.type;
    }

    public boolean hasTypeElement() {
        return this.type != null && !this.type.isEmpty();
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public OperationDefinition setTypeElement(BooleanType value) {
        this.type = value;
        return this;
    }

    public boolean getType() {
        return this.type == null || this.type.isEmpty() ? false : (Boolean)this.type.getValue();
    }

    public OperationDefinition setType(boolean value) {
        if (this.type == null) {
            this.type = new BooleanType();
        }
        this.type.setValue((Object)value);
        return this;
    }

    public BooleanType getInstanceElement() {
        if (this.instance == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.instance");
            }
            if (Configuration.doAutoCreate()) {
                this.instance = new BooleanType();
            }
        }
        return this.instance;
    }

    public boolean hasInstanceElement() {
        return this.instance != null && !this.instance.isEmpty();
    }

    public boolean hasInstance() {
        return this.instance != null && !this.instance.isEmpty();
    }

    public OperationDefinition setInstanceElement(BooleanType value) {
        this.instance = value;
        return this;
    }

    public boolean getInstance() {
        return this.instance == null || this.instance.isEmpty() ? false : (Boolean)this.instance.getValue();
    }

    public OperationDefinition setInstance(boolean value) {
        if (this.instance == null) {
            this.instance = new BooleanType();
        }
        this.instance.setValue((Object)value);
        return this;
    }

    public CanonicalType getInputProfileElement() {
        if (this.inputProfile == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.inputProfile");
            }
            if (Configuration.doAutoCreate()) {
                this.inputProfile = new CanonicalType();
            }
        }
        return this.inputProfile;
    }

    public boolean hasInputProfileElement() {
        return this.inputProfile != null && !this.inputProfile.isEmpty();
    }

    public boolean hasInputProfile() {
        return this.inputProfile != null && !this.inputProfile.isEmpty();
    }

    public OperationDefinition setInputProfileElement(CanonicalType value) {
        this.inputProfile = value;
        return this;
    }

    public String getInputProfile() {
        return this.inputProfile == null ? null : (String)this.inputProfile.getValue();
    }

    public OperationDefinition setInputProfile(String value) {
        if (Utilities.noString((String)value)) {
            this.inputProfile = null;
        } else {
            if (this.inputProfile == null) {
                this.inputProfile = new CanonicalType();
            }
            this.inputProfile.setValue(value);
        }
        return this;
    }

    public CanonicalType getOutputProfileElement() {
        if (this.outputProfile == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OperationDefinition.outputProfile");
            }
            if (Configuration.doAutoCreate()) {
                this.outputProfile = new CanonicalType();
            }
        }
        return this.outputProfile;
    }

    public boolean hasOutputProfileElement() {
        return this.outputProfile != null && !this.outputProfile.isEmpty();
    }

    public boolean hasOutputProfile() {
        return this.outputProfile != null && !this.outputProfile.isEmpty();
    }

    public OperationDefinition setOutputProfileElement(CanonicalType value) {
        this.outputProfile = value;
        return this;
    }

    public String getOutputProfile() {
        return this.outputProfile == null ? null : (String)this.outputProfile.getValue();
    }

    public OperationDefinition setOutputProfile(String value) {
        if (Utilities.noString((String)value)) {
            this.outputProfile = null;
        } else {
            if (this.outputProfile == null) {
                this.outputProfile = new CanonicalType();
            }
            this.outputProfile.setValue(value);
        }
        return this;
    }

    public List<OperationDefinitionParameterComponent> getParameter() {
        if (this.parameter == null) {
            this.parameter = new ArrayList<OperationDefinitionParameterComponent>();
        }
        return this.parameter;
    }

    public OperationDefinition setParameter(List<OperationDefinitionParameterComponent> theParameter) {
        this.parameter = theParameter;
        return this;
    }

    public boolean hasParameter() {
        if (this.parameter == null) {
            return false;
        }
        for (OperationDefinitionParameterComponent item : this.parameter) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public OperationDefinitionParameterComponent addParameter() {
        OperationDefinitionParameterComponent t = new OperationDefinitionParameterComponent();
        if (this.parameter == null) {
            this.parameter = new ArrayList<OperationDefinitionParameterComponent>();
        }
        this.parameter.add(t);
        return t;
    }

    public OperationDefinition addParameter(OperationDefinitionParameterComponent t) {
        if (t == null) {
            return this;
        }
        if (this.parameter == null) {
            this.parameter = new ArrayList<OperationDefinitionParameterComponent>();
        }
        this.parameter.add(t);
        return this;
    }

    public OperationDefinitionParameterComponent getParameterFirstRep() {
        if (this.getParameter().isEmpty()) {
            this.addParameter();
        }
        return this.getParameter().get(0);
    }

    public List<OperationDefinitionOverloadComponent> getOverload() {
        if (this.overload == null) {
            this.overload = new ArrayList<OperationDefinitionOverloadComponent>();
        }
        return this.overload;
    }

    public OperationDefinition setOverload(List<OperationDefinitionOverloadComponent> theOverload) {
        this.overload = theOverload;
        return this;
    }

    public boolean hasOverload() {
        if (this.overload == null) {
            return false;
        }
        for (OperationDefinitionOverloadComponent item : this.overload) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public OperationDefinitionOverloadComponent addOverload() {
        OperationDefinitionOverloadComponent t = new OperationDefinitionOverloadComponent();
        if (this.overload == null) {
            this.overload = new ArrayList<OperationDefinitionOverloadComponent>();
        }
        this.overload.add(t);
        return t;
    }

    public OperationDefinition addOverload(OperationDefinitionOverloadComponent t) {
        if (t == null) {
            return this;
        }
        if (this.overload == null) {
            this.overload = new ArrayList<OperationDefinitionOverloadComponent>();
        }
        this.overload.add(t);
        return this;
    }

    public OperationDefinitionOverloadComponent getOverloadFirstRep() {
        if (this.getOverload().isEmpty()) {
            this.addOverload();
        }
        return this.getOverload().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this operation definition when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which this operation definition is (or will be) published.", 0, 1, this.url));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the operation definition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the operation definition author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version));
        children.add(new Property(SP_NAME, "string", "A natural language name identifying the operation definition. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property(SP_STATUS, SP_CODE, "The status of this operation definition. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property(SP_KIND, SP_CODE, "Whether this is an operation or a named query.", 0, 1, this.kind));
        children.add(new Property("experimental", "boolean", "A Boolean value to indicate that this operation definition is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the operation definition was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the operation definition changes.", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the operation definition.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the operation definition from a consumer's perspective.", 0, 1, this.description));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching for appropriate operation definition instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the operation definition is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("purpose", "markdown", "Explanation of why this operation definition is needed and why it has been designed as it has.", 0, 1, this.purpose));
        children.add(new Property("affectsState", "boolean", "Operations that have affects state = false (see [HTTP specification definition of idempotent](http://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html)) may be invoked by performing an HTTP GET operation instead of a POST.", 0, 1, this.affectsState));
        children.add(new Property(SP_CODE, SP_CODE, "The name used to invoke the operation.", 0, 1, this.code));
        children.add(new Property("comment", "markdown", "Additional information about how to use this operation or named query.", 0, 1, this.comment));
        children.add(new Property(SP_BASE, "canonical(OperationDefinition)", "Indicates that this operation definition is a constraining profile on the base.", 0, 1, this.base));
        children.add(new Property("resource", SP_CODE, "The types on which this operation can be executed.", 0, Integer.MAX_VALUE, this.resource));
        children.add(new Property(SP_SYSTEM, "boolean", "Indicates whether this operation or named query can be invoked at the system level (e.g. without needing to choose a resource type for the context).", 0, 1, this.system));
        children.add(new Property(SP_TYPE, "boolean", "Indicates whether this operation or named query can be invoked at the resource type level for any given resource type level (e.g. without needing to choose a specific resource id for the context).", 0, 1, this.type));
        children.add(new Property(SP_INSTANCE, "boolean", "Indicates whether this operation can be invoked on a particular instance of one of the given types.", 0, 1, this.instance));
        children.add(new Property("inputProfile", "canonical(StructureDefinition)", "Additional validation information for the in parameters. The profile is a constraint on the parameters resource.", 0, 1, this.inputProfile));
        children.add(new Property("outputProfile", "canonical(StructureDefinition)", "Additional validation information for the out parameters. The profile is a constraint on the parameters resource.", 0, 1, this.outputProfile));
        children.add(new Property("parameter", "", "The parameters for the operation/query.", 0, Integer.MAX_VALUE, this.parameter));
        children.add(new Property("overload", "", "Defines an appropriate combination of parameters to use when invoking this operation, to help code generators when generating overloaded parameter sets for this operation.", 0, Integer.MAX_VALUE, this.overload));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this operation definition when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which this operation definition is (or will be) published.", 0, 1, this.url);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the operation definition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the operation definition author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A natural language name identifying the operation definition. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case -892481550: {
                return new Property(SP_STATUS, SP_CODE, "The status of this operation definition. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case 3292052: {
                return new Property(SP_KIND, SP_CODE, "Whether this is an operation or a named query.", 0, 1, this.kind);
            }
            case -404562712: {
                return new Property("experimental", "boolean", "A Boolean value to indicate that this operation definition is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the operation definition was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the operation definition changes.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the operation definition.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the operation definition from a consumer's perspective.", 0, 1, this.description);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching for appropriate operation definition instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the operation definition is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case -220463842: {
                return new Property("purpose", "markdown", "Explanation of why this operation definition is needed and why it has been designed as it has.", 0, 1, this.purpose);
            }
            case -14805197: {
                return new Property("affectsState", "boolean", "Operations that have affects state = false (see [HTTP specification definition of idempotent](http://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html)) may be invoked by performing an HTTP GET operation instead of a POST.", 0, 1, this.affectsState);
            }
            case 3059181: {
                return new Property(SP_CODE, SP_CODE, "The name used to invoke the operation.", 0, 1, this.code);
            }
            case 950398559: {
                return new Property("comment", "markdown", "Additional information about how to use this operation or named query.", 0, 1, this.comment);
            }
            case 3016401: {
                return new Property(SP_BASE, "canonical(OperationDefinition)", "Indicates that this operation definition is a constraining profile on the base.", 0, 1, this.base);
            }
            case -341064690: {
                return new Property("resource", SP_CODE, "The types on which this operation can be executed.", 0, Integer.MAX_VALUE, this.resource);
            }
            case -887328209: {
                return new Property(SP_SYSTEM, "boolean", "Indicates whether this operation or named query can be invoked at the system level (e.g. without needing to choose a resource type for the context).", 0, 1, this.system);
            }
            case 3575610: {
                return new Property(SP_TYPE, "boolean", "Indicates whether this operation or named query can be invoked at the resource type level for any given resource type level (e.g. without needing to choose a specific resource id for the context).", 0, 1, this.type);
            }
            case 555127957: {
                return new Property(SP_INSTANCE, "boolean", "Indicates whether this operation can be invoked on a particular instance of one of the given types.", 0, 1, this.instance);
            }
            case 676942463: {
                return new Property("inputProfile", "canonical(StructureDefinition)", "Additional validation information for the in parameters. The profile is a constraint on the parameters resource.", 0, 1, this.inputProfile);
            }
            case 1826166120: {
                return new Property("outputProfile", "canonical(StructureDefinition)", "Additional validation information for the out parameters. The profile is a constraint on the parameters resource.", 0, 1, this.outputProfile);
            }
            case 1954460585: {
                return new Property("parameter", "", "The parameters for the operation/query.", 0, Integer.MAX_VALUE, this.parameter);
            }
            case 529823674: {
                return new Property("overload", "", "Defines an appropriate combination of parameters to use when invoking this operation, to help code generators when generating overloaded parameter sets for this operation.", 0, Integer.MAX_VALUE, this.overload);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.status;
                }
                return baseArray;
            }
            case 3292052: {
                Base[] baseArray;
                if (this.kind == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.kind;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.experimental;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case -220463842: {
                Base[] baseArray;
                if (this.purpose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.purpose;
                }
                return baseArray;
            }
            case -14805197: {
                Base[] baseArray;
                if (this.affectsState == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.affectsState;
                }
                return baseArray;
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.code;
                }
                return baseArray;
            }
            case 950398559: {
                Base[] baseArray;
                if (this.comment == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.comment;
                }
                return baseArray;
            }
            case 3016401: {
                Base[] baseArray;
                if (this.base == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.base;
                }
                return baseArray;
            }
            case -341064690: {
                return this.resource == null ? new Base[]{} : this.resource.toArray(new Base[this.resource.size()]);
            }
            case -887328209: {
                Base[] baseArray;
                if (this.system == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.system;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray17 = new Base[1];
                    baseArray = baseArray17;
                    baseArray17[0] = this.type;
                }
                return baseArray;
            }
            case 555127957: {
                Base[] baseArray;
                if (this.instance == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray18 = new Base[1];
                    baseArray = baseArray18;
                    baseArray18[0] = this.instance;
                }
                return baseArray;
            }
            case 676942463: {
                Base[] baseArray;
                if (this.inputProfile == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray19 = new Base[1];
                    baseArray = baseArray19;
                    baseArray19[0] = this.inputProfile;
                }
                return baseArray;
            }
            case 1826166120: {
                Base[] baseArray;
                if (this.outputProfile == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray20 = new Base[1];
                    baseArray = baseArray20;
                    baseArray20[0] = this.outputProfile;
                }
                return baseArray;
            }
            case 1954460585: {
                return this.parameter == null ? new Base[]{} : this.parameter.toArray(new Base[this.parameter.size()]);
            }
            case 529823674: {
                return this.overload == null ? new Base[]{} : this.overload.toArray(new Base[this.overload.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = this.castToUri(value);
                return value;
            }
            case 351608024: {
                this.version = this.castToString(value);
                return value;
            }
            case 3373707: {
                this.name = this.castToString(value);
                return value;
            }
            case -892481550: {
                this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
                return value;
            }
            case 3292052: {
                value = new OperationKindEnumFactory().fromType(this.castToCode(value));
                this.kind = value;
                return value;
            }
            case -404562712: {
                this.experimental = this.castToBoolean(value);
                return value;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = this.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(this.castToContactDetail(value));
                return value;
            }
            case -1724546052: {
                this.description = this.castToMarkdown(value);
                return value;
            }
            case -669707736: {
                this.getUseContext().add(this.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(this.castToCodeableConcept(value));
                return value;
            }
            case -220463842: {
                this.purpose = this.castToMarkdown(value);
                return value;
            }
            case -14805197: {
                this.affectsState = this.castToBoolean(value);
                return value;
            }
            case 3059181: {
                this.code = this.castToCode(value);
                return value;
            }
            case 950398559: {
                this.comment = this.castToMarkdown(value);
                return value;
            }
            case 3016401: {
                this.base = this.castToCanonical(value);
                return value;
            }
            case -341064690: {
                this.getResource().add(this.castToCode(value));
                return value;
            }
            case -887328209: {
                this.system = this.castToBoolean(value);
                return value;
            }
            case 3575610: {
                this.type = this.castToBoolean(value);
                return value;
            }
            case 555127957: {
                this.instance = this.castToBoolean(value);
                return value;
            }
            case 676942463: {
                this.inputProfile = this.castToCanonical(value);
                return value;
            }
            case 1826166120: {
                this.outputProfile = this.castToCanonical(value);
                return value;
            }
            case 1954460585: {
                this.getParameter().add((OperationDefinitionParameterComponent)((Object)value));
                return value;
            }
            case 529823674: {
                this.getOverload().add((OperationDefinitionOverloadComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = this.castToUri(value);
        } else if (name.equals(SP_VERSION)) {
            this.version = this.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = this.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
        } else if (name.equals(SP_KIND)) {
            value = new OperationKindEnumFactory().fromType(this.castToCode(value));
            this.kind = value;
        } else if (name.equals("experimental")) {
            this.experimental = this.castToBoolean(value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = this.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(this.castToContactDetail(value));
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = this.castToMarkdown(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(this.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().add(this.castToCodeableConcept(value));
        } else if (name.equals("purpose")) {
            this.purpose = this.castToMarkdown(value);
        } else if (name.equals("affectsState")) {
            this.affectsState = this.castToBoolean(value);
        } else if (name.equals(SP_CODE)) {
            this.code = this.castToCode(value);
        } else if (name.equals("comment")) {
            this.comment = this.castToMarkdown(value);
        } else if (name.equals(SP_BASE)) {
            this.base = this.castToCanonical(value);
        } else if (name.equals("resource")) {
            this.getResource().add(this.castToCode(value));
        } else if (name.equals(SP_SYSTEM)) {
            this.system = this.castToBoolean(value);
        } else if (name.equals(SP_TYPE)) {
            this.type = this.castToBoolean(value);
        } else if (name.equals(SP_INSTANCE)) {
            this.instance = this.castToBoolean(value);
        } else if (name.equals("inputProfile")) {
            this.inputProfile = this.castToCanonical(value);
        } else if (name.equals("outputProfile")) {
            this.outputProfile = this.castToCanonical(value);
        } else if (name.equals("parameter")) {
            this.getParameter().add((OperationDefinitionParameterComponent)((Object)value));
        } else if (name.equals("overload")) {
            this.getOverload().add((OperationDefinitionOverloadComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 3292052: {
                return this.getKindElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case -220463842: {
                return this.getPurposeElement();
            }
            case -14805197: {
                return this.getAffectsStateElement();
            }
            case 3059181: {
                return this.getCodeElement();
            }
            case 950398559: {
                return this.getCommentElement();
            }
            case 3016401: {
                return this.getBaseElement();
            }
            case -341064690: {
                return this.addResourceElement();
            }
            case -887328209: {
                return this.getSystemElement();
            }
            case 3575610: {
                return this.getTypeElement();
            }
            case 555127957: {
                return this.getInstanceElement();
            }
            case 676942463: {
                return this.getInputProfileElement();
            }
            case 1826166120: {
                return this.getOutputProfileElement();
            }
            case 1954460585: {
                return this.addParameter();
            }
            case 529823674: {
                return this.addOverload();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case 3292052: {
                return new String[]{SP_CODE};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case -220463842: {
                return new String[]{"markdown"};
            }
            case -14805197: {
                return new String[]{"boolean"};
            }
            case 3059181: {
                return new String[]{SP_CODE};
            }
            case 950398559: {
                return new String[]{"markdown"};
            }
            case 3016401: {
                return new String[]{"canonical"};
            }
            case -341064690: {
                return new String[]{SP_CODE};
            }
            case -887328209: {
                return new String[]{"boolean"};
            }
            case 3575610: {
                return new String[]{"boolean"};
            }
            case 555127957: {
                return new String[]{"boolean"};
            }
            case 676942463: {
                return new String[]{"canonical"};
            }
            case 1826166120: {
                return new String[]{"canonical"};
            }
            case 1954460585: {
                return new String[0];
            }
            case 529823674: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.url");
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.version");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.name");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.status");
        }
        if (name.equals(SP_KIND)) {
            throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.kind");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.experimental");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_JURISDICTION)) {
            return this.addJurisdiction();
        }
        if (name.equals("purpose")) {
            throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.purpose");
        }
        if (name.equals("affectsState")) {
            throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.affectsState");
        }
        if (name.equals(SP_CODE)) {
            throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.code");
        }
        if (name.equals("comment")) {
            throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.comment");
        }
        if (name.equals(SP_BASE)) {
            throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.base");
        }
        if (name.equals("resource")) {
            throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.resource");
        }
        if (name.equals(SP_SYSTEM)) {
            throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.system");
        }
        if (name.equals(SP_TYPE)) {
            throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.type");
        }
        if (name.equals(SP_INSTANCE)) {
            throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.instance");
        }
        if (name.equals("inputProfile")) {
            throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.inputProfile");
        }
        if (name.equals("outputProfile")) {
            throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.outputProfile");
        }
        if (name.equals("parameter")) {
            return this.addParameter();
        }
        if (name.equals("overload")) {
            return this.addOverload();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "OperationDefinition";
    }

    @Override
    public OperationDefinition copy() {
        OperationDefinition dst = new OperationDefinition();
        this.copyValues(dst);
        dst.url = this.url == null ? null : this.url.copy();
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.kind = this.kind == null ? null : this.kind.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.purpose = this.purpose == null ? null : this.purpose.copy();
        dst.affectsState = this.affectsState == null ? null : this.affectsState.copy();
        dst.code = this.code == null ? null : this.code.copy();
        dst.comment = this.comment == null ? null : this.comment.copy();
        CanonicalType canonicalType = dst.base = this.base == null ? null : this.base.copy();
        if (this.resource != null) {
            dst.resource = new ArrayList<CodeType>();
            for (CodeType codeType : this.resource) {
                dst.resource.add(codeType.copy());
            }
        }
        dst.system = this.system == null ? null : this.system.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.instance = this.instance == null ? null : this.instance.copy();
        dst.inputProfile = this.inputProfile == null ? null : this.inputProfile.copy();
        CanonicalType canonicalType2 = dst.outputProfile = this.outputProfile == null ? null : this.outputProfile.copy();
        if (this.parameter != null) {
            dst.parameter = new ArrayList<OperationDefinitionParameterComponent>();
            for (OperationDefinitionParameterComponent operationDefinitionParameterComponent : this.parameter) {
                dst.parameter.add(operationDefinitionParameterComponent.copy());
            }
        }
        if (this.overload != null) {
            dst.overload = new ArrayList<OperationDefinitionOverloadComponent>();
            for (OperationDefinitionOverloadComponent operationDefinitionOverloadComponent : this.overload) {
                dst.overload.add(operationDefinitionOverloadComponent.copy());
            }
        }
        return dst;
    }

    protected OperationDefinition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof OperationDefinition)) {
            return false;
        }
        OperationDefinition o = (OperationDefinition)other_;
        return OperationDefinition.compareDeep(this.kind, o.kind, true) && OperationDefinition.compareDeep(this.purpose, o.purpose, true) && OperationDefinition.compareDeep(this.affectsState, o.affectsState, true) && OperationDefinition.compareDeep(this.code, o.code, true) && OperationDefinition.compareDeep(this.comment, o.comment, true) && OperationDefinition.compareDeep(this.base, o.base, true) && OperationDefinition.compareDeep(this.resource, o.resource, true) && OperationDefinition.compareDeep(this.system, o.system, true) && OperationDefinition.compareDeep(this.type, o.type, true) && OperationDefinition.compareDeep(this.instance, o.instance, true) && OperationDefinition.compareDeep(this.inputProfile, o.inputProfile, true) && OperationDefinition.compareDeep(this.outputProfile, o.outputProfile, true) && OperationDefinition.compareDeep(this.parameter, o.parameter, true) && OperationDefinition.compareDeep(this.overload, o.overload, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof OperationDefinition)) {
            return false;
        }
        OperationDefinition o = (OperationDefinition)other_;
        return OperationDefinition.compareValues(this.kind, o.kind, true) && OperationDefinition.compareValues(this.purpose, o.purpose, true) && OperationDefinition.compareValues(this.affectsState, o.affectsState, true) && OperationDefinition.compareValues(this.code, o.code, true) && OperationDefinition.compareValues(this.comment, o.comment, true) && OperationDefinition.compareValues(this.resource, o.resource, true) && OperationDefinition.compareValues(this.system, o.system, true) && OperationDefinition.compareValues(this.type, o.type, true) && OperationDefinition.compareValues(this.instance, o.instance, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.kind, this.purpose, this.affectsState, this.code, this.comment, this.base, this.resource, this.system, this.type, this.instance, this.inputProfile, this.outputProfile, this.parameter, this.overload});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.OperationDefinition;
    }

    @Block
    public static class OperationDefinitionOverloadComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="parameterName", type={StringType.class}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Name of parameter to include in overload", formalDefinition="Name of parameter to include in overload.")
        protected List<StringType> parameterName;
        @Child(name="comment", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Comments to go on overload", formalDefinition="Comments to go on overload.")
        protected StringType comment;
        private static final long serialVersionUID = -907948545L;

        public List<StringType> getParameterName() {
            if (this.parameterName == null) {
                this.parameterName = new ArrayList<StringType>();
            }
            return this.parameterName;
        }

        public OperationDefinitionOverloadComponent setParameterName(List<StringType> theParameterName) {
            this.parameterName = theParameterName;
            return this;
        }

        public boolean hasParameterName() {
            if (this.parameterName == null) {
                return false;
            }
            for (StringType item : this.parameterName) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addParameterNameElement() {
            StringType t = new StringType();
            if (this.parameterName == null) {
                this.parameterName = new ArrayList<StringType>();
            }
            this.parameterName.add(t);
            return t;
        }

        public OperationDefinitionOverloadComponent addParameterName(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.parameterName == null) {
                this.parameterName = new ArrayList<StringType>();
            }
            this.parameterName.add(t);
            return this;
        }

        public boolean hasParameterName(String value) {
            if (this.parameterName == null) {
                return false;
            }
            for (StringType v : this.parameterName) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public StringType getCommentElement() {
            if (this.comment == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OperationDefinitionOverloadComponent.comment");
                }
                if (Configuration.doAutoCreate()) {
                    this.comment = new StringType();
                }
            }
            return this.comment;
        }

        public boolean hasCommentElement() {
            return this.comment != null && !this.comment.isEmpty();
        }

        public boolean hasComment() {
            return this.comment != null && !this.comment.isEmpty();
        }

        public OperationDefinitionOverloadComponent setCommentElement(StringType value) {
            this.comment = value;
            return this;
        }

        public String getComment() {
            return this.comment == null ? null : (String)this.comment.getValue();
        }

        public OperationDefinitionOverloadComponent setComment(String value) {
            if (Utilities.noString((String)value)) {
                this.comment = null;
            } else {
                if (this.comment == null) {
                    this.comment = new StringType();
                }
                this.comment.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("parameterName", "string", "Name of parameter to include in overload.", 0, Integer.MAX_VALUE, this.parameterName));
            children.add(new Property("comment", "string", "Comments to go on overload.", 0, 1, this.comment));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -379607596: {
                    return new Property("parameterName", "string", "Name of parameter to include in overload.", 0, Integer.MAX_VALUE, this.parameterName);
                }
                case 950398559: {
                    return new Property("comment", "string", "Comments to go on overload.", 0, 1, this.comment);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -379607596: {
                    return this.parameterName == null ? new Base[]{} : this.parameterName.toArray(new Base[this.parameterName.size()]);
                }
                case 950398559: {
                    Base[] baseArray;
                    if (this.comment == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.comment;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -379607596: {
                    this.getParameterName().add(this.castToString(value));
                    return value;
                }
                case 950398559: {
                    this.comment = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("parameterName")) {
                this.getParameterName().add(this.castToString(value));
            } else if (name.equals("comment")) {
                this.comment = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -379607596: {
                    return this.addParameterNameElement();
                }
                case 950398559: {
                    return this.getCommentElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -379607596: {
                    return new String[]{"string"};
                }
                case 950398559: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("parameterName")) {
                throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.parameterName");
            }
            if (name.equals("comment")) {
                throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.comment");
            }
            return super.addChild(name);
        }

        @Override
        public OperationDefinitionOverloadComponent copy() {
            OperationDefinitionOverloadComponent dst = new OperationDefinitionOverloadComponent();
            this.copyValues(dst);
            if (this.parameterName != null) {
                dst.parameterName = new ArrayList<StringType>();
                for (StringType i : this.parameterName) {
                    dst.parameterName.add(i.copy());
                }
            }
            dst.comment = this.comment == null ? null : this.comment.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof OperationDefinitionOverloadComponent)) {
                return false;
            }
            OperationDefinitionOverloadComponent o = (OperationDefinitionOverloadComponent)other_;
            return OperationDefinitionOverloadComponent.compareDeep(this.parameterName, o.parameterName, true) && OperationDefinitionOverloadComponent.compareDeep(this.comment, o.comment, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof OperationDefinitionOverloadComponent)) {
                return false;
            }
            OperationDefinitionOverloadComponent o = (OperationDefinitionOverloadComponent)other_;
            return OperationDefinitionOverloadComponent.compareValues(this.parameterName, o.parameterName, true) && OperationDefinitionOverloadComponent.compareValues(this.comment, o.comment, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.parameterName, this.comment});
        }

        @Override
        public String fhirType() {
            return "OperationDefinition.overload";
        }
    }

    @Block
    public static class OperationDefinitionParameterBindingComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="strength", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="required | extensible | preferred | example", formalDefinition="Indicates the degree of conformance expectations associated with this binding - that is, the degree to which the provided value set must be adhered to in the instances.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/binding-strength")
        protected Enumeration<Enumerations.BindingStrength> strength;
        @Child(name="valueSet", type={UriType.class, CanonicalType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Source of value set", formalDefinition="Points to the value set or external definition (e.g. implicit value set) that identifies the set of codes to be used.")
        protected Type valueSet;
        private static final long serialVersionUID = 857140521L;

        public OperationDefinitionParameterBindingComponent() {
        }

        public OperationDefinitionParameterBindingComponent(Enumeration<Enumerations.BindingStrength> strength, Type valueSet) {
            this.strength = strength;
            this.valueSet = valueSet;
        }

        public Enumeration<Enumerations.BindingStrength> getStrengthElement() {
            if (this.strength == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OperationDefinitionParameterBindingComponent.strength");
                }
                if (Configuration.doAutoCreate()) {
                    this.strength = new Enumeration<Enumerations.BindingStrength>(new Enumerations.BindingStrengthEnumFactory());
                }
            }
            return this.strength;
        }

        public boolean hasStrengthElement() {
            return this.strength != null && !this.strength.isEmpty();
        }

        public boolean hasStrength() {
            return this.strength != null && !this.strength.isEmpty();
        }

        public OperationDefinitionParameterBindingComponent setStrengthElement(Enumeration<Enumerations.BindingStrength> value) {
            this.strength = value;
            return this;
        }

        public Enumerations.BindingStrength getStrength() {
            return this.strength == null ? null : (Enumerations.BindingStrength)((Object)this.strength.getValue());
        }

        public OperationDefinitionParameterBindingComponent setStrength(Enumerations.BindingStrength value) {
            if (this.strength == null) {
                this.strength = new Enumeration<Enumerations.BindingStrength>(new Enumerations.BindingStrengthEnumFactory());
            }
            this.strength.setValue((Object)value);
            return this;
        }

        public Type getValueSet() {
            return this.valueSet;
        }

        public UriType getValueSetUriType() throws FHIRException {
            if (this.valueSet == null) {
                return null;
            }
            if (!(this.valueSet instanceof UriType)) {
                throw new FHIRException("Type mismatch: the type UriType was expected, but " + this.valueSet.getClass().getName() + " was encountered");
            }
            return (UriType)this.valueSet;
        }

        public boolean hasValueSetUriType() {
            return this != null && this.valueSet instanceof UriType;
        }

        public CanonicalType getValueSetCanonicalType() throws FHIRException {
            if (this.valueSet == null) {
                return null;
            }
            if (!(this.valueSet instanceof CanonicalType)) {
                throw new FHIRException("Type mismatch: the type CanonicalType was expected, but " + this.valueSet.getClass().getName() + " was encountered");
            }
            return (CanonicalType)this.valueSet;
        }

        public boolean hasValueSetCanonicalType() {
            return this != null && this.valueSet instanceof CanonicalType;
        }

        public boolean hasValueSet() {
            return this.valueSet != null && !this.valueSet.isEmpty();
        }

        public OperationDefinitionParameterBindingComponent setValueSet(Type value) {
            if (value != null && !(value instanceof UriType) && !(value instanceof CanonicalType)) {
                throw new Error("Not the right type for OperationDefinition.parameter.binding.valueSet[x]: " + value.fhirType());
            }
            this.valueSet = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("strength", OperationDefinition.SP_CODE, "Indicates the degree of conformance expectations associated with this binding - that is, the degree to which the provided value set must be adhered to in the instances.", 0, 1, this.strength));
            children.add(new Property("valueSet[x]", "uri|canonical(ValueSet)", "Points to the value set or external definition (e.g. implicit value set) that identifies the set of codes to be used.", 0, 1, this.valueSet));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1791316033: {
                    return new Property("strength", OperationDefinition.SP_CODE, "Indicates the degree of conformance expectations associated with this binding - that is, the degree to which the provided value set must be adhered to in the instances.", 0, 1, this.strength);
                }
                case -1438410321: {
                    return new Property("valueSet[x]", "uri|canonical(ValueSet)", "Points to the value set or external definition (e.g. implicit value set) that identifies the set of codes to be used.", 0, 1, this.valueSet);
                }
                case -1410174671: {
                    return new Property("valueSet[x]", "uri|canonical(ValueSet)", "Points to the value set or external definition (e.g. implicit value set) that identifies the set of codes to be used.", 0, 1, this.valueSet);
                }
                case -1438416261: {
                    return new Property("valueSet[x]", "uri|canonical(ValueSet)", "Points to the value set or external definition (e.g. implicit value set) that identifies the set of codes to be used.", 0, 1, this.valueSet);
                }
                case 2048727747: {
                    return new Property("valueSet[x]", "uri|canonical(ValueSet)", "Points to the value set or external definition (e.g. implicit value set) that identifies the set of codes to be used.", 0, 1, this.valueSet);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1791316033: {
                    Base[] baseArray;
                    if (this.strength == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.strength;
                    }
                    return baseArray;
                }
                case -1410174671: {
                    Base[] baseArray;
                    if (this.valueSet == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.valueSet;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1791316033: {
                    value = new Enumerations.BindingStrengthEnumFactory().fromType(this.castToCode(value));
                    this.strength = value;
                    return value;
                }
                case -1410174671: {
                    this.valueSet = this.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("strength")) {
                value = new Enumerations.BindingStrengthEnumFactory().fromType(this.castToCode(value));
                this.strength = value;
            } else if (name.equals("valueSet[x]")) {
                this.valueSet = this.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1791316033: {
                    return this.getStrengthElement();
                }
                case -1438410321: {
                    return this.getValueSet();
                }
                case -1410174671: {
                    return this.getValueSet();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1791316033: {
                    return new String[]{OperationDefinition.SP_CODE};
                }
                case -1410174671: {
                    return new String[]{"uri", "canonical"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("strength")) {
                throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.strength");
            }
            if (name.equals("valueSetUri")) {
                this.valueSet = new UriType();
                return this.valueSet;
            }
            if (name.equals("valueSetCanonical")) {
                this.valueSet = new CanonicalType();
                return this.valueSet;
            }
            return super.addChild(name);
        }

        @Override
        public OperationDefinitionParameterBindingComponent copy() {
            OperationDefinitionParameterBindingComponent dst = new OperationDefinitionParameterBindingComponent();
            this.copyValues(dst);
            dst.strength = this.strength == null ? null : this.strength.copy();
            dst.valueSet = this.valueSet == null ? null : this.valueSet.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof OperationDefinitionParameterBindingComponent)) {
                return false;
            }
            OperationDefinitionParameterBindingComponent o = (OperationDefinitionParameterBindingComponent)other_;
            return OperationDefinitionParameterBindingComponent.compareDeep(this.strength, o.strength, true) && OperationDefinitionParameterBindingComponent.compareDeep(this.valueSet, o.valueSet, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof OperationDefinitionParameterBindingComponent)) {
                return false;
            }
            OperationDefinitionParameterBindingComponent o = (OperationDefinitionParameterBindingComponent)other_;
            return OperationDefinitionParameterBindingComponent.compareValues(this.strength, o.strength, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.strength, this.valueSet});
        }

        @Override
        public String fhirType() {
            return "OperationDefinition.parameter.binding";
        }
    }

    @Block
    public static class OperationDefinitionParameterComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Name in Parameters.parameter.name or in URL", formalDefinition="The name of used to identify the parameter.")
        protected CodeType name;
        @Child(name="use", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="in | out", formalDefinition="Whether this is an input or an output parameter.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/operation-parameter-use")
        protected Enumeration<OperationParameterUse> use;
        @Child(name="min", type={IntegerType.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Minimum Cardinality", formalDefinition="The minimum number of times this parameter SHALL appear in the request or response.")
        protected IntegerType min;
        @Child(name="max", type={StringType.class}, order=4, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Maximum Cardinality (a number or *)", formalDefinition="The maximum number of times this element is permitted to appear in the request or response.")
        protected StringType max;
        @Child(name="documentation", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of meaning/use", formalDefinition="Describes the meaning or use of this parameter.")
        protected StringType documentation;
        @Child(name="type", type={CodeType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What type this parameter has", formalDefinition="The type for this parameter.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/all-types")
        protected CodeType type;
        @Child(name="targetProfile", type={CanonicalType.class}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="If type is Reference, allowed targets", formalDefinition="If the type is \"Reference\", then targetProfile lists a one or more profiles that the Reference can refer to.")
        protected List<CanonicalType> targetProfile;
        @Child(name="searchType", type={CodeType.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="number | date | string | token | reference | composite | quantity | uri", formalDefinition="How the parameter is understood as a search parameter. This is only used if the parameter type is 'string'.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/search-param-type")
        protected Enumeration<Enumerations.SearchParamType> searchType;
        @Child(name="binding", type={}, order=9, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="ValueSet details if this is coded", formalDefinition="Binds to a value set if this parameter is coded (code, Coding, CodeableConcept).")
        protected OperationDefinitionParameterBindingComponent binding;
        @Child(name="part", type={OperationDefinitionParameterComponent.class}, order=10, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Parts of a nested Parameter", formalDefinition="The parts of a nested Parameter.")
        protected List<OperationDefinitionParameterComponent> part;
        private static final long serialVersionUID = 2140320275L;

        public OperationDefinitionParameterComponent() {
        }

        public OperationDefinitionParameterComponent(CodeType name, Enumeration<OperationParameterUse> use, IntegerType min, StringType max) {
            this.name = name;
            this.use = use;
            this.min = min;
            this.max = max;
        }

        public CodeType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OperationDefinitionParameterComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new CodeType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public OperationDefinitionParameterComponent setNameElement(CodeType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public OperationDefinitionParameterComponent setName(String value) {
            if (this.name == null) {
                this.name = new CodeType();
            }
            this.name.setValue(value);
            return this;
        }

        public Enumeration<OperationParameterUse> getUseElement() {
            if (this.use == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OperationDefinitionParameterComponent.use");
                }
                if (Configuration.doAutoCreate()) {
                    this.use = new Enumeration<OperationParameterUse>(new OperationParameterUseEnumFactory());
                }
            }
            return this.use;
        }

        public boolean hasUseElement() {
            return this.use != null && !this.use.isEmpty();
        }

        public boolean hasUse() {
            return this.use != null && !this.use.isEmpty();
        }

        public OperationDefinitionParameterComponent setUseElement(Enumeration<OperationParameterUse> value) {
            this.use = value;
            return this;
        }

        public OperationParameterUse getUse() {
            return this.use == null ? null : (OperationParameterUse)((Object)this.use.getValue());
        }

        public OperationDefinitionParameterComponent setUse(OperationParameterUse value) {
            if (this.use == null) {
                this.use = new Enumeration<OperationParameterUse>(new OperationParameterUseEnumFactory());
            }
            this.use.setValue((Object)value);
            return this;
        }

        public IntegerType getMinElement() {
            if (this.min == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OperationDefinitionParameterComponent.min");
                }
                if (Configuration.doAutoCreate()) {
                    this.min = new IntegerType();
                }
            }
            return this.min;
        }

        public boolean hasMinElement() {
            return this.min != null && !this.min.isEmpty();
        }

        public boolean hasMin() {
            return this.min != null && !this.min.isEmpty();
        }

        public OperationDefinitionParameterComponent setMinElement(IntegerType value) {
            this.min = value;
            return this;
        }

        public int getMin() {
            return this.min == null || this.min.isEmpty() ? 0 : (Integer)this.min.getValue();
        }

        public OperationDefinitionParameterComponent setMin(int value) {
            if (this.min == null) {
                this.min = new IntegerType();
            }
            this.min.setValue((Object)value);
            return this;
        }

        public StringType getMaxElement() {
            if (this.max == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OperationDefinitionParameterComponent.max");
                }
                if (Configuration.doAutoCreate()) {
                    this.max = new StringType();
                }
            }
            return this.max;
        }

        public boolean hasMaxElement() {
            return this.max != null && !this.max.isEmpty();
        }

        public boolean hasMax() {
            return this.max != null && !this.max.isEmpty();
        }

        public OperationDefinitionParameterComponent setMaxElement(StringType value) {
            this.max = value;
            return this;
        }

        public String getMax() {
            return this.max == null ? null : (String)this.max.getValue();
        }

        public OperationDefinitionParameterComponent setMax(String value) {
            if (this.max == null) {
                this.max = new StringType();
            }
            this.max.setValue(value);
            return this;
        }

        public StringType getDocumentationElement() {
            if (this.documentation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OperationDefinitionParameterComponent.documentation");
                }
                if (Configuration.doAutoCreate()) {
                    this.documentation = new StringType();
                }
            }
            return this.documentation;
        }

        public boolean hasDocumentationElement() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public boolean hasDocumentation() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public OperationDefinitionParameterComponent setDocumentationElement(StringType value) {
            this.documentation = value;
            return this;
        }

        public String getDocumentation() {
            return this.documentation == null ? null : (String)this.documentation.getValue();
        }

        public OperationDefinitionParameterComponent setDocumentation(String value) {
            if (Utilities.noString((String)value)) {
                this.documentation = null;
            } else {
                if (this.documentation == null) {
                    this.documentation = new StringType();
                }
                this.documentation.setValue(value);
            }
            return this;
        }

        public CodeType getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OperationDefinitionParameterComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeType();
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public OperationDefinitionParameterComponent setTypeElement(CodeType value) {
            this.type = value;
            return this;
        }

        public String getType() {
            return this.type == null ? null : (String)this.type.getValue();
        }

        public OperationDefinitionParameterComponent setType(String value) {
            if (Utilities.noString((String)value)) {
                this.type = null;
            } else {
                if (this.type == null) {
                    this.type = new CodeType();
                }
                this.type.setValue(value);
            }
            return this;
        }

        public List<CanonicalType> getTargetProfile() {
            if (this.targetProfile == null) {
                this.targetProfile = new ArrayList<CanonicalType>();
            }
            return this.targetProfile;
        }

        public OperationDefinitionParameterComponent setTargetProfile(List<CanonicalType> theTargetProfile) {
            this.targetProfile = theTargetProfile;
            return this;
        }

        public boolean hasTargetProfile() {
            if (this.targetProfile == null) {
                return false;
            }
            for (CanonicalType item : this.targetProfile) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CanonicalType addTargetProfileElement() {
            CanonicalType t = new CanonicalType();
            if (this.targetProfile == null) {
                this.targetProfile = new ArrayList<CanonicalType>();
            }
            this.targetProfile.add(t);
            return t;
        }

        public OperationDefinitionParameterComponent addTargetProfile(String value) {
            CanonicalType t = new CanonicalType();
            t.setValue(value);
            if (this.targetProfile == null) {
                this.targetProfile = new ArrayList<CanonicalType>();
            }
            this.targetProfile.add(t);
            return this;
        }

        public boolean hasTargetProfile(String value) {
            if (this.targetProfile == null) {
                return false;
            }
            for (CanonicalType v : this.targetProfile) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public Enumeration<Enumerations.SearchParamType> getSearchTypeElement() {
            if (this.searchType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OperationDefinitionParameterComponent.searchType");
                }
                if (Configuration.doAutoCreate()) {
                    this.searchType = new Enumeration<Enumerations.SearchParamType>(new Enumerations.SearchParamTypeEnumFactory());
                }
            }
            return this.searchType;
        }

        public boolean hasSearchTypeElement() {
            return this.searchType != null && !this.searchType.isEmpty();
        }

        public boolean hasSearchType() {
            return this.searchType != null && !this.searchType.isEmpty();
        }

        public OperationDefinitionParameterComponent setSearchTypeElement(Enumeration<Enumerations.SearchParamType> value) {
            this.searchType = value;
            return this;
        }

        public Enumerations.SearchParamType getSearchType() {
            return this.searchType == null ? null : (Enumerations.SearchParamType)((Object)this.searchType.getValue());
        }

        public OperationDefinitionParameterComponent setSearchType(Enumerations.SearchParamType value) {
            if (value == null) {
                this.searchType = null;
            } else {
                if (this.searchType == null) {
                    this.searchType = new Enumeration<Enumerations.SearchParamType>(new Enumerations.SearchParamTypeEnumFactory());
                }
                this.searchType.setValue((Object)value);
            }
            return this;
        }

        public OperationDefinitionParameterBindingComponent getBinding() {
            if (this.binding == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OperationDefinitionParameterComponent.binding");
                }
                if (Configuration.doAutoCreate()) {
                    this.binding = new OperationDefinitionParameterBindingComponent();
                }
            }
            return this.binding;
        }

        public boolean hasBinding() {
            return this.binding != null && !this.binding.isEmpty();
        }

        public OperationDefinitionParameterComponent setBinding(OperationDefinitionParameterBindingComponent value) {
            this.binding = value;
            return this;
        }

        public List<OperationDefinitionParameterComponent> getPart() {
            if (this.part == null) {
                this.part = new ArrayList<OperationDefinitionParameterComponent>();
            }
            return this.part;
        }

        public OperationDefinitionParameterComponent setPart(List<OperationDefinitionParameterComponent> thePart) {
            this.part = thePart;
            return this;
        }

        public boolean hasPart() {
            if (this.part == null) {
                return false;
            }
            for (OperationDefinitionParameterComponent item : this.part) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public OperationDefinitionParameterComponent addPart() {
            OperationDefinitionParameterComponent t = new OperationDefinitionParameterComponent();
            if (this.part == null) {
                this.part = new ArrayList<OperationDefinitionParameterComponent>();
            }
            this.part.add(t);
            return t;
        }

        public OperationDefinitionParameterComponent addPart(OperationDefinitionParameterComponent t) {
            if (t == null) {
                return this;
            }
            if (this.part == null) {
                this.part = new ArrayList<OperationDefinitionParameterComponent>();
            }
            this.part.add(t);
            return this;
        }

        public OperationDefinitionParameterComponent getPartFirstRep() {
            if (this.getPart().isEmpty()) {
                this.addPart();
            }
            return this.getPart().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(OperationDefinition.SP_NAME, OperationDefinition.SP_CODE, "The name of used to identify the parameter.", 0, 1, this.name));
            children.add(new Property("use", OperationDefinition.SP_CODE, "Whether this is an input or an output parameter.", 0, 1, this.use));
            children.add(new Property("min", "integer", "The minimum number of times this parameter SHALL appear in the request or response.", 0, 1, this.min));
            children.add(new Property("max", "string", "The maximum number of times this element is permitted to appear in the request or response.", 0, 1, this.max));
            children.add(new Property("documentation", "string", "Describes the meaning or use of this parameter.", 0, 1, this.documentation));
            children.add(new Property(OperationDefinition.SP_TYPE, OperationDefinition.SP_CODE, "The type for this parameter.", 0, 1, this.type));
            children.add(new Property("targetProfile", "canonical(StructureDefinition)", "If the type is \"Reference\", then targetProfile lists a one or more profiles that the Reference can refer to.", 0, Integer.MAX_VALUE, this.targetProfile));
            children.add(new Property("searchType", OperationDefinition.SP_CODE, "How the parameter is understood as a search parameter. This is only used if the parameter type is 'string'.", 0, 1, this.searchType));
            children.add(new Property("binding", "", "Binds to a value set if this parameter is coded (code, Coding, CodeableConcept).", 0, 1, this.binding));
            children.add(new Property("part", "@OperationDefinition.parameter", "The parts of a nested Parameter.", 0, Integer.MAX_VALUE, this.part));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property(OperationDefinition.SP_NAME, OperationDefinition.SP_CODE, "The name of used to identify the parameter.", 0, 1, this.name);
                }
                case 116103: {
                    return new Property("use", OperationDefinition.SP_CODE, "Whether this is an input or an output parameter.", 0, 1, this.use);
                }
                case 108114: {
                    return new Property("min", "integer", "The minimum number of times this parameter SHALL appear in the request or response.", 0, 1, this.min);
                }
                case 107876: {
                    return new Property("max", "string", "The maximum number of times this element is permitted to appear in the request or response.", 0, 1, this.max);
                }
                case 1587405498: {
                    return new Property("documentation", "string", "Describes the meaning or use of this parameter.", 0, 1, this.documentation);
                }
                case 3575610: {
                    return new Property(OperationDefinition.SP_TYPE, OperationDefinition.SP_CODE, "The type for this parameter.", 0, 1, this.type);
                }
                case 1994521304: {
                    return new Property("targetProfile", "canonical(StructureDefinition)", "If the type is \"Reference\", then targetProfile lists a one or more profiles that the Reference can refer to.", 0, Integer.MAX_VALUE, this.targetProfile);
                }
                case -710454014: {
                    return new Property("searchType", OperationDefinition.SP_CODE, "How the parameter is understood as a search parameter. This is only used if the parameter type is 'string'.", 0, 1, this.searchType);
                }
                case -108220795: {
                    return new Property("binding", "", "Binds to a value set if this parameter is coded (code, Coding, CodeableConcept).", 0, 1, this.binding);
                }
                case 3433459: {
                    return new Property("part", "@OperationDefinition.parameter", "The parts of a nested Parameter.", 0, Integer.MAX_VALUE, this.part);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case 116103: {
                    Base[] baseArray;
                    if (this.use == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.use;
                    }
                    return baseArray;
                }
                case 108114: {
                    Base[] baseArray;
                    if (this.min == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.min;
                    }
                    return baseArray;
                }
                case 107876: {
                    Base[] baseArray;
                    if (this.max == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.max;
                    }
                    return baseArray;
                }
                case 1587405498: {
                    Base[] baseArray;
                    if (this.documentation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.documentation;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.type;
                    }
                    return baseArray;
                }
                case 1994521304: {
                    return this.targetProfile == null ? new Base[]{} : this.targetProfile.toArray(new Base[this.targetProfile.size()]);
                }
                case -710454014: {
                    Base[] baseArray;
                    if (this.searchType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.searchType;
                    }
                    return baseArray;
                }
                case -108220795: {
                    Base[] baseArray;
                    if (this.binding == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.binding;
                    }
                    return baseArray;
                }
                case 3433459: {
                    return this.part == null ? new Base[]{} : this.part.toArray(new Base[this.part.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToCode(value);
                    return value;
                }
                case 116103: {
                    value = new OperationParameterUseEnumFactory().fromType(this.castToCode(value));
                    this.use = value;
                    return value;
                }
                case 108114: {
                    this.min = this.castToInteger(value);
                    return value;
                }
                case 107876: {
                    this.max = this.castToString(value);
                    return value;
                }
                case 1587405498: {
                    this.documentation = this.castToString(value);
                    return value;
                }
                case 3575610: {
                    this.type = this.castToCode(value);
                    return value;
                }
                case 1994521304: {
                    this.getTargetProfile().add(this.castToCanonical(value));
                    return value;
                }
                case -710454014: {
                    value = new Enumerations.SearchParamTypeEnumFactory().fromType(this.castToCode(value));
                    this.searchType = value;
                    return value;
                }
                case -108220795: {
                    this.binding = (OperationDefinitionParameterBindingComponent)((Object)value);
                    return value;
                }
                case 3433459: {
                    this.getPart().add((OperationDefinitionParameterComponent)((Object)value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(OperationDefinition.SP_NAME)) {
                this.name = this.castToCode(value);
            } else if (name.equals("use")) {
                value = new OperationParameterUseEnumFactory().fromType(this.castToCode(value));
                this.use = value;
            } else if (name.equals("min")) {
                this.min = this.castToInteger(value);
            } else if (name.equals("max")) {
                this.max = this.castToString(value);
            } else if (name.equals("documentation")) {
                this.documentation = this.castToString(value);
            } else if (name.equals(OperationDefinition.SP_TYPE)) {
                this.type = this.castToCode(value);
            } else if (name.equals("targetProfile")) {
                this.getTargetProfile().add(this.castToCanonical(value));
            } else if (name.equals("searchType")) {
                value = new Enumerations.SearchParamTypeEnumFactory().fromType(this.castToCode(value));
                this.searchType = value;
            } else if (name.equals("binding")) {
                this.binding = (OperationDefinitionParameterBindingComponent)((Object)value);
            } else if (name.equals("part")) {
                this.getPart().add((OperationDefinitionParameterComponent)((Object)value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case 116103: {
                    return this.getUseElement();
                }
                case 108114: {
                    return this.getMinElement();
                }
                case 107876: {
                    return this.getMaxElement();
                }
                case 1587405498: {
                    return this.getDocumentationElement();
                }
                case 3575610: {
                    return this.getTypeElement();
                }
                case 1994521304: {
                    return this.addTargetProfileElement();
                }
                case -710454014: {
                    return this.getSearchTypeElement();
                }
                case -108220795: {
                    return this.getBinding();
                }
                case 3433459: {
                    return this.addPart();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{OperationDefinition.SP_CODE};
                }
                case 116103: {
                    return new String[]{OperationDefinition.SP_CODE};
                }
                case 108114: {
                    return new String[]{"integer"};
                }
                case 107876: {
                    return new String[]{"string"};
                }
                case 1587405498: {
                    return new String[]{"string"};
                }
                case 3575610: {
                    return new String[]{OperationDefinition.SP_CODE};
                }
                case 1994521304: {
                    return new String[]{"canonical"};
                }
                case -710454014: {
                    return new String[]{OperationDefinition.SP_CODE};
                }
                case -108220795: {
                    return new String[0];
                }
                case 3433459: {
                    return new String[]{"@OperationDefinition.parameter"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(OperationDefinition.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.name");
            }
            if (name.equals("use")) {
                throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.use");
            }
            if (name.equals("min")) {
                throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.min");
            }
            if (name.equals("max")) {
                throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.max");
            }
            if (name.equals("documentation")) {
                throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.documentation");
            }
            if (name.equals(OperationDefinition.SP_TYPE)) {
                throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.type");
            }
            if (name.equals("targetProfile")) {
                throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.targetProfile");
            }
            if (name.equals("searchType")) {
                throw new FHIRException("Cannot call addChild on a primitive type OperationDefinition.searchType");
            }
            if (name.equals("binding")) {
                this.binding = new OperationDefinitionParameterBindingComponent();
                return this.binding;
            }
            if (name.equals("part")) {
                return this.addPart();
            }
            return super.addChild(name);
        }

        @Override
        public OperationDefinitionParameterComponent copy() {
            OperationDefinitionParameterComponent dst = new OperationDefinitionParameterComponent();
            this.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.use = this.use == null ? null : this.use.copy();
            dst.min = this.min == null ? null : this.min.copy();
            dst.max = this.max == null ? null : this.max.copy();
            dst.documentation = this.documentation == null ? null : this.documentation.copy();
            CodeType codeType = dst.type = this.type == null ? null : this.type.copy();
            if (this.targetProfile != null) {
                dst.targetProfile = new ArrayList<CanonicalType>();
                for (CanonicalType canonicalType : this.targetProfile) {
                    dst.targetProfile.add(canonicalType.copy());
                }
            }
            dst.searchType = this.searchType == null ? null : this.searchType.copy();
            OperationDefinitionParameterBindingComponent operationDefinitionParameterBindingComponent = dst.binding = this.binding == null ? null : this.binding.copy();
            if (this.part != null) {
                dst.part = new ArrayList<OperationDefinitionParameterComponent>();
                for (OperationDefinitionParameterComponent operationDefinitionParameterComponent : this.part) {
                    dst.part.add(operationDefinitionParameterComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof OperationDefinitionParameterComponent)) {
                return false;
            }
            OperationDefinitionParameterComponent o = (OperationDefinitionParameterComponent)other_;
            return OperationDefinitionParameterComponent.compareDeep(this.name, o.name, true) && OperationDefinitionParameterComponent.compareDeep(this.use, o.use, true) && OperationDefinitionParameterComponent.compareDeep(this.min, o.min, true) && OperationDefinitionParameterComponent.compareDeep(this.max, o.max, true) && OperationDefinitionParameterComponent.compareDeep(this.documentation, o.documentation, true) && OperationDefinitionParameterComponent.compareDeep(this.type, o.type, true) && OperationDefinitionParameterComponent.compareDeep(this.targetProfile, o.targetProfile, true) && OperationDefinitionParameterComponent.compareDeep(this.searchType, o.searchType, true) && OperationDefinitionParameterComponent.compareDeep(this.binding, o.binding, true) && OperationDefinitionParameterComponent.compareDeep(this.part, o.part, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof OperationDefinitionParameterComponent)) {
                return false;
            }
            OperationDefinitionParameterComponent o = (OperationDefinitionParameterComponent)other_;
            return OperationDefinitionParameterComponent.compareValues(this.name, o.name, true) && OperationDefinitionParameterComponent.compareValues(this.use, o.use, true) && OperationDefinitionParameterComponent.compareValues(this.min, o.min, true) && OperationDefinitionParameterComponent.compareValues(this.max, o.max, true) && OperationDefinitionParameterComponent.compareValues(this.documentation, o.documentation, true) && OperationDefinitionParameterComponent.compareValues(this.type, o.type, true) && OperationDefinitionParameterComponent.compareValues(this.searchType, o.searchType, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.name, this.use, this.min, this.max, this.documentation, this.type, this.targetProfile, this.searchType, this.binding, this.part});
        }

        @Override
        public String fhirType() {
            return "OperationDefinition.parameter";
        }
    }

    public static class OperationParameterUseEnumFactory
    implements EnumFactory<OperationParameterUse> {
        @Override
        public OperationParameterUse fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("in".equals(codeString)) {
                return OperationParameterUse.IN;
            }
            if ("out".equals(codeString)) {
                return OperationParameterUse.OUT;
            }
            throw new IllegalArgumentException("Unknown OperationParameterUse code '" + codeString + "'");
        }

        public Enumeration<OperationParameterUse> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<OperationParameterUse>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("in".equals(codeString)) {
                return new Enumeration<OperationParameterUse>(this, OperationParameterUse.IN);
            }
            if ("out".equals(codeString)) {
                return new Enumeration<OperationParameterUse>(this, OperationParameterUse.OUT);
            }
            throw new FHIRException("Unknown OperationParameterUse code '" + codeString + "'");
        }

        @Override
        public String toCode(OperationParameterUse code) {
            if (code == OperationParameterUse.IN) {
                return "in";
            }
            if (code == OperationParameterUse.OUT) {
                return "out";
            }
            return "?";
        }

        @Override
        public String toSystem(OperationParameterUse code) {
            return code.getSystem();
        }
    }

    public static enum OperationParameterUse {
        IN,
        OUT,
        NULL;


        public static OperationParameterUse fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("in".equals(codeString)) {
                return IN;
            }
            if ("out".equals(codeString)) {
                return OUT;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown OperationParameterUse code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case IN: {
                    return "in";
                }
                case OUT: {
                    return "out";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case IN: {
                    return "http://hl7.org/fhir/operation-parameter-use";
                }
                case OUT: {
                    return "http://hl7.org/fhir/operation-parameter-use";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case IN: {
                    return "This is an input parameter.";
                }
                case OUT: {
                    return "This is an output parameter.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case IN: {
                    return "In";
                }
                case OUT: {
                    return "Out";
                }
            }
            return "?";
        }
    }

    public static class OperationKindEnumFactory
    implements EnumFactory<OperationKind> {
        @Override
        public OperationKind fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("operation".equals(codeString)) {
                return OperationKind.OPERATION;
            }
            if ("query".equals(codeString)) {
                return OperationKind.QUERY;
            }
            throw new IllegalArgumentException("Unknown OperationKind code '" + codeString + "'");
        }

        public Enumeration<OperationKind> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<OperationKind>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("operation".equals(codeString)) {
                return new Enumeration<OperationKind>(this, OperationKind.OPERATION);
            }
            if ("query".equals(codeString)) {
                return new Enumeration<OperationKind>(this, OperationKind.QUERY);
            }
            throw new FHIRException("Unknown OperationKind code '" + codeString + "'");
        }

        @Override
        public String toCode(OperationKind code) {
            if (code == OperationKind.OPERATION) {
                return "operation";
            }
            if (code == OperationKind.QUERY) {
                return "query";
            }
            return "?";
        }

        @Override
        public String toSystem(OperationKind code) {
            return code.getSystem();
        }
    }

    public static enum OperationKind {
        OPERATION,
        QUERY,
        NULL;


        public static OperationKind fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("operation".equals(codeString)) {
                return OPERATION;
            }
            if ("query".equals(codeString)) {
                return QUERY;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown OperationKind code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case OPERATION: {
                    return "operation";
                }
                case QUERY: {
                    return "query";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case OPERATION: {
                    return "http://hl7.org/fhir/operation-kind";
                }
                case QUERY: {
                    return "http://hl7.org/fhir/operation-kind";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case OPERATION: {
                    return "This operation is invoked as an operation.";
                }
                case QUERY: {
                    return "This operation is a named query, invoked using the search mechanism.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case OPERATION: {
                    return "Operation";
                }
                case QUERY: {
                    return "Query";
                }
            }
            return "?";
        }
    }
}

