/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DecimalType;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Duration;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.RelatedPerson;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;

@ResourceDef(name="OccupationalData", profile="http://hl7.org/fhir/Profile/OccupationalData")
public class OccupationalData
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Unique identifier for the occupational data (ODH) record", formalDefinition="Business identifier assigned to the occupational data record.")
    protected Identifier identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired | unknown", formalDefinition="The status of this ODH. Enables tracking the life-cycle of the content.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    protected Enumeration<Enumerations.PublicationStatus> status;
    @Child(name="subject", type={Patient.class, RelatedPerson.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who the occupational data (ODH) is collected about", formalDefinition="The occupational data record is about this person (e.g., the patient, a parent of a minor child).")
    protected Reference subject;
    protected Resource subjectTarget;
    @Child(name="date", type={DateTimeType.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Occupational Data (ODH) recording time", formalDefinition="The date of creation or updating of the occupational data record.")
    protected DateTimeType date;
    @Child(name="recorder", type={Practitioner.class, PractitionerRole.class, Patient.class, RelatedPerson.class}, order=4, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Occupational Data (ODH) recorder", formalDefinition="The person who created or last updated the occupational data record.")
    protected List<Reference> recorder;
    protected List<Resource> recorderTarget;
    @Child(name="informant", type={Patient.class, RelatedPerson.class}, order=5, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Occupational Data (ODH) informant", formalDefinition="The person who provided the subject's health-related occupational data.")
    protected List<Reference> informant;
    protected List<Resource> informantTarget;
    @Child(name="employmentStatus", type={}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Employment status", formalDefinition="A person's current economic relationship to a job. Employment status refers to whether a person is currently working for compensation, is unemployed (i.e., searching for work for compensation), or is not in the labor force (e.g. disabled, homemaker, chooses not to work, etc.). Employment status is not the same as classification of work.")
    protected List<OccupationalDataEmploymentStatusComponent> employmentStatus;
    @Child(name="retirementDate", type={DateTimeType.class}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Retirement date", formalDefinition="A person's self-identified retirement date.  A person may retire multiple times.")
    protected List<DateTimeType> retirementDate;
    @Child(name="combatZonePeriod", type={Period.class}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Combat Zone Work period", formalDefinition="The start and end dates for the period of time a person's work is or was in a combat zone. In addition to military personnel, civilians also may work or have worked in a combat zone.")
    protected List<Period> combatZonePeriod;
    @Child(name="usualWork", type={}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Usual Work", formalDefinition="The type of work a person has held for the longest amount of time during his or her life, regardless of the occupation currently held and regardless of whether or not it has been held for a continuous time.")
    protected OccupationalDataUsualWorkComponent usualWork;
    @Child(name="pastOrPresentJob", type={}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Past or Present Job", formalDefinition="The type of work done by a person during a current or past job. A job is defined by the sum of all the data related to the occupation. A change in occupation, supervisory level, industry, employer, or employer location is considered a new job.")
    protected List<OccupationalDataPastOrPresentJobComponent> pastOrPresentJob;
    private static final long serialVersionUID = -1765327023L;
    @SearchParamDefinition(name="date", path="OccupationalData.date", description="Obtained date/time. If the obtained element is a period, a date that falls in the period", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="OccupationalData.identifier", description="A business identifier for a particular occupational data record", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="recorder", path="OccupationalData.recorder", description="The person who recorded or updated the occupational data record", type="reference", target={Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_RECORDER = "recorder";
    public static final ReferenceClientParam RECORDER = new ReferenceClientParam("recorder");
    public static final Include INCLUDE_RECORDER = new Include("OccupationalData:recorder").toLocked();
    @SearchParamDefinition(name="subject", path="OccupationalData.subject", description="The subject that the occupational data record is about", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Patient.class, RelatedPerson.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("OccupationalData:subject").toLocked();
    @SearchParamDefinition(name="status", path="OccupationalData.status", description="The status of the occupational data record", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="informant", path="OccupationalData.informant", description="The person who provided the subject's health-related occupational data.", type="reference", target={Patient.class, RelatedPerson.class})
    public static final String SP_INFORMANT = "informant";
    public static final ReferenceClientParam INFORMANT = new ReferenceClientParam("informant");
    public static final Include INCLUDE_INFORMANT = new Include("OccupationalData:informant").toLocked();

    public OccupationalData() {
    }

    public OccupationalData(Enumeration<Enumerations.PublicationStatus> status) {
        this.status = status;
    }

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OccupationalData.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public OccupationalData setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OccupationalData.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public OccupationalData setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    public OccupationalData setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OccupationalData.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public OccupationalData setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public OccupationalData setSubjectTarget(Resource value) {
        this.subjectTarget = value;
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OccupationalData.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public OccupationalData setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public OccupationalData setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public List<Reference> getRecorder() {
        if (this.recorder == null) {
            this.recorder = new ArrayList<Reference>();
        }
        return this.recorder;
    }

    public OccupationalData setRecorder(List<Reference> theRecorder) {
        this.recorder = theRecorder;
        return this;
    }

    public boolean hasRecorder() {
        if (this.recorder == null) {
            return false;
        }
        for (Reference item : this.recorder) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addRecorder() {
        Reference t = new Reference();
        if (this.recorder == null) {
            this.recorder = new ArrayList<Reference>();
        }
        this.recorder.add(t);
        return t;
    }

    public OccupationalData addRecorder(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.recorder == null) {
            this.recorder = new ArrayList<Reference>();
        }
        this.recorder.add(t);
        return this;
    }

    public Reference getRecorderFirstRep() {
        if (this.getRecorder().isEmpty()) {
            this.addRecorder();
        }
        return this.getRecorder().get(0);
    }

    @Deprecated
    public List<Resource> getRecorderTarget() {
        if (this.recorderTarget == null) {
            this.recorderTarget = new ArrayList<Resource>();
        }
        return this.recorderTarget;
    }

    public List<Reference> getInformant() {
        if (this.informant == null) {
            this.informant = new ArrayList<Reference>();
        }
        return this.informant;
    }

    public OccupationalData setInformant(List<Reference> theInformant) {
        this.informant = theInformant;
        return this;
    }

    public boolean hasInformant() {
        if (this.informant == null) {
            return false;
        }
        for (Reference item : this.informant) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addInformant() {
        Reference t = new Reference();
        if (this.informant == null) {
            this.informant = new ArrayList<Reference>();
        }
        this.informant.add(t);
        return t;
    }

    public OccupationalData addInformant(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.informant == null) {
            this.informant = new ArrayList<Reference>();
        }
        this.informant.add(t);
        return this;
    }

    public Reference getInformantFirstRep() {
        if (this.getInformant().isEmpty()) {
            this.addInformant();
        }
        return this.getInformant().get(0);
    }

    @Deprecated
    public List<Resource> getInformantTarget() {
        if (this.informantTarget == null) {
            this.informantTarget = new ArrayList<Resource>();
        }
        return this.informantTarget;
    }

    public List<OccupationalDataEmploymentStatusComponent> getEmploymentStatus() {
        if (this.employmentStatus == null) {
            this.employmentStatus = new ArrayList<OccupationalDataEmploymentStatusComponent>();
        }
        return this.employmentStatus;
    }

    public OccupationalData setEmploymentStatus(List<OccupationalDataEmploymentStatusComponent> theEmploymentStatus) {
        this.employmentStatus = theEmploymentStatus;
        return this;
    }

    public boolean hasEmploymentStatus() {
        if (this.employmentStatus == null) {
            return false;
        }
        for (OccupationalDataEmploymentStatusComponent item : this.employmentStatus) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public OccupationalDataEmploymentStatusComponent addEmploymentStatus() {
        OccupationalDataEmploymentStatusComponent t = new OccupationalDataEmploymentStatusComponent();
        if (this.employmentStatus == null) {
            this.employmentStatus = new ArrayList<OccupationalDataEmploymentStatusComponent>();
        }
        this.employmentStatus.add(t);
        return t;
    }

    public OccupationalData addEmploymentStatus(OccupationalDataEmploymentStatusComponent t) {
        if (t == null) {
            return this;
        }
        if (this.employmentStatus == null) {
            this.employmentStatus = new ArrayList<OccupationalDataEmploymentStatusComponent>();
        }
        this.employmentStatus.add(t);
        return this;
    }

    public OccupationalDataEmploymentStatusComponent getEmploymentStatusFirstRep() {
        if (this.getEmploymentStatus().isEmpty()) {
            this.addEmploymentStatus();
        }
        return this.getEmploymentStatus().get(0);
    }

    public List<DateTimeType> getRetirementDate() {
        if (this.retirementDate == null) {
            this.retirementDate = new ArrayList<DateTimeType>();
        }
        return this.retirementDate;
    }

    public OccupationalData setRetirementDate(List<DateTimeType> theRetirementDate) {
        this.retirementDate = theRetirementDate;
        return this;
    }

    public boolean hasRetirementDate() {
        if (this.retirementDate == null) {
            return false;
        }
        for (DateTimeType item : this.retirementDate) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DateTimeType addRetirementDateElement() {
        DateTimeType t = new DateTimeType();
        if (this.retirementDate == null) {
            this.retirementDate = new ArrayList<DateTimeType>();
        }
        this.retirementDate.add(t);
        return t;
    }

    public OccupationalData addRetirementDate(Date value) {
        DateTimeType t = new DateTimeType();
        t.setValue(value);
        if (this.retirementDate == null) {
            this.retirementDate = new ArrayList<DateTimeType>();
        }
        this.retirementDate.add(t);
        return this;
    }

    public boolean hasRetirementDate(Date value) {
        if (this.retirementDate == null) {
            return false;
        }
        for (DateTimeType v : this.retirementDate) {
            if (!((Date)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<Period> getCombatZonePeriod() {
        if (this.combatZonePeriod == null) {
            this.combatZonePeriod = new ArrayList<Period>();
        }
        return this.combatZonePeriod;
    }

    public OccupationalData setCombatZonePeriod(List<Period> theCombatZonePeriod) {
        this.combatZonePeriod = theCombatZonePeriod;
        return this;
    }

    public boolean hasCombatZonePeriod() {
        if (this.combatZonePeriod == null) {
            return false;
        }
        for (Period item : this.combatZonePeriod) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Period addCombatZonePeriod() {
        Period t = new Period();
        if (this.combatZonePeriod == null) {
            this.combatZonePeriod = new ArrayList<Period>();
        }
        this.combatZonePeriod.add(t);
        return t;
    }

    public OccupationalData addCombatZonePeriod(Period t) {
        if (t == null) {
            return this;
        }
        if (this.combatZonePeriod == null) {
            this.combatZonePeriod = new ArrayList<Period>();
        }
        this.combatZonePeriod.add(t);
        return this;
    }

    public Period getCombatZonePeriodFirstRep() {
        if (this.getCombatZonePeriod().isEmpty()) {
            this.addCombatZonePeriod();
        }
        return this.getCombatZonePeriod().get(0);
    }

    public OccupationalDataUsualWorkComponent getUsualWork() {
        if (this.usualWork == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OccupationalData.usualWork");
            }
            if (Configuration.doAutoCreate()) {
                this.usualWork = new OccupationalDataUsualWorkComponent();
            }
        }
        return this.usualWork;
    }

    public boolean hasUsualWork() {
        return this.usualWork != null && !this.usualWork.isEmpty();
    }

    public OccupationalData setUsualWork(OccupationalDataUsualWorkComponent value) {
        this.usualWork = value;
        return this;
    }

    public List<OccupationalDataPastOrPresentJobComponent> getPastOrPresentJob() {
        if (this.pastOrPresentJob == null) {
            this.pastOrPresentJob = new ArrayList<OccupationalDataPastOrPresentJobComponent>();
        }
        return this.pastOrPresentJob;
    }

    public OccupationalData setPastOrPresentJob(List<OccupationalDataPastOrPresentJobComponent> thePastOrPresentJob) {
        this.pastOrPresentJob = thePastOrPresentJob;
        return this;
    }

    public boolean hasPastOrPresentJob() {
        if (this.pastOrPresentJob == null) {
            return false;
        }
        for (OccupationalDataPastOrPresentJobComponent item : this.pastOrPresentJob) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public OccupationalDataPastOrPresentJobComponent addPastOrPresentJob() {
        OccupationalDataPastOrPresentJobComponent t = new OccupationalDataPastOrPresentJobComponent();
        if (this.pastOrPresentJob == null) {
            this.pastOrPresentJob = new ArrayList<OccupationalDataPastOrPresentJobComponent>();
        }
        this.pastOrPresentJob.add(t);
        return t;
    }

    public OccupationalData addPastOrPresentJob(OccupationalDataPastOrPresentJobComponent t) {
        if (t == null) {
            return this;
        }
        if (this.pastOrPresentJob == null) {
            this.pastOrPresentJob = new ArrayList<OccupationalDataPastOrPresentJobComponent>();
        }
        this.pastOrPresentJob.add(t);
        return this;
    }

    public OccupationalDataPastOrPresentJobComponent getPastOrPresentJobFirstRep() {
        if (this.getPastOrPresentJob().isEmpty()) {
            this.addPastOrPresentJob();
        }
        return this.getPastOrPresentJob().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Business identifier assigned to the occupational data record.", 0, 1, this.identifier));
        children.add(new Property(SP_STATUS, "code", "The status of this ODH. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|RelatedPerson)", "The occupational data record is about this person (e.g., the patient, a parent of a minor child).", 0, 1, this.subject));
        children.add(new Property(SP_DATE, "dateTime", "The date of creation or updating of the occupational data record.", 0, 1, this.date));
        children.add(new Property(SP_RECORDER, "Reference(Practitioner|PractitionerRole|Patient|RelatedPerson)", "The person who created or last updated the occupational data record.", 0, Integer.MAX_VALUE, this.recorder));
        children.add(new Property(SP_INFORMANT, "Reference(Patient|RelatedPerson)", "The person who provided the subject's health-related occupational data.", 0, Integer.MAX_VALUE, this.informant));
        children.add(new Property("employmentStatus", "", "A person's current economic relationship to a job. Employment status refers to whether a person is currently working for compensation, is unemployed (i.e., searching for work for compensation), or is not in the labor force (e.g. disabled, homemaker, chooses not to work, etc.). Employment status is not the same as classification of work.", 0, Integer.MAX_VALUE, this.employmentStatus));
        children.add(new Property("retirementDate", "dateTime", "A person's self-identified retirement date.  A person may retire multiple times.", 0, Integer.MAX_VALUE, this.retirementDate));
        children.add(new Property("combatZonePeriod", "Period", "The start and end dates for the period of time a person's work is or was in a combat zone. In addition to military personnel, civilians also may work or have worked in a combat zone.", 0, Integer.MAX_VALUE, this.combatZonePeriod));
        children.add(new Property("usualWork", "", "The type of work a person has held for the longest amount of time during his or her life, regardless of the occupation currently held and regardless of whether or not it has been held for a continuous time.", 0, 1, this.usualWork));
        children.add(new Property("pastOrPresentJob", "", "The type of work done by a person during a current or past job. A job is defined by the sum of all the data related to the occupation. A change in occupation, supervisory level, industry, employer, or employer location is considered a new job.", 0, Integer.MAX_VALUE, this.pastOrPresentJob));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Business identifier assigned to the occupational data record.", 0, 1, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of this ODH. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|RelatedPerson)", "The occupational data record is about this person (e.g., the patient, a parent of a minor child).", 0, 1, this.subject);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date of creation or updating of the occupational data record.", 0, 1, this.date);
            }
            case -799233858: {
                return new Property(SP_RECORDER, "Reference(Practitioner|PractitionerRole|Patient|RelatedPerson)", "The person who created or last updated the occupational data record.", 0, Integer.MAX_VALUE, this.recorder);
            }
            case 1248974302: {
                return new Property(SP_INFORMANT, "Reference(Patient|RelatedPerson)", "The person who provided the subject's health-related occupational data.", 0, Integer.MAX_VALUE, this.informant);
            }
            case 418561790: {
                return new Property("employmentStatus", "", "A person's current economic relationship to a job. Employment status refers to whether a person is currently working for compensation, is unemployed (i.e., searching for work for compensation), or is not in the labor force (e.g. disabled, homemaker, chooses not to work, etc.). Employment status is not the same as classification of work.", 0, Integer.MAX_VALUE, this.employmentStatus);
            }
            case 1617125191: {
                return new Property("retirementDate", "dateTime", "A person's self-identified retirement date.  A person may retire multiple times.", 0, Integer.MAX_VALUE, this.retirementDate);
            }
            case 1215352481: {
                return new Property("combatZonePeriod", "Period", "The start and end dates for the period of time a person's work is or was in a combat zone. In addition to military personnel, civilians also may work or have worked in a combat zone.", 0, Integer.MAX_VALUE, this.combatZonePeriod);
            }
            case 1179136563: {
                return new Property("usualWork", "", "The type of work a person has held for the longest amount of time during his or her life, regardless of the occupation currently held and regardless of whether or not it has been held for a continuous time.", 0, 1, this.usualWork);
            }
            case -1024719753: {
                return new Property("pastOrPresentJob", "", "The type of work done by a person during a current or past job. A job is defined by the sum of all the data related to the occupation. A change in occupation, supervisory level, industry, employer, or employer location is considered a new job.", 0, Integer.MAX_VALUE, this.pastOrPresentJob);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.identifier;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.subject;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.date;
                }
                return baseArray;
            }
            case -799233858: {
                return this.recorder == null ? new Base[]{} : this.recorder.toArray(new Base[this.recorder.size()]);
            }
            case 1248974302: {
                return this.informant == null ? new Base[]{} : this.informant.toArray(new Base[this.informant.size()]);
            }
            case 418561790: {
                return this.employmentStatus == null ? new Base[]{} : this.employmentStatus.toArray(new Base[this.employmentStatus.size()]);
            }
            case 1617125191: {
                return this.retirementDate == null ? new Base[]{} : this.retirementDate.toArray(new Base[this.retirementDate.size()]);
            }
            case 1215352481: {
                return this.combatZonePeriod == null ? new Base[]{} : this.combatZonePeriod.toArray(new Base[this.combatZonePeriod.size()]);
            }
            case 1179136563: {
                Base[] baseArray;
                if (this.usualWork == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.usualWork;
                }
                return baseArray;
            }
            case -1024719753: {
                return this.pastOrPresentJob == null ? new Base[]{} : this.pastOrPresentJob.toArray(new Base[this.pastOrPresentJob.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.identifier = this.castToIdentifier(value);
                return value;
            }
            case -892481550: {
                value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case -1867885268: {
                this.subject = this.castToReference(value);
                return value;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                return value;
            }
            case -799233858: {
                this.getRecorder().add(this.castToReference(value));
                return value;
            }
            case 1248974302: {
                this.getInformant().add(this.castToReference(value));
                return value;
            }
            case 418561790: {
                this.getEmploymentStatus().add((OccupationalDataEmploymentStatusComponent)((Object)value));
                return value;
            }
            case 1617125191: {
                this.getRetirementDate().add(this.castToDateTime(value));
                return value;
            }
            case 1215352481: {
                this.getCombatZonePeriod().add(this.castToPeriod(value));
                return value;
            }
            case 1179136563: {
                this.usualWork = (OccupationalDataUsualWorkComponent)((Object)value);
                return value;
            }
            case -1024719753: {
                this.getPastOrPresentJob().add((OccupationalDataPastOrPresentJobComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = this.castToIdentifier(value);
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_RECORDER)) {
            this.getRecorder().add(this.castToReference(value));
        } else if (name.equals(SP_INFORMANT)) {
            this.getInformant().add(this.castToReference(value));
        } else if (name.equals("employmentStatus")) {
            this.getEmploymentStatus().add((OccupationalDataEmploymentStatusComponent)((Object)value));
        } else if (name.equals("retirementDate")) {
            this.getRetirementDate().add(this.castToDateTime(value));
        } else if (name.equals("combatZonePeriod")) {
            this.getCombatZonePeriod().add(this.castToPeriod(value));
        } else if (name.equals("usualWork")) {
            this.usualWork = (OccupationalDataUsualWorkComponent)((Object)value);
        } else if (name.equals("pastOrPresentJob")) {
            this.getPastOrPresentJob().add((OccupationalDataPastOrPresentJobComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.getIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case -799233858: {
                return this.addRecorder();
            }
            case 1248974302: {
                return this.addInformant();
            }
            case 418561790: {
                return this.addEmploymentStatus();
            }
            case 1617125191: {
                return this.addRetirementDateElement();
            }
            case 1215352481: {
                return this.addCombatZonePeriod();
            }
            case 1179136563: {
                return this.getUsualWork();
            }
            case -1024719753: {
                return this.addPastOrPresentJob();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case -799233858: {
                return new String[]{"Reference"};
            }
            case 1248974302: {
                return new String[]{"Reference"};
            }
            case 418561790: {
                return new String[0];
            }
            case 1617125191: {
                return new String[]{"dateTime"};
            }
            case 1215352481: {
                return new String[]{"Period"};
            }
            case 1179136563: {
                return new String[0];
            }
            case -1024719753: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type OccupationalData.status");
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type OccupationalData.date");
        }
        if (name.equals(SP_RECORDER)) {
            return this.addRecorder();
        }
        if (name.equals(SP_INFORMANT)) {
            return this.addInformant();
        }
        if (name.equals("employmentStatus")) {
            return this.addEmploymentStatus();
        }
        if (name.equals("retirementDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type OccupationalData.retirementDate");
        }
        if (name.equals("combatZonePeriod")) {
            return this.addCombatZonePeriod();
        }
        if (name.equals("usualWork")) {
            this.usualWork = new OccupationalDataUsualWorkComponent();
            return this.usualWork;
        }
        if (name.equals("pastOrPresentJob")) {
            return this.addPastOrPresentJob();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "OccupationalData";
    }

    @Override
    public OccupationalData copy() {
        OccupationalData dst = new OccupationalData();
        this.copyValues(dst);
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        DateTimeType dateTimeType = dst.date = this.date == null ? null : this.date.copy();
        if (this.recorder != null) {
            dst.recorder = new ArrayList<Reference>();
            for (Reference reference : this.recorder) {
                dst.recorder.add(reference.copy());
            }
        }
        if (this.informant != null) {
            dst.informant = new ArrayList<Reference>();
            for (Reference reference : this.informant) {
                dst.informant.add(reference.copy());
            }
        }
        if (this.employmentStatus != null) {
            dst.employmentStatus = new ArrayList<OccupationalDataEmploymentStatusComponent>();
            for (OccupationalDataEmploymentStatusComponent occupationalDataEmploymentStatusComponent : this.employmentStatus) {
                dst.employmentStatus.add(occupationalDataEmploymentStatusComponent.copy());
            }
        }
        if (this.retirementDate != null) {
            dst.retirementDate = new ArrayList<DateTimeType>();
            for (DateTimeType dateTimeType2 : this.retirementDate) {
                dst.retirementDate.add(dateTimeType2.copy());
            }
        }
        if (this.combatZonePeriod != null) {
            dst.combatZonePeriod = new ArrayList<Period>();
            for (Period period : this.combatZonePeriod) {
                dst.combatZonePeriod.add(period.copy());
            }
        }
        OccupationalDataUsualWorkComponent occupationalDataUsualWorkComponent = dst.usualWork = this.usualWork == null ? null : this.usualWork.copy();
        if (this.pastOrPresentJob != null) {
            dst.pastOrPresentJob = new ArrayList<OccupationalDataPastOrPresentJobComponent>();
            for (OccupationalDataPastOrPresentJobComponent occupationalDataPastOrPresentJobComponent : this.pastOrPresentJob) {
                dst.pastOrPresentJob.add(occupationalDataPastOrPresentJobComponent.copy());
            }
        }
        return dst;
    }

    protected OccupationalData typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof OccupationalData)) {
            return false;
        }
        OccupationalData o = (OccupationalData)other_;
        return OccupationalData.compareDeep(this.identifier, o.identifier, true) && OccupationalData.compareDeep(this.status, o.status, true) && OccupationalData.compareDeep(this.subject, o.subject, true) && OccupationalData.compareDeep(this.date, o.date, true) && OccupationalData.compareDeep(this.recorder, o.recorder, true) && OccupationalData.compareDeep(this.informant, o.informant, true) && OccupationalData.compareDeep(this.employmentStatus, o.employmentStatus, true) && OccupationalData.compareDeep(this.retirementDate, o.retirementDate, true) && OccupationalData.compareDeep(this.combatZonePeriod, o.combatZonePeriod, true) && OccupationalData.compareDeep(this.usualWork, o.usualWork, true) && OccupationalData.compareDeep(this.pastOrPresentJob, o.pastOrPresentJob, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof OccupationalData)) {
            return false;
        }
        OccupationalData o = (OccupationalData)other_;
        return OccupationalData.compareValues(this.status, o.status, true) && OccupationalData.compareValues(this.date, o.date, true) && OccupationalData.compareValues(this.retirementDate, o.retirementDate, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.subject, this.date, this.recorder, this.informant, this.employmentStatus, this.retirementDate, this.combatZonePeriod, this.usualWork, this.pastOrPresentJob});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.OccupationalData;
    }

    @Block
    public static class OccupationalDataPastOrPresentJobWorkScheduleComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Past or Present Job work schedule code", formalDefinition="A code that represents a person's typical arrangement of working hours for one job.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/work-schedule-odh")
        protected CodeableConcept code;
        @Child(name="weeklyWorkDays", type={DecimalType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Past or Present Job work schedule weekly work days", formalDefinition="The typical number of days worked in a week by a person at one job.")
        protected DecimalType weeklyWorkDays;
        @Child(name="dailyWorkHours", type={DecimalType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Past or Present Job work schedule daily work hours", formalDefinition="The number of hours worked in a day or shift at one job by a person. For those working a split shift (divided into two parts that are separated by an interval longer than a normal rest period), it is the total of both periods of time in a shift.")
        protected DecimalType dailyWorkHours;
        private static final long serialVersionUID = -253812674L;

        public OccupationalDataPastOrPresentJobWorkScheduleComponent() {
        }

        public OccupationalDataPastOrPresentJobWorkScheduleComponent(CodeableConcept code) {
            this.code = code;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OccupationalDataPastOrPresentJobWorkScheduleComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public OccupationalDataPastOrPresentJobWorkScheduleComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public DecimalType getWeeklyWorkDaysElement() {
            if (this.weeklyWorkDays == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OccupationalDataPastOrPresentJobWorkScheduleComponent.weeklyWorkDays");
                }
                if (Configuration.doAutoCreate()) {
                    this.weeklyWorkDays = new DecimalType();
                }
            }
            return this.weeklyWorkDays;
        }

        public boolean hasWeeklyWorkDaysElement() {
            return this.weeklyWorkDays != null && !this.weeklyWorkDays.isEmpty();
        }

        public boolean hasWeeklyWorkDays() {
            return this.weeklyWorkDays != null && !this.weeklyWorkDays.isEmpty();
        }

        public OccupationalDataPastOrPresentJobWorkScheduleComponent setWeeklyWorkDaysElement(DecimalType value) {
            this.weeklyWorkDays = value;
            return this;
        }

        public BigDecimal getWeeklyWorkDays() {
            return this.weeklyWorkDays == null ? null : (BigDecimal)this.weeklyWorkDays.getValue();
        }

        public OccupationalDataPastOrPresentJobWorkScheduleComponent setWeeklyWorkDays(BigDecimal value) {
            if (value == null) {
                this.weeklyWorkDays = null;
            } else {
                if (this.weeklyWorkDays == null) {
                    this.weeklyWorkDays = new DecimalType();
                }
                this.weeklyWorkDays.setValue(value);
            }
            return this;
        }

        public OccupationalDataPastOrPresentJobWorkScheduleComponent setWeeklyWorkDays(long value) {
            this.weeklyWorkDays = new DecimalType();
            this.weeklyWorkDays.setValue(value);
            return this;
        }

        public OccupationalDataPastOrPresentJobWorkScheduleComponent setWeeklyWorkDays(double value) {
            this.weeklyWorkDays = new DecimalType();
            this.weeklyWorkDays.setValue(value);
            return this;
        }

        public DecimalType getDailyWorkHoursElement() {
            if (this.dailyWorkHours == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OccupationalDataPastOrPresentJobWorkScheduleComponent.dailyWorkHours");
                }
                if (Configuration.doAutoCreate()) {
                    this.dailyWorkHours = new DecimalType();
                }
            }
            return this.dailyWorkHours;
        }

        public boolean hasDailyWorkHoursElement() {
            return this.dailyWorkHours != null && !this.dailyWorkHours.isEmpty();
        }

        public boolean hasDailyWorkHours() {
            return this.dailyWorkHours != null && !this.dailyWorkHours.isEmpty();
        }

        public OccupationalDataPastOrPresentJobWorkScheduleComponent setDailyWorkHoursElement(DecimalType value) {
            this.dailyWorkHours = value;
            return this;
        }

        public BigDecimal getDailyWorkHours() {
            return this.dailyWorkHours == null ? null : (BigDecimal)this.dailyWorkHours.getValue();
        }

        public OccupationalDataPastOrPresentJobWorkScheduleComponent setDailyWorkHours(BigDecimal value) {
            if (value == null) {
                this.dailyWorkHours = null;
            } else {
                if (this.dailyWorkHours == null) {
                    this.dailyWorkHours = new DecimalType();
                }
                this.dailyWorkHours.setValue(value);
            }
            return this;
        }

        public OccupationalDataPastOrPresentJobWorkScheduleComponent setDailyWorkHours(long value) {
            this.dailyWorkHours = new DecimalType();
            this.dailyWorkHours.setValue(value);
            return this;
        }

        public OccupationalDataPastOrPresentJobWorkScheduleComponent setDailyWorkHours(double value) {
            this.dailyWorkHours = new DecimalType();
            this.dailyWorkHours.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "CodeableConcept", "A code that represents a person's typical arrangement of working hours for one job.", 0, 1, this.code));
            children.add(new Property("weeklyWorkDays", "decimal", "The typical number of days worked in a week by a person at one job.", 0, 1, this.weeklyWorkDays));
            children.add(new Property("dailyWorkHours", "decimal", "The number of hours worked in a day or shift at one job by a person. For those working a split shift (divided into two parts that are separated by an interval longer than a normal rest period), it is the total of both periods of time in a shift.", 0, 1, this.dailyWorkHours));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "CodeableConcept", "A code that represents a person's typical arrangement of working hours for one job.", 0, 1, this.code);
                }
                case -2051928407: {
                    return new Property("weeklyWorkDays", "decimal", "The typical number of days worked in a week by a person at one job.", 0, 1, this.weeklyWorkDays);
                }
                case -1065164699: {
                    return new Property("dailyWorkHours", "decimal", "The number of hours worked in a day or shift at one job by a person. For those working a split shift (divided into two parts that are separated by an interval longer than a normal rest period), it is the total of both periods of time in a shift.", 0, 1, this.dailyWorkHours);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case -2051928407: {
                    Base[] baseArray;
                    if (this.weeklyWorkDays == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.weeklyWorkDays;
                    }
                    return baseArray;
                }
                case -1065164699: {
                    Base[] baseArray;
                    if (this.dailyWorkHours == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.dailyWorkHours;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = this.castToCodeableConcept(value);
                    return value;
                }
                case -2051928407: {
                    this.weeklyWorkDays = this.castToDecimal(value);
                    return value;
                }
                case -1065164699: {
                    this.dailyWorkHours = this.castToDecimal(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = this.castToCodeableConcept(value);
            } else if (name.equals("weeklyWorkDays")) {
                this.weeklyWorkDays = this.castToDecimal(value);
            } else if (name.equals("dailyWorkHours")) {
                this.dailyWorkHours = this.castToDecimal(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case -2051928407: {
                    return this.getWeeklyWorkDaysElement();
                }
                case -1065164699: {
                    return this.getDailyWorkHoursElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case -2051928407: {
                    return new String[]{"decimal"};
                }
                case -1065164699: {
                    return new String[]{"decimal"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("weeklyWorkDays")) {
                throw new FHIRException("Cannot call addChild on a primitive type OccupationalData.weeklyWorkDays");
            }
            if (name.equals("dailyWorkHours")) {
                throw new FHIRException("Cannot call addChild on a primitive type OccupationalData.dailyWorkHours");
            }
            return super.addChild(name);
        }

        @Override
        public OccupationalDataPastOrPresentJobWorkScheduleComponent copy() {
            OccupationalDataPastOrPresentJobWorkScheduleComponent dst = new OccupationalDataPastOrPresentJobWorkScheduleComponent();
            this.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.weeklyWorkDays = this.weeklyWorkDays == null ? null : this.weeklyWorkDays.copy();
            dst.dailyWorkHours = this.dailyWorkHours == null ? null : this.dailyWorkHours.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof OccupationalDataPastOrPresentJobWorkScheduleComponent)) {
                return false;
            }
            OccupationalDataPastOrPresentJobWorkScheduleComponent o = (OccupationalDataPastOrPresentJobWorkScheduleComponent)other_;
            return OccupationalDataPastOrPresentJobWorkScheduleComponent.compareDeep(this.code, o.code, true) && OccupationalDataPastOrPresentJobWorkScheduleComponent.compareDeep(this.weeklyWorkDays, o.weeklyWorkDays, true) && OccupationalDataPastOrPresentJobWorkScheduleComponent.compareDeep(this.dailyWorkHours, o.dailyWorkHours, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof OccupationalDataPastOrPresentJobWorkScheduleComponent)) {
                return false;
            }
            OccupationalDataPastOrPresentJobWorkScheduleComponent o = (OccupationalDataPastOrPresentJobWorkScheduleComponent)other_;
            return OccupationalDataPastOrPresentJobWorkScheduleComponent.compareValues(this.weeklyWorkDays, o.weeklyWorkDays, true) && OccupationalDataPastOrPresentJobWorkScheduleComponent.compareValues(this.dailyWorkHours, o.dailyWorkHours, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.code, this.weeklyWorkDays, this.dailyWorkHours});
        }

        @Override
        public String fhirType() {
            return "OccupationalData.pastOrPresentJob.workSchedule";
        }
    }

    @Block
    public static class OccupationalDataPastOrPresentJobComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="occupation", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Past or Present Job occupation", formalDefinition="A code that represents the type of work done by a person at one job.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/occupation-cdc-census-2010")
        protected CodeableConcept occupation;
        @Child(name="industry", type={CodeableConcept.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Past or Present Job industry", formalDefinition="A code that represents the type of business associated with a person's Past or Present Job; i.e., for one job. A change in industry indicates a change in job.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/industry-cdc-census-2010")
        protected CodeableConcept industry;
        @Child(name="effective", type={Period.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Past or Present Job effective time period", formalDefinition="The start and end dates for one job.  A change in occupation, supervisory level, industry, employer, or employer location is considered a new job.")
        protected Period effective;
        @Child(name="employer", type={Organization.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Past or Present Job employer", formalDefinition="The party, be it an individual or an organization, responsible for providing compensation to a person performing work, or in the case of unpaid work, the party responsible for engaging the person in a position. For military occupations, this refers to the name of the person's military home base; the person's Branch of Service is recorded as industry. A change in employer or employer location indicates a change in job.")
        protected Reference employer;
        protected Organization employerTarget;
        @Child(name="workClassification", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Past or Present Job work classification", formalDefinition="The classification of a person's job (one job) as defined by compensation and sector (e.g. paid, unpaid, self-employed, government, etc.). This is different from employment status: a person who is a volunteer (work classification) may have chosen not to be in the labor force (employment status).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/work-classification-odh")
        protected CodeableConcept workClassification;
        @Child(name="supervisoryLevel", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Past or Present Job supervisory level", formalDefinition="Reflects the amount of supervisory or management responsibilities of a person at one job. For military jobs, pay grade is used as a proxy because it can be interpreted across branches of service.  A change in supervisory level is considered a new job.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/supervisory-level-odh-us")
        protected CodeableConcept supervisoryLevel;
        @Child(name="jobDuty", type={StringType.class}, order=7, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Past or Present Job job duty", formalDefinition="A regular action performed at a single job.")
        protected List<StringType> jobDuty;
        @Child(name="occupationalHazard", type={StringType.class}, order=8, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Past or Present Job occupational hazard", formalDefinition="A hazard that is specific to a person's work or work environment for a single job and with which the person might come in contact. A hazard is a source of potential harm to an individual's physical or mental health (e.g., biological, chemical, physical, psychological, radiological).")
        protected List<StringType> occupationalHazard;
        @Child(name="workSchedule", type={}, order=9, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Past or Present Job work schedule", formalDefinition="Describes a person's typical arrangement of working hours for one job.")
        protected OccupationalDataPastOrPresentJobWorkScheduleComponent workSchedule;
        private static final long serialVersionUID = 354602497L;

        public OccupationalDataPastOrPresentJobComponent() {
        }

        public OccupationalDataPastOrPresentJobComponent(CodeableConcept occupation, CodeableConcept industry) {
            this.occupation = occupation;
            this.industry = industry;
        }

        public CodeableConcept getOccupation() {
            if (this.occupation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OccupationalDataPastOrPresentJobComponent.occupation");
                }
                if (Configuration.doAutoCreate()) {
                    this.occupation = new CodeableConcept();
                }
            }
            return this.occupation;
        }

        public boolean hasOccupation() {
            return this.occupation != null && !this.occupation.isEmpty();
        }

        public OccupationalDataPastOrPresentJobComponent setOccupation(CodeableConcept value) {
            this.occupation = value;
            return this;
        }

        public CodeableConcept getIndustry() {
            if (this.industry == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OccupationalDataPastOrPresentJobComponent.industry");
                }
                if (Configuration.doAutoCreate()) {
                    this.industry = new CodeableConcept();
                }
            }
            return this.industry;
        }

        public boolean hasIndustry() {
            return this.industry != null && !this.industry.isEmpty();
        }

        public OccupationalDataPastOrPresentJobComponent setIndustry(CodeableConcept value) {
            this.industry = value;
            return this;
        }

        public Period getEffective() {
            if (this.effective == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OccupationalDataPastOrPresentJobComponent.effective");
                }
                if (Configuration.doAutoCreate()) {
                    this.effective = new Period();
                }
            }
            return this.effective;
        }

        public boolean hasEffective() {
            return this.effective != null && !this.effective.isEmpty();
        }

        public OccupationalDataPastOrPresentJobComponent setEffective(Period value) {
            this.effective = value;
            return this;
        }

        public Reference getEmployer() {
            if (this.employer == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OccupationalDataPastOrPresentJobComponent.employer");
                }
                if (Configuration.doAutoCreate()) {
                    this.employer = new Reference();
                }
            }
            return this.employer;
        }

        public boolean hasEmployer() {
            return this.employer != null && !this.employer.isEmpty();
        }

        public OccupationalDataPastOrPresentJobComponent setEmployer(Reference value) {
            this.employer = value;
            return this;
        }

        public Organization getEmployerTarget() {
            if (this.employerTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OccupationalDataPastOrPresentJobComponent.employer");
                }
                if (Configuration.doAutoCreate()) {
                    this.employerTarget = new Organization();
                }
            }
            return this.employerTarget;
        }

        public OccupationalDataPastOrPresentJobComponent setEmployerTarget(Organization value) {
            this.employerTarget = value;
            return this;
        }

        public CodeableConcept getWorkClassification() {
            if (this.workClassification == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OccupationalDataPastOrPresentJobComponent.workClassification");
                }
                if (Configuration.doAutoCreate()) {
                    this.workClassification = new CodeableConcept();
                }
            }
            return this.workClassification;
        }

        public boolean hasWorkClassification() {
            return this.workClassification != null && !this.workClassification.isEmpty();
        }

        public OccupationalDataPastOrPresentJobComponent setWorkClassification(CodeableConcept value) {
            this.workClassification = value;
            return this;
        }

        public CodeableConcept getSupervisoryLevel() {
            if (this.supervisoryLevel == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OccupationalDataPastOrPresentJobComponent.supervisoryLevel");
                }
                if (Configuration.doAutoCreate()) {
                    this.supervisoryLevel = new CodeableConcept();
                }
            }
            return this.supervisoryLevel;
        }

        public boolean hasSupervisoryLevel() {
            return this.supervisoryLevel != null && !this.supervisoryLevel.isEmpty();
        }

        public OccupationalDataPastOrPresentJobComponent setSupervisoryLevel(CodeableConcept value) {
            this.supervisoryLevel = value;
            return this;
        }

        public List<StringType> getJobDuty() {
            if (this.jobDuty == null) {
                this.jobDuty = new ArrayList<StringType>();
            }
            return this.jobDuty;
        }

        public OccupationalDataPastOrPresentJobComponent setJobDuty(List<StringType> theJobDuty) {
            this.jobDuty = theJobDuty;
            return this;
        }

        public boolean hasJobDuty() {
            if (this.jobDuty == null) {
                return false;
            }
            for (StringType item : this.jobDuty) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addJobDutyElement() {
            StringType t = new StringType();
            if (this.jobDuty == null) {
                this.jobDuty = new ArrayList<StringType>();
            }
            this.jobDuty.add(t);
            return t;
        }

        public OccupationalDataPastOrPresentJobComponent addJobDuty(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.jobDuty == null) {
                this.jobDuty = new ArrayList<StringType>();
            }
            this.jobDuty.add(t);
            return this;
        }

        public boolean hasJobDuty(String value) {
            if (this.jobDuty == null) {
                return false;
            }
            for (StringType v : this.jobDuty) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<StringType> getOccupationalHazard() {
            if (this.occupationalHazard == null) {
                this.occupationalHazard = new ArrayList<StringType>();
            }
            return this.occupationalHazard;
        }

        public OccupationalDataPastOrPresentJobComponent setOccupationalHazard(List<StringType> theOccupationalHazard) {
            this.occupationalHazard = theOccupationalHazard;
            return this;
        }

        public boolean hasOccupationalHazard() {
            if (this.occupationalHazard == null) {
                return false;
            }
            for (StringType item : this.occupationalHazard) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addOccupationalHazardElement() {
            StringType t = new StringType();
            if (this.occupationalHazard == null) {
                this.occupationalHazard = new ArrayList<StringType>();
            }
            this.occupationalHazard.add(t);
            return t;
        }

        public OccupationalDataPastOrPresentJobComponent addOccupationalHazard(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.occupationalHazard == null) {
                this.occupationalHazard = new ArrayList<StringType>();
            }
            this.occupationalHazard.add(t);
            return this;
        }

        public boolean hasOccupationalHazard(String value) {
            if (this.occupationalHazard == null) {
                return false;
            }
            for (StringType v : this.occupationalHazard) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public OccupationalDataPastOrPresentJobWorkScheduleComponent getWorkSchedule() {
            if (this.workSchedule == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OccupationalDataPastOrPresentJobComponent.workSchedule");
                }
                if (Configuration.doAutoCreate()) {
                    this.workSchedule = new OccupationalDataPastOrPresentJobWorkScheduleComponent();
                }
            }
            return this.workSchedule;
        }

        public boolean hasWorkSchedule() {
            return this.workSchedule != null && !this.workSchedule.isEmpty();
        }

        public OccupationalDataPastOrPresentJobComponent setWorkSchedule(OccupationalDataPastOrPresentJobWorkScheduleComponent value) {
            this.workSchedule = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("occupation", "CodeableConcept", "A code that represents the type of work done by a person at one job.", 0, 1, this.occupation));
            children.add(new Property("industry", "CodeableConcept", "A code that represents the type of business associated with a person's Past or Present Job; i.e., for one job. A change in industry indicates a change in job.", 0, 1, this.industry));
            children.add(new Property("effective", "Period", "The start and end dates for one job.  A change in occupation, supervisory level, industry, employer, or employer location is considered a new job.", 0, 1, this.effective));
            children.add(new Property("employer", "Reference(Organization)", "The party, be it an individual or an organization, responsible for providing compensation to a person performing work, or in the case of unpaid work, the party responsible for engaging the person in a position. For military occupations, this refers to the name of the person's military home base; the person's Branch of Service is recorded as industry. A change in employer or employer location indicates a change in job.", 0, 1, this.employer));
            children.add(new Property("workClassification", "CodeableConcept", "The classification of a person's job (one job) as defined by compensation and sector (e.g. paid, unpaid, self-employed, government, etc.). This is different from employment status: a person who is a volunteer (work classification) may have chosen not to be in the labor force (employment status).", 0, 1, this.workClassification));
            children.add(new Property("supervisoryLevel", "CodeableConcept", "Reflects the amount of supervisory or management responsibilities of a person at one job. For military jobs, pay grade is used as a proxy because it can be interpreted across branches of service.  A change in supervisory level is considered a new job.", 0, 1, this.supervisoryLevel));
            children.add(new Property("jobDuty", "string", "A regular action performed at a single job.", 0, Integer.MAX_VALUE, this.jobDuty));
            children.add(new Property("occupationalHazard", "string", "A hazard that is specific to a person's work or work environment for a single job and with which the person might come in contact. A hazard is a source of potential harm to an individual's physical or mental health (e.g., biological, chemical, physical, psychological, radiological).", 0, Integer.MAX_VALUE, this.occupationalHazard));
            children.add(new Property("workSchedule", "", "Describes a person's typical arrangement of working hours for one job.", 0, 1, this.workSchedule));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1615358283: {
                    return new Property("occupation", "CodeableConcept", "A code that represents the type of work done by a person at one job.", 0, 1, this.occupation);
                }
                case 127156702: {
                    return new Property("industry", "CodeableConcept", "A code that represents the type of business associated with a person's Past or Present Job; i.e., for one job. A change in industry indicates a change in job.", 0, 1, this.industry);
                }
                case -1468651097: {
                    return new Property("effective", "Period", "The start and end dates for one job.  A change in occupation, supervisory level, industry, employer, or employer location is considered a new job.", 0, 1, this.effective);
                }
                case 1193469627: {
                    return new Property("employer", "Reference(Organization)", "The party, be it an individual or an organization, responsible for providing compensation to a person performing work, or in the case of unpaid work, the party responsible for engaging the person in a position. For military occupations, this refers to the name of the person's military home base; the person's Branch of Service is recorded as industry. A change in employer or employer location indicates a change in job.", 0, 1, this.employer);
                }
                case 909284695: {
                    return new Property("workClassification", "CodeableConcept", "The classification of a person's job (one job) as defined by compensation and sector (e.g. paid, unpaid, self-employed, government, etc.). This is different from employment status: a person who is a volunteer (work classification) may have chosen not to be in the labor force (employment status).", 0, 1, this.workClassification);
                }
                case -1746062349: {
                    return new Property("supervisoryLevel", "CodeableConcept", "Reflects the amount of supervisory or management responsibilities of a person at one job. For military jobs, pay grade is used as a proxy because it can be interpreted across branches of service.  A change in supervisory level is considered a new job.", 0, 1, this.supervisoryLevel);
                }
                case -1438374861: {
                    return new Property("jobDuty", "string", "A regular action performed at a single job.", 0, Integer.MAX_VALUE, this.jobDuty);
                }
                case 1203483240: {
                    return new Property("occupationalHazard", "string", "A hazard that is specific to a person's work or work environment for a single job and with which the person might come in contact. A hazard is a source of potential harm to an individual's physical or mental health (e.g., biological, chemical, physical, psychological, radiological).", 0, Integer.MAX_VALUE, this.occupationalHazard);
                }
                case -1102242616: {
                    return new Property("workSchedule", "", "Describes a person's typical arrangement of working hours for one job.", 0, 1, this.workSchedule);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1615358283: {
                    Base[] baseArray;
                    if (this.occupation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.occupation;
                    }
                    return baseArray;
                }
                case 127156702: {
                    Base[] baseArray;
                    if (this.industry == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.industry;
                    }
                    return baseArray;
                }
                case -1468651097: {
                    Base[] baseArray;
                    if (this.effective == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.effective;
                    }
                    return baseArray;
                }
                case 1193469627: {
                    Base[] baseArray;
                    if (this.employer == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.employer;
                    }
                    return baseArray;
                }
                case 909284695: {
                    Base[] baseArray;
                    if (this.workClassification == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.workClassification;
                    }
                    return baseArray;
                }
                case -1746062349: {
                    Base[] baseArray;
                    if (this.supervisoryLevel == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.supervisoryLevel;
                    }
                    return baseArray;
                }
                case -1438374861: {
                    return this.jobDuty == null ? new Base[]{} : this.jobDuty.toArray(new Base[this.jobDuty.size()]);
                }
                case 1203483240: {
                    return this.occupationalHazard == null ? new Base[]{} : this.occupationalHazard.toArray(new Base[this.occupationalHazard.size()]);
                }
                case -1102242616: {
                    Base[] baseArray;
                    if (this.workSchedule == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.workSchedule;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1615358283: {
                    this.occupation = this.castToCodeableConcept(value);
                    return value;
                }
                case 127156702: {
                    this.industry = this.castToCodeableConcept(value);
                    return value;
                }
                case -1468651097: {
                    this.effective = this.castToPeriod(value);
                    return value;
                }
                case 1193469627: {
                    this.employer = this.castToReference(value);
                    return value;
                }
                case 909284695: {
                    this.workClassification = this.castToCodeableConcept(value);
                    return value;
                }
                case -1746062349: {
                    this.supervisoryLevel = this.castToCodeableConcept(value);
                    return value;
                }
                case -1438374861: {
                    this.getJobDuty().add(this.castToString(value));
                    return value;
                }
                case 1203483240: {
                    this.getOccupationalHazard().add(this.castToString(value));
                    return value;
                }
                case -1102242616: {
                    this.workSchedule = (OccupationalDataPastOrPresentJobWorkScheduleComponent)value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("occupation")) {
                this.occupation = this.castToCodeableConcept(value);
            } else if (name.equals("industry")) {
                this.industry = this.castToCodeableConcept(value);
            } else if (name.equals("effective")) {
                this.effective = this.castToPeriod(value);
            } else if (name.equals("employer")) {
                this.employer = this.castToReference(value);
            } else if (name.equals("workClassification")) {
                this.workClassification = this.castToCodeableConcept(value);
            } else if (name.equals("supervisoryLevel")) {
                this.supervisoryLevel = this.castToCodeableConcept(value);
            } else if (name.equals("jobDuty")) {
                this.getJobDuty().add(this.castToString(value));
            } else if (name.equals("occupationalHazard")) {
                this.getOccupationalHazard().add(this.castToString(value));
            } else if (name.equals("workSchedule")) {
                this.workSchedule = (OccupationalDataPastOrPresentJobWorkScheduleComponent)value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1615358283: {
                    return this.getOccupation();
                }
                case 127156702: {
                    return this.getIndustry();
                }
                case -1468651097: {
                    return this.getEffective();
                }
                case 1193469627: {
                    return this.getEmployer();
                }
                case 909284695: {
                    return this.getWorkClassification();
                }
                case -1746062349: {
                    return this.getSupervisoryLevel();
                }
                case -1438374861: {
                    return this.addJobDutyElement();
                }
                case 1203483240: {
                    return this.addOccupationalHazardElement();
                }
                case -1102242616: {
                    return this.getWorkSchedule();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1615358283: {
                    return new String[]{"CodeableConcept"};
                }
                case 127156702: {
                    return new String[]{"CodeableConcept"};
                }
                case -1468651097: {
                    return new String[]{"Period"};
                }
                case 1193469627: {
                    return new String[]{"Reference"};
                }
                case 909284695: {
                    return new String[]{"CodeableConcept"};
                }
                case -1746062349: {
                    return new String[]{"CodeableConcept"};
                }
                case -1438374861: {
                    return new String[]{"string"};
                }
                case 1203483240: {
                    return new String[]{"string"};
                }
                case -1102242616: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("occupation")) {
                this.occupation = new CodeableConcept();
                return this.occupation;
            }
            if (name.equals("industry")) {
                this.industry = new CodeableConcept();
                return this.industry;
            }
            if (name.equals("effective")) {
                this.effective = new Period();
                return this.effective;
            }
            if (name.equals("employer")) {
                this.employer = new Reference();
                return this.employer;
            }
            if (name.equals("workClassification")) {
                this.workClassification = new CodeableConcept();
                return this.workClassification;
            }
            if (name.equals("supervisoryLevel")) {
                this.supervisoryLevel = new CodeableConcept();
                return this.supervisoryLevel;
            }
            if (name.equals("jobDuty")) {
                throw new FHIRException("Cannot call addChild on a primitive type OccupationalData.jobDuty");
            }
            if (name.equals("occupationalHazard")) {
                throw new FHIRException("Cannot call addChild on a primitive type OccupationalData.occupationalHazard");
            }
            if (name.equals("workSchedule")) {
                this.workSchedule = new OccupationalDataPastOrPresentJobWorkScheduleComponent();
                return this.workSchedule;
            }
            return super.addChild(name);
        }

        @Override
        public OccupationalDataPastOrPresentJobComponent copy() {
            OccupationalDataPastOrPresentJobComponent dst = new OccupationalDataPastOrPresentJobComponent();
            this.copyValues(dst);
            dst.occupation = this.occupation == null ? null : this.occupation.copy();
            dst.industry = this.industry == null ? null : this.industry.copy();
            dst.effective = this.effective == null ? null : this.effective.copy();
            dst.employer = this.employer == null ? null : this.employer.copy();
            dst.workClassification = this.workClassification == null ? null : this.workClassification.copy();
            CodeableConcept codeableConcept = dst.supervisoryLevel = this.supervisoryLevel == null ? null : this.supervisoryLevel.copy();
            if (this.jobDuty != null) {
                dst.jobDuty = new ArrayList<StringType>();
                for (StringType i : this.jobDuty) {
                    dst.jobDuty.add(i.copy());
                }
            }
            if (this.occupationalHazard != null) {
                dst.occupationalHazard = new ArrayList<StringType>();
                for (StringType i : this.occupationalHazard) {
                    dst.occupationalHazard.add(i.copy());
                }
            }
            dst.workSchedule = this.workSchedule == null ? null : this.workSchedule.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof OccupationalDataPastOrPresentJobComponent)) {
                return false;
            }
            OccupationalDataPastOrPresentJobComponent o = (OccupationalDataPastOrPresentJobComponent)other_;
            return OccupationalDataPastOrPresentJobComponent.compareDeep(this.occupation, o.occupation, true) && OccupationalDataPastOrPresentJobComponent.compareDeep(this.industry, o.industry, true) && OccupationalDataPastOrPresentJobComponent.compareDeep(this.effective, o.effective, true) && OccupationalDataPastOrPresentJobComponent.compareDeep(this.employer, o.employer, true) && OccupationalDataPastOrPresentJobComponent.compareDeep(this.workClassification, o.workClassification, true) && OccupationalDataPastOrPresentJobComponent.compareDeep(this.supervisoryLevel, o.supervisoryLevel, true) && OccupationalDataPastOrPresentJobComponent.compareDeep(this.jobDuty, o.jobDuty, true) && OccupationalDataPastOrPresentJobComponent.compareDeep(this.occupationalHazard, o.occupationalHazard, true) && OccupationalDataPastOrPresentJobComponent.compareDeep(this.workSchedule, o.workSchedule, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof OccupationalDataPastOrPresentJobComponent)) {
                return false;
            }
            OccupationalDataPastOrPresentJobComponent o = (OccupationalDataPastOrPresentJobComponent)other_;
            return OccupationalDataPastOrPresentJobComponent.compareValues(this.jobDuty, o.jobDuty, true) && OccupationalDataPastOrPresentJobComponent.compareValues(this.occupationalHazard, o.occupationalHazard, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.occupation, this.industry, this.effective, this.employer, this.workClassification, this.supervisoryLevel, this.jobDuty, this.occupationalHazard, this.workSchedule});
        }

        @Override
        public String fhirType() {
            return "OccupationalData.pastOrPresentJob";
        }
    }

    @Block
    public static class OccupationalDataUsualWorkComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="occupation", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Usual Work occupation", formalDefinition="A code that represents the type of work a person has held for the longest amount of time during his or her life.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/occupation-cdc-census-2010")
        protected CodeableConcept occupation;
        @Child(name="industry", type={CodeableConcept.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Usual Work industry", formalDefinition="A code that represents the type of business a person has worked in for the longest total time while in the usual occupation.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/industry-cdc-census-2010")
        protected CodeableConcept industry;
        @Child(name="start", type={DateTimeType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Usual Work start time", formalDefinition="The date when a person first started working in their usual occupation.")
        protected DateTimeType start;
        @Child(name="duration", type={Duration.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Usual Work duration", formalDefinition="Total of all periods of time a person has spent in the usual occupation, not including intermittent period(s) where the person was not working in that occupation.")
        protected Duration duration;
        private static final long serialVersionUID = -1952160116L;

        public OccupationalDataUsualWorkComponent() {
        }

        public OccupationalDataUsualWorkComponent(CodeableConcept occupation, CodeableConcept industry) {
            this.occupation = occupation;
            this.industry = industry;
        }

        public CodeableConcept getOccupation() {
            if (this.occupation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OccupationalDataUsualWorkComponent.occupation");
                }
                if (Configuration.doAutoCreate()) {
                    this.occupation = new CodeableConcept();
                }
            }
            return this.occupation;
        }

        public boolean hasOccupation() {
            return this.occupation != null && !this.occupation.isEmpty();
        }

        public OccupationalDataUsualWorkComponent setOccupation(CodeableConcept value) {
            this.occupation = value;
            return this;
        }

        public CodeableConcept getIndustry() {
            if (this.industry == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OccupationalDataUsualWorkComponent.industry");
                }
                if (Configuration.doAutoCreate()) {
                    this.industry = new CodeableConcept();
                }
            }
            return this.industry;
        }

        public boolean hasIndustry() {
            return this.industry != null && !this.industry.isEmpty();
        }

        public OccupationalDataUsualWorkComponent setIndustry(CodeableConcept value) {
            this.industry = value;
            return this;
        }

        public DateTimeType getStartElement() {
            if (this.start == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OccupationalDataUsualWorkComponent.start");
                }
                if (Configuration.doAutoCreate()) {
                    this.start = new DateTimeType();
                }
            }
            return this.start;
        }

        public boolean hasStartElement() {
            return this.start != null && !this.start.isEmpty();
        }

        public boolean hasStart() {
            return this.start != null && !this.start.isEmpty();
        }

        public OccupationalDataUsualWorkComponent setStartElement(DateTimeType value) {
            this.start = value;
            return this;
        }

        public Date getStart() {
            return this.start == null ? null : (Date)this.start.getValue();
        }

        public OccupationalDataUsualWorkComponent setStart(Date value) {
            if (value == null) {
                this.start = null;
            } else {
                if (this.start == null) {
                    this.start = new DateTimeType();
                }
                this.start.setValue(value);
            }
            return this;
        }

        public Duration getDuration() {
            if (this.duration == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OccupationalDataUsualWorkComponent.duration");
                }
                if (Configuration.doAutoCreate()) {
                    this.duration = new Duration();
                }
            }
            return this.duration;
        }

        public boolean hasDuration() {
            return this.duration != null && !this.duration.isEmpty();
        }

        public OccupationalDataUsualWorkComponent setDuration(Duration value) {
            this.duration = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("occupation", "CodeableConcept", "A code that represents the type of work a person has held for the longest amount of time during his or her life.", 0, 1, this.occupation));
            children.add(new Property("industry", "CodeableConcept", "A code that represents the type of business a person has worked in for the longest total time while in the usual occupation.", 0, 1, this.industry));
            children.add(new Property("start", "dateTime", "The date when a person first started working in their usual occupation.", 0, 1, this.start));
            children.add(new Property("duration", "Duration", "Total of all periods of time a person has spent in the usual occupation, not including intermittent period(s) where the person was not working in that occupation.", 0, 1, this.duration));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1615358283: {
                    return new Property("occupation", "CodeableConcept", "A code that represents the type of work a person has held for the longest amount of time during his or her life.", 0, 1, this.occupation);
                }
                case 127156702: {
                    return new Property("industry", "CodeableConcept", "A code that represents the type of business a person has worked in for the longest total time while in the usual occupation.", 0, 1, this.industry);
                }
                case 109757538: {
                    return new Property("start", "dateTime", "The date when a person first started working in their usual occupation.", 0, 1, this.start);
                }
                case -1992012396: {
                    return new Property("duration", "Duration", "Total of all periods of time a person has spent in the usual occupation, not including intermittent period(s) where the person was not working in that occupation.", 0, 1, this.duration);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1615358283: {
                    Base[] baseArray;
                    if (this.occupation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.occupation;
                    }
                    return baseArray;
                }
                case 127156702: {
                    Base[] baseArray;
                    if (this.industry == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.industry;
                    }
                    return baseArray;
                }
                case 109757538: {
                    Base[] baseArray;
                    if (this.start == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.start;
                    }
                    return baseArray;
                }
                case -1992012396: {
                    Base[] baseArray;
                    if (this.duration == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.duration;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1615358283: {
                    this.occupation = this.castToCodeableConcept(value);
                    return value;
                }
                case 127156702: {
                    this.industry = this.castToCodeableConcept(value);
                    return value;
                }
                case 109757538: {
                    this.start = this.castToDateTime(value);
                    return value;
                }
                case -1992012396: {
                    this.duration = this.castToDuration(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("occupation")) {
                this.occupation = this.castToCodeableConcept(value);
            } else if (name.equals("industry")) {
                this.industry = this.castToCodeableConcept(value);
            } else if (name.equals("start")) {
                this.start = this.castToDateTime(value);
            } else if (name.equals("duration")) {
                this.duration = this.castToDuration(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1615358283: {
                    return this.getOccupation();
                }
                case 127156702: {
                    return this.getIndustry();
                }
                case 109757538: {
                    return this.getStartElement();
                }
                case -1992012396: {
                    return this.getDuration();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1615358283: {
                    return new String[]{"CodeableConcept"};
                }
                case 127156702: {
                    return new String[]{"CodeableConcept"};
                }
                case 109757538: {
                    return new String[]{"dateTime"};
                }
                case -1992012396: {
                    return new String[]{"Duration"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("occupation")) {
                this.occupation = new CodeableConcept();
                return this.occupation;
            }
            if (name.equals("industry")) {
                this.industry = new CodeableConcept();
                return this.industry;
            }
            if (name.equals("start")) {
                throw new FHIRException("Cannot call addChild on a primitive type OccupationalData.start");
            }
            if (name.equals("duration")) {
                this.duration = new Duration();
                return this.duration;
            }
            return super.addChild(name);
        }

        @Override
        public OccupationalDataUsualWorkComponent copy() {
            OccupationalDataUsualWorkComponent dst = new OccupationalDataUsualWorkComponent();
            this.copyValues(dst);
            dst.occupation = this.occupation == null ? null : this.occupation.copy();
            dst.industry = this.industry == null ? null : this.industry.copy();
            dst.start = this.start == null ? null : this.start.copy();
            dst.duration = this.duration == null ? null : this.duration.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof OccupationalDataUsualWorkComponent)) {
                return false;
            }
            OccupationalDataUsualWorkComponent o = (OccupationalDataUsualWorkComponent)other_;
            return OccupationalDataUsualWorkComponent.compareDeep(this.occupation, o.occupation, true) && OccupationalDataUsualWorkComponent.compareDeep(this.industry, o.industry, true) && OccupationalDataUsualWorkComponent.compareDeep(this.start, o.start, true) && OccupationalDataUsualWorkComponent.compareDeep(this.duration, o.duration, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof OccupationalDataUsualWorkComponent)) {
                return false;
            }
            OccupationalDataUsualWorkComponent o = (OccupationalDataUsualWorkComponent)other_;
            return OccupationalDataUsualWorkComponent.compareValues(this.start, o.start, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.occupation, this.industry, this.start, this.duration});
        }

        @Override
        public String fhirType() {
            return "OccupationalData.usualWork";
        }
    }

    @Block
    public static class OccupationalDataEmploymentStatusComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Employment status code", formalDefinition="A code that represents a person's current economic relationship to a job.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/employment-status-odh")
        protected CodeableConcept code;
        @Child(name="effective", type={Period.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Employment status effective time period", formalDefinition="The start and end dates for a person's current economic relationship to a job.")
        protected Period effective;
        private static final long serialVersionUID = -6533436L;

        public OccupationalDataEmploymentStatusComponent() {
        }

        public OccupationalDataEmploymentStatusComponent(CodeableConcept code, Period effective) {
            this.code = code;
            this.effective = effective;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OccupationalDataEmploymentStatusComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public OccupationalDataEmploymentStatusComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public Period getEffective() {
            if (this.effective == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OccupationalDataEmploymentStatusComponent.effective");
                }
                if (Configuration.doAutoCreate()) {
                    this.effective = new Period();
                }
            }
            return this.effective;
        }

        public boolean hasEffective() {
            return this.effective != null && !this.effective.isEmpty();
        }

        public OccupationalDataEmploymentStatusComponent setEffective(Period value) {
            this.effective = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "CodeableConcept", "A code that represents a person's current economic relationship to a job.", 0, 1, this.code));
            children.add(new Property("effective", "Period", "The start and end dates for a person's current economic relationship to a job.", 0, 1, this.effective));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "CodeableConcept", "A code that represents a person's current economic relationship to a job.", 0, 1, this.code);
                }
                case -1468651097: {
                    return new Property("effective", "Period", "The start and end dates for a person's current economic relationship to a job.", 0, 1, this.effective);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case -1468651097: {
                    Base[] baseArray;
                    if (this.effective == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.effective;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = this.castToCodeableConcept(value);
                    return value;
                }
                case -1468651097: {
                    this.effective = this.castToPeriod(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = this.castToCodeableConcept(value);
            } else if (name.equals("effective")) {
                this.effective = this.castToPeriod(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case -1468651097: {
                    return this.getEffective();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case -1468651097: {
                    return new String[]{"Period"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("effective")) {
                this.effective = new Period();
                return this.effective;
            }
            return super.addChild(name);
        }

        @Override
        public OccupationalDataEmploymentStatusComponent copy() {
            OccupationalDataEmploymentStatusComponent dst = new OccupationalDataEmploymentStatusComponent();
            this.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.effective = this.effective == null ? null : this.effective.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof OccupationalDataEmploymentStatusComponent)) {
                return false;
            }
            OccupationalDataEmploymentStatusComponent o = (OccupationalDataEmploymentStatusComponent)other_;
            return OccupationalDataEmploymentStatusComponent.compareDeep(this.code, o.code, true) && OccupationalDataEmploymentStatusComponent.compareDeep(this.effective, o.effective, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof OccupationalDataEmploymentStatusComponent)) {
                return false;
            }
            OccupationalDataEmploymentStatusComponent o = (OccupationalDataEmploymentStatusComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.code, this.effective});
        }

        @Override
        public String fhirType() {
            return "OccupationalData.employmentStatus";
        }
    }
}

