/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.MarketingStatus;
import org.hl7.fhir.r4.model.MedicinalProductDeviceSpec;
import org.hl7.fhir.r4.model.MedicinalProductIngredient;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.ProdCharacteristic;
import org.hl7.fhir.r4.model.ProductShelfLife;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="MedicinalProductPackaged", profile="http://hl7.org/fhir/Profile/MedicinalProductPackaged")
public class MedicinalProductPackaged
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Unique identifier", formalDefinition="Unique identifier.")
    protected Identifier identifier;
    @Child(name="description", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Textual description", formalDefinition="Textual description.")
    protected StringType description;
    @Child(name="marketingStatus", type={MarketingStatus.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Marketing information", formalDefinition="Marketing information.")
    protected List<MarketingStatus> marketingStatus;
    @Child(name="batchIdentifier", type={}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Batch numbering", formalDefinition="Batch numbering.")
    protected List<MedicinalProductPackagedBatchIdentifierComponent> batchIdentifier;
    @Child(name="packageItem", type={}, order=4, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A packaging item, as a contained for medicine, possibly with other packaging items within", formalDefinition="A packaging item, as a contained for medicine, possibly with other packaging items within.")
    protected List<MedicinalProductPackagedPackageItemComponent> packageItem;
    private static final long serialVersionUID = -934778857L;

    public MedicinalProductPackaged() {
    }

    public MedicinalProductPackaged(Identifier identifier) {
        this.identifier = identifier;
    }

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductPackaged.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public MedicinalProductPackaged setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductPackaged.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public MedicinalProductPackaged setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public MedicinalProductPackaged setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<MarketingStatus> getMarketingStatus() {
        if (this.marketingStatus == null) {
            this.marketingStatus = new ArrayList<MarketingStatus>();
        }
        return this.marketingStatus;
    }

    public MedicinalProductPackaged setMarketingStatus(List<MarketingStatus> theMarketingStatus) {
        this.marketingStatus = theMarketingStatus;
        return this;
    }

    public boolean hasMarketingStatus() {
        if (this.marketingStatus == null) {
            return false;
        }
        for (MarketingStatus item : this.marketingStatus) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MarketingStatus addMarketingStatus() {
        MarketingStatus t = new MarketingStatus();
        if (this.marketingStatus == null) {
            this.marketingStatus = new ArrayList<MarketingStatus>();
        }
        this.marketingStatus.add(t);
        return t;
    }

    public MedicinalProductPackaged addMarketingStatus(MarketingStatus t) {
        if (t == null) {
            return this;
        }
        if (this.marketingStatus == null) {
            this.marketingStatus = new ArrayList<MarketingStatus>();
        }
        this.marketingStatus.add(t);
        return this;
    }

    public MarketingStatus getMarketingStatusFirstRep() {
        if (this.getMarketingStatus().isEmpty()) {
            this.addMarketingStatus();
        }
        return this.getMarketingStatus().get(0);
    }

    public List<MedicinalProductPackagedBatchIdentifierComponent> getBatchIdentifier() {
        if (this.batchIdentifier == null) {
            this.batchIdentifier = new ArrayList<MedicinalProductPackagedBatchIdentifierComponent>();
        }
        return this.batchIdentifier;
    }

    public MedicinalProductPackaged setBatchIdentifier(List<MedicinalProductPackagedBatchIdentifierComponent> theBatchIdentifier) {
        this.batchIdentifier = theBatchIdentifier;
        return this;
    }

    public boolean hasBatchIdentifier() {
        if (this.batchIdentifier == null) {
            return false;
        }
        for (MedicinalProductPackagedBatchIdentifierComponent item : this.batchIdentifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicinalProductPackagedBatchIdentifierComponent addBatchIdentifier() {
        MedicinalProductPackagedBatchIdentifierComponent t = new MedicinalProductPackagedBatchIdentifierComponent();
        if (this.batchIdentifier == null) {
            this.batchIdentifier = new ArrayList<MedicinalProductPackagedBatchIdentifierComponent>();
        }
        this.batchIdentifier.add(t);
        return t;
    }

    public MedicinalProductPackaged addBatchIdentifier(MedicinalProductPackagedBatchIdentifierComponent t) {
        if (t == null) {
            return this;
        }
        if (this.batchIdentifier == null) {
            this.batchIdentifier = new ArrayList<MedicinalProductPackagedBatchIdentifierComponent>();
        }
        this.batchIdentifier.add(t);
        return this;
    }

    public MedicinalProductPackagedBatchIdentifierComponent getBatchIdentifierFirstRep() {
        if (this.getBatchIdentifier().isEmpty()) {
            this.addBatchIdentifier();
        }
        return this.getBatchIdentifier().get(0);
    }

    public List<MedicinalProductPackagedPackageItemComponent> getPackageItem() {
        if (this.packageItem == null) {
            this.packageItem = new ArrayList<MedicinalProductPackagedPackageItemComponent>();
        }
        return this.packageItem;
    }

    public MedicinalProductPackaged setPackageItem(List<MedicinalProductPackagedPackageItemComponent> thePackageItem) {
        this.packageItem = thePackageItem;
        return this;
    }

    public boolean hasPackageItem() {
        if (this.packageItem == null) {
            return false;
        }
        for (MedicinalProductPackagedPackageItemComponent item : this.packageItem) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicinalProductPackagedPackageItemComponent addPackageItem() {
        MedicinalProductPackagedPackageItemComponent t = new MedicinalProductPackagedPackageItemComponent();
        if (this.packageItem == null) {
            this.packageItem = new ArrayList<MedicinalProductPackagedPackageItemComponent>();
        }
        this.packageItem.add(t);
        return t;
    }

    public MedicinalProductPackaged addPackageItem(MedicinalProductPackagedPackageItemComponent t) {
        if (t == null) {
            return this;
        }
        if (this.packageItem == null) {
            this.packageItem = new ArrayList<MedicinalProductPackagedPackageItemComponent>();
        }
        this.packageItem.add(t);
        return this;
    }

    public MedicinalProductPackagedPackageItemComponent getPackageItemFirstRep() {
        if (this.getPackageItem().isEmpty()) {
            this.addPackageItem();
        }
        return this.getPackageItem().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("identifier", "Identifier", "Unique identifier.", 0, 1, this.identifier));
        children.add(new Property("description", "string", "Textual description.", 0, 1, this.description));
        children.add(new Property("marketingStatus", "MarketingStatus", "Marketing information.", 0, Integer.MAX_VALUE, this.marketingStatus));
        children.add(new Property("batchIdentifier", "", "Batch numbering.", 0, Integer.MAX_VALUE, this.batchIdentifier));
        children.add(new Property("packageItem", "", "A packaging item, as a contained for medicine, possibly with other packaging items within.", 0, Integer.MAX_VALUE, this.packageItem));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property("identifier", "Identifier", "Unique identifier.", 0, 1, this.identifier);
            }
            case -1724546052: {
                return new Property("description", "string", "Textual description.", 0, 1, this.description);
            }
            case 70767032: {
                return new Property("marketingStatus", "MarketingStatus", "Marketing information.", 0, Integer.MAX_VALUE, this.marketingStatus);
            }
            case -1688395901: {
                return new Property("batchIdentifier", "", "Batch numbering.", 0, Integer.MAX_VALUE, this.batchIdentifier);
            }
            case 908628089: {
                return new Property("packageItem", "", "A packaging item, as a contained for medicine, possibly with other packaging items within.", 0, Integer.MAX_VALUE, this.packageItem);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.identifier;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.description;
                }
                return baseArray;
            }
            case 70767032: {
                return this.marketingStatus == null ? new Base[]{} : this.marketingStatus.toArray(new Base[this.marketingStatus.size()]);
            }
            case -1688395901: {
                return this.batchIdentifier == null ? new Base[]{} : this.batchIdentifier.toArray(new Base[this.batchIdentifier.size()]);
            }
            case 908628089: {
                return this.packageItem == null ? new Base[]{} : this.packageItem.toArray(new Base[this.packageItem.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.identifier = this.castToIdentifier(value);
                return value;
            }
            case -1724546052: {
                this.description = this.castToString(value);
                return value;
            }
            case 70767032: {
                this.getMarketingStatus().add(this.castToMarketingStatus(value));
                return value;
            }
            case -1688395901: {
                this.getBatchIdentifier().add((MedicinalProductPackagedBatchIdentifierComponent)value);
                return value;
            }
            case 908628089: {
                this.getPackageItem().add((MedicinalProductPackagedPackageItemComponent)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("identifier")) {
            this.identifier = this.castToIdentifier(value);
        } else if (name.equals("description")) {
            this.description = this.castToString(value);
        } else if (name.equals("marketingStatus")) {
            this.getMarketingStatus().add(this.castToMarketingStatus(value));
        } else if (name.equals("batchIdentifier")) {
            this.getBatchIdentifier().add((MedicinalProductPackagedBatchIdentifierComponent)value);
        } else if (name.equals("packageItem")) {
            this.getPackageItem().add((MedicinalProductPackagedPackageItemComponent)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.getIdentifier();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case 70767032: {
                return this.addMarketingStatus();
            }
            case -1688395901: {
                return this.addBatchIdentifier();
            }
            case 908628089: {
                return this.addPackageItem();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -1724546052: {
                return new String[]{"string"};
            }
            case 70767032: {
                return new String[]{"MarketingStatus"};
            }
            case -1688395901: {
                return new String[0];
            }
            case 908628089: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("identifier")) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicinalProductPackaged.description");
        }
        if (name.equals("marketingStatus")) {
            return this.addMarketingStatus();
        }
        if (name.equals("batchIdentifier")) {
            return this.addBatchIdentifier();
        }
        if (name.equals("packageItem")) {
            return this.addPackageItem();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "MedicinalProductPackaged";
    }

    @Override
    public MedicinalProductPackaged copy() {
        MedicinalProductPackaged dst = new MedicinalProductPackaged();
        this.copyValues(dst);
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        StringType stringType = dst.description = this.description == null ? null : this.description.copy();
        if (this.marketingStatus != null) {
            dst.marketingStatus = new ArrayList<MarketingStatus>();
            for (MarketingStatus marketingStatus : this.marketingStatus) {
                dst.marketingStatus.add(marketingStatus.copy());
            }
        }
        if (this.batchIdentifier != null) {
            dst.batchIdentifier = new ArrayList<MedicinalProductPackagedBatchIdentifierComponent>();
            for (MedicinalProductPackagedBatchIdentifierComponent medicinalProductPackagedBatchIdentifierComponent : this.batchIdentifier) {
                dst.batchIdentifier.add(medicinalProductPackagedBatchIdentifierComponent.copy());
            }
        }
        if (this.packageItem != null) {
            dst.packageItem = new ArrayList<MedicinalProductPackagedPackageItemComponent>();
            for (MedicinalProductPackagedPackageItemComponent medicinalProductPackagedPackageItemComponent : this.packageItem) {
                dst.packageItem.add(medicinalProductPackagedPackageItemComponent.copy());
            }
        }
        return dst;
    }

    protected MedicinalProductPackaged typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicinalProductPackaged)) {
            return false;
        }
        MedicinalProductPackaged o = (MedicinalProductPackaged)other_;
        return MedicinalProductPackaged.compareDeep(this.identifier, o.identifier, true) && MedicinalProductPackaged.compareDeep(this.description, o.description, true) && MedicinalProductPackaged.compareDeep(this.marketingStatus, o.marketingStatus, true) && MedicinalProductPackaged.compareDeep(this.batchIdentifier, o.batchIdentifier, true) && MedicinalProductPackaged.compareDeep(this.packageItem, o.packageItem, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicinalProductPackaged)) {
            return false;
        }
        MedicinalProductPackaged o = (MedicinalProductPackaged)other_;
        return MedicinalProductPackaged.compareValues(this.description, o.description, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.description, this.marketingStatus, this.batchIdentifier, this.packageItem});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.MedicinalProductPackaged;
    }

    @Block
    public static class MedicinalProductPackagedPackageItemManufacturedItemComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="manufacturedDoseForm", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Dose form as manufactured and before any transformation into the pharmaceutical product", formalDefinition="Dose form as manufactured and before any transformation into the pharmaceutical product.")
        protected CodeableConcept manufacturedDoseForm;
        @Child(name="unitOfPresentation", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The \u201creal world\u201d units in which the quantity of the manufactured item is described", formalDefinition="The \u201creal world\u201d units in which the quantity of the manufactured item is described.")
        protected CodeableConcept unitOfPresentation;
        @Child(name="quantity", type={Quantity.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The quantity or \"count number\" of the manufactured item", formalDefinition="The quantity or \"count number\" of the manufactured item.")
        protected Quantity quantity;
        @Child(name="xManufacturer", type={Organization.class}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Manufacturer of the item (Note that this should be named \"manufacturer\" but it currently causes technical issues)", formalDefinition="Manufacturer of the item (Note that this should be named \"manufacturer\" but it currently causes technical issues).")
        protected List<Reference> xManufacturer;
        protected List<Organization> xManufacturerTarget;
        @Child(name="ingredient", type={MedicinalProductIngredient.class}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Ingredient", formalDefinition="Ingredient.")
        protected List<Reference> ingredient;
        protected List<MedicinalProductIngredient> ingredientTarget;
        @Child(name="physicalCharacteristics", type={ProdCharacteristic.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Dimensions, color etc.", formalDefinition="Dimensions, color etc.")
        protected ProdCharacteristic physicalCharacteristics;
        private static final long serialVersionUID = 54400069L;

        public MedicinalProductPackagedPackageItemManufacturedItemComponent() {
        }

        public MedicinalProductPackagedPackageItemManufacturedItemComponent(CodeableConcept manufacturedDoseForm, Quantity quantity) {
            this.manufacturedDoseForm = manufacturedDoseForm;
            this.quantity = quantity;
        }

        public CodeableConcept getManufacturedDoseForm() {
            if (this.manufacturedDoseForm == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductPackagedPackageItemManufacturedItemComponent.manufacturedDoseForm");
                }
                if (Configuration.doAutoCreate()) {
                    this.manufacturedDoseForm = new CodeableConcept();
                }
            }
            return this.manufacturedDoseForm;
        }

        public boolean hasManufacturedDoseForm() {
            return this.manufacturedDoseForm != null && !this.manufacturedDoseForm.isEmpty();
        }

        public MedicinalProductPackagedPackageItemManufacturedItemComponent setManufacturedDoseForm(CodeableConcept value) {
            this.manufacturedDoseForm = value;
            return this;
        }

        public CodeableConcept getUnitOfPresentation() {
            if (this.unitOfPresentation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductPackagedPackageItemManufacturedItemComponent.unitOfPresentation");
                }
                if (Configuration.doAutoCreate()) {
                    this.unitOfPresentation = new CodeableConcept();
                }
            }
            return this.unitOfPresentation;
        }

        public boolean hasUnitOfPresentation() {
            return this.unitOfPresentation != null && !this.unitOfPresentation.isEmpty();
        }

        public MedicinalProductPackagedPackageItemManufacturedItemComponent setUnitOfPresentation(CodeableConcept value) {
            this.unitOfPresentation = value;
            return this;
        }

        public Quantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductPackagedPackageItemManufacturedItemComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new Quantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public MedicinalProductPackagedPackageItemManufacturedItemComponent setQuantity(Quantity value) {
            this.quantity = value;
            return this;
        }

        public List<Reference> getXManufacturer() {
            if (this.xManufacturer == null) {
                this.xManufacturer = new ArrayList<Reference>();
            }
            return this.xManufacturer;
        }

        public MedicinalProductPackagedPackageItemManufacturedItemComponent setXManufacturer(List<Reference> theXManufacturer) {
            this.xManufacturer = theXManufacturer;
            return this;
        }

        public boolean hasXManufacturer() {
            if (this.xManufacturer == null) {
                return false;
            }
            for (Reference item : this.xManufacturer) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addXManufacturer() {
            Reference t = new Reference();
            if (this.xManufacturer == null) {
                this.xManufacturer = new ArrayList<Reference>();
            }
            this.xManufacturer.add(t);
            return t;
        }

        public MedicinalProductPackagedPackageItemManufacturedItemComponent addXManufacturer(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.xManufacturer == null) {
                this.xManufacturer = new ArrayList<Reference>();
            }
            this.xManufacturer.add(t);
            return this;
        }

        public Reference getXManufacturerFirstRep() {
            if (this.getXManufacturer().isEmpty()) {
                this.addXManufacturer();
            }
            return this.getXManufacturer().get(0);
        }

        @Deprecated
        public List<Organization> getXManufacturerTarget() {
            if (this.xManufacturerTarget == null) {
                this.xManufacturerTarget = new ArrayList<Organization>();
            }
            return this.xManufacturerTarget;
        }

        @Deprecated
        public Organization addXManufacturerTarget() {
            Organization r = new Organization();
            if (this.xManufacturerTarget == null) {
                this.xManufacturerTarget = new ArrayList<Organization>();
            }
            this.xManufacturerTarget.add(r);
            return r;
        }

        public List<Reference> getIngredient() {
            if (this.ingredient == null) {
                this.ingredient = new ArrayList<Reference>();
            }
            return this.ingredient;
        }

        public MedicinalProductPackagedPackageItemManufacturedItemComponent setIngredient(List<Reference> theIngredient) {
            this.ingredient = theIngredient;
            return this;
        }

        public boolean hasIngredient() {
            if (this.ingredient == null) {
                return false;
            }
            for (Reference item : this.ingredient) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addIngredient() {
            Reference t = new Reference();
            if (this.ingredient == null) {
                this.ingredient = new ArrayList<Reference>();
            }
            this.ingredient.add(t);
            return t;
        }

        public MedicinalProductPackagedPackageItemManufacturedItemComponent addIngredient(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.ingredient == null) {
                this.ingredient = new ArrayList<Reference>();
            }
            this.ingredient.add(t);
            return this;
        }

        public Reference getIngredientFirstRep() {
            if (this.getIngredient().isEmpty()) {
                this.addIngredient();
            }
            return this.getIngredient().get(0);
        }

        @Deprecated
        public List<MedicinalProductIngredient> getIngredientTarget() {
            if (this.ingredientTarget == null) {
                this.ingredientTarget = new ArrayList<MedicinalProductIngredient>();
            }
            return this.ingredientTarget;
        }

        @Deprecated
        public MedicinalProductIngredient addIngredientTarget() {
            MedicinalProductIngredient r = new MedicinalProductIngredient();
            if (this.ingredientTarget == null) {
                this.ingredientTarget = new ArrayList<MedicinalProductIngredient>();
            }
            this.ingredientTarget.add(r);
            return r;
        }

        public ProdCharacteristic getPhysicalCharacteristics() {
            if (this.physicalCharacteristics == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductPackagedPackageItemManufacturedItemComponent.physicalCharacteristics");
                }
                if (Configuration.doAutoCreate()) {
                    this.physicalCharacteristics = new ProdCharacteristic();
                }
            }
            return this.physicalCharacteristics;
        }

        public boolean hasPhysicalCharacteristics() {
            return this.physicalCharacteristics != null && !this.physicalCharacteristics.isEmpty();
        }

        public MedicinalProductPackagedPackageItemManufacturedItemComponent setPhysicalCharacteristics(ProdCharacteristic value) {
            this.physicalCharacteristics = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("manufacturedDoseForm", "CodeableConcept", "Dose form as manufactured and before any transformation into the pharmaceutical product.", 0, 1, this.manufacturedDoseForm));
            children.add(new Property("unitOfPresentation", "CodeableConcept", "The \u201creal world\u201d units in which the quantity of the manufactured item is described.", 0, 1, this.unitOfPresentation));
            children.add(new Property("quantity", "Quantity", "The quantity or \"count number\" of the manufactured item.", 0, 1, this.quantity));
            children.add(new Property("xManufacturer", "Reference(Organization)", "Manufacturer of the item (Note that this should be named \"manufacturer\" but it currently causes technical issues).", 0, Integer.MAX_VALUE, this.xManufacturer));
            children.add(new Property("ingredient", "Reference(MedicinalProductIngredient)", "Ingredient.", 0, Integer.MAX_VALUE, this.ingredient));
            children.add(new Property("physicalCharacteristics", "ProdCharacteristic", "Dimensions, color etc.", 0, 1, this.physicalCharacteristics));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1451400348: {
                    return new Property("manufacturedDoseForm", "CodeableConcept", "Dose form as manufactured and before any transformation into the pharmaceutical product.", 0, 1, this.manufacturedDoseForm);
                }
                case -1427765963: {
                    return new Property("unitOfPresentation", "CodeableConcept", "The \u201creal world\u201d units in which the quantity of the manufactured item is described.", 0, 1, this.unitOfPresentation);
                }
                case -1285004149: {
                    return new Property("quantity", "Quantity", "The quantity or \"count number\" of the manufactured item.", 0, 1, this.quantity);
                }
                case 1641317481: {
                    return new Property("xManufacturer", "Reference(Organization)", "Manufacturer of the item (Note that this should be named \"manufacturer\" but it currently causes technical issues).", 0, Integer.MAX_VALUE, this.xManufacturer);
                }
                case -206409263: {
                    return new Property("ingredient", "Reference(MedicinalProductIngredient)", "Ingredient.", 0, Integer.MAX_VALUE, this.ingredient);
                }
                case -1599676319: {
                    return new Property("physicalCharacteristics", "ProdCharacteristic", "Dimensions, color etc.", 0, 1, this.physicalCharacteristics);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1451400348: {
                    Base[] baseArray;
                    if (this.manufacturedDoseForm == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.manufacturedDoseForm;
                    }
                    return baseArray;
                }
                case -1427765963: {
                    Base[] baseArray;
                    if (this.unitOfPresentation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.unitOfPresentation;
                    }
                    return baseArray;
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.quantity;
                    }
                    return baseArray;
                }
                case 1641317481: {
                    return this.xManufacturer == null ? new Base[]{} : this.xManufacturer.toArray(new Base[this.xManufacturer.size()]);
                }
                case -206409263: {
                    return this.ingredient == null ? new Base[]{} : this.ingredient.toArray(new Base[this.ingredient.size()]);
                }
                case -1599676319: {
                    Base[] baseArray;
                    if (this.physicalCharacteristics == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.physicalCharacteristics;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1451400348: {
                    this.manufacturedDoseForm = this.castToCodeableConcept(value);
                    return value;
                }
                case -1427765963: {
                    this.unitOfPresentation = this.castToCodeableConcept(value);
                    return value;
                }
                case -1285004149: {
                    this.quantity = this.castToQuantity(value);
                    return value;
                }
                case 1641317481: {
                    this.getXManufacturer().add(this.castToReference(value));
                    return value;
                }
                case -206409263: {
                    this.getIngredient().add(this.castToReference(value));
                    return value;
                }
                case -1599676319: {
                    this.physicalCharacteristics = this.castToProdCharacteristic(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("manufacturedDoseForm")) {
                this.manufacturedDoseForm = this.castToCodeableConcept(value);
            } else if (name.equals("unitOfPresentation")) {
                this.unitOfPresentation = this.castToCodeableConcept(value);
            } else if (name.equals("quantity")) {
                this.quantity = this.castToQuantity(value);
            } else if (name.equals("xManufacturer")) {
                this.getXManufacturer().add(this.castToReference(value));
            } else if (name.equals("ingredient")) {
                this.getIngredient().add(this.castToReference(value));
            } else if (name.equals("physicalCharacteristics")) {
                this.physicalCharacteristics = this.castToProdCharacteristic(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1451400348: {
                    return this.getManufacturedDoseForm();
                }
                case -1427765963: {
                    return this.getUnitOfPresentation();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case 1641317481: {
                    return this.addXManufacturer();
                }
                case -206409263: {
                    return this.addIngredient();
                }
                case -1599676319: {
                    return this.getPhysicalCharacteristics();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1451400348: {
                    return new String[]{"CodeableConcept"};
                }
                case -1427765963: {
                    return new String[]{"CodeableConcept"};
                }
                case -1285004149: {
                    return new String[]{"Quantity"};
                }
                case 1641317481: {
                    return new String[]{"Reference"};
                }
                case -206409263: {
                    return new String[]{"Reference"};
                }
                case -1599676319: {
                    return new String[]{"ProdCharacteristic"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("manufacturedDoseForm")) {
                this.manufacturedDoseForm = new CodeableConcept();
                return this.manufacturedDoseForm;
            }
            if (name.equals("unitOfPresentation")) {
                this.unitOfPresentation = new CodeableConcept();
                return this.unitOfPresentation;
            }
            if (name.equals("quantity")) {
                this.quantity = new Quantity();
                return this.quantity;
            }
            if (name.equals("xManufacturer")) {
                return this.addXManufacturer();
            }
            if (name.equals("ingredient")) {
                return this.addIngredient();
            }
            if (name.equals("physicalCharacteristics")) {
                this.physicalCharacteristics = new ProdCharacteristic();
                return this.physicalCharacteristics;
            }
            return super.addChild(name);
        }

        @Override
        public MedicinalProductPackagedPackageItemManufacturedItemComponent copy() {
            MedicinalProductPackagedPackageItemManufacturedItemComponent dst = new MedicinalProductPackagedPackageItemManufacturedItemComponent();
            this.copyValues(dst);
            dst.manufacturedDoseForm = this.manufacturedDoseForm == null ? null : this.manufacturedDoseForm.copy();
            dst.unitOfPresentation = this.unitOfPresentation == null ? null : this.unitOfPresentation.copy();
            Quantity quantity = dst.quantity = this.quantity == null ? null : this.quantity.copy();
            if (this.xManufacturer != null) {
                dst.xManufacturer = new ArrayList<Reference>();
                for (Reference i : this.xManufacturer) {
                    dst.xManufacturer.add(i.copy());
                }
            }
            if (this.ingredient != null) {
                dst.ingredient = new ArrayList<Reference>();
                for (Reference i : this.ingredient) {
                    dst.ingredient.add(i.copy());
                }
            }
            dst.physicalCharacteristics = this.physicalCharacteristics == null ? null : this.physicalCharacteristics.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductPackagedPackageItemManufacturedItemComponent)) {
                return false;
            }
            MedicinalProductPackagedPackageItemManufacturedItemComponent o = (MedicinalProductPackagedPackageItemManufacturedItemComponent)other_;
            return MedicinalProductPackagedPackageItemManufacturedItemComponent.compareDeep(this.manufacturedDoseForm, o.manufacturedDoseForm, true) && MedicinalProductPackagedPackageItemManufacturedItemComponent.compareDeep(this.unitOfPresentation, o.unitOfPresentation, true) && MedicinalProductPackagedPackageItemManufacturedItemComponent.compareDeep(this.quantity, o.quantity, true) && MedicinalProductPackagedPackageItemManufacturedItemComponent.compareDeep(this.xManufacturer, o.xManufacturer, true) && MedicinalProductPackagedPackageItemManufacturedItemComponent.compareDeep(this.ingredient, o.ingredient, true) && MedicinalProductPackagedPackageItemManufacturedItemComponent.compareDeep(this.physicalCharacteristics, o.physicalCharacteristics, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductPackagedPackageItemManufacturedItemComponent)) {
                return false;
            }
            MedicinalProductPackagedPackageItemManufacturedItemComponent o = (MedicinalProductPackagedPackageItemManufacturedItemComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.manufacturedDoseForm, this.unitOfPresentation, this.quantity, this.xManufacturer, this.ingredient, this.physicalCharacteristics});
        }

        @Override
        public String fhirType() {
            return "MedicinalProductPackaged.packageItem.manufacturedItem";
        }
    }

    @Block
    public static class MedicinalProductPackagedPackageItemComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Including possibly Data Carrier Identifier", formalDefinition="Including possibly Data Carrier Identifier.")
        protected List<Identifier> identifier;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The physical type of the container of the medicine", formalDefinition="The physical type of the container of the medicine.")
        protected CodeableConcept type;
        @Child(name="quantity", type={Quantity.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The quantity of this package in the medicinal product, at the current level of packaging. The outermost is always 1", formalDefinition="The quantity of this package in the medicinal product, at the current level of packaging. The outermost is always 1.")
        protected Quantity quantity;
        @Child(name="material", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Material type of the package item", formalDefinition="Material type of the package item.")
        protected List<CodeableConcept> material;
        @Child(name="alternateMaterial", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="A possible alternate material for the packaging", formalDefinition="A possible alternate material for the packaging.")
        protected List<CodeableConcept> alternateMaterial;
        @Child(name="manufacturer", type={Organization.class}, order=6, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Manufacturer of this Package Item", formalDefinition="Manufacturer of this Package Item.")
        protected List<Reference> manufacturer;
        protected List<Organization> manufacturerTarget;
        @Child(name="device", type={MedicinalProductDeviceSpec.class}, order=7, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="A device accompanying a medicinal product", formalDefinition="A device accompanying a medicinal product.")
        protected List<Reference> device;
        protected List<MedicinalProductDeviceSpec> deviceTarget;
        @Child(name="manufacturedItem", type={}, order=8, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The manufactured item as contained in the packaged medicinal product", formalDefinition="The manufactured item as contained in the packaged medicinal product.")
        protected List<MedicinalProductPackagedPackageItemManufacturedItemComponent> manufacturedItem;
        @Child(name="otherCharacteristics", type={CodeableConcept.class}, order=9, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Other codeable characteristics", formalDefinition="Other codeable characteristics.")
        protected List<CodeableConcept> otherCharacteristics;
        @Child(name="packageItem", type={MedicinalProductPackagedPackageItemComponent.class}, order=10, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Allows containers within containers", formalDefinition="Allows containers within containers.")
        protected List<MedicinalProductPackagedPackageItemComponent> packageItem;
        @Child(name="physicalCharacteristics", type={ProdCharacteristic.class}, order=11, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Dimensions, color etc.", formalDefinition="Dimensions, color etc.")
        protected ProdCharacteristic physicalCharacteristics;
        @Child(name="shelfLifeStorage", type={ProductShelfLife.class}, order=12, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Shelf Life and storage information", formalDefinition="Shelf Life and storage information.")
        protected List<ProductShelfLife> shelfLifeStorage;
        private static final long serialVersionUID = -1046468533L;

        public MedicinalProductPackagedPackageItemComponent() {
        }

        public MedicinalProductPackagedPackageItemComponent(CodeableConcept type, Quantity quantity) {
            this.type = type;
            this.quantity = quantity;
        }

        public List<Identifier> getIdentifier() {
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            return this.identifier;
        }

        public MedicinalProductPackagedPackageItemComponent setIdentifier(List<Identifier> theIdentifier) {
            this.identifier = theIdentifier;
            return this;
        }

        public boolean hasIdentifier() {
            if (this.identifier == null) {
                return false;
            }
            for (Identifier item : this.identifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Identifier addIdentifier() {
            Identifier t = new Identifier();
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return t;
        }

        public MedicinalProductPackagedPackageItemComponent addIdentifier(Identifier t) {
            if (t == null) {
                return this;
            }
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return this;
        }

        public Identifier getIdentifierFirstRep() {
            if (this.getIdentifier().isEmpty()) {
                this.addIdentifier();
            }
            return this.getIdentifier().get(0);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductPackagedPackageItemComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicinalProductPackagedPackageItemComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Quantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductPackagedPackageItemComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new Quantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public MedicinalProductPackagedPackageItemComponent setQuantity(Quantity value) {
            this.quantity = value;
            return this;
        }

        public List<CodeableConcept> getMaterial() {
            if (this.material == null) {
                this.material = new ArrayList<CodeableConcept>();
            }
            return this.material;
        }

        public MedicinalProductPackagedPackageItemComponent setMaterial(List<CodeableConcept> theMaterial) {
            this.material = theMaterial;
            return this;
        }

        public boolean hasMaterial() {
            if (this.material == null) {
                return false;
            }
            for (CodeableConcept item : this.material) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addMaterial() {
            CodeableConcept t = new CodeableConcept();
            if (this.material == null) {
                this.material = new ArrayList<CodeableConcept>();
            }
            this.material.add(t);
            return t;
        }

        public MedicinalProductPackagedPackageItemComponent addMaterial(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.material == null) {
                this.material = new ArrayList<CodeableConcept>();
            }
            this.material.add(t);
            return this;
        }

        public CodeableConcept getMaterialFirstRep() {
            if (this.getMaterial().isEmpty()) {
                this.addMaterial();
            }
            return this.getMaterial().get(0);
        }

        public List<CodeableConcept> getAlternateMaterial() {
            if (this.alternateMaterial == null) {
                this.alternateMaterial = new ArrayList<CodeableConcept>();
            }
            return this.alternateMaterial;
        }

        public MedicinalProductPackagedPackageItemComponent setAlternateMaterial(List<CodeableConcept> theAlternateMaterial) {
            this.alternateMaterial = theAlternateMaterial;
            return this;
        }

        public boolean hasAlternateMaterial() {
            if (this.alternateMaterial == null) {
                return false;
            }
            for (CodeableConcept item : this.alternateMaterial) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addAlternateMaterial() {
            CodeableConcept t = new CodeableConcept();
            if (this.alternateMaterial == null) {
                this.alternateMaterial = new ArrayList<CodeableConcept>();
            }
            this.alternateMaterial.add(t);
            return t;
        }

        public MedicinalProductPackagedPackageItemComponent addAlternateMaterial(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.alternateMaterial == null) {
                this.alternateMaterial = new ArrayList<CodeableConcept>();
            }
            this.alternateMaterial.add(t);
            return this;
        }

        public CodeableConcept getAlternateMaterialFirstRep() {
            if (this.getAlternateMaterial().isEmpty()) {
                this.addAlternateMaterial();
            }
            return this.getAlternateMaterial().get(0);
        }

        public List<Reference> getManufacturer() {
            if (this.manufacturer == null) {
                this.manufacturer = new ArrayList<Reference>();
            }
            return this.manufacturer;
        }

        public MedicinalProductPackagedPackageItemComponent setManufacturer(List<Reference> theManufacturer) {
            this.manufacturer = theManufacturer;
            return this;
        }

        public boolean hasManufacturer() {
            if (this.manufacturer == null) {
                return false;
            }
            for (Reference item : this.manufacturer) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addManufacturer() {
            Reference t = new Reference();
            if (this.manufacturer == null) {
                this.manufacturer = new ArrayList<Reference>();
            }
            this.manufacturer.add(t);
            return t;
        }

        public MedicinalProductPackagedPackageItemComponent addManufacturer(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.manufacturer == null) {
                this.manufacturer = new ArrayList<Reference>();
            }
            this.manufacturer.add(t);
            return this;
        }

        public Reference getManufacturerFirstRep() {
            if (this.getManufacturer().isEmpty()) {
                this.addManufacturer();
            }
            return this.getManufacturer().get(0);
        }

        @Deprecated
        public List<Organization> getManufacturerTarget() {
            if (this.manufacturerTarget == null) {
                this.manufacturerTarget = new ArrayList<Organization>();
            }
            return this.manufacturerTarget;
        }

        @Deprecated
        public Organization addManufacturerTarget() {
            Organization r = new Organization();
            if (this.manufacturerTarget == null) {
                this.manufacturerTarget = new ArrayList<Organization>();
            }
            this.manufacturerTarget.add(r);
            return r;
        }

        public List<Reference> getDevice() {
            if (this.device == null) {
                this.device = new ArrayList<Reference>();
            }
            return this.device;
        }

        public MedicinalProductPackagedPackageItemComponent setDevice(List<Reference> theDevice) {
            this.device = theDevice;
            return this;
        }

        public boolean hasDevice() {
            if (this.device == null) {
                return false;
            }
            for (Reference item : this.device) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addDevice() {
            Reference t = new Reference();
            if (this.device == null) {
                this.device = new ArrayList<Reference>();
            }
            this.device.add(t);
            return t;
        }

        public MedicinalProductPackagedPackageItemComponent addDevice(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.device == null) {
                this.device = new ArrayList<Reference>();
            }
            this.device.add(t);
            return this;
        }

        public Reference getDeviceFirstRep() {
            if (this.getDevice().isEmpty()) {
                this.addDevice();
            }
            return this.getDevice().get(0);
        }

        @Deprecated
        public List<MedicinalProductDeviceSpec> getDeviceTarget() {
            if (this.deviceTarget == null) {
                this.deviceTarget = new ArrayList<MedicinalProductDeviceSpec>();
            }
            return this.deviceTarget;
        }

        @Deprecated
        public MedicinalProductDeviceSpec addDeviceTarget() {
            MedicinalProductDeviceSpec r = new MedicinalProductDeviceSpec();
            if (this.deviceTarget == null) {
                this.deviceTarget = new ArrayList<MedicinalProductDeviceSpec>();
            }
            this.deviceTarget.add(r);
            return r;
        }

        public List<MedicinalProductPackagedPackageItemManufacturedItemComponent> getManufacturedItem() {
            if (this.manufacturedItem == null) {
                this.manufacturedItem = new ArrayList<MedicinalProductPackagedPackageItemManufacturedItemComponent>();
            }
            return this.manufacturedItem;
        }

        public MedicinalProductPackagedPackageItemComponent setManufacturedItem(List<MedicinalProductPackagedPackageItemManufacturedItemComponent> theManufacturedItem) {
            this.manufacturedItem = theManufacturedItem;
            return this;
        }

        public boolean hasManufacturedItem() {
            if (this.manufacturedItem == null) {
                return false;
            }
            for (MedicinalProductPackagedPackageItemManufacturedItemComponent item : this.manufacturedItem) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MedicinalProductPackagedPackageItemManufacturedItemComponent addManufacturedItem() {
            MedicinalProductPackagedPackageItemManufacturedItemComponent t = new MedicinalProductPackagedPackageItemManufacturedItemComponent();
            if (this.manufacturedItem == null) {
                this.manufacturedItem = new ArrayList<MedicinalProductPackagedPackageItemManufacturedItemComponent>();
            }
            this.manufacturedItem.add(t);
            return t;
        }

        public MedicinalProductPackagedPackageItemComponent addManufacturedItem(MedicinalProductPackagedPackageItemManufacturedItemComponent t) {
            if (t == null) {
                return this;
            }
            if (this.manufacturedItem == null) {
                this.manufacturedItem = new ArrayList<MedicinalProductPackagedPackageItemManufacturedItemComponent>();
            }
            this.manufacturedItem.add(t);
            return this;
        }

        public MedicinalProductPackagedPackageItemManufacturedItemComponent getManufacturedItemFirstRep() {
            if (this.getManufacturedItem().isEmpty()) {
                this.addManufacturedItem();
            }
            return this.getManufacturedItem().get(0);
        }

        public List<CodeableConcept> getOtherCharacteristics() {
            if (this.otherCharacteristics == null) {
                this.otherCharacteristics = new ArrayList<CodeableConcept>();
            }
            return this.otherCharacteristics;
        }

        public MedicinalProductPackagedPackageItemComponent setOtherCharacteristics(List<CodeableConcept> theOtherCharacteristics) {
            this.otherCharacteristics = theOtherCharacteristics;
            return this;
        }

        public boolean hasOtherCharacteristics() {
            if (this.otherCharacteristics == null) {
                return false;
            }
            for (CodeableConcept item : this.otherCharacteristics) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addOtherCharacteristics() {
            CodeableConcept t = new CodeableConcept();
            if (this.otherCharacteristics == null) {
                this.otherCharacteristics = new ArrayList<CodeableConcept>();
            }
            this.otherCharacteristics.add(t);
            return t;
        }

        public MedicinalProductPackagedPackageItemComponent addOtherCharacteristics(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.otherCharacteristics == null) {
                this.otherCharacteristics = new ArrayList<CodeableConcept>();
            }
            this.otherCharacteristics.add(t);
            return this;
        }

        public CodeableConcept getOtherCharacteristicsFirstRep() {
            if (this.getOtherCharacteristics().isEmpty()) {
                this.addOtherCharacteristics();
            }
            return this.getOtherCharacteristics().get(0);
        }

        public List<MedicinalProductPackagedPackageItemComponent> getPackageItem() {
            if (this.packageItem == null) {
                this.packageItem = new ArrayList<MedicinalProductPackagedPackageItemComponent>();
            }
            return this.packageItem;
        }

        public MedicinalProductPackagedPackageItemComponent setPackageItem(List<MedicinalProductPackagedPackageItemComponent> thePackageItem) {
            this.packageItem = thePackageItem;
            return this;
        }

        public boolean hasPackageItem() {
            if (this.packageItem == null) {
                return false;
            }
            for (MedicinalProductPackagedPackageItemComponent item : this.packageItem) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MedicinalProductPackagedPackageItemComponent addPackageItem() {
            MedicinalProductPackagedPackageItemComponent t = new MedicinalProductPackagedPackageItemComponent();
            if (this.packageItem == null) {
                this.packageItem = new ArrayList<MedicinalProductPackagedPackageItemComponent>();
            }
            this.packageItem.add(t);
            return t;
        }

        public MedicinalProductPackagedPackageItemComponent addPackageItem(MedicinalProductPackagedPackageItemComponent t) {
            if (t == null) {
                return this;
            }
            if (this.packageItem == null) {
                this.packageItem = new ArrayList<MedicinalProductPackagedPackageItemComponent>();
            }
            this.packageItem.add(t);
            return this;
        }

        public MedicinalProductPackagedPackageItemComponent getPackageItemFirstRep() {
            if (this.getPackageItem().isEmpty()) {
                this.addPackageItem();
            }
            return this.getPackageItem().get(0);
        }

        public ProdCharacteristic getPhysicalCharacteristics() {
            if (this.physicalCharacteristics == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductPackagedPackageItemComponent.physicalCharacteristics");
                }
                if (Configuration.doAutoCreate()) {
                    this.physicalCharacteristics = new ProdCharacteristic();
                }
            }
            return this.physicalCharacteristics;
        }

        public boolean hasPhysicalCharacteristics() {
            return this.physicalCharacteristics != null && !this.physicalCharacteristics.isEmpty();
        }

        public MedicinalProductPackagedPackageItemComponent setPhysicalCharacteristics(ProdCharacteristic value) {
            this.physicalCharacteristics = value;
            return this;
        }

        public List<ProductShelfLife> getShelfLifeStorage() {
            if (this.shelfLifeStorage == null) {
                this.shelfLifeStorage = new ArrayList<ProductShelfLife>();
            }
            return this.shelfLifeStorage;
        }

        public MedicinalProductPackagedPackageItemComponent setShelfLifeStorage(List<ProductShelfLife> theShelfLifeStorage) {
            this.shelfLifeStorage = theShelfLifeStorage;
            return this;
        }

        public boolean hasShelfLifeStorage() {
            if (this.shelfLifeStorage == null) {
                return false;
            }
            for (ProductShelfLife item : this.shelfLifeStorage) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ProductShelfLife addShelfLifeStorage() {
            ProductShelfLife t = new ProductShelfLife();
            if (this.shelfLifeStorage == null) {
                this.shelfLifeStorage = new ArrayList<ProductShelfLife>();
            }
            this.shelfLifeStorage.add(t);
            return t;
        }

        public MedicinalProductPackagedPackageItemComponent addShelfLifeStorage(ProductShelfLife t) {
            if (t == null) {
                return this;
            }
            if (this.shelfLifeStorage == null) {
                this.shelfLifeStorage = new ArrayList<ProductShelfLife>();
            }
            this.shelfLifeStorage.add(t);
            return this;
        }

        public ProductShelfLife getShelfLifeStorageFirstRep() {
            if (this.getShelfLifeStorage().isEmpty()) {
                this.addShelfLifeStorage();
            }
            return this.getShelfLifeStorage().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("identifier", "Identifier", "Including possibly Data Carrier Identifier.", 0, Integer.MAX_VALUE, this.identifier));
            children.add(new Property("type", "CodeableConcept", "The physical type of the container of the medicine.", 0, 1, this.type));
            children.add(new Property("quantity", "Quantity", "The quantity of this package in the medicinal product, at the current level of packaging. The outermost is always 1.", 0, 1, this.quantity));
            children.add(new Property("material", "CodeableConcept", "Material type of the package item.", 0, Integer.MAX_VALUE, this.material));
            children.add(new Property("alternateMaterial", "CodeableConcept", "A possible alternate material for the packaging.", 0, Integer.MAX_VALUE, this.alternateMaterial));
            children.add(new Property("manufacturer", "Reference(Organization)", "Manufacturer of this Package Item.", 0, Integer.MAX_VALUE, this.manufacturer));
            children.add(new Property("device", "Reference(MedicinalProductDeviceSpec)", "A device accompanying a medicinal product.", 0, Integer.MAX_VALUE, this.device));
            children.add(new Property("manufacturedItem", "", "The manufactured item as contained in the packaged medicinal product.", 0, Integer.MAX_VALUE, this.manufacturedItem));
            children.add(new Property("otherCharacteristics", "CodeableConcept", "Other codeable characteristics.", 0, Integer.MAX_VALUE, this.otherCharacteristics));
            children.add(new Property("packageItem", "@MedicinalProductPackaged.packageItem", "Allows containers within containers.", 0, Integer.MAX_VALUE, this.packageItem));
            children.add(new Property("physicalCharacteristics", "ProdCharacteristic", "Dimensions, color etc.", 0, 1, this.physicalCharacteristics));
            children.add(new Property("shelfLifeStorage", "ProductShelfLife", "Shelf Life and storage information.", 0, Integer.MAX_VALUE, this.shelfLifeStorage));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1618432855: {
                    return new Property("identifier", "Identifier", "Including possibly Data Carrier Identifier.", 0, Integer.MAX_VALUE, this.identifier);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The physical type of the container of the medicine.", 0, 1, this.type);
                }
                case -1285004149: {
                    return new Property("quantity", "Quantity", "The quantity of this package in the medicinal product, at the current level of packaging. The outermost is always 1.", 0, 1, this.quantity);
                }
                case 299066663: {
                    return new Property("material", "CodeableConcept", "Material type of the package item.", 0, Integer.MAX_VALUE, this.material);
                }
                case -1021448255: {
                    return new Property("alternateMaterial", "CodeableConcept", "A possible alternate material for the packaging.", 0, Integer.MAX_VALUE, this.alternateMaterial);
                }
                case -1969347631: {
                    return new Property("manufacturer", "Reference(Organization)", "Manufacturer of this Package Item.", 0, Integer.MAX_VALUE, this.manufacturer);
                }
                case -1335157162: {
                    return new Property("device", "Reference(MedicinalProductDeviceSpec)", "A device accompanying a medicinal product.", 0, Integer.MAX_VALUE, this.device);
                }
                case 62093686: {
                    return new Property("manufacturedItem", "", "The manufactured item as contained in the packaged medicinal product.", 0, Integer.MAX_VALUE, this.manufacturedItem);
                }
                case 722135304: {
                    return new Property("otherCharacteristics", "CodeableConcept", "Other codeable characteristics.", 0, Integer.MAX_VALUE, this.otherCharacteristics);
                }
                case 908628089: {
                    return new Property("packageItem", "@MedicinalProductPackaged.packageItem", "Allows containers within containers.", 0, Integer.MAX_VALUE, this.packageItem);
                }
                case -1599676319: {
                    return new Property("physicalCharacteristics", "ProdCharacteristic", "Dimensions, color etc.", 0, 1, this.physicalCharacteristics);
                }
                case 172049237: {
                    return new Property("shelfLifeStorage", "ProductShelfLife", "Shelf Life and storage information.", 0, Integer.MAX_VALUE, this.shelfLifeStorage);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.quantity;
                    }
                    return baseArray;
                }
                case 299066663: {
                    return this.material == null ? new Base[]{} : this.material.toArray(new Base[this.material.size()]);
                }
                case -1021448255: {
                    return this.alternateMaterial == null ? new Base[]{} : this.alternateMaterial.toArray(new Base[this.alternateMaterial.size()]);
                }
                case -1969347631: {
                    return this.manufacturer == null ? new Base[]{} : this.manufacturer.toArray(new Base[this.manufacturer.size()]);
                }
                case -1335157162: {
                    return this.device == null ? new Base[]{} : this.device.toArray(new Base[this.device.size()]);
                }
                case 62093686: {
                    return this.manufacturedItem == null ? new Base[]{} : this.manufacturedItem.toArray(new Base[this.manufacturedItem.size()]);
                }
                case 722135304: {
                    return this.otherCharacteristics == null ? new Base[]{} : this.otherCharacteristics.toArray(new Base[this.otherCharacteristics.size()]);
                }
                case 908628089: {
                    return this.packageItem == null ? new Base[]{} : this.packageItem.toArray(new Base[this.packageItem.size()]);
                }
                case -1599676319: {
                    Base[] baseArray;
                    if (this.physicalCharacteristics == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.physicalCharacteristics;
                    }
                    return baseArray;
                }
                case 172049237: {
                    return this.shelfLifeStorage == null ? new Base[]{} : this.shelfLifeStorage.toArray(new Base[this.shelfLifeStorage.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    this.getIdentifier().add(this.castToIdentifier(value));
                    return value;
                }
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case -1285004149: {
                    this.quantity = this.castToQuantity(value);
                    return value;
                }
                case 299066663: {
                    this.getMaterial().add(this.castToCodeableConcept(value));
                    return value;
                }
                case -1021448255: {
                    this.getAlternateMaterial().add(this.castToCodeableConcept(value));
                    return value;
                }
                case -1969347631: {
                    this.getManufacturer().add(this.castToReference(value));
                    return value;
                }
                case -1335157162: {
                    this.getDevice().add(this.castToReference(value));
                    return value;
                }
                case 62093686: {
                    this.getManufacturedItem().add((MedicinalProductPackagedPackageItemManufacturedItemComponent)value);
                    return value;
                }
                case 722135304: {
                    this.getOtherCharacteristics().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 908628089: {
                    this.getPackageItem().add((MedicinalProductPackagedPackageItemComponent)value);
                    return value;
                }
                case -1599676319: {
                    this.physicalCharacteristics = this.castToProdCharacteristic(value);
                    return value;
                }
                case 172049237: {
                    this.getShelfLifeStorage().add(this.castToProductShelfLife(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("identifier")) {
                this.getIdentifier().add(this.castToIdentifier(value));
            } else if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("quantity")) {
                this.quantity = this.castToQuantity(value);
            } else if (name.equals("material")) {
                this.getMaterial().add(this.castToCodeableConcept(value));
            } else if (name.equals("alternateMaterial")) {
                this.getAlternateMaterial().add(this.castToCodeableConcept(value));
            } else if (name.equals("manufacturer")) {
                this.getManufacturer().add(this.castToReference(value));
            } else if (name.equals("device")) {
                this.getDevice().add(this.castToReference(value));
            } else if (name.equals("manufacturedItem")) {
                this.getManufacturedItem().add((MedicinalProductPackagedPackageItemManufacturedItemComponent)value);
            } else if (name.equals("otherCharacteristics")) {
                this.getOtherCharacteristics().add(this.castToCodeableConcept(value));
            } else if (name.equals("packageItem")) {
                this.getPackageItem().add((MedicinalProductPackagedPackageItemComponent)value);
            } else if (name.equals("physicalCharacteristics")) {
                this.physicalCharacteristics = this.castToProdCharacteristic(value);
            } else if (name.equals("shelfLifeStorage")) {
                this.getShelfLifeStorage().add(this.castToProductShelfLife(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.addIdentifier();
                }
                case 3575610: {
                    return this.getType();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case 299066663: {
                    return this.addMaterial();
                }
                case -1021448255: {
                    return this.addAlternateMaterial();
                }
                case -1969347631: {
                    return this.addManufacturer();
                }
                case -1335157162: {
                    return this.addDevice();
                }
                case 62093686: {
                    return this.addManufacturedItem();
                }
                case 722135304: {
                    return this.addOtherCharacteristics();
                }
                case 908628089: {
                    return this.addPackageItem();
                }
                case -1599676319: {
                    return this.getPhysicalCharacteristics();
                }
                case 172049237: {
                    return this.addShelfLifeStorage();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1285004149: {
                    return new String[]{"Quantity"};
                }
                case 299066663: {
                    return new String[]{"CodeableConcept"};
                }
                case -1021448255: {
                    return new String[]{"CodeableConcept"};
                }
                case -1969347631: {
                    return new String[]{"Reference"};
                }
                case -1335157162: {
                    return new String[]{"Reference"};
                }
                case 62093686: {
                    return new String[0];
                }
                case 722135304: {
                    return new String[]{"CodeableConcept"};
                }
                case 908628089: {
                    return new String[]{"@MedicinalProductPackaged.packageItem"};
                }
                case -1599676319: {
                    return new String[]{"ProdCharacteristic"};
                }
                case 172049237: {
                    return new String[]{"ProductShelfLife"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("identifier")) {
                return this.addIdentifier();
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("quantity")) {
                this.quantity = new Quantity();
                return this.quantity;
            }
            if (name.equals("material")) {
                return this.addMaterial();
            }
            if (name.equals("alternateMaterial")) {
                return this.addAlternateMaterial();
            }
            if (name.equals("manufacturer")) {
                return this.addManufacturer();
            }
            if (name.equals("device")) {
                return this.addDevice();
            }
            if (name.equals("manufacturedItem")) {
                return this.addManufacturedItem();
            }
            if (name.equals("otherCharacteristics")) {
                return this.addOtherCharacteristics();
            }
            if (name.equals("packageItem")) {
                return this.addPackageItem();
            }
            if (name.equals("physicalCharacteristics")) {
                this.physicalCharacteristics = new ProdCharacteristic();
                return this.physicalCharacteristics;
            }
            if (name.equals("shelfLifeStorage")) {
                return this.addShelfLifeStorage();
            }
            return super.addChild(name);
        }

        @Override
        public MedicinalProductPackagedPackageItemComponent copy() {
            MedicinalProductPackagedPackageItemComponent dst = new MedicinalProductPackagedPackageItemComponent();
            this.copyValues(dst);
            if (this.identifier != null) {
                dst.identifier = new ArrayList<Identifier>();
                for (Identifier identifier : this.identifier) {
                    dst.identifier.add(identifier.copy());
                }
            }
            dst.type = this.type == null ? null : this.type.copy();
            Quantity quantity = dst.quantity = this.quantity == null ? null : this.quantity.copy();
            if (this.material != null) {
                dst.material = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.material) {
                    dst.material.add(codeableConcept.copy());
                }
            }
            if (this.alternateMaterial != null) {
                dst.alternateMaterial = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.alternateMaterial) {
                    dst.alternateMaterial.add(codeableConcept.copy());
                }
            }
            if (this.manufacturer != null) {
                dst.manufacturer = new ArrayList<Reference>();
                for (Reference reference : this.manufacturer) {
                    dst.manufacturer.add(reference.copy());
                }
            }
            if (this.device != null) {
                dst.device = new ArrayList<Reference>();
                for (Reference reference : this.device) {
                    dst.device.add(reference.copy());
                }
            }
            if (this.manufacturedItem != null) {
                dst.manufacturedItem = new ArrayList<MedicinalProductPackagedPackageItemManufacturedItemComponent>();
                for (MedicinalProductPackagedPackageItemManufacturedItemComponent medicinalProductPackagedPackageItemManufacturedItemComponent : this.manufacturedItem) {
                    dst.manufacturedItem.add(medicinalProductPackagedPackageItemManufacturedItemComponent.copy());
                }
            }
            if (this.otherCharacteristics != null) {
                dst.otherCharacteristics = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.otherCharacteristics) {
                    dst.otherCharacteristics.add(codeableConcept.copy());
                }
            }
            if (this.packageItem != null) {
                dst.packageItem = new ArrayList<MedicinalProductPackagedPackageItemComponent>();
                for (MedicinalProductPackagedPackageItemComponent medicinalProductPackagedPackageItemComponent : this.packageItem) {
                    dst.packageItem.add(medicinalProductPackagedPackageItemComponent.copy());
                }
            }
            ProdCharacteristic prodCharacteristic = dst.physicalCharacteristics = this.physicalCharacteristics == null ? null : this.physicalCharacteristics.copy();
            if (this.shelfLifeStorage != null) {
                dst.shelfLifeStorage = new ArrayList<ProductShelfLife>();
                for (ProductShelfLife productShelfLife : this.shelfLifeStorage) {
                    dst.shelfLifeStorage.add(productShelfLife.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductPackagedPackageItemComponent)) {
                return false;
            }
            MedicinalProductPackagedPackageItemComponent o = (MedicinalProductPackagedPackageItemComponent)other_;
            return MedicinalProductPackagedPackageItemComponent.compareDeep(this.identifier, o.identifier, true) && MedicinalProductPackagedPackageItemComponent.compareDeep(this.type, o.type, true) && MedicinalProductPackagedPackageItemComponent.compareDeep(this.quantity, o.quantity, true) && MedicinalProductPackagedPackageItemComponent.compareDeep(this.material, o.material, true) && MedicinalProductPackagedPackageItemComponent.compareDeep(this.alternateMaterial, o.alternateMaterial, true) && MedicinalProductPackagedPackageItemComponent.compareDeep(this.manufacturer, o.manufacturer, true) && MedicinalProductPackagedPackageItemComponent.compareDeep(this.device, o.device, true) && MedicinalProductPackagedPackageItemComponent.compareDeep(this.manufacturedItem, o.manufacturedItem, true) && MedicinalProductPackagedPackageItemComponent.compareDeep(this.otherCharacteristics, o.otherCharacteristics, true) && MedicinalProductPackagedPackageItemComponent.compareDeep(this.packageItem, o.packageItem, true) && MedicinalProductPackagedPackageItemComponent.compareDeep(this.physicalCharacteristics, o.physicalCharacteristics, true) && MedicinalProductPackagedPackageItemComponent.compareDeep(this.shelfLifeStorage, o.shelfLifeStorage, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductPackagedPackageItemComponent)) {
                return false;
            }
            MedicinalProductPackagedPackageItemComponent o = (MedicinalProductPackagedPackageItemComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.type, this.quantity, this.material, this.alternateMaterial, this.manufacturer, this.device, this.manufacturedItem, this.otherCharacteristics, this.packageItem, this.physicalCharacteristics, this.shelfLifeStorage});
        }

        @Override
        public String fhirType() {
            return "MedicinalProductPackaged.packageItem";
        }
    }

    @Block
    public static class MedicinalProductPackagedBatchIdentifierComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="outerPackaging", type={Identifier.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A number appearing on the outer packaging of a specific batch", formalDefinition="A number appearing on the outer packaging of a specific batch.")
        protected Identifier outerPackaging;
        @Child(name="immediatePackaging", type={Identifier.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A number appearing on the immediate packaging (and not the outer packaging)", formalDefinition="A number appearing on the immediate packaging (and not the outer packaging).")
        protected Identifier immediatePackaging;
        private static final long serialVersionUID = 1187365068L;

        public MedicinalProductPackagedBatchIdentifierComponent() {
        }

        public MedicinalProductPackagedBatchIdentifierComponent(Identifier outerPackaging) {
            this.outerPackaging = outerPackaging;
        }

        public Identifier getOuterPackaging() {
            if (this.outerPackaging == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductPackagedBatchIdentifierComponent.outerPackaging");
                }
                if (Configuration.doAutoCreate()) {
                    this.outerPackaging = new Identifier();
                }
            }
            return this.outerPackaging;
        }

        public boolean hasOuterPackaging() {
            return this.outerPackaging != null && !this.outerPackaging.isEmpty();
        }

        public MedicinalProductPackagedBatchIdentifierComponent setOuterPackaging(Identifier value) {
            this.outerPackaging = value;
            return this;
        }

        public Identifier getImmediatePackaging() {
            if (this.immediatePackaging == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductPackagedBatchIdentifierComponent.immediatePackaging");
                }
                if (Configuration.doAutoCreate()) {
                    this.immediatePackaging = new Identifier();
                }
            }
            return this.immediatePackaging;
        }

        public boolean hasImmediatePackaging() {
            return this.immediatePackaging != null && !this.immediatePackaging.isEmpty();
        }

        public MedicinalProductPackagedBatchIdentifierComponent setImmediatePackaging(Identifier value) {
            this.immediatePackaging = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("outerPackaging", "Identifier", "A number appearing on the outer packaging of a specific batch.", 0, 1, this.outerPackaging));
            children.add(new Property("immediatePackaging", "Identifier", "A number appearing on the immediate packaging (and not the outer packaging).", 0, 1, this.immediatePackaging));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -682249912: {
                    return new Property("outerPackaging", "Identifier", "A number appearing on the outer packaging of a specific batch.", 0, 1, this.outerPackaging);
                }
                case 721147602: {
                    return new Property("immediatePackaging", "Identifier", "A number appearing on the immediate packaging (and not the outer packaging).", 0, 1, this.immediatePackaging);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -682249912: {
                    Base[] baseArray;
                    if (this.outerPackaging == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.outerPackaging;
                    }
                    return baseArray;
                }
                case 721147602: {
                    Base[] baseArray;
                    if (this.immediatePackaging == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.immediatePackaging;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -682249912: {
                    this.outerPackaging = this.castToIdentifier(value);
                    return value;
                }
                case 721147602: {
                    this.immediatePackaging = this.castToIdentifier(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("outerPackaging")) {
                this.outerPackaging = this.castToIdentifier(value);
            } else if (name.equals("immediatePackaging")) {
                this.immediatePackaging = this.castToIdentifier(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -682249912: {
                    return this.getOuterPackaging();
                }
                case 721147602: {
                    return this.getImmediatePackaging();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -682249912: {
                    return new String[]{"Identifier"};
                }
                case 721147602: {
                    return new String[]{"Identifier"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("outerPackaging")) {
                this.outerPackaging = new Identifier();
                return this.outerPackaging;
            }
            if (name.equals("immediatePackaging")) {
                this.immediatePackaging = new Identifier();
                return this.immediatePackaging;
            }
            return super.addChild(name);
        }

        @Override
        public MedicinalProductPackagedBatchIdentifierComponent copy() {
            MedicinalProductPackagedBatchIdentifierComponent dst = new MedicinalProductPackagedBatchIdentifierComponent();
            this.copyValues(dst);
            dst.outerPackaging = this.outerPackaging == null ? null : this.outerPackaging.copy();
            dst.immediatePackaging = this.immediatePackaging == null ? null : this.immediatePackaging.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductPackagedBatchIdentifierComponent)) {
                return false;
            }
            MedicinalProductPackagedBatchIdentifierComponent o = (MedicinalProductPackagedBatchIdentifierComponent)other_;
            return MedicinalProductPackagedBatchIdentifierComponent.compareDeep(this.outerPackaging, o.outerPackaging, true) && MedicinalProductPackagedBatchIdentifierComponent.compareDeep(this.immediatePackaging, o.immediatePackaging, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductPackagedBatchIdentifierComponent)) {
                return false;
            }
            MedicinalProductPackagedBatchIdentifierComponent o = (MedicinalProductPackagedBatchIdentifierComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.outerPackaging, this.immediatePackaging});
        }

        @Override
        public String fhirType() {
            return "MedicinalProductPackaged.batchIdentifier";
        }
    }
}

