/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Medication;
import org.hl7.fhir.r4.model.MedicinalProduct;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Range;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.Substance;
import org.hl7.fhir.r4.model.SubstanceSpecification;
import org.hl7.fhir.r4.model.Type;

@ResourceDef(name="MedicinalProductClinicals", profile="http://hl7.org/fhir/Profile/MedicinalProductClinicals")
public class MedicinalProductClinicals
extends DomainResource {
    @Child(name="undesirableEffects", type={}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Describe the undesirable effects of the medicinal product", formalDefinition="Describe the undesirable effects of the medicinal product.")
    protected List<MedicinalProductClinicalsUndesirableEffectsComponent> undesirableEffects;
    @Child(name="therapeuticIndication", type={}, order=1, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Indication for the Medicinal Product", formalDefinition="Indication for the Medicinal Product.")
    protected List<MedicinalProductClinicalsTherapeuticIndicationComponent> therapeuticIndication;
    @Child(name="contraindication", type={}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contraindication for the medicinal product", formalDefinition="Contraindication for the medicinal product.")
    protected List<MedicinalProductClinicalsContraindicationComponent> contraindication;
    @Child(name="interactions", type={}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The interactions of the medicinal product with other medicinal products, or other forms of interactions", formalDefinition="The interactions of the medicinal product with other medicinal products, or other forms of interactions.")
    protected List<MedicinalProductClinicalsInteractionsComponent> interactions;
    private static final long serialVersionUID = 544343962L;

    public List<MedicinalProductClinicalsUndesirableEffectsComponent> getUndesirableEffects() {
        if (this.undesirableEffects == null) {
            this.undesirableEffects = new ArrayList<MedicinalProductClinicalsUndesirableEffectsComponent>();
        }
        return this.undesirableEffects;
    }

    public MedicinalProductClinicals setUndesirableEffects(List<MedicinalProductClinicalsUndesirableEffectsComponent> theUndesirableEffects) {
        this.undesirableEffects = theUndesirableEffects;
        return this;
    }

    public boolean hasUndesirableEffects() {
        if (this.undesirableEffects == null) {
            return false;
        }
        for (MedicinalProductClinicalsUndesirableEffectsComponent item : this.undesirableEffects) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicinalProductClinicalsUndesirableEffectsComponent addUndesirableEffects() {
        MedicinalProductClinicalsUndesirableEffectsComponent t = new MedicinalProductClinicalsUndesirableEffectsComponent();
        if (this.undesirableEffects == null) {
            this.undesirableEffects = new ArrayList<MedicinalProductClinicalsUndesirableEffectsComponent>();
        }
        this.undesirableEffects.add(t);
        return t;
    }

    public MedicinalProductClinicals addUndesirableEffects(MedicinalProductClinicalsUndesirableEffectsComponent t) {
        if (t == null) {
            return this;
        }
        if (this.undesirableEffects == null) {
            this.undesirableEffects = new ArrayList<MedicinalProductClinicalsUndesirableEffectsComponent>();
        }
        this.undesirableEffects.add(t);
        return this;
    }

    public MedicinalProductClinicalsUndesirableEffectsComponent getUndesirableEffectsFirstRep() {
        if (this.getUndesirableEffects().isEmpty()) {
            this.addUndesirableEffects();
        }
        return this.getUndesirableEffects().get(0);
    }

    public List<MedicinalProductClinicalsTherapeuticIndicationComponent> getTherapeuticIndication() {
        if (this.therapeuticIndication == null) {
            this.therapeuticIndication = new ArrayList<MedicinalProductClinicalsTherapeuticIndicationComponent>();
        }
        return this.therapeuticIndication;
    }

    public MedicinalProductClinicals setTherapeuticIndication(List<MedicinalProductClinicalsTherapeuticIndicationComponent> theTherapeuticIndication) {
        this.therapeuticIndication = theTherapeuticIndication;
        return this;
    }

    public boolean hasTherapeuticIndication() {
        if (this.therapeuticIndication == null) {
            return false;
        }
        for (MedicinalProductClinicalsTherapeuticIndicationComponent item : this.therapeuticIndication) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicinalProductClinicalsTherapeuticIndicationComponent addTherapeuticIndication() {
        MedicinalProductClinicalsTherapeuticIndicationComponent t = new MedicinalProductClinicalsTherapeuticIndicationComponent();
        if (this.therapeuticIndication == null) {
            this.therapeuticIndication = new ArrayList<MedicinalProductClinicalsTherapeuticIndicationComponent>();
        }
        this.therapeuticIndication.add(t);
        return t;
    }

    public MedicinalProductClinicals addTherapeuticIndication(MedicinalProductClinicalsTherapeuticIndicationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.therapeuticIndication == null) {
            this.therapeuticIndication = new ArrayList<MedicinalProductClinicalsTherapeuticIndicationComponent>();
        }
        this.therapeuticIndication.add(t);
        return this;
    }

    public MedicinalProductClinicalsTherapeuticIndicationComponent getTherapeuticIndicationFirstRep() {
        if (this.getTherapeuticIndication().isEmpty()) {
            this.addTherapeuticIndication();
        }
        return this.getTherapeuticIndication().get(0);
    }

    public List<MedicinalProductClinicalsContraindicationComponent> getContraindication() {
        if (this.contraindication == null) {
            this.contraindication = new ArrayList<MedicinalProductClinicalsContraindicationComponent>();
        }
        return this.contraindication;
    }

    public MedicinalProductClinicals setContraindication(List<MedicinalProductClinicalsContraindicationComponent> theContraindication) {
        this.contraindication = theContraindication;
        return this;
    }

    public boolean hasContraindication() {
        if (this.contraindication == null) {
            return false;
        }
        for (MedicinalProductClinicalsContraindicationComponent item : this.contraindication) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicinalProductClinicalsContraindicationComponent addContraindication() {
        MedicinalProductClinicalsContraindicationComponent t = new MedicinalProductClinicalsContraindicationComponent();
        if (this.contraindication == null) {
            this.contraindication = new ArrayList<MedicinalProductClinicalsContraindicationComponent>();
        }
        this.contraindication.add(t);
        return t;
    }

    public MedicinalProductClinicals addContraindication(MedicinalProductClinicalsContraindicationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.contraindication == null) {
            this.contraindication = new ArrayList<MedicinalProductClinicalsContraindicationComponent>();
        }
        this.contraindication.add(t);
        return this;
    }

    public MedicinalProductClinicalsContraindicationComponent getContraindicationFirstRep() {
        if (this.getContraindication().isEmpty()) {
            this.addContraindication();
        }
        return this.getContraindication().get(0);
    }

    public List<MedicinalProductClinicalsInteractionsComponent> getInteractions() {
        if (this.interactions == null) {
            this.interactions = new ArrayList<MedicinalProductClinicalsInteractionsComponent>();
        }
        return this.interactions;
    }

    public MedicinalProductClinicals setInteractions(List<MedicinalProductClinicalsInteractionsComponent> theInteractions) {
        this.interactions = theInteractions;
        return this;
    }

    public boolean hasInteractions() {
        if (this.interactions == null) {
            return false;
        }
        for (MedicinalProductClinicalsInteractionsComponent item : this.interactions) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicinalProductClinicalsInteractionsComponent addInteractions() {
        MedicinalProductClinicalsInteractionsComponent t = new MedicinalProductClinicalsInteractionsComponent();
        if (this.interactions == null) {
            this.interactions = new ArrayList<MedicinalProductClinicalsInteractionsComponent>();
        }
        this.interactions.add(t);
        return t;
    }

    public MedicinalProductClinicals addInteractions(MedicinalProductClinicalsInteractionsComponent t) {
        if (t == null) {
            return this;
        }
        if (this.interactions == null) {
            this.interactions = new ArrayList<MedicinalProductClinicalsInteractionsComponent>();
        }
        this.interactions.add(t);
        return this;
    }

    public MedicinalProductClinicalsInteractionsComponent getInteractionsFirstRep() {
        if (this.getInteractions().isEmpty()) {
            this.addInteractions();
        }
        return this.getInteractions().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("undesirableEffects", "", "Describe the undesirable effects of the medicinal product.", 0, Integer.MAX_VALUE, this.undesirableEffects));
        children.add(new Property("therapeuticIndication", "", "Indication for the Medicinal Product.", 0, Integer.MAX_VALUE, this.therapeuticIndication));
        children.add(new Property("contraindication", "", "Contraindication for the medicinal product.", 0, Integer.MAX_VALUE, this.contraindication));
        children.add(new Property("interactions", "", "The interactions of the medicinal product with other medicinal products, or other forms of interactions.", 0, Integer.MAX_VALUE, this.interactions));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 890492742: {
                return new Property("undesirableEffects", "", "Describe the undesirable effects of the medicinal product.", 0, Integer.MAX_VALUE, this.undesirableEffects);
            }
            case -1925150262: {
                return new Property("therapeuticIndication", "", "Indication for the Medicinal Product.", 0, Integer.MAX_VALUE, this.therapeuticIndication);
            }
            case 107135229: {
                return new Property("contraindication", "", "Contraindication for the medicinal product.", 0, Integer.MAX_VALUE, this.contraindication);
            }
            case 1332671649: {
                return new Property("interactions", "", "The interactions of the medicinal product with other medicinal products, or other forms of interactions.", 0, Integer.MAX_VALUE, this.interactions);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 890492742: {
                return this.undesirableEffects == null ? new Base[]{} : this.undesirableEffects.toArray(new Base[this.undesirableEffects.size()]);
            }
            case -1925150262: {
                return this.therapeuticIndication == null ? new Base[]{} : this.therapeuticIndication.toArray(new Base[this.therapeuticIndication.size()]);
            }
            case 107135229: {
                return this.contraindication == null ? new Base[]{} : this.contraindication.toArray(new Base[this.contraindication.size()]);
            }
            case 1332671649: {
                return this.interactions == null ? new Base[]{} : this.interactions.toArray(new Base[this.interactions.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 890492742: {
                this.getUndesirableEffects().add((MedicinalProductClinicalsUndesirableEffectsComponent)value);
                return value;
            }
            case -1925150262: {
                this.getTherapeuticIndication().add((MedicinalProductClinicalsTherapeuticIndicationComponent)value);
                return value;
            }
            case 107135229: {
                this.getContraindication().add((MedicinalProductClinicalsContraindicationComponent)value);
                return value;
            }
            case 1332671649: {
                this.getInteractions().add((MedicinalProductClinicalsInteractionsComponent)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("undesirableEffects")) {
            this.getUndesirableEffects().add((MedicinalProductClinicalsUndesirableEffectsComponent)value);
        } else if (name.equals("therapeuticIndication")) {
            this.getTherapeuticIndication().add((MedicinalProductClinicalsTherapeuticIndicationComponent)value);
        } else if (name.equals("contraindication")) {
            this.getContraindication().add((MedicinalProductClinicalsContraindicationComponent)value);
        } else if (name.equals("interactions")) {
            this.getInteractions().add((MedicinalProductClinicalsInteractionsComponent)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 890492742: {
                return this.addUndesirableEffects();
            }
            case -1925150262: {
                return this.addTherapeuticIndication();
            }
            case 107135229: {
                return this.addContraindication();
            }
            case 1332671649: {
                return this.addInteractions();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 890492742: {
                return new String[0];
            }
            case -1925150262: {
                return new String[0];
            }
            case 107135229: {
                return new String[0];
            }
            case 1332671649: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("undesirableEffects")) {
            return this.addUndesirableEffects();
        }
        if (name.equals("therapeuticIndication")) {
            return this.addTherapeuticIndication();
        }
        if (name.equals("contraindication")) {
            return this.addContraindication();
        }
        if (name.equals("interactions")) {
            return this.addInteractions();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "MedicinalProductClinicals";
    }

    @Override
    public MedicinalProductClinicals copy() {
        MedicinalProductClinicals dst = new MedicinalProductClinicals();
        this.copyValues(dst);
        if (this.undesirableEffects != null) {
            dst.undesirableEffects = new ArrayList<MedicinalProductClinicalsUndesirableEffectsComponent>();
            for (MedicinalProductClinicalsUndesirableEffectsComponent medicinalProductClinicalsUndesirableEffectsComponent : this.undesirableEffects) {
                dst.undesirableEffects.add(medicinalProductClinicalsUndesirableEffectsComponent.copy());
            }
        }
        if (this.therapeuticIndication != null) {
            dst.therapeuticIndication = new ArrayList<MedicinalProductClinicalsTherapeuticIndicationComponent>();
            for (MedicinalProductClinicalsTherapeuticIndicationComponent medicinalProductClinicalsTherapeuticIndicationComponent : this.therapeuticIndication) {
                dst.therapeuticIndication.add(medicinalProductClinicalsTherapeuticIndicationComponent.copy());
            }
        }
        if (this.contraindication != null) {
            dst.contraindication = new ArrayList<MedicinalProductClinicalsContraindicationComponent>();
            for (MedicinalProductClinicalsContraindicationComponent medicinalProductClinicalsContraindicationComponent : this.contraindication) {
                dst.contraindication.add(medicinalProductClinicalsContraindicationComponent.copy());
            }
        }
        if (this.interactions != null) {
            dst.interactions = new ArrayList<MedicinalProductClinicalsInteractionsComponent>();
            for (MedicinalProductClinicalsInteractionsComponent medicinalProductClinicalsInteractionsComponent : this.interactions) {
                dst.interactions.add(medicinalProductClinicalsInteractionsComponent.copy());
            }
        }
        return dst;
    }

    protected MedicinalProductClinicals typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicinalProductClinicals)) {
            return false;
        }
        MedicinalProductClinicals o = (MedicinalProductClinicals)other_;
        return MedicinalProductClinicals.compareDeep(this.undesirableEffects, o.undesirableEffects, true) && MedicinalProductClinicals.compareDeep(this.therapeuticIndication, o.therapeuticIndication, true) && MedicinalProductClinicals.compareDeep(this.contraindication, o.contraindication, true) && MedicinalProductClinicals.compareDeep(this.interactions, o.interactions, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicinalProductClinicals)) {
            return false;
        }
        MedicinalProductClinicals o = (MedicinalProductClinicals)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.undesirableEffects, this.therapeuticIndication, this.contraindication, this.interactions});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.MedicinalProductClinicals;
    }

    @Block
    public static class MedicinalProductClinicalsInteractionsComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="interactant", type={CodeableConcept.class}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The specific medication, food or laboratory test that interacts", formalDefinition="The specific medication, food or laboratory test that interacts.")
        protected List<CodeableConcept> interactant;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The type of the interaction", formalDefinition="The type of the interaction.")
        protected CodeableConcept type;
        @Child(name="effect", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The effect of the interaction", formalDefinition="The effect of the interaction.")
        protected CodeableConcept effect;
        @Child(name="incidence", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The incidence of the interaction", formalDefinition="The incidence of the interaction.")
        protected CodeableConcept incidence;
        @Child(name="management", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Actions for managing the interaction", formalDefinition="Actions for managing the interaction.")
        protected CodeableConcept management;
        private static final long serialVersionUID = -1519724968L;

        public List<CodeableConcept> getInteractant() {
            if (this.interactant == null) {
                this.interactant = new ArrayList<CodeableConcept>();
            }
            return this.interactant;
        }

        public MedicinalProductClinicalsInteractionsComponent setInteractant(List<CodeableConcept> theInteractant) {
            this.interactant = theInteractant;
            return this;
        }

        public boolean hasInteractant() {
            if (this.interactant == null) {
                return false;
            }
            for (CodeableConcept item : this.interactant) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addInteractant() {
            CodeableConcept t = new CodeableConcept();
            if (this.interactant == null) {
                this.interactant = new ArrayList<CodeableConcept>();
            }
            this.interactant.add(t);
            return t;
        }

        public MedicinalProductClinicalsInteractionsComponent addInteractant(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.interactant == null) {
                this.interactant = new ArrayList<CodeableConcept>();
            }
            this.interactant.add(t);
            return this;
        }

        public CodeableConcept getInteractantFirstRep() {
            if (this.getInteractant().isEmpty()) {
                this.addInteractant();
            }
            return this.getInteractant().get(0);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductClinicalsInteractionsComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicinalProductClinicalsInteractionsComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public CodeableConcept getEffect() {
            if (this.effect == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductClinicalsInteractionsComponent.effect");
                }
                if (Configuration.doAutoCreate()) {
                    this.effect = new CodeableConcept();
                }
            }
            return this.effect;
        }

        public boolean hasEffect() {
            return this.effect != null && !this.effect.isEmpty();
        }

        public MedicinalProductClinicalsInteractionsComponent setEffect(CodeableConcept value) {
            this.effect = value;
            return this;
        }

        public CodeableConcept getIncidence() {
            if (this.incidence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductClinicalsInteractionsComponent.incidence");
                }
                if (Configuration.doAutoCreate()) {
                    this.incidence = new CodeableConcept();
                }
            }
            return this.incidence;
        }

        public boolean hasIncidence() {
            return this.incidence != null && !this.incidence.isEmpty();
        }

        public MedicinalProductClinicalsInteractionsComponent setIncidence(CodeableConcept value) {
            this.incidence = value;
            return this;
        }

        public CodeableConcept getManagement() {
            if (this.management == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductClinicalsInteractionsComponent.management");
                }
                if (Configuration.doAutoCreate()) {
                    this.management = new CodeableConcept();
                }
            }
            return this.management;
        }

        public boolean hasManagement() {
            return this.management != null && !this.management.isEmpty();
        }

        public MedicinalProductClinicalsInteractionsComponent setManagement(CodeableConcept value) {
            this.management = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("interactant", "CodeableConcept", "The specific medication, food or laboratory test that interacts.", 0, Integer.MAX_VALUE, this.interactant));
            children.add(new Property("type", "CodeableConcept", "The type of the interaction.", 0, 1, this.type));
            children.add(new Property("effect", "CodeableConcept", "The effect of the interaction.", 0, 1, this.effect));
            children.add(new Property("incidence", "CodeableConcept", "The incidence of the interaction.", 0, 1, this.incidence));
            children.add(new Property("management", "CodeableConcept", "Actions for managing the interaction.", 0, 1, this.management));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1844097009: {
                    return new Property("interactant", "CodeableConcept", "The specific medication, food or laboratory test that interacts.", 0, Integer.MAX_VALUE, this.interactant);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The type of the interaction.", 0, 1, this.type);
                }
                case -1306084975: {
                    return new Property("effect", "CodeableConcept", "The effect of the interaction.", 0, 1, this.effect);
                }
                case -1598467132: {
                    return new Property("incidence", "CodeableConcept", "The incidence of the interaction.", 0, 1, this.incidence);
                }
                case -1799980989: {
                    return new Property("management", "CodeableConcept", "Actions for managing the interaction.", 0, 1, this.management);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1844097009: {
                    return this.interactant == null ? new Base[]{} : this.interactant.toArray(new Base[this.interactant.size()]);
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -1306084975: {
                    Base[] baseArray;
                    if (this.effect == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.effect;
                    }
                    return baseArray;
                }
                case -1598467132: {
                    Base[] baseArray;
                    if (this.incidence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.incidence;
                    }
                    return baseArray;
                }
                case -1799980989: {
                    Base[] baseArray;
                    if (this.management == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.management;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1844097009: {
                    this.getInteractant().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case -1306084975: {
                    this.effect = this.castToCodeableConcept(value);
                    return value;
                }
                case -1598467132: {
                    this.incidence = this.castToCodeableConcept(value);
                    return value;
                }
                case -1799980989: {
                    this.management = this.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("interactant")) {
                this.getInteractant().add(this.castToCodeableConcept(value));
            } else if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("effect")) {
                this.effect = this.castToCodeableConcept(value);
            } else if (name.equals("incidence")) {
                this.incidence = this.castToCodeableConcept(value);
            } else if (name.equals("management")) {
                this.management = this.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1844097009: {
                    return this.addInteractant();
                }
                case 3575610: {
                    return this.getType();
                }
                case -1306084975: {
                    return this.getEffect();
                }
                case -1598467132: {
                    return this.getIncidence();
                }
                case -1799980989: {
                    return this.getManagement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1844097009: {
                    return new String[]{"CodeableConcept"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1306084975: {
                    return new String[]{"CodeableConcept"};
                }
                case -1598467132: {
                    return new String[]{"CodeableConcept"};
                }
                case -1799980989: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("interactant")) {
                return this.addInteractant();
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("effect")) {
                this.effect = new CodeableConcept();
                return this.effect;
            }
            if (name.equals("incidence")) {
                this.incidence = new CodeableConcept();
                return this.incidence;
            }
            if (name.equals("management")) {
                this.management = new CodeableConcept();
                return this.management;
            }
            return super.addChild(name);
        }

        @Override
        public MedicinalProductClinicalsInteractionsComponent copy() {
            MedicinalProductClinicalsInteractionsComponent dst = new MedicinalProductClinicalsInteractionsComponent();
            this.copyValues(dst);
            if (this.interactant != null) {
                dst.interactant = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.interactant) {
                    dst.interactant.add(i.copy());
                }
            }
            dst.type = this.type == null ? null : this.type.copy();
            dst.effect = this.effect == null ? null : this.effect.copy();
            dst.incidence = this.incidence == null ? null : this.incidence.copy();
            dst.management = this.management == null ? null : this.management.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductClinicalsInteractionsComponent)) {
                return false;
            }
            MedicinalProductClinicalsInteractionsComponent o = (MedicinalProductClinicalsInteractionsComponent)other_;
            return MedicinalProductClinicalsInteractionsComponent.compareDeep(this.interactant, o.interactant, true) && MedicinalProductClinicalsInteractionsComponent.compareDeep(this.type, o.type, true) && MedicinalProductClinicalsInteractionsComponent.compareDeep(this.effect, o.effect, true) && MedicinalProductClinicalsInteractionsComponent.compareDeep(this.incidence, o.incidence, true) && MedicinalProductClinicalsInteractionsComponent.compareDeep(this.management, o.management, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductClinicalsInteractionsComponent)) {
                return false;
            }
            MedicinalProductClinicalsInteractionsComponent o = (MedicinalProductClinicalsInteractionsComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.interactant, this.type, this.effect, this.incidence, this.management});
        }

        @Override
        public String fhirType() {
            return "MedicinalProductClinicals.interactions";
        }
    }

    @Block
    public static class MedicinalProductClinicalsContraindicationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="disease", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The disease, symptom or procedure for the contraindication", formalDefinition="The disease, symptom or procedure for the contraindication.")
        protected CodeableConcept disease;
        @Child(name="diseaseStatus", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The status of the disease or symptom for the contraindication", formalDefinition="The status of the disease or symptom for the contraindication.")
        protected CodeableConcept diseaseStatus;
        @Child(name="comorbidity", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="A comorbidity (concurrent condition) or coinfection", formalDefinition="A comorbidity (concurrent condition) or coinfection.")
        protected List<CodeableConcept> comorbidity;
        @Child(name="therapeuticIndication", type={MedicinalProductClinicalsTherapeuticIndicationComponent.class}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Information about the use of the medicinal product in relation to other therapies as part of the indication", formalDefinition="Information about the use of the medicinal product in relation to other therapies as part of the indication.")
        protected List<MedicinalProductClinicalsTherapeuticIndicationComponent> therapeuticIndication;
        @Child(name="otherTherapy", type={MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent.class}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Information about the use of the medicinal product in relation to other therapies described as part of the contraindication", formalDefinition="Information about the use of the medicinal product in relation to other therapies described as part of the contraindication.")
        protected List<MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent> otherTherapy;
        @Child(name="population", type={MedicinalProductClinicalsUndesirableEffectsPopulationComponent.class}, order=6, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The population group to which this applies", formalDefinition="The population group to which this applies.")
        protected List<MedicinalProductClinicalsUndesirableEffectsPopulationComponent> population;
        private static final long serialVersionUID = -328954718L;

        public CodeableConcept getDisease() {
            if (this.disease == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductClinicalsContraindicationComponent.disease");
                }
                if (Configuration.doAutoCreate()) {
                    this.disease = new CodeableConcept();
                }
            }
            return this.disease;
        }

        public boolean hasDisease() {
            return this.disease != null && !this.disease.isEmpty();
        }

        public MedicinalProductClinicalsContraindicationComponent setDisease(CodeableConcept value) {
            this.disease = value;
            return this;
        }

        public CodeableConcept getDiseaseStatus() {
            if (this.diseaseStatus == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductClinicalsContraindicationComponent.diseaseStatus");
                }
                if (Configuration.doAutoCreate()) {
                    this.diseaseStatus = new CodeableConcept();
                }
            }
            return this.diseaseStatus;
        }

        public boolean hasDiseaseStatus() {
            return this.diseaseStatus != null && !this.diseaseStatus.isEmpty();
        }

        public MedicinalProductClinicalsContraindicationComponent setDiseaseStatus(CodeableConcept value) {
            this.diseaseStatus = value;
            return this;
        }

        public List<CodeableConcept> getComorbidity() {
            if (this.comorbidity == null) {
                this.comorbidity = new ArrayList<CodeableConcept>();
            }
            return this.comorbidity;
        }

        public MedicinalProductClinicalsContraindicationComponent setComorbidity(List<CodeableConcept> theComorbidity) {
            this.comorbidity = theComorbidity;
            return this;
        }

        public boolean hasComorbidity() {
            if (this.comorbidity == null) {
                return false;
            }
            for (CodeableConcept item : this.comorbidity) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addComorbidity() {
            CodeableConcept t = new CodeableConcept();
            if (this.comorbidity == null) {
                this.comorbidity = new ArrayList<CodeableConcept>();
            }
            this.comorbidity.add(t);
            return t;
        }

        public MedicinalProductClinicalsContraindicationComponent addComorbidity(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.comorbidity == null) {
                this.comorbidity = new ArrayList<CodeableConcept>();
            }
            this.comorbidity.add(t);
            return this;
        }

        public CodeableConcept getComorbidityFirstRep() {
            if (this.getComorbidity().isEmpty()) {
                this.addComorbidity();
            }
            return this.getComorbidity().get(0);
        }

        public List<MedicinalProductClinicalsTherapeuticIndicationComponent> getTherapeuticIndication() {
            if (this.therapeuticIndication == null) {
                this.therapeuticIndication = new ArrayList<MedicinalProductClinicalsTherapeuticIndicationComponent>();
            }
            return this.therapeuticIndication;
        }

        public MedicinalProductClinicalsContraindicationComponent setTherapeuticIndication(List<MedicinalProductClinicalsTherapeuticIndicationComponent> theTherapeuticIndication) {
            this.therapeuticIndication = theTherapeuticIndication;
            return this;
        }

        public boolean hasTherapeuticIndication() {
            if (this.therapeuticIndication == null) {
                return false;
            }
            for (MedicinalProductClinicalsTherapeuticIndicationComponent item : this.therapeuticIndication) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MedicinalProductClinicalsTherapeuticIndicationComponent addTherapeuticIndication() {
            MedicinalProductClinicalsTherapeuticIndicationComponent t = new MedicinalProductClinicalsTherapeuticIndicationComponent();
            if (this.therapeuticIndication == null) {
                this.therapeuticIndication = new ArrayList<MedicinalProductClinicalsTherapeuticIndicationComponent>();
            }
            this.therapeuticIndication.add(t);
            return t;
        }

        public MedicinalProductClinicalsContraindicationComponent addTherapeuticIndication(MedicinalProductClinicalsTherapeuticIndicationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.therapeuticIndication == null) {
                this.therapeuticIndication = new ArrayList<MedicinalProductClinicalsTherapeuticIndicationComponent>();
            }
            this.therapeuticIndication.add(t);
            return this;
        }

        public MedicinalProductClinicalsTherapeuticIndicationComponent getTherapeuticIndicationFirstRep() {
            if (this.getTherapeuticIndication().isEmpty()) {
                this.addTherapeuticIndication();
            }
            return this.getTherapeuticIndication().get(0);
        }

        public List<MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent> getOtherTherapy() {
            if (this.otherTherapy == null) {
                this.otherTherapy = new ArrayList<MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent>();
            }
            return this.otherTherapy;
        }

        public MedicinalProductClinicalsContraindicationComponent setOtherTherapy(List<MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent> theOtherTherapy) {
            this.otherTherapy = theOtherTherapy;
            return this;
        }

        public boolean hasOtherTherapy() {
            if (this.otherTherapy == null) {
                return false;
            }
            for (MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent item : this.otherTherapy) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent addOtherTherapy() {
            MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent t = new MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent();
            if (this.otherTherapy == null) {
                this.otherTherapy = new ArrayList<MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent>();
            }
            this.otherTherapy.add(t);
            return t;
        }

        public MedicinalProductClinicalsContraindicationComponent addOtherTherapy(MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent t) {
            if (t == null) {
                return this;
            }
            if (this.otherTherapy == null) {
                this.otherTherapy = new ArrayList<MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent>();
            }
            this.otherTherapy.add(t);
            return this;
        }

        public MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent getOtherTherapyFirstRep() {
            if (this.getOtherTherapy().isEmpty()) {
                this.addOtherTherapy();
            }
            return this.getOtherTherapy().get(0);
        }

        public List<MedicinalProductClinicalsUndesirableEffectsPopulationComponent> getPopulation() {
            if (this.population == null) {
                this.population = new ArrayList<MedicinalProductClinicalsUndesirableEffectsPopulationComponent>();
            }
            return this.population;
        }

        public MedicinalProductClinicalsContraindicationComponent setPopulation(List<MedicinalProductClinicalsUndesirableEffectsPopulationComponent> thePopulation) {
            this.population = thePopulation;
            return this;
        }

        public boolean hasPopulation() {
            if (this.population == null) {
                return false;
            }
            for (MedicinalProductClinicalsUndesirableEffectsPopulationComponent item : this.population) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MedicinalProductClinicalsUndesirableEffectsPopulationComponent addPopulation() {
            MedicinalProductClinicalsUndesirableEffectsPopulationComponent t = new MedicinalProductClinicalsUndesirableEffectsPopulationComponent();
            if (this.population == null) {
                this.population = new ArrayList<MedicinalProductClinicalsUndesirableEffectsPopulationComponent>();
            }
            this.population.add(t);
            return t;
        }

        public MedicinalProductClinicalsContraindicationComponent addPopulation(MedicinalProductClinicalsUndesirableEffectsPopulationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.population == null) {
                this.population = new ArrayList<MedicinalProductClinicalsUndesirableEffectsPopulationComponent>();
            }
            this.population.add(t);
            return this;
        }

        public MedicinalProductClinicalsUndesirableEffectsPopulationComponent getPopulationFirstRep() {
            if (this.getPopulation().isEmpty()) {
                this.addPopulation();
            }
            return this.getPopulation().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("disease", "CodeableConcept", "The disease, symptom or procedure for the contraindication.", 0, 1, this.disease));
            children.add(new Property("diseaseStatus", "CodeableConcept", "The status of the disease or symptom for the contraindication.", 0, 1, this.diseaseStatus));
            children.add(new Property("comorbidity", "CodeableConcept", "A comorbidity (concurrent condition) or coinfection.", 0, Integer.MAX_VALUE, this.comorbidity));
            children.add(new Property("therapeuticIndication", "@MedicinalProductClinicals.therapeuticIndication", "Information about the use of the medicinal product in relation to other therapies as part of the indication.", 0, Integer.MAX_VALUE, this.therapeuticIndication));
            children.add(new Property("otherTherapy", "@MedicinalProductClinicals.therapeuticIndication.otherTherapy", "Information about the use of the medicinal product in relation to other therapies described as part of the contraindication.", 0, Integer.MAX_VALUE, this.otherTherapy));
            children.add(new Property("population", "@MedicinalProductClinicals.undesirableEffects.population", "The population group to which this applies.", 0, Integer.MAX_VALUE, this.population));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1671426428: {
                    return new Property("disease", "CodeableConcept", "The disease, symptom or procedure for the contraindication.", 0, 1, this.disease);
                }
                case -505503602: {
                    return new Property("diseaseStatus", "CodeableConcept", "The status of the disease or symptom for the contraindication.", 0, 1, this.diseaseStatus);
                }
                case -406395211: {
                    return new Property("comorbidity", "CodeableConcept", "A comorbidity (concurrent condition) or coinfection.", 0, Integer.MAX_VALUE, this.comorbidity);
                }
                case -1925150262: {
                    return new Property("therapeuticIndication", "@MedicinalProductClinicals.therapeuticIndication", "Information about the use of the medicinal product in relation to other therapies as part of the indication.", 0, Integer.MAX_VALUE, this.therapeuticIndication);
                }
                case -544509127: {
                    return new Property("otherTherapy", "@MedicinalProductClinicals.therapeuticIndication.otherTherapy", "Information about the use of the medicinal product in relation to other therapies described as part of the contraindication.", 0, Integer.MAX_VALUE, this.otherTherapy);
                }
                case -2023558323: {
                    return new Property("population", "@MedicinalProductClinicals.undesirableEffects.population", "The population group to which this applies.", 0, Integer.MAX_VALUE, this.population);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1671426428: {
                    Base[] baseArray;
                    if (this.disease == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.disease;
                    }
                    return baseArray;
                }
                case -505503602: {
                    Base[] baseArray;
                    if (this.diseaseStatus == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.diseaseStatus;
                    }
                    return baseArray;
                }
                case -406395211: {
                    return this.comorbidity == null ? new Base[]{} : this.comorbidity.toArray(new Base[this.comorbidity.size()]);
                }
                case -1925150262: {
                    return this.therapeuticIndication == null ? new Base[]{} : this.therapeuticIndication.toArray(new Base[this.therapeuticIndication.size()]);
                }
                case -544509127: {
                    return this.otherTherapy == null ? new Base[]{} : this.otherTherapy.toArray(new Base[this.otherTherapy.size()]);
                }
                case -2023558323: {
                    return this.population == null ? new Base[]{} : this.population.toArray(new Base[this.population.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1671426428: {
                    this.disease = this.castToCodeableConcept(value);
                    return value;
                }
                case -505503602: {
                    this.diseaseStatus = this.castToCodeableConcept(value);
                    return value;
                }
                case -406395211: {
                    this.getComorbidity().add(this.castToCodeableConcept(value));
                    return value;
                }
                case -1925150262: {
                    this.getTherapeuticIndication().add((MedicinalProductClinicalsTherapeuticIndicationComponent)value);
                    return value;
                }
                case -544509127: {
                    this.getOtherTherapy().add((MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent)value);
                    return value;
                }
                case -2023558323: {
                    this.getPopulation().add((MedicinalProductClinicalsUndesirableEffectsPopulationComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("disease")) {
                this.disease = this.castToCodeableConcept(value);
            } else if (name.equals("diseaseStatus")) {
                this.diseaseStatus = this.castToCodeableConcept(value);
            } else if (name.equals("comorbidity")) {
                this.getComorbidity().add(this.castToCodeableConcept(value));
            } else if (name.equals("therapeuticIndication")) {
                this.getTherapeuticIndication().add((MedicinalProductClinicalsTherapeuticIndicationComponent)value);
            } else if (name.equals("otherTherapy")) {
                this.getOtherTherapy().add((MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent)value);
            } else if (name.equals("population")) {
                this.getPopulation().add((MedicinalProductClinicalsUndesirableEffectsPopulationComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1671426428: {
                    return this.getDisease();
                }
                case -505503602: {
                    return this.getDiseaseStatus();
                }
                case -406395211: {
                    return this.addComorbidity();
                }
                case -1925150262: {
                    return this.addTherapeuticIndication();
                }
                case -544509127: {
                    return this.addOtherTherapy();
                }
                case -2023558323: {
                    return this.addPopulation();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1671426428: {
                    return new String[]{"CodeableConcept"};
                }
                case -505503602: {
                    return new String[]{"CodeableConcept"};
                }
                case -406395211: {
                    return new String[]{"CodeableConcept"};
                }
                case -1925150262: {
                    return new String[]{"@MedicinalProductClinicals.therapeuticIndication"};
                }
                case -544509127: {
                    return new String[]{"@MedicinalProductClinicals.therapeuticIndication.otherTherapy"};
                }
                case -2023558323: {
                    return new String[]{"@MedicinalProductClinicals.undesirableEffects.population"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("disease")) {
                this.disease = new CodeableConcept();
                return this.disease;
            }
            if (name.equals("diseaseStatus")) {
                this.diseaseStatus = new CodeableConcept();
                return this.diseaseStatus;
            }
            if (name.equals("comorbidity")) {
                return this.addComorbidity();
            }
            if (name.equals("therapeuticIndication")) {
                return this.addTherapeuticIndication();
            }
            if (name.equals("otherTherapy")) {
                return this.addOtherTherapy();
            }
            if (name.equals("population")) {
                return this.addPopulation();
            }
            return super.addChild(name);
        }

        @Override
        public MedicinalProductClinicalsContraindicationComponent copy() {
            MedicinalProductClinicalsContraindicationComponent dst = new MedicinalProductClinicalsContraindicationComponent();
            this.copyValues(dst);
            dst.disease = this.disease == null ? null : this.disease.copy();
            CodeableConcept codeableConcept = dst.diseaseStatus = this.diseaseStatus == null ? null : this.diseaseStatus.copy();
            if (this.comorbidity != null) {
                dst.comorbidity = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.comorbidity) {
                    dst.comorbidity.add(codeableConcept2.copy());
                }
            }
            if (this.therapeuticIndication != null) {
                dst.therapeuticIndication = new ArrayList<MedicinalProductClinicalsTherapeuticIndicationComponent>();
                for (MedicinalProductClinicalsTherapeuticIndicationComponent medicinalProductClinicalsTherapeuticIndicationComponent : this.therapeuticIndication) {
                    dst.therapeuticIndication.add(medicinalProductClinicalsTherapeuticIndicationComponent.copy());
                }
            }
            if (this.otherTherapy != null) {
                dst.otherTherapy = new ArrayList<MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent>();
                for (MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent medicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent : this.otherTherapy) {
                    dst.otherTherapy.add(medicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent.copy());
                }
            }
            if (this.population != null) {
                dst.population = new ArrayList<MedicinalProductClinicalsUndesirableEffectsPopulationComponent>();
                for (MedicinalProductClinicalsUndesirableEffectsPopulationComponent medicinalProductClinicalsUndesirableEffectsPopulationComponent : this.population) {
                    dst.population.add(medicinalProductClinicalsUndesirableEffectsPopulationComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductClinicalsContraindicationComponent)) {
                return false;
            }
            MedicinalProductClinicalsContraindicationComponent o = (MedicinalProductClinicalsContraindicationComponent)other_;
            return MedicinalProductClinicalsContraindicationComponent.compareDeep(this.disease, o.disease, true) && MedicinalProductClinicalsContraindicationComponent.compareDeep(this.diseaseStatus, o.diseaseStatus, true) && MedicinalProductClinicalsContraindicationComponent.compareDeep(this.comorbidity, o.comorbidity, true) && MedicinalProductClinicalsContraindicationComponent.compareDeep(this.therapeuticIndication, o.therapeuticIndication, true) && MedicinalProductClinicalsContraindicationComponent.compareDeep(this.otherTherapy, o.otherTherapy, true) && MedicinalProductClinicalsContraindicationComponent.compareDeep(this.population, o.population, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductClinicalsContraindicationComponent)) {
                return false;
            }
            MedicinalProductClinicalsContraindicationComponent o = (MedicinalProductClinicalsContraindicationComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.disease, this.diseaseStatus, this.comorbidity, this.therapeuticIndication, this.otherTherapy, this.population});
        }

        @Override
        public String fhirType() {
            return "MedicinalProductClinicals.contraindication";
        }
    }

    @Block
    public static class MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="therapyRelationshipType", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The type of relationship between the medicinal product indication or contraindication and another therapy", formalDefinition="The type of relationship between the medicinal product indication or contraindication and another therapy.")
        protected CodeableConcept therapyRelationshipType;
        @Child(name="medication", type={CodeableConcept.class, MedicinalProduct.class, Medication.class, Substance.class, SubstanceSpecification.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Reference to a specific medication (active substance, medicinal product or class of products) as part of an indication or contraindication", formalDefinition="Reference to a specific medication (active substance, medicinal product or class of products) as part of an indication or contraindication.")
        protected Type medication;
        private static final long serialVersionUID = 1438478115L;

        public MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent() {
        }

        public MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent(CodeableConcept therapyRelationshipType, Type medication) {
            this.therapyRelationshipType = therapyRelationshipType;
            this.medication = medication;
        }

        public CodeableConcept getTherapyRelationshipType() {
            if (this.therapyRelationshipType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent.therapyRelationshipType");
                }
                if (Configuration.doAutoCreate()) {
                    this.therapyRelationshipType = new CodeableConcept();
                }
            }
            return this.therapyRelationshipType;
        }

        public boolean hasTherapyRelationshipType() {
            return this.therapyRelationshipType != null && !this.therapyRelationshipType.isEmpty();
        }

        public MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent setTherapyRelationshipType(CodeableConcept value) {
            this.therapyRelationshipType = value;
            return this;
        }

        public Type getMedication() {
            return this.medication;
        }

        public CodeableConcept getMedicationCodeableConcept() throws FHIRException {
            if (this.medication == null) {
                return null;
            }
            if (!(this.medication instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.medication.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.medication;
        }

        public boolean hasMedicationCodeableConcept() {
            return this != null && this.medication instanceof CodeableConcept;
        }

        public Reference getMedicationReference() throws FHIRException {
            if (this.medication == null) {
                return null;
            }
            if (!(this.medication instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.medication.getClass().getName() + " was encountered");
            }
            return (Reference)this.medication;
        }

        public boolean hasMedicationReference() {
            return this != null && this.medication instanceof Reference;
        }

        public boolean hasMedication() {
            return this.medication != null && !this.medication.isEmpty();
        }

        public MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent setMedication(Type value) {
            if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
                throw new Error("Not the right type for MedicinalProductClinicals.therapeuticIndication.otherTherapy.medication[x]: " + value.fhirType());
            }
            this.medication = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("therapyRelationshipType", "CodeableConcept", "The type of relationship between the medicinal product indication or contraindication and another therapy.", 0, 1, this.therapyRelationshipType));
            children.add(new Property("medication[x]", "CodeableConcept|Reference(MedicinalProduct|Medication|Substance|SubstanceSpecification)", "Reference to a specific medication (active substance, medicinal product or class of products) as part of an indication or contraindication.", 0, 1, this.medication));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -551658469: {
                    return new Property("therapyRelationshipType", "CodeableConcept", "The type of relationship between the medicinal product indication or contraindication and another therapy.", 0, 1, this.therapyRelationshipType);
                }
                case 1458402129: {
                    return new Property("medication[x]", "CodeableConcept|Reference(MedicinalProduct|Medication|Substance|SubstanceSpecification)", "Reference to a specific medication (active substance, medicinal product or class of products) as part of an indication or contraindication.", 0, 1, this.medication);
                }
                case 1998965455: {
                    return new Property("medication[x]", "CodeableConcept|Reference(MedicinalProduct|Medication|Substance|SubstanceSpecification)", "Reference to a specific medication (active substance, medicinal product or class of products) as part of an indication or contraindication.", 0, 1, this.medication);
                }
                case -209845038: {
                    return new Property("medication[x]", "CodeableConcept|Reference(MedicinalProduct|Medication|Substance|SubstanceSpecification)", "Reference to a specific medication (active substance, medicinal product or class of products) as part of an indication or contraindication.", 0, 1, this.medication);
                }
                case 2104315196: {
                    return new Property("medication[x]", "CodeableConcept|Reference(MedicinalProduct|Medication|Substance|SubstanceSpecification)", "Reference to a specific medication (active substance, medicinal product or class of products) as part of an indication or contraindication.", 0, 1, this.medication);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -551658469: {
                    Base[] baseArray;
                    if (this.therapyRelationshipType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.therapyRelationshipType;
                    }
                    return baseArray;
                }
                case 1998965455: {
                    Base[] baseArray;
                    if (this.medication == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.medication;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -551658469: {
                    this.therapyRelationshipType = this.castToCodeableConcept(value);
                    return value;
                }
                case 1998965455: {
                    this.medication = this.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("therapyRelationshipType")) {
                this.therapyRelationshipType = this.castToCodeableConcept(value);
            } else if (name.equals("medication[x]")) {
                this.medication = this.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -551658469: {
                    return this.getTherapyRelationshipType();
                }
                case 1458402129: {
                    return this.getMedication();
                }
                case 1998965455: {
                    return this.getMedication();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -551658469: {
                    return new String[]{"CodeableConcept"};
                }
                case 1998965455: {
                    return new String[]{"CodeableConcept", "Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("therapyRelationshipType")) {
                this.therapyRelationshipType = new CodeableConcept();
                return this.therapyRelationshipType;
            }
            if (name.equals("medicationCodeableConcept")) {
                this.medication = new CodeableConcept();
                return this.medication;
            }
            if (name.equals("medicationReference")) {
                this.medication = new Reference();
                return this.medication;
            }
            return super.addChild(name);
        }

        @Override
        public MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent copy() {
            MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent dst = new MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent();
            this.copyValues(dst);
            dst.therapyRelationshipType = this.therapyRelationshipType == null ? null : this.therapyRelationshipType.copy();
            dst.medication = this.medication == null ? null : this.medication.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent)) {
                return false;
            }
            MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent o = (MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent)other_;
            return MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent.compareDeep(this.therapyRelationshipType, o.therapyRelationshipType, true) && MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent.compareDeep(this.medication, o.medication, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent)) {
                return false;
            }
            MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent o = (MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.therapyRelationshipType, this.medication});
        }

        @Override
        public String fhirType() {
            return "MedicinalProductClinicals.therapeuticIndication.otherTherapy";
        }
    }

    @Block
    public static class MedicinalProductClinicalsTherapeuticIndicationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="diseaseSymptomProcedure", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The disease, symptom or procedure that is the indication for treatment", formalDefinition="The disease, symptom or procedure that is the indication for treatment.")
        protected CodeableConcept diseaseSymptomProcedure;
        @Child(name="diseaseStatus", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The status of the disease or symptom for which the indication applies", formalDefinition="The status of the disease or symptom for which the indication applies.")
        protected CodeableConcept diseaseStatus;
        @Child(name="comorbidity", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Comorbidity (concurrent condition) or co-infection as part of the indication", formalDefinition="Comorbidity (concurrent condition) or co-infection as part of the indication.")
        protected List<CodeableConcept> comorbidity;
        @Child(name="intendedEffect", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The intended effect, aim or strategy to be achieved by the indication", formalDefinition="The intended effect, aim or strategy to be achieved by the indication.")
        protected CodeableConcept intendedEffect;
        @Child(name="duration", type={Quantity.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Timing or duration information as part of the indication", formalDefinition="Timing or duration information as part of the indication.")
        protected Quantity duration;
        @Child(name="undesirableEffects", type={MedicinalProductClinicalsUndesirableEffectsComponent.class}, order=6, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Information about the use of the medicinal product in relation to other therapies as part of the indication", formalDefinition="Information about the use of the medicinal product in relation to other therapies as part of the indication.")
        protected List<MedicinalProductClinicalsUndesirableEffectsComponent> undesirableEffects;
        @Child(name="otherTherapy", type={}, order=7, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Information about the use of the medicinal product in relation to other therapies described as part of the indication", formalDefinition="Information about the use of the medicinal product in relation to other therapies described as part of the indication.")
        protected List<MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent> otherTherapy;
        @Child(name="population", type={MedicinalProductClinicalsUndesirableEffectsPopulationComponent.class}, order=8, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The population group to which this applies", formalDefinition="The population group to which this applies.")
        protected List<MedicinalProductClinicalsUndesirableEffectsPopulationComponent> population;
        private static final long serialVersionUID = -18331206L;

        public CodeableConcept getDiseaseSymptomProcedure() {
            if (this.diseaseSymptomProcedure == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductClinicalsTherapeuticIndicationComponent.diseaseSymptomProcedure");
                }
                if (Configuration.doAutoCreate()) {
                    this.diseaseSymptomProcedure = new CodeableConcept();
                }
            }
            return this.diseaseSymptomProcedure;
        }

        public boolean hasDiseaseSymptomProcedure() {
            return this.diseaseSymptomProcedure != null && !this.diseaseSymptomProcedure.isEmpty();
        }

        public MedicinalProductClinicalsTherapeuticIndicationComponent setDiseaseSymptomProcedure(CodeableConcept value) {
            this.diseaseSymptomProcedure = value;
            return this;
        }

        public CodeableConcept getDiseaseStatus() {
            if (this.diseaseStatus == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductClinicalsTherapeuticIndicationComponent.diseaseStatus");
                }
                if (Configuration.doAutoCreate()) {
                    this.diseaseStatus = new CodeableConcept();
                }
            }
            return this.diseaseStatus;
        }

        public boolean hasDiseaseStatus() {
            return this.diseaseStatus != null && !this.diseaseStatus.isEmpty();
        }

        public MedicinalProductClinicalsTherapeuticIndicationComponent setDiseaseStatus(CodeableConcept value) {
            this.diseaseStatus = value;
            return this;
        }

        public List<CodeableConcept> getComorbidity() {
            if (this.comorbidity == null) {
                this.comorbidity = new ArrayList<CodeableConcept>();
            }
            return this.comorbidity;
        }

        public MedicinalProductClinicalsTherapeuticIndicationComponent setComorbidity(List<CodeableConcept> theComorbidity) {
            this.comorbidity = theComorbidity;
            return this;
        }

        public boolean hasComorbidity() {
            if (this.comorbidity == null) {
                return false;
            }
            for (CodeableConcept item : this.comorbidity) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addComorbidity() {
            CodeableConcept t = new CodeableConcept();
            if (this.comorbidity == null) {
                this.comorbidity = new ArrayList<CodeableConcept>();
            }
            this.comorbidity.add(t);
            return t;
        }

        public MedicinalProductClinicalsTherapeuticIndicationComponent addComorbidity(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.comorbidity == null) {
                this.comorbidity = new ArrayList<CodeableConcept>();
            }
            this.comorbidity.add(t);
            return this;
        }

        public CodeableConcept getComorbidityFirstRep() {
            if (this.getComorbidity().isEmpty()) {
                this.addComorbidity();
            }
            return this.getComorbidity().get(0);
        }

        public CodeableConcept getIntendedEffect() {
            if (this.intendedEffect == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductClinicalsTherapeuticIndicationComponent.intendedEffect");
                }
                if (Configuration.doAutoCreate()) {
                    this.intendedEffect = new CodeableConcept();
                }
            }
            return this.intendedEffect;
        }

        public boolean hasIntendedEffect() {
            return this.intendedEffect != null && !this.intendedEffect.isEmpty();
        }

        public MedicinalProductClinicalsTherapeuticIndicationComponent setIntendedEffect(CodeableConcept value) {
            this.intendedEffect = value;
            return this;
        }

        public Quantity getDuration() {
            if (this.duration == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductClinicalsTherapeuticIndicationComponent.duration");
                }
                if (Configuration.doAutoCreate()) {
                    this.duration = new Quantity();
                }
            }
            return this.duration;
        }

        public boolean hasDuration() {
            return this.duration != null && !this.duration.isEmpty();
        }

        public MedicinalProductClinicalsTherapeuticIndicationComponent setDuration(Quantity value) {
            this.duration = value;
            return this;
        }

        public List<MedicinalProductClinicalsUndesirableEffectsComponent> getUndesirableEffects() {
            if (this.undesirableEffects == null) {
                this.undesirableEffects = new ArrayList<MedicinalProductClinicalsUndesirableEffectsComponent>();
            }
            return this.undesirableEffects;
        }

        public MedicinalProductClinicalsTherapeuticIndicationComponent setUndesirableEffects(List<MedicinalProductClinicalsUndesirableEffectsComponent> theUndesirableEffects) {
            this.undesirableEffects = theUndesirableEffects;
            return this;
        }

        public boolean hasUndesirableEffects() {
            if (this.undesirableEffects == null) {
                return false;
            }
            for (MedicinalProductClinicalsUndesirableEffectsComponent item : this.undesirableEffects) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MedicinalProductClinicalsUndesirableEffectsComponent addUndesirableEffects() {
            MedicinalProductClinicalsUndesirableEffectsComponent t = new MedicinalProductClinicalsUndesirableEffectsComponent();
            if (this.undesirableEffects == null) {
                this.undesirableEffects = new ArrayList<MedicinalProductClinicalsUndesirableEffectsComponent>();
            }
            this.undesirableEffects.add(t);
            return t;
        }

        public MedicinalProductClinicalsTherapeuticIndicationComponent addUndesirableEffects(MedicinalProductClinicalsUndesirableEffectsComponent t) {
            if (t == null) {
                return this;
            }
            if (this.undesirableEffects == null) {
                this.undesirableEffects = new ArrayList<MedicinalProductClinicalsUndesirableEffectsComponent>();
            }
            this.undesirableEffects.add(t);
            return this;
        }

        public MedicinalProductClinicalsUndesirableEffectsComponent getUndesirableEffectsFirstRep() {
            if (this.getUndesirableEffects().isEmpty()) {
                this.addUndesirableEffects();
            }
            return this.getUndesirableEffects().get(0);
        }

        public List<MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent> getOtherTherapy() {
            if (this.otherTherapy == null) {
                this.otherTherapy = new ArrayList<MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent>();
            }
            return this.otherTherapy;
        }

        public MedicinalProductClinicalsTherapeuticIndicationComponent setOtherTherapy(List<MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent> theOtherTherapy) {
            this.otherTherapy = theOtherTherapy;
            return this;
        }

        public boolean hasOtherTherapy() {
            if (this.otherTherapy == null) {
                return false;
            }
            for (MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent item : this.otherTherapy) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent addOtherTherapy() {
            MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent t = new MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent();
            if (this.otherTherapy == null) {
                this.otherTherapy = new ArrayList<MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent>();
            }
            this.otherTherapy.add(t);
            return t;
        }

        public MedicinalProductClinicalsTherapeuticIndicationComponent addOtherTherapy(MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent t) {
            if (t == null) {
                return this;
            }
            if (this.otherTherapy == null) {
                this.otherTherapy = new ArrayList<MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent>();
            }
            this.otherTherapy.add(t);
            return this;
        }

        public MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent getOtherTherapyFirstRep() {
            if (this.getOtherTherapy().isEmpty()) {
                this.addOtherTherapy();
            }
            return this.getOtherTherapy().get(0);
        }

        public List<MedicinalProductClinicalsUndesirableEffectsPopulationComponent> getPopulation() {
            if (this.population == null) {
                this.population = new ArrayList<MedicinalProductClinicalsUndesirableEffectsPopulationComponent>();
            }
            return this.population;
        }

        public MedicinalProductClinicalsTherapeuticIndicationComponent setPopulation(List<MedicinalProductClinicalsUndesirableEffectsPopulationComponent> thePopulation) {
            this.population = thePopulation;
            return this;
        }

        public boolean hasPopulation() {
            if (this.population == null) {
                return false;
            }
            for (MedicinalProductClinicalsUndesirableEffectsPopulationComponent item : this.population) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MedicinalProductClinicalsUndesirableEffectsPopulationComponent addPopulation() {
            MedicinalProductClinicalsUndesirableEffectsPopulationComponent t = new MedicinalProductClinicalsUndesirableEffectsPopulationComponent();
            if (this.population == null) {
                this.population = new ArrayList<MedicinalProductClinicalsUndesirableEffectsPopulationComponent>();
            }
            this.population.add(t);
            return t;
        }

        public MedicinalProductClinicalsTherapeuticIndicationComponent addPopulation(MedicinalProductClinicalsUndesirableEffectsPopulationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.population == null) {
                this.population = new ArrayList<MedicinalProductClinicalsUndesirableEffectsPopulationComponent>();
            }
            this.population.add(t);
            return this;
        }

        public MedicinalProductClinicalsUndesirableEffectsPopulationComponent getPopulationFirstRep() {
            if (this.getPopulation().isEmpty()) {
                this.addPopulation();
            }
            return this.getPopulation().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("diseaseSymptomProcedure", "CodeableConcept", "The disease, symptom or procedure that is the indication for treatment.", 0, 1, this.diseaseSymptomProcedure));
            children.add(new Property("diseaseStatus", "CodeableConcept", "The status of the disease or symptom for which the indication applies.", 0, 1, this.diseaseStatus));
            children.add(new Property("comorbidity", "CodeableConcept", "Comorbidity (concurrent condition) or co-infection as part of the indication.", 0, Integer.MAX_VALUE, this.comorbidity));
            children.add(new Property("intendedEffect", "CodeableConcept", "The intended effect, aim or strategy to be achieved by the indication.", 0, 1, this.intendedEffect));
            children.add(new Property("duration", "Quantity", "Timing or duration information as part of the indication.", 0, 1, this.duration));
            children.add(new Property("undesirableEffects", "@MedicinalProductClinicals.undesirableEffects", "Information about the use of the medicinal product in relation to other therapies as part of the indication.", 0, Integer.MAX_VALUE, this.undesirableEffects));
            children.add(new Property("otherTherapy", "", "Information about the use of the medicinal product in relation to other therapies described as part of the indication.", 0, Integer.MAX_VALUE, this.otherTherapy));
            children.add(new Property("population", "@MedicinalProductClinicals.undesirableEffects.population", "The population group to which this applies.", 0, Integer.MAX_VALUE, this.population));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1497395130: {
                    return new Property("diseaseSymptomProcedure", "CodeableConcept", "The disease, symptom or procedure that is the indication for treatment.", 0, 1, this.diseaseSymptomProcedure);
                }
                case -505503602: {
                    return new Property("diseaseStatus", "CodeableConcept", "The status of the disease or symptom for which the indication applies.", 0, 1, this.diseaseStatus);
                }
                case -406395211: {
                    return new Property("comorbidity", "CodeableConcept", "Comorbidity (concurrent condition) or co-infection as part of the indication.", 0, Integer.MAX_VALUE, this.comorbidity);
                }
                case 1587112348: {
                    return new Property("intendedEffect", "CodeableConcept", "The intended effect, aim or strategy to be achieved by the indication.", 0, 1, this.intendedEffect);
                }
                case -1992012396: {
                    return new Property("duration", "Quantity", "Timing or duration information as part of the indication.", 0, 1, this.duration);
                }
                case 890492742: {
                    return new Property("undesirableEffects", "@MedicinalProductClinicals.undesirableEffects", "Information about the use of the medicinal product in relation to other therapies as part of the indication.", 0, Integer.MAX_VALUE, this.undesirableEffects);
                }
                case -544509127: {
                    return new Property("otherTherapy", "", "Information about the use of the medicinal product in relation to other therapies described as part of the indication.", 0, Integer.MAX_VALUE, this.otherTherapy);
                }
                case -2023558323: {
                    return new Property("population", "@MedicinalProductClinicals.undesirableEffects.population", "The population group to which this applies.", 0, Integer.MAX_VALUE, this.population);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1497395130: {
                    Base[] baseArray;
                    if (this.diseaseSymptomProcedure == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.diseaseSymptomProcedure;
                    }
                    return baseArray;
                }
                case -505503602: {
                    Base[] baseArray;
                    if (this.diseaseStatus == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.diseaseStatus;
                    }
                    return baseArray;
                }
                case -406395211: {
                    return this.comorbidity == null ? new Base[]{} : this.comorbidity.toArray(new Base[this.comorbidity.size()]);
                }
                case 1587112348: {
                    Base[] baseArray;
                    if (this.intendedEffect == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.intendedEffect;
                    }
                    return baseArray;
                }
                case -1992012396: {
                    Base[] baseArray;
                    if (this.duration == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.duration;
                    }
                    return baseArray;
                }
                case 890492742: {
                    return this.undesirableEffects == null ? new Base[]{} : this.undesirableEffects.toArray(new Base[this.undesirableEffects.size()]);
                }
                case -544509127: {
                    return this.otherTherapy == null ? new Base[]{} : this.otherTherapy.toArray(new Base[this.otherTherapy.size()]);
                }
                case -2023558323: {
                    return this.population == null ? new Base[]{} : this.population.toArray(new Base[this.population.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1497395130: {
                    this.diseaseSymptomProcedure = this.castToCodeableConcept(value);
                    return value;
                }
                case -505503602: {
                    this.diseaseStatus = this.castToCodeableConcept(value);
                    return value;
                }
                case -406395211: {
                    this.getComorbidity().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 1587112348: {
                    this.intendedEffect = this.castToCodeableConcept(value);
                    return value;
                }
                case -1992012396: {
                    this.duration = this.castToQuantity(value);
                    return value;
                }
                case 890492742: {
                    this.getUndesirableEffects().add((MedicinalProductClinicalsUndesirableEffectsComponent)value);
                    return value;
                }
                case -544509127: {
                    this.getOtherTherapy().add((MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent)value);
                    return value;
                }
                case -2023558323: {
                    this.getPopulation().add((MedicinalProductClinicalsUndesirableEffectsPopulationComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("diseaseSymptomProcedure")) {
                this.diseaseSymptomProcedure = this.castToCodeableConcept(value);
            } else if (name.equals("diseaseStatus")) {
                this.diseaseStatus = this.castToCodeableConcept(value);
            } else if (name.equals("comorbidity")) {
                this.getComorbidity().add(this.castToCodeableConcept(value));
            } else if (name.equals("intendedEffect")) {
                this.intendedEffect = this.castToCodeableConcept(value);
            } else if (name.equals("duration")) {
                this.duration = this.castToQuantity(value);
            } else if (name.equals("undesirableEffects")) {
                this.getUndesirableEffects().add((MedicinalProductClinicalsUndesirableEffectsComponent)value);
            } else if (name.equals("otherTherapy")) {
                this.getOtherTherapy().add((MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent)value);
            } else if (name.equals("population")) {
                this.getPopulation().add((MedicinalProductClinicalsUndesirableEffectsPopulationComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1497395130: {
                    return this.getDiseaseSymptomProcedure();
                }
                case -505503602: {
                    return this.getDiseaseStatus();
                }
                case -406395211: {
                    return this.addComorbidity();
                }
                case 1587112348: {
                    return this.getIntendedEffect();
                }
                case -1992012396: {
                    return this.getDuration();
                }
                case 890492742: {
                    return this.addUndesirableEffects();
                }
                case -544509127: {
                    return this.addOtherTherapy();
                }
                case -2023558323: {
                    return this.addPopulation();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1497395130: {
                    return new String[]{"CodeableConcept"};
                }
                case -505503602: {
                    return new String[]{"CodeableConcept"};
                }
                case -406395211: {
                    return new String[]{"CodeableConcept"};
                }
                case 1587112348: {
                    return new String[]{"CodeableConcept"};
                }
                case -1992012396: {
                    return new String[]{"Quantity"};
                }
                case 890492742: {
                    return new String[]{"@MedicinalProductClinicals.undesirableEffects"};
                }
                case -544509127: {
                    return new String[0];
                }
                case -2023558323: {
                    return new String[]{"@MedicinalProductClinicals.undesirableEffects.population"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("diseaseSymptomProcedure")) {
                this.diseaseSymptomProcedure = new CodeableConcept();
                return this.diseaseSymptomProcedure;
            }
            if (name.equals("diseaseStatus")) {
                this.diseaseStatus = new CodeableConcept();
                return this.diseaseStatus;
            }
            if (name.equals("comorbidity")) {
                return this.addComorbidity();
            }
            if (name.equals("intendedEffect")) {
                this.intendedEffect = new CodeableConcept();
                return this.intendedEffect;
            }
            if (name.equals("duration")) {
                this.duration = new Quantity();
                return this.duration;
            }
            if (name.equals("undesirableEffects")) {
                return this.addUndesirableEffects();
            }
            if (name.equals("otherTherapy")) {
                return this.addOtherTherapy();
            }
            if (name.equals("population")) {
                return this.addPopulation();
            }
            return super.addChild(name);
        }

        @Override
        public MedicinalProductClinicalsTherapeuticIndicationComponent copy() {
            MedicinalProductClinicalsTherapeuticIndicationComponent dst = new MedicinalProductClinicalsTherapeuticIndicationComponent();
            this.copyValues(dst);
            dst.diseaseSymptomProcedure = this.diseaseSymptomProcedure == null ? null : this.diseaseSymptomProcedure.copy();
            CodeableConcept codeableConcept = dst.diseaseStatus = this.diseaseStatus == null ? null : this.diseaseStatus.copy();
            if (this.comorbidity != null) {
                dst.comorbidity = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.comorbidity) {
                    dst.comorbidity.add(codeableConcept2.copy());
                }
            }
            dst.intendedEffect = this.intendedEffect == null ? null : this.intendedEffect.copy();
            Quantity quantity = dst.duration = this.duration == null ? null : this.duration.copy();
            if (this.undesirableEffects != null) {
                dst.undesirableEffects = new ArrayList<MedicinalProductClinicalsUndesirableEffectsComponent>();
                for (MedicinalProductClinicalsUndesirableEffectsComponent medicinalProductClinicalsUndesirableEffectsComponent : this.undesirableEffects) {
                    dst.undesirableEffects.add(medicinalProductClinicalsUndesirableEffectsComponent.copy());
                }
            }
            if (this.otherTherapy != null) {
                dst.otherTherapy = new ArrayList<MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent>();
                for (MedicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent medicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent : this.otherTherapy) {
                    dst.otherTherapy.add(medicinalProductClinicalsTherapeuticIndicationOtherTherapyComponent.copy());
                }
            }
            if (this.population != null) {
                dst.population = new ArrayList<MedicinalProductClinicalsUndesirableEffectsPopulationComponent>();
                for (MedicinalProductClinicalsUndesirableEffectsPopulationComponent medicinalProductClinicalsUndesirableEffectsPopulationComponent : this.population) {
                    dst.population.add(medicinalProductClinicalsUndesirableEffectsPopulationComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductClinicalsTherapeuticIndicationComponent)) {
                return false;
            }
            MedicinalProductClinicalsTherapeuticIndicationComponent o = (MedicinalProductClinicalsTherapeuticIndicationComponent)other_;
            return MedicinalProductClinicalsTherapeuticIndicationComponent.compareDeep(this.diseaseSymptomProcedure, o.diseaseSymptomProcedure, true) && MedicinalProductClinicalsTherapeuticIndicationComponent.compareDeep(this.diseaseStatus, o.diseaseStatus, true) && MedicinalProductClinicalsTherapeuticIndicationComponent.compareDeep(this.comorbidity, o.comorbidity, true) && MedicinalProductClinicalsTherapeuticIndicationComponent.compareDeep(this.intendedEffect, o.intendedEffect, true) && MedicinalProductClinicalsTherapeuticIndicationComponent.compareDeep(this.duration, o.duration, true) && MedicinalProductClinicalsTherapeuticIndicationComponent.compareDeep(this.undesirableEffects, o.undesirableEffects, true) && MedicinalProductClinicalsTherapeuticIndicationComponent.compareDeep(this.otherTherapy, o.otherTherapy, true) && MedicinalProductClinicalsTherapeuticIndicationComponent.compareDeep(this.population, o.population, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductClinicalsTherapeuticIndicationComponent)) {
                return false;
            }
            MedicinalProductClinicalsTherapeuticIndicationComponent o = (MedicinalProductClinicalsTherapeuticIndicationComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.diseaseSymptomProcedure, this.diseaseStatus, this.comorbidity, this.intendedEffect, this.duration, this.undesirableEffects, this.otherTherapy, this.population});
        }

        @Override
        public String fhirType() {
            return "MedicinalProductClinicals.therapeuticIndication";
        }
    }

    @Block
    public static class MedicinalProductClinicalsUndesirableEffectsPopulationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="age", type={Range.class, CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The age of the specific population", formalDefinition="The age of the specific population.")
        protected Type age;
        @Child(name="gender", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The gender of the specific population", formalDefinition="The gender of the specific population.")
        protected CodeableConcept gender;
        @Child(name="race", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Race of the specific population", formalDefinition="Race of the specific population.")
        protected CodeableConcept race;
        @Child(name="physiologicalCondition", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The existing physiological conditions of the specific population to which this applies", formalDefinition="The existing physiological conditions of the specific population to which this applies.")
        protected CodeableConcept physiologicalCondition;
        private static final long serialVersionUID = -394311584L;

        public Type getAge() {
            return this.age;
        }

        public Range getAgeRange() throws FHIRException {
            if (this.age == null) {
                return null;
            }
            if (!(this.age instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.age.getClass().getName() + " was encountered");
            }
            return (Range)this.age;
        }

        public boolean hasAgeRange() {
            return this != null && this.age instanceof Range;
        }

        public CodeableConcept getAgeCodeableConcept() throws FHIRException {
            if (this.age == null) {
                return null;
            }
            if (!(this.age instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.age.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.age;
        }

        public boolean hasAgeCodeableConcept() {
            return this != null && this.age instanceof CodeableConcept;
        }

        public boolean hasAge() {
            return this.age != null && !this.age.isEmpty();
        }

        public MedicinalProductClinicalsUndesirableEffectsPopulationComponent setAge(Type value) {
            if (value != null && !(value instanceof Range) && !(value instanceof CodeableConcept)) {
                throw new Error("Not the right type for MedicinalProductClinicals.undesirableEffects.population.age[x]: " + value.fhirType());
            }
            this.age = value;
            return this;
        }

        public CodeableConcept getGender() {
            if (this.gender == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductClinicalsUndesirableEffectsPopulationComponent.gender");
                }
                if (Configuration.doAutoCreate()) {
                    this.gender = new CodeableConcept();
                }
            }
            return this.gender;
        }

        public boolean hasGender() {
            return this.gender != null && !this.gender.isEmpty();
        }

        public MedicinalProductClinicalsUndesirableEffectsPopulationComponent setGender(CodeableConcept value) {
            this.gender = value;
            return this;
        }

        public CodeableConcept getRace() {
            if (this.race == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductClinicalsUndesirableEffectsPopulationComponent.race");
                }
                if (Configuration.doAutoCreate()) {
                    this.race = new CodeableConcept();
                }
            }
            return this.race;
        }

        public boolean hasRace() {
            return this.race != null && !this.race.isEmpty();
        }

        public MedicinalProductClinicalsUndesirableEffectsPopulationComponent setRace(CodeableConcept value) {
            this.race = value;
            return this;
        }

        public CodeableConcept getPhysiologicalCondition() {
            if (this.physiologicalCondition == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductClinicalsUndesirableEffectsPopulationComponent.physiologicalCondition");
                }
                if (Configuration.doAutoCreate()) {
                    this.physiologicalCondition = new CodeableConcept();
                }
            }
            return this.physiologicalCondition;
        }

        public boolean hasPhysiologicalCondition() {
            return this.physiologicalCondition != null && !this.physiologicalCondition.isEmpty();
        }

        public MedicinalProductClinicalsUndesirableEffectsPopulationComponent setPhysiologicalCondition(CodeableConcept value) {
            this.physiologicalCondition = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("age[x]", "Range|CodeableConcept", "The age of the specific population.", 0, 1, this.age));
            children.add(new Property("gender", "CodeableConcept", "The gender of the specific population.", 0, 1, this.gender));
            children.add(new Property("race", "CodeableConcept", "Race of the specific population.", 0, 1, this.race));
            children.add(new Property("physiologicalCondition", "CodeableConcept", "The existing physiological conditions of the specific population to which this applies.", 0, 1, this.physiologicalCondition));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1419716831: {
                    return new Property("age[x]", "Range|CodeableConcept", "The age of the specific population.", 0, 1, this.age);
                }
                case 96511: {
                    return new Property("age[x]", "Range|CodeableConcept", "The age of the specific population.", 0, 1, this.age);
                }
                case 1442748286: {
                    return new Property("age[x]", "Range|CodeableConcept", "The age of the specific population.", 0, 1, this.age);
                }
                case -1452658526: {
                    return new Property("age[x]", "Range|CodeableConcept", "The age of the specific population.", 0, 1, this.age);
                }
                case -1249512767: {
                    return new Property("gender", "CodeableConcept", "The gender of the specific population.", 0, 1, this.gender);
                }
                case 3492561: {
                    return new Property("race", "CodeableConcept", "Race of the specific population.", 0, 1, this.race);
                }
                case -62715190: {
                    return new Property("physiologicalCondition", "CodeableConcept", "The existing physiological conditions of the specific population to which this applies.", 0, 1, this.physiologicalCondition);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 96511: {
                    Base[] baseArray;
                    if (this.age == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.age;
                    }
                    return baseArray;
                }
                case -1249512767: {
                    Base[] baseArray;
                    if (this.gender == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.gender;
                    }
                    return baseArray;
                }
                case 3492561: {
                    Base[] baseArray;
                    if (this.race == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.race;
                    }
                    return baseArray;
                }
                case -62715190: {
                    Base[] baseArray;
                    if (this.physiologicalCondition == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.physiologicalCondition;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 96511: {
                    this.age = this.castToType(value);
                    return value;
                }
                case -1249512767: {
                    this.gender = this.castToCodeableConcept(value);
                    return value;
                }
                case 3492561: {
                    this.race = this.castToCodeableConcept(value);
                    return value;
                }
                case -62715190: {
                    this.physiologicalCondition = this.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("age[x]")) {
                this.age = this.castToType(value);
            } else if (name.equals("gender")) {
                this.gender = this.castToCodeableConcept(value);
            } else if (name.equals("race")) {
                this.race = this.castToCodeableConcept(value);
            } else if (name.equals("physiologicalCondition")) {
                this.physiologicalCondition = this.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1419716831: {
                    return this.getAge();
                }
                case 96511: {
                    return this.getAge();
                }
                case -1249512767: {
                    return this.getGender();
                }
                case 3492561: {
                    return this.getRace();
                }
                case -62715190: {
                    return this.getPhysiologicalCondition();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 96511: {
                    return new String[]{"Range", "CodeableConcept"};
                }
                case -1249512767: {
                    return new String[]{"CodeableConcept"};
                }
                case 3492561: {
                    return new String[]{"CodeableConcept"};
                }
                case -62715190: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("ageRange")) {
                this.age = new Range();
                return this.age;
            }
            if (name.equals("ageCodeableConcept")) {
                this.age = new CodeableConcept();
                return this.age;
            }
            if (name.equals("gender")) {
                this.gender = new CodeableConcept();
                return this.gender;
            }
            if (name.equals("race")) {
                this.race = new CodeableConcept();
                return this.race;
            }
            if (name.equals("physiologicalCondition")) {
                this.physiologicalCondition = new CodeableConcept();
                return this.physiologicalCondition;
            }
            return super.addChild(name);
        }

        @Override
        public MedicinalProductClinicalsUndesirableEffectsPopulationComponent copy() {
            MedicinalProductClinicalsUndesirableEffectsPopulationComponent dst = new MedicinalProductClinicalsUndesirableEffectsPopulationComponent();
            this.copyValues(dst);
            dst.age = this.age == null ? null : this.age.copy();
            dst.gender = this.gender == null ? null : this.gender.copy();
            dst.race = this.race == null ? null : this.race.copy();
            dst.physiologicalCondition = this.physiologicalCondition == null ? null : this.physiologicalCondition.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductClinicalsUndesirableEffectsPopulationComponent)) {
                return false;
            }
            MedicinalProductClinicalsUndesirableEffectsPopulationComponent o = (MedicinalProductClinicalsUndesirableEffectsPopulationComponent)other_;
            return MedicinalProductClinicalsUndesirableEffectsPopulationComponent.compareDeep(this.age, o.age, true) && MedicinalProductClinicalsUndesirableEffectsPopulationComponent.compareDeep(this.gender, o.gender, true) && MedicinalProductClinicalsUndesirableEffectsPopulationComponent.compareDeep(this.race, o.race, true) && MedicinalProductClinicalsUndesirableEffectsPopulationComponent.compareDeep(this.physiologicalCondition, o.physiologicalCondition, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductClinicalsUndesirableEffectsPopulationComponent)) {
                return false;
            }
            MedicinalProductClinicalsUndesirableEffectsPopulationComponent o = (MedicinalProductClinicalsUndesirableEffectsPopulationComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.age, this.gender, this.race, this.physiologicalCondition});
        }

        @Override
        public String fhirType() {
            return "MedicinalProductClinicals.undesirableEffects.population";
        }
    }

    @Block
    public static class MedicinalProductClinicalsUndesirableEffectsComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="symptomConditionEffect", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The symptom, condition or undesirable effect", formalDefinition="The symptom, condition or undesirable effect.")
        protected CodeableConcept symptomConditionEffect;
        @Child(name="classification", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Classification of the effect", formalDefinition="Classification of the effect.")
        protected CodeableConcept classification;
        @Child(name="frequencyOfOccurrence", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The frequency of occurrence of the effect", formalDefinition="The frequency of occurrence of the effect.")
        protected CodeableConcept frequencyOfOccurrence;
        @Child(name="population", type={}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The population group to which this applies", formalDefinition="The population group to which this applies.")
        protected List<MedicinalProductClinicalsUndesirableEffectsPopulationComponent> population;
        private static final long serialVersionUID = 2112477180L;

        public CodeableConcept getSymptomConditionEffect() {
            if (this.symptomConditionEffect == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductClinicalsUndesirableEffectsComponent.symptomConditionEffect");
                }
                if (Configuration.doAutoCreate()) {
                    this.symptomConditionEffect = new CodeableConcept();
                }
            }
            return this.symptomConditionEffect;
        }

        public boolean hasSymptomConditionEffect() {
            return this.symptomConditionEffect != null && !this.symptomConditionEffect.isEmpty();
        }

        public MedicinalProductClinicalsUndesirableEffectsComponent setSymptomConditionEffect(CodeableConcept value) {
            this.symptomConditionEffect = value;
            return this;
        }

        public CodeableConcept getClassification() {
            if (this.classification == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductClinicalsUndesirableEffectsComponent.classification");
                }
                if (Configuration.doAutoCreate()) {
                    this.classification = new CodeableConcept();
                }
            }
            return this.classification;
        }

        public boolean hasClassification() {
            return this.classification != null && !this.classification.isEmpty();
        }

        public MedicinalProductClinicalsUndesirableEffectsComponent setClassification(CodeableConcept value) {
            this.classification = value;
            return this;
        }

        public CodeableConcept getFrequencyOfOccurrence() {
            if (this.frequencyOfOccurrence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductClinicalsUndesirableEffectsComponent.frequencyOfOccurrence");
                }
                if (Configuration.doAutoCreate()) {
                    this.frequencyOfOccurrence = new CodeableConcept();
                }
            }
            return this.frequencyOfOccurrence;
        }

        public boolean hasFrequencyOfOccurrence() {
            return this.frequencyOfOccurrence != null && !this.frequencyOfOccurrence.isEmpty();
        }

        public MedicinalProductClinicalsUndesirableEffectsComponent setFrequencyOfOccurrence(CodeableConcept value) {
            this.frequencyOfOccurrence = value;
            return this;
        }

        public List<MedicinalProductClinicalsUndesirableEffectsPopulationComponent> getPopulation() {
            if (this.population == null) {
                this.population = new ArrayList<MedicinalProductClinicalsUndesirableEffectsPopulationComponent>();
            }
            return this.population;
        }

        public MedicinalProductClinicalsUndesirableEffectsComponent setPopulation(List<MedicinalProductClinicalsUndesirableEffectsPopulationComponent> thePopulation) {
            this.population = thePopulation;
            return this;
        }

        public boolean hasPopulation() {
            if (this.population == null) {
                return false;
            }
            for (MedicinalProductClinicalsUndesirableEffectsPopulationComponent item : this.population) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MedicinalProductClinicalsUndesirableEffectsPopulationComponent addPopulation() {
            MedicinalProductClinicalsUndesirableEffectsPopulationComponent t = new MedicinalProductClinicalsUndesirableEffectsPopulationComponent();
            if (this.population == null) {
                this.population = new ArrayList<MedicinalProductClinicalsUndesirableEffectsPopulationComponent>();
            }
            this.population.add(t);
            return t;
        }

        public MedicinalProductClinicalsUndesirableEffectsComponent addPopulation(MedicinalProductClinicalsUndesirableEffectsPopulationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.population == null) {
                this.population = new ArrayList<MedicinalProductClinicalsUndesirableEffectsPopulationComponent>();
            }
            this.population.add(t);
            return this;
        }

        public MedicinalProductClinicalsUndesirableEffectsPopulationComponent getPopulationFirstRep() {
            if (this.getPopulation().isEmpty()) {
                this.addPopulation();
            }
            return this.getPopulation().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("symptomConditionEffect", "CodeableConcept", "The symptom, condition or undesirable effect.", 0, 1, this.symptomConditionEffect));
            children.add(new Property("classification", "CodeableConcept", "Classification of the effect.", 0, 1, this.classification));
            children.add(new Property("frequencyOfOccurrence", "CodeableConcept", "The frequency of occurrence of the effect.", 0, 1, this.frequencyOfOccurrence));
            children.add(new Property("population", "", "The population group to which this applies.", 0, Integer.MAX_VALUE, this.population));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -650549981: {
                    return new Property("symptomConditionEffect", "CodeableConcept", "The symptom, condition or undesirable effect.", 0, 1, this.symptomConditionEffect);
                }
                case 382350310: {
                    return new Property("classification", "CodeableConcept", "Classification of the effect.", 0, 1, this.classification);
                }
                case 791175812: {
                    return new Property("frequencyOfOccurrence", "CodeableConcept", "The frequency of occurrence of the effect.", 0, 1, this.frequencyOfOccurrence);
                }
                case -2023558323: {
                    return new Property("population", "", "The population group to which this applies.", 0, Integer.MAX_VALUE, this.population);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -650549981: {
                    Base[] baseArray;
                    if (this.symptomConditionEffect == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.symptomConditionEffect;
                    }
                    return baseArray;
                }
                case 382350310: {
                    Base[] baseArray;
                    if (this.classification == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.classification;
                    }
                    return baseArray;
                }
                case 791175812: {
                    Base[] baseArray;
                    if (this.frequencyOfOccurrence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.frequencyOfOccurrence;
                    }
                    return baseArray;
                }
                case -2023558323: {
                    return this.population == null ? new Base[]{} : this.population.toArray(new Base[this.population.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -650549981: {
                    this.symptomConditionEffect = this.castToCodeableConcept(value);
                    return value;
                }
                case 382350310: {
                    this.classification = this.castToCodeableConcept(value);
                    return value;
                }
                case 791175812: {
                    this.frequencyOfOccurrence = this.castToCodeableConcept(value);
                    return value;
                }
                case -2023558323: {
                    this.getPopulation().add((MedicinalProductClinicalsUndesirableEffectsPopulationComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("symptomConditionEffect")) {
                this.symptomConditionEffect = this.castToCodeableConcept(value);
            } else if (name.equals("classification")) {
                this.classification = this.castToCodeableConcept(value);
            } else if (name.equals("frequencyOfOccurrence")) {
                this.frequencyOfOccurrence = this.castToCodeableConcept(value);
            } else if (name.equals("population")) {
                this.getPopulation().add((MedicinalProductClinicalsUndesirableEffectsPopulationComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -650549981: {
                    return this.getSymptomConditionEffect();
                }
                case 382350310: {
                    return this.getClassification();
                }
                case 791175812: {
                    return this.getFrequencyOfOccurrence();
                }
                case -2023558323: {
                    return this.addPopulation();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -650549981: {
                    return new String[]{"CodeableConcept"};
                }
                case 382350310: {
                    return new String[]{"CodeableConcept"};
                }
                case 791175812: {
                    return new String[]{"CodeableConcept"};
                }
                case -2023558323: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("symptomConditionEffect")) {
                this.symptomConditionEffect = new CodeableConcept();
                return this.symptomConditionEffect;
            }
            if (name.equals("classification")) {
                this.classification = new CodeableConcept();
                return this.classification;
            }
            if (name.equals("frequencyOfOccurrence")) {
                this.frequencyOfOccurrence = new CodeableConcept();
                return this.frequencyOfOccurrence;
            }
            if (name.equals("population")) {
                return this.addPopulation();
            }
            return super.addChild(name);
        }

        @Override
        public MedicinalProductClinicalsUndesirableEffectsComponent copy() {
            MedicinalProductClinicalsUndesirableEffectsComponent dst = new MedicinalProductClinicalsUndesirableEffectsComponent();
            this.copyValues(dst);
            dst.symptomConditionEffect = this.symptomConditionEffect == null ? null : this.symptomConditionEffect.copy();
            dst.classification = this.classification == null ? null : this.classification.copy();
            CodeableConcept codeableConcept = dst.frequencyOfOccurrence = this.frequencyOfOccurrence == null ? null : this.frequencyOfOccurrence.copy();
            if (this.population != null) {
                dst.population = new ArrayList<MedicinalProductClinicalsUndesirableEffectsPopulationComponent>();
                for (MedicinalProductClinicalsUndesirableEffectsPopulationComponent i : this.population) {
                    dst.population.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductClinicalsUndesirableEffectsComponent)) {
                return false;
            }
            MedicinalProductClinicalsUndesirableEffectsComponent o = (MedicinalProductClinicalsUndesirableEffectsComponent)other_;
            return MedicinalProductClinicalsUndesirableEffectsComponent.compareDeep(this.symptomConditionEffect, o.symptomConditionEffect, true) && MedicinalProductClinicalsUndesirableEffectsComponent.compareDeep(this.classification, o.classification, true) && MedicinalProductClinicalsUndesirableEffectsComponent.compareDeep(this.frequencyOfOccurrence, o.frequencyOfOccurrence, true) && MedicinalProductClinicalsUndesirableEffectsComponent.compareDeep(this.population, o.population, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductClinicalsUndesirableEffectsComponent)) {
                return false;
            }
            MedicinalProductClinicalsUndesirableEffectsComponent o = (MedicinalProductClinicalsUndesirableEffectsComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.symptomConditionEffect, this.classification, this.frequencyOfOccurrence, this.population});
        }

        @Override
        public String fhirType() {
            return "MedicinalProductClinicals.undesirableEffects";
        }
    }
}

