/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DocumentReference;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.MedicinalProductAuthorization;
import org.hl7.fhir.r4.model.MedicinalProductClinicals;
import org.hl7.fhir.r4.model.MedicinalProductPackaged;
import org.hl7.fhir.r4.model.MedicinalProductPharmaceutical;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;

@ResourceDef(name="MedicinalProduct", profile="http://hl7.org/fhir/Profile/MedicinalProduct")
public class MedicinalProduct
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Business idenfifier for this product. Could be an MPID", formalDefinition="Business idenfifier for this product. Could be an MPID.")
    protected Identifier identifier;
    @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Regulatory type, e.g. Investigational or Authorized", formalDefinition="Regulatory type, e.g. Investigational or Authorized.")
    protected CodeableConcept type;
    @Child(name="combinedPharmaceuticalDoseForm", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The dose form for a single part product, or combined form of a multiple part product", formalDefinition="The dose form for a single part product, or combined form of a multiple part product.")
    protected CodeableConcept combinedPharmaceuticalDoseForm;
    @Child(name="additionalMonitoringIndicator", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Whether the Medicinal Product is subject to additional monitoring for regulatory reasons", formalDefinition="Whether the Medicinal Product is subject to additional monitoring for regulatory reasons.")
    protected CodeableConcept additionalMonitoringIndicator;
    @Child(name="specialMeasures", type={StringType.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Whether the Medicinal Product is subject to special measures for regulatory reasons", formalDefinition="Whether the Medicinal Product is subject to special measures for regulatory reasons.")
    protected List<StringType> specialMeasures;
    @Child(name="paediatricUseIndicator", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If authorised for use in children", formalDefinition="If authorised for use in children.")
    protected CodeableConcept paediatricUseIndicator;
    @Child(name="orphanDesignationStatus", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Indicates if the medicinal product has an orphan designation for the treatment of a rare disease", formalDefinition="Indicates if the medicinal product has an orphan designation for the treatment of a rare disease.")
    protected CodeableConcept orphanDesignationStatus;
    @Child(name="productClassification", type={CodeableConcept.class}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Allows the product to be classified by various systems", formalDefinition="Allows the product to be classified by various systems.")
    protected List<CodeableConcept> productClassification;
    @Child(name="marketingAuthorization", type={MedicinalProductAuthorization.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Product regulatory authorization", formalDefinition="Product regulatory authorization.")
    protected Reference marketingAuthorization;
    protected MedicinalProductAuthorization marketingAuthorizationTarget;
    @Child(name="packagedMedicinalProduct", type={MedicinalProductPackaged.class}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Package representation for the product", formalDefinition="Package representation for the product.")
    protected List<Reference> packagedMedicinalProduct;
    protected List<MedicinalProductPackaged> packagedMedicinalProductTarget;
    @Child(name="pharmaceuticalProduct", type={MedicinalProductPharmaceutical.class}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Pharmaceutical aspects of product", formalDefinition="Pharmaceutical aspects of product.")
    protected List<Reference> pharmaceuticalProduct;
    protected List<MedicinalProductPharmaceutical> pharmaceuticalProductTarget;
    @Child(name="clinicalParticulars", type={MedicinalProductClinicals.class}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Clinical particulars, indications etc.", formalDefinition="Clinical particulars, indications etc.")
    protected List<Reference> clinicalParticulars;
    protected List<MedicinalProductClinicals> clinicalParticularsTarget;
    @Child(name="attachedDocument", type={DocumentReference.class}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Supporting documentation, typically for regulatory submission", formalDefinition="Supporting documentation, typically for regulatory submission.")
    protected List<Reference> attachedDocument;
    protected List<DocumentReference> attachedDocumentTarget;
    @Child(name="masterFile", type={DocumentReference.class}, order=13, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A master file for to the medicinal product (e.g. Pharmacovigilance System Master File)", formalDefinition="A master file for to the medicinal product (e.g. Pharmacovigilance System Master File).")
    protected List<Reference> masterFile;
    protected List<DocumentReference> masterFileTarget;
    @Child(name="name", type={}, order=14, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The product's name, including full name and possibly coded parts", formalDefinition="The product's name, including full name and possibly coded parts.")
    protected List<MedicinalProductNameComponent> name;
    @Child(name="crossReference", type={Identifier.class}, order=15, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Reference to another product, e.g. for linking authorised to investigational product", formalDefinition="Reference to another product, e.g. for linking authorised to investigational product.")
    protected List<Identifier> crossReference;
    @Child(name="manufacturingBusinessOperation", type={}, order=16, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="An operation applied to the product, for manufacturing or adminsitrative purpose", formalDefinition="An operation applied to the product, for manufacturing or adminsitrative purpose.")
    protected List<MedicinalProductManufacturingBusinessOperationComponent> manufacturingBusinessOperation;
    private static final long serialVersionUID = -1694141448L;

    public MedicinalProduct() {
    }

    public MedicinalProduct(Identifier identifier) {
        this.identifier = identifier;
    }

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProduct.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public MedicinalProduct setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProduct.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public MedicinalProduct setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public CodeableConcept getCombinedPharmaceuticalDoseForm() {
        if (this.combinedPharmaceuticalDoseForm == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProduct.combinedPharmaceuticalDoseForm");
            }
            if (Configuration.doAutoCreate()) {
                this.combinedPharmaceuticalDoseForm = new CodeableConcept();
            }
        }
        return this.combinedPharmaceuticalDoseForm;
    }

    public boolean hasCombinedPharmaceuticalDoseForm() {
        return this.combinedPharmaceuticalDoseForm != null && !this.combinedPharmaceuticalDoseForm.isEmpty();
    }

    public MedicinalProduct setCombinedPharmaceuticalDoseForm(CodeableConcept value) {
        this.combinedPharmaceuticalDoseForm = value;
        return this;
    }

    public CodeableConcept getAdditionalMonitoringIndicator() {
        if (this.additionalMonitoringIndicator == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProduct.additionalMonitoringIndicator");
            }
            if (Configuration.doAutoCreate()) {
                this.additionalMonitoringIndicator = new CodeableConcept();
            }
        }
        return this.additionalMonitoringIndicator;
    }

    public boolean hasAdditionalMonitoringIndicator() {
        return this.additionalMonitoringIndicator != null && !this.additionalMonitoringIndicator.isEmpty();
    }

    public MedicinalProduct setAdditionalMonitoringIndicator(CodeableConcept value) {
        this.additionalMonitoringIndicator = value;
        return this;
    }

    public List<StringType> getSpecialMeasures() {
        if (this.specialMeasures == null) {
            this.specialMeasures = new ArrayList<StringType>();
        }
        return this.specialMeasures;
    }

    public MedicinalProduct setSpecialMeasures(List<StringType> theSpecialMeasures) {
        this.specialMeasures = theSpecialMeasures;
        return this;
    }

    public boolean hasSpecialMeasures() {
        if (this.specialMeasures == null) {
            return false;
        }
        for (StringType item : this.specialMeasures) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addSpecialMeasuresElement() {
        StringType t = new StringType();
        if (this.specialMeasures == null) {
            this.specialMeasures = new ArrayList<StringType>();
        }
        this.specialMeasures.add(t);
        return t;
    }

    public MedicinalProduct addSpecialMeasures(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.specialMeasures == null) {
            this.specialMeasures = new ArrayList<StringType>();
        }
        this.specialMeasures.add(t);
        return this;
    }

    public boolean hasSpecialMeasures(String value) {
        if (this.specialMeasures == null) {
            return false;
        }
        for (StringType v : this.specialMeasures) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept getPaediatricUseIndicator() {
        if (this.paediatricUseIndicator == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProduct.paediatricUseIndicator");
            }
            if (Configuration.doAutoCreate()) {
                this.paediatricUseIndicator = new CodeableConcept();
            }
        }
        return this.paediatricUseIndicator;
    }

    public boolean hasPaediatricUseIndicator() {
        return this.paediatricUseIndicator != null && !this.paediatricUseIndicator.isEmpty();
    }

    public MedicinalProduct setPaediatricUseIndicator(CodeableConcept value) {
        this.paediatricUseIndicator = value;
        return this;
    }

    public CodeableConcept getOrphanDesignationStatus() {
        if (this.orphanDesignationStatus == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProduct.orphanDesignationStatus");
            }
            if (Configuration.doAutoCreate()) {
                this.orphanDesignationStatus = new CodeableConcept();
            }
        }
        return this.orphanDesignationStatus;
    }

    public boolean hasOrphanDesignationStatus() {
        return this.orphanDesignationStatus != null && !this.orphanDesignationStatus.isEmpty();
    }

    public MedicinalProduct setOrphanDesignationStatus(CodeableConcept value) {
        this.orphanDesignationStatus = value;
        return this;
    }

    public List<CodeableConcept> getProductClassification() {
        if (this.productClassification == null) {
            this.productClassification = new ArrayList<CodeableConcept>();
        }
        return this.productClassification;
    }

    public MedicinalProduct setProductClassification(List<CodeableConcept> theProductClassification) {
        this.productClassification = theProductClassification;
        return this;
    }

    public boolean hasProductClassification() {
        if (this.productClassification == null) {
            return false;
        }
        for (CodeableConcept item : this.productClassification) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addProductClassification() {
        CodeableConcept t = new CodeableConcept();
        if (this.productClassification == null) {
            this.productClassification = new ArrayList<CodeableConcept>();
        }
        this.productClassification.add(t);
        return t;
    }

    public MedicinalProduct addProductClassification(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.productClassification == null) {
            this.productClassification = new ArrayList<CodeableConcept>();
        }
        this.productClassification.add(t);
        return this;
    }

    public CodeableConcept getProductClassificationFirstRep() {
        if (this.getProductClassification().isEmpty()) {
            this.addProductClassification();
        }
        return this.getProductClassification().get(0);
    }

    public Reference getMarketingAuthorization() {
        if (this.marketingAuthorization == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProduct.marketingAuthorization");
            }
            if (Configuration.doAutoCreate()) {
                this.marketingAuthorization = new Reference();
            }
        }
        return this.marketingAuthorization;
    }

    public boolean hasMarketingAuthorization() {
        return this.marketingAuthorization != null && !this.marketingAuthorization.isEmpty();
    }

    public MedicinalProduct setMarketingAuthorization(Reference value) {
        this.marketingAuthorization = value;
        return this;
    }

    public MedicinalProductAuthorization getMarketingAuthorizationTarget() {
        if (this.marketingAuthorizationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProduct.marketingAuthorization");
            }
            if (Configuration.doAutoCreate()) {
                this.marketingAuthorizationTarget = new MedicinalProductAuthorization();
            }
        }
        return this.marketingAuthorizationTarget;
    }

    public MedicinalProduct setMarketingAuthorizationTarget(MedicinalProductAuthorization value) {
        this.marketingAuthorizationTarget = value;
        return this;
    }

    public List<Reference> getPackagedMedicinalProduct() {
        if (this.packagedMedicinalProduct == null) {
            this.packagedMedicinalProduct = new ArrayList<Reference>();
        }
        return this.packagedMedicinalProduct;
    }

    public MedicinalProduct setPackagedMedicinalProduct(List<Reference> thePackagedMedicinalProduct) {
        this.packagedMedicinalProduct = thePackagedMedicinalProduct;
        return this;
    }

    public boolean hasPackagedMedicinalProduct() {
        if (this.packagedMedicinalProduct == null) {
            return false;
        }
        for (Reference item : this.packagedMedicinalProduct) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPackagedMedicinalProduct() {
        Reference t = new Reference();
        if (this.packagedMedicinalProduct == null) {
            this.packagedMedicinalProduct = new ArrayList<Reference>();
        }
        this.packagedMedicinalProduct.add(t);
        return t;
    }

    public MedicinalProduct addPackagedMedicinalProduct(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.packagedMedicinalProduct == null) {
            this.packagedMedicinalProduct = new ArrayList<Reference>();
        }
        this.packagedMedicinalProduct.add(t);
        return this;
    }

    public Reference getPackagedMedicinalProductFirstRep() {
        if (this.getPackagedMedicinalProduct().isEmpty()) {
            this.addPackagedMedicinalProduct();
        }
        return this.getPackagedMedicinalProduct().get(0);
    }

    @Deprecated
    public List<MedicinalProductPackaged> getPackagedMedicinalProductTarget() {
        if (this.packagedMedicinalProductTarget == null) {
            this.packagedMedicinalProductTarget = new ArrayList<MedicinalProductPackaged>();
        }
        return this.packagedMedicinalProductTarget;
    }

    @Deprecated
    public MedicinalProductPackaged addPackagedMedicinalProductTarget() {
        MedicinalProductPackaged r = new MedicinalProductPackaged();
        if (this.packagedMedicinalProductTarget == null) {
            this.packagedMedicinalProductTarget = new ArrayList<MedicinalProductPackaged>();
        }
        this.packagedMedicinalProductTarget.add(r);
        return r;
    }

    public List<Reference> getPharmaceuticalProduct() {
        if (this.pharmaceuticalProduct == null) {
            this.pharmaceuticalProduct = new ArrayList<Reference>();
        }
        return this.pharmaceuticalProduct;
    }

    public MedicinalProduct setPharmaceuticalProduct(List<Reference> thePharmaceuticalProduct) {
        this.pharmaceuticalProduct = thePharmaceuticalProduct;
        return this;
    }

    public boolean hasPharmaceuticalProduct() {
        if (this.pharmaceuticalProduct == null) {
            return false;
        }
        for (Reference item : this.pharmaceuticalProduct) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPharmaceuticalProduct() {
        Reference t = new Reference();
        if (this.pharmaceuticalProduct == null) {
            this.pharmaceuticalProduct = new ArrayList<Reference>();
        }
        this.pharmaceuticalProduct.add(t);
        return t;
    }

    public MedicinalProduct addPharmaceuticalProduct(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.pharmaceuticalProduct == null) {
            this.pharmaceuticalProduct = new ArrayList<Reference>();
        }
        this.pharmaceuticalProduct.add(t);
        return this;
    }

    public Reference getPharmaceuticalProductFirstRep() {
        if (this.getPharmaceuticalProduct().isEmpty()) {
            this.addPharmaceuticalProduct();
        }
        return this.getPharmaceuticalProduct().get(0);
    }

    @Deprecated
    public List<MedicinalProductPharmaceutical> getPharmaceuticalProductTarget() {
        if (this.pharmaceuticalProductTarget == null) {
            this.pharmaceuticalProductTarget = new ArrayList<MedicinalProductPharmaceutical>();
        }
        return this.pharmaceuticalProductTarget;
    }

    @Deprecated
    public MedicinalProductPharmaceutical addPharmaceuticalProductTarget() {
        MedicinalProductPharmaceutical r = new MedicinalProductPharmaceutical();
        if (this.pharmaceuticalProductTarget == null) {
            this.pharmaceuticalProductTarget = new ArrayList<MedicinalProductPharmaceutical>();
        }
        this.pharmaceuticalProductTarget.add(r);
        return r;
    }

    public List<Reference> getClinicalParticulars() {
        if (this.clinicalParticulars == null) {
            this.clinicalParticulars = new ArrayList<Reference>();
        }
        return this.clinicalParticulars;
    }

    public MedicinalProduct setClinicalParticulars(List<Reference> theClinicalParticulars) {
        this.clinicalParticulars = theClinicalParticulars;
        return this;
    }

    public boolean hasClinicalParticulars() {
        if (this.clinicalParticulars == null) {
            return false;
        }
        for (Reference item : this.clinicalParticulars) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addClinicalParticulars() {
        Reference t = new Reference();
        if (this.clinicalParticulars == null) {
            this.clinicalParticulars = new ArrayList<Reference>();
        }
        this.clinicalParticulars.add(t);
        return t;
    }

    public MedicinalProduct addClinicalParticulars(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.clinicalParticulars == null) {
            this.clinicalParticulars = new ArrayList<Reference>();
        }
        this.clinicalParticulars.add(t);
        return this;
    }

    public Reference getClinicalParticularsFirstRep() {
        if (this.getClinicalParticulars().isEmpty()) {
            this.addClinicalParticulars();
        }
        return this.getClinicalParticulars().get(0);
    }

    @Deprecated
    public List<MedicinalProductClinicals> getClinicalParticularsTarget() {
        if (this.clinicalParticularsTarget == null) {
            this.clinicalParticularsTarget = new ArrayList<MedicinalProductClinicals>();
        }
        return this.clinicalParticularsTarget;
    }

    @Deprecated
    public MedicinalProductClinicals addClinicalParticularsTarget() {
        MedicinalProductClinicals r = new MedicinalProductClinicals();
        if (this.clinicalParticularsTarget == null) {
            this.clinicalParticularsTarget = new ArrayList<MedicinalProductClinicals>();
        }
        this.clinicalParticularsTarget.add(r);
        return r;
    }

    public List<Reference> getAttachedDocument() {
        if (this.attachedDocument == null) {
            this.attachedDocument = new ArrayList<Reference>();
        }
        return this.attachedDocument;
    }

    public MedicinalProduct setAttachedDocument(List<Reference> theAttachedDocument) {
        this.attachedDocument = theAttachedDocument;
        return this;
    }

    public boolean hasAttachedDocument() {
        if (this.attachedDocument == null) {
            return false;
        }
        for (Reference item : this.attachedDocument) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addAttachedDocument() {
        Reference t = new Reference();
        if (this.attachedDocument == null) {
            this.attachedDocument = new ArrayList<Reference>();
        }
        this.attachedDocument.add(t);
        return t;
    }

    public MedicinalProduct addAttachedDocument(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.attachedDocument == null) {
            this.attachedDocument = new ArrayList<Reference>();
        }
        this.attachedDocument.add(t);
        return this;
    }

    public Reference getAttachedDocumentFirstRep() {
        if (this.getAttachedDocument().isEmpty()) {
            this.addAttachedDocument();
        }
        return this.getAttachedDocument().get(0);
    }

    @Deprecated
    public List<DocumentReference> getAttachedDocumentTarget() {
        if (this.attachedDocumentTarget == null) {
            this.attachedDocumentTarget = new ArrayList<DocumentReference>();
        }
        return this.attachedDocumentTarget;
    }

    @Deprecated
    public DocumentReference addAttachedDocumentTarget() {
        DocumentReference r = new DocumentReference();
        if (this.attachedDocumentTarget == null) {
            this.attachedDocumentTarget = new ArrayList<DocumentReference>();
        }
        this.attachedDocumentTarget.add(r);
        return r;
    }

    public List<Reference> getMasterFile() {
        if (this.masterFile == null) {
            this.masterFile = new ArrayList<Reference>();
        }
        return this.masterFile;
    }

    public MedicinalProduct setMasterFile(List<Reference> theMasterFile) {
        this.masterFile = theMasterFile;
        return this;
    }

    public boolean hasMasterFile() {
        if (this.masterFile == null) {
            return false;
        }
        for (Reference item : this.masterFile) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addMasterFile() {
        Reference t = new Reference();
        if (this.masterFile == null) {
            this.masterFile = new ArrayList<Reference>();
        }
        this.masterFile.add(t);
        return t;
    }

    public MedicinalProduct addMasterFile(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.masterFile == null) {
            this.masterFile = new ArrayList<Reference>();
        }
        this.masterFile.add(t);
        return this;
    }

    public Reference getMasterFileFirstRep() {
        if (this.getMasterFile().isEmpty()) {
            this.addMasterFile();
        }
        return this.getMasterFile().get(0);
    }

    @Deprecated
    public List<DocumentReference> getMasterFileTarget() {
        if (this.masterFileTarget == null) {
            this.masterFileTarget = new ArrayList<DocumentReference>();
        }
        return this.masterFileTarget;
    }

    @Deprecated
    public DocumentReference addMasterFileTarget() {
        DocumentReference r = new DocumentReference();
        if (this.masterFileTarget == null) {
            this.masterFileTarget = new ArrayList<DocumentReference>();
        }
        this.masterFileTarget.add(r);
        return r;
    }

    public List<MedicinalProductNameComponent> getName() {
        if (this.name == null) {
            this.name = new ArrayList<MedicinalProductNameComponent>();
        }
        return this.name;
    }

    public MedicinalProduct setName(List<MedicinalProductNameComponent> theName) {
        this.name = theName;
        return this;
    }

    public boolean hasName() {
        if (this.name == null) {
            return false;
        }
        for (MedicinalProductNameComponent item : this.name) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicinalProductNameComponent addName() {
        MedicinalProductNameComponent t = new MedicinalProductNameComponent();
        if (this.name == null) {
            this.name = new ArrayList<MedicinalProductNameComponent>();
        }
        this.name.add(t);
        return t;
    }

    public MedicinalProduct addName(MedicinalProductNameComponent t) {
        if (t == null) {
            return this;
        }
        if (this.name == null) {
            this.name = new ArrayList<MedicinalProductNameComponent>();
        }
        this.name.add(t);
        return this;
    }

    public MedicinalProductNameComponent getNameFirstRep() {
        if (this.getName().isEmpty()) {
            this.addName();
        }
        return this.getName().get(0);
    }

    public List<Identifier> getCrossReference() {
        if (this.crossReference == null) {
            this.crossReference = new ArrayList<Identifier>();
        }
        return this.crossReference;
    }

    public MedicinalProduct setCrossReference(List<Identifier> theCrossReference) {
        this.crossReference = theCrossReference;
        return this;
    }

    public boolean hasCrossReference() {
        if (this.crossReference == null) {
            return false;
        }
        for (Identifier item : this.crossReference) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addCrossReference() {
        Identifier t = new Identifier();
        if (this.crossReference == null) {
            this.crossReference = new ArrayList<Identifier>();
        }
        this.crossReference.add(t);
        return t;
    }

    public MedicinalProduct addCrossReference(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.crossReference == null) {
            this.crossReference = new ArrayList<Identifier>();
        }
        this.crossReference.add(t);
        return this;
    }

    public Identifier getCrossReferenceFirstRep() {
        if (this.getCrossReference().isEmpty()) {
            this.addCrossReference();
        }
        return this.getCrossReference().get(0);
    }

    public List<MedicinalProductManufacturingBusinessOperationComponent> getManufacturingBusinessOperation() {
        if (this.manufacturingBusinessOperation == null) {
            this.manufacturingBusinessOperation = new ArrayList<MedicinalProductManufacturingBusinessOperationComponent>();
        }
        return this.manufacturingBusinessOperation;
    }

    public MedicinalProduct setManufacturingBusinessOperation(List<MedicinalProductManufacturingBusinessOperationComponent> theManufacturingBusinessOperation) {
        this.manufacturingBusinessOperation = theManufacturingBusinessOperation;
        return this;
    }

    public boolean hasManufacturingBusinessOperation() {
        if (this.manufacturingBusinessOperation == null) {
            return false;
        }
        for (MedicinalProductManufacturingBusinessOperationComponent item : this.manufacturingBusinessOperation) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicinalProductManufacturingBusinessOperationComponent addManufacturingBusinessOperation() {
        MedicinalProductManufacturingBusinessOperationComponent t = new MedicinalProductManufacturingBusinessOperationComponent();
        if (this.manufacturingBusinessOperation == null) {
            this.manufacturingBusinessOperation = new ArrayList<MedicinalProductManufacturingBusinessOperationComponent>();
        }
        this.manufacturingBusinessOperation.add(t);
        return t;
    }

    public MedicinalProduct addManufacturingBusinessOperation(MedicinalProductManufacturingBusinessOperationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.manufacturingBusinessOperation == null) {
            this.manufacturingBusinessOperation = new ArrayList<MedicinalProductManufacturingBusinessOperationComponent>();
        }
        this.manufacturingBusinessOperation.add(t);
        return this;
    }

    public MedicinalProductManufacturingBusinessOperationComponent getManufacturingBusinessOperationFirstRep() {
        if (this.getManufacturingBusinessOperation().isEmpty()) {
            this.addManufacturingBusinessOperation();
        }
        return this.getManufacturingBusinessOperation().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("identifier", "Identifier", "Business idenfifier for this product. Could be an MPID.", 0, 1, this.identifier));
        children.add(new Property("type", "CodeableConcept", "Regulatory type, e.g. Investigational or Authorized.", 0, 1, this.type));
        children.add(new Property("combinedPharmaceuticalDoseForm", "CodeableConcept", "The dose form for a single part product, or combined form of a multiple part product.", 0, 1, this.combinedPharmaceuticalDoseForm));
        children.add(new Property("additionalMonitoringIndicator", "CodeableConcept", "Whether the Medicinal Product is subject to additional monitoring for regulatory reasons.", 0, 1, this.additionalMonitoringIndicator));
        children.add(new Property("specialMeasures", "string", "Whether the Medicinal Product is subject to special measures for regulatory reasons.", 0, Integer.MAX_VALUE, this.specialMeasures));
        children.add(new Property("paediatricUseIndicator", "CodeableConcept", "If authorised for use in children.", 0, 1, this.paediatricUseIndicator));
        children.add(new Property("orphanDesignationStatus", "CodeableConcept", "Indicates if the medicinal product has an orphan designation for the treatment of a rare disease.", 0, 1, this.orphanDesignationStatus));
        children.add(new Property("productClassification", "CodeableConcept", "Allows the product to be classified by various systems.", 0, Integer.MAX_VALUE, this.productClassification));
        children.add(new Property("marketingAuthorization", "Reference(MedicinalProductAuthorization)", "Product regulatory authorization.", 0, 1, this.marketingAuthorization));
        children.add(new Property("packagedMedicinalProduct", "Reference(MedicinalProductPackaged)", "Package representation for the product.", 0, Integer.MAX_VALUE, this.packagedMedicinalProduct));
        children.add(new Property("pharmaceuticalProduct", "Reference(MedicinalProductPharmaceutical)", "Pharmaceutical aspects of product.", 0, Integer.MAX_VALUE, this.pharmaceuticalProduct));
        children.add(new Property("clinicalParticulars", "Reference(MedicinalProductClinicals)", "Clinical particulars, indications etc.", 0, Integer.MAX_VALUE, this.clinicalParticulars));
        children.add(new Property("attachedDocument", "Reference(DocumentReference)", "Supporting documentation, typically for regulatory submission.", 0, Integer.MAX_VALUE, this.attachedDocument));
        children.add(new Property("masterFile", "Reference(DocumentReference)", "A master file for to the medicinal product (e.g. Pharmacovigilance System Master File).", 0, Integer.MAX_VALUE, this.masterFile));
        children.add(new Property("name", "", "The product's name, including full name and possibly coded parts.", 0, Integer.MAX_VALUE, this.name));
        children.add(new Property("crossReference", "Identifier", "Reference to another product, e.g. for linking authorised to investigational product.", 0, Integer.MAX_VALUE, this.crossReference));
        children.add(new Property("manufacturingBusinessOperation", "", "An operation applied to the product, for manufacturing or adminsitrative purpose.", 0, Integer.MAX_VALUE, this.manufacturingBusinessOperation));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property("identifier", "Identifier", "Business idenfifier for this product. Could be an MPID.", 0, 1, this.identifier);
            }
            case 3575610: {
                return new Property("type", "CodeableConcept", "Regulatory type, e.g. Investigational or Authorized.", 0, 1, this.type);
            }
            case -1992898487: {
                return new Property("combinedPharmaceuticalDoseForm", "CodeableConcept", "The dose form for a single part product, or combined form of a multiple part product.", 0, 1, this.combinedPharmaceuticalDoseForm);
            }
            case 1935999744: {
                return new Property("additionalMonitoringIndicator", "CodeableConcept", "Whether the Medicinal Product is subject to additional monitoring for regulatory reasons.", 0, 1, this.additionalMonitoringIndicator);
            }
            case 975102638: {
                return new Property("specialMeasures", "string", "Whether the Medicinal Product is subject to special measures for regulatory reasons.", 0, Integer.MAX_VALUE, this.specialMeasures);
            }
            case -1019867160: {
                return new Property("paediatricUseIndicator", "CodeableConcept", "If authorised for use in children.", 0, 1, this.paediatricUseIndicator);
            }
            case 201000737: {
                return new Property("orphanDesignationStatus", "CodeableConcept", "Indicates if the medicinal product has an orphan designation for the treatment of a rare disease.", 0, 1, this.orphanDesignationStatus);
            }
            case 1247936181: {
                return new Property("productClassification", "CodeableConcept", "Allows the product to be classified by various systems.", 0, Integer.MAX_VALUE, this.productClassification);
            }
            case 571831283: {
                return new Property("marketingAuthorization", "Reference(MedicinalProductAuthorization)", "Product regulatory authorization.", 0, 1, this.marketingAuthorization);
            }
            case -361025513: {
                return new Property("packagedMedicinalProduct", "Reference(MedicinalProductPackaged)", "Package representation for the product.", 0, Integer.MAX_VALUE, this.packagedMedicinalProduct);
            }
            case 443273260: {
                return new Property("pharmaceuticalProduct", "Reference(MedicinalProductPharmaceutical)", "Pharmaceutical aspects of product.", 0, Integer.MAX_VALUE, this.pharmaceuticalProduct);
            }
            case -588103893: {
                return new Property("clinicalParticulars", "Reference(MedicinalProductClinicals)", "Clinical particulars, indications etc.", 0, Integer.MAX_VALUE, this.clinicalParticulars);
            }
            case -513945889: {
                return new Property("attachedDocument", "Reference(DocumentReference)", "Supporting documentation, typically for regulatory submission.", 0, Integer.MAX_VALUE, this.attachedDocument);
            }
            case -2039573762: {
                return new Property("masterFile", "Reference(DocumentReference)", "A master file for to the medicinal product (e.g. Pharmacovigilance System Master File).", 0, Integer.MAX_VALUE, this.masterFile);
            }
            case 3373707: {
                return new Property("name", "", "The product's name, including full name and possibly coded parts.", 0, Integer.MAX_VALUE, this.name);
            }
            case -986968341: {
                return new Property("crossReference", "Identifier", "Reference to another product, e.g. for linking authorised to investigational product.", 0, Integer.MAX_VALUE, this.crossReference);
            }
            case -171103255: {
                return new Property("manufacturingBusinessOperation", "", "An operation applied to the product, for manufacturing or adminsitrative purpose.", 0, Integer.MAX_VALUE, this.manufacturingBusinessOperation);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.identifier;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.type;
                }
                return baseArray;
            }
            case -1992898487: {
                Base[] baseArray;
                if (this.combinedPharmaceuticalDoseForm == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.combinedPharmaceuticalDoseForm;
                }
                return baseArray;
            }
            case 1935999744: {
                Base[] baseArray;
                if (this.additionalMonitoringIndicator == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.additionalMonitoringIndicator;
                }
                return baseArray;
            }
            case 975102638: {
                return this.specialMeasures == null ? new Base[]{} : this.specialMeasures.toArray(new Base[this.specialMeasures.size()]);
            }
            case -1019867160: {
                Base[] baseArray;
                if (this.paediatricUseIndicator == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.paediatricUseIndicator;
                }
                return baseArray;
            }
            case 201000737: {
                Base[] baseArray;
                if (this.orphanDesignationStatus == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.orphanDesignationStatus;
                }
                return baseArray;
            }
            case 1247936181: {
                return this.productClassification == null ? new Base[]{} : this.productClassification.toArray(new Base[this.productClassification.size()]);
            }
            case 571831283: {
                Base[] baseArray;
                if (this.marketingAuthorization == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.marketingAuthorization;
                }
                return baseArray;
            }
            case -361025513: {
                return this.packagedMedicinalProduct == null ? new Base[]{} : this.packagedMedicinalProduct.toArray(new Base[this.packagedMedicinalProduct.size()]);
            }
            case 443273260: {
                return this.pharmaceuticalProduct == null ? new Base[]{} : this.pharmaceuticalProduct.toArray(new Base[this.pharmaceuticalProduct.size()]);
            }
            case -588103893: {
                return this.clinicalParticulars == null ? new Base[]{} : this.clinicalParticulars.toArray(new Base[this.clinicalParticulars.size()]);
            }
            case -513945889: {
                return this.attachedDocument == null ? new Base[]{} : this.attachedDocument.toArray(new Base[this.attachedDocument.size()]);
            }
            case -2039573762: {
                return this.masterFile == null ? new Base[]{} : this.masterFile.toArray(new Base[this.masterFile.size()]);
            }
            case 3373707: {
                return this.name == null ? new Base[]{} : this.name.toArray(new Base[this.name.size()]);
            }
            case -986968341: {
                return this.crossReference == null ? new Base[]{} : this.crossReference.toArray(new Base[this.crossReference.size()]);
            }
            case -171103255: {
                return this.manufacturingBusinessOperation == null ? new Base[]{} : this.manufacturingBusinessOperation.toArray(new Base[this.manufacturingBusinessOperation.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.identifier = this.castToIdentifier(value);
                return value;
            }
            case 3575610: {
                this.type = this.castToCodeableConcept(value);
                return value;
            }
            case -1992898487: {
                this.combinedPharmaceuticalDoseForm = this.castToCodeableConcept(value);
                return value;
            }
            case 1935999744: {
                this.additionalMonitoringIndicator = this.castToCodeableConcept(value);
                return value;
            }
            case 975102638: {
                this.getSpecialMeasures().add(this.castToString(value));
                return value;
            }
            case -1019867160: {
                this.paediatricUseIndicator = this.castToCodeableConcept(value);
                return value;
            }
            case 201000737: {
                this.orphanDesignationStatus = this.castToCodeableConcept(value);
                return value;
            }
            case 1247936181: {
                this.getProductClassification().add(this.castToCodeableConcept(value));
                return value;
            }
            case 571831283: {
                this.marketingAuthorization = this.castToReference(value);
                return value;
            }
            case -361025513: {
                this.getPackagedMedicinalProduct().add(this.castToReference(value));
                return value;
            }
            case 443273260: {
                this.getPharmaceuticalProduct().add(this.castToReference(value));
                return value;
            }
            case -588103893: {
                this.getClinicalParticulars().add(this.castToReference(value));
                return value;
            }
            case -513945889: {
                this.getAttachedDocument().add(this.castToReference(value));
                return value;
            }
            case -2039573762: {
                this.getMasterFile().add(this.castToReference(value));
                return value;
            }
            case 3373707: {
                this.getName().add((MedicinalProductNameComponent)value);
                return value;
            }
            case -986968341: {
                this.getCrossReference().add(this.castToIdentifier(value));
                return value;
            }
            case -171103255: {
                this.getManufacturingBusinessOperation().add((MedicinalProductManufacturingBusinessOperationComponent)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("identifier")) {
            this.identifier = this.castToIdentifier(value);
        } else if (name.equals("type")) {
            this.type = this.castToCodeableConcept(value);
        } else if (name.equals("combinedPharmaceuticalDoseForm")) {
            this.combinedPharmaceuticalDoseForm = this.castToCodeableConcept(value);
        } else if (name.equals("additionalMonitoringIndicator")) {
            this.additionalMonitoringIndicator = this.castToCodeableConcept(value);
        } else if (name.equals("specialMeasures")) {
            this.getSpecialMeasures().add(this.castToString(value));
        } else if (name.equals("paediatricUseIndicator")) {
            this.paediatricUseIndicator = this.castToCodeableConcept(value);
        } else if (name.equals("orphanDesignationStatus")) {
            this.orphanDesignationStatus = this.castToCodeableConcept(value);
        } else if (name.equals("productClassification")) {
            this.getProductClassification().add(this.castToCodeableConcept(value));
        } else if (name.equals("marketingAuthorization")) {
            this.marketingAuthorization = this.castToReference(value);
        } else if (name.equals("packagedMedicinalProduct")) {
            this.getPackagedMedicinalProduct().add(this.castToReference(value));
        } else if (name.equals("pharmaceuticalProduct")) {
            this.getPharmaceuticalProduct().add(this.castToReference(value));
        } else if (name.equals("clinicalParticulars")) {
            this.getClinicalParticulars().add(this.castToReference(value));
        } else if (name.equals("attachedDocument")) {
            this.getAttachedDocument().add(this.castToReference(value));
        } else if (name.equals("masterFile")) {
            this.getMasterFile().add(this.castToReference(value));
        } else if (name.equals("name")) {
            this.getName().add((MedicinalProductNameComponent)value);
        } else if (name.equals("crossReference")) {
            this.getCrossReference().add(this.castToIdentifier(value));
        } else if (name.equals("manufacturingBusinessOperation")) {
            this.getManufacturingBusinessOperation().add((MedicinalProductManufacturingBusinessOperationComponent)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.getIdentifier();
            }
            case 3575610: {
                return this.getType();
            }
            case -1992898487: {
                return this.getCombinedPharmaceuticalDoseForm();
            }
            case 1935999744: {
                return this.getAdditionalMonitoringIndicator();
            }
            case 975102638: {
                return this.addSpecialMeasuresElement();
            }
            case -1019867160: {
                return this.getPaediatricUseIndicator();
            }
            case 201000737: {
                return this.getOrphanDesignationStatus();
            }
            case 1247936181: {
                return this.addProductClassification();
            }
            case 571831283: {
                return this.getMarketingAuthorization();
            }
            case -361025513: {
                return this.addPackagedMedicinalProduct();
            }
            case 443273260: {
                return this.addPharmaceuticalProduct();
            }
            case -588103893: {
                return this.addClinicalParticulars();
            }
            case -513945889: {
                return this.addAttachedDocument();
            }
            case -2039573762: {
                return this.addMasterFile();
            }
            case 3373707: {
                return this.addName();
            }
            case -986968341: {
                return this.addCrossReference();
            }
            case -171103255: {
                return this.addManufacturingBusinessOperation();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case -1992898487: {
                return new String[]{"CodeableConcept"};
            }
            case 1935999744: {
                return new String[]{"CodeableConcept"};
            }
            case 975102638: {
                return new String[]{"string"};
            }
            case -1019867160: {
                return new String[]{"CodeableConcept"};
            }
            case 201000737: {
                return new String[]{"CodeableConcept"};
            }
            case 1247936181: {
                return new String[]{"CodeableConcept"};
            }
            case 571831283: {
                return new String[]{"Reference"};
            }
            case -361025513: {
                return new String[]{"Reference"};
            }
            case 443273260: {
                return new String[]{"Reference"};
            }
            case -588103893: {
                return new String[]{"Reference"};
            }
            case -513945889: {
                return new String[]{"Reference"};
            }
            case -2039573762: {
                return new String[]{"Reference"};
            }
            case 3373707: {
                return new String[0];
            }
            case -986968341: {
                return new String[]{"Identifier"};
            }
            case -171103255: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("identifier")) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals("type")) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals("combinedPharmaceuticalDoseForm")) {
            this.combinedPharmaceuticalDoseForm = new CodeableConcept();
            return this.combinedPharmaceuticalDoseForm;
        }
        if (name.equals("additionalMonitoringIndicator")) {
            this.additionalMonitoringIndicator = new CodeableConcept();
            return this.additionalMonitoringIndicator;
        }
        if (name.equals("specialMeasures")) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicinalProduct.specialMeasures");
        }
        if (name.equals("paediatricUseIndicator")) {
            this.paediatricUseIndicator = new CodeableConcept();
            return this.paediatricUseIndicator;
        }
        if (name.equals("orphanDesignationStatus")) {
            this.orphanDesignationStatus = new CodeableConcept();
            return this.orphanDesignationStatus;
        }
        if (name.equals("productClassification")) {
            return this.addProductClassification();
        }
        if (name.equals("marketingAuthorization")) {
            this.marketingAuthorization = new Reference();
            return this.marketingAuthorization;
        }
        if (name.equals("packagedMedicinalProduct")) {
            return this.addPackagedMedicinalProduct();
        }
        if (name.equals("pharmaceuticalProduct")) {
            return this.addPharmaceuticalProduct();
        }
        if (name.equals("clinicalParticulars")) {
            return this.addClinicalParticulars();
        }
        if (name.equals("attachedDocument")) {
            return this.addAttachedDocument();
        }
        if (name.equals("masterFile")) {
            return this.addMasterFile();
        }
        if (name.equals("name")) {
            return this.addName();
        }
        if (name.equals("crossReference")) {
            return this.addCrossReference();
        }
        if (name.equals("manufacturingBusinessOperation")) {
            return this.addManufacturingBusinessOperation();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "MedicinalProduct";
    }

    @Override
    public MedicinalProduct copy() {
        MedicinalProduct dst = new MedicinalProduct();
        this.copyValues(dst);
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.combinedPharmaceuticalDoseForm = this.combinedPharmaceuticalDoseForm == null ? null : this.combinedPharmaceuticalDoseForm.copy();
        CodeableConcept codeableConcept = dst.additionalMonitoringIndicator = this.additionalMonitoringIndicator == null ? null : this.additionalMonitoringIndicator.copy();
        if (this.specialMeasures != null) {
            dst.specialMeasures = new ArrayList<StringType>();
            for (StringType stringType : this.specialMeasures) {
                dst.specialMeasures.add(stringType.copy());
            }
        }
        dst.paediatricUseIndicator = this.paediatricUseIndicator == null ? null : this.paediatricUseIndicator.copy();
        CodeableConcept codeableConcept2 = dst.orphanDesignationStatus = this.orphanDesignationStatus == null ? null : this.orphanDesignationStatus.copy();
        if (this.productClassification != null) {
            dst.productClassification = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept3 : this.productClassification) {
                dst.productClassification.add(codeableConcept3.copy());
            }
        }
        Reference reference = dst.marketingAuthorization = this.marketingAuthorization == null ? null : this.marketingAuthorization.copy();
        if (this.packagedMedicinalProduct != null) {
            dst.packagedMedicinalProduct = new ArrayList<Reference>();
            for (Reference reference2 : this.packagedMedicinalProduct) {
                dst.packagedMedicinalProduct.add(reference2.copy());
            }
        }
        if (this.pharmaceuticalProduct != null) {
            dst.pharmaceuticalProduct = new ArrayList<Reference>();
            for (Reference reference3 : this.pharmaceuticalProduct) {
                dst.pharmaceuticalProduct.add(reference3.copy());
            }
        }
        if (this.clinicalParticulars != null) {
            dst.clinicalParticulars = new ArrayList<Reference>();
            for (Reference reference4 : this.clinicalParticulars) {
                dst.clinicalParticulars.add(reference4.copy());
            }
        }
        if (this.attachedDocument != null) {
            dst.attachedDocument = new ArrayList<Reference>();
            for (Reference reference5 : this.attachedDocument) {
                dst.attachedDocument.add(reference5.copy());
            }
        }
        if (this.masterFile != null) {
            dst.masterFile = new ArrayList<Reference>();
            for (Reference reference6 : this.masterFile) {
                dst.masterFile.add(reference6.copy());
            }
        }
        if (this.name != null) {
            dst.name = new ArrayList<MedicinalProductNameComponent>();
            for (MedicinalProductNameComponent medicinalProductNameComponent : this.name) {
                dst.name.add(medicinalProductNameComponent.copy());
            }
        }
        if (this.crossReference != null) {
            dst.crossReference = new ArrayList<Identifier>();
            for (Identifier identifier : this.crossReference) {
                dst.crossReference.add(identifier.copy());
            }
        }
        if (this.manufacturingBusinessOperation != null) {
            dst.manufacturingBusinessOperation = new ArrayList<MedicinalProductManufacturingBusinessOperationComponent>();
            for (MedicinalProductManufacturingBusinessOperationComponent medicinalProductManufacturingBusinessOperationComponent : this.manufacturingBusinessOperation) {
                dst.manufacturingBusinessOperation.add(medicinalProductManufacturingBusinessOperationComponent.copy());
            }
        }
        return dst;
    }

    protected MedicinalProduct typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicinalProduct)) {
            return false;
        }
        MedicinalProduct o = (MedicinalProduct)other_;
        return MedicinalProduct.compareDeep(this.identifier, o.identifier, true) && MedicinalProduct.compareDeep(this.type, o.type, true) && MedicinalProduct.compareDeep(this.combinedPharmaceuticalDoseForm, o.combinedPharmaceuticalDoseForm, true) && MedicinalProduct.compareDeep(this.additionalMonitoringIndicator, o.additionalMonitoringIndicator, true) && MedicinalProduct.compareDeep(this.specialMeasures, o.specialMeasures, true) && MedicinalProduct.compareDeep(this.paediatricUseIndicator, o.paediatricUseIndicator, true) && MedicinalProduct.compareDeep(this.orphanDesignationStatus, o.orphanDesignationStatus, true) && MedicinalProduct.compareDeep(this.productClassification, o.productClassification, true) && MedicinalProduct.compareDeep(this.marketingAuthorization, o.marketingAuthorization, true) && MedicinalProduct.compareDeep(this.packagedMedicinalProduct, o.packagedMedicinalProduct, true) && MedicinalProduct.compareDeep(this.pharmaceuticalProduct, o.pharmaceuticalProduct, true) && MedicinalProduct.compareDeep(this.clinicalParticulars, o.clinicalParticulars, true) && MedicinalProduct.compareDeep(this.attachedDocument, o.attachedDocument, true) && MedicinalProduct.compareDeep(this.masterFile, o.masterFile, true) && MedicinalProduct.compareDeep(this.name, o.name, true) && MedicinalProduct.compareDeep(this.crossReference, o.crossReference, true) && MedicinalProduct.compareDeep(this.manufacturingBusinessOperation, o.manufacturingBusinessOperation, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicinalProduct)) {
            return false;
        }
        MedicinalProduct o = (MedicinalProduct)other_;
        return MedicinalProduct.compareValues(this.specialMeasures, o.specialMeasures, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.type, this.combinedPharmaceuticalDoseForm, this.additionalMonitoringIndicator, this.specialMeasures, this.paediatricUseIndicator, this.orphanDesignationStatus, this.productClassification, this.marketingAuthorization, this.packagedMedicinalProduct, this.pharmaceuticalProduct, this.clinicalParticulars, this.attachedDocument, this.masterFile, this.name, this.crossReference, this.manufacturingBusinessOperation});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.MedicinalProduct;
    }

    @Block
    public static class MedicinalProductManufacturingBusinessOperationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="operationType", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The type of manufacturing operation", formalDefinition="The type of manufacturing operation.")
        protected CodeableConcept operationType;
        @Child(name="authorisationReferenceNumber", type={Identifier.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Regulatory authorization reference number", formalDefinition="Regulatory authorization reference number.")
        protected Identifier authorisationReferenceNumber;
        @Child(name="effectiveDate", type={DateTimeType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Regulatory authorization date", formalDefinition="Regulatory authorization date.")
        protected DateTimeType effectiveDate;
        @Child(name="confidentialityIndicator", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="To indicate if this proces is commercially confidential", formalDefinition="To indicate if this proces is commercially confidential.")
        protected CodeableConcept confidentialityIndicator;
        @Child(name="manufacturer", type={Organization.class}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The manufacturer or establishment associated with the process", formalDefinition="The manufacturer or establishment associated with the process.")
        protected List<Reference> manufacturer;
        protected List<Organization> manufacturerTarget;
        @Child(name="regulator", type={Organization.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A regulator which oversees the operation", formalDefinition="A regulator which oversees the operation.")
        protected Reference regulator;
        protected Organization regulatorTarget;
        private static final long serialVersionUID = 1259822353L;

        public CodeableConcept getOperationType() {
            if (this.operationType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductManufacturingBusinessOperationComponent.operationType");
                }
                if (Configuration.doAutoCreate()) {
                    this.operationType = new CodeableConcept();
                }
            }
            return this.operationType;
        }

        public boolean hasOperationType() {
            return this.operationType != null && !this.operationType.isEmpty();
        }

        public MedicinalProductManufacturingBusinessOperationComponent setOperationType(CodeableConcept value) {
            this.operationType = value;
            return this;
        }

        public Identifier getAuthorisationReferenceNumber() {
            if (this.authorisationReferenceNumber == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductManufacturingBusinessOperationComponent.authorisationReferenceNumber");
                }
                if (Configuration.doAutoCreate()) {
                    this.authorisationReferenceNumber = new Identifier();
                }
            }
            return this.authorisationReferenceNumber;
        }

        public boolean hasAuthorisationReferenceNumber() {
            return this.authorisationReferenceNumber != null && !this.authorisationReferenceNumber.isEmpty();
        }

        public MedicinalProductManufacturingBusinessOperationComponent setAuthorisationReferenceNumber(Identifier value) {
            this.authorisationReferenceNumber = value;
            return this;
        }

        public DateTimeType getEffectiveDateElement() {
            if (this.effectiveDate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductManufacturingBusinessOperationComponent.effectiveDate");
                }
                if (Configuration.doAutoCreate()) {
                    this.effectiveDate = new DateTimeType();
                }
            }
            return this.effectiveDate;
        }

        public boolean hasEffectiveDateElement() {
            return this.effectiveDate != null && !this.effectiveDate.isEmpty();
        }

        public boolean hasEffectiveDate() {
            return this.effectiveDate != null && !this.effectiveDate.isEmpty();
        }

        public MedicinalProductManufacturingBusinessOperationComponent setEffectiveDateElement(DateTimeType value) {
            this.effectiveDate = value;
            return this;
        }

        public Date getEffectiveDate() {
            return this.effectiveDate == null ? null : (Date)this.effectiveDate.getValue();
        }

        public MedicinalProductManufacturingBusinessOperationComponent setEffectiveDate(Date value) {
            if (value == null) {
                this.effectiveDate = null;
            } else {
                if (this.effectiveDate == null) {
                    this.effectiveDate = new DateTimeType();
                }
                this.effectiveDate.setValue(value);
            }
            return this;
        }

        public CodeableConcept getConfidentialityIndicator() {
            if (this.confidentialityIndicator == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductManufacturingBusinessOperationComponent.confidentialityIndicator");
                }
                if (Configuration.doAutoCreate()) {
                    this.confidentialityIndicator = new CodeableConcept();
                }
            }
            return this.confidentialityIndicator;
        }

        public boolean hasConfidentialityIndicator() {
            return this.confidentialityIndicator != null && !this.confidentialityIndicator.isEmpty();
        }

        public MedicinalProductManufacturingBusinessOperationComponent setConfidentialityIndicator(CodeableConcept value) {
            this.confidentialityIndicator = value;
            return this;
        }

        public List<Reference> getManufacturer() {
            if (this.manufacturer == null) {
                this.manufacturer = new ArrayList<Reference>();
            }
            return this.manufacturer;
        }

        public MedicinalProductManufacturingBusinessOperationComponent setManufacturer(List<Reference> theManufacturer) {
            this.manufacturer = theManufacturer;
            return this;
        }

        public boolean hasManufacturer() {
            if (this.manufacturer == null) {
                return false;
            }
            for (Reference item : this.manufacturer) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addManufacturer() {
            Reference t = new Reference();
            if (this.manufacturer == null) {
                this.manufacturer = new ArrayList<Reference>();
            }
            this.manufacturer.add(t);
            return t;
        }

        public MedicinalProductManufacturingBusinessOperationComponent addManufacturer(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.manufacturer == null) {
                this.manufacturer = new ArrayList<Reference>();
            }
            this.manufacturer.add(t);
            return this;
        }

        public Reference getManufacturerFirstRep() {
            if (this.getManufacturer().isEmpty()) {
                this.addManufacturer();
            }
            return this.getManufacturer().get(0);
        }

        @Deprecated
        public List<Organization> getManufacturerTarget() {
            if (this.manufacturerTarget == null) {
                this.manufacturerTarget = new ArrayList<Organization>();
            }
            return this.manufacturerTarget;
        }

        @Deprecated
        public Organization addManufacturerTarget() {
            Organization r = new Organization();
            if (this.manufacturerTarget == null) {
                this.manufacturerTarget = new ArrayList<Organization>();
            }
            this.manufacturerTarget.add(r);
            return r;
        }

        public Reference getRegulator() {
            if (this.regulator == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductManufacturingBusinessOperationComponent.regulator");
                }
                if (Configuration.doAutoCreate()) {
                    this.regulator = new Reference();
                }
            }
            return this.regulator;
        }

        public boolean hasRegulator() {
            return this.regulator != null && !this.regulator.isEmpty();
        }

        public MedicinalProductManufacturingBusinessOperationComponent setRegulator(Reference value) {
            this.regulator = value;
            return this;
        }

        public Organization getRegulatorTarget() {
            if (this.regulatorTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductManufacturingBusinessOperationComponent.regulator");
                }
                if (Configuration.doAutoCreate()) {
                    this.regulatorTarget = new Organization();
                }
            }
            return this.regulatorTarget;
        }

        public MedicinalProductManufacturingBusinessOperationComponent setRegulatorTarget(Organization value) {
            this.regulatorTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("operationType", "CodeableConcept", "The type of manufacturing operation.", 0, 1, this.operationType));
            children.add(new Property("authorisationReferenceNumber", "Identifier", "Regulatory authorization reference number.", 0, 1, this.authorisationReferenceNumber));
            children.add(new Property("effectiveDate", "dateTime", "Regulatory authorization date.", 0, 1, this.effectiveDate));
            children.add(new Property("confidentialityIndicator", "CodeableConcept", "To indicate if this proces is commercially confidential.", 0, 1, this.confidentialityIndicator));
            children.add(new Property("manufacturer", "Reference(Organization)", "The manufacturer or establishment associated with the process.", 0, Integer.MAX_VALUE, this.manufacturer));
            children.add(new Property("regulator", "Reference(Organization)", "A regulator which oversees the operation.", 0, 1, this.regulator));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 91999553: {
                    return new Property("operationType", "CodeableConcept", "The type of manufacturing operation.", 0, 1, this.operationType);
                }
                case -1940839884: {
                    return new Property("authorisationReferenceNumber", "Identifier", "Regulatory authorization reference number.", 0, 1, this.authorisationReferenceNumber);
                }
                case -930389515: {
                    return new Property("effectiveDate", "dateTime", "Regulatory authorization date.", 0, 1, this.effectiveDate);
                }
                case -1449404791: {
                    return new Property("confidentialityIndicator", "CodeableConcept", "To indicate if this proces is commercially confidential.", 0, 1, this.confidentialityIndicator);
                }
                case -1969347631: {
                    return new Property("manufacturer", "Reference(Organization)", "The manufacturer or establishment associated with the process.", 0, Integer.MAX_VALUE, this.manufacturer);
                }
                case 414760449: {
                    return new Property("regulator", "Reference(Organization)", "A regulator which oversees the operation.", 0, 1, this.regulator);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 91999553: {
                    Base[] baseArray;
                    if (this.operationType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.operationType;
                    }
                    return baseArray;
                }
                case -1940839884: {
                    Base[] baseArray;
                    if (this.authorisationReferenceNumber == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.authorisationReferenceNumber;
                    }
                    return baseArray;
                }
                case -930389515: {
                    Base[] baseArray;
                    if (this.effectiveDate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.effectiveDate;
                    }
                    return baseArray;
                }
                case -1449404791: {
                    Base[] baseArray;
                    if (this.confidentialityIndicator == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.confidentialityIndicator;
                    }
                    return baseArray;
                }
                case -1969347631: {
                    return this.manufacturer == null ? new Base[]{} : this.manufacturer.toArray(new Base[this.manufacturer.size()]);
                }
                case 414760449: {
                    Base[] baseArray;
                    if (this.regulator == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.regulator;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 91999553: {
                    this.operationType = this.castToCodeableConcept(value);
                    return value;
                }
                case -1940839884: {
                    this.authorisationReferenceNumber = this.castToIdentifier(value);
                    return value;
                }
                case -930389515: {
                    this.effectiveDate = this.castToDateTime(value);
                    return value;
                }
                case -1449404791: {
                    this.confidentialityIndicator = this.castToCodeableConcept(value);
                    return value;
                }
                case -1969347631: {
                    this.getManufacturer().add(this.castToReference(value));
                    return value;
                }
                case 414760449: {
                    this.regulator = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("operationType")) {
                this.operationType = this.castToCodeableConcept(value);
            } else if (name.equals("authorisationReferenceNumber")) {
                this.authorisationReferenceNumber = this.castToIdentifier(value);
            } else if (name.equals("effectiveDate")) {
                this.effectiveDate = this.castToDateTime(value);
            } else if (name.equals("confidentialityIndicator")) {
                this.confidentialityIndicator = this.castToCodeableConcept(value);
            } else if (name.equals("manufacturer")) {
                this.getManufacturer().add(this.castToReference(value));
            } else if (name.equals("regulator")) {
                this.regulator = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 91999553: {
                    return this.getOperationType();
                }
                case -1940839884: {
                    return this.getAuthorisationReferenceNumber();
                }
                case -930389515: {
                    return this.getEffectiveDateElement();
                }
                case -1449404791: {
                    return this.getConfidentialityIndicator();
                }
                case -1969347631: {
                    return this.addManufacturer();
                }
                case 414760449: {
                    return this.getRegulator();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 91999553: {
                    return new String[]{"CodeableConcept"};
                }
                case -1940839884: {
                    return new String[]{"Identifier"};
                }
                case -930389515: {
                    return new String[]{"dateTime"};
                }
                case -1449404791: {
                    return new String[]{"CodeableConcept"};
                }
                case -1969347631: {
                    return new String[]{"Reference"};
                }
                case 414760449: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("operationType")) {
                this.operationType = new CodeableConcept();
                return this.operationType;
            }
            if (name.equals("authorisationReferenceNumber")) {
                this.authorisationReferenceNumber = new Identifier();
                return this.authorisationReferenceNumber;
            }
            if (name.equals("effectiveDate")) {
                throw new FHIRException("Cannot call addChild on a primitive type MedicinalProduct.effectiveDate");
            }
            if (name.equals("confidentialityIndicator")) {
                this.confidentialityIndicator = new CodeableConcept();
                return this.confidentialityIndicator;
            }
            if (name.equals("manufacturer")) {
                return this.addManufacturer();
            }
            if (name.equals("regulator")) {
                this.regulator = new Reference();
                return this.regulator;
            }
            return super.addChild(name);
        }

        @Override
        public MedicinalProductManufacturingBusinessOperationComponent copy() {
            MedicinalProductManufacturingBusinessOperationComponent dst = new MedicinalProductManufacturingBusinessOperationComponent();
            this.copyValues(dst);
            dst.operationType = this.operationType == null ? null : this.operationType.copy();
            dst.authorisationReferenceNumber = this.authorisationReferenceNumber == null ? null : this.authorisationReferenceNumber.copy();
            dst.effectiveDate = this.effectiveDate == null ? null : this.effectiveDate.copy();
            CodeableConcept codeableConcept = dst.confidentialityIndicator = this.confidentialityIndicator == null ? null : this.confidentialityIndicator.copy();
            if (this.manufacturer != null) {
                dst.manufacturer = new ArrayList<Reference>();
                for (Reference i : this.manufacturer) {
                    dst.manufacturer.add(i.copy());
                }
            }
            dst.regulator = this.regulator == null ? null : this.regulator.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductManufacturingBusinessOperationComponent)) {
                return false;
            }
            MedicinalProductManufacturingBusinessOperationComponent o = (MedicinalProductManufacturingBusinessOperationComponent)other_;
            return MedicinalProductManufacturingBusinessOperationComponent.compareDeep(this.operationType, o.operationType, true) && MedicinalProductManufacturingBusinessOperationComponent.compareDeep(this.authorisationReferenceNumber, o.authorisationReferenceNumber, true) && MedicinalProductManufacturingBusinessOperationComponent.compareDeep(this.effectiveDate, o.effectiveDate, true) && MedicinalProductManufacturingBusinessOperationComponent.compareDeep(this.confidentialityIndicator, o.confidentialityIndicator, true) && MedicinalProductManufacturingBusinessOperationComponent.compareDeep(this.manufacturer, o.manufacturer, true) && MedicinalProductManufacturingBusinessOperationComponent.compareDeep(this.regulator, o.regulator, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductManufacturingBusinessOperationComponent)) {
                return false;
            }
            MedicinalProductManufacturingBusinessOperationComponent o = (MedicinalProductManufacturingBusinessOperationComponent)other_;
            return MedicinalProductManufacturingBusinessOperationComponent.compareValues(this.effectiveDate, o.effectiveDate, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.operationType, this.authorisationReferenceNumber, this.effectiveDate, this.confidentialityIndicator, this.manufacturer, this.regulator});
        }

        @Override
        public String fhirType() {
            return "MedicinalProduct.manufacturingBusinessOperation";
        }
    }

    @Block
    public static class MedicinalProductNameCountryLanguageComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="country", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Country code for where this name applies", formalDefinition="Country code for where this name applies.")
        protected CodeableConcept country;
        @Child(name="jurisdiction", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Jurisdiction code for where this name applies", formalDefinition="Jurisdiction code for where this name applies.")
        protected CodeableConcept jurisdiction;
        @Child(name="language", type={CodeableConcept.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Language code for this name", formalDefinition="Language code for this name.")
        protected CodeableConcept language;
        private static final long serialVersionUID = 1627157564L;

        public MedicinalProductNameCountryLanguageComponent() {
        }

        public MedicinalProductNameCountryLanguageComponent(CodeableConcept country, CodeableConcept language) {
            this.country = country;
            this.language = language;
        }

        public CodeableConcept getCountry() {
            if (this.country == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductNameCountryLanguageComponent.country");
                }
                if (Configuration.doAutoCreate()) {
                    this.country = new CodeableConcept();
                }
            }
            return this.country;
        }

        public boolean hasCountry() {
            return this.country != null && !this.country.isEmpty();
        }

        public MedicinalProductNameCountryLanguageComponent setCountry(CodeableConcept value) {
            this.country = value;
            return this;
        }

        public CodeableConcept getJurisdiction() {
            if (this.jurisdiction == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductNameCountryLanguageComponent.jurisdiction");
                }
                if (Configuration.doAutoCreate()) {
                    this.jurisdiction = new CodeableConcept();
                }
            }
            return this.jurisdiction;
        }

        public boolean hasJurisdiction() {
            return this.jurisdiction != null && !this.jurisdiction.isEmpty();
        }

        public MedicinalProductNameCountryLanguageComponent setJurisdiction(CodeableConcept value) {
            this.jurisdiction = value;
            return this;
        }

        public CodeableConcept getLanguage() {
            if (this.language == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductNameCountryLanguageComponent.language");
                }
                if (Configuration.doAutoCreate()) {
                    this.language = new CodeableConcept();
                }
            }
            return this.language;
        }

        public boolean hasLanguage() {
            return this.language != null && !this.language.isEmpty();
        }

        public MedicinalProductNameCountryLanguageComponent setLanguage(CodeableConcept value) {
            this.language = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("country", "CodeableConcept", "Country code for where this name applies.", 0, 1, this.country));
            children.add(new Property("jurisdiction", "CodeableConcept", "Jurisdiction code for where this name applies.", 0, 1, this.jurisdiction));
            children.add(new Property("language", "CodeableConcept", "Language code for this name.", 0, 1, this.language));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 957831062: {
                    return new Property("country", "CodeableConcept", "Country code for where this name applies.", 0, 1, this.country);
                }
                case -507075711: {
                    return new Property("jurisdiction", "CodeableConcept", "Jurisdiction code for where this name applies.", 0, 1, this.jurisdiction);
                }
                case -1613589672: {
                    return new Property("language", "CodeableConcept", "Language code for this name.", 0, 1, this.language);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 957831062: {
                    Base[] baseArray;
                    if (this.country == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.country;
                    }
                    return baseArray;
                }
                case -507075711: {
                    Base[] baseArray;
                    if (this.jurisdiction == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.jurisdiction;
                    }
                    return baseArray;
                }
                case -1613589672: {
                    Base[] baseArray;
                    if (this.language == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.language;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 957831062: {
                    this.country = this.castToCodeableConcept(value);
                    return value;
                }
                case -507075711: {
                    this.jurisdiction = this.castToCodeableConcept(value);
                    return value;
                }
                case -1613589672: {
                    this.language = this.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("country")) {
                this.country = this.castToCodeableConcept(value);
            } else if (name.equals("jurisdiction")) {
                this.jurisdiction = this.castToCodeableConcept(value);
            } else if (name.equals("language")) {
                this.language = this.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 957831062: {
                    return this.getCountry();
                }
                case -507075711: {
                    return this.getJurisdiction();
                }
                case -1613589672: {
                    return this.getLanguage();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 957831062: {
                    return new String[]{"CodeableConcept"};
                }
                case -507075711: {
                    return new String[]{"CodeableConcept"};
                }
                case -1613589672: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("country")) {
                this.country = new CodeableConcept();
                return this.country;
            }
            if (name.equals("jurisdiction")) {
                this.jurisdiction = new CodeableConcept();
                return this.jurisdiction;
            }
            if (name.equals("language")) {
                this.language = new CodeableConcept();
                return this.language;
            }
            return super.addChild(name);
        }

        @Override
        public MedicinalProductNameCountryLanguageComponent copy() {
            MedicinalProductNameCountryLanguageComponent dst = new MedicinalProductNameCountryLanguageComponent();
            this.copyValues(dst);
            dst.country = this.country == null ? null : this.country.copy();
            dst.jurisdiction = this.jurisdiction == null ? null : this.jurisdiction.copy();
            dst.language = this.language == null ? null : this.language.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductNameCountryLanguageComponent)) {
                return false;
            }
            MedicinalProductNameCountryLanguageComponent o = (MedicinalProductNameCountryLanguageComponent)other_;
            return MedicinalProductNameCountryLanguageComponent.compareDeep(this.country, o.country, true) && MedicinalProductNameCountryLanguageComponent.compareDeep(this.jurisdiction, o.jurisdiction, true) && MedicinalProductNameCountryLanguageComponent.compareDeep(this.language, o.language, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductNameCountryLanguageComponent)) {
                return false;
            }
            MedicinalProductNameCountryLanguageComponent o = (MedicinalProductNameCountryLanguageComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.country, this.jurisdiction, this.language});
        }

        @Override
        public String fhirType() {
            return "MedicinalProduct.name.countryLanguage";
        }
    }

    @Block
    public static class MedicinalProductNameNamePartComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="part", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A fragment of a product name", formalDefinition="A fragment of a product name.")
        protected StringType part;
        @Child(name="type", type={Coding.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Idenifying type for this part of the name (e.g. strength part)", formalDefinition="Idenifying type for this part of the name (e.g. strength part).")
        protected Coding type;
        private static final long serialVersionUID = -301533796L;

        public MedicinalProductNameNamePartComponent() {
        }

        public MedicinalProductNameNamePartComponent(StringType part, Coding type) {
            this.part = part;
            this.type = type;
        }

        public StringType getPartElement() {
            if (this.part == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductNameNamePartComponent.part");
                }
                if (Configuration.doAutoCreate()) {
                    this.part = new StringType();
                }
            }
            return this.part;
        }

        public boolean hasPartElement() {
            return this.part != null && !this.part.isEmpty();
        }

        public boolean hasPart() {
            return this.part != null && !this.part.isEmpty();
        }

        public MedicinalProductNameNamePartComponent setPartElement(StringType value) {
            this.part = value;
            return this;
        }

        public String getPart() {
            return this.part == null ? null : (String)this.part.getValue();
        }

        public MedicinalProductNameNamePartComponent setPart(String value) {
            if (this.part == null) {
                this.part = new StringType();
            }
            this.part.setValue(value);
            return this;
        }

        public Coding getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductNameNamePartComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Coding();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicinalProductNameNamePartComponent setType(Coding value) {
            this.type = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("part", "string", "A fragment of a product name.", 0, 1, this.part));
            children.add(new Property("type", "Coding", "Idenifying type for this part of the name (e.g. strength part).", 0, 1, this.type));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3433459: {
                    return new Property("part", "string", "A fragment of a product name.", 0, 1, this.part);
                }
                case 3575610: {
                    return new Property("type", "Coding", "Idenifying type for this part of the name (e.g. strength part).", 0, 1, this.type);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3433459: {
                    Base[] baseArray;
                    if (this.part == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.part;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3433459: {
                    this.part = this.castToString(value);
                    return value;
                }
                case 3575610: {
                    this.type = this.castToCoding(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("part")) {
                this.part = this.castToString(value);
            } else if (name.equals("type")) {
                this.type = this.castToCoding(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3433459: {
                    return this.getPartElement();
                }
                case 3575610: {
                    return this.getType();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3433459: {
                    return new String[]{"string"};
                }
                case 3575610: {
                    return new String[]{"Coding"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("part")) {
                throw new FHIRException("Cannot call addChild on a primitive type MedicinalProduct.part");
            }
            if (name.equals("type")) {
                this.type = new Coding();
                return this.type;
            }
            return super.addChild(name);
        }

        @Override
        public MedicinalProductNameNamePartComponent copy() {
            MedicinalProductNameNamePartComponent dst = new MedicinalProductNameNamePartComponent();
            this.copyValues(dst);
            dst.part = this.part == null ? null : this.part.copy();
            dst.type = this.type == null ? null : this.type.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductNameNamePartComponent)) {
                return false;
            }
            MedicinalProductNameNamePartComponent o = (MedicinalProductNameNamePartComponent)other_;
            return MedicinalProductNameNamePartComponent.compareDeep(this.part, o.part, true) && MedicinalProductNameNamePartComponent.compareDeep(this.type, o.type, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductNameNamePartComponent)) {
                return false;
            }
            MedicinalProductNameNamePartComponent o = (MedicinalProductNameNamePartComponent)other_;
            return MedicinalProductNameNamePartComponent.compareValues(this.part, o.part, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.part, this.type});
        }

        @Override
        public String fhirType() {
            return "MedicinalProduct.name.namePart";
        }
    }

    @Block
    public static class MedicinalProductNameComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="fullName", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The full product name", formalDefinition="The full product name.")
        protected StringType fullName;
        @Child(name="namePart", type={}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Coding words or phrases of the name", formalDefinition="Coding words or phrases of the name.")
        protected List<MedicinalProductNameNamePartComponent> namePart;
        @Child(name="countryLanguage", type={}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Country where the name applies", formalDefinition="Country where the name applies.")
        protected List<MedicinalProductNameCountryLanguageComponent> countryLanguage;
        private static final long serialVersionUID = 993877853L;

        public MedicinalProductNameComponent() {
        }

        public MedicinalProductNameComponent(StringType fullName) {
            this.fullName = fullName;
        }

        public StringType getFullNameElement() {
            if (this.fullName == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductNameComponent.fullName");
                }
                if (Configuration.doAutoCreate()) {
                    this.fullName = new StringType();
                }
            }
            return this.fullName;
        }

        public boolean hasFullNameElement() {
            return this.fullName != null && !this.fullName.isEmpty();
        }

        public boolean hasFullName() {
            return this.fullName != null && !this.fullName.isEmpty();
        }

        public MedicinalProductNameComponent setFullNameElement(StringType value) {
            this.fullName = value;
            return this;
        }

        public String getFullName() {
            return this.fullName == null ? null : (String)this.fullName.getValue();
        }

        public MedicinalProductNameComponent setFullName(String value) {
            if (this.fullName == null) {
                this.fullName = new StringType();
            }
            this.fullName.setValue(value);
            return this;
        }

        public List<MedicinalProductNameNamePartComponent> getNamePart() {
            if (this.namePart == null) {
                this.namePart = new ArrayList<MedicinalProductNameNamePartComponent>();
            }
            return this.namePart;
        }

        public MedicinalProductNameComponent setNamePart(List<MedicinalProductNameNamePartComponent> theNamePart) {
            this.namePart = theNamePart;
            return this;
        }

        public boolean hasNamePart() {
            if (this.namePart == null) {
                return false;
            }
            for (MedicinalProductNameNamePartComponent item : this.namePart) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MedicinalProductNameNamePartComponent addNamePart() {
            MedicinalProductNameNamePartComponent t = new MedicinalProductNameNamePartComponent();
            if (this.namePart == null) {
                this.namePart = new ArrayList<MedicinalProductNameNamePartComponent>();
            }
            this.namePart.add(t);
            return t;
        }

        public MedicinalProductNameComponent addNamePart(MedicinalProductNameNamePartComponent t) {
            if (t == null) {
                return this;
            }
            if (this.namePart == null) {
                this.namePart = new ArrayList<MedicinalProductNameNamePartComponent>();
            }
            this.namePart.add(t);
            return this;
        }

        public MedicinalProductNameNamePartComponent getNamePartFirstRep() {
            if (this.getNamePart().isEmpty()) {
                this.addNamePart();
            }
            return this.getNamePart().get(0);
        }

        public List<MedicinalProductNameCountryLanguageComponent> getCountryLanguage() {
            if (this.countryLanguage == null) {
                this.countryLanguage = new ArrayList<MedicinalProductNameCountryLanguageComponent>();
            }
            return this.countryLanguage;
        }

        public MedicinalProductNameComponent setCountryLanguage(List<MedicinalProductNameCountryLanguageComponent> theCountryLanguage) {
            this.countryLanguage = theCountryLanguage;
            return this;
        }

        public boolean hasCountryLanguage() {
            if (this.countryLanguage == null) {
                return false;
            }
            for (MedicinalProductNameCountryLanguageComponent item : this.countryLanguage) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MedicinalProductNameCountryLanguageComponent addCountryLanguage() {
            MedicinalProductNameCountryLanguageComponent t = new MedicinalProductNameCountryLanguageComponent();
            if (this.countryLanguage == null) {
                this.countryLanguage = new ArrayList<MedicinalProductNameCountryLanguageComponent>();
            }
            this.countryLanguage.add(t);
            return t;
        }

        public MedicinalProductNameComponent addCountryLanguage(MedicinalProductNameCountryLanguageComponent t) {
            if (t == null) {
                return this;
            }
            if (this.countryLanguage == null) {
                this.countryLanguage = new ArrayList<MedicinalProductNameCountryLanguageComponent>();
            }
            this.countryLanguage.add(t);
            return this;
        }

        public MedicinalProductNameCountryLanguageComponent getCountryLanguageFirstRep() {
            if (this.getCountryLanguage().isEmpty()) {
                this.addCountryLanguage();
            }
            return this.getCountryLanguage().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("fullName", "string", "The full product name.", 0, 1, this.fullName));
            children.add(new Property("namePart", "", "Coding words or phrases of the name.", 0, Integer.MAX_VALUE, this.namePart));
            children.add(new Property("countryLanguage", "", "Country where the name applies.", 0, Integer.MAX_VALUE, this.countryLanguage));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1330852282: {
                    return new Property("fullName", "string", "The full product name.", 0, 1, this.fullName);
                }
                case 1840452894: {
                    return new Property("namePart", "", "Coding words or phrases of the name.", 0, Integer.MAX_VALUE, this.namePart);
                }
                case -141141746: {
                    return new Property("countryLanguage", "", "Country where the name applies.", 0, Integer.MAX_VALUE, this.countryLanguage);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1330852282: {
                    Base[] baseArray;
                    if (this.fullName == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.fullName;
                    }
                    return baseArray;
                }
                case 1840452894: {
                    return this.namePart == null ? new Base[]{} : this.namePart.toArray(new Base[this.namePart.size()]);
                }
                case -141141746: {
                    return this.countryLanguage == null ? new Base[]{} : this.countryLanguage.toArray(new Base[this.countryLanguage.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1330852282: {
                    this.fullName = this.castToString(value);
                    return value;
                }
                case 1840452894: {
                    this.getNamePart().add((MedicinalProductNameNamePartComponent)value);
                    return value;
                }
                case -141141746: {
                    this.getCountryLanguage().add((MedicinalProductNameCountryLanguageComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("fullName")) {
                this.fullName = this.castToString(value);
            } else if (name.equals("namePart")) {
                this.getNamePart().add((MedicinalProductNameNamePartComponent)value);
            } else if (name.equals("countryLanguage")) {
                this.getCountryLanguage().add((MedicinalProductNameCountryLanguageComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1330852282: {
                    return this.getFullNameElement();
                }
                case 1840452894: {
                    return this.addNamePart();
                }
                case -141141746: {
                    return this.addCountryLanguage();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1330852282: {
                    return new String[]{"string"};
                }
                case 1840452894: {
                    return new String[0];
                }
                case -141141746: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("fullName")) {
                throw new FHIRException("Cannot call addChild on a primitive type MedicinalProduct.fullName");
            }
            if (name.equals("namePart")) {
                return this.addNamePart();
            }
            if (name.equals("countryLanguage")) {
                return this.addCountryLanguage();
            }
            return super.addChild(name);
        }

        @Override
        public MedicinalProductNameComponent copy() {
            MedicinalProductNameComponent dst = new MedicinalProductNameComponent();
            this.copyValues(dst);
            StringType stringType = dst.fullName = this.fullName == null ? null : this.fullName.copy();
            if (this.namePart != null) {
                dst.namePart = new ArrayList<MedicinalProductNameNamePartComponent>();
                for (MedicinalProductNameNamePartComponent medicinalProductNameNamePartComponent : this.namePart) {
                    dst.namePart.add(medicinalProductNameNamePartComponent.copy());
                }
            }
            if (this.countryLanguage != null) {
                dst.countryLanguage = new ArrayList<MedicinalProductNameCountryLanguageComponent>();
                for (MedicinalProductNameCountryLanguageComponent medicinalProductNameCountryLanguageComponent : this.countryLanguage) {
                    dst.countryLanguage.add(medicinalProductNameCountryLanguageComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductNameComponent)) {
                return false;
            }
            MedicinalProductNameComponent o = (MedicinalProductNameComponent)other_;
            return MedicinalProductNameComponent.compareDeep(this.fullName, o.fullName, true) && MedicinalProductNameComponent.compareDeep(this.namePart, o.namePart, true) && MedicinalProductNameComponent.compareDeep(this.countryLanguage, o.countryLanguage, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductNameComponent)) {
                return false;
            }
            MedicinalProductNameComponent o = (MedicinalProductNameComponent)other_;
            return MedicinalProductNameComponent.compareValues(this.fullName, o.fullName, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.fullName, this.namePart, this.countryLanguage});
        }

        @Override
        public String fhirType() {
            return "MedicinalProduct.name";
        }
    }
}

