/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.Base64BinaryType;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DetectedIssue;
import org.hl7.fhir.r4.model.DocumentReference;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Dosage;
import org.hl7.fhir.r4.model.Duration;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.MarkdownType;
import org.hl7.fhir.r4.model.Medication;
import org.hl7.fhir.r4.model.Money;
import org.hl7.fhir.r4.model.ObservationDefinition;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Ratio;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.SimpleQuantity;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Substance;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="MedicationKnowledge", profile="http://hl7.org/fhir/Profile/MedicationKnowledge")
public class MedicationKnowledge
extends DomainResource {
    @Child(name="code", type={CodeableConcept.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Code that identifies this medication", formalDefinition="A code that specifies this medication, or a textual description if no code is available. Usage note: This could be a standard medication code such as a code from RxNorm, SNOMED CT, IDMP etc. It could also be a national or local formulary code, optionally with translations to other code systems.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-codes")
    protected CodeableConcept code;
    @Child(name="status", type={CodeType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="active | inactive | entered-in-error", formalDefinition="A code to indicate if the medication is in active use.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medicationKnowledge-status")
    protected Enumeration<MedicationKnowledgeStatus> status;
    @Child(name="manufacturer", type={Organization.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Manufacturer of the item", formalDefinition="Describes the details of the manufacturer of the medication product.  This is not intended to represent the distributor of a medication product.")
    protected Reference manufacturer;
    protected Organization manufacturerTarget;
    @Child(name="form", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="powder | tablets | capsule +", formalDefinition="Describes the form of the item.  Powder; tablets; capsule.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-form-codes")
    protected CodeableConcept form;
    @Child(name="amount", type={SimpleQuantity.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Amount of drug in package", formalDefinition="Specific amount of the drug in the packaged product.  For example, when specifying a product that has the same strength (For example, Insulin glargine 100 unit per mL solution for injection), this attribute provides additional clarification of the package amount (For example, 3 mL, 10mL, etc).")
    protected SimpleQuantity amount;
    @Child(name="synonym", type={StringType.class}, order=5, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional names for a medication", formalDefinition="Additional names for a medication, for example, the name(s) given to a medication in different countries.  For example, acetaminophen and paracetamol or salbutamol and albuterol.")
    protected List<StringType> synonym;
    @Child(name="relatedMedicationKnowledge", type={MedicationKnowledge.class}, order=6, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Associated or related medication information", formalDefinition="Associated or related knowledge about a medication.")
    protected List<Reference> relatedMedicationKnowledge;
    protected List<MedicationKnowledge> relatedMedicationKnowledgeTarget;
    @Child(name="associatedMedication", type={Medication.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="A medication resource that is associated with this medication", formalDefinition="Associated or related medications.  For example, if the medication is a branded product (e.g. Crestor), this is the Therapeutic Moeity (e.g. Rosuvastatin) or if this is a generic medication (e.g. Rosuvastatin), this would link to a branded product (e.g. Crestor).")
    protected Reference associatedMedication;
    protected Medication associatedMedicationTarget;
    @Child(name="productType", type={CodeableConcept.class}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Category of the medication or product", formalDefinition="Category of the medication or product (e.g. branded product, therapeutic moeity, generic product, innovator product, etc).")
    protected List<CodeableConcept> productType;
    @Child(name="monograph", type={}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Associated documentation about the medication", formalDefinition="Associated documentation about the medication.")
    protected List<MedicationKnowledgeMonographComponent> monograph;
    @Child(name="halfLifePeriod", type={Duration.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Time required for concentration in the body to decrease by half", formalDefinition="The time required for any specified property (e.g., the concentration of a substance in the body) to decrease by half.")
    protected Duration halfLifePeriod;
    @Child(name="ingredient", type={}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Active or inactive ingredient", formalDefinition="Identifies a particular constituent of interest in the product.")
    protected List<MedicationKnowledgeIngredientComponent> ingredient;
    @Child(name="preparationInstruction", type={MarkdownType.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The instructions for preparing the medication", formalDefinition="The instructions for preparing the medication.")
    protected MarkdownType preparationInstruction;
    @Child(name="intendedRoute", type={CodeableConcept.class}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The intended or approved route of administration", formalDefinition="The intended or approved route of administration.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/route-codes")
    protected List<CodeableConcept> intendedRoute;
    @Child(name="cost", type={}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The pricing of the medication", formalDefinition="The price of the medication.")
    protected List<MedicationKnowledgeCostComponent> cost;
    @Child(name="monitoringProgram", type={}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Program under which a medication is reviewed", formalDefinition="The program under which the medication is reviewed.")
    protected List<MedicationKnowledgeMonitoringProgramComponent> monitoringProgram;
    @Child(name="administrationGuidelines", type={}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Gudelines for administration of the medication", formalDefinition="Guidelines for the administration of the medication.")
    protected List<MedicationKnowledgeAdministrationGuidelinesComponent> administrationGuidelines;
    @Child(name="medicineClassification", type={}, order=17, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Categorization of the medication within a formulary or classification system", formalDefinition="Categorization of the medication within a formulary or classification system.")
    protected List<MedicationKnowledgeMedicineClassificationComponent> medicineClassification;
    @Child(name="packaging", type={}, order=18, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Details about packaged medications", formalDefinition="Information that only applies to packages (not products).")
    protected MedicationKnowledgePackagingComponent packaging;
    @Child(name="drugCharacteristic", type={}, order=19, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Specifies descriptive properties of the medicine", formalDefinition="Specifies descriptive properties of the medicine, such as color, shape, imprints, etc.")
    protected List<MedicationKnowledgeDrugCharacteristicComponent> drugCharacteristic;
    @Child(name="contraindication", type={DetectedIssue.class}, order=20, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Potential clinical issue with or between medication(s)", formalDefinition="Potential clinical issue with or between medication(s) (for example, drug-drug interaction, drug-disease contraindication, drug-allergy interaction, etc).")
    protected List<Reference> contraindication;
    protected List<DetectedIssue> contraindicationTarget;
    private static final long serialVersionUID = 854168093L;
    @SearchParamDefinition(name="code", path="MedicationKnowledge.code", description="Code that identifies this medication", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="ingredient", path="MedicationKnowledge.ingredient.item.as(Reference)", description="Medication(s) or substance(s) contained in the medication", type="reference", target={Substance.class})
    public static final String SP_INGREDIENT = "ingredient";
    public static final ReferenceClientParam INGREDIENT = new ReferenceClientParam("ingredient");
    public static final Include INCLUDE_INGREDIENT = new Include("MedicationKnowledge:ingredient").toLocked();
    @SearchParamDefinition(name="classification-type", path="MedicationKnowledge.medicineClassification.type", description="The type of category for the medication (for example, therapeutic classification, therapeutic sub-classification)", type="token")
    public static final String SP_CLASSIFICATION_TYPE = "classification-type";
    public static final TokenClientParam CLASSIFICATION_TYPE = new TokenClientParam("classification-type");
    @SearchParamDefinition(name="monograph-type", path="MedicationKnowledge.monograph.type", description="The category of medication document", type="token")
    public static final String SP_MONOGRAPH_TYPE = "monograph-type";
    public static final TokenClientParam MONOGRAPH_TYPE = new TokenClientParam("monograph-type");
    @SearchParamDefinition(name="classification", path="MedicationKnowledge.medicineClassification.classification", description="Specific category assigned to the medication", type="token")
    public static final String SP_CLASSIFICATION = "classification";
    public static final TokenClientParam CLASSIFICATION = new TokenClientParam("classification");
    @SearchParamDefinition(name="manufacturer", path="MedicationKnowledge.manufacturer", description="Manufacturer of the item", type="reference", target={Organization.class})
    public static final String SP_MANUFACTURER = "manufacturer";
    public static final ReferenceClientParam MANUFACTURER = new ReferenceClientParam("manufacturer");
    public static final Include INCLUDE_MANUFACTURER = new Include("MedicationKnowledge:manufacturer").toLocked();
    @SearchParamDefinition(name="ingredient-code", path="MedicationKnowledge.ingredient.item.as(CodeableConcept)", description="Medication(s) or substance(s) contained in the medication", type="token")
    public static final String SP_INGREDIENT_CODE = "ingredient-code";
    public static final TokenClientParam INGREDIENT_CODE = new TokenClientParam("ingredient-code");
    @SearchParamDefinition(name="source-cost", path="MedicationKnowledge.cost.source", description="The source or owner for the price information", type="token")
    public static final String SP_SOURCE_COST = "source-cost";
    public static final TokenClientParam SOURCE_COST = new TokenClientParam("source-cost");
    @SearchParamDefinition(name="form", path="MedicationKnowledge.form", description="powder | tablets | capsule +", type="token")
    public static final String SP_FORM = "form";
    public static final TokenClientParam FORM = new TokenClientParam("form");
    @SearchParamDefinition(name="monograph", path="MedicationKnowledge.monograph.document", description="Associated documentation about the medication", type="reference", target={DocumentReference.class})
    public static final String SP_MONOGRAPH = "monograph";
    public static final ReferenceClientParam MONOGRAPH = new ReferenceClientParam("monograph");
    public static final Include INCLUDE_MONOGRAPH = new Include("MedicationKnowledge:monograph").toLocked();
    @SearchParamDefinition(name="monitoring-program-name", path="MedicationKnowledge.monitoringProgram.name", description="Name of the reviewing program", type="token")
    public static final String SP_MONITORING_PROGRAM_NAME = "monitoring-program-name";
    public static final TokenClientParam MONITORING_PROGRAM_NAME = new TokenClientParam("monitoring-program-name");
    @SearchParamDefinition(name="monitoring-program-type", path="MedicationKnowledge.monitoringProgram.type", description="Type of program under which the medication is monitored", type="token")
    public static final String SP_MONITORING_PROGRAM_TYPE = "monitoring-program-type";
    public static final TokenClientParam MONITORING_PROGRAM_TYPE = new TokenClientParam("monitoring-program-type");
    @SearchParamDefinition(name="status", path="MedicationKnowledge.status", description="active | inactive | entered-in-error", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationKnowledge.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public MedicationKnowledge setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public Enumeration<MedicationKnowledgeStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationKnowledge.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<MedicationKnowledgeStatus>(new MedicationKnowledgeStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public MedicationKnowledge setStatusElement(Enumeration<MedicationKnowledgeStatus> value) {
        this.status = value;
        return this;
    }

    public MedicationKnowledgeStatus getStatus() {
        return this.status == null ? null : (MedicationKnowledgeStatus)((Object)this.status.getValue());
    }

    public MedicationKnowledge setStatus(MedicationKnowledgeStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<MedicationKnowledgeStatus>(new MedicationKnowledgeStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public Reference getManufacturer() {
        if (this.manufacturer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationKnowledge.manufacturer");
            }
            if (Configuration.doAutoCreate()) {
                this.manufacturer = new Reference();
            }
        }
        return this.manufacturer;
    }

    public boolean hasManufacturer() {
        return this.manufacturer != null && !this.manufacturer.isEmpty();
    }

    public MedicationKnowledge setManufacturer(Reference value) {
        this.manufacturer = value;
        return this;
    }

    public Organization getManufacturerTarget() {
        if (this.manufacturerTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationKnowledge.manufacturer");
            }
            if (Configuration.doAutoCreate()) {
                this.manufacturerTarget = new Organization();
            }
        }
        return this.manufacturerTarget;
    }

    public MedicationKnowledge setManufacturerTarget(Organization value) {
        this.manufacturerTarget = value;
        return this;
    }

    public CodeableConcept getForm() {
        if (this.form == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationKnowledge.form");
            }
            if (Configuration.doAutoCreate()) {
                this.form = new CodeableConcept();
            }
        }
        return this.form;
    }

    public boolean hasForm() {
        return this.form != null && !this.form.isEmpty();
    }

    public MedicationKnowledge setForm(CodeableConcept value) {
        this.form = value;
        return this;
    }

    public SimpleQuantity getAmount() {
        if (this.amount == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationKnowledge.amount");
            }
            if (Configuration.doAutoCreate()) {
                this.amount = new SimpleQuantity();
            }
        }
        return this.amount;
    }

    public boolean hasAmount() {
        return this.amount != null && !this.amount.isEmpty();
    }

    public MedicationKnowledge setAmount(SimpleQuantity value) {
        this.amount = value;
        return this;
    }

    public List<StringType> getSynonym() {
        if (this.synonym == null) {
            this.synonym = new ArrayList<StringType>();
        }
        return this.synonym;
    }

    public MedicationKnowledge setSynonym(List<StringType> theSynonym) {
        this.synonym = theSynonym;
        return this;
    }

    public boolean hasSynonym() {
        if (this.synonym == null) {
            return false;
        }
        for (StringType item : this.synonym) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addSynonymElement() {
        StringType t = new StringType();
        if (this.synonym == null) {
            this.synonym = new ArrayList<StringType>();
        }
        this.synonym.add(t);
        return t;
    }

    public MedicationKnowledge addSynonym(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.synonym == null) {
            this.synonym = new ArrayList<StringType>();
        }
        this.synonym.add(t);
        return this;
    }

    public boolean hasSynonym(String value) {
        if (this.synonym == null) {
            return false;
        }
        for (StringType v : this.synonym) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<Reference> getRelatedMedicationKnowledge() {
        if (this.relatedMedicationKnowledge == null) {
            this.relatedMedicationKnowledge = new ArrayList<Reference>();
        }
        return this.relatedMedicationKnowledge;
    }

    public MedicationKnowledge setRelatedMedicationKnowledge(List<Reference> theRelatedMedicationKnowledge) {
        this.relatedMedicationKnowledge = theRelatedMedicationKnowledge;
        return this;
    }

    public boolean hasRelatedMedicationKnowledge() {
        if (this.relatedMedicationKnowledge == null) {
            return false;
        }
        for (Reference item : this.relatedMedicationKnowledge) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addRelatedMedicationKnowledge() {
        Reference t = new Reference();
        if (this.relatedMedicationKnowledge == null) {
            this.relatedMedicationKnowledge = new ArrayList<Reference>();
        }
        this.relatedMedicationKnowledge.add(t);
        return t;
    }

    public MedicationKnowledge addRelatedMedicationKnowledge(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.relatedMedicationKnowledge == null) {
            this.relatedMedicationKnowledge = new ArrayList<Reference>();
        }
        this.relatedMedicationKnowledge.add(t);
        return this;
    }

    public Reference getRelatedMedicationKnowledgeFirstRep() {
        if (this.getRelatedMedicationKnowledge().isEmpty()) {
            this.addRelatedMedicationKnowledge();
        }
        return this.getRelatedMedicationKnowledge().get(0);
    }

    @Deprecated
    public List<MedicationKnowledge> getRelatedMedicationKnowledgeTarget() {
        if (this.relatedMedicationKnowledgeTarget == null) {
            this.relatedMedicationKnowledgeTarget = new ArrayList<MedicationKnowledge>();
        }
        return this.relatedMedicationKnowledgeTarget;
    }

    @Deprecated
    public MedicationKnowledge addRelatedMedicationKnowledgeTarget() {
        MedicationKnowledge r = new MedicationKnowledge();
        if (this.relatedMedicationKnowledgeTarget == null) {
            this.relatedMedicationKnowledgeTarget = new ArrayList<MedicationKnowledge>();
        }
        this.relatedMedicationKnowledgeTarget.add(r);
        return r;
    }

    public Reference getAssociatedMedication() {
        if (this.associatedMedication == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationKnowledge.associatedMedication");
            }
            if (Configuration.doAutoCreate()) {
                this.associatedMedication = new Reference();
            }
        }
        return this.associatedMedication;
    }

    public boolean hasAssociatedMedication() {
        return this.associatedMedication != null && !this.associatedMedication.isEmpty();
    }

    public MedicationKnowledge setAssociatedMedication(Reference value) {
        this.associatedMedication = value;
        return this;
    }

    public Medication getAssociatedMedicationTarget() {
        if (this.associatedMedicationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationKnowledge.associatedMedication");
            }
            if (Configuration.doAutoCreate()) {
                this.associatedMedicationTarget = new Medication();
            }
        }
        return this.associatedMedicationTarget;
    }

    public MedicationKnowledge setAssociatedMedicationTarget(Medication value) {
        this.associatedMedicationTarget = value;
        return this;
    }

    public List<CodeableConcept> getProductType() {
        if (this.productType == null) {
            this.productType = new ArrayList<CodeableConcept>();
        }
        return this.productType;
    }

    public MedicationKnowledge setProductType(List<CodeableConcept> theProductType) {
        this.productType = theProductType;
        return this;
    }

    public boolean hasProductType() {
        if (this.productType == null) {
            return false;
        }
        for (CodeableConcept item : this.productType) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addProductType() {
        CodeableConcept t = new CodeableConcept();
        if (this.productType == null) {
            this.productType = new ArrayList<CodeableConcept>();
        }
        this.productType.add(t);
        return t;
    }

    public MedicationKnowledge addProductType(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.productType == null) {
            this.productType = new ArrayList<CodeableConcept>();
        }
        this.productType.add(t);
        return this;
    }

    public CodeableConcept getProductTypeFirstRep() {
        if (this.getProductType().isEmpty()) {
            this.addProductType();
        }
        return this.getProductType().get(0);
    }

    public List<MedicationKnowledgeMonographComponent> getMonograph() {
        if (this.monograph == null) {
            this.monograph = new ArrayList<MedicationKnowledgeMonographComponent>();
        }
        return this.monograph;
    }

    public MedicationKnowledge setMonograph(List<MedicationKnowledgeMonographComponent> theMonograph) {
        this.monograph = theMonograph;
        return this;
    }

    public boolean hasMonograph() {
        if (this.monograph == null) {
            return false;
        }
        for (MedicationKnowledgeMonographComponent item : this.monograph) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicationKnowledgeMonographComponent addMonograph() {
        MedicationKnowledgeMonographComponent t = new MedicationKnowledgeMonographComponent();
        if (this.monograph == null) {
            this.monograph = new ArrayList<MedicationKnowledgeMonographComponent>();
        }
        this.monograph.add(t);
        return t;
    }

    public MedicationKnowledge addMonograph(MedicationKnowledgeMonographComponent t) {
        if (t == null) {
            return this;
        }
        if (this.monograph == null) {
            this.monograph = new ArrayList<MedicationKnowledgeMonographComponent>();
        }
        this.monograph.add(t);
        return this;
    }

    public MedicationKnowledgeMonographComponent getMonographFirstRep() {
        if (this.getMonograph().isEmpty()) {
            this.addMonograph();
        }
        return this.getMonograph().get(0);
    }

    public Duration getHalfLifePeriod() {
        if (this.halfLifePeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationKnowledge.halfLifePeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.halfLifePeriod = new Duration();
            }
        }
        return this.halfLifePeriod;
    }

    public boolean hasHalfLifePeriod() {
        return this.halfLifePeriod != null && !this.halfLifePeriod.isEmpty();
    }

    public MedicationKnowledge setHalfLifePeriod(Duration value) {
        this.halfLifePeriod = value;
        return this;
    }

    public List<MedicationKnowledgeIngredientComponent> getIngredient() {
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<MedicationKnowledgeIngredientComponent>();
        }
        return this.ingredient;
    }

    public MedicationKnowledge setIngredient(List<MedicationKnowledgeIngredientComponent> theIngredient) {
        this.ingredient = theIngredient;
        return this;
    }

    public boolean hasIngredient() {
        if (this.ingredient == null) {
            return false;
        }
        for (MedicationKnowledgeIngredientComponent item : this.ingredient) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicationKnowledgeIngredientComponent addIngredient() {
        MedicationKnowledgeIngredientComponent t = new MedicationKnowledgeIngredientComponent();
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<MedicationKnowledgeIngredientComponent>();
        }
        this.ingredient.add(t);
        return t;
    }

    public MedicationKnowledge addIngredient(MedicationKnowledgeIngredientComponent t) {
        if (t == null) {
            return this;
        }
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<MedicationKnowledgeIngredientComponent>();
        }
        this.ingredient.add(t);
        return this;
    }

    public MedicationKnowledgeIngredientComponent getIngredientFirstRep() {
        if (this.getIngredient().isEmpty()) {
            this.addIngredient();
        }
        return this.getIngredient().get(0);
    }

    public MarkdownType getPreparationInstructionElement() {
        if (this.preparationInstruction == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationKnowledge.preparationInstruction");
            }
            if (Configuration.doAutoCreate()) {
                this.preparationInstruction = new MarkdownType();
            }
        }
        return this.preparationInstruction;
    }

    public boolean hasPreparationInstructionElement() {
        return this.preparationInstruction != null && !this.preparationInstruction.isEmpty();
    }

    public boolean hasPreparationInstruction() {
        return this.preparationInstruction != null && !this.preparationInstruction.isEmpty();
    }

    public MedicationKnowledge setPreparationInstructionElement(MarkdownType value) {
        this.preparationInstruction = value;
        return this;
    }

    public String getPreparationInstruction() {
        return this.preparationInstruction == null ? null : (String)this.preparationInstruction.getValue();
    }

    public MedicationKnowledge setPreparationInstruction(String value) {
        if (value == null) {
            this.preparationInstruction = null;
        } else {
            if (this.preparationInstruction == null) {
                this.preparationInstruction = new MarkdownType();
            }
            this.preparationInstruction.setValue(value);
        }
        return this;
    }

    public List<CodeableConcept> getIntendedRoute() {
        if (this.intendedRoute == null) {
            this.intendedRoute = new ArrayList<CodeableConcept>();
        }
        return this.intendedRoute;
    }

    public MedicationKnowledge setIntendedRoute(List<CodeableConcept> theIntendedRoute) {
        this.intendedRoute = theIntendedRoute;
        return this;
    }

    public boolean hasIntendedRoute() {
        if (this.intendedRoute == null) {
            return false;
        }
        for (CodeableConcept item : this.intendedRoute) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addIntendedRoute() {
        CodeableConcept t = new CodeableConcept();
        if (this.intendedRoute == null) {
            this.intendedRoute = new ArrayList<CodeableConcept>();
        }
        this.intendedRoute.add(t);
        return t;
    }

    public MedicationKnowledge addIntendedRoute(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.intendedRoute == null) {
            this.intendedRoute = new ArrayList<CodeableConcept>();
        }
        this.intendedRoute.add(t);
        return this;
    }

    public CodeableConcept getIntendedRouteFirstRep() {
        if (this.getIntendedRoute().isEmpty()) {
            this.addIntendedRoute();
        }
        return this.getIntendedRoute().get(0);
    }

    public List<MedicationKnowledgeCostComponent> getCost() {
        if (this.cost == null) {
            this.cost = new ArrayList<MedicationKnowledgeCostComponent>();
        }
        return this.cost;
    }

    public MedicationKnowledge setCost(List<MedicationKnowledgeCostComponent> theCost) {
        this.cost = theCost;
        return this;
    }

    public boolean hasCost() {
        if (this.cost == null) {
            return false;
        }
        for (MedicationKnowledgeCostComponent item : this.cost) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicationKnowledgeCostComponent addCost() {
        MedicationKnowledgeCostComponent t = new MedicationKnowledgeCostComponent();
        if (this.cost == null) {
            this.cost = new ArrayList<MedicationKnowledgeCostComponent>();
        }
        this.cost.add(t);
        return t;
    }

    public MedicationKnowledge addCost(MedicationKnowledgeCostComponent t) {
        if (t == null) {
            return this;
        }
        if (this.cost == null) {
            this.cost = new ArrayList<MedicationKnowledgeCostComponent>();
        }
        this.cost.add(t);
        return this;
    }

    public MedicationKnowledgeCostComponent getCostFirstRep() {
        if (this.getCost().isEmpty()) {
            this.addCost();
        }
        return this.getCost().get(0);
    }

    public List<MedicationKnowledgeMonitoringProgramComponent> getMonitoringProgram() {
        if (this.monitoringProgram == null) {
            this.monitoringProgram = new ArrayList<MedicationKnowledgeMonitoringProgramComponent>();
        }
        return this.monitoringProgram;
    }

    public MedicationKnowledge setMonitoringProgram(List<MedicationKnowledgeMonitoringProgramComponent> theMonitoringProgram) {
        this.monitoringProgram = theMonitoringProgram;
        return this;
    }

    public boolean hasMonitoringProgram() {
        if (this.monitoringProgram == null) {
            return false;
        }
        for (MedicationKnowledgeMonitoringProgramComponent item : this.monitoringProgram) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicationKnowledgeMonitoringProgramComponent addMonitoringProgram() {
        MedicationKnowledgeMonitoringProgramComponent t = new MedicationKnowledgeMonitoringProgramComponent();
        if (this.monitoringProgram == null) {
            this.monitoringProgram = new ArrayList<MedicationKnowledgeMonitoringProgramComponent>();
        }
        this.monitoringProgram.add(t);
        return t;
    }

    public MedicationKnowledge addMonitoringProgram(MedicationKnowledgeMonitoringProgramComponent t) {
        if (t == null) {
            return this;
        }
        if (this.monitoringProgram == null) {
            this.monitoringProgram = new ArrayList<MedicationKnowledgeMonitoringProgramComponent>();
        }
        this.monitoringProgram.add(t);
        return this;
    }

    public MedicationKnowledgeMonitoringProgramComponent getMonitoringProgramFirstRep() {
        if (this.getMonitoringProgram().isEmpty()) {
            this.addMonitoringProgram();
        }
        return this.getMonitoringProgram().get(0);
    }

    public List<MedicationKnowledgeAdministrationGuidelinesComponent> getAdministrationGuidelines() {
        if (this.administrationGuidelines == null) {
            this.administrationGuidelines = new ArrayList<MedicationKnowledgeAdministrationGuidelinesComponent>();
        }
        return this.administrationGuidelines;
    }

    public MedicationKnowledge setAdministrationGuidelines(List<MedicationKnowledgeAdministrationGuidelinesComponent> theAdministrationGuidelines) {
        this.administrationGuidelines = theAdministrationGuidelines;
        return this;
    }

    public boolean hasAdministrationGuidelines() {
        if (this.administrationGuidelines == null) {
            return false;
        }
        for (MedicationKnowledgeAdministrationGuidelinesComponent item : this.administrationGuidelines) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicationKnowledgeAdministrationGuidelinesComponent addAdministrationGuidelines() {
        MedicationKnowledgeAdministrationGuidelinesComponent t = new MedicationKnowledgeAdministrationGuidelinesComponent();
        if (this.administrationGuidelines == null) {
            this.administrationGuidelines = new ArrayList<MedicationKnowledgeAdministrationGuidelinesComponent>();
        }
        this.administrationGuidelines.add(t);
        return t;
    }

    public MedicationKnowledge addAdministrationGuidelines(MedicationKnowledgeAdministrationGuidelinesComponent t) {
        if (t == null) {
            return this;
        }
        if (this.administrationGuidelines == null) {
            this.administrationGuidelines = new ArrayList<MedicationKnowledgeAdministrationGuidelinesComponent>();
        }
        this.administrationGuidelines.add(t);
        return this;
    }

    public MedicationKnowledgeAdministrationGuidelinesComponent getAdministrationGuidelinesFirstRep() {
        if (this.getAdministrationGuidelines().isEmpty()) {
            this.addAdministrationGuidelines();
        }
        return this.getAdministrationGuidelines().get(0);
    }

    public List<MedicationKnowledgeMedicineClassificationComponent> getMedicineClassification() {
        if (this.medicineClassification == null) {
            this.medicineClassification = new ArrayList<MedicationKnowledgeMedicineClassificationComponent>();
        }
        return this.medicineClassification;
    }

    public MedicationKnowledge setMedicineClassification(List<MedicationKnowledgeMedicineClassificationComponent> theMedicineClassification) {
        this.medicineClassification = theMedicineClassification;
        return this;
    }

    public boolean hasMedicineClassification() {
        if (this.medicineClassification == null) {
            return false;
        }
        for (MedicationKnowledgeMedicineClassificationComponent item : this.medicineClassification) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicationKnowledgeMedicineClassificationComponent addMedicineClassification() {
        MedicationKnowledgeMedicineClassificationComponent t = new MedicationKnowledgeMedicineClassificationComponent();
        if (this.medicineClassification == null) {
            this.medicineClassification = new ArrayList<MedicationKnowledgeMedicineClassificationComponent>();
        }
        this.medicineClassification.add(t);
        return t;
    }

    public MedicationKnowledge addMedicineClassification(MedicationKnowledgeMedicineClassificationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.medicineClassification == null) {
            this.medicineClassification = new ArrayList<MedicationKnowledgeMedicineClassificationComponent>();
        }
        this.medicineClassification.add(t);
        return this;
    }

    public MedicationKnowledgeMedicineClassificationComponent getMedicineClassificationFirstRep() {
        if (this.getMedicineClassification().isEmpty()) {
            this.addMedicineClassification();
        }
        return this.getMedicineClassification().get(0);
    }

    public MedicationKnowledgePackagingComponent getPackaging() {
        if (this.packaging == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationKnowledge.packaging");
            }
            if (Configuration.doAutoCreate()) {
                this.packaging = new MedicationKnowledgePackagingComponent();
            }
        }
        return this.packaging;
    }

    public boolean hasPackaging() {
        return this.packaging != null && !this.packaging.isEmpty();
    }

    public MedicationKnowledge setPackaging(MedicationKnowledgePackagingComponent value) {
        this.packaging = value;
        return this;
    }

    public List<MedicationKnowledgeDrugCharacteristicComponent> getDrugCharacteristic() {
        if (this.drugCharacteristic == null) {
            this.drugCharacteristic = new ArrayList<MedicationKnowledgeDrugCharacteristicComponent>();
        }
        return this.drugCharacteristic;
    }

    public MedicationKnowledge setDrugCharacteristic(List<MedicationKnowledgeDrugCharacteristicComponent> theDrugCharacteristic) {
        this.drugCharacteristic = theDrugCharacteristic;
        return this;
    }

    public boolean hasDrugCharacteristic() {
        if (this.drugCharacteristic == null) {
            return false;
        }
        for (MedicationKnowledgeDrugCharacteristicComponent item : this.drugCharacteristic) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicationKnowledgeDrugCharacteristicComponent addDrugCharacteristic() {
        MedicationKnowledgeDrugCharacteristicComponent t = new MedicationKnowledgeDrugCharacteristicComponent();
        if (this.drugCharacteristic == null) {
            this.drugCharacteristic = new ArrayList<MedicationKnowledgeDrugCharacteristicComponent>();
        }
        this.drugCharacteristic.add(t);
        return t;
    }

    public MedicationKnowledge addDrugCharacteristic(MedicationKnowledgeDrugCharacteristicComponent t) {
        if (t == null) {
            return this;
        }
        if (this.drugCharacteristic == null) {
            this.drugCharacteristic = new ArrayList<MedicationKnowledgeDrugCharacteristicComponent>();
        }
        this.drugCharacteristic.add(t);
        return this;
    }

    public MedicationKnowledgeDrugCharacteristicComponent getDrugCharacteristicFirstRep() {
        if (this.getDrugCharacteristic().isEmpty()) {
            this.addDrugCharacteristic();
        }
        return this.getDrugCharacteristic().get(0);
    }

    public List<Reference> getContraindication() {
        if (this.contraindication == null) {
            this.contraindication = new ArrayList<Reference>();
        }
        return this.contraindication;
    }

    public MedicationKnowledge setContraindication(List<Reference> theContraindication) {
        this.contraindication = theContraindication;
        return this;
    }

    public boolean hasContraindication() {
        if (this.contraindication == null) {
            return false;
        }
        for (Reference item : this.contraindication) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addContraindication() {
        Reference t = new Reference();
        if (this.contraindication == null) {
            this.contraindication = new ArrayList<Reference>();
        }
        this.contraindication.add(t);
        return t;
    }

    public MedicationKnowledge addContraindication(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.contraindication == null) {
            this.contraindication = new ArrayList<Reference>();
        }
        this.contraindication.add(t);
        return this;
    }

    public Reference getContraindicationFirstRep() {
        if (this.getContraindication().isEmpty()) {
            this.addContraindication();
        }
        return this.getContraindication().get(0);
    }

    @Deprecated
    public List<DetectedIssue> getContraindicationTarget() {
        if (this.contraindicationTarget == null) {
            this.contraindicationTarget = new ArrayList<DetectedIssue>();
        }
        return this.contraindicationTarget;
    }

    @Deprecated
    public DetectedIssue addContraindicationTarget() {
        DetectedIssue r = new DetectedIssue();
        if (this.contraindicationTarget == null) {
            this.contraindicationTarget = new ArrayList<DetectedIssue>();
        }
        this.contraindicationTarget.add(r);
        return r;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_CODE, "CodeableConcept", "A code that specifies this medication, or a textual description if no code is available. Usage note: This could be a standard medication code such as a code from RxNorm, SNOMED CT, IDMP etc. It could also be a national or local formulary code, optionally with translations to other code systems.", 0, 1, this.code));
        children.add(new Property(SP_STATUS, SP_CODE, "A code to indicate if the medication is in active use.", 0, 1, this.status));
        children.add(new Property(SP_MANUFACTURER, "Reference(Organization)", "Describes the details of the manufacturer of the medication product.  This is not intended to represent the distributor of a medication product.", 0, 1, this.manufacturer));
        children.add(new Property(SP_FORM, "CodeableConcept", "Describes the form of the item.  Powder; tablets; capsule.", 0, 1, this.form));
        children.add(new Property("amount", "SimpleQuantity", "Specific amount of the drug in the packaged product.  For example, when specifying a product that has the same strength (For example, Insulin glargine 100 unit per mL solution for injection), this attribute provides additional clarification of the package amount (For example, 3 mL, 10mL, etc).", 0, 1, this.amount));
        children.add(new Property("synonym", "string", "Additional names for a medication, for example, the name(s) given to a medication in different countries.  For example, acetaminophen and paracetamol or salbutamol and albuterol.", 0, Integer.MAX_VALUE, this.synonym));
        children.add(new Property("relatedMedicationKnowledge", "Reference(MedicationKnowledge)", "Associated or related knowledge about a medication.", 0, Integer.MAX_VALUE, this.relatedMedicationKnowledge));
        children.add(new Property("associatedMedication", "Reference(Medication)", "Associated or related medications.  For example, if the medication is a branded product (e.g. Crestor), this is the Therapeutic Moeity (e.g. Rosuvastatin) or if this is a generic medication (e.g. Rosuvastatin), this would link to a branded product (e.g. Crestor).", 0, 1, this.associatedMedication));
        children.add(new Property("productType", "CodeableConcept", "Category of the medication or product (e.g. branded product, therapeutic moeity, generic product, innovator product, etc).", 0, Integer.MAX_VALUE, this.productType));
        children.add(new Property(SP_MONOGRAPH, "", "Associated documentation about the medication.", 0, Integer.MAX_VALUE, this.monograph));
        children.add(new Property("halfLifePeriod", "Duration", "The time required for any specified property (e.g., the concentration of a substance in the body) to decrease by half.", 0, 1, this.halfLifePeriod));
        children.add(new Property(SP_INGREDIENT, "", "Identifies a particular constituent of interest in the product.", 0, Integer.MAX_VALUE, this.ingredient));
        children.add(new Property("preparationInstruction", "markdown", "The instructions for preparing the medication.", 0, 1, this.preparationInstruction));
        children.add(new Property("intendedRoute", "CodeableConcept", "The intended or approved route of administration.", 0, Integer.MAX_VALUE, this.intendedRoute));
        children.add(new Property("cost", "", "The price of the medication.", 0, Integer.MAX_VALUE, this.cost));
        children.add(new Property("monitoringProgram", "", "The program under which the medication is reviewed.", 0, Integer.MAX_VALUE, this.monitoringProgram));
        children.add(new Property("administrationGuidelines", "", "Guidelines for the administration of the medication.", 0, Integer.MAX_VALUE, this.administrationGuidelines));
        children.add(new Property("medicineClassification", "", "Categorization of the medication within a formulary or classification system.", 0, Integer.MAX_VALUE, this.medicineClassification));
        children.add(new Property("packaging", "", "Information that only applies to packages (not products).", 0, 1, this.packaging));
        children.add(new Property("drugCharacteristic", "", "Specifies descriptive properties of the medicine, such as color, shape, imprints, etc.", 0, Integer.MAX_VALUE, this.drugCharacteristic));
        children.add(new Property("contraindication", "Reference(DetectedIssue)", "Potential clinical issue with or between medication(s) (for example, drug-drug interaction, drug-disease contraindication, drug-allergy interaction, etc).", 0, Integer.MAX_VALUE, this.contraindication));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 3059181: {
                return new Property(SP_CODE, "CodeableConcept", "A code that specifies this medication, or a textual description if no code is available. Usage note: This could be a standard medication code such as a code from RxNorm, SNOMED CT, IDMP etc. It could also be a national or local formulary code, optionally with translations to other code systems.", 0, 1, this.code);
            }
            case -892481550: {
                return new Property(SP_STATUS, SP_CODE, "A code to indicate if the medication is in active use.", 0, 1, this.status);
            }
            case -1969347631: {
                return new Property(SP_MANUFACTURER, "Reference(Organization)", "Describes the details of the manufacturer of the medication product.  This is not intended to represent the distributor of a medication product.", 0, 1, this.manufacturer);
            }
            case 3148996: {
                return new Property(SP_FORM, "CodeableConcept", "Describes the form of the item.  Powder; tablets; capsule.", 0, 1, this.form);
            }
            case -1413853096: {
                return new Property("amount", "SimpleQuantity", "Specific amount of the drug in the packaged product.  For example, when specifying a product that has the same strength (For example, Insulin glargine 100 unit per mL solution for injection), this attribute provides additional clarification of the package amount (For example, 3 mL, 10mL, etc).", 0, 1, this.amount);
            }
            case -1742128133: {
                return new Property("synonym", "string", "Additional names for a medication, for example, the name(s) given to a medication in different countries.  For example, acetaminophen and paracetamol or salbutamol and albuterol.", 0, Integer.MAX_VALUE, this.synonym);
            }
            case 723067972: {
                return new Property("relatedMedicationKnowledge", "Reference(MedicationKnowledge)", "Associated or related knowledge about a medication.", 0, Integer.MAX_VALUE, this.relatedMedicationKnowledge);
            }
            case 1312779381: {
                return new Property("associatedMedication", "Reference(Medication)", "Associated or related medications.  For example, if the medication is a branded product (e.g. Crestor), this is the Therapeutic Moeity (e.g. Rosuvastatin) or if this is a generic medication (e.g. Rosuvastatin), this would link to a branded product (e.g. Crestor).", 0, 1, this.associatedMedication);
            }
            case -1491615543: {
                return new Property("productType", "CodeableConcept", "Category of the medication or product (e.g. branded product, therapeutic moeity, generic product, innovator product, etc).", 0, Integer.MAX_VALUE, this.productType);
            }
            case -1442980789: {
                return new Property(SP_MONOGRAPH, "", "Associated documentation about the medication.", 0, Integer.MAX_VALUE, this.monograph);
            }
            case -628810640: {
                return new Property("halfLifePeriod", "Duration", "The time required for any specified property (e.g., the concentration of a substance in the body) to decrease by half.", 0, 1, this.halfLifePeriod);
            }
            case -206409263: {
                return new Property(SP_INGREDIENT, "", "Identifies a particular constituent of interest in the product.", 0, Integer.MAX_VALUE, this.ingredient);
            }
            case 1025456503: {
                return new Property("preparationInstruction", "markdown", "The instructions for preparing the medication.", 0, 1, this.preparationInstruction);
            }
            case -767798050: {
                return new Property("intendedRoute", "CodeableConcept", "The intended or approved route of administration.", 0, Integer.MAX_VALUE, this.intendedRoute);
            }
            case 3059661: {
                return new Property("cost", "", "The price of the medication.", 0, Integer.MAX_VALUE, this.cost);
            }
            case 569848092: {
                return new Property("monitoringProgram", "", "The program under which the medication is reviewed.", 0, Integer.MAX_VALUE, this.monitoringProgram);
            }
            case 496930945: {
                return new Property("administrationGuidelines", "", "Guidelines for the administration of the medication.", 0, Integer.MAX_VALUE, this.administrationGuidelines);
            }
            case 1791551680: {
                return new Property("medicineClassification", "", "Categorization of the medication within a formulary or classification system.", 0, Integer.MAX_VALUE, this.medicineClassification);
            }
            case 1802065795: {
                return new Property("packaging", "", "Information that only applies to packages (not products).", 0, 1, this.packaging);
            }
            case -844126885: {
                return new Property("drugCharacteristic", "", "Specifies descriptive properties of the medicine, such as color, shape, imprints, etc.", 0, Integer.MAX_VALUE, this.drugCharacteristic);
            }
            case 107135229: {
                return new Property("contraindication", "Reference(DetectedIssue)", "Potential clinical issue with or between medication(s) (for example, drug-drug interaction, drug-disease contraindication, drug-allergy interaction, etc).", 0, Integer.MAX_VALUE, this.contraindication);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.code;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case -1969347631: {
                Base[] baseArray;
                if (this.manufacturer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.manufacturer;
                }
                return baseArray;
            }
            case 3148996: {
                Base[] baseArray;
                if (this.form == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.form;
                }
                return baseArray;
            }
            case -1413853096: {
                Base[] baseArray;
                if (this.amount == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.amount;
                }
                return baseArray;
            }
            case -1742128133: {
                return this.synonym == null ? new Base[]{} : this.synonym.toArray(new Base[this.synonym.size()]);
            }
            case 723067972: {
                return this.relatedMedicationKnowledge == null ? new Base[]{} : this.relatedMedicationKnowledge.toArray(new Base[this.relatedMedicationKnowledge.size()]);
            }
            case 1312779381: {
                Base[] baseArray;
                if (this.associatedMedication == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.associatedMedication;
                }
                return baseArray;
            }
            case -1491615543: {
                return this.productType == null ? new Base[]{} : this.productType.toArray(new Base[this.productType.size()]);
            }
            case -1442980789: {
                return this.monograph == null ? new Base[]{} : this.monograph.toArray(new Base[this.monograph.size()]);
            }
            case -628810640: {
                Base[] baseArray;
                if (this.halfLifePeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.halfLifePeriod;
                }
                return baseArray;
            }
            case -206409263: {
                return this.ingredient == null ? new Base[]{} : this.ingredient.toArray(new Base[this.ingredient.size()]);
            }
            case 1025456503: {
                Base[] baseArray;
                if (this.preparationInstruction == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.preparationInstruction;
                }
                return baseArray;
            }
            case -767798050: {
                return this.intendedRoute == null ? new Base[]{} : this.intendedRoute.toArray(new Base[this.intendedRoute.size()]);
            }
            case 3059661: {
                return this.cost == null ? new Base[]{} : this.cost.toArray(new Base[this.cost.size()]);
            }
            case 569848092: {
                return this.monitoringProgram == null ? new Base[]{} : this.monitoringProgram.toArray(new Base[this.monitoringProgram.size()]);
            }
            case 496930945: {
                return this.administrationGuidelines == null ? new Base[]{} : this.administrationGuidelines.toArray(new Base[this.administrationGuidelines.size()]);
            }
            case 1791551680: {
                return this.medicineClassification == null ? new Base[]{} : this.medicineClassification.toArray(new Base[this.medicineClassification.size()]);
            }
            case 1802065795: {
                Base[] baseArray;
                if (this.packaging == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.packaging;
                }
                return baseArray;
            }
            case -844126885: {
                return this.drugCharacteristic == null ? new Base[]{} : this.drugCharacteristic.toArray(new Base[this.drugCharacteristic.size()]);
            }
            case 107135229: {
                return this.contraindication == null ? new Base[]{} : this.contraindication.toArray(new Base[this.contraindication.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 3059181: {
                this.code = this.castToCodeableConcept(value);
                return value;
            }
            case -892481550: {
                value = new MedicationKnowledgeStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case -1969347631: {
                this.manufacturer = this.castToReference(value);
                return value;
            }
            case 3148996: {
                this.form = this.castToCodeableConcept(value);
                return value;
            }
            case -1413853096: {
                this.amount = this.castToSimpleQuantity(value);
                return value;
            }
            case -1742128133: {
                this.getSynonym().add(this.castToString(value));
                return value;
            }
            case 723067972: {
                this.getRelatedMedicationKnowledge().add(this.castToReference(value));
                return value;
            }
            case 1312779381: {
                this.associatedMedication = this.castToReference(value);
                return value;
            }
            case -1491615543: {
                this.getProductType().add(this.castToCodeableConcept(value));
                return value;
            }
            case -1442980789: {
                this.getMonograph().add((MedicationKnowledgeMonographComponent)((Object)value));
                return value;
            }
            case -628810640: {
                this.halfLifePeriod = this.castToDuration(value);
                return value;
            }
            case -206409263: {
                this.getIngredient().add((MedicationKnowledgeIngredientComponent)((Object)value));
                return value;
            }
            case 1025456503: {
                this.preparationInstruction = this.castToMarkdown(value);
                return value;
            }
            case -767798050: {
                this.getIntendedRoute().add(this.castToCodeableConcept(value));
                return value;
            }
            case 3059661: {
                this.getCost().add((MedicationKnowledgeCostComponent)((Object)value));
                return value;
            }
            case 569848092: {
                this.getMonitoringProgram().add((MedicationKnowledgeMonitoringProgramComponent)((Object)value));
                return value;
            }
            case 496930945: {
                this.getAdministrationGuidelines().add((MedicationKnowledgeAdministrationGuidelinesComponent)((Object)value));
                return value;
            }
            case 1791551680: {
                this.getMedicineClassification().add((MedicationKnowledgeMedicineClassificationComponent)((Object)value));
                return value;
            }
            case 1802065795: {
                this.packaging = (MedicationKnowledgePackagingComponent)((Object)value);
                return value;
            }
            case -844126885: {
                this.getDrugCharacteristic().add((MedicationKnowledgeDrugCharacteristicComponent)((Object)value));
                return value;
            }
            case 107135229: {
                this.getContraindication().add(this.castToReference(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_CODE)) {
            this.code = this.castToCodeableConcept(value);
        } else if (name.equals(SP_STATUS)) {
            value = new MedicationKnowledgeStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_MANUFACTURER)) {
            this.manufacturer = this.castToReference(value);
        } else if (name.equals(SP_FORM)) {
            this.form = this.castToCodeableConcept(value);
        } else if (name.equals("amount")) {
            this.amount = this.castToSimpleQuantity(value);
        } else if (name.equals("synonym")) {
            this.getSynonym().add(this.castToString(value));
        } else if (name.equals("relatedMedicationKnowledge")) {
            this.getRelatedMedicationKnowledge().add(this.castToReference(value));
        } else if (name.equals("associatedMedication")) {
            this.associatedMedication = this.castToReference(value);
        } else if (name.equals("productType")) {
            this.getProductType().add(this.castToCodeableConcept(value));
        } else if (name.equals(SP_MONOGRAPH)) {
            this.getMonograph().add((MedicationKnowledgeMonographComponent)((Object)value));
        } else if (name.equals("halfLifePeriod")) {
            this.halfLifePeriod = this.castToDuration(value);
        } else if (name.equals(SP_INGREDIENT)) {
            this.getIngredient().add((MedicationKnowledgeIngredientComponent)((Object)value));
        } else if (name.equals("preparationInstruction")) {
            this.preparationInstruction = this.castToMarkdown(value);
        } else if (name.equals("intendedRoute")) {
            this.getIntendedRoute().add(this.castToCodeableConcept(value));
        } else if (name.equals("cost")) {
            this.getCost().add((MedicationKnowledgeCostComponent)((Object)value));
        } else if (name.equals("monitoringProgram")) {
            this.getMonitoringProgram().add((MedicationKnowledgeMonitoringProgramComponent)((Object)value));
        } else if (name.equals("administrationGuidelines")) {
            this.getAdministrationGuidelines().add((MedicationKnowledgeAdministrationGuidelinesComponent)((Object)value));
        } else if (name.equals("medicineClassification")) {
            this.getMedicineClassification().add((MedicationKnowledgeMedicineClassificationComponent)((Object)value));
        } else if (name.equals("packaging")) {
            this.packaging = (MedicationKnowledgePackagingComponent)((Object)value);
        } else if (name.equals("drugCharacteristic")) {
            this.getDrugCharacteristic().add((MedicationKnowledgeDrugCharacteristicComponent)((Object)value));
        } else if (name.equals("contraindication")) {
            this.getContraindication().add(this.castToReference(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3059181: {
                return this.getCode();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -1969347631: {
                return this.getManufacturer();
            }
            case 3148996: {
                return this.getForm();
            }
            case -1413853096: {
                return this.getAmount();
            }
            case -1742128133: {
                return this.addSynonymElement();
            }
            case 723067972: {
                return this.addRelatedMedicationKnowledge();
            }
            case 1312779381: {
                return this.getAssociatedMedication();
            }
            case -1491615543: {
                return this.addProductType();
            }
            case -1442980789: {
                return this.addMonograph();
            }
            case -628810640: {
                return this.getHalfLifePeriod();
            }
            case -206409263: {
                return this.addIngredient();
            }
            case 1025456503: {
                return this.getPreparationInstructionElement();
            }
            case -767798050: {
                return this.addIntendedRoute();
            }
            case 3059661: {
                return this.addCost();
            }
            case 569848092: {
                return this.addMonitoringProgram();
            }
            case 496930945: {
                return this.addAdministrationGuidelines();
            }
            case 1791551680: {
                return this.addMedicineClassification();
            }
            case 1802065795: {
                return this.getPackaging();
            }
            case -844126885: {
                return this.addDrugCharacteristic();
            }
            case 107135229: {
                return this.addContraindication();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case -1969347631: {
                return new String[]{"Reference"};
            }
            case 3148996: {
                return new String[]{"CodeableConcept"};
            }
            case -1413853096: {
                return new String[]{"SimpleQuantity"};
            }
            case -1742128133: {
                return new String[]{"string"};
            }
            case 723067972: {
                return new String[]{"Reference"};
            }
            case 1312779381: {
                return new String[]{"Reference"};
            }
            case -1491615543: {
                return new String[]{"CodeableConcept"};
            }
            case -1442980789: {
                return new String[0];
            }
            case -628810640: {
                return new String[]{"Duration"};
            }
            case -206409263: {
                return new String[0];
            }
            case 1025456503: {
                return new String[]{"markdown"};
            }
            case -767798050: {
                return new String[]{"CodeableConcept"};
            }
            case 3059661: {
                return new String[0];
            }
            case 569848092: {
                return new String[0];
            }
            case 496930945: {
                return new String[0];
            }
            case 1791551680: {
                return new String[0];
            }
            case 1802065795: {
                return new String[0];
            }
            case -844126885: {
                return new String[0];
            }
            case 107135229: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_CODE)) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicationKnowledge.status");
        }
        if (name.equals(SP_MANUFACTURER)) {
            this.manufacturer = new Reference();
            return this.manufacturer;
        }
        if (name.equals(SP_FORM)) {
            this.form = new CodeableConcept();
            return this.form;
        }
        if (name.equals("amount")) {
            this.amount = new SimpleQuantity();
            return this.amount;
        }
        if (name.equals("synonym")) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicationKnowledge.synonym");
        }
        if (name.equals("relatedMedicationKnowledge")) {
            return this.addRelatedMedicationKnowledge();
        }
        if (name.equals("associatedMedication")) {
            this.associatedMedication = new Reference();
            return this.associatedMedication;
        }
        if (name.equals("productType")) {
            return this.addProductType();
        }
        if (name.equals(SP_MONOGRAPH)) {
            return this.addMonograph();
        }
        if (name.equals("halfLifePeriod")) {
            this.halfLifePeriod = new Duration();
            return this.halfLifePeriod;
        }
        if (name.equals(SP_INGREDIENT)) {
            return this.addIngredient();
        }
        if (name.equals("preparationInstruction")) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicationKnowledge.preparationInstruction");
        }
        if (name.equals("intendedRoute")) {
            return this.addIntendedRoute();
        }
        if (name.equals("cost")) {
            return this.addCost();
        }
        if (name.equals("monitoringProgram")) {
            return this.addMonitoringProgram();
        }
        if (name.equals("administrationGuidelines")) {
            return this.addAdministrationGuidelines();
        }
        if (name.equals("medicineClassification")) {
            return this.addMedicineClassification();
        }
        if (name.equals("packaging")) {
            this.packaging = new MedicationKnowledgePackagingComponent();
            return this.packaging;
        }
        if (name.equals("drugCharacteristic")) {
            return this.addDrugCharacteristic();
        }
        if (name.equals("contraindication")) {
            return this.addContraindication();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "MedicationKnowledge";
    }

    @Override
    public MedicationKnowledge copy() {
        MedicationKnowledge dst = new MedicationKnowledge();
        this.copyValues(dst);
        dst.code = this.code == null ? null : this.code.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.manufacturer = this.manufacturer == null ? null : this.manufacturer.copy();
        dst.form = this.form == null ? null : this.form.copy();
        SimpleQuantity simpleQuantity = dst.amount = this.amount == null ? null : this.amount.copy();
        if (this.synonym != null) {
            dst.synonym = new ArrayList<StringType>();
            for (StringType stringType : this.synonym) {
                dst.synonym.add(stringType.copy());
            }
        }
        if (this.relatedMedicationKnowledge != null) {
            dst.relatedMedicationKnowledge = new ArrayList<Reference>();
            for (Reference reference : this.relatedMedicationKnowledge) {
                dst.relatedMedicationKnowledge.add(reference.copy());
            }
        }
        Reference reference = dst.associatedMedication = this.associatedMedication == null ? null : this.associatedMedication.copy();
        if (this.productType != null) {
            dst.productType = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.productType) {
                dst.productType.add(codeableConcept.copy());
            }
        }
        if (this.monograph != null) {
            dst.monograph = new ArrayList<MedicationKnowledgeMonographComponent>();
            for (MedicationKnowledgeMonographComponent medicationKnowledgeMonographComponent : this.monograph) {
                dst.monograph.add(medicationKnowledgeMonographComponent.copy());
            }
        }
        Duration duration = dst.halfLifePeriod = this.halfLifePeriod == null ? null : this.halfLifePeriod.copy();
        if (this.ingredient != null) {
            dst.ingredient = new ArrayList<MedicationKnowledgeIngredientComponent>();
            for (MedicationKnowledgeIngredientComponent medicationKnowledgeIngredientComponent : this.ingredient) {
                dst.ingredient.add(medicationKnowledgeIngredientComponent.copy());
            }
        }
        MarkdownType markdownType = dst.preparationInstruction = this.preparationInstruction == null ? null : this.preparationInstruction.copy();
        if (this.intendedRoute != null) {
            dst.intendedRoute = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.intendedRoute) {
                dst.intendedRoute.add(codeableConcept.copy());
            }
        }
        if (this.cost != null) {
            dst.cost = new ArrayList<MedicationKnowledgeCostComponent>();
            for (MedicationKnowledgeCostComponent medicationKnowledgeCostComponent : this.cost) {
                dst.cost.add(medicationKnowledgeCostComponent.copy());
            }
        }
        if (this.monitoringProgram != null) {
            dst.monitoringProgram = new ArrayList<MedicationKnowledgeMonitoringProgramComponent>();
            for (MedicationKnowledgeMonitoringProgramComponent medicationKnowledgeMonitoringProgramComponent : this.monitoringProgram) {
                dst.monitoringProgram.add(medicationKnowledgeMonitoringProgramComponent.copy());
            }
        }
        if (this.administrationGuidelines != null) {
            dst.administrationGuidelines = new ArrayList<MedicationKnowledgeAdministrationGuidelinesComponent>();
            for (MedicationKnowledgeAdministrationGuidelinesComponent medicationKnowledgeAdministrationGuidelinesComponent : this.administrationGuidelines) {
                dst.administrationGuidelines.add(medicationKnowledgeAdministrationGuidelinesComponent.copy());
            }
        }
        if (this.medicineClassification != null) {
            dst.medicineClassification = new ArrayList<MedicationKnowledgeMedicineClassificationComponent>();
            for (MedicationKnowledgeMedicineClassificationComponent medicationKnowledgeMedicineClassificationComponent : this.medicineClassification) {
                dst.medicineClassification.add(medicationKnowledgeMedicineClassificationComponent.copy());
            }
        }
        MedicationKnowledgePackagingComponent medicationKnowledgePackagingComponent = dst.packaging = this.packaging == null ? null : this.packaging.copy();
        if (this.drugCharacteristic != null) {
            dst.drugCharacteristic = new ArrayList<MedicationKnowledgeDrugCharacteristicComponent>();
            for (MedicationKnowledgeDrugCharacteristicComponent medicationKnowledgeDrugCharacteristicComponent : this.drugCharacteristic) {
                dst.drugCharacteristic.add(medicationKnowledgeDrugCharacteristicComponent.copy());
            }
        }
        if (this.contraindication != null) {
            dst.contraindication = new ArrayList<Reference>();
            for (Reference reference2 : this.contraindication) {
                dst.contraindication.add(reference2.copy());
            }
        }
        return dst;
    }

    protected MedicationKnowledge typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicationKnowledge)) {
            return false;
        }
        MedicationKnowledge o = (MedicationKnowledge)other_;
        return MedicationKnowledge.compareDeep(this.code, o.code, true) && MedicationKnowledge.compareDeep(this.status, o.status, true) && MedicationKnowledge.compareDeep(this.manufacturer, o.manufacturer, true) && MedicationKnowledge.compareDeep(this.form, o.form, true) && MedicationKnowledge.compareDeep(this.amount, o.amount, true) && MedicationKnowledge.compareDeep(this.synonym, o.synonym, true) && MedicationKnowledge.compareDeep(this.relatedMedicationKnowledge, o.relatedMedicationKnowledge, true) && MedicationKnowledge.compareDeep(this.associatedMedication, o.associatedMedication, true) && MedicationKnowledge.compareDeep(this.productType, o.productType, true) && MedicationKnowledge.compareDeep(this.monograph, o.monograph, true) && MedicationKnowledge.compareDeep(this.halfLifePeriod, o.halfLifePeriod, true) && MedicationKnowledge.compareDeep(this.ingredient, o.ingredient, true) && MedicationKnowledge.compareDeep(this.preparationInstruction, o.preparationInstruction, true) && MedicationKnowledge.compareDeep(this.intendedRoute, o.intendedRoute, true) && MedicationKnowledge.compareDeep(this.cost, o.cost, true) && MedicationKnowledge.compareDeep(this.monitoringProgram, o.monitoringProgram, true) && MedicationKnowledge.compareDeep(this.administrationGuidelines, o.administrationGuidelines, true) && MedicationKnowledge.compareDeep(this.medicineClassification, o.medicineClassification, true) && MedicationKnowledge.compareDeep(this.packaging, o.packaging, true) && MedicationKnowledge.compareDeep(this.drugCharacteristic, o.drugCharacteristic, true) && MedicationKnowledge.compareDeep(this.contraindication, o.contraindication, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicationKnowledge)) {
            return false;
        }
        MedicationKnowledge o = (MedicationKnowledge)other_;
        return MedicationKnowledge.compareValues(this.status, o.status, true) && MedicationKnowledge.compareValues(this.synonym, o.synonym, true) && MedicationKnowledge.compareValues(this.preparationInstruction, o.preparationInstruction, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.code, this.status, this.manufacturer, this.form, this.amount, this.synonym, this.relatedMedicationKnowledge, this.associatedMedication, this.productType, this.monograph, this.halfLifePeriod, this.ingredient, this.preparationInstruction, this.intendedRoute, this.cost, this.monitoringProgram, this.administrationGuidelines, this.medicineClassification, this.packaging, this.drugCharacteristic, this.contraindication});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.MedicationKnowledge;
    }

    @Block
    public static class MedicationKnowledgeDrugCharacteristicComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code specifying the type of characteristic of medication", formalDefinition="A code specifying which characteristic of the medicine is being described (for example, colour, shape, imprint).")
        protected CodeableConcept type;
        @Child(name="value", type={CodeableConcept.class, StringType.class, SimpleQuantity.class, Base64BinaryType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of the characteristic", formalDefinition="Description of the characteristic.")
        protected Type value;
        private static final long serialVersionUID = -491121170L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeDrugCharacteristicComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicationKnowledgeDrugCharacteristicComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Type getValue() {
            return this.value;
        }

        public CodeableConcept getValueCodeableConcept() throws FHIRException {
            if (this.value == null) {
                return null;
            }
            if (!(this.value instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.value;
        }

        public boolean hasValueCodeableConcept() {
            return this != null && this.value instanceof CodeableConcept;
        }

        public StringType getValueStringType() throws FHIRException {
            if (this.value == null) {
                return null;
            }
            if (!(this.value instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (StringType)this.value;
        }

        public boolean hasValueStringType() {
            return this != null && this.value instanceof StringType;
        }

        public SimpleQuantity getValueSimpleQuantity() throws FHIRException {
            if (this.value == null) {
                return null;
            }
            if (!(this.value instanceof SimpleQuantity)) {
                throw new FHIRException("Type mismatch: the type SimpleQuantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (SimpleQuantity)this.value;
        }

        public boolean hasValueSimpleQuantity() {
            return this != null && this.value instanceof SimpleQuantity;
        }

        public Base64BinaryType getValueBase64BinaryType() throws FHIRException {
            if (this.value == null) {
                return null;
            }
            if (!(this.value instanceof Base64BinaryType)) {
                throw new FHIRException("Type mismatch: the type Base64BinaryType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Base64BinaryType)this.value;
        }

        public boolean hasValueBase64BinaryType() {
            return this != null && this.value instanceof Base64BinaryType;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public MedicationKnowledgeDrugCharacteristicComponent setValue(Type value) {
            if (!(value == null || value instanceof CodeableConcept || value instanceof StringType || value instanceof SimpleQuantity || value instanceof Base64BinaryType)) {
                throw new Error("Not the right type for MedicationKnowledge.drugCharacteristic.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "A code specifying which characteristic of the medicine is being described (for example, colour, shape, imprint).", 0, 1, this.type));
            children.add(new Property("value[x]", "CodeableConcept|string|SimpleQuantity|base64Binary", "Description of the characteristic.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "A code specifying which characteristic of the medicine is being described (for example, colour, shape, imprint).", 0, 1, this.type);
                }
                case -1410166417: {
                    return new Property("value[x]", "CodeableConcept|string|SimpleQuantity|base64Binary", "Description of the characteristic.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "CodeableConcept|string|SimpleQuantity|base64Binary", "Description of the characteristic.", 0, 1, this.value);
                }
                case 924902896: {
                    return new Property("value[x]", "CodeableConcept|string|SimpleQuantity|base64Binary", "Description of the characteristic.", 0, 1, this.value);
                }
                case -1424603934: {
                    return new Property("value[x]", "CodeableConcept|string|SimpleQuantity|base64Binary", "Description of the characteristic.", 0, 1, this.value);
                }
                case -1723159506: {
                    return new Property("value[x]", "CodeableConcept|string|SimpleQuantity|base64Binary", "Description of the characteristic.", 0, 1, this.value);
                }
                case -1535024575: {
                    return new Property("value[x]", "CodeableConcept|string|SimpleQuantity|base64Binary", "Description of the characteristic.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = this.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("value[x]")) {
                this.value = this.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"CodeableConcept", "string", "SimpleQuantity", "base64Binary"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("valueCodeableConcept")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueSimpleQuantity")) {
                this.value = new SimpleQuantity();
                return this.value;
            }
            if (name.equals("valueBase64Binary")) {
                this.value = new Base64BinaryType();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeDrugCharacteristicComponent copy() {
            MedicationKnowledgeDrugCharacteristicComponent dst = new MedicationKnowledgeDrugCharacteristicComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.value = this.value == null ? null : this.value.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeDrugCharacteristicComponent)) {
                return false;
            }
            MedicationKnowledgeDrugCharacteristicComponent o = (MedicationKnowledgeDrugCharacteristicComponent)other_;
            return MedicationKnowledgeDrugCharacteristicComponent.compareDeep(this.type, o.type, true) && MedicationKnowledgeDrugCharacteristicComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeDrugCharacteristicComponent)) {
                return false;
            }
            MedicationKnowledgeDrugCharacteristicComponent o = (MedicationKnowledgeDrugCharacteristicComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.value});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.drugCharacteristic";
        }
    }

    @Block
    public static class MedicationKnowledgePackagingComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="A code that defines the specific type of packaging that the medication can be found in", formalDefinition="A code that defines the specific type of packaging that the medication can be found in (e.g. blister sleeve, tube, bottle).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/medicationKnowledge-package")
        protected CodeableConcept type;
        @Child(name="quantity", type={SimpleQuantity.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The number of product units the package would contain if fully loaded", formalDefinition="The number of product units the package would contain if fully loaded.")
        protected SimpleQuantity quantity;
        private static final long serialVersionUID = -216496823L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgePackagingComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicationKnowledgePackagingComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public SimpleQuantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgePackagingComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new SimpleQuantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public MedicationKnowledgePackagingComponent setQuantity(SimpleQuantity value) {
            this.quantity = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "A code that defines the specific type of packaging that the medication can be found in (e.g. blister sleeve, tube, bottle).", 0, 1, this.type));
            children.add(new Property("quantity", "SimpleQuantity", "The number of product units the package would contain if fully loaded.", 0, 1, this.quantity));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "A code that defines the specific type of packaging that the medication can be found in (e.g. blister sleeve, tube, bottle).", 0, 1, this.type);
                }
                case -1285004149: {
                    return new Property("quantity", "SimpleQuantity", "The number of product units the package would contain if fully loaded.", 0, 1, this.quantity);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.quantity;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case -1285004149: {
                    this.quantity = this.castToSimpleQuantity(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("quantity")) {
                this.quantity = this.castToSimpleQuantity(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1285004149: {
                    return new String[]{"SimpleQuantity"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("quantity")) {
                this.quantity = new SimpleQuantity();
                return this.quantity;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgePackagingComponent copy() {
            MedicationKnowledgePackagingComponent dst = new MedicationKnowledgePackagingComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgePackagingComponent)) {
                return false;
            }
            MedicationKnowledgePackagingComponent o = (MedicationKnowledgePackagingComponent)other_;
            return MedicationKnowledgePackagingComponent.compareDeep(this.type, o.type, true) && MedicationKnowledgePackagingComponent.compareDeep(this.quantity, o.quantity, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgePackagingComponent)) {
                return false;
            }
            MedicationKnowledgePackagingComponent o = (MedicationKnowledgePackagingComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.quantity});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.packaging";
        }
    }

    @Block
    public static class MedicationKnowledgeMedicineClassificationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The type of category for the medication (for example, therapeutic classification, therapeutic sub-classification)", formalDefinition="The type of category for the medication (for example, therapeutic classification, therapeutic sub-classification).")
        protected CodeableConcept type;
        @Child(name="classification", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Specific category assigned to the medication", formalDefinition="Specific category assigned to the medication (e.g. anti-infective, anti-hypertensive, antibiotic, etc).")
        protected List<CodeableConcept> classification;
        private static final long serialVersionUID = 1562996046L;

        public MedicationKnowledgeMedicineClassificationComponent() {
        }

        public MedicationKnowledgeMedicineClassificationComponent(CodeableConcept type) {
            this.type = type;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeMedicineClassificationComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicationKnowledgeMedicineClassificationComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public List<CodeableConcept> getClassification() {
            if (this.classification == null) {
                this.classification = new ArrayList<CodeableConcept>();
            }
            return this.classification;
        }

        public MedicationKnowledgeMedicineClassificationComponent setClassification(List<CodeableConcept> theClassification) {
            this.classification = theClassification;
            return this;
        }

        public boolean hasClassification() {
            if (this.classification == null) {
                return false;
            }
            for (CodeableConcept item : this.classification) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addClassification() {
            CodeableConcept t = new CodeableConcept();
            if (this.classification == null) {
                this.classification = new ArrayList<CodeableConcept>();
            }
            this.classification.add(t);
            return t;
        }

        public MedicationKnowledgeMedicineClassificationComponent addClassification(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.classification == null) {
                this.classification = new ArrayList<CodeableConcept>();
            }
            this.classification.add(t);
            return this;
        }

        public CodeableConcept getClassificationFirstRep() {
            if (this.getClassification().isEmpty()) {
                this.addClassification();
            }
            return this.getClassification().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "The type of category for the medication (for example, therapeutic classification, therapeutic sub-classification).", 0, 1, this.type));
            children.add(new Property(MedicationKnowledge.SP_CLASSIFICATION, "CodeableConcept", "Specific category assigned to the medication (e.g. anti-infective, anti-hypertensive, antibiotic, etc).", 0, Integer.MAX_VALUE, this.classification));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The type of category for the medication (for example, therapeutic classification, therapeutic sub-classification).", 0, 1, this.type);
                }
                case 382350310: {
                    return new Property(MedicationKnowledge.SP_CLASSIFICATION, "CodeableConcept", "Specific category assigned to the medication (e.g. anti-infective, anti-hypertensive, antibiotic, etc).", 0, Integer.MAX_VALUE, this.classification);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 382350310: {
                    return this.classification == null ? new Base[]{} : this.classification.toArray(new Base[this.classification.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case 382350310: {
                    this.getClassification().add(this.castToCodeableConcept(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals(MedicationKnowledge.SP_CLASSIFICATION)) {
                this.getClassification().add(this.castToCodeableConcept(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 382350310: {
                    return this.addClassification();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 382350310: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals(MedicationKnowledge.SP_CLASSIFICATION)) {
                return this.addClassification();
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeMedicineClassificationComponent copy() {
            MedicationKnowledgeMedicineClassificationComponent dst = new MedicationKnowledgeMedicineClassificationComponent();
            this.copyValues(dst);
            CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
            if (this.classification != null) {
                dst.classification = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.classification) {
                    dst.classification.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeMedicineClassificationComponent)) {
                return false;
            }
            MedicationKnowledgeMedicineClassificationComponent o = (MedicationKnowledgeMedicineClassificationComponent)other_;
            return MedicationKnowledgeMedicineClassificationComponent.compareDeep(this.type, o.type, true) && MedicationKnowledgeMedicineClassificationComponent.compareDeep(this.classification, o.classification, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeMedicineClassificationComponent)) {
                return false;
            }
            MedicationKnowledgeMedicineClassificationComponent o = (MedicationKnowledgeMedicineClassificationComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.classification});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.medicineClassification";
        }
    }

    @Block
    public static class MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="characteristic", type={CodeableConcept.class, SimpleQuantity.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Specific characteristic that is relevant to the administration guideline", formalDefinition="Specific characteristic that is relevant to the administration guideline (e.g. height, weight, gender).")
        protected Type characteristic;
        @Child(name="value", type={StringType.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The specific characteristic", formalDefinition="The specific characteristic (e.g. height, weight, gender, etc).")
        protected List<StringType> value;
        private static final long serialVersionUID = -133608297L;

        public MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent() {
        }

        public MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent(Type characteristic) {
            this.characteristic = characteristic;
        }

        public Type getCharacteristic() {
            return this.characteristic;
        }

        public CodeableConcept getCharacteristicCodeableConcept() throws FHIRException {
            if (this.characteristic == null) {
                return null;
            }
            if (!(this.characteristic instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.characteristic.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.characteristic;
        }

        public boolean hasCharacteristicCodeableConcept() {
            return this != null && this.characteristic instanceof CodeableConcept;
        }

        public SimpleQuantity getCharacteristicSimpleQuantity() throws FHIRException {
            if (this.characteristic == null) {
                return null;
            }
            if (!(this.characteristic instanceof SimpleQuantity)) {
                throw new FHIRException("Type mismatch: the type SimpleQuantity was expected, but " + this.characteristic.getClass().getName() + " was encountered");
            }
            return (SimpleQuantity)this.characteristic;
        }

        public boolean hasCharacteristicSimpleQuantity() {
            return this != null && this.characteristic instanceof SimpleQuantity;
        }

        public boolean hasCharacteristic() {
            return this.characteristic != null && !this.characteristic.isEmpty();
        }

        public MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent setCharacteristic(Type value) {
            if (value != null && !(value instanceof CodeableConcept) && !(value instanceof SimpleQuantity)) {
                throw new Error("Not the right type for MedicationKnowledge.administrationGuidelines.patientCharacteristics.characteristic[x]: " + value.fhirType());
            }
            this.characteristic = value;
            return this;
        }

        public List<StringType> getValue() {
            if (this.value == null) {
                this.value = new ArrayList<StringType>();
            }
            return this.value;
        }

        public MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent setValue(List<StringType> theValue) {
            this.value = theValue;
            return this;
        }

        public boolean hasValue() {
            if (this.value == null) {
                return false;
            }
            for (StringType item : this.value) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addValueElement() {
            StringType t = new StringType();
            if (this.value == null) {
                this.value = new ArrayList<StringType>();
            }
            this.value.add(t);
            return t;
        }

        public MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent addValue(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.value == null) {
                this.value = new ArrayList<StringType>();
            }
            this.value.add(t);
            return this;
        }

        public boolean hasValue(String value) {
            if (this.value == null) {
                return false;
            }
            for (StringType v : this.value) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("characteristic[x]", "CodeableConcept|SimpleQuantity", "Specific characteristic that is relevant to the administration guideline (e.g. height, weight, gender).", 0, 1, this.characteristic));
            children.add(new Property("value", "string", "The specific characteristic (e.g. height, weight, gender, etc).", 0, Integer.MAX_VALUE, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -654919419: {
                    return new Property("characteristic[x]", "CodeableConcept|SimpleQuantity", "Specific characteristic that is relevant to the administration guideline (e.g. height, weight, gender).", 0, 1, this.characteristic);
                }
                case 366313883: {
                    return new Property("characteristic[x]", "CodeableConcept|SimpleQuantity", "Specific characteristic that is relevant to the administration guideline (e.g. height, weight, gender).", 0, 1, this.characteristic);
                }
                case -1259840378: {
                    return new Property("characteristic[x]", "CodeableConcept|SimpleQuantity", "Specific characteristic that is relevant to the administration guideline (e.g. height, weight, gender).", 0, 1, this.characteristic);
                }
                case 1947142872: {
                    return new Property("characteristic[x]", "CodeableConcept|SimpleQuantity", "Specific characteristic that is relevant to the administration guideline (e.g. height, weight, gender).", 0, 1, this.characteristic);
                }
                case 111972721: {
                    return new Property("value", "string", "The specific characteristic (e.g. height, weight, gender, etc).", 0, Integer.MAX_VALUE, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 366313883: {
                    Base[] baseArray;
                    if (this.characteristic == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.characteristic;
                    }
                    return baseArray;
                }
                case 111972721: {
                    return this.value == null ? new Base[]{} : this.value.toArray(new Base[this.value.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 366313883: {
                    this.characteristic = this.castToType(value);
                    return value;
                }
                case 111972721: {
                    this.getValue().add(this.castToString(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("characteristic[x]")) {
                this.characteristic = this.castToType(value);
            } else if (name.equals("value")) {
                this.getValue().add(this.castToString(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -654919419: {
                    return this.getCharacteristic();
                }
                case 366313883: {
                    return this.getCharacteristic();
                }
                case 111972721: {
                    return this.addValueElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 366313883: {
                    return new String[]{"CodeableConcept", "SimpleQuantity"};
                }
                case 111972721: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("characteristicCodeableConcept")) {
                this.characteristic = new CodeableConcept();
                return this.characteristic;
            }
            if (name.equals("characteristicSimpleQuantity")) {
                this.characteristic = new SimpleQuantity();
                return this.characteristic;
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a primitive type MedicationKnowledge.value");
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent copy() {
            MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent dst = new MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent();
            this.copyValues(dst);
            Type type = dst.characteristic = this.characteristic == null ? null : this.characteristic.copy();
            if (this.value != null) {
                dst.value = new ArrayList<StringType>();
                for (StringType i : this.value) {
                    dst.value.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent)) {
                return false;
            }
            MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent o = (MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent)other_;
            return MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent.compareDeep(this.characteristic, o.characteristic, true) && MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent)) {
                return false;
            }
            MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent o = (MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent)other_;
            return MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.characteristic, this.value});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.administrationGuidelines.patientCharacteristics";
        }
    }

    @Block
    public static class MedicationKnowledgeAdministrationGuidelinesComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="dosage", type={Dosage.class}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Dosage for the medication for the specific guidelines", formalDefinition="Dosage for the medication for the specific guidelines.")
        protected List<Dosage> dosage;
        @Child(name="indication", type={CodeableConcept.class, ObservationDefinition.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Indication for use that apply to the specific administration guidelines", formalDefinition="Indication for use that apply to the specific administration guidelines.")
        protected Type indication;
        @Child(name="patientCharacteristics", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Characteristics of the patient that are relevant to the administration guidelines", formalDefinition="Characteristics of the patient that are relevant to the administration guidelines (for example, height, weight,gender,  etc).")
        protected List<MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent> patientCharacteristics;
        private static final long serialVersionUID = -685386015L;

        public List<Dosage> getDosage() {
            if (this.dosage == null) {
                this.dosage = new ArrayList<Dosage>();
            }
            return this.dosage;
        }

        public MedicationKnowledgeAdministrationGuidelinesComponent setDosage(List<Dosage> theDosage) {
            this.dosage = theDosage;
            return this;
        }

        public boolean hasDosage() {
            if (this.dosage == null) {
                return false;
            }
            for (Dosage item : this.dosage) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Dosage addDosage() {
            Dosage t = new Dosage();
            if (this.dosage == null) {
                this.dosage = new ArrayList<Dosage>();
            }
            this.dosage.add(t);
            return t;
        }

        public MedicationKnowledgeAdministrationGuidelinesComponent addDosage(Dosage t) {
            if (t == null) {
                return this;
            }
            if (this.dosage == null) {
                this.dosage = new ArrayList<Dosage>();
            }
            this.dosage.add(t);
            return this;
        }

        public Dosage getDosageFirstRep() {
            if (this.getDosage().isEmpty()) {
                this.addDosage();
            }
            return this.getDosage().get(0);
        }

        public Type getIndication() {
            return this.indication;
        }

        public CodeableConcept getIndicationCodeableConcept() throws FHIRException {
            if (this.indication == null) {
                return null;
            }
            if (!(this.indication instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.indication.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.indication;
        }

        public boolean hasIndicationCodeableConcept() {
            return this != null && this.indication instanceof CodeableConcept;
        }

        public Reference getIndicationReference() throws FHIRException {
            if (this.indication == null) {
                return null;
            }
            if (!(this.indication instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.indication.getClass().getName() + " was encountered");
            }
            return (Reference)this.indication;
        }

        public boolean hasIndicationReference() {
            return this != null && this.indication instanceof Reference;
        }

        public boolean hasIndication() {
            return this.indication != null && !this.indication.isEmpty();
        }

        public MedicationKnowledgeAdministrationGuidelinesComponent setIndication(Type value) {
            if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
                throw new Error("Not the right type for MedicationKnowledge.administrationGuidelines.indication[x]: " + value.fhirType());
            }
            this.indication = value;
            return this;
        }

        public List<MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent> getPatientCharacteristics() {
            if (this.patientCharacteristics == null) {
                this.patientCharacteristics = new ArrayList<MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent>();
            }
            return this.patientCharacteristics;
        }

        public MedicationKnowledgeAdministrationGuidelinesComponent setPatientCharacteristics(List<MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent> thePatientCharacteristics) {
            this.patientCharacteristics = thePatientCharacteristics;
            return this;
        }

        public boolean hasPatientCharacteristics() {
            if (this.patientCharacteristics == null) {
                return false;
            }
            for (MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent item : this.patientCharacteristics) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent addPatientCharacteristics() {
            MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent t = new MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent();
            if (this.patientCharacteristics == null) {
                this.patientCharacteristics = new ArrayList<MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent>();
            }
            this.patientCharacteristics.add(t);
            return t;
        }

        public MedicationKnowledgeAdministrationGuidelinesComponent addPatientCharacteristics(MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent t) {
            if (t == null) {
                return this;
            }
            if (this.patientCharacteristics == null) {
                this.patientCharacteristics = new ArrayList<MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent>();
            }
            this.patientCharacteristics.add(t);
            return this;
        }

        public MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent getPatientCharacteristicsFirstRep() {
            if (this.getPatientCharacteristics().isEmpty()) {
                this.addPatientCharacteristics();
            }
            return this.getPatientCharacteristics().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("dosage", "Dosage", "Dosage for the medication for the specific guidelines.", 0, Integer.MAX_VALUE, this.dosage));
            children.add(new Property("indication[x]", "CodeableConcept|Reference(ObservationDefinition)", "Indication for use that apply to the specific administration guidelines.", 0, 1, this.indication));
            children.add(new Property("patientCharacteristics", "", "Characteristics of the patient that are relevant to the administration guidelines (for example, height, weight,gender,  etc).", 0, Integer.MAX_VALUE, this.patientCharacteristics));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1326018889: {
                    return new Property("dosage", "Dosage", "Dosage for the medication for the specific guidelines.", 0, Integer.MAX_VALUE, this.dosage);
                }
                case -501208668: {
                    return new Property("indication[x]", "CodeableConcept|Reference(ObservationDefinition)", "Indication for use that apply to the specific administration guidelines.", 0, 1, this.indication);
                }
                case -597168804: {
                    return new Property("indication[x]", "CodeableConcept|Reference(ObservationDefinition)", "Indication for use that apply to the specific administration guidelines.", 0, 1, this.indication);
                }
                case -1094003035: {
                    return new Property("indication[x]", "CodeableConcept|Reference(ObservationDefinition)", "Indication for use that apply to the specific administration guidelines.", 0, 1, this.indication);
                }
                case 803518799: {
                    return new Property("indication[x]", "CodeableConcept|Reference(ObservationDefinition)", "Indication for use that apply to the specific administration guidelines.", 0, 1, this.indication);
                }
                case -960531341: {
                    return new Property("patientCharacteristics", "", "Characteristics of the patient that are relevant to the administration guidelines (for example, height, weight,gender,  etc).", 0, Integer.MAX_VALUE, this.patientCharacteristics);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1326018889: {
                    return this.dosage == null ? new Base[]{} : this.dosage.toArray(new Base[this.dosage.size()]);
                }
                case -597168804: {
                    Base[] baseArray;
                    if (this.indication == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.indication;
                    }
                    return baseArray;
                }
                case -960531341: {
                    return this.patientCharacteristics == null ? new Base[]{} : this.patientCharacteristics.toArray(new Base[this.patientCharacteristics.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1326018889: {
                    this.getDosage().add(this.castToDosage(value));
                    return value;
                }
                case -597168804: {
                    this.indication = this.castToType(value);
                    return value;
                }
                case -960531341: {
                    this.getPatientCharacteristics().add((MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("dosage")) {
                this.getDosage().add(this.castToDosage(value));
            } else if (name.equals("indication[x]")) {
                this.indication = this.castToType(value);
            } else if (name.equals("patientCharacteristics")) {
                this.getPatientCharacteristics().add((MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1326018889: {
                    return this.addDosage();
                }
                case -501208668: {
                    return this.getIndication();
                }
                case -597168804: {
                    return this.getIndication();
                }
                case -960531341: {
                    return this.addPatientCharacteristics();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1326018889: {
                    return new String[]{"Dosage"};
                }
                case -597168804: {
                    return new String[]{"CodeableConcept", "Reference"};
                }
                case -960531341: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("dosage")) {
                return this.addDosage();
            }
            if (name.equals("indicationCodeableConcept")) {
                this.indication = new CodeableConcept();
                return this.indication;
            }
            if (name.equals("indicationReference")) {
                this.indication = new Reference();
                return this.indication;
            }
            if (name.equals("patientCharacteristics")) {
                return this.addPatientCharacteristics();
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeAdministrationGuidelinesComponent copy() {
            MedicationKnowledgeAdministrationGuidelinesComponent dst = new MedicationKnowledgeAdministrationGuidelinesComponent();
            this.copyValues(dst);
            if (this.dosage != null) {
                dst.dosage = new ArrayList<Dosage>();
                for (Dosage dosage : this.dosage) {
                    dst.dosage.add(dosage.copy());
                }
            }
            Type type = dst.indication = this.indication == null ? null : this.indication.copy();
            if (this.patientCharacteristics != null) {
                dst.patientCharacteristics = new ArrayList<MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent>();
                for (MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent medicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent : this.patientCharacteristics) {
                    dst.patientCharacteristics.add(medicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeAdministrationGuidelinesComponent)) {
                return false;
            }
            MedicationKnowledgeAdministrationGuidelinesComponent o = (MedicationKnowledgeAdministrationGuidelinesComponent)other_;
            return MedicationKnowledgeAdministrationGuidelinesComponent.compareDeep(this.dosage, o.dosage, true) && MedicationKnowledgeAdministrationGuidelinesComponent.compareDeep(this.indication, o.indication, true) && MedicationKnowledgeAdministrationGuidelinesComponent.compareDeep(this.patientCharacteristics, o.patientCharacteristics, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeAdministrationGuidelinesComponent)) {
                return false;
            }
            MedicationKnowledgeAdministrationGuidelinesComponent o = (MedicationKnowledgeAdministrationGuidelinesComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.dosage, this.indication, this.patientCharacteristics});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.administrationGuidelines";
        }
    }

    @Block
    public static class MedicationKnowledgeMonitoringProgramComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of program under which the medication is monitored", formalDefinition="Type of program under which the medication is monitored.")
        protected CodeableConcept type;
        @Child(name="name", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Name of the reviewing program", formalDefinition="Name of the reviewing program.")
        protected StringType name;
        private static final long serialVersionUID = -280346281L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeMonitoringProgramComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicationKnowledgeMonitoringProgramComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeMonitoringProgramComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public MedicationKnowledgeMonitoringProgramComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public MedicationKnowledgeMonitoringProgramComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "Type of program under which the medication is monitored.", 0, 1, this.type));
            children.add(new Property("name", "string", "Name of the reviewing program.", 0, 1, this.name));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Type of program under which the medication is monitored.", 0, 1, this.type);
                }
                case 3373707: {
                    return new Property("name", "string", "Name of the reviewing program.", 0, 1, this.name);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.name;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case 3373707: {
                    this.name = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("name")) {
                this.name = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 3373707: {
                    return this.getNameElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 3373707: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a primitive type MedicationKnowledge.name");
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeMonitoringProgramComponent copy() {
            MedicationKnowledgeMonitoringProgramComponent dst = new MedicationKnowledgeMonitoringProgramComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.name = this.name == null ? null : this.name.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeMonitoringProgramComponent)) {
                return false;
            }
            MedicationKnowledgeMonitoringProgramComponent o = (MedicationKnowledgeMonitoringProgramComponent)other_;
            return MedicationKnowledgeMonitoringProgramComponent.compareDeep(this.type, o.type, true) && MedicationKnowledgeMonitoringProgramComponent.compareDeep(this.name, o.name, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeMonitoringProgramComponent)) {
                return false;
            }
            MedicationKnowledgeMonitoringProgramComponent o = (MedicationKnowledgeMonitoringProgramComponent)other_;
            return MedicationKnowledgeMonitoringProgramComponent.compareValues(this.name, o.name, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.name});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.monitoringProgram";
        }
    }

    @Block
    public static class MedicationKnowledgeCostComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The category of the cost information", formalDefinition="The category of the cost information.  For example, manufacturers' cost, patient cost, claim reimbursement cost, actual acquisition cost.")
        protected StringType type;
        @Child(name="source", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The source or owner for the price information", formalDefinition="The source or owner that assigns the price to the medication.")
        protected StringType source;
        @Child(name="cost", type={Money.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The price of the medication", formalDefinition="The price of the medication.")
        protected Money cost;
        private static final long serialVersionUID = 1750634148L;

        public MedicationKnowledgeCostComponent() {
        }

        public MedicationKnowledgeCostComponent(StringType type, Money cost) {
            this.type = type;
            this.cost = cost;
        }

        public StringType getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeCostComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new StringType();
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicationKnowledgeCostComponent setTypeElement(StringType value) {
            this.type = value;
            return this;
        }

        public String getType() {
            return this.type == null ? null : (String)this.type.getValue();
        }

        public MedicationKnowledgeCostComponent setType(String value) {
            if (this.type == null) {
                this.type = new StringType();
            }
            this.type.setValue(value);
            return this;
        }

        public StringType getSourceElement() {
            if (this.source == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeCostComponent.source");
                }
                if (Configuration.doAutoCreate()) {
                    this.source = new StringType();
                }
            }
            return this.source;
        }

        public boolean hasSourceElement() {
            return this.source != null && !this.source.isEmpty();
        }

        public boolean hasSource() {
            return this.source != null && !this.source.isEmpty();
        }

        public MedicationKnowledgeCostComponent setSourceElement(StringType value) {
            this.source = value;
            return this;
        }

        public String getSource() {
            return this.source == null ? null : (String)this.source.getValue();
        }

        public MedicationKnowledgeCostComponent setSource(String value) {
            if (Utilities.noString((String)value)) {
                this.source = null;
            } else {
                if (this.source == null) {
                    this.source = new StringType();
                }
                this.source.setValue(value);
            }
            return this;
        }

        public Money getCost() {
            if (this.cost == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeCostComponent.cost");
                }
                if (Configuration.doAutoCreate()) {
                    this.cost = new Money();
                }
            }
            return this.cost;
        }

        public boolean hasCost() {
            return this.cost != null && !this.cost.isEmpty();
        }

        public MedicationKnowledgeCostComponent setCost(Money value) {
            this.cost = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "string", "The category of the cost information.  For example, manufacturers' cost, patient cost, claim reimbursement cost, actual acquisition cost.", 0, 1, this.type));
            children.add(new Property("source", "string", "The source or owner that assigns the price to the medication.", 0, 1, this.source));
            children.add(new Property("cost", "Money", "The price of the medication.", 0, 1, this.cost));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "string", "The category of the cost information.  For example, manufacturers' cost, patient cost, claim reimbursement cost, actual acquisition cost.", 0, 1, this.type);
                }
                case -896505829: {
                    return new Property("source", "string", "The source or owner that assigns the price to the medication.", 0, 1, this.source);
                }
                case 3059661: {
                    return new Property("cost", "Money", "The price of the medication.", 0, 1, this.cost);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -896505829: {
                    Base[] baseArray;
                    if (this.source == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.source;
                    }
                    return baseArray;
                }
                case 3059661: {
                    Base[] baseArray;
                    if (this.cost == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.cost;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToString(value);
                    return value;
                }
                case -896505829: {
                    this.source = this.castToString(value);
                    return value;
                }
                case 3059661: {
                    this.cost = this.castToMoney(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToString(value);
            } else if (name.equals("source")) {
                this.source = this.castToString(value);
            } else if (name.equals("cost")) {
                this.cost = this.castToMoney(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getTypeElement();
                }
                case -896505829: {
                    return this.getSourceElement();
                }
                case 3059661: {
                    return this.getCost();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"string"};
                }
                case -896505829: {
                    return new String[]{"string"};
                }
                case 3059661: {
                    return new String[]{"Money"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type MedicationKnowledge.type");
            }
            if (name.equals("source")) {
                throw new FHIRException("Cannot call addChild on a primitive type MedicationKnowledge.source");
            }
            if (name.equals("cost")) {
                this.cost = new Money();
                return this.cost;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeCostComponent copy() {
            MedicationKnowledgeCostComponent dst = new MedicationKnowledgeCostComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.source = this.source == null ? null : this.source.copy();
            dst.cost = this.cost == null ? null : this.cost.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeCostComponent)) {
                return false;
            }
            MedicationKnowledgeCostComponent o = (MedicationKnowledgeCostComponent)other_;
            return MedicationKnowledgeCostComponent.compareDeep(this.type, o.type, true) && MedicationKnowledgeCostComponent.compareDeep(this.source, o.source, true) && MedicationKnowledgeCostComponent.compareDeep(this.cost, o.cost, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeCostComponent)) {
                return false;
            }
            MedicationKnowledgeCostComponent o = (MedicationKnowledgeCostComponent)other_;
            return MedicationKnowledgeCostComponent.compareValues(this.type, o.type, true) && MedicationKnowledgeCostComponent.compareValues(this.source, o.source, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.source, this.cost});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.cost";
        }
    }

    @Block
    public static class MedicationKnowledgeIngredientComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="item", type={CodeableConcept.class, Substance.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Medication(s) or substance(s) contained in the medication", formalDefinition="The actual ingredient - either a substance (simple ingredient) or another medication.")
        protected Type item;
        @Child(name="isActive", type={BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Active ingredient indicator", formalDefinition="Indication of whether this\u00a0ingredient affects\u00a0the therapeutic action of the drug.")
        protected BooleanType isActive;
        @Child(name="strength", type={Ratio.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Quantity of ingredient present", formalDefinition="Specifies how many (or how much) of the items there are in this Medication.  For example, 250 mg per tablet.  This is expressed as a ratio where the numerator is 250mg and the denominator is 1 tablet.")
        protected Ratio strength;
        private static final long serialVersionUID = 1365103497L;

        public MedicationKnowledgeIngredientComponent() {
        }

        public MedicationKnowledgeIngredientComponent(Type item) {
            this.item = item;
        }

        public Type getItem() {
            return this.item;
        }

        public CodeableConcept getItemCodeableConcept() throws FHIRException {
            if (this.item == null) {
                return null;
            }
            if (!(this.item instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.item.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.item;
        }

        public boolean hasItemCodeableConcept() {
            return this != null && this.item instanceof CodeableConcept;
        }

        public Reference getItemReference() throws FHIRException {
            if (this.item == null) {
                return null;
            }
            if (!(this.item instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.item.getClass().getName() + " was encountered");
            }
            return (Reference)this.item;
        }

        public boolean hasItemReference() {
            return this != null && this.item instanceof Reference;
        }

        public boolean hasItem() {
            return this.item != null && !this.item.isEmpty();
        }

        public MedicationKnowledgeIngredientComponent setItem(Type value) {
            if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
                throw new Error("Not the right type for MedicationKnowledge.ingredient.item[x]: " + value.fhirType());
            }
            this.item = value;
            return this;
        }

        public BooleanType getIsActiveElement() {
            if (this.isActive == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeIngredientComponent.isActive");
                }
                if (Configuration.doAutoCreate()) {
                    this.isActive = new BooleanType();
                }
            }
            return this.isActive;
        }

        public boolean hasIsActiveElement() {
            return this.isActive != null && !this.isActive.isEmpty();
        }

        public boolean hasIsActive() {
            return this.isActive != null && !this.isActive.isEmpty();
        }

        public MedicationKnowledgeIngredientComponent setIsActiveElement(BooleanType value) {
            this.isActive = value;
            return this;
        }

        public boolean getIsActive() {
            return this.isActive == null || this.isActive.isEmpty() ? false : (Boolean)this.isActive.getValue();
        }

        public MedicationKnowledgeIngredientComponent setIsActive(boolean value) {
            if (this.isActive == null) {
                this.isActive = new BooleanType();
            }
            this.isActive.setValue((Object)value);
            return this;
        }

        public Ratio getStrength() {
            if (this.strength == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeIngredientComponent.strength");
                }
                if (Configuration.doAutoCreate()) {
                    this.strength = new Ratio();
                }
            }
            return this.strength;
        }

        public boolean hasStrength() {
            return this.strength != null && !this.strength.isEmpty();
        }

        public MedicationKnowledgeIngredientComponent setStrength(Ratio value) {
            this.strength = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("item[x]", "CodeableConcept|Reference(Substance)", "The actual ingredient - either a substance (simple ingredient) or another medication.", 0, 1, this.item));
            children.add(new Property("isActive", "boolean", "Indication of whether this\u00a0ingredient affects\u00a0the therapeutic action of the drug.", 0, 1, this.isActive));
            children.add(new Property("strength", "Ratio", "Specifies how many (or how much) of the items there are in this Medication.  For example, 250 mg per tablet.  This is expressed as a ratio where the numerator is 250mg and the denominator is 1 tablet.", 0, 1, this.strength));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 2116201613: {
                    return new Property("item[x]", "CodeableConcept|Reference(Substance)", "The actual ingredient - either a substance (simple ingredient) or another medication.", 0, 1, this.item);
                }
                case 3242771: {
                    return new Property("item[x]", "CodeableConcept|Reference(Substance)", "The actual ingredient - either a substance (simple ingredient) or another medication.", 0, 1, this.item);
                }
                case 106644494: {
                    return new Property("item[x]", "CodeableConcept|Reference(Substance)", "The actual ingredient - either a substance (simple ingredient) or another medication.", 0, 1, this.item);
                }
                case 1376364920: {
                    return new Property("item[x]", "CodeableConcept|Reference(Substance)", "The actual ingredient - either a substance (simple ingredient) or another medication.", 0, 1, this.item);
                }
                case -748916528: {
                    return new Property("isActive", "boolean", "Indication of whether this\u00a0ingredient affects\u00a0the therapeutic action of the drug.", 0, 1, this.isActive);
                }
                case 1791316033: {
                    return new Property("strength", "Ratio", "Specifies how many (or how much) of the items there are in this Medication.  For example, 250 mg per tablet.  This is expressed as a ratio where the numerator is 250mg and the denominator is 1 tablet.", 0, 1, this.strength);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    Base[] baseArray;
                    if (this.item == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.item;
                    }
                    return baseArray;
                }
                case -748916528: {
                    Base[] baseArray;
                    if (this.isActive == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.isActive;
                    }
                    return baseArray;
                }
                case 1791316033: {
                    Base[] baseArray;
                    if (this.strength == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.strength;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    this.item = this.castToType(value);
                    return value;
                }
                case -748916528: {
                    this.isActive = this.castToBoolean(value);
                    return value;
                }
                case 1791316033: {
                    this.strength = this.castToRatio(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("item[x]")) {
                this.item = this.castToType(value);
            } else if (name.equals("isActive")) {
                this.isActive = this.castToBoolean(value);
            } else if (name.equals("strength")) {
                this.strength = this.castToRatio(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 2116201613: {
                    return this.getItem();
                }
                case 3242771: {
                    return this.getItem();
                }
                case -748916528: {
                    return this.getIsActiveElement();
                }
                case 1791316033: {
                    return this.getStrength();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    return new String[]{"CodeableConcept", "Reference"};
                }
                case -748916528: {
                    return new String[]{"boolean"};
                }
                case 1791316033: {
                    return new String[]{"Ratio"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("itemCodeableConcept")) {
                this.item = new CodeableConcept();
                return this.item;
            }
            if (name.equals("itemReference")) {
                this.item = new Reference();
                return this.item;
            }
            if (name.equals("isActive")) {
                throw new FHIRException("Cannot call addChild on a primitive type MedicationKnowledge.isActive");
            }
            if (name.equals("strength")) {
                this.strength = new Ratio();
                return this.strength;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeIngredientComponent copy() {
            MedicationKnowledgeIngredientComponent dst = new MedicationKnowledgeIngredientComponent();
            this.copyValues(dst);
            dst.item = this.item == null ? null : this.item.copy();
            dst.isActive = this.isActive == null ? null : this.isActive.copy();
            dst.strength = this.strength == null ? null : this.strength.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeIngredientComponent)) {
                return false;
            }
            MedicationKnowledgeIngredientComponent o = (MedicationKnowledgeIngredientComponent)other_;
            return MedicationKnowledgeIngredientComponent.compareDeep(this.item, o.item, true) && MedicationKnowledgeIngredientComponent.compareDeep(this.isActive, o.isActive, true) && MedicationKnowledgeIngredientComponent.compareDeep(this.strength, o.strength, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeIngredientComponent)) {
                return false;
            }
            MedicationKnowledgeIngredientComponent o = (MedicationKnowledgeIngredientComponent)other_;
            return MedicationKnowledgeIngredientComponent.compareValues(this.isActive, o.isActive, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.item, this.isActive, this.strength});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.ingredient";
        }
    }

    @Block
    public static class MedicationKnowledgeMonographComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The category of medication document", formalDefinition="The category of documentation about the medication. (e.g. professional monograph, patient educaton monograph).")
        protected CodeableConcept type;
        @Child(name="document", type={DocumentReference.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Associated documentation about the medication", formalDefinition="Associated documentation about the medication.")
        protected Reference document;
        protected DocumentReference documentTarget;
        private static final long serialVersionUID = 2046517217L;

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeMonographComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicationKnowledgeMonographComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Reference getDocument() {
            if (this.document == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeMonographComponent.document");
                }
                if (Configuration.doAutoCreate()) {
                    this.document = new Reference();
                }
            }
            return this.document;
        }

        public boolean hasDocument() {
            return this.document != null && !this.document.isEmpty();
        }

        public MedicationKnowledgeMonographComponent setDocument(Reference value) {
            this.document = value;
            return this;
        }

        public DocumentReference getDocumentTarget() {
            if (this.documentTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationKnowledgeMonographComponent.document");
                }
                if (Configuration.doAutoCreate()) {
                    this.documentTarget = new DocumentReference();
                }
            }
            return this.documentTarget;
        }

        public MedicationKnowledgeMonographComponent setDocumentTarget(DocumentReference value) {
            this.documentTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "The category of documentation about the medication. (e.g. professional monograph, patient educaton monograph).", 0, 1, this.type));
            children.add(new Property("document", "Reference(DocumentReference)", "Associated documentation about the medication.", 0, 1, this.document));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The category of documentation about the medication. (e.g. professional monograph, patient educaton monograph).", 0, 1, this.type);
                }
                case 861720859: {
                    return new Property("document", "Reference(DocumentReference)", "Associated documentation about the medication.", 0, 1, this.document);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 861720859: {
                    Base[] baseArray;
                    if (this.document == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.document;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case 861720859: {
                    this.document = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("document")) {
                this.document = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 861720859: {
                    return this.getDocument();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 861720859: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("document")) {
                this.document = new Reference();
                return this.document;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationKnowledgeMonographComponent copy() {
            MedicationKnowledgeMonographComponent dst = new MedicationKnowledgeMonographComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.document = this.document == null ? null : this.document.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeMonographComponent)) {
                return false;
            }
            MedicationKnowledgeMonographComponent o = (MedicationKnowledgeMonographComponent)other_;
            return MedicationKnowledgeMonographComponent.compareDeep(this.type, o.type, true) && MedicationKnowledgeMonographComponent.compareDeep(this.document, o.document, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationKnowledgeMonographComponent)) {
                return false;
            }
            MedicationKnowledgeMonographComponent o = (MedicationKnowledgeMonographComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.document});
        }

        @Override
        public String fhirType() {
            return "MedicationKnowledge.monograph";
        }
    }

    public static class MedicationKnowledgeStatusEnumFactory
    implements EnumFactory<MedicationKnowledgeStatus> {
        @Override
        public MedicationKnowledgeStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return MedicationKnowledgeStatus.ACTIVE;
            }
            if ("inactive".equals(codeString)) {
                return MedicationKnowledgeStatus.INACTIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return MedicationKnowledgeStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown MedicationKnowledgeStatus code '" + codeString + "'");
        }

        public Enumeration<MedicationKnowledgeStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<MedicationKnowledgeStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return new Enumeration<MedicationKnowledgeStatus>(this, MedicationKnowledgeStatus.ACTIVE);
            }
            if ("inactive".equals(codeString)) {
                return new Enumeration<MedicationKnowledgeStatus>(this, MedicationKnowledgeStatus.INACTIVE);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<MedicationKnowledgeStatus>(this, MedicationKnowledgeStatus.ENTEREDINERROR);
            }
            throw new FHIRException("Unknown MedicationKnowledgeStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(MedicationKnowledgeStatus code) {
            if (code == MedicationKnowledgeStatus.ACTIVE) {
                return "active";
            }
            if (code == MedicationKnowledgeStatus.INACTIVE) {
                return "inactive";
            }
            if (code == MedicationKnowledgeStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(MedicationKnowledgeStatus code) {
            return code.getSystem();
        }
    }

    public static enum MedicationKnowledgeStatus {
        ACTIVE,
        INACTIVE,
        ENTEREDINERROR,
        NULL;


        public static MedicationKnowledgeStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("inactive".equals(codeString)) {
                return INACTIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown MedicationKnowledgeStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case INACTIVE: {
                    return "inactive";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/medicationKnowledge-status";
                }
                case INACTIVE: {
                    return "http://hl7.org/fhir/medicationKnowledge-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/medicationKnowledge-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "The medication is available for use";
                }
                case INACTIVE: {
                    return "The medication is not available for use";
                }
                case ENTEREDINERROR: {
                    return "The medication was entered in error";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case INACTIVE: {
                    return "Inactive";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
            }
            return "?";
        }
    }
}

