/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.UrlType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Endpoint", profile="http://hl7.org/fhir/Profile/Endpoint")
public class Endpoint
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Identifies this endpoint across multiple systems", formalDefinition="Identifier for the organization that is used to identify the endpoint across multiple disparate systems.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | suspended | error | off | entered-in-error | test", formalDefinition="active | suspended | error | off | test.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/endpoint-status")
    protected Enumeration<EndpointStatus> status;
    @Child(name="connectionType", type={Coding.class}, order=2, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Protocol/Profile/Standard to be used with this endpoint connection", formalDefinition="A coded value that represents the technical details of the usage of this endpoint, such as what WSDLs should be used in what way. (e.g. XDS.b/DICOM/cds-hook).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/endpoint-connection-type")
    protected Coding connectionType;
    @Child(name="name", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="A name that this endpoint can be identified by", formalDefinition="A friendly name that this endpoint can be referred to with.")
    protected StringType name;
    @Child(name="managingOrganization", type={Organization.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Organization that manages this endpoint (might not be the organization that exposes the endpoint)", formalDefinition="The organization that manages this endpoint (even if technically another organization is hosting this in the cloud, it is the organization associated with the data).")
    protected Reference managingOrganization;
    protected Organization managingOrganizationTarget;
    @Child(name="contact", type={ContactPoint.class}, order=5, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Contact details for source (e.g. troubleshooting)", formalDefinition="Contact details for a human to contact about the subscription. The primary use of this for system administrator troubleshooting.")
    protected List<ContactPoint> contact;
    @Child(name="period", type={Period.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Interval the endpoint is expected to be operational", formalDefinition="The interval during which the endpoint is expected to be operational.")
    protected Period period;
    @Child(name="payloadType", type={CodeableConcept.class}, order=7, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The type of content that may be used at this endpoint (e.g. XDS Discharge summaries)", formalDefinition="The payload type describes the acceptable content that can be communicated on the endpoint.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/endpoint-payload-type")
    protected List<CodeableConcept> payloadType;
    @Child(name="payloadMimeType", type={CodeType.class}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Mimetype to send. If not specified, the content could be anything (including no payload, if the connectionType defined this)", formalDefinition="The mime type to send the payload in - e.g. application/fhir+xml, application/fhir+json. If the mime type is not specified, then the sender could send any content (including no content depending on the connectionType).")
    protected List<CodeType> payloadMimeType;
    @Child(name="address", type={UrlType.class}, order=9, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The technical base address for connecting to this endpoint", formalDefinition="The uri that describes the actual end-point to connect to.")
    protected UrlType address;
    @Child(name="header", type={StringType.class}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Usage depends on the channel type", formalDefinition="Additional headers / information to send as part of the notification.")
    protected List<StringType> header;
    private static final long serialVersionUID = 755181080L;
    @SearchParamDefinition(name="payload-type", path="Endpoint.payloadType", description="The type of content that may be used at this endpoint (e.g. XDS Discharge summaries)", type="token")
    public static final String SP_PAYLOAD_TYPE = "payload-type";
    public static final TokenClientParam PAYLOAD_TYPE = new TokenClientParam("payload-type");
    @SearchParamDefinition(name="identifier", path="Endpoint.identifier", description="Identifies this endpoint across multiple systems", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="organization", path="Endpoint.managingOrganization", description="The organization that is managing the endpoint", type="reference", target={Organization.class})
    public static final String SP_ORGANIZATION = "organization";
    public static final ReferenceClientParam ORGANIZATION = new ReferenceClientParam("organization");
    public static final Include INCLUDE_ORGANIZATION = new Include("Endpoint:organization").toLocked();
    @SearchParamDefinition(name="connection-type", path="Endpoint.connectionType", description="Protocol/Profile/Standard to be used with this endpoint connection", type="token")
    public static final String SP_CONNECTION_TYPE = "connection-type";
    public static final TokenClientParam CONNECTION_TYPE = new TokenClientParam("connection-type");
    @SearchParamDefinition(name="name", path="Endpoint.name", description="A name that this endpoint can be identified by", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="status", path="Endpoint.status", description="The current status of the Endpoint (usually expected to be active)", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public Endpoint() {
    }

    public Endpoint(Enumeration<EndpointStatus> status, Coding connectionType, UrlType address) {
        this.status = status;
        this.connectionType = connectionType;
        this.address = address;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Endpoint setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Endpoint addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<EndpointStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Endpoint.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<EndpointStatus>(new EndpointStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Endpoint setStatusElement(Enumeration<EndpointStatus> value) {
        this.status = value;
        return this;
    }

    public EndpointStatus getStatus() {
        return this.status == null ? null : (EndpointStatus)((Object)this.status.getValue());
    }

    public Endpoint setStatus(EndpointStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<EndpointStatus>(new EndpointStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public Coding getConnectionType() {
        if (this.connectionType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Endpoint.connectionType");
            }
            if (Configuration.doAutoCreate()) {
                this.connectionType = new Coding();
            }
        }
        return this.connectionType;
    }

    public boolean hasConnectionType() {
        return this.connectionType != null && !this.connectionType.isEmpty();
    }

    public Endpoint setConnectionType(Coding value) {
        this.connectionType = value;
        return this;
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Endpoint.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public Endpoint setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public Endpoint setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    public Reference getManagingOrganization() {
        if (this.managingOrganization == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Endpoint.managingOrganization");
            }
            if (Configuration.doAutoCreate()) {
                this.managingOrganization = new Reference();
            }
        }
        return this.managingOrganization;
    }

    public boolean hasManagingOrganization() {
        return this.managingOrganization != null && !this.managingOrganization.isEmpty();
    }

    public Endpoint setManagingOrganization(Reference value) {
        this.managingOrganization = value;
        return this;
    }

    public Organization getManagingOrganizationTarget() {
        if (this.managingOrganizationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Endpoint.managingOrganization");
            }
            if (Configuration.doAutoCreate()) {
                this.managingOrganizationTarget = new Organization();
            }
        }
        return this.managingOrganizationTarget;
    }

    public Endpoint setManagingOrganizationTarget(Organization value) {
        this.managingOrganizationTarget = value;
        return this;
    }

    public List<ContactPoint> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactPoint>();
        }
        return this.contact;
    }

    public Endpoint setContact(List<ContactPoint> theContact) {
        this.contact = theContact;
        return this;
    }

    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactPoint item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactPoint addContact() {
        ContactPoint t = new ContactPoint();
        if (this.contact == null) {
            this.contact = new ArrayList<ContactPoint>();
        }
        this.contact.add(t);
        return t;
    }

    public Endpoint addContact(ContactPoint t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ContactPoint>();
        }
        this.contact.add(t);
        return this;
    }

    public ContactPoint getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Endpoint.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public Endpoint setPeriod(Period value) {
        this.period = value;
        return this;
    }

    public List<CodeableConcept> getPayloadType() {
        if (this.payloadType == null) {
            this.payloadType = new ArrayList<CodeableConcept>();
        }
        return this.payloadType;
    }

    public Endpoint setPayloadType(List<CodeableConcept> thePayloadType) {
        this.payloadType = thePayloadType;
        return this;
    }

    public boolean hasPayloadType() {
        if (this.payloadType == null) {
            return false;
        }
        for (CodeableConcept item : this.payloadType) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addPayloadType() {
        CodeableConcept t = new CodeableConcept();
        if (this.payloadType == null) {
            this.payloadType = new ArrayList<CodeableConcept>();
        }
        this.payloadType.add(t);
        return t;
    }

    public Endpoint addPayloadType(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.payloadType == null) {
            this.payloadType = new ArrayList<CodeableConcept>();
        }
        this.payloadType.add(t);
        return this;
    }

    public CodeableConcept getPayloadTypeFirstRep() {
        if (this.getPayloadType().isEmpty()) {
            this.addPayloadType();
        }
        return this.getPayloadType().get(0);
    }

    public List<CodeType> getPayloadMimeType() {
        if (this.payloadMimeType == null) {
            this.payloadMimeType = new ArrayList<CodeType>();
        }
        return this.payloadMimeType;
    }

    public Endpoint setPayloadMimeType(List<CodeType> thePayloadMimeType) {
        this.payloadMimeType = thePayloadMimeType;
        return this;
    }

    public boolean hasPayloadMimeType() {
        if (this.payloadMimeType == null) {
            return false;
        }
        for (CodeType item : this.payloadMimeType) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeType addPayloadMimeTypeElement() {
        CodeType t = new CodeType();
        if (this.payloadMimeType == null) {
            this.payloadMimeType = new ArrayList<CodeType>();
        }
        this.payloadMimeType.add(t);
        return t;
    }

    public Endpoint addPayloadMimeType(String value) {
        CodeType t = new CodeType();
        t.setValue(value);
        if (this.payloadMimeType == null) {
            this.payloadMimeType = new ArrayList<CodeType>();
        }
        this.payloadMimeType.add(t);
        return this;
    }

    public boolean hasPayloadMimeType(String value) {
        if (this.payloadMimeType == null) {
            return false;
        }
        for (CodeType v : this.payloadMimeType) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public UrlType getAddressElement() {
        if (this.address == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Endpoint.address");
            }
            if (Configuration.doAutoCreate()) {
                this.address = new UrlType();
            }
        }
        return this.address;
    }

    public boolean hasAddressElement() {
        return this.address != null && !this.address.isEmpty();
    }

    public boolean hasAddress() {
        return this.address != null && !this.address.isEmpty();
    }

    public Endpoint setAddressElement(UrlType value) {
        this.address = value;
        return this;
    }

    public String getAddress() {
        return this.address == null ? null : (String)this.address.getValue();
    }

    public Endpoint setAddress(String value) {
        if (this.address == null) {
            this.address = new UrlType();
        }
        this.address.setValue(value);
        return this;
    }

    public List<StringType> getHeader() {
        if (this.header == null) {
            this.header = new ArrayList<StringType>();
        }
        return this.header;
    }

    public Endpoint setHeader(List<StringType> theHeader) {
        this.header = theHeader;
        return this;
    }

    public boolean hasHeader() {
        if (this.header == null) {
            return false;
        }
        for (StringType item : this.header) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addHeaderElement() {
        StringType t = new StringType();
        if (this.header == null) {
            this.header = new ArrayList<StringType>();
        }
        this.header.add(t);
        return t;
    }

    public Endpoint addHeader(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.header == null) {
            this.header = new ArrayList<StringType>();
        }
        this.header.add(t);
        return this;
    }

    public boolean hasHeader(String value) {
        if (this.header == null) {
            return false;
        }
        for (StringType v : this.header) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Identifier for the organization that is used to identify the endpoint across multiple disparate systems.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "code", "active | suspended | error | off | test.", 0, 1, this.status));
        children.add(new Property("connectionType", "Coding", "A coded value that represents the technical details of the usage of this endpoint, such as what WSDLs should be used in what way. (e.g. XDS.b/DICOM/cds-hook).", 0, 1, this.connectionType));
        children.add(new Property(SP_NAME, "string", "A friendly name that this endpoint can be referred to with.", 0, 1, this.name));
        children.add(new Property("managingOrganization", "Reference(Organization)", "The organization that manages this endpoint (even if technically another organization is hosting this in the cloud, it is the organization associated with the data).", 0, 1, this.managingOrganization));
        children.add(new Property("contact", "ContactPoint", "Contact details for a human to contact about the subscription. The primary use of this for system administrator troubleshooting.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property("period", "Period", "The interval during which the endpoint is expected to be operational.", 0, 1, this.period));
        children.add(new Property("payloadType", "CodeableConcept", "The payload type describes the acceptable content that can be communicated on the endpoint.", 0, Integer.MAX_VALUE, this.payloadType));
        children.add(new Property("payloadMimeType", "code", "The mime type to send the payload in - e.g. application/fhir+xml, application/fhir+json. If the mime type is not specified, then the sender could send any content (including no content depending on the connectionType).", 0, Integer.MAX_VALUE, this.payloadMimeType));
        children.add(new Property("address", "url", "The uri that describes the actual end-point to connect to.", 0, 1, this.address));
        children.add(new Property("header", "string", "Additional headers / information to send as part of the notification.", 0, Integer.MAX_VALUE, this.header));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Identifier for the organization that is used to identify the endpoint across multiple disparate systems.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "active | suspended | error | off | test.", 0, 1, this.status);
            }
            case 1270211384: {
                return new Property("connectionType", "Coding", "A coded value that represents the technical details of the usage of this endpoint, such as what WSDLs should be used in what way. (e.g. XDS.b/DICOM/cds-hook).", 0, 1, this.connectionType);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A friendly name that this endpoint can be referred to with.", 0, 1, this.name);
            }
            case -2058947787: {
                return new Property("managingOrganization", "Reference(Organization)", "The organization that manages this endpoint (even if technically another organization is hosting this in the cloud, it is the organization associated with the data).", 0, 1, this.managingOrganization);
            }
            case 951526432: {
                return new Property("contact", "ContactPoint", "Contact details for a human to contact about the subscription. The primary use of this for system administrator troubleshooting.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -991726143: {
                return new Property("period", "Period", "The interval during which the endpoint is expected to be operational.", 0, 1, this.period);
            }
            case 909929960: {
                return new Property("payloadType", "CodeableConcept", "The payload type describes the acceptable content that can be communicated on the endpoint.", 0, Integer.MAX_VALUE, this.payloadType);
            }
            case -1702836932: {
                return new Property("payloadMimeType", "code", "The mime type to send the payload in - e.g. application/fhir+xml, application/fhir+json. If the mime type is not specified, then the sender could send any content (including no content depending on the connectionType).", 0, Integer.MAX_VALUE, this.payloadMimeType);
            }
            case -1147692044: {
                return new Property("address", "url", "The uri that describes the actual end-point to connect to.", 0, 1, this.address);
            }
            case -1221270899: {
                return new Property("header", "string", "Additional headers / information to send as part of the notification.", 0, Integer.MAX_VALUE, this.header);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 1270211384: {
                Base[] baseArray;
                if (this.connectionType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.connectionType;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case -2058947787: {
                Base[] baseArray;
                if (this.managingOrganization == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.managingOrganization;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.period;
                }
                return baseArray;
            }
            case 909929960: {
                return this.payloadType == null ? new Base[]{} : this.payloadType.toArray(new Base[this.payloadType.size()]);
            }
            case -1702836932: {
                return this.payloadMimeType == null ? new Base[]{} : this.payloadMimeType.toArray(new Base[this.payloadMimeType.size()]);
            }
            case -1147692044: {
                Base[] baseArray;
                if (this.address == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.address;
                }
                return baseArray;
            }
            case -1221270899: {
                return this.header == null ? new Base[]{} : this.header.toArray(new Base[this.header.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new EndpointStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case 1270211384: {
                this.connectionType = this.castToCoding(value);
                return value;
            }
            case 3373707: {
                this.name = this.castToString(value);
                return value;
            }
            case -2058947787: {
                this.managingOrganization = this.castToReference(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(this.castToContactPoint(value));
                return value;
            }
            case -991726143: {
                this.period = this.castToPeriod(value);
                return value;
            }
            case 909929960: {
                this.getPayloadType().add(this.castToCodeableConcept(value));
                return value;
            }
            case -1702836932: {
                this.getPayloadMimeType().add(this.castToCode(value));
                return value;
            }
            case -1147692044: {
                this.address = this.castToUrl(value);
                return value;
            }
            case -1221270899: {
                this.getHeader().add(this.castToString(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new EndpointStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals("connectionType")) {
            this.connectionType = this.castToCoding(value);
        } else if (name.equals(SP_NAME)) {
            this.name = this.castToString(value);
        } else if (name.equals("managingOrganization")) {
            this.managingOrganization = this.castToReference(value);
        } else if (name.equals("contact")) {
            this.getContact().add(this.castToContactPoint(value));
        } else if (name.equals("period")) {
            this.period = this.castToPeriod(value);
        } else if (name.equals("payloadType")) {
            this.getPayloadType().add(this.castToCodeableConcept(value));
        } else if (name.equals("payloadMimeType")) {
            this.getPayloadMimeType().add(this.castToCode(value));
        } else if (name.equals("address")) {
            this.address = this.castToUrl(value);
        } else if (name.equals("header")) {
            this.getHeader().add(this.castToString(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 1270211384: {
                return this.getConnectionType();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case -2058947787: {
                return this.getManagingOrganization();
            }
            case 951526432: {
                return this.addContact();
            }
            case -991726143: {
                return this.getPeriod();
            }
            case 909929960: {
                return this.addPayloadType();
            }
            case -1702836932: {
                return this.addPayloadMimeTypeElement();
            }
            case -1147692044: {
                return this.getAddressElement();
            }
            case -1221270899: {
                return this.addHeaderElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 1270211384: {
                return new String[]{"Coding"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case -2058947787: {
                return new String[]{"Reference"};
            }
            case 951526432: {
                return new String[]{"ContactPoint"};
            }
            case -991726143: {
                return new String[]{"Period"};
            }
            case 909929960: {
                return new String[]{"CodeableConcept"};
            }
            case -1702836932: {
                return new String[]{"code"};
            }
            case -1147692044: {
                return new String[]{"url"};
            }
            case -1221270899: {
                return new String[]{"string"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Endpoint.status");
        }
        if (name.equals("connectionType")) {
            this.connectionType = new Coding();
            return this.connectionType;
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type Endpoint.name");
        }
        if (name.equals("managingOrganization")) {
            this.managingOrganization = new Reference();
            return this.managingOrganization;
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        if (name.equals("payloadType")) {
            return this.addPayloadType();
        }
        if (name.equals("payloadMimeType")) {
            throw new FHIRException("Cannot call addChild on a primitive type Endpoint.payloadMimeType");
        }
        if (name.equals("address")) {
            throw new FHIRException("Cannot call addChild on a primitive type Endpoint.address");
        }
        if (name.equals("header")) {
            throw new FHIRException("Cannot call addChild on a primitive type Endpoint.header");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Endpoint";
    }

    @Override
    public Endpoint copy() {
        Endpoint dst = new Endpoint();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.connectionType = this.connectionType == null ? null : this.connectionType.copy();
        dst.name = this.name == null ? null : this.name.copy();
        Reference reference = dst.managingOrganization = this.managingOrganization == null ? null : this.managingOrganization.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ContactPoint>();
            for (ContactPoint contactPoint : this.contact) {
                dst.contact.add(contactPoint.copy());
            }
        }
        Period period = dst.period = this.period == null ? null : this.period.copy();
        if (this.payloadType != null) {
            dst.payloadType = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.payloadType) {
                dst.payloadType.add(codeableConcept.copy());
            }
        }
        if (this.payloadMimeType != null) {
            dst.payloadMimeType = new ArrayList<CodeType>();
            for (CodeType codeType : this.payloadMimeType) {
                dst.payloadMimeType.add(codeType.copy());
            }
        }
        UrlType urlType = dst.address = this.address == null ? null : this.address.copy();
        if (this.header != null) {
            dst.header = new ArrayList<StringType>();
            for (StringType stringType : this.header) {
                dst.header.add(stringType.copy());
            }
        }
        return dst;
    }

    protected Endpoint typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Endpoint)) {
            return false;
        }
        Endpoint o = (Endpoint)other_;
        return Endpoint.compareDeep(this.identifier, o.identifier, true) && Endpoint.compareDeep(this.status, o.status, true) && Endpoint.compareDeep(this.connectionType, o.connectionType, true) && Endpoint.compareDeep(this.name, o.name, true) && Endpoint.compareDeep(this.managingOrganization, o.managingOrganization, true) && Endpoint.compareDeep(this.contact, o.contact, true) && Endpoint.compareDeep(this.period, o.period, true) && Endpoint.compareDeep(this.payloadType, o.payloadType, true) && Endpoint.compareDeep(this.payloadMimeType, o.payloadMimeType, true) && Endpoint.compareDeep(this.address, o.address, true) && Endpoint.compareDeep(this.header, o.header, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Endpoint)) {
            return false;
        }
        Endpoint o = (Endpoint)other_;
        return Endpoint.compareValues(this.status, o.status, true) && Endpoint.compareValues(this.name, o.name, true) && Endpoint.compareValues(this.payloadMimeType, o.payloadMimeType, true) && Endpoint.compareValues(this.address, o.address, true) && Endpoint.compareValues(this.header, o.header, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.connectionType, this.name, this.managingOrganization, this.contact, this.period, this.payloadType, this.payloadMimeType, this.address, this.header});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Endpoint;
    }

    public static class EndpointStatusEnumFactory
    implements EnumFactory<EndpointStatus> {
        @Override
        public EndpointStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return EndpointStatus.ACTIVE;
            }
            if ("suspended".equals(codeString)) {
                return EndpointStatus.SUSPENDED;
            }
            if ("error".equals(codeString)) {
                return EndpointStatus.ERROR;
            }
            if ("off".equals(codeString)) {
                return EndpointStatus.OFF;
            }
            if ("entered-in-error".equals(codeString)) {
                return EndpointStatus.ENTEREDINERROR;
            }
            if ("test".equals(codeString)) {
                return EndpointStatus.TEST;
            }
            throw new IllegalArgumentException("Unknown EndpointStatus code '" + codeString + "'");
        }

        public Enumeration<EndpointStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<EndpointStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return new Enumeration<EndpointStatus>(this, EndpointStatus.ACTIVE);
            }
            if ("suspended".equals(codeString)) {
                return new Enumeration<EndpointStatus>(this, EndpointStatus.SUSPENDED);
            }
            if ("error".equals(codeString)) {
                return new Enumeration<EndpointStatus>(this, EndpointStatus.ERROR);
            }
            if ("off".equals(codeString)) {
                return new Enumeration<EndpointStatus>(this, EndpointStatus.OFF);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<EndpointStatus>(this, EndpointStatus.ENTEREDINERROR);
            }
            if ("test".equals(codeString)) {
                return new Enumeration<EndpointStatus>(this, EndpointStatus.TEST);
            }
            throw new FHIRException("Unknown EndpointStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(EndpointStatus code) {
            if (code == EndpointStatus.ACTIVE) {
                return "active";
            }
            if (code == EndpointStatus.SUSPENDED) {
                return "suspended";
            }
            if (code == EndpointStatus.ERROR) {
                return "error";
            }
            if (code == EndpointStatus.OFF) {
                return "off";
            }
            if (code == EndpointStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == EndpointStatus.TEST) {
                return "test";
            }
            return "?";
        }

        @Override
        public String toSystem(EndpointStatus code) {
            return code.getSystem();
        }
    }

    public static enum EndpointStatus {
        ACTIVE,
        SUSPENDED,
        ERROR,
        OFF,
        ENTEREDINERROR,
        TEST,
        NULL;


        public static EndpointStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("suspended".equals(codeString)) {
                return SUSPENDED;
            }
            if ("error".equals(codeString)) {
                return ERROR;
            }
            if ("off".equals(codeString)) {
                return OFF;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("test".equals(codeString)) {
                return TEST;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown EndpointStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case SUSPENDED: {
                    return "suspended";
                }
                case ERROR: {
                    return "error";
                }
                case OFF: {
                    return "off";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case TEST: {
                    return "test";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/endpoint-status";
                }
                case SUSPENDED: {
                    return "http://hl7.org/fhir/endpoint-status";
                }
                case ERROR: {
                    return "http://hl7.org/fhir/endpoint-status";
                }
                case OFF: {
                    return "http://hl7.org/fhir/endpoint-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/endpoint-status";
                }
                case TEST: {
                    return "http://hl7.org/fhir/endpoint-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "This endpoint is expected to be active and can be used";
                }
                case SUSPENDED: {
                    return "This endpoint is temporarily unavailable";
                }
                case ERROR: {
                    return "This endpoint has exceeded connectivity thresholds and is considered in an error state and should no longer be attempted to connect to until corrective action is taken";
                }
                case OFF: {
                    return "This endpoint is no longer to be used";
                }
                case ENTEREDINERROR: {
                    return "This instance should not have been part of this patient's medical record.";
                }
                case TEST: {
                    return "This endpoint is not intended for production usage.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case SUSPENDED: {
                    return "Suspended";
                }
                case ERROR: {
                    return "Error";
                }
                case OFF: {
                    return "Off";
                }
                case ENTEREDINERROR: {
                    return "Entered in error";
                }
                case TEST: {
                    return "Test";
                }
            }
            return "?";
        }
    }
}

