/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.r4.model.BaseDateTimeType;
import org.hl7.fhir.r4.model.InstantType;

@DatatypeDef(name="date")
public class DateType
extends BaseDateTimeType {
    public static final TemporalPrecisionEnum DEFAULT_PRECISION = TemporalPrecisionEnum.DAY;
    private static final long serialVersionUID = 3L;

    public DateType() {
    }

    public DateType(Date theDate) {
        super(theDate, DEFAULT_PRECISION);
    }

    public DateType(Date theDate, TemporalPrecisionEnum thePrecision) {
        super(theDate, thePrecision);
    }

    public DateType(String theDate) {
        super(theDate);
    }

    public DateType(Calendar theCalendar) {
        super(theCalendar.getTime(), DEFAULT_PRECISION);
        this.setTimeZone(theCalendar.getTimeZone());
    }

    public DateType(int theYear, int theMonth, int theDay) {
        this(DateType.toCalendarZulu(theYear, theMonth, theDay));
    }

    @Override
    public DateType copy() {
        return new DateType(this.getValueAsString());
    }

    @Override
    public String fhirType() {
        return "date";
    }

    @Override
    protected TemporalPrecisionEnum getDefaultPrecisionForDatatype() {
        return DEFAULT_PRECISION;
    }

    @Override
    boolean isPrecisionAllowed(TemporalPrecisionEnum thePrecision) {
        switch (thePrecision) {
            case YEAR: 
            case MONTH: 
            case DAY: {
                return true;
            }
        }
        return false;
    }

    public static DateType parseV3(String theV3String) {
        DateType retVal = new DateType();
        retVal.setValueAsV3String(theV3String);
        return retVal;
    }

    private static GregorianCalendar toCalendarZulu(int theYear, int theMonth, int theDay) {
        Validate.isTrue((theMonth >= 0 ? 1 : 0) != 0, (String)"theMonth must be between 0 and 11", (Object[])new Object[0]);
        Validate.isTrue((theMonth <= 11 ? 1 : 0) != 0, (String)"theMonth must be between 0 and 11", (Object[])new Object[0]);
        Validate.isTrue((theDay >= 1 ? 1 : 0) != 0, (String)"theMonth must be between 0 and 11", (Object[])new Object[0]);
        Validate.isTrue((theDay <= 31 ? 1 : 0) != 0, (String)"theMonth must be between 0 and 11", (Object[])new Object[0]);
        GregorianCalendar retVal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        retVal.set(1, theYear);
        retVal.set(2, theMonth);
        retVal.set(5, theDay);
        return retVal;
    }

    public static InstantType today() {
        return new InstantType(new Date(), TemporalPrecisionEnum.DAY, TimeZone.getDefault());
    }
}

