/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.hapi.ctx;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.support.IContextValidationSupport;
import ca.uhn.fhir.fluentpath.IFluentPath;
import ca.uhn.fhir.model.api.IFhirVersion;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.IVersionSpecificBundleFactory;
import ca.uhn.fhir.util.ReflectionUtil;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.hapi.fluentpath.FluentPathR4;
import org.hl7.fhir.r4.hapi.rest.server.R4BundleFactory;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.StructureDefinition;

public class FhirR4
implements IFhirVersion {
    private String myId;

    public IFluentPath createFluentPathExecutor(FhirContext theFhirContext) {
        return new FluentPathR4(theFhirContext);
    }

    public IContextValidationSupport<?, ?, ?, ?, ?, ?> createValidationSupport() {
        return ReflectionUtil.newInstanceOfFhirProfileValidationSupport((String)"org.hl7.fhir.r4.hapi.ctx.DefaultProfileValidationSupport");
    }

    public IBaseResource generateProfile(RuntimeResourceDefinition theRuntimeResourceDefinition, String theServerBase) {
        StructureDefinition retVal = new StructureDefinition();
        RuntimeResourceDefinition def = theRuntimeResourceDefinition;
        this.myId = def.getId();
        if (StringUtils.isBlank((CharSequence)this.myId)) {
            this.myId = theRuntimeResourceDefinition.getName().toLowerCase();
        }
        retVal.setId((IIdType)new IdDt(this.myId));
        return retVal;
    }

    public Class<List> getContainedType() {
        return List.class;
    }

    public InputStream getFhirVersionPropertiesFile() {
        String path = "org/hl7/fhir/r4/model/fhirversion.properties";
        InputStream str = FhirR4.class.getResourceAsStream("/" + path);
        if (str == null) {
            str = FhirR4.class.getResourceAsStream(path);
        }
        if (str == null) {
            throw new ConfigurationException("Can not find model property file on classpath: " + path);
        }
        return str;
    }

    public IPrimitiveType<Date> getLastUpdated(IBaseResource theResource) {
        return ((Resource)theResource).getMeta().getLastUpdatedElement();
    }

    public String getPathToSchemaDefinitions() {
        return "/org/hl7/fhir/r4/model/schema";
    }

    public Class<? extends IBaseReference> getResourceReferenceType() {
        return Reference.class;
    }

    public Object getServerVersion() {
        return ReflectionUtil.newInstanceOfFhirServerType((String)"org.hl7.fhir.r4.hapi.ctx.FhirServerR4");
    }

    public FhirVersionEnum getVersion() {
        return FhirVersionEnum.R4;
    }

    public IVersionSpecificBundleFactory newBundleFactory(FhirContext theContext) {
        return new R4BundleFactory(theContext);
    }

    public IBaseCoding newCodingDt() {
        return new Coding();
    }

    public IIdType newIdType() {
        return new IdType();
    }
}

