/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum V3CodingRationale {
    O,
    OR,
    P,
    PR,
    R,
    HL7,
    SH,
    SRC,
    NULL;


    public static V3CodingRationale fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("O".equals(codeString)) {
            return O;
        }
        if ("OR".equals(codeString)) {
            return OR;
        }
        if ("P".equals(codeString)) {
            return P;
        }
        if ("PR".equals(codeString)) {
            return PR;
        }
        if ("R".equals(codeString)) {
            return R;
        }
        if ("HL7".equals(codeString)) {
            return HL7;
        }
        if ("SH".equals(codeString)) {
            return SH;
        }
        if ("SRC".equals(codeString)) {
            return SRC;
        }
        throw new FHIRException("Unknown V3CodingRationale code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case O: {
                return "O";
            }
            case OR: {
                return "OR";
            }
            case P: {
                return "P";
            }
            case PR: {
                return "PR";
            }
            case R: {
                return "R";
            }
            case HL7: {
                return "HL7";
            }
            case SH: {
                return "SH";
            }
            case SRC: {
                return "SRC";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/v3/CodingRationale";
    }

    public String getDefinition() {
        switch (this) {
            case O: {
                return "Description: Originally produced code.";
            }
            case OR: {
                return "Originally produced code, required by the specification describing the use of the coded concept.";
            }
            case P: {
                return "Description: Post-coded from free text source</description>";
            }
            case PR: {
                return "Post-coded from free text source, required by the specification describing the use of the coded concept.";
            }
            case R: {
                return "Description: Required standard code for HL7.";
            }
            case HL7: {
                return "HL7 Specified or Mandated";
            }
            case SH: {
                return "Both HL7 mandated and the original code (precoordination)";
            }
            case SRC: {
                return "Source (or original) code";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case O: {
                return "originally produced code";
            }
            case OR: {
                return "original and required";
            }
            case P: {
                return "post-coded";
            }
            case PR: {
                return "post-coded and required";
            }
            case R: {
                return "required";
            }
            case HL7: {
                return "HL7 Specified or Mandated";
            }
            case SH: {
                return "Both HL7 mandated and the original code";
            }
            case SRC: {
                return "Source (or original) code";
            }
        }
        return "?";
    }
}

