/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu3.model.Attachment;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.BooleanType;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.Organization;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Ratio;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.SimpleQuantity;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.Substance;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Medication", profile="http://hl7.org/fhir/StructureDefinition/Medication")
public class Medication
extends DomainResource {
    @Child(name="code", type={CodeableConcept.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Codes that identify this medication", formalDefinition="A code (or set of codes) that specify this medication, or a textual description if no code is available. Usage note: This could be a standard medication code such as a code from RxNorm, SNOMED CT, IDMP etc. It could also be a national or local formulary code, optionally with translations to other code systems.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-codes")
    protected CodeableConcept code;
    @Child(name="status", type={CodeType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="active | inactive | entered-in-error", formalDefinition="A code to indicate if the medication is in active use.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-status")
    protected Enumeration<MedicationStatus> status;
    @Child(name="isBrand", type={BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="True if a brand", formalDefinition="Set to true if the item is attributable to a specific manufacturer.")
    protected BooleanType isBrand;
    @Child(name="isOverTheCounter", type={BooleanType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="True if medication does not require a prescription", formalDefinition="Set to true if the medication can be obtained without an order from a prescriber.")
    protected BooleanType isOverTheCounter;
    @Child(name="manufacturer", type={Organization.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Manufacturer of the item", formalDefinition="Describes the details of the manufacturer of the medication product.  This is not intended to represent the distributor of a medication product.")
    protected Reference manufacturer;
    protected Organization manufacturerTarget;
    @Child(name="form", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="powder | tablets | capsule +", formalDefinition="Describes the form of the item.  Powder; tablets; capsule.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-form-codes")
    protected CodeableConcept form;
    @Child(name="ingredient", type={}, order=6, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Active or inactive ingredient", formalDefinition="Identifies a particular constituent of interest in the product.")
    protected List<MedicationIngredientComponent> ingredient;
    @Child(name="package", type={}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Details about packaged medications", formalDefinition="Information that only applies to packages (not products).")
    protected MedicationPackageComponent package_;
    @Child(name="image", type={Attachment.class}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Picture of the medication", formalDefinition="Photo(s) or graphic representation(s) of the medication.")
    protected List<Attachment> image;
    private static final long serialVersionUID = 860383645L;
    @SearchParamDefinition(name="ingredient-code", path="Medication.ingredient.item.as(CodeableConcept)", description="The product contained", type="token")
    public static final String SP_INGREDIENT_CODE = "ingredient-code";
    public static final TokenClientParam INGREDIENT_CODE = new TokenClientParam("ingredient-code");
    @SearchParamDefinition(name="container", path="Medication.package.container", description="E.g. box, vial, blister-pack", type="token")
    public static final String SP_CONTAINER = "container";
    public static final TokenClientParam CONTAINER = new TokenClientParam("container");
    @SearchParamDefinition(name="package-item", path="Medication.package.content.item.as(Reference)", description="The item in the package", type="reference", target={Medication.class})
    public static final String SP_PACKAGE_ITEM = "package-item";
    public static final ReferenceClientParam PACKAGE_ITEM = new ReferenceClientParam("package-item");
    public static final Include INCLUDE_PACKAGE_ITEM = new Include("Medication:package-item").toLocked();
    @SearchParamDefinition(name="code", path="Medication.code", description="Codes that identify this medication", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="ingredient", path="Medication.ingredient.item.as(Reference)", description="The product contained", type="reference", target={Medication.class, Substance.class})
    public static final String SP_INGREDIENT = "ingredient";
    public static final ReferenceClientParam INGREDIENT = new ReferenceClientParam("ingredient");
    public static final Include INCLUDE_INGREDIENT = new Include("Medication:ingredient").toLocked();
    @SearchParamDefinition(name="form", path="Medication.form", description="powder | tablets | capsule +", type="token")
    public static final String SP_FORM = "form";
    public static final TokenClientParam FORM = new TokenClientParam("form");
    @SearchParamDefinition(name="package-item-code", path="Medication.package.content.item.as(CodeableConcept)", description="The item in the package", type="token")
    public static final String SP_PACKAGE_ITEM_CODE = "package-item-code";
    public static final TokenClientParam PACKAGE_ITEM_CODE = new TokenClientParam("package-item-code");
    @SearchParamDefinition(name="manufacturer", path="Medication.manufacturer", description="Manufacturer of the item", type="reference", target={Organization.class})
    public static final String SP_MANUFACTURER = "manufacturer";
    public static final ReferenceClientParam MANUFACTURER = new ReferenceClientParam("manufacturer");
    public static final Include INCLUDE_MANUFACTURER = new Include("Medication:manufacturer").toLocked();
    @SearchParamDefinition(name="over-the-counter", path="Medication.isOverTheCounter", description="True if medication does not require a prescription", type="token")
    public static final String SP_OVER_THE_COUNTER = "over-the-counter";
    public static final TokenClientParam OVER_THE_COUNTER = new TokenClientParam("over-the-counter");
    @SearchParamDefinition(name="status", path="Medication.status", description="active | inactive | entered-in-error", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Medication.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public Medication setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public Enumeration<MedicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Medication.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<MedicationStatus>(new MedicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Medication setStatusElement(Enumeration<MedicationStatus> value) {
        this.status = value;
        return this;
    }

    public MedicationStatus getStatus() {
        return this.status == null ? null : (MedicationStatus)((Object)this.status.getValue());
    }

    public Medication setStatus(MedicationStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<MedicationStatus>(new MedicationStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public BooleanType getIsBrandElement() {
        if (this.isBrand == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Medication.isBrand");
            }
            if (Configuration.doAutoCreate()) {
                this.isBrand = new BooleanType();
            }
        }
        return this.isBrand;
    }

    public boolean hasIsBrandElement() {
        return this.isBrand != null && !this.isBrand.isEmpty();
    }

    public boolean hasIsBrand() {
        return this.isBrand != null && !this.isBrand.isEmpty();
    }

    public Medication setIsBrandElement(BooleanType value) {
        this.isBrand = value;
        return this;
    }

    public boolean getIsBrand() {
        return this.isBrand == null || this.isBrand.isEmpty() ? false : (Boolean)this.isBrand.getValue();
    }

    public Medication setIsBrand(boolean value) {
        if (this.isBrand == null) {
            this.isBrand = new BooleanType();
        }
        this.isBrand.setValue((Object)value);
        return this;
    }

    public BooleanType getIsOverTheCounterElement() {
        if (this.isOverTheCounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Medication.isOverTheCounter");
            }
            if (Configuration.doAutoCreate()) {
                this.isOverTheCounter = new BooleanType();
            }
        }
        return this.isOverTheCounter;
    }

    public boolean hasIsOverTheCounterElement() {
        return this.isOverTheCounter != null && !this.isOverTheCounter.isEmpty();
    }

    public boolean hasIsOverTheCounter() {
        return this.isOverTheCounter != null && !this.isOverTheCounter.isEmpty();
    }

    public Medication setIsOverTheCounterElement(BooleanType value) {
        this.isOverTheCounter = value;
        return this;
    }

    public boolean getIsOverTheCounter() {
        return this.isOverTheCounter == null || this.isOverTheCounter.isEmpty() ? false : (Boolean)this.isOverTheCounter.getValue();
    }

    public Medication setIsOverTheCounter(boolean value) {
        if (this.isOverTheCounter == null) {
            this.isOverTheCounter = new BooleanType();
        }
        this.isOverTheCounter.setValue((Object)value);
        return this;
    }

    public Reference getManufacturer() {
        if (this.manufacturer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Medication.manufacturer");
            }
            if (Configuration.doAutoCreate()) {
                this.manufacturer = new Reference();
            }
        }
        return this.manufacturer;
    }

    public boolean hasManufacturer() {
        return this.manufacturer != null && !this.manufacturer.isEmpty();
    }

    public Medication setManufacturer(Reference value) {
        this.manufacturer = value;
        return this;
    }

    public Organization getManufacturerTarget() {
        if (this.manufacturerTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Medication.manufacturer");
            }
            if (Configuration.doAutoCreate()) {
                this.manufacturerTarget = new Organization();
            }
        }
        return this.manufacturerTarget;
    }

    public Medication setManufacturerTarget(Organization value) {
        this.manufacturerTarget = value;
        return this;
    }

    public CodeableConcept getForm() {
        if (this.form == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Medication.form");
            }
            if (Configuration.doAutoCreate()) {
                this.form = new CodeableConcept();
            }
        }
        return this.form;
    }

    public boolean hasForm() {
        return this.form != null && !this.form.isEmpty();
    }

    public Medication setForm(CodeableConcept value) {
        this.form = value;
        return this;
    }

    public List<MedicationIngredientComponent> getIngredient() {
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<MedicationIngredientComponent>();
        }
        return this.ingredient;
    }

    public Medication setIngredient(List<MedicationIngredientComponent> theIngredient) {
        this.ingredient = theIngredient;
        return this;
    }

    public boolean hasIngredient() {
        if (this.ingredient == null) {
            return false;
        }
        for (MedicationIngredientComponent item : this.ingredient) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicationIngredientComponent addIngredient() {
        MedicationIngredientComponent t = new MedicationIngredientComponent();
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<MedicationIngredientComponent>();
        }
        this.ingredient.add(t);
        return t;
    }

    public Medication addIngredient(MedicationIngredientComponent t) {
        if (t == null) {
            return this;
        }
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<MedicationIngredientComponent>();
        }
        this.ingredient.add(t);
        return this;
    }

    public MedicationIngredientComponent getIngredientFirstRep() {
        if (this.getIngredient().isEmpty()) {
            this.addIngredient();
        }
        return this.getIngredient().get(0);
    }

    public MedicationPackageComponent getPackage() {
        if (this.package_ == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Medication.package_");
            }
            if (Configuration.doAutoCreate()) {
                this.package_ = new MedicationPackageComponent();
            }
        }
        return this.package_;
    }

    public boolean hasPackage() {
        return this.package_ != null && !this.package_.isEmpty();
    }

    public Medication setPackage(MedicationPackageComponent value) {
        this.package_ = value;
        return this;
    }

    public List<Attachment> getImage() {
        if (this.image == null) {
            this.image = new ArrayList<Attachment>();
        }
        return this.image;
    }

    public Medication setImage(List<Attachment> theImage) {
        this.image = theImage;
        return this;
    }

    public boolean hasImage() {
        if (this.image == null) {
            return false;
        }
        for (Attachment item : this.image) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Attachment addImage() {
        Attachment t = new Attachment();
        if (this.image == null) {
            this.image = new ArrayList<Attachment>();
        }
        this.image.add(t);
        return t;
    }

    public Medication addImage(Attachment t) {
        if (t == null) {
            return this;
        }
        if (this.image == null) {
            this.image = new ArrayList<Attachment>();
        }
        this.image.add(t);
        return this;
    }

    public Attachment getImageFirstRep() {
        if (this.getImage().isEmpty()) {
            this.addImage();
        }
        return this.getImage().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_CODE, "CodeableConcept", "A code (or set of codes) that specify this medication, or a textual description if no code is available. Usage note: This could be a standard medication code such as a code from RxNorm, SNOMED CT, IDMP etc. It could also be a national or local formulary code, optionally with translations to other code systems.", 0, 1, this.code));
        children.add(new Property(SP_STATUS, SP_CODE, "A code to indicate if the medication is in active use.", 0, 1, this.status));
        children.add(new Property("isBrand", "boolean", "Set to true if the item is attributable to a specific manufacturer.", 0, 1, this.isBrand));
        children.add(new Property("isOverTheCounter", "boolean", "Set to true if the medication can be obtained without an order from a prescriber.", 0, 1, this.isOverTheCounter));
        children.add(new Property(SP_MANUFACTURER, "Reference(Organization)", "Describes the details of the manufacturer of the medication product.  This is not intended to represent the distributor of a medication product.", 0, 1, this.manufacturer));
        children.add(new Property(SP_FORM, "CodeableConcept", "Describes the form of the item.  Powder; tablets; capsule.", 0, 1, this.form));
        children.add(new Property(SP_INGREDIENT, "", "Identifies a particular constituent of interest in the product.", 0, Integer.MAX_VALUE, this.ingredient));
        children.add(new Property("package", "", "Information that only applies to packages (not products).", 0, 1, this.package_));
        children.add(new Property("image", "Attachment", "Photo(s) or graphic representation(s) of the medication.", 0, Integer.MAX_VALUE, this.image));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 3059181: {
                return new Property(SP_CODE, "CodeableConcept", "A code (or set of codes) that specify this medication, or a textual description if no code is available. Usage note: This could be a standard medication code such as a code from RxNorm, SNOMED CT, IDMP etc. It could also be a national or local formulary code, optionally with translations to other code systems.", 0, 1, this.code);
            }
            case -892481550: {
                return new Property(SP_STATUS, SP_CODE, "A code to indicate if the medication is in active use.", 0, 1, this.status);
            }
            case 2055403645: {
                return new Property("isBrand", "boolean", "Set to true if the item is attributable to a specific manufacturer.", 0, 1, this.isBrand);
            }
            case -650796023: {
                return new Property("isOverTheCounter", "boolean", "Set to true if the medication can be obtained without an order from a prescriber.", 0, 1, this.isOverTheCounter);
            }
            case -1969347631: {
                return new Property(SP_MANUFACTURER, "Reference(Organization)", "Describes the details of the manufacturer of the medication product.  This is not intended to represent the distributor of a medication product.", 0, 1, this.manufacturer);
            }
            case 3148996: {
                return new Property(SP_FORM, "CodeableConcept", "Describes the form of the item.  Powder; tablets; capsule.", 0, 1, this.form);
            }
            case -206409263: {
                return new Property(SP_INGREDIENT, "", "Identifies a particular constituent of interest in the product.", 0, Integer.MAX_VALUE, this.ingredient);
            }
            case -807062458: {
                return new Property("package", "", "Information that only applies to packages (not products).", 0, 1, this.package_);
            }
            case 100313435: {
                return new Property("image", "Attachment", "Photo(s) or graphic representation(s) of the medication.", 0, Integer.MAX_VALUE, this.image);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.code;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case 2055403645: {
                Base[] baseArray;
                if (this.isBrand == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.isBrand;
                }
                return baseArray;
            }
            case -650796023: {
                Base[] baseArray;
                if (this.isOverTheCounter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.isOverTheCounter;
                }
                return baseArray;
            }
            case -1969347631: {
                Base[] baseArray;
                if (this.manufacturer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.manufacturer;
                }
                return baseArray;
            }
            case 3148996: {
                Base[] baseArray;
                if (this.form == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.form;
                }
                return baseArray;
            }
            case -206409263: {
                return this.ingredient == null ? new Base[]{} : this.ingredient.toArray(new Base[this.ingredient.size()]);
            }
            case -807062458: {
                Base[] baseArray;
                if (this.package_ == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.package_;
                }
                return baseArray;
            }
            case 100313435: {
                return this.image == null ? new Base[]{} : this.image.toArray(new Base[this.image.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 3059181: {
                this.code = this.castToCodeableConcept(value);
                return value;
            }
            case -892481550: {
                value = new MedicationStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case 2055403645: {
                this.isBrand = this.castToBoolean(value);
                return value;
            }
            case -650796023: {
                this.isOverTheCounter = this.castToBoolean(value);
                return value;
            }
            case -1969347631: {
                this.manufacturer = this.castToReference(value);
                return value;
            }
            case 3148996: {
                this.form = this.castToCodeableConcept(value);
                return value;
            }
            case -206409263: {
                this.getIngredient().add((MedicationIngredientComponent)((Object)value));
                return value;
            }
            case -807062458: {
                this.package_ = (MedicationPackageComponent)((Object)value);
                return value;
            }
            case 100313435: {
                this.getImage().add(this.castToAttachment(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_CODE)) {
            this.code = this.castToCodeableConcept(value);
        } else if (name.equals(SP_STATUS)) {
            value = new MedicationStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals("isBrand")) {
            this.isBrand = this.castToBoolean(value);
        } else if (name.equals("isOverTheCounter")) {
            this.isOverTheCounter = this.castToBoolean(value);
        } else if (name.equals(SP_MANUFACTURER)) {
            this.manufacturer = this.castToReference(value);
        } else if (name.equals(SP_FORM)) {
            this.form = this.castToCodeableConcept(value);
        } else if (name.equals(SP_INGREDIENT)) {
            this.getIngredient().add((MedicationIngredientComponent)((Object)value));
        } else if (name.equals("package")) {
            this.package_ = (MedicationPackageComponent)((Object)value);
        } else if (name.equals("image")) {
            this.getImage().add(this.castToAttachment(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3059181: {
                return this.getCode();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 2055403645: {
                return this.getIsBrandElement();
            }
            case -650796023: {
                return this.getIsOverTheCounterElement();
            }
            case -1969347631: {
                return this.getManufacturer();
            }
            case 3148996: {
                return this.getForm();
            }
            case -206409263: {
                return this.addIngredient();
            }
            case -807062458: {
                return this.getPackage();
            }
            case 100313435: {
                return this.addImage();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case 2055403645: {
                return new String[]{"boolean"};
            }
            case -650796023: {
                return new String[]{"boolean"};
            }
            case -1969347631: {
                return new String[]{"Reference"};
            }
            case 3148996: {
                return new String[]{"CodeableConcept"};
            }
            case -206409263: {
                return new String[0];
            }
            case -807062458: {
                return new String[0];
            }
            case 100313435: {
                return new String[]{"Attachment"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_CODE)) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Medication.status");
        }
        if (name.equals("isBrand")) {
            throw new FHIRException("Cannot call addChild on a primitive type Medication.isBrand");
        }
        if (name.equals("isOverTheCounter")) {
            throw new FHIRException("Cannot call addChild on a primitive type Medication.isOverTheCounter");
        }
        if (name.equals(SP_MANUFACTURER)) {
            this.manufacturer = new Reference();
            return this.manufacturer;
        }
        if (name.equals(SP_FORM)) {
            this.form = new CodeableConcept();
            return this.form;
        }
        if (name.equals(SP_INGREDIENT)) {
            return this.addIngredient();
        }
        if (name.equals("package")) {
            this.package_ = new MedicationPackageComponent();
            return this.package_;
        }
        if (name.equals("image")) {
            return this.addImage();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Medication";
    }

    @Override
    public Medication copy() {
        Medication dst = new Medication();
        this.copyValues(dst);
        dst.code = this.code == null ? null : this.code.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.isBrand = this.isBrand == null ? null : this.isBrand.copy();
        dst.isOverTheCounter = this.isOverTheCounter == null ? null : this.isOverTheCounter.copy();
        dst.manufacturer = this.manufacturer == null ? null : this.manufacturer.copy();
        CodeableConcept codeableConcept = dst.form = this.form == null ? null : this.form.copy();
        if (this.ingredient != null) {
            dst.ingredient = new ArrayList<MedicationIngredientComponent>();
            for (MedicationIngredientComponent medicationIngredientComponent : this.ingredient) {
                dst.ingredient.add(medicationIngredientComponent.copy());
            }
        }
        MedicationPackageComponent medicationPackageComponent = dst.package_ = this.package_ == null ? null : this.package_.copy();
        if (this.image != null) {
            dst.image = new ArrayList<Attachment>();
            for (Attachment attachment : this.image) {
                dst.image.add(attachment.copy());
            }
        }
        return dst;
    }

    protected Medication typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Medication)) {
            return false;
        }
        Medication o = (Medication)other_;
        return Medication.compareDeep(this.code, o.code, true) && Medication.compareDeep(this.status, o.status, true) && Medication.compareDeep(this.isBrand, o.isBrand, true) && Medication.compareDeep(this.isOverTheCounter, o.isOverTheCounter, true) && Medication.compareDeep(this.manufacturer, o.manufacturer, true) && Medication.compareDeep(this.form, o.form, true) && Medication.compareDeep(this.ingredient, o.ingredient, true) && Medication.compareDeep(this.package_, o.package_, true) && Medication.compareDeep(this.image, o.image, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Medication)) {
            return false;
        }
        Medication o = (Medication)other_;
        return Medication.compareValues(this.status, o.status, true) && Medication.compareValues(this.isBrand, o.isBrand, true) && Medication.compareValues(this.isOverTheCounter, o.isOverTheCounter, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.code, this.status, this.isBrand, this.isOverTheCounter, this.manufacturer, this.form, this.ingredient, this.package_, this.image});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Medication;
    }

    @Block
    public static class MedicationPackageBatchComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="lotNumber", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Identifier assigned to batch", formalDefinition="The assigned lot number of a batch of the specified product.")
        protected StringType lotNumber;
        @Child(name="expirationDate", type={DateTimeType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When batch will expire", formalDefinition="When this specific batch of product will expire.")
        protected DateTimeType expirationDate;
        private static final long serialVersionUID = 1982738755L;

        public StringType getLotNumberElement() {
            if (this.lotNumber == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationPackageBatchComponent.lotNumber");
                }
                if (Configuration.doAutoCreate()) {
                    this.lotNumber = new StringType();
                }
            }
            return this.lotNumber;
        }

        public boolean hasLotNumberElement() {
            return this.lotNumber != null && !this.lotNumber.isEmpty();
        }

        public boolean hasLotNumber() {
            return this.lotNumber != null && !this.lotNumber.isEmpty();
        }

        public MedicationPackageBatchComponent setLotNumberElement(StringType value) {
            this.lotNumber = value;
            return this;
        }

        public String getLotNumber() {
            return this.lotNumber == null ? null : (String)this.lotNumber.getValue();
        }

        public MedicationPackageBatchComponent setLotNumber(String value) {
            if (Utilities.noString((String)value)) {
                this.lotNumber = null;
            } else {
                if (this.lotNumber == null) {
                    this.lotNumber = new StringType();
                }
                this.lotNumber.setValue(value);
            }
            return this;
        }

        public DateTimeType getExpirationDateElement() {
            if (this.expirationDate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationPackageBatchComponent.expirationDate");
                }
                if (Configuration.doAutoCreate()) {
                    this.expirationDate = new DateTimeType();
                }
            }
            return this.expirationDate;
        }

        public boolean hasExpirationDateElement() {
            return this.expirationDate != null && !this.expirationDate.isEmpty();
        }

        public boolean hasExpirationDate() {
            return this.expirationDate != null && !this.expirationDate.isEmpty();
        }

        public MedicationPackageBatchComponent setExpirationDateElement(DateTimeType value) {
            this.expirationDate = value;
            return this;
        }

        public Date getExpirationDate() {
            return this.expirationDate == null ? null : (Date)this.expirationDate.getValue();
        }

        public MedicationPackageBatchComponent setExpirationDate(Date value) {
            if (value == null) {
                this.expirationDate = null;
            } else {
                if (this.expirationDate == null) {
                    this.expirationDate = new DateTimeType();
                }
                this.expirationDate.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("lotNumber", "string", "The assigned lot number of a batch of the specified product.", 0, 1, this.lotNumber));
            children.add(new Property("expirationDate", "dateTime", "When this specific batch of product will expire.", 0, 1, this.expirationDate));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 462547450: {
                    return new Property("lotNumber", "string", "The assigned lot number of a batch of the specified product.", 0, 1, this.lotNumber);
                }
                case -668811523: {
                    return new Property("expirationDate", "dateTime", "When this specific batch of product will expire.", 0, 1, this.expirationDate);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 462547450: {
                    Base[] baseArray;
                    if (this.lotNumber == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.lotNumber;
                    }
                    return baseArray;
                }
                case -668811523: {
                    Base[] baseArray;
                    if (this.expirationDate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.expirationDate;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 462547450: {
                    this.lotNumber = this.castToString(value);
                    return value;
                }
                case -668811523: {
                    this.expirationDate = this.castToDateTime(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("lotNumber")) {
                this.lotNumber = this.castToString(value);
            } else if (name.equals("expirationDate")) {
                this.expirationDate = this.castToDateTime(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 462547450: {
                    return this.getLotNumberElement();
                }
                case -668811523: {
                    return this.getExpirationDateElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 462547450: {
                    return new String[]{"string"};
                }
                case -668811523: {
                    return new String[]{"dateTime"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("lotNumber")) {
                throw new FHIRException("Cannot call addChild on a primitive type Medication.lotNumber");
            }
            if (name.equals("expirationDate")) {
                throw new FHIRException("Cannot call addChild on a primitive type Medication.expirationDate");
            }
            return super.addChild(name);
        }

        @Override
        public MedicationPackageBatchComponent copy() {
            MedicationPackageBatchComponent dst = new MedicationPackageBatchComponent();
            this.copyValues(dst);
            dst.lotNumber = this.lotNumber == null ? null : this.lotNumber.copy();
            dst.expirationDate = this.expirationDate == null ? null : this.expirationDate.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationPackageBatchComponent)) {
                return false;
            }
            MedicationPackageBatchComponent o = (MedicationPackageBatchComponent)other_;
            return MedicationPackageBatchComponent.compareDeep(this.lotNumber, o.lotNumber, true) && MedicationPackageBatchComponent.compareDeep(this.expirationDate, o.expirationDate, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationPackageBatchComponent)) {
                return false;
            }
            MedicationPackageBatchComponent o = (MedicationPackageBatchComponent)other_;
            return MedicationPackageBatchComponent.compareValues(this.lotNumber, o.lotNumber, true) && MedicationPackageBatchComponent.compareValues(this.expirationDate, o.expirationDate, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.lotNumber, this.expirationDate});
        }

        @Override
        public String fhirType() {
            return "Medication.package.batch";
        }
    }

    @Block
    public static class MedicationPackageContentComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="item", type={CodeableConcept.class, Medication.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The item in the package", formalDefinition="Identifies one of the items in the package.")
        protected Type item;
        @Child(name="amount", type={SimpleQuantity.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Quantity present in the package", formalDefinition="The amount of the product that is in the package.")
        protected SimpleQuantity amount;
        private static final long serialVersionUID = 1669610080L;

        public MedicationPackageContentComponent() {
        }

        public MedicationPackageContentComponent(Type item) {
            this.item = item;
        }

        public Type getItem() {
            return this.item;
        }

        public CodeableConcept getItemCodeableConcept() throws FHIRException {
            if (this.item == null) {
                return null;
            }
            if (!(this.item instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.item.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.item;
        }

        public boolean hasItemCodeableConcept() {
            return this != null && this.item instanceof CodeableConcept;
        }

        public Reference getItemReference() throws FHIRException {
            if (this.item == null) {
                return null;
            }
            if (!(this.item instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.item.getClass().getName() + " was encountered");
            }
            return (Reference)this.item;
        }

        public boolean hasItemReference() {
            return this != null && this.item instanceof Reference;
        }

        public boolean hasItem() {
            return this.item != null && !this.item.isEmpty();
        }

        public MedicationPackageContentComponent setItem(Type value) throws FHIRFormatError {
            if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
                throw new FHIRFormatError("Not the right type for Medication.package.content.item[x]: " + value.fhirType());
            }
            this.item = value;
            return this;
        }

        public SimpleQuantity getAmount() {
            if (this.amount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationPackageContentComponent.amount");
                }
                if (Configuration.doAutoCreate()) {
                    this.amount = new SimpleQuantity();
                }
            }
            return this.amount;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public MedicationPackageContentComponent setAmount(SimpleQuantity value) {
            this.amount = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("item[x]", "CodeableConcept|Reference(Medication)", "Identifies one of the items in the package.", 0, 1, this.item));
            children.add(new Property("amount", "SimpleQuantity", "The amount of the product that is in the package.", 0, 1, this.amount));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 2116201613: {
                    return new Property("item[x]", "CodeableConcept|Reference(Medication)", "Identifies one of the items in the package.", 0, 1, this.item);
                }
                case 3242771: {
                    return new Property("item[x]", "CodeableConcept|Reference(Medication)", "Identifies one of the items in the package.", 0, 1, this.item);
                }
                case 106644494: {
                    return new Property("item[x]", "CodeableConcept|Reference(Medication)", "Identifies one of the items in the package.", 0, 1, this.item);
                }
                case 1376364920: {
                    return new Property("item[x]", "CodeableConcept|Reference(Medication)", "Identifies one of the items in the package.", 0, 1, this.item);
                }
                case -1413853096: {
                    return new Property("amount", "SimpleQuantity", "The amount of the product that is in the package.", 0, 1, this.amount);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    Base[] baseArray;
                    if (this.item == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.item;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.amount;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    this.item = this.castToType(value);
                    return value;
                }
                case -1413853096: {
                    this.amount = this.castToSimpleQuantity(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("item[x]")) {
                this.item = this.castToType(value);
            } else if (name.equals("amount")) {
                this.amount = this.castToSimpleQuantity(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 2116201613: {
                    return this.getItem();
                }
                case 3242771: {
                    return this.getItem();
                }
                case -1413853096: {
                    return this.getAmount();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    return new String[]{"CodeableConcept", "Reference"};
                }
                case -1413853096: {
                    return new String[]{"SimpleQuantity"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("itemCodeableConcept")) {
                this.item = new CodeableConcept();
                return this.item;
            }
            if (name.equals("itemReference")) {
                this.item = new Reference();
                return this.item;
            }
            if (name.equals("amount")) {
                this.amount = new SimpleQuantity();
                return this.amount;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationPackageContentComponent copy() {
            MedicationPackageContentComponent dst = new MedicationPackageContentComponent();
            this.copyValues(dst);
            dst.item = this.item == null ? null : this.item.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationPackageContentComponent)) {
                return false;
            }
            MedicationPackageContentComponent o = (MedicationPackageContentComponent)other_;
            return MedicationPackageContentComponent.compareDeep(this.item, o.item, true) && MedicationPackageContentComponent.compareDeep(this.amount, o.amount, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationPackageContentComponent)) {
                return false;
            }
            MedicationPackageContentComponent o = (MedicationPackageContentComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.item, this.amount});
        }

        @Override
        public String fhirType() {
            return "Medication.package.content";
        }
    }

    @Block
    public static class MedicationPackageComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="container", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="E.g. box, vial, blister-pack", formalDefinition="The kind of container that this package comes as.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-package-form")
        protected CodeableConcept container;
        @Child(name="content", type={}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="What is  in the package", formalDefinition="A set of components that go to make up the described item.")
        protected List<MedicationPackageContentComponent> content;
        @Child(name="batch", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Identifies a single production run", formalDefinition="Information about a group of medication produced or packaged from one production run.")
        protected List<MedicationPackageBatchComponent> batch;
        private static final long serialVersionUID = -255992250L;

        public CodeableConcept getContainer() {
            if (this.container == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationPackageComponent.container");
                }
                if (Configuration.doAutoCreate()) {
                    this.container = new CodeableConcept();
                }
            }
            return this.container;
        }

        public boolean hasContainer() {
            return this.container != null && !this.container.isEmpty();
        }

        public MedicationPackageComponent setContainer(CodeableConcept value) {
            this.container = value;
            return this;
        }

        public List<MedicationPackageContentComponent> getContent() {
            if (this.content == null) {
                this.content = new ArrayList<MedicationPackageContentComponent>();
            }
            return this.content;
        }

        public MedicationPackageComponent setContent(List<MedicationPackageContentComponent> theContent) {
            this.content = theContent;
            return this;
        }

        public boolean hasContent() {
            if (this.content == null) {
                return false;
            }
            for (MedicationPackageContentComponent item : this.content) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MedicationPackageContentComponent addContent() {
            MedicationPackageContentComponent t = new MedicationPackageContentComponent();
            if (this.content == null) {
                this.content = new ArrayList<MedicationPackageContentComponent>();
            }
            this.content.add(t);
            return t;
        }

        public MedicationPackageComponent addContent(MedicationPackageContentComponent t) {
            if (t == null) {
                return this;
            }
            if (this.content == null) {
                this.content = new ArrayList<MedicationPackageContentComponent>();
            }
            this.content.add(t);
            return this;
        }

        public MedicationPackageContentComponent getContentFirstRep() {
            if (this.getContent().isEmpty()) {
                this.addContent();
            }
            return this.getContent().get(0);
        }

        public List<MedicationPackageBatchComponent> getBatch() {
            if (this.batch == null) {
                this.batch = new ArrayList<MedicationPackageBatchComponent>();
            }
            return this.batch;
        }

        public MedicationPackageComponent setBatch(List<MedicationPackageBatchComponent> theBatch) {
            this.batch = theBatch;
            return this;
        }

        public boolean hasBatch() {
            if (this.batch == null) {
                return false;
            }
            for (MedicationPackageBatchComponent item : this.batch) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MedicationPackageBatchComponent addBatch() {
            MedicationPackageBatchComponent t = new MedicationPackageBatchComponent();
            if (this.batch == null) {
                this.batch = new ArrayList<MedicationPackageBatchComponent>();
            }
            this.batch.add(t);
            return t;
        }

        public MedicationPackageComponent addBatch(MedicationPackageBatchComponent t) {
            if (t == null) {
                return this;
            }
            if (this.batch == null) {
                this.batch = new ArrayList<MedicationPackageBatchComponent>();
            }
            this.batch.add(t);
            return this;
        }

        public MedicationPackageBatchComponent getBatchFirstRep() {
            if (this.getBatch().isEmpty()) {
                this.addBatch();
            }
            return this.getBatch().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Medication.SP_CONTAINER, "CodeableConcept", "The kind of container that this package comes as.", 0, 1, this.container));
            children.add(new Property("content", "", "A set of components that go to make up the described item.", 0, Integer.MAX_VALUE, this.content));
            children.add(new Property("batch", "", "Information about a group of medication produced or packaged from one production run.", 0, Integer.MAX_VALUE, this.batch));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -410956671: {
                    return new Property(Medication.SP_CONTAINER, "CodeableConcept", "The kind of container that this package comes as.", 0, 1, this.container);
                }
                case 951530617: {
                    return new Property("content", "", "A set of components that go to make up the described item.", 0, Integer.MAX_VALUE, this.content);
                }
                case 93509434: {
                    return new Property("batch", "", "Information about a group of medication produced or packaged from one production run.", 0, Integer.MAX_VALUE, this.batch);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -410956671: {
                    Base[] baseArray;
                    if (this.container == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.container;
                    }
                    return baseArray;
                }
                case 951530617: {
                    return this.content == null ? new Base[]{} : this.content.toArray(new Base[this.content.size()]);
                }
                case 93509434: {
                    return this.batch == null ? new Base[]{} : this.batch.toArray(new Base[this.batch.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -410956671: {
                    this.container = this.castToCodeableConcept(value);
                    return value;
                }
                case 951530617: {
                    this.getContent().add((MedicationPackageContentComponent)value);
                    return value;
                }
                case 93509434: {
                    this.getBatch().add((MedicationPackageBatchComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Medication.SP_CONTAINER)) {
                this.container = this.castToCodeableConcept(value);
            } else if (name.equals("content")) {
                this.getContent().add((MedicationPackageContentComponent)value);
            } else if (name.equals("batch")) {
                this.getBatch().add((MedicationPackageBatchComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -410956671: {
                    return this.getContainer();
                }
                case 951530617: {
                    return this.addContent();
                }
                case 93509434: {
                    return this.addBatch();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -410956671: {
                    return new String[]{"CodeableConcept"};
                }
                case 951530617: {
                    return new String[0];
                }
                case 93509434: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Medication.SP_CONTAINER)) {
                this.container = new CodeableConcept();
                return this.container;
            }
            if (name.equals("content")) {
                return this.addContent();
            }
            if (name.equals("batch")) {
                return this.addBatch();
            }
            return super.addChild(name);
        }

        @Override
        public MedicationPackageComponent copy() {
            MedicationPackageComponent dst = new MedicationPackageComponent();
            this.copyValues(dst);
            CodeableConcept codeableConcept = dst.container = this.container == null ? null : this.container.copy();
            if (this.content != null) {
                dst.content = new ArrayList<MedicationPackageContentComponent>();
                for (MedicationPackageContentComponent medicationPackageContentComponent : this.content) {
                    dst.content.add(medicationPackageContentComponent.copy());
                }
            }
            if (this.batch != null) {
                dst.batch = new ArrayList<MedicationPackageBatchComponent>();
                for (MedicationPackageBatchComponent medicationPackageBatchComponent : this.batch) {
                    dst.batch.add(medicationPackageBatchComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationPackageComponent)) {
                return false;
            }
            MedicationPackageComponent o = (MedicationPackageComponent)other_;
            return MedicationPackageComponent.compareDeep(this.container, o.container, true) && MedicationPackageComponent.compareDeep(this.content, o.content, true) && MedicationPackageComponent.compareDeep(this.batch, o.batch, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationPackageComponent)) {
                return false;
            }
            MedicationPackageComponent o = (MedicationPackageComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.container, this.content, this.batch});
        }

        @Override
        public String fhirType() {
            return "Medication.package";
        }
    }

    @Block
    public static class MedicationIngredientComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="item", type={CodeableConcept.class, Substance.class, Medication.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The product contained", formalDefinition="The actual ingredient - either a substance (simple ingredient) or another medication.")
        protected Type item;
        @Child(name="isActive", type={BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Active ingredient indicator", formalDefinition="Indication of whether this\u00a0ingredient affects\u00a0the therapeutic action of the drug.")
        protected BooleanType isActive;
        @Child(name="amount", type={Ratio.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Quantity of ingredient present", formalDefinition="Specifies how many (or how much) of the items there are in this Medication.  For example, 250 mg per tablet.  This is expressed as a ratio where the numerator is 250mg and the denominator is 1 tablet.")
        protected Ratio amount;
        private static final long serialVersionUID = -1796655982L;

        public MedicationIngredientComponent() {
        }

        public MedicationIngredientComponent(Type item) {
            this.item = item;
        }

        public Type getItem() {
            return this.item;
        }

        public CodeableConcept getItemCodeableConcept() throws FHIRException {
            if (this.item == null) {
                return null;
            }
            if (!(this.item instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.item.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.item;
        }

        public boolean hasItemCodeableConcept() {
            return this != null && this.item instanceof CodeableConcept;
        }

        public Reference getItemReference() throws FHIRException {
            if (this.item == null) {
                return null;
            }
            if (!(this.item instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.item.getClass().getName() + " was encountered");
            }
            return (Reference)this.item;
        }

        public boolean hasItemReference() {
            return this != null && this.item instanceof Reference;
        }

        public boolean hasItem() {
            return this.item != null && !this.item.isEmpty();
        }

        public MedicationIngredientComponent setItem(Type value) throws FHIRFormatError {
            if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
                throw new FHIRFormatError("Not the right type for Medication.ingredient.item[x]: " + value.fhirType());
            }
            this.item = value;
            return this;
        }

        public BooleanType getIsActiveElement() {
            if (this.isActive == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationIngredientComponent.isActive");
                }
                if (Configuration.doAutoCreate()) {
                    this.isActive = new BooleanType();
                }
            }
            return this.isActive;
        }

        public boolean hasIsActiveElement() {
            return this.isActive != null && !this.isActive.isEmpty();
        }

        public boolean hasIsActive() {
            return this.isActive != null && !this.isActive.isEmpty();
        }

        public MedicationIngredientComponent setIsActiveElement(BooleanType value) {
            this.isActive = value;
            return this;
        }

        public boolean getIsActive() {
            return this.isActive == null || this.isActive.isEmpty() ? false : (Boolean)this.isActive.getValue();
        }

        public MedicationIngredientComponent setIsActive(boolean value) {
            if (this.isActive == null) {
                this.isActive = new BooleanType();
            }
            this.isActive.setValue((Object)value);
            return this;
        }

        public Ratio getAmount() {
            if (this.amount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationIngredientComponent.amount");
                }
                if (Configuration.doAutoCreate()) {
                    this.amount = new Ratio();
                }
            }
            return this.amount;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public MedicationIngredientComponent setAmount(Ratio value) {
            this.amount = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("item[x]", "CodeableConcept|Reference(Substance|Medication)", "The actual ingredient - either a substance (simple ingredient) or another medication.", 0, 1, this.item));
            children.add(new Property("isActive", "boolean", "Indication of whether this\u00a0ingredient affects\u00a0the therapeutic action of the drug.", 0, 1, this.isActive));
            children.add(new Property("amount", "Ratio", "Specifies how many (or how much) of the items there are in this Medication.  For example, 250 mg per tablet.  This is expressed as a ratio where the numerator is 250mg and the denominator is 1 tablet.", 0, 1, this.amount));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 2116201613: {
                    return new Property("item[x]", "CodeableConcept|Reference(Substance|Medication)", "The actual ingredient - either a substance (simple ingredient) or another medication.", 0, 1, this.item);
                }
                case 3242771: {
                    return new Property("item[x]", "CodeableConcept|Reference(Substance|Medication)", "The actual ingredient - either a substance (simple ingredient) or another medication.", 0, 1, this.item);
                }
                case 106644494: {
                    return new Property("item[x]", "CodeableConcept|Reference(Substance|Medication)", "The actual ingredient - either a substance (simple ingredient) or another medication.", 0, 1, this.item);
                }
                case 1376364920: {
                    return new Property("item[x]", "CodeableConcept|Reference(Substance|Medication)", "The actual ingredient - either a substance (simple ingredient) or another medication.", 0, 1, this.item);
                }
                case -748916528: {
                    return new Property("isActive", "boolean", "Indication of whether this\u00a0ingredient affects\u00a0the therapeutic action of the drug.", 0, 1, this.isActive);
                }
                case -1413853096: {
                    return new Property("amount", "Ratio", "Specifies how many (or how much) of the items there are in this Medication.  For example, 250 mg per tablet.  This is expressed as a ratio where the numerator is 250mg and the denominator is 1 tablet.", 0, 1, this.amount);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    Base[] baseArray;
                    if (this.item == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.item;
                    }
                    return baseArray;
                }
                case -748916528: {
                    Base[] baseArray;
                    if (this.isActive == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.isActive;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.amount;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    this.item = this.castToType(value);
                    return value;
                }
                case -748916528: {
                    this.isActive = this.castToBoolean(value);
                    return value;
                }
                case -1413853096: {
                    this.amount = this.castToRatio(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("item[x]")) {
                this.item = this.castToType(value);
            } else if (name.equals("isActive")) {
                this.isActive = this.castToBoolean(value);
            } else if (name.equals("amount")) {
                this.amount = this.castToRatio(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 2116201613: {
                    return this.getItem();
                }
                case 3242771: {
                    return this.getItem();
                }
                case -748916528: {
                    return this.getIsActiveElement();
                }
                case -1413853096: {
                    return this.getAmount();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3242771: {
                    return new String[]{"CodeableConcept", "Reference"};
                }
                case -748916528: {
                    return new String[]{"boolean"};
                }
                case -1413853096: {
                    return new String[]{"Ratio"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("itemCodeableConcept")) {
                this.item = new CodeableConcept();
                return this.item;
            }
            if (name.equals("itemReference")) {
                this.item = new Reference();
                return this.item;
            }
            if (name.equals("isActive")) {
                throw new FHIRException("Cannot call addChild on a primitive type Medication.isActive");
            }
            if (name.equals("amount")) {
                this.amount = new Ratio();
                return this.amount;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationIngredientComponent copy() {
            MedicationIngredientComponent dst = new MedicationIngredientComponent();
            this.copyValues(dst);
            dst.item = this.item == null ? null : this.item.copy();
            dst.isActive = this.isActive == null ? null : this.isActive.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationIngredientComponent)) {
                return false;
            }
            MedicationIngredientComponent o = (MedicationIngredientComponent)other_;
            return MedicationIngredientComponent.compareDeep(this.item, o.item, true) && MedicationIngredientComponent.compareDeep(this.isActive, o.isActive, true) && MedicationIngredientComponent.compareDeep(this.amount, o.amount, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicationIngredientComponent)) {
                return false;
            }
            MedicationIngredientComponent o = (MedicationIngredientComponent)other_;
            return MedicationIngredientComponent.compareValues(this.isActive, o.isActive, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.item, this.isActive, this.amount});
        }

        @Override
        public String fhirType() {
            return "Medication.ingredient";
        }
    }

    public static class MedicationStatusEnumFactory
    implements EnumFactory<MedicationStatus> {
        @Override
        public MedicationStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return MedicationStatus.ACTIVE;
            }
            if ("inactive".equals(codeString)) {
                return MedicationStatus.INACTIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return MedicationStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown MedicationStatus code '" + codeString + "'");
        }

        public Enumeration<MedicationStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<MedicationStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return new Enumeration<MedicationStatus>(this, MedicationStatus.ACTIVE);
            }
            if ("inactive".equals(codeString)) {
                return new Enumeration<MedicationStatus>(this, MedicationStatus.INACTIVE);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<MedicationStatus>(this, MedicationStatus.ENTEREDINERROR);
            }
            throw new FHIRException("Unknown MedicationStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(MedicationStatus code) {
            if (code == MedicationStatus.ACTIVE) {
                return "active";
            }
            if (code == MedicationStatus.INACTIVE) {
                return "inactive";
            }
            if (code == MedicationStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(MedicationStatus code) {
            return code.getSystem();
        }
    }

    public static enum MedicationStatus {
        ACTIVE,
        INACTIVE,
        ENTEREDINERROR,
        NULL;


        public static MedicationStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("inactive".equals(codeString)) {
                return INACTIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown MedicationStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case INACTIVE: {
                    return "inactive";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/medication-status";
                }
                case INACTIVE: {
                    return "http://hl7.org/fhir/medication-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/medication-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "The medication is available for use";
                }
                case INACTIVE: {
                    return "The medication is not available for use";
                }
                case ENTEREDINERROR: {
                    return "The medication was entered in error";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case INACTIVE: {
                    return "Inactive";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
            }
            return "?";
        }
    }
}

