/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.Device;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.InstantType;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="DeviceComponent", profile="http://hl7.org/fhir/StructureDefinition/DeviceComponent")
public class DeviceComponent
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Instance id assigned by the software stack", formalDefinition="The locally assigned unique identification by the software. For example: handle ID.")
    protected Identifier identifier;
    @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="What kind of component it is", formalDefinition="The component type as defined in the object-oriented or metric nomenclature partition.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/device-kind")
    protected CodeableConcept type;
    @Child(name="lastSystemChange", type={InstantType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Recent system change timestamp", formalDefinition="The timestamp for the most recent system change which includes device configuration or setting change.")
    protected InstantType lastSystemChange;
    @Child(name="source", type={Device.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Top-level device resource link", formalDefinition="The link to the source Device that contains administrative device information such as manufacture, serial number, etc.")
    protected Reference source;
    protected Device sourceTarget;
    @Child(name="parent", type={DeviceComponent.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Parent resource link", formalDefinition="The link to the parent resource. For example: Channel is linked to its VMD parent.")
    protected Reference parent;
    protected DeviceComponent parentTarget;
    @Child(name="operationalStatus", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Current operational status of the component, for example On, Off or Standby", formalDefinition="The current operational status of the device. For example: On, Off, Standby, etc.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/operational-status")
    protected List<CodeableConcept> operationalStatus;
    @Child(name="parameterGroup", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Current supported parameter group", formalDefinition="The parameter group supported by the current device component that is based on some nomenclature, e.g. cardiovascular.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/parameter-group")
    protected CodeableConcept parameterGroup;
    @Child(name="measurementPrinciple", type={CodeType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="other | chemical | electrical | impedance | nuclear | optical | thermal | biological | mechanical | acoustical | manual+", formalDefinition="The physical principle of the measurement. For example: thermal, chemical, acoustical, etc.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/measurement-principle")
    protected Enumeration<MeasmntPrinciple> measurementPrinciple;
    @Child(name="productionSpecification", type={}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Specification details such as Component Revisions, or Serial Numbers", formalDefinition="The production specification such as component revision, serial number, etc.")
    protected List<DeviceComponentProductionSpecificationComponent> productionSpecification;
    @Child(name="languageCode", type={CodeableConcept.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Language code for the human-readable text strings produced by the device", formalDefinition="The language code for the human-readable text string produced by the device. This language code will follow the IETF language tag. Example: en-US.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/languages")
    protected CodeableConcept languageCode;
    private static final long serialVersionUID = 32987426L;
    @SearchParamDefinition(name="parent", path="DeviceComponent.parent", description="The parent DeviceComponent resource", type="reference", target={DeviceComponent.class})
    public static final String SP_PARENT = "parent";
    public static final ReferenceClientParam PARENT = new ReferenceClientParam("parent");
    public static final Include INCLUDE_PARENT = new Include("DeviceComponent:parent").toLocked();
    @SearchParamDefinition(name="identifier", path="DeviceComponent.identifier", description="The identifier of the component", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="source", path="DeviceComponent.source", description="The device source", type="reference", providesMembershipIn={@Compartment(name="Device")}, target={Device.class})
    public static final String SP_SOURCE = "source";
    public static final ReferenceClientParam SOURCE = new ReferenceClientParam("source");
    public static final Include INCLUDE_SOURCE = new Include("DeviceComponent:source").toLocked();
    @SearchParamDefinition(name="type", path="DeviceComponent.type", description="The device component type", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");

    public DeviceComponent() {
    }

    public DeviceComponent(Identifier identifier, CodeableConcept type) {
        this.identifier = identifier;
        this.type = type;
    }

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceComponent.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public DeviceComponent setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceComponent.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public DeviceComponent setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public InstantType getLastSystemChangeElement() {
        if (this.lastSystemChange == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceComponent.lastSystemChange");
            }
            if (Configuration.doAutoCreate()) {
                this.lastSystemChange = new InstantType();
            }
        }
        return this.lastSystemChange;
    }

    public boolean hasLastSystemChangeElement() {
        return this.lastSystemChange != null && !this.lastSystemChange.isEmpty();
    }

    public boolean hasLastSystemChange() {
        return this.lastSystemChange != null && !this.lastSystemChange.isEmpty();
    }

    public DeviceComponent setLastSystemChangeElement(InstantType value) {
        this.lastSystemChange = value;
        return this;
    }

    public Date getLastSystemChange() {
        return this.lastSystemChange == null ? null : (Date)this.lastSystemChange.getValue();
    }

    public DeviceComponent setLastSystemChange(Date value) {
        if (value == null) {
            this.lastSystemChange = null;
        } else {
            if (this.lastSystemChange == null) {
                this.lastSystemChange = new InstantType();
            }
            this.lastSystemChange.setValue(value);
        }
        return this;
    }

    public Reference getSource() {
        if (this.source == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceComponent.source");
            }
            if (Configuration.doAutoCreate()) {
                this.source = new Reference();
            }
        }
        return this.source;
    }

    public boolean hasSource() {
        return this.source != null && !this.source.isEmpty();
    }

    public DeviceComponent setSource(Reference value) {
        this.source = value;
        return this;
    }

    public Device getSourceTarget() {
        if (this.sourceTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceComponent.source");
            }
            if (Configuration.doAutoCreate()) {
                this.sourceTarget = new Device();
            }
        }
        return this.sourceTarget;
    }

    public DeviceComponent setSourceTarget(Device value) {
        this.sourceTarget = value;
        return this;
    }

    public Reference getParent() {
        if (this.parent == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceComponent.parent");
            }
            if (Configuration.doAutoCreate()) {
                this.parent = new Reference();
            }
        }
        return this.parent;
    }

    public boolean hasParent() {
        return this.parent != null && !this.parent.isEmpty();
    }

    public DeviceComponent setParent(Reference value) {
        this.parent = value;
        return this;
    }

    public DeviceComponent getParentTarget() {
        if (this.parentTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceComponent.parent");
            }
            if (Configuration.doAutoCreate()) {
                this.parentTarget = new DeviceComponent();
            }
        }
        return this.parentTarget;
    }

    public DeviceComponent setParentTarget(DeviceComponent value) {
        this.parentTarget = value;
        return this;
    }

    public List<CodeableConcept> getOperationalStatus() {
        if (this.operationalStatus == null) {
            this.operationalStatus = new ArrayList<CodeableConcept>();
        }
        return this.operationalStatus;
    }

    public DeviceComponent setOperationalStatus(List<CodeableConcept> theOperationalStatus) {
        this.operationalStatus = theOperationalStatus;
        return this;
    }

    public boolean hasOperationalStatus() {
        if (this.operationalStatus == null) {
            return false;
        }
        for (CodeableConcept item : this.operationalStatus) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addOperationalStatus() {
        CodeableConcept t = new CodeableConcept();
        if (this.operationalStatus == null) {
            this.operationalStatus = new ArrayList<CodeableConcept>();
        }
        this.operationalStatus.add(t);
        return t;
    }

    public DeviceComponent addOperationalStatus(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.operationalStatus == null) {
            this.operationalStatus = new ArrayList<CodeableConcept>();
        }
        this.operationalStatus.add(t);
        return this;
    }

    public CodeableConcept getOperationalStatusFirstRep() {
        if (this.getOperationalStatus().isEmpty()) {
            this.addOperationalStatus();
        }
        return this.getOperationalStatus().get(0);
    }

    public CodeableConcept getParameterGroup() {
        if (this.parameterGroup == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceComponent.parameterGroup");
            }
            if (Configuration.doAutoCreate()) {
                this.parameterGroup = new CodeableConcept();
            }
        }
        return this.parameterGroup;
    }

    public boolean hasParameterGroup() {
        return this.parameterGroup != null && !this.parameterGroup.isEmpty();
    }

    public DeviceComponent setParameterGroup(CodeableConcept value) {
        this.parameterGroup = value;
        return this;
    }

    public Enumeration<MeasmntPrinciple> getMeasurementPrincipleElement() {
        if (this.measurementPrinciple == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceComponent.measurementPrinciple");
            }
            if (Configuration.doAutoCreate()) {
                this.measurementPrinciple = new Enumeration<MeasmntPrinciple>(new MeasmntPrincipleEnumFactory());
            }
        }
        return this.measurementPrinciple;
    }

    public boolean hasMeasurementPrincipleElement() {
        return this.measurementPrinciple != null && !this.measurementPrinciple.isEmpty();
    }

    public boolean hasMeasurementPrinciple() {
        return this.measurementPrinciple != null && !this.measurementPrinciple.isEmpty();
    }

    public DeviceComponent setMeasurementPrincipleElement(Enumeration<MeasmntPrinciple> value) {
        this.measurementPrinciple = value;
        return this;
    }

    public MeasmntPrinciple getMeasurementPrinciple() {
        return this.measurementPrinciple == null ? null : (MeasmntPrinciple)((Object)this.measurementPrinciple.getValue());
    }

    public DeviceComponent setMeasurementPrinciple(MeasmntPrinciple value) {
        if (value == null) {
            this.measurementPrinciple = null;
        } else {
            if (this.measurementPrinciple == null) {
                this.measurementPrinciple = new Enumeration<MeasmntPrinciple>(new MeasmntPrincipleEnumFactory());
            }
            this.measurementPrinciple.setValue((Object)value);
        }
        return this;
    }

    public List<DeviceComponentProductionSpecificationComponent> getProductionSpecification() {
        if (this.productionSpecification == null) {
            this.productionSpecification = new ArrayList<DeviceComponentProductionSpecificationComponent>();
        }
        return this.productionSpecification;
    }

    public DeviceComponent setProductionSpecification(List<DeviceComponentProductionSpecificationComponent> theProductionSpecification) {
        this.productionSpecification = theProductionSpecification;
        return this;
    }

    public boolean hasProductionSpecification() {
        if (this.productionSpecification == null) {
            return false;
        }
        for (DeviceComponentProductionSpecificationComponent item : this.productionSpecification) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DeviceComponentProductionSpecificationComponent addProductionSpecification() {
        DeviceComponentProductionSpecificationComponent t = new DeviceComponentProductionSpecificationComponent();
        if (this.productionSpecification == null) {
            this.productionSpecification = new ArrayList<DeviceComponentProductionSpecificationComponent>();
        }
        this.productionSpecification.add(t);
        return t;
    }

    public DeviceComponent addProductionSpecification(DeviceComponentProductionSpecificationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.productionSpecification == null) {
            this.productionSpecification = new ArrayList<DeviceComponentProductionSpecificationComponent>();
        }
        this.productionSpecification.add(t);
        return this;
    }

    public DeviceComponentProductionSpecificationComponent getProductionSpecificationFirstRep() {
        if (this.getProductionSpecification().isEmpty()) {
            this.addProductionSpecification();
        }
        return this.getProductionSpecification().get(0);
    }

    public CodeableConcept getLanguageCode() {
        if (this.languageCode == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceComponent.languageCode");
            }
            if (Configuration.doAutoCreate()) {
                this.languageCode = new CodeableConcept();
            }
        }
        return this.languageCode;
    }

    public boolean hasLanguageCode() {
        return this.languageCode != null && !this.languageCode.isEmpty();
    }

    public DeviceComponent setLanguageCode(CodeableConcept value) {
        this.languageCode = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "The locally assigned unique identification by the software. For example: handle ID.", 0, 1, this.identifier));
        children.add(new Property(SP_TYPE, "CodeableConcept", "The component type as defined in the object-oriented or metric nomenclature partition.", 0, 1, this.type));
        children.add(new Property("lastSystemChange", "instant", "The timestamp for the most recent system change which includes device configuration or setting change.", 0, 1, this.lastSystemChange));
        children.add(new Property(SP_SOURCE, "Reference(Device)", "The link to the source Device that contains administrative device information such as manufacture, serial number, etc.", 0, 1, this.source));
        children.add(new Property(SP_PARENT, "Reference(DeviceComponent)", "The link to the parent resource. For example: Channel is linked to its VMD parent.", 0, 1, this.parent));
        children.add(new Property("operationalStatus", "CodeableConcept", "The current operational status of the device. For example: On, Off, Standby, etc.", 0, Integer.MAX_VALUE, this.operationalStatus));
        children.add(new Property("parameterGroup", "CodeableConcept", "The parameter group supported by the current device component that is based on some nomenclature, e.g. cardiovascular.", 0, 1, this.parameterGroup));
        children.add(new Property("measurementPrinciple", "code", "The physical principle of the measurement. For example: thermal, chemical, acoustical, etc.", 0, 1, this.measurementPrinciple));
        children.add(new Property("productionSpecification", "", "The production specification such as component revision, serial number, etc.", 0, Integer.MAX_VALUE, this.productionSpecification));
        children.add(new Property("languageCode", "CodeableConcept", "The language code for the human-readable text string produced by the device. This language code will follow the IETF language tag. Example: en-US.", 0, 1, this.languageCode));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "The locally assigned unique identification by the software. For example: handle ID.", 0, 1, this.identifier);
            }
            case 3575610: {
                return new Property(SP_TYPE, "CodeableConcept", "The component type as defined in the object-oriented or metric nomenclature partition.", 0, 1, this.type);
            }
            case -2072475531: {
                return new Property("lastSystemChange", "instant", "The timestamp for the most recent system change which includes device configuration or setting change.", 0, 1, this.lastSystemChange);
            }
            case -896505829: {
                return new Property(SP_SOURCE, "Reference(Device)", "The link to the source Device that contains administrative device information such as manufacture, serial number, etc.", 0, 1, this.source);
            }
            case -995424086: {
                return new Property(SP_PARENT, "Reference(DeviceComponent)", "The link to the parent resource. For example: Channel is linked to its VMD parent.", 0, 1, this.parent);
            }
            case -2103166364: {
                return new Property("operationalStatus", "CodeableConcept", "The current operational status of the device. For example: On, Off, Standby, etc.", 0, Integer.MAX_VALUE, this.operationalStatus);
            }
            case 1111110742: {
                return new Property("parameterGroup", "CodeableConcept", "The parameter group supported by the current device component that is based on some nomenclature, e.g. cardiovascular.", 0, 1, this.parameterGroup);
            }
            case 24324384: {
                return new Property("measurementPrinciple", "code", "The physical principle of the measurement. For example: thermal, chemical, acoustical, etc.", 0, 1, this.measurementPrinciple);
            }
            case -455527222: {
                return new Property("productionSpecification", "", "The production specification such as component revision, serial number, etc.", 0, Integer.MAX_VALUE, this.productionSpecification);
            }
            case -2092349083: {
                return new Property("languageCode", "CodeableConcept", "The language code for the human-readable text string produced by the device. This language code will follow the IETF language tag. Example: en-US.", 0, 1, this.languageCode);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.identifier;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.type;
                }
                return baseArray;
            }
            case -2072475531: {
                Base[] baseArray;
                if (this.lastSystemChange == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.lastSystemChange;
                }
                return baseArray;
            }
            case -896505829: {
                Base[] baseArray;
                if (this.source == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.source;
                }
                return baseArray;
            }
            case -995424086: {
                Base[] baseArray;
                if (this.parent == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.parent;
                }
                return baseArray;
            }
            case -2103166364: {
                return this.operationalStatus == null ? new Base[]{} : this.operationalStatus.toArray(new Base[this.operationalStatus.size()]);
            }
            case 1111110742: {
                Base[] baseArray;
                if (this.parameterGroup == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.parameterGroup;
                }
                return baseArray;
            }
            case 24324384: {
                Base[] baseArray;
                if (this.measurementPrinciple == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.measurementPrinciple;
                }
                return baseArray;
            }
            case -455527222: {
                return this.productionSpecification == null ? new Base[]{} : this.productionSpecification.toArray(new Base[this.productionSpecification.size()]);
            }
            case -2092349083: {
                Base[] baseArray;
                if (this.languageCode == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.languageCode;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.identifier = this.castToIdentifier(value);
                return value;
            }
            case 3575610: {
                this.type = this.castToCodeableConcept(value);
                return value;
            }
            case -2072475531: {
                this.lastSystemChange = this.castToInstant(value);
                return value;
            }
            case -896505829: {
                this.source = this.castToReference(value);
                return value;
            }
            case -995424086: {
                this.parent = this.castToReference(value);
                return value;
            }
            case -2103166364: {
                this.getOperationalStatus().add(this.castToCodeableConcept(value));
                return value;
            }
            case 1111110742: {
                this.parameterGroup = this.castToCodeableConcept(value);
                return value;
            }
            case 24324384: {
                value = new MeasmntPrincipleEnumFactory().fromType(this.castToCode(value));
                this.measurementPrinciple = value;
                return value;
            }
            case -455527222: {
                this.getProductionSpecification().add((DeviceComponentProductionSpecificationComponent)((Object)value));
                return value;
            }
            case -2092349083: {
                this.languageCode = this.castToCodeableConcept(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = this.castToIdentifier(value);
        } else if (name.equals(SP_TYPE)) {
            this.type = this.castToCodeableConcept(value);
        } else if (name.equals("lastSystemChange")) {
            this.lastSystemChange = this.castToInstant(value);
        } else if (name.equals(SP_SOURCE)) {
            this.source = this.castToReference(value);
        } else if (name.equals(SP_PARENT)) {
            this.parent = this.castToReference(value);
        } else if (name.equals("operationalStatus")) {
            this.getOperationalStatus().add(this.castToCodeableConcept(value));
        } else if (name.equals("parameterGroup")) {
            this.parameterGroup = this.castToCodeableConcept(value);
        } else if (name.equals("measurementPrinciple")) {
            value = new MeasmntPrincipleEnumFactory().fromType(this.castToCode(value));
            this.measurementPrinciple = value;
        } else if (name.equals("productionSpecification")) {
            this.getProductionSpecification().add((DeviceComponentProductionSpecificationComponent)((Object)value));
        } else if (name.equals("languageCode")) {
            this.languageCode = this.castToCodeableConcept(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.getIdentifier();
            }
            case 3575610: {
                return this.getType();
            }
            case -2072475531: {
                return this.getLastSystemChangeElement();
            }
            case -896505829: {
                return this.getSource();
            }
            case -995424086: {
                return this.getParent();
            }
            case -2103166364: {
                return this.addOperationalStatus();
            }
            case 1111110742: {
                return this.getParameterGroup();
            }
            case 24324384: {
                return this.getMeasurementPrincipleElement();
            }
            case -455527222: {
                return this.addProductionSpecification();
            }
            case -2092349083: {
                return this.getLanguageCode();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case -2072475531: {
                return new String[]{"instant"};
            }
            case -896505829: {
                return new String[]{"Reference"};
            }
            case -995424086: {
                return new String[]{"Reference"};
            }
            case -2103166364: {
                return new String[]{"CodeableConcept"};
            }
            case 1111110742: {
                return new String[]{"CodeableConcept"};
            }
            case 24324384: {
                return new String[]{"code"};
            }
            case -455527222: {
                return new String[0];
            }
            case -2092349083: {
                return new String[]{"CodeableConcept"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals(SP_TYPE)) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals("lastSystemChange")) {
            throw new FHIRException("Cannot call addChild on a primitive type DeviceComponent.lastSystemChange");
        }
        if (name.equals(SP_SOURCE)) {
            this.source = new Reference();
            return this.source;
        }
        if (name.equals(SP_PARENT)) {
            this.parent = new Reference();
            return this.parent;
        }
        if (name.equals("operationalStatus")) {
            return this.addOperationalStatus();
        }
        if (name.equals("parameterGroup")) {
            this.parameterGroup = new CodeableConcept();
            return this.parameterGroup;
        }
        if (name.equals("measurementPrinciple")) {
            throw new FHIRException("Cannot call addChild on a primitive type DeviceComponent.measurementPrinciple");
        }
        if (name.equals("productionSpecification")) {
            return this.addProductionSpecification();
        }
        if (name.equals("languageCode")) {
            this.languageCode = new CodeableConcept();
            return this.languageCode;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DeviceComponent";
    }

    @Override
    public DeviceComponent copy() {
        DeviceComponent dst = new DeviceComponent();
        this.copyValues(dst);
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.lastSystemChange = this.lastSystemChange == null ? null : this.lastSystemChange.copy();
        dst.source = this.source == null ? null : this.source.copy();
        Reference reference = dst.parent = this.parent == null ? null : this.parent.copy();
        if (this.operationalStatus != null) {
            dst.operationalStatus = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.operationalStatus) {
                dst.operationalStatus.add(codeableConcept.copy());
            }
        }
        dst.parameterGroup = this.parameterGroup == null ? null : this.parameterGroup.copy();
        Enumeration<MeasmntPrinciple> enumeration = dst.measurementPrinciple = this.measurementPrinciple == null ? null : this.measurementPrinciple.copy();
        if (this.productionSpecification != null) {
            dst.productionSpecification = new ArrayList<DeviceComponentProductionSpecificationComponent>();
            for (DeviceComponentProductionSpecificationComponent deviceComponentProductionSpecificationComponent : this.productionSpecification) {
                dst.productionSpecification.add(deviceComponentProductionSpecificationComponent.copy());
            }
        }
        dst.languageCode = this.languageCode == null ? null : this.languageCode.copy();
        return dst;
    }

    protected DeviceComponent typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof DeviceComponent)) {
            return false;
        }
        DeviceComponent o = (DeviceComponent)other_;
        return DeviceComponent.compareDeep(this.identifier, o.identifier, true) && DeviceComponent.compareDeep(this.type, o.type, true) && DeviceComponent.compareDeep(this.lastSystemChange, o.lastSystemChange, true) && DeviceComponent.compareDeep(this.source, o.source, true) && DeviceComponent.compareDeep(this.parent, o.parent, true) && DeviceComponent.compareDeep(this.operationalStatus, o.operationalStatus, true) && DeviceComponent.compareDeep(this.parameterGroup, o.parameterGroup, true) && DeviceComponent.compareDeep(this.measurementPrinciple, o.measurementPrinciple, true) && DeviceComponent.compareDeep(this.productionSpecification, o.productionSpecification, true) && DeviceComponent.compareDeep(this.languageCode, o.languageCode, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof DeviceComponent)) {
            return false;
        }
        DeviceComponent o = (DeviceComponent)other_;
        return DeviceComponent.compareValues(this.lastSystemChange, o.lastSystemChange, true) && DeviceComponent.compareValues(this.measurementPrinciple, o.measurementPrinciple, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.type, this.lastSystemChange, this.source, this.parent, this.operationalStatus, this.parameterGroup, this.measurementPrinciple, this.productionSpecification, this.languageCode});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.DeviceComponent;
    }

    @Block
    public static class DeviceComponentProductionSpecificationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="specType", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type or kind of production specification, for example serial number or software revision", formalDefinition="The specification type, such as, serial number, part number, hardware revision, software revision, etc.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/specification-type")
        protected CodeableConcept specType;
        @Child(name="componentId", type={Identifier.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Internal component unique identification", formalDefinition="The internal component unique identification. This is a provision for manufacture specific standard components using a private OID. 11073-10101 has a partition for private OID semantic that the manufacturer can make use of.")
        protected Identifier componentId;
        @Child(name="productionSpec", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A printable string defining the component", formalDefinition="The printable string defining the component.")
        protected StringType productionSpec;
        private static final long serialVersionUID = -1476597516L;

        public CodeableConcept getSpecType() {
            if (this.specType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceComponentProductionSpecificationComponent.specType");
                }
                if (Configuration.doAutoCreate()) {
                    this.specType = new CodeableConcept();
                }
            }
            return this.specType;
        }

        public boolean hasSpecType() {
            return this.specType != null && !this.specType.isEmpty();
        }

        public DeviceComponentProductionSpecificationComponent setSpecType(CodeableConcept value) {
            this.specType = value;
            return this;
        }

        public Identifier getComponentId() {
            if (this.componentId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceComponentProductionSpecificationComponent.componentId");
                }
                if (Configuration.doAutoCreate()) {
                    this.componentId = new Identifier();
                }
            }
            return this.componentId;
        }

        public boolean hasComponentId() {
            return this.componentId != null && !this.componentId.isEmpty();
        }

        public DeviceComponentProductionSpecificationComponent setComponentId(Identifier value) {
            this.componentId = value;
            return this;
        }

        public StringType getProductionSpecElement() {
            if (this.productionSpec == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceComponentProductionSpecificationComponent.productionSpec");
                }
                if (Configuration.doAutoCreate()) {
                    this.productionSpec = new StringType();
                }
            }
            return this.productionSpec;
        }

        public boolean hasProductionSpecElement() {
            return this.productionSpec != null && !this.productionSpec.isEmpty();
        }

        public boolean hasProductionSpec() {
            return this.productionSpec != null && !this.productionSpec.isEmpty();
        }

        public DeviceComponentProductionSpecificationComponent setProductionSpecElement(StringType value) {
            this.productionSpec = value;
            return this;
        }

        public String getProductionSpec() {
            return this.productionSpec == null ? null : (String)this.productionSpec.getValue();
        }

        public DeviceComponentProductionSpecificationComponent setProductionSpec(String value) {
            if (Utilities.noString((String)value)) {
                this.productionSpec = null;
            } else {
                if (this.productionSpec == null) {
                    this.productionSpec = new StringType();
                }
                this.productionSpec.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("specType", "CodeableConcept", "The specification type, such as, serial number, part number, hardware revision, software revision, etc.", 0, 1, this.specType));
            children.add(new Property("componentId", "Identifier", "The internal component unique identification. This is a provision for manufacture specific standard components using a private OID. 11073-10101 has a partition for private OID semantic that the manufacturer can make use of.", 0, 1, this.componentId));
            children.add(new Property("productionSpec", "string", "The printable string defining the component.", 0, 1, this.productionSpec));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -2133482091: {
                    return new Property("specType", "CodeableConcept", "The specification type, such as, serial number, part number, hardware revision, software revision, etc.", 0, 1, this.specType);
                }
                case -985933064: {
                    return new Property("componentId", "Identifier", "The internal component unique identification. This is a provision for manufacture specific standard components using a private OID. 11073-10101 has a partition for private OID semantic that the manufacturer can make use of.", 0, 1, this.componentId);
                }
                case 182147092: {
                    return new Property("productionSpec", "string", "The printable string defining the component.", 0, 1, this.productionSpec);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -2133482091: {
                    Base[] baseArray;
                    if (this.specType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.specType;
                    }
                    return baseArray;
                }
                case -985933064: {
                    Base[] baseArray;
                    if (this.componentId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.componentId;
                    }
                    return baseArray;
                }
                case 182147092: {
                    Base[] baseArray;
                    if (this.productionSpec == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.productionSpec;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -2133482091: {
                    this.specType = this.castToCodeableConcept(value);
                    return value;
                }
                case -985933064: {
                    this.componentId = this.castToIdentifier(value);
                    return value;
                }
                case 182147092: {
                    this.productionSpec = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("specType")) {
                this.specType = this.castToCodeableConcept(value);
            } else if (name.equals("componentId")) {
                this.componentId = this.castToIdentifier(value);
            } else if (name.equals("productionSpec")) {
                this.productionSpec = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -2133482091: {
                    return this.getSpecType();
                }
                case -985933064: {
                    return this.getComponentId();
                }
                case 182147092: {
                    return this.getProductionSpecElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -2133482091: {
                    return new String[]{"CodeableConcept"};
                }
                case -985933064: {
                    return new String[]{"Identifier"};
                }
                case 182147092: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("specType")) {
                this.specType = new CodeableConcept();
                return this.specType;
            }
            if (name.equals("componentId")) {
                this.componentId = new Identifier();
                return this.componentId;
            }
            if (name.equals("productionSpec")) {
                throw new FHIRException("Cannot call addChild on a primitive type DeviceComponent.productionSpec");
            }
            return super.addChild(name);
        }

        @Override
        public DeviceComponentProductionSpecificationComponent copy() {
            DeviceComponentProductionSpecificationComponent dst = new DeviceComponentProductionSpecificationComponent();
            this.copyValues(dst);
            dst.specType = this.specType == null ? null : this.specType.copy();
            dst.componentId = this.componentId == null ? null : this.componentId.copy();
            dst.productionSpec = this.productionSpec == null ? null : this.productionSpec.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceComponentProductionSpecificationComponent)) {
                return false;
            }
            DeviceComponentProductionSpecificationComponent o = (DeviceComponentProductionSpecificationComponent)other_;
            return DeviceComponentProductionSpecificationComponent.compareDeep(this.specType, o.specType, true) && DeviceComponentProductionSpecificationComponent.compareDeep(this.componentId, o.componentId, true) && DeviceComponentProductionSpecificationComponent.compareDeep(this.productionSpec, o.productionSpec, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceComponentProductionSpecificationComponent)) {
                return false;
            }
            DeviceComponentProductionSpecificationComponent o = (DeviceComponentProductionSpecificationComponent)other_;
            return DeviceComponentProductionSpecificationComponent.compareValues(this.productionSpec, o.productionSpec, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.specType, this.componentId, this.productionSpec});
        }

        @Override
        public String fhirType() {
            return "DeviceComponent.productionSpecification";
        }
    }

    public static class MeasmntPrincipleEnumFactory
    implements EnumFactory<MeasmntPrinciple> {
        @Override
        public MeasmntPrinciple fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("other".equals(codeString)) {
                return MeasmntPrinciple.OTHER;
            }
            if ("chemical".equals(codeString)) {
                return MeasmntPrinciple.CHEMICAL;
            }
            if ("electrical".equals(codeString)) {
                return MeasmntPrinciple.ELECTRICAL;
            }
            if ("impedance".equals(codeString)) {
                return MeasmntPrinciple.IMPEDANCE;
            }
            if ("nuclear".equals(codeString)) {
                return MeasmntPrinciple.NUCLEAR;
            }
            if ("optical".equals(codeString)) {
                return MeasmntPrinciple.OPTICAL;
            }
            if ("thermal".equals(codeString)) {
                return MeasmntPrinciple.THERMAL;
            }
            if ("biological".equals(codeString)) {
                return MeasmntPrinciple.BIOLOGICAL;
            }
            if ("mechanical".equals(codeString)) {
                return MeasmntPrinciple.MECHANICAL;
            }
            if ("acoustical".equals(codeString)) {
                return MeasmntPrinciple.ACOUSTICAL;
            }
            if ("manual".equals(codeString)) {
                return MeasmntPrinciple.MANUAL;
            }
            throw new IllegalArgumentException("Unknown MeasmntPrinciple code '" + codeString + "'");
        }

        public Enumeration<MeasmntPrinciple> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<MeasmntPrinciple>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("other".equals(codeString)) {
                return new Enumeration<MeasmntPrinciple>(this, MeasmntPrinciple.OTHER);
            }
            if ("chemical".equals(codeString)) {
                return new Enumeration<MeasmntPrinciple>(this, MeasmntPrinciple.CHEMICAL);
            }
            if ("electrical".equals(codeString)) {
                return new Enumeration<MeasmntPrinciple>(this, MeasmntPrinciple.ELECTRICAL);
            }
            if ("impedance".equals(codeString)) {
                return new Enumeration<MeasmntPrinciple>(this, MeasmntPrinciple.IMPEDANCE);
            }
            if ("nuclear".equals(codeString)) {
                return new Enumeration<MeasmntPrinciple>(this, MeasmntPrinciple.NUCLEAR);
            }
            if ("optical".equals(codeString)) {
                return new Enumeration<MeasmntPrinciple>(this, MeasmntPrinciple.OPTICAL);
            }
            if ("thermal".equals(codeString)) {
                return new Enumeration<MeasmntPrinciple>(this, MeasmntPrinciple.THERMAL);
            }
            if ("biological".equals(codeString)) {
                return new Enumeration<MeasmntPrinciple>(this, MeasmntPrinciple.BIOLOGICAL);
            }
            if ("mechanical".equals(codeString)) {
                return new Enumeration<MeasmntPrinciple>(this, MeasmntPrinciple.MECHANICAL);
            }
            if ("acoustical".equals(codeString)) {
                return new Enumeration<MeasmntPrinciple>(this, MeasmntPrinciple.ACOUSTICAL);
            }
            if ("manual".equals(codeString)) {
                return new Enumeration<MeasmntPrinciple>(this, MeasmntPrinciple.MANUAL);
            }
            throw new FHIRException("Unknown MeasmntPrinciple code '" + codeString + "'");
        }

        @Override
        public String toCode(MeasmntPrinciple code) {
            if (code == MeasmntPrinciple.OTHER) {
                return "other";
            }
            if (code == MeasmntPrinciple.CHEMICAL) {
                return "chemical";
            }
            if (code == MeasmntPrinciple.ELECTRICAL) {
                return "electrical";
            }
            if (code == MeasmntPrinciple.IMPEDANCE) {
                return "impedance";
            }
            if (code == MeasmntPrinciple.NUCLEAR) {
                return "nuclear";
            }
            if (code == MeasmntPrinciple.OPTICAL) {
                return "optical";
            }
            if (code == MeasmntPrinciple.THERMAL) {
                return "thermal";
            }
            if (code == MeasmntPrinciple.BIOLOGICAL) {
                return "biological";
            }
            if (code == MeasmntPrinciple.MECHANICAL) {
                return "mechanical";
            }
            if (code == MeasmntPrinciple.ACOUSTICAL) {
                return "acoustical";
            }
            if (code == MeasmntPrinciple.MANUAL) {
                return "manual";
            }
            return "?";
        }

        @Override
        public String toSystem(MeasmntPrinciple code) {
            return code.getSystem();
        }
    }

    public static enum MeasmntPrinciple {
        OTHER,
        CHEMICAL,
        ELECTRICAL,
        IMPEDANCE,
        NUCLEAR,
        OPTICAL,
        THERMAL,
        BIOLOGICAL,
        MECHANICAL,
        ACOUSTICAL,
        MANUAL,
        NULL;


        public static MeasmntPrinciple fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("other".equals(codeString)) {
                return OTHER;
            }
            if ("chemical".equals(codeString)) {
                return CHEMICAL;
            }
            if ("electrical".equals(codeString)) {
                return ELECTRICAL;
            }
            if ("impedance".equals(codeString)) {
                return IMPEDANCE;
            }
            if ("nuclear".equals(codeString)) {
                return NUCLEAR;
            }
            if ("optical".equals(codeString)) {
                return OPTICAL;
            }
            if ("thermal".equals(codeString)) {
                return THERMAL;
            }
            if ("biological".equals(codeString)) {
                return BIOLOGICAL;
            }
            if ("mechanical".equals(codeString)) {
                return MECHANICAL;
            }
            if ("acoustical".equals(codeString)) {
                return ACOUSTICAL;
            }
            if ("manual".equals(codeString)) {
                return MANUAL;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown MeasmntPrinciple code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case OTHER: {
                    return "other";
                }
                case CHEMICAL: {
                    return "chemical";
                }
                case ELECTRICAL: {
                    return "electrical";
                }
                case IMPEDANCE: {
                    return "impedance";
                }
                case NUCLEAR: {
                    return "nuclear";
                }
                case OPTICAL: {
                    return "optical";
                }
                case THERMAL: {
                    return "thermal";
                }
                case BIOLOGICAL: {
                    return "biological";
                }
                case MECHANICAL: {
                    return "mechanical";
                }
                case ACOUSTICAL: {
                    return "acoustical";
                }
                case MANUAL: {
                    return "manual";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case OTHER: {
                    return "http://hl7.org/fhir/measurement-principle";
                }
                case CHEMICAL: {
                    return "http://hl7.org/fhir/measurement-principle";
                }
                case ELECTRICAL: {
                    return "http://hl7.org/fhir/measurement-principle";
                }
                case IMPEDANCE: {
                    return "http://hl7.org/fhir/measurement-principle";
                }
                case NUCLEAR: {
                    return "http://hl7.org/fhir/measurement-principle";
                }
                case OPTICAL: {
                    return "http://hl7.org/fhir/measurement-principle";
                }
                case THERMAL: {
                    return "http://hl7.org/fhir/measurement-principle";
                }
                case BIOLOGICAL: {
                    return "http://hl7.org/fhir/measurement-principle";
                }
                case MECHANICAL: {
                    return "http://hl7.org/fhir/measurement-principle";
                }
                case ACOUSTICAL: {
                    return "http://hl7.org/fhir/measurement-principle";
                }
                case MANUAL: {
                    return "http://hl7.org/fhir/measurement-principle";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case OTHER: {
                    return "Measurement principle isn't in the list.";
                }
                case CHEMICAL: {
                    return "Measurement is done using the chemical principle.";
                }
                case ELECTRICAL: {
                    return "Measurement is done using the electrical principle.";
                }
                case IMPEDANCE: {
                    return "Measurement is done using the impedance principle.";
                }
                case NUCLEAR: {
                    return "Measurement is done using the nuclear principle.";
                }
                case OPTICAL: {
                    return "Measurement is done using the optical principle.";
                }
                case THERMAL: {
                    return "Measurement is done using the thermal principle.";
                }
                case BIOLOGICAL: {
                    return "Measurement is done using the biological principle.";
                }
                case MECHANICAL: {
                    return "Measurement is done using the mechanical principle.";
                }
                case ACOUSTICAL: {
                    return "Measurement is done using the acoustical principle.";
                }
                case MANUAL: {
                    return "Measurement is done using the manual principle.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case OTHER: {
                    return "MSP Other";
                }
                case CHEMICAL: {
                    return "MSP Chemical";
                }
                case ELECTRICAL: {
                    return "MSP Electrical";
                }
                case IMPEDANCE: {
                    return "MSP Impedance";
                }
                case NUCLEAR: {
                    return "MSP Nuclear";
                }
                case OPTICAL: {
                    return "MSP Optical";
                }
                case THERMAL: {
                    return "MSP Thermal";
                }
                case BIOLOGICAL: {
                    return "MSP Biological";
                }
                case MECHANICAL: {
                    return "MSP Mechanical";
                }
                case ACOUSTICAL: {
                    return "MSP Acoustical";
                }
                case MANUAL: {
                    return "MSP Manual";
                }
            }
            return "?";
        }
    }
}

