/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu3.model.Annotation;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.Base64BinaryType;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.ContactPoint;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Location;
import org.hl7.fhir.dstu3.model.Organization;
import org.hl7.fhir.dstu3.model.Patient;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Device", profile="http://hl7.org/fhir/StructureDefinition/Device")
public class Device
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Instance identifier", formalDefinition="Unique instance identifiers assigned to a device by manufacturers other organizations or owners.")
    protected List<Identifier> identifier;
    @Child(name="udi", type={}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Unique Device Identifier (UDI) Barcode string", formalDefinition="[Unique device identifier (UDI)](device.html#5.11.3.2.2) assigned to device label or package.")
    protected DeviceUdiComponent udi;
    @Child(name="status", type={CodeType.class}, order=2, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | inactive | entered-in-error | unknown", formalDefinition="Status of the Device availability.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/device-status")
    protected Enumeration<FHIRDeviceStatus> status;
    @Child(name="type", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="What kind of device this is", formalDefinition="Code or identifier to identify a kind of device.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/device-kind")
    protected CodeableConcept type;
    @Child(name="lotNumber", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Lot number of manufacture", formalDefinition="Lot number assigned by the manufacturer.")
    protected StringType lotNumber;
    @Child(name="manufacturer", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Name of device manufacturer", formalDefinition="A name of the manufacturer.")
    protected StringType manufacturer;
    @Child(name="manufactureDate", type={DateTimeType.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Date when the device was made", formalDefinition="The date and time when the device was manufactured.")
    protected DateTimeType manufactureDate;
    @Child(name="expirationDate", type={DateTimeType.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Date and time of expiry of this device (if applicable)", formalDefinition="The date and time beyond which this device is no longer valid or should not be used (if applicable).")
    protected DateTimeType expirationDate;
    @Child(name="model", type={StringType.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Model id assigned by the manufacturer", formalDefinition="The \"model\" is an identifier assigned by the manufacturer to identify the product by its type. This number is shared by the all devices sold as the same type.")
    protected StringType model;
    @Child(name="version", type={StringType.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Version number (i.e. software)", formalDefinition="The version of the device, if the device has multiple releases under the same model, or if the device is software or carries firmware.")
    protected StringType version;
    @Child(name="patient", type={Patient.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Patient to whom Device is affixed", formalDefinition="Patient information, If the device is affixed to a person.")
    protected Reference patient;
    protected Patient patientTarget;
    @Child(name="owner", type={Organization.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Organization responsible for device", formalDefinition="An organization that is responsible for the provision and ongoing maintenance of the device.")
    protected Reference owner;
    protected Organization ownerTarget;
    @Child(name="contact", type={ContactPoint.class}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Details for human/organization for support", formalDefinition="Contact details for an organization or a particular human that is responsible for the device.")
    protected List<ContactPoint> contact;
    @Child(name="location", type={Location.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Where the resource is found", formalDefinition="The place where the device can be found.")
    protected Reference location;
    protected Location locationTarget;
    @Child(name="url", type={UriType.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Network address to contact device", formalDefinition="A network address on which the device may be contacted directly.")
    protected UriType url;
    @Child(name="note", type={Annotation.class}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Device notes and comments", formalDefinition="Descriptive information, usage information or implantation information that is not captured in an existing element.")
    protected List<Annotation> note;
    @Child(name="safety", type={CodeableConcept.class}, order=16, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Safety Characteristics of Device", formalDefinition="Provides additional safety characteristics about a medical device.  For example devices containing latex.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/device-safety")
    protected List<CodeableConcept> safety;
    private static final long serialVersionUID = -1056263930L;
    @SearchParamDefinition(name="udi-di", path="Device.udi.deviceIdentifier", description="The udi Device Identifier (DI)", type="string")
    public static final String SP_UDI_DI = "udi-di";
    public static final StringClientParam UDI_DI = new StringClientParam("udi-di");
    @SearchParamDefinition(name="identifier", path="Device.identifier", description="Instance id from manufacturer, owner, and others", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="udi-carrier", path="Device.udi.carrierHRF | Device.udi.carrierAIDC", description="UDI Barcode (RFID or other technology) string either in HRF format or AIDC format converted to base64 string.", type="string")
    public static final String SP_UDI_CARRIER = "udi-carrier";
    public static final StringClientParam UDI_CARRIER = new StringClientParam("udi-carrier");
    @SearchParamDefinition(name="device-name", path="Device.udi.name | Device.type.text | Device.type.coding.display", description="A server defined search that may match any of the string fields in the Device.udi.name  or Device.type.coding.display or  Device.type.text", type="string")
    public static final String SP_DEVICE_NAME = "device-name";
    public static final StringClientParam DEVICE_NAME = new StringClientParam("device-name");
    @SearchParamDefinition(name="patient", path="Device.patient", description="Patient information, if the resource is affixed to a person", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Device:patient").toLocked();
    @SearchParamDefinition(name="organization", path="Device.owner", description="The organization responsible for the device", type="reference", target={Organization.class})
    public static final String SP_ORGANIZATION = "organization";
    public static final ReferenceClientParam ORGANIZATION = new ReferenceClientParam("organization");
    public static final Include INCLUDE_ORGANIZATION = new Include("Device:organization").toLocked();
    @SearchParamDefinition(name="model", path="Device.model", description="The model of the device", type="string")
    public static final String SP_MODEL = "model";
    public static final StringClientParam MODEL = new StringClientParam("model");
    @SearchParamDefinition(name="location", path="Device.location", description="A location, where the resource is found", type="reference", target={Location.class})
    public static final String SP_LOCATION = "location";
    public static final ReferenceClientParam LOCATION = new ReferenceClientParam("location");
    public static final Include INCLUDE_LOCATION = new Include("Device:location").toLocked();
    @SearchParamDefinition(name="type", path="Device.type", description="The type of the device", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="url", path="Device.url", description="Network address to contact device", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="manufacturer", path="Device.manufacturer", description="The manufacturer of the device", type="string")
    public static final String SP_MANUFACTURER = "manufacturer";
    public static final StringClientParam MANUFACTURER = new StringClientParam("manufacturer");
    @SearchParamDefinition(name="status", path="Device.status", description="active | inactive | entered-in-error | unknown", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Device setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Device addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public DeviceUdiComponent getUdi() {
        if (this.udi == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.udi");
            }
            if (Configuration.doAutoCreate()) {
                this.udi = new DeviceUdiComponent();
            }
        }
        return this.udi;
    }

    public boolean hasUdi() {
        return this.udi != null && !this.udi.isEmpty();
    }

    public Device setUdi(DeviceUdiComponent value) {
        this.udi = value;
        return this;
    }

    public Enumeration<FHIRDeviceStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<FHIRDeviceStatus>(new FHIRDeviceStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Device setStatusElement(Enumeration<FHIRDeviceStatus> value) {
        this.status = value;
        return this;
    }

    public FHIRDeviceStatus getStatus() {
        return this.status == null ? null : (FHIRDeviceStatus)((Object)this.status.getValue());
    }

    public Device setStatus(FHIRDeviceStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<FHIRDeviceStatus>(new FHIRDeviceStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public Device setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public StringType getLotNumberElement() {
        if (this.lotNumber == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.lotNumber");
            }
            if (Configuration.doAutoCreate()) {
                this.lotNumber = new StringType();
            }
        }
        return this.lotNumber;
    }

    public boolean hasLotNumberElement() {
        return this.lotNumber != null && !this.lotNumber.isEmpty();
    }

    public boolean hasLotNumber() {
        return this.lotNumber != null && !this.lotNumber.isEmpty();
    }

    public Device setLotNumberElement(StringType value) {
        this.lotNumber = value;
        return this;
    }

    public String getLotNumber() {
        return this.lotNumber == null ? null : (String)this.lotNumber.getValue();
    }

    public Device setLotNumber(String value) {
        if (Utilities.noString((String)value)) {
            this.lotNumber = null;
        } else {
            if (this.lotNumber == null) {
                this.lotNumber = new StringType();
            }
            this.lotNumber.setValue(value);
        }
        return this;
    }

    public StringType getManufacturerElement() {
        if (this.manufacturer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.manufacturer");
            }
            if (Configuration.doAutoCreate()) {
                this.manufacturer = new StringType();
            }
        }
        return this.manufacturer;
    }

    public boolean hasManufacturerElement() {
        return this.manufacturer != null && !this.manufacturer.isEmpty();
    }

    public boolean hasManufacturer() {
        return this.manufacturer != null && !this.manufacturer.isEmpty();
    }

    public Device setManufacturerElement(StringType value) {
        this.manufacturer = value;
        return this;
    }

    public String getManufacturer() {
        return this.manufacturer == null ? null : (String)this.manufacturer.getValue();
    }

    public Device setManufacturer(String value) {
        if (Utilities.noString((String)value)) {
            this.manufacturer = null;
        } else {
            if (this.manufacturer == null) {
                this.manufacturer = new StringType();
            }
            this.manufacturer.setValue(value);
        }
        return this;
    }

    public DateTimeType getManufactureDateElement() {
        if (this.manufactureDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.manufactureDate");
            }
            if (Configuration.doAutoCreate()) {
                this.manufactureDate = new DateTimeType();
            }
        }
        return this.manufactureDate;
    }

    public boolean hasManufactureDateElement() {
        return this.manufactureDate != null && !this.manufactureDate.isEmpty();
    }

    public boolean hasManufactureDate() {
        return this.manufactureDate != null && !this.manufactureDate.isEmpty();
    }

    public Device setManufactureDateElement(DateTimeType value) {
        this.manufactureDate = value;
        return this;
    }

    public Date getManufactureDate() {
        return this.manufactureDate == null ? null : (Date)this.manufactureDate.getValue();
    }

    public Device setManufactureDate(Date value) {
        if (value == null) {
            this.manufactureDate = null;
        } else {
            if (this.manufactureDate == null) {
                this.manufactureDate = new DateTimeType();
            }
            this.manufactureDate.setValue(value);
        }
        return this;
    }

    public DateTimeType getExpirationDateElement() {
        if (this.expirationDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.expirationDate");
            }
            if (Configuration.doAutoCreate()) {
                this.expirationDate = new DateTimeType();
            }
        }
        return this.expirationDate;
    }

    public boolean hasExpirationDateElement() {
        return this.expirationDate != null && !this.expirationDate.isEmpty();
    }

    public boolean hasExpirationDate() {
        return this.expirationDate != null && !this.expirationDate.isEmpty();
    }

    public Device setExpirationDateElement(DateTimeType value) {
        this.expirationDate = value;
        return this;
    }

    public Date getExpirationDate() {
        return this.expirationDate == null ? null : (Date)this.expirationDate.getValue();
    }

    public Device setExpirationDate(Date value) {
        if (value == null) {
            this.expirationDate = null;
        } else {
            if (this.expirationDate == null) {
                this.expirationDate = new DateTimeType();
            }
            this.expirationDate.setValue(value);
        }
        return this;
    }

    public StringType getModelElement() {
        if (this.model == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.model");
            }
            if (Configuration.doAutoCreate()) {
                this.model = new StringType();
            }
        }
        return this.model;
    }

    public boolean hasModelElement() {
        return this.model != null && !this.model.isEmpty();
    }

    public boolean hasModel() {
        return this.model != null && !this.model.isEmpty();
    }

    public Device setModelElement(StringType value) {
        this.model = value;
        return this;
    }

    public String getModel() {
        return this.model == null ? null : (String)this.model.getValue();
    }

    public Device setModel(String value) {
        if (Utilities.noString((String)value)) {
            this.model = null;
        } else {
            if (this.model == null) {
                this.model = new StringType();
            }
            this.model.setValue(value);
        }
        return this;
    }

    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    public Device setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    public Device setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public Device setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public Device setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    public Reference getOwner() {
        if (this.owner == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.owner");
            }
            if (Configuration.doAutoCreate()) {
                this.owner = new Reference();
            }
        }
        return this.owner;
    }

    public boolean hasOwner() {
        return this.owner != null && !this.owner.isEmpty();
    }

    public Device setOwner(Reference value) {
        this.owner = value;
        return this;
    }

    public Organization getOwnerTarget() {
        if (this.ownerTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.owner");
            }
            if (Configuration.doAutoCreate()) {
                this.ownerTarget = new Organization();
            }
        }
        return this.ownerTarget;
    }

    public Device setOwnerTarget(Organization value) {
        this.ownerTarget = value;
        return this;
    }

    public List<ContactPoint> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactPoint>();
        }
        return this.contact;
    }

    public Device setContact(List<ContactPoint> theContact) {
        this.contact = theContact;
        return this;
    }

    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactPoint item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactPoint addContact() {
        ContactPoint t = new ContactPoint();
        if (this.contact == null) {
            this.contact = new ArrayList<ContactPoint>();
        }
        this.contact.add(t);
        return t;
    }

    public Device addContact(ContactPoint t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ContactPoint>();
        }
        this.contact.add(t);
        return this;
    }

    public ContactPoint getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    public Reference getLocation() {
        if (this.location == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.location");
            }
            if (Configuration.doAutoCreate()) {
                this.location = new Reference();
            }
        }
        return this.location;
    }

    public boolean hasLocation() {
        return this.location != null && !this.location.isEmpty();
    }

    public Device setLocation(Reference value) {
        this.location = value;
        return this;
    }

    public Location getLocationTarget() {
        if (this.locationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.location");
            }
            if (Configuration.doAutoCreate()) {
                this.locationTarget = new Location();
            }
        }
        return this.locationTarget;
    }

    public Device setLocationTarget(Location value) {
        this.locationTarget = value;
        return this;
    }

    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Device.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    public Device setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    public Device setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public Device setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public Device addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public List<CodeableConcept> getSafety() {
        if (this.safety == null) {
            this.safety = new ArrayList<CodeableConcept>();
        }
        return this.safety;
    }

    public Device setSafety(List<CodeableConcept> theSafety) {
        this.safety = theSafety;
        return this;
    }

    public boolean hasSafety() {
        if (this.safety == null) {
            return false;
        }
        for (CodeableConcept item : this.safety) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addSafety() {
        CodeableConcept t = new CodeableConcept();
        if (this.safety == null) {
            this.safety = new ArrayList<CodeableConcept>();
        }
        this.safety.add(t);
        return t;
    }

    public Device addSafety(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.safety == null) {
            this.safety = new ArrayList<CodeableConcept>();
        }
        this.safety.add(t);
        return this;
    }

    public CodeableConcept getSafetyFirstRep() {
        if (this.getSafety().isEmpty()) {
            this.addSafety();
        }
        return this.getSafety().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Unique instance identifiers assigned to a device by manufacturers other organizations or owners.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("udi", "", "[Unique device identifier (UDI)](device.html#5.11.3.2.2) assigned to device label or package.", 0, 1, this.udi));
        children.add(new Property(SP_STATUS, "code", "Status of the Device availability.", 0, 1, this.status));
        children.add(new Property(SP_TYPE, "CodeableConcept", "Code or identifier to identify a kind of device.", 0, 1, this.type));
        children.add(new Property("lotNumber", "string", "Lot number assigned by the manufacturer.", 0, 1, this.lotNumber));
        children.add(new Property(SP_MANUFACTURER, "string", "A name of the manufacturer.", 0, 1, this.manufacturer));
        children.add(new Property("manufactureDate", "dateTime", "The date and time when the device was manufactured.", 0, 1, this.manufactureDate));
        children.add(new Property("expirationDate", "dateTime", "The date and time beyond which this device is no longer valid or should not be used (if applicable).", 0, 1, this.expirationDate));
        children.add(new Property(SP_MODEL, "string", "The \"model\" is an identifier assigned by the manufacturer to identify the product by its type. This number is shared by the all devices sold as the same type.", 0, 1, this.model));
        children.add(new Property("version", "string", "The version of the device, if the device has multiple releases under the same model, or if the device is software or carries firmware.", 0, 1, this.version));
        children.add(new Property(SP_PATIENT, "Reference(Patient)", "Patient information, If the device is affixed to a person.", 0, 1, this.patient));
        children.add(new Property("owner", "Reference(Organization)", "An organization that is responsible for the provision and ongoing maintenance of the device.", 0, 1, this.owner));
        children.add(new Property("contact", "ContactPoint", "Contact details for an organization or a particular human that is responsible for the device.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property(SP_LOCATION, "Reference(Location)", "The place where the device can be found.", 0, 1, this.location));
        children.add(new Property(SP_URL, "uri", "A network address on which the device may be contacted directly.", 0, 1, this.url));
        children.add(new Property("note", "Annotation", "Descriptive information, usage information or implantation information that is not captured in an existing element.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("safety", "CodeableConcept", "Provides additional safety characteristics about a medical device.  For example devices containing latex.", 0, Integer.MAX_VALUE, this.safety));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Unique instance identifiers assigned to a device by manufacturers other organizations or owners.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 115642: {
                return new Property("udi", "", "[Unique device identifier (UDI)](device.html#5.11.3.2.2) assigned to device label or package.", 0, 1, this.udi);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "Status of the Device availability.", 0, 1, this.status);
            }
            case 3575610: {
                return new Property(SP_TYPE, "CodeableConcept", "Code or identifier to identify a kind of device.", 0, 1, this.type);
            }
            case 462547450: {
                return new Property("lotNumber", "string", "Lot number assigned by the manufacturer.", 0, 1, this.lotNumber);
            }
            case -1969347631: {
                return new Property(SP_MANUFACTURER, "string", "A name of the manufacturer.", 0, 1, this.manufacturer);
            }
            case 416714767: {
                return new Property("manufactureDate", "dateTime", "The date and time when the device was manufactured.", 0, 1, this.manufactureDate);
            }
            case -668811523: {
                return new Property("expirationDate", "dateTime", "The date and time beyond which this device is no longer valid or should not be used (if applicable).", 0, 1, this.expirationDate);
            }
            case 104069929: {
                return new Property(SP_MODEL, "string", "The \"model\" is an identifier assigned by the manufacturer to identify the product by its type. This number is shared by the all devices sold as the same type.", 0, 1, this.model);
            }
            case 351608024: {
                return new Property("version", "string", "The version of the device, if the device has multiple releases under the same model, or if the device is software or carries firmware.", 0, 1, this.version);
            }
            case -791418107: {
                return new Property(SP_PATIENT, "Reference(Patient)", "Patient information, If the device is affixed to a person.", 0, 1, this.patient);
            }
            case 106164915: {
                return new Property("owner", "Reference(Organization)", "An organization that is responsible for the provision and ongoing maintenance of the device.", 0, 1, this.owner);
            }
            case 951526432: {
                return new Property("contact", "ContactPoint", "Contact details for an organization or a particular human that is responsible for the device.", 0, Integer.MAX_VALUE, this.contact);
            }
            case 1901043637: {
                return new Property(SP_LOCATION, "Reference(Location)", "The place where the device can be found.", 0, 1, this.location);
            }
            case 116079: {
                return new Property(SP_URL, "uri", "A network address on which the device may be contacted directly.", 0, 1, this.url);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Descriptive information, usage information or implantation information that is not captured in an existing element.", 0, Integer.MAX_VALUE, this.note);
            }
            case -909893934: {
                return new Property("safety", "CodeableConcept", "Provides additional safety characteristics about a medical device.  For example devices containing latex.", 0, Integer.MAX_VALUE, this.safety);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 115642: {
                Base[] baseArray;
                if (this.udi == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.udi;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.type;
                }
                return baseArray;
            }
            case 462547450: {
                Base[] baseArray;
                if (this.lotNumber == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.lotNumber;
                }
                return baseArray;
            }
            case -1969347631: {
                Base[] baseArray;
                if (this.manufacturer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.manufacturer;
                }
                return baseArray;
            }
            case 416714767: {
                Base[] baseArray;
                if (this.manufactureDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.manufactureDate;
                }
                return baseArray;
            }
            case -668811523: {
                Base[] baseArray;
                if (this.expirationDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.expirationDate;
                }
                return baseArray;
            }
            case 104069929: {
                Base[] baseArray;
                if (this.model == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.model;
                }
                return baseArray;
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.version;
                }
                return baseArray;
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.patient;
                }
                return baseArray;
            }
            case 106164915: {
                Base[] baseArray;
                if (this.owner == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.owner;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case 1901043637: {
                Base[] baseArray;
                if (this.location == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.location;
                }
                return baseArray;
            }
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.url;
                }
                return baseArray;
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case -909893934: {
                return this.safety == null ? new Base[]{} : this.safety.toArray(new Base[this.safety.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case 115642: {
                this.udi = (DeviceUdiComponent)((Object)value);
                return value;
            }
            case -892481550: {
                value = new FHIRDeviceStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case 3575610: {
                this.type = this.castToCodeableConcept(value);
                return value;
            }
            case 462547450: {
                this.lotNumber = this.castToString(value);
                return value;
            }
            case -1969347631: {
                this.manufacturer = this.castToString(value);
                return value;
            }
            case 416714767: {
                this.manufactureDate = this.castToDateTime(value);
                return value;
            }
            case -668811523: {
                this.expirationDate = this.castToDateTime(value);
                return value;
            }
            case 104069929: {
                this.model = this.castToString(value);
                return value;
            }
            case 351608024: {
                this.version = this.castToString(value);
                return value;
            }
            case -791418107: {
                this.patient = this.castToReference(value);
                return value;
            }
            case 106164915: {
                this.owner = this.castToReference(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(this.castToContactPoint(value));
                return value;
            }
            case 1901043637: {
                this.location = this.castToReference(value);
                return value;
            }
            case 116079: {
                this.url = this.castToUri(value);
                return value;
            }
            case 3387378: {
                this.getNote().add(this.castToAnnotation(value));
                return value;
            }
            case -909893934: {
                this.getSafety().add(this.castToCodeableConcept(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("udi")) {
            this.udi = (DeviceUdiComponent)((Object)value);
        } else if (name.equals(SP_STATUS)) {
            value = new FHIRDeviceStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_TYPE)) {
            this.type = this.castToCodeableConcept(value);
        } else if (name.equals("lotNumber")) {
            this.lotNumber = this.castToString(value);
        } else if (name.equals(SP_MANUFACTURER)) {
            this.manufacturer = this.castToString(value);
        } else if (name.equals("manufactureDate")) {
            this.manufactureDate = this.castToDateTime(value);
        } else if (name.equals("expirationDate")) {
            this.expirationDate = this.castToDateTime(value);
        } else if (name.equals(SP_MODEL)) {
            this.model = this.castToString(value);
        } else if (name.equals("version")) {
            this.version = this.castToString(value);
        } else if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals("owner")) {
            this.owner = this.castToReference(value);
        } else if (name.equals("contact")) {
            this.getContact().add(this.castToContactPoint(value));
        } else if (name.equals(SP_LOCATION)) {
            this.location = this.castToReference(value);
        } else if (name.equals(SP_URL)) {
            this.url = this.castToUri(value);
        } else if (name.equals("note")) {
            this.getNote().add(this.castToAnnotation(value));
        } else if (name.equals("safety")) {
            this.getSafety().add(this.castToCodeableConcept(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 115642: {
                return this.getUdi();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 3575610: {
                return this.getType();
            }
            case 462547450: {
                return this.getLotNumberElement();
            }
            case -1969347631: {
                return this.getManufacturerElement();
            }
            case 416714767: {
                return this.getManufactureDateElement();
            }
            case -668811523: {
                return this.getExpirationDateElement();
            }
            case 104069929: {
                return this.getModelElement();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case -791418107: {
                return this.getPatient();
            }
            case 106164915: {
                return this.getOwner();
            }
            case 951526432: {
                return this.addContact();
            }
            case 1901043637: {
                return this.getLocation();
            }
            case 116079: {
                return this.getUrlElement();
            }
            case 3387378: {
                return this.addNote();
            }
            case -909893934: {
                return this.addSafety();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 115642: {
                return new String[0];
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case 462547450: {
                return new String[]{"string"};
            }
            case -1969347631: {
                return new String[]{"string"};
            }
            case 416714767: {
                return new String[]{"dateTime"};
            }
            case -668811523: {
                return new String[]{"dateTime"};
            }
            case 104069929: {
                return new String[]{"string"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case -791418107: {
                return new String[]{"Reference"};
            }
            case 106164915: {
                return new String[]{"Reference"};
            }
            case 951526432: {
                return new String[]{"ContactPoint"};
            }
            case 1901043637: {
                return new String[]{"Reference"};
            }
            case 116079: {
                return new String[]{"uri"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case -909893934: {
                return new String[]{"CodeableConcept"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("udi")) {
            this.udi = new DeviceUdiComponent();
            return this.udi;
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Device.status");
        }
        if (name.equals(SP_TYPE)) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals("lotNumber")) {
            throw new FHIRException("Cannot call addChild on a primitive type Device.lotNumber");
        }
        if (name.equals(SP_MANUFACTURER)) {
            throw new FHIRException("Cannot call addChild on a primitive type Device.manufacturer");
        }
        if (name.equals("manufactureDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type Device.manufactureDate");
        }
        if (name.equals("expirationDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type Device.expirationDate");
        }
        if (name.equals(SP_MODEL)) {
            throw new FHIRException("Cannot call addChild on a primitive type Device.model");
        }
        if (name.equals("version")) {
            throw new FHIRException("Cannot call addChild on a primitive type Device.version");
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals("owner")) {
            this.owner = new Reference();
            return this.owner;
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_LOCATION)) {
            this.location = new Reference();
            return this.location;
        }
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type Device.url");
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("safety")) {
            return this.addSafety();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Device";
    }

    @Override
    public Device copy() {
        Device dst = new Device();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.udi = this.udi == null ? null : this.udi.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.lotNumber = this.lotNumber == null ? null : this.lotNumber.copy();
        dst.manufacturer = this.manufacturer == null ? null : this.manufacturer.copy();
        dst.manufactureDate = this.manufactureDate == null ? null : this.manufactureDate.copy();
        dst.expirationDate = this.expirationDate == null ? null : this.expirationDate.copy();
        dst.model = this.model == null ? null : this.model.copy();
        dst.version = this.version == null ? null : this.version.copy();
        dst.patient = this.patient == null ? null : this.patient.copy();
        Reference reference = dst.owner = this.owner == null ? null : this.owner.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ContactPoint>();
            for (ContactPoint contactPoint : this.contact) {
                dst.contact.add(contactPoint.copy());
            }
        }
        dst.location = this.location == null ? null : this.location.copy();
        UriType uriType = dst.url = this.url == null ? null : this.url.copy();
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        if (this.safety != null) {
            dst.safety = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.safety) {
                dst.safety.add(codeableConcept.copy());
            }
        }
        return dst;
    }

    protected Device typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Device)) {
            return false;
        }
        Device o = (Device)other_;
        return Device.compareDeep(this.identifier, o.identifier, true) && Device.compareDeep(this.udi, o.udi, true) && Device.compareDeep(this.status, o.status, true) && Device.compareDeep(this.type, o.type, true) && Device.compareDeep(this.lotNumber, o.lotNumber, true) && Device.compareDeep(this.manufacturer, o.manufacturer, true) && Device.compareDeep(this.manufactureDate, o.manufactureDate, true) && Device.compareDeep(this.expirationDate, o.expirationDate, true) && Device.compareDeep(this.model, o.model, true) && Device.compareDeep(this.version, o.version, true) && Device.compareDeep(this.patient, o.patient, true) && Device.compareDeep(this.owner, o.owner, true) && Device.compareDeep(this.contact, o.contact, true) && Device.compareDeep(this.location, o.location, true) && Device.compareDeep(this.url, o.url, true) && Device.compareDeep(this.note, o.note, true) && Device.compareDeep(this.safety, o.safety, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Device)) {
            return false;
        }
        Device o = (Device)other_;
        return Device.compareValues(this.status, o.status, true) && Device.compareValues(this.lotNumber, o.lotNumber, true) && Device.compareValues(this.manufacturer, o.manufacturer, true) && Device.compareValues(this.manufactureDate, o.manufactureDate, true) && Device.compareValues(this.expirationDate, o.expirationDate, true) && Device.compareValues(this.model, o.model, true) && Device.compareValues(this.version, o.version, true) && Device.compareValues(this.url, o.url, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.udi, this.status, this.type, this.lotNumber, this.manufacturer, this.manufactureDate, this.expirationDate, this.model, this.version, this.patient, this.owner, this.contact, this.location, this.url, this.note, this.safety});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Device;
    }

    @Block
    public static class DeviceUdiComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="deviceIdentifier", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Mandatory fixed portion of UDI", formalDefinition="The device identifier (DI) is a mandatory, fixed portion of a UDI that identifies the labeler and the specific version or model of a device.")
        protected StringType deviceIdentifier;
        @Child(name="name", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Device Name as appears on UDI label", formalDefinition="Name of device as used in labeling or catalog.")
        protected StringType name;
        @Child(name="jurisdiction", type={UriType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Regional UDI authority", formalDefinition="The identity of the authoritative source for UDI generation within a  jurisdiction.  All UDIs are globally unique within a single namespace. with the appropriate repository uri as the system.  For example,  UDIs of devices managed in the U.S. by the FDA, the value is  http://hl7.org/fhir/NamingSystem/fda-udi.")
        protected UriType jurisdiction;
        @Child(name="carrierHRF", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="UDI Human Readable Barcode String", formalDefinition="The full UDI carrier as the human readable form (HRF) representation of the barcode string as printed on the packaging of the device.")
        protected StringType carrierHRF;
        @Child(name="carrierAIDC", type={Base64BinaryType.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="UDI Machine Readable Barcode String", formalDefinition="The full UDI carrier of the Automatic Identification and Data Capture (AIDC) technology representation of the barcode string as printed on the packaging of the device - E.g a barcode or RFID.   Because of limitations on character sets in XML and the need to round-trip JSON data through XML, AIDC Formats *SHALL* be base64 encoded.")
        protected Base64BinaryType carrierAIDC;
        @Child(name="issuer", type={UriType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="UDI Issuing Organization", formalDefinition="Organization that is charged with issuing UDIs for devices.  For example, the US FDA issuers include :\n1) GS1: \nhttp://hl7.org/fhir/NamingSystem/gs1-di, \n2) HIBCC:\nhttp://hl7.org/fhir/NamingSystem/hibcc-dI, \n3) ICCBBA for blood containers:\nhttp://hl7.org/fhir/NamingSystem/iccbba-blood-di, \n4) ICCBA for other devices:\nhttp://hl7.org/fhir/NamingSystem/iccbba-other-di.")
        protected UriType issuer;
        @Child(name="entryType", type={CodeType.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="barcode | rfid | manual +", formalDefinition="A coded entry to indicate how the data was entered.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/udi-entry-type")
        protected Enumeration<UDIEntryType> entryType;
        private static final long serialVersionUID = -1105798343L;

        public StringType getDeviceIdentifierElement() {
            if (this.deviceIdentifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceUdiComponent.deviceIdentifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.deviceIdentifier = new StringType();
                }
            }
            return this.deviceIdentifier;
        }

        public boolean hasDeviceIdentifierElement() {
            return this.deviceIdentifier != null && !this.deviceIdentifier.isEmpty();
        }

        public boolean hasDeviceIdentifier() {
            return this.deviceIdentifier != null && !this.deviceIdentifier.isEmpty();
        }

        public DeviceUdiComponent setDeviceIdentifierElement(StringType value) {
            this.deviceIdentifier = value;
            return this;
        }

        public String getDeviceIdentifier() {
            return this.deviceIdentifier == null ? null : (String)this.deviceIdentifier.getValue();
        }

        public DeviceUdiComponent setDeviceIdentifier(String value) {
            if (Utilities.noString((String)value)) {
                this.deviceIdentifier = null;
            } else {
                if (this.deviceIdentifier == null) {
                    this.deviceIdentifier = new StringType();
                }
                this.deviceIdentifier.setValue(value);
            }
            return this;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceUdiComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public DeviceUdiComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public DeviceUdiComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public UriType getJurisdictionElement() {
            if (this.jurisdiction == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceUdiComponent.jurisdiction");
                }
                if (Configuration.doAutoCreate()) {
                    this.jurisdiction = new UriType();
                }
            }
            return this.jurisdiction;
        }

        public boolean hasJurisdictionElement() {
            return this.jurisdiction != null && !this.jurisdiction.isEmpty();
        }

        public boolean hasJurisdiction() {
            return this.jurisdiction != null && !this.jurisdiction.isEmpty();
        }

        public DeviceUdiComponent setJurisdictionElement(UriType value) {
            this.jurisdiction = value;
            return this;
        }

        public String getJurisdiction() {
            return this.jurisdiction == null ? null : (String)this.jurisdiction.getValue();
        }

        public DeviceUdiComponent setJurisdiction(String value) {
            if (Utilities.noString((String)value)) {
                this.jurisdiction = null;
            } else {
                if (this.jurisdiction == null) {
                    this.jurisdiction = new UriType();
                }
                this.jurisdiction.setValue(value);
            }
            return this;
        }

        public StringType getCarrierHRFElement() {
            if (this.carrierHRF == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceUdiComponent.carrierHRF");
                }
                if (Configuration.doAutoCreate()) {
                    this.carrierHRF = new StringType();
                }
            }
            return this.carrierHRF;
        }

        public boolean hasCarrierHRFElement() {
            return this.carrierHRF != null && !this.carrierHRF.isEmpty();
        }

        public boolean hasCarrierHRF() {
            return this.carrierHRF != null && !this.carrierHRF.isEmpty();
        }

        public DeviceUdiComponent setCarrierHRFElement(StringType value) {
            this.carrierHRF = value;
            return this;
        }

        public String getCarrierHRF() {
            return this.carrierHRF == null ? null : (String)this.carrierHRF.getValue();
        }

        public DeviceUdiComponent setCarrierHRF(String value) {
            if (Utilities.noString((String)value)) {
                this.carrierHRF = null;
            } else {
                if (this.carrierHRF == null) {
                    this.carrierHRF = new StringType();
                }
                this.carrierHRF.setValue(value);
            }
            return this;
        }

        public Base64BinaryType getCarrierAIDCElement() {
            if (this.carrierAIDC == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceUdiComponent.carrierAIDC");
                }
                if (Configuration.doAutoCreate()) {
                    this.carrierAIDC = new Base64BinaryType();
                }
            }
            return this.carrierAIDC;
        }

        public boolean hasCarrierAIDCElement() {
            return this.carrierAIDC != null && !this.carrierAIDC.isEmpty();
        }

        public boolean hasCarrierAIDC() {
            return this.carrierAIDC != null && !this.carrierAIDC.isEmpty();
        }

        public DeviceUdiComponent setCarrierAIDCElement(Base64BinaryType value) {
            this.carrierAIDC = value;
            return this;
        }

        public byte[] getCarrierAIDC() {
            return this.carrierAIDC == null ? null : (byte[])this.carrierAIDC.getValue();
        }

        public DeviceUdiComponent setCarrierAIDC(byte[] value) {
            if (value == null) {
                this.carrierAIDC = null;
            } else {
                if (this.carrierAIDC == null) {
                    this.carrierAIDC = new Base64BinaryType();
                }
                this.carrierAIDC.setValue(value);
            }
            return this;
        }

        public UriType getIssuerElement() {
            if (this.issuer == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceUdiComponent.issuer");
                }
                if (Configuration.doAutoCreate()) {
                    this.issuer = new UriType();
                }
            }
            return this.issuer;
        }

        public boolean hasIssuerElement() {
            return this.issuer != null && !this.issuer.isEmpty();
        }

        public boolean hasIssuer() {
            return this.issuer != null && !this.issuer.isEmpty();
        }

        public DeviceUdiComponent setIssuerElement(UriType value) {
            this.issuer = value;
            return this;
        }

        public String getIssuer() {
            return this.issuer == null ? null : (String)this.issuer.getValue();
        }

        public DeviceUdiComponent setIssuer(String value) {
            if (Utilities.noString((String)value)) {
                this.issuer = null;
            } else {
                if (this.issuer == null) {
                    this.issuer = new UriType();
                }
                this.issuer.setValue(value);
            }
            return this;
        }

        public Enumeration<UDIEntryType> getEntryTypeElement() {
            if (this.entryType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceUdiComponent.entryType");
                }
                if (Configuration.doAutoCreate()) {
                    this.entryType = new Enumeration<UDIEntryType>(new UDIEntryTypeEnumFactory());
                }
            }
            return this.entryType;
        }

        public boolean hasEntryTypeElement() {
            return this.entryType != null && !this.entryType.isEmpty();
        }

        public boolean hasEntryType() {
            return this.entryType != null && !this.entryType.isEmpty();
        }

        public DeviceUdiComponent setEntryTypeElement(Enumeration<UDIEntryType> value) {
            this.entryType = value;
            return this;
        }

        public UDIEntryType getEntryType() {
            return this.entryType == null ? null : (UDIEntryType)((Object)this.entryType.getValue());
        }

        public DeviceUdiComponent setEntryType(UDIEntryType value) {
            if (value == null) {
                this.entryType = null;
            } else {
                if (this.entryType == null) {
                    this.entryType = new Enumeration<UDIEntryType>(new UDIEntryTypeEnumFactory());
                }
                this.entryType.setValue((Object)value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("deviceIdentifier", "string", "The device identifier (DI) is a mandatory, fixed portion of a UDI that identifies the labeler and the specific version or model of a device.", 0, 1, this.deviceIdentifier));
            children.add(new Property("name", "string", "Name of device as used in labeling or catalog.", 0, 1, this.name));
            children.add(new Property("jurisdiction", "uri", "The identity of the authoritative source for UDI generation within a  jurisdiction.  All UDIs are globally unique within a single namespace. with the appropriate repository uri as the system.  For example,  UDIs of devices managed in the U.S. by the FDA, the value is  http://hl7.org/fhir/NamingSystem/fda-udi.", 0, 1, this.jurisdiction));
            children.add(new Property("carrierHRF", "string", "The full UDI carrier as the human readable form (HRF) representation of the barcode string as printed on the packaging of the device.", 0, 1, this.carrierHRF));
            children.add(new Property("carrierAIDC", "base64Binary", "The full UDI carrier of the Automatic Identification and Data Capture (AIDC) technology representation of the barcode string as printed on the packaging of the device - E.g a barcode or RFID.   Because of limitations on character sets in XML and the need to round-trip JSON data through XML, AIDC Formats *SHALL* be base64 encoded.", 0, 1, this.carrierAIDC));
            children.add(new Property("issuer", "uri", "Organization that is charged with issuing UDIs for devices.  For example, the US FDA issuers include :\n1) GS1: \nhttp://hl7.org/fhir/NamingSystem/gs1-di, \n2) HIBCC:\nhttp://hl7.org/fhir/NamingSystem/hibcc-dI, \n3) ICCBBA for blood containers:\nhttp://hl7.org/fhir/NamingSystem/iccbba-blood-di, \n4) ICCBA for other devices:\nhttp://hl7.org/fhir/NamingSystem/iccbba-other-di.", 0, 1, this.issuer));
            children.add(new Property("entryType", "code", "A coded entry to indicate how the data was entered.", 0, 1, this.entryType));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1322005407: {
                    return new Property("deviceIdentifier", "string", "The device identifier (DI) is a mandatory, fixed portion of a UDI that identifies the labeler and the specific version or model of a device.", 0, 1, this.deviceIdentifier);
                }
                case 3373707: {
                    return new Property("name", "string", "Name of device as used in labeling or catalog.", 0, 1, this.name);
                }
                case -507075711: {
                    return new Property("jurisdiction", "uri", "The identity of the authoritative source for UDI generation within a  jurisdiction.  All UDIs are globally unique within a single namespace. with the appropriate repository uri as the system.  For example,  UDIs of devices managed in the U.S. by the FDA, the value is  http://hl7.org/fhir/NamingSystem/fda-udi.", 0, 1, this.jurisdiction);
                }
                case 806499972: {
                    return new Property("carrierHRF", "string", "The full UDI carrier as the human readable form (HRF) representation of the barcode string as printed on the packaging of the device.", 0, 1, this.carrierHRF);
                }
                case -768521825: {
                    return new Property("carrierAIDC", "base64Binary", "The full UDI carrier of the Automatic Identification and Data Capture (AIDC) technology representation of the barcode string as printed on the packaging of the device - E.g a barcode or RFID.   Because of limitations on character sets in XML and the need to round-trip JSON data through XML, AIDC Formats *SHALL* be base64 encoded.", 0, 1, this.carrierAIDC);
                }
                case -1179159879: {
                    return new Property("issuer", "uri", "Organization that is charged with issuing UDIs for devices.  For example, the US FDA issuers include :\n1) GS1: \nhttp://hl7.org/fhir/NamingSystem/gs1-di, \n2) HIBCC:\nhttp://hl7.org/fhir/NamingSystem/hibcc-dI, \n3) ICCBBA for blood containers:\nhttp://hl7.org/fhir/NamingSystem/iccbba-blood-di, \n4) ICCBA for other devices:\nhttp://hl7.org/fhir/NamingSystem/iccbba-other-di.", 0, 1, this.issuer);
                }
                case -479362356: {
                    return new Property("entryType", "code", "A coded entry to indicate how the data was entered.", 0, 1, this.entryType);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1322005407: {
                    Base[] baseArray;
                    if (this.deviceIdentifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.deviceIdentifier;
                    }
                    return baseArray;
                }
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.name;
                    }
                    return baseArray;
                }
                case -507075711: {
                    Base[] baseArray;
                    if (this.jurisdiction == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.jurisdiction;
                    }
                    return baseArray;
                }
                case 806499972: {
                    Base[] baseArray;
                    if (this.carrierHRF == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.carrierHRF;
                    }
                    return baseArray;
                }
                case -768521825: {
                    Base[] baseArray;
                    if (this.carrierAIDC == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.carrierAIDC;
                    }
                    return baseArray;
                }
                case -1179159879: {
                    Base[] baseArray;
                    if (this.issuer == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.issuer;
                    }
                    return baseArray;
                }
                case -479362356: {
                    Base[] baseArray;
                    if (this.entryType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.entryType;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1322005407: {
                    this.deviceIdentifier = this.castToString(value);
                    return value;
                }
                case 3373707: {
                    this.name = this.castToString(value);
                    return value;
                }
                case -507075711: {
                    this.jurisdiction = this.castToUri(value);
                    return value;
                }
                case 806499972: {
                    this.carrierHRF = this.castToString(value);
                    return value;
                }
                case -768521825: {
                    this.carrierAIDC = this.castToBase64Binary(value);
                    return value;
                }
                case -1179159879: {
                    this.issuer = this.castToUri(value);
                    return value;
                }
                case -479362356: {
                    value = new UDIEntryTypeEnumFactory().fromType(this.castToCode(value));
                    this.entryType = value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("deviceIdentifier")) {
                this.deviceIdentifier = this.castToString(value);
            } else if (name.equals("name")) {
                this.name = this.castToString(value);
            } else if (name.equals("jurisdiction")) {
                this.jurisdiction = this.castToUri(value);
            } else if (name.equals("carrierHRF")) {
                this.carrierHRF = this.castToString(value);
            } else if (name.equals("carrierAIDC")) {
                this.carrierAIDC = this.castToBase64Binary(value);
            } else if (name.equals("issuer")) {
                this.issuer = this.castToUri(value);
            } else if (name.equals("entryType")) {
                value = new UDIEntryTypeEnumFactory().fromType(this.castToCode(value));
                this.entryType = value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1322005407: {
                    return this.getDeviceIdentifierElement();
                }
                case 3373707: {
                    return this.getNameElement();
                }
                case -507075711: {
                    return this.getJurisdictionElement();
                }
                case 806499972: {
                    return this.getCarrierHRFElement();
                }
                case -768521825: {
                    return this.getCarrierAIDCElement();
                }
                case -1179159879: {
                    return this.getIssuerElement();
                }
                case -479362356: {
                    return this.getEntryTypeElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1322005407: {
                    return new String[]{"string"};
                }
                case 3373707: {
                    return new String[]{"string"};
                }
                case -507075711: {
                    return new String[]{"uri"};
                }
                case 806499972: {
                    return new String[]{"string"};
                }
                case -768521825: {
                    return new String[]{"base64Binary"};
                }
                case -1179159879: {
                    return new String[]{"uri"};
                }
                case -479362356: {
                    return new String[]{"code"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("deviceIdentifier")) {
                throw new FHIRException("Cannot call addChild on a primitive type Device.deviceIdentifier");
            }
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a primitive type Device.name");
            }
            if (name.equals("jurisdiction")) {
                throw new FHIRException("Cannot call addChild on a primitive type Device.jurisdiction");
            }
            if (name.equals("carrierHRF")) {
                throw new FHIRException("Cannot call addChild on a primitive type Device.carrierHRF");
            }
            if (name.equals("carrierAIDC")) {
                throw new FHIRException("Cannot call addChild on a primitive type Device.carrierAIDC");
            }
            if (name.equals("issuer")) {
                throw new FHIRException("Cannot call addChild on a primitive type Device.issuer");
            }
            if (name.equals("entryType")) {
                throw new FHIRException("Cannot call addChild on a primitive type Device.entryType");
            }
            return super.addChild(name);
        }

        @Override
        public DeviceUdiComponent copy() {
            DeviceUdiComponent dst = new DeviceUdiComponent();
            this.copyValues(dst);
            dst.deviceIdentifier = this.deviceIdentifier == null ? null : this.deviceIdentifier.copy();
            dst.name = this.name == null ? null : this.name.copy();
            dst.jurisdiction = this.jurisdiction == null ? null : this.jurisdiction.copy();
            dst.carrierHRF = this.carrierHRF == null ? null : this.carrierHRF.copy();
            dst.carrierAIDC = this.carrierAIDC == null ? null : this.carrierAIDC.copy();
            dst.issuer = this.issuer == null ? null : this.issuer.copy();
            dst.entryType = this.entryType == null ? null : this.entryType.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceUdiComponent)) {
                return false;
            }
            DeviceUdiComponent o = (DeviceUdiComponent)other_;
            return DeviceUdiComponent.compareDeep(this.deviceIdentifier, o.deviceIdentifier, true) && DeviceUdiComponent.compareDeep(this.name, o.name, true) && DeviceUdiComponent.compareDeep(this.jurisdiction, o.jurisdiction, true) && DeviceUdiComponent.compareDeep(this.carrierHRF, o.carrierHRF, true) && DeviceUdiComponent.compareDeep(this.carrierAIDC, o.carrierAIDC, true) && DeviceUdiComponent.compareDeep(this.issuer, o.issuer, true) && DeviceUdiComponent.compareDeep(this.entryType, o.entryType, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceUdiComponent)) {
                return false;
            }
            DeviceUdiComponent o = (DeviceUdiComponent)other_;
            return DeviceUdiComponent.compareValues(this.deviceIdentifier, o.deviceIdentifier, true) && DeviceUdiComponent.compareValues(this.name, o.name, true) && DeviceUdiComponent.compareValues(this.jurisdiction, o.jurisdiction, true) && DeviceUdiComponent.compareValues(this.carrierHRF, o.carrierHRF, true) && DeviceUdiComponent.compareValues(this.carrierAIDC, o.carrierAIDC, true) && DeviceUdiComponent.compareValues(this.issuer, o.issuer, true) && DeviceUdiComponent.compareValues(this.entryType, o.entryType, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.deviceIdentifier, this.name, this.jurisdiction, this.carrierHRF, this.carrierAIDC, this.issuer, this.entryType});
        }

        @Override
        public String fhirType() {
            return "Device.udi";
        }
    }

    public static class FHIRDeviceStatusEnumFactory
    implements EnumFactory<FHIRDeviceStatus> {
        @Override
        public FHIRDeviceStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return FHIRDeviceStatus.ACTIVE;
            }
            if ("inactive".equals(codeString)) {
                return FHIRDeviceStatus.INACTIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return FHIRDeviceStatus.ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return FHIRDeviceStatus.UNKNOWN;
            }
            throw new IllegalArgumentException("Unknown FHIRDeviceStatus code '" + codeString + "'");
        }

        public Enumeration<FHIRDeviceStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<FHIRDeviceStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return new Enumeration<FHIRDeviceStatus>(this, FHIRDeviceStatus.ACTIVE);
            }
            if ("inactive".equals(codeString)) {
                return new Enumeration<FHIRDeviceStatus>(this, FHIRDeviceStatus.INACTIVE);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<FHIRDeviceStatus>(this, FHIRDeviceStatus.ENTEREDINERROR);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<FHIRDeviceStatus>(this, FHIRDeviceStatus.UNKNOWN);
            }
            throw new FHIRException("Unknown FHIRDeviceStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(FHIRDeviceStatus code) {
            if (code == FHIRDeviceStatus.ACTIVE) {
                return "active";
            }
            if (code == FHIRDeviceStatus.INACTIVE) {
                return "inactive";
            }
            if (code == FHIRDeviceStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == FHIRDeviceStatus.UNKNOWN) {
                return "unknown";
            }
            return "?";
        }

        @Override
        public String toSystem(FHIRDeviceStatus code) {
            return code.getSystem();
        }
    }

    public static enum FHIRDeviceStatus {
        ACTIVE,
        INACTIVE,
        ENTEREDINERROR,
        UNKNOWN,
        NULL;


        public static FHIRDeviceStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("inactive".equals(codeString)) {
                return INACTIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown FHIRDeviceStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case INACTIVE: {
                    return "inactive";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case UNKNOWN: {
                    return "unknown";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/device-status";
                }
                case INACTIVE: {
                    return "http://hl7.org/fhir/device-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/device-status";
                }
                case UNKNOWN: {
                    return "http://hl7.org/fhir/device-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "The Device is available for use.  Note: This means for *implanted devices*  the device is implanted in the patient.";
                }
                case INACTIVE: {
                    return "The Device is no longer available for use (e.g. lost, expired, damaged).  Note: This means for *implanted devices*  the device has been removed from the patient.";
                }
                case ENTEREDINERROR: {
                    return "The Device was entered in error and voided.";
                }
                case UNKNOWN: {
                    return "The status of the device has not been determined.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case INACTIVE: {
                    return "Inactive";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case UNKNOWN: {
                    return "Unknown";
                }
            }
            return "?";
        }
    }

    public static class UDIEntryTypeEnumFactory
    implements EnumFactory<UDIEntryType> {
        @Override
        public UDIEntryType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("barcode".equals(codeString)) {
                return UDIEntryType.BARCODE;
            }
            if ("rfid".equals(codeString)) {
                return UDIEntryType.RFID;
            }
            if ("manual".equals(codeString)) {
                return UDIEntryType.MANUAL;
            }
            if ("card".equals(codeString)) {
                return UDIEntryType.CARD;
            }
            if ("self-reported".equals(codeString)) {
                return UDIEntryType.SELFREPORTED;
            }
            if ("unknown".equals(codeString)) {
                return UDIEntryType.UNKNOWN;
            }
            throw new IllegalArgumentException("Unknown UDIEntryType code '" + codeString + "'");
        }

        public Enumeration<UDIEntryType> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<UDIEntryType>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("barcode".equals(codeString)) {
                return new Enumeration<UDIEntryType>(this, UDIEntryType.BARCODE);
            }
            if ("rfid".equals(codeString)) {
                return new Enumeration<UDIEntryType>(this, UDIEntryType.RFID);
            }
            if ("manual".equals(codeString)) {
                return new Enumeration<UDIEntryType>(this, UDIEntryType.MANUAL);
            }
            if ("card".equals(codeString)) {
                return new Enumeration<UDIEntryType>(this, UDIEntryType.CARD);
            }
            if ("self-reported".equals(codeString)) {
                return new Enumeration<UDIEntryType>(this, UDIEntryType.SELFREPORTED);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<UDIEntryType>(this, UDIEntryType.UNKNOWN);
            }
            throw new FHIRException("Unknown UDIEntryType code '" + codeString + "'");
        }

        @Override
        public String toCode(UDIEntryType code) {
            if (code == UDIEntryType.BARCODE) {
                return "barcode";
            }
            if (code == UDIEntryType.RFID) {
                return "rfid";
            }
            if (code == UDIEntryType.MANUAL) {
                return "manual";
            }
            if (code == UDIEntryType.CARD) {
                return "card";
            }
            if (code == UDIEntryType.SELFREPORTED) {
                return "self-reported";
            }
            if (code == UDIEntryType.UNKNOWN) {
                return "unknown";
            }
            return "?";
        }

        @Override
        public String toSystem(UDIEntryType code) {
            return code.getSystem();
        }
    }

    public static enum UDIEntryType {
        BARCODE,
        RFID,
        MANUAL,
        CARD,
        SELFREPORTED,
        UNKNOWN,
        NULL;


        public static UDIEntryType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("barcode".equals(codeString)) {
                return BARCODE;
            }
            if ("rfid".equals(codeString)) {
                return RFID;
            }
            if ("manual".equals(codeString)) {
                return MANUAL;
            }
            if ("card".equals(codeString)) {
                return CARD;
            }
            if ("self-reported".equals(codeString)) {
                return SELFREPORTED;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown UDIEntryType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case BARCODE: {
                    return "barcode";
                }
                case RFID: {
                    return "rfid";
                }
                case MANUAL: {
                    return "manual";
                }
                case CARD: {
                    return "card";
                }
                case SELFREPORTED: {
                    return "self-reported";
                }
                case UNKNOWN: {
                    return "unknown";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case BARCODE: {
                    return "http://hl7.org/fhir/udi-entry-type";
                }
                case RFID: {
                    return "http://hl7.org/fhir/udi-entry-type";
                }
                case MANUAL: {
                    return "http://hl7.org/fhir/udi-entry-type";
                }
                case CARD: {
                    return "http://hl7.org/fhir/udi-entry-type";
                }
                case SELFREPORTED: {
                    return "http://hl7.org/fhir/udi-entry-type";
                }
                case UNKNOWN: {
                    return "http://hl7.org/fhir/udi-entry-type";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case BARCODE: {
                    return "A Barcode scanner captured the data from the device label";
                }
                case RFID: {
                    return "An RFID chip reader captured the data from the device label";
                }
                case MANUAL: {
                    return "The data was read from the label by a person and manually entered. (e.g.  via a keyboard)";
                }
                case CARD: {
                    return "The data originated from a patient's implant card and read by an operator.";
                }
                case SELFREPORTED: {
                    return "The data originated from a patient source and not directly scanned or read from a label or card.";
                }
                case UNKNOWN: {
                    return "The method of data capture has not been determined";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case BARCODE: {
                    return "BarCode";
                }
                case RFID: {
                    return "RFID";
                }
                case MANUAL: {
                    return "Manual";
                }
                case CARD: {
                    return "Card";
                }
                case SELFREPORTED: {
                    return "Self Reported";
                }
                case UNKNOWN: {
                    return "Unknown";
                }
            }
            return "?";
        }
    }
}

