/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu3.model.ActivityDefinition;
import org.hl7.fhir.dstu3.model.Annotation;
import org.hl7.fhir.dstu3.model.Appointment;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.BooleanType;
import org.hl7.fhir.dstu3.model.CareTeam;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.CommunicationRequest;
import org.hl7.fhir.dstu3.model.Condition;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.DeviceRequest;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.Encounter;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.EpisodeOfCare;
import org.hl7.fhir.dstu3.model.Goal;
import org.hl7.fhir.dstu3.model.Group;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Location;
import org.hl7.fhir.dstu3.model.Medication;
import org.hl7.fhir.dstu3.model.MedicationRequest;
import org.hl7.fhir.dstu3.model.NutritionOrder;
import org.hl7.fhir.dstu3.model.Organization;
import org.hl7.fhir.dstu3.model.Patient;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.PlanDefinition;
import org.hl7.fhir.dstu3.model.Practitioner;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.ProcedureRequest;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Questionnaire;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.ReferralRequest;
import org.hl7.fhir.dstu3.model.RelatedPerson;
import org.hl7.fhir.dstu3.model.RequestGroup;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.SimpleQuantity;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.Substance;
import org.hl7.fhir.dstu3.model.Task;
import org.hl7.fhir.dstu3.model.Timing;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.dstu3.model.VisionPrescription;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="CarePlan", profile="http://hl7.org/fhir/StructureDefinition/CarePlan")
public class CarePlan
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="External Ids for this plan", formalDefinition="This records identifiers associated with this care plan that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).")
    protected List<Identifier> identifier;
    @Child(name="definition", type={PlanDefinition.class, Questionnaire.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Protocol or definition", formalDefinition="Identifies the protocol, questionnaire, guideline or other specification the care plan should be conducted in accordance with.")
    protected List<Reference> definition;
    protected List<Resource> definitionTarget;
    @Child(name="basedOn", type={CarePlan.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Fulfills care plan", formalDefinition="A care plan that is fulfilled in whole or in part by this care plan.")
    protected List<Reference> basedOn;
    protected List<CarePlan> basedOnTarget;
    @Child(name="replaces", type={CarePlan.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="CarePlan replaced by this CarePlan", formalDefinition="Completed or terminated care plan whose function is taken by this new care plan.")
    protected List<Reference> replaces;
    protected List<CarePlan> replacesTarget;
    @Child(name="partOf", type={CarePlan.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Part of referenced CarePlan", formalDefinition="A larger care plan of which this particular care plan is a component or step.")
    protected List<Reference> partOf;
    protected List<CarePlan> partOfTarget;
    @Child(name="status", type={CodeType.class}, order=5, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | suspended | completed | entered-in-error | cancelled | unknown", formalDefinition="Indicates whether the plan is currently being acted upon, represents future intentions or is now a historical record.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/care-plan-status")
    protected Enumeration<CarePlanStatus> status;
    @Child(name="intent", type={CodeType.class}, order=6, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="proposal | plan | order | option", formalDefinition="Indicates the level of authority/intentionality associated with the care plan and where the care plan fits into the workflow chain.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/care-plan-intent")
    protected Enumeration<CarePlanIntent> intent;
    @Child(name="category", type={CodeableConcept.class}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Type of plan", formalDefinition="Identifies what \"kind\" of plan this is to support differentiation between multiple co-existing plans; e.g. \"Home health\", \"psychiatric\", \"asthma\", \"disease management\", \"wellness plan\", etc.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/care-plan-category")
    protected List<CodeableConcept> category;
    @Child(name="title", type={StringType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Human-friendly name for the CarePlan", formalDefinition="Human-friendly name for the CarePlan.")
    protected StringType title;
    @Child(name="description", type={StringType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Summary of nature of plan", formalDefinition="A description of the scope and nature of the plan.")
    protected StringType description;
    @Child(name="subject", type={Patient.class, Group.class}, order=10, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who care plan is for", formalDefinition="Identifies the patient or group whose intended care is described by the plan.")
    protected Reference subject;
    protected Resource subjectTarget;
    @Child(name="context", type={Encounter.class, EpisodeOfCare.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Created in context of", formalDefinition="Identifies the original context in which this particular CarePlan was created.")
    protected Reference context;
    protected Resource contextTarget;
    @Child(name="period", type={Period.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Time period plan covers", formalDefinition="Indicates when the plan did (or is intended to) come into effect and end.")
    protected Period period;
    @Child(name="author", type={Patient.class, Practitioner.class, RelatedPerson.class, Organization.class, CareTeam.class}, order=13, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Who is responsible for contents of the plan", formalDefinition="Identifies the individual(s) or ogranization who is responsible for the content of the care plan.")
    protected List<Reference> author;
    protected List<Resource> authorTarget;
    @Child(name="careTeam", type={CareTeam.class}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who's involved in plan?", formalDefinition="Identifies all people and organizations who are expected to be involved in the care envisioned by this plan.")
    protected List<Reference> careTeam;
    protected List<CareTeam> careTeamTarget;
    @Child(name="addresses", type={Condition.class}, order=15, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Health issues this plan addresses", formalDefinition="Identifies the conditions/problems/concerns/diagnoses/etc. whose management and/or mitigation are handled by this plan.")
    protected List<Reference> addresses;
    protected List<Condition> addressesTarget;
    @Child(name="supportingInfo", type={Reference.class}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Information considered as part of plan", formalDefinition="Identifies portions of the patient's record that specifically influenced the formation of the plan.  These might include co-morbidities, recent procedures, limitations, recent assessments, etc.")
    protected List<Reference> supportingInfo;
    protected List<Resource> supportingInfoTarget;
    @Child(name="goal", type={Goal.class}, order=17, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Desired outcome of plan", formalDefinition="Describes the intended objective(s) of carrying out the care plan.")
    protected List<Reference> goal;
    protected List<Goal> goalTarget;
    @Child(name="activity", type={}, order=18, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Action to occur as part of plan", formalDefinition="Identifies a planned action to occur as part of the plan.  For example, a medication to be used, lab tests to perform, self-monitoring, education, etc.")
    protected List<CarePlanActivityComponent> activity;
    @Child(name="note", type={Annotation.class}, order=19, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Comments about the plan", formalDefinition="General notes about the care plan not covered elsewhere.")
    protected List<Annotation> note;
    private static final long serialVersionUID = 995943625L;
    @SearchParamDefinition(name="date", path="CarePlan.period", description="Time period plan covers", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="care-team", path="CarePlan.careTeam", description="Who's involved in plan?", type="reference", target={CareTeam.class})
    public static final String SP_CARE_TEAM = "care-team";
    public static final ReferenceClientParam CARE_TEAM = new ReferenceClientParam("care-team");
    public static final Include INCLUDE_CARE_TEAM = new Include("CarePlan:care-team").toLocked();
    @SearchParamDefinition(name="identifier", path="CarePlan.identifier", description="External Ids for this plan", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="performer", path="CarePlan.activity.detail.performer", description="Matches if the practitioner is listed as a performer in any of the \"simple\" activities.  (For performers of the detailed activities, chain through the activitydetail search parameter.)", type="reference", providesMembershipIn={@Compartment(name="Patient"), @Compartment(name="Practitioner"), @Compartment(name="RelatedPerson")}, target={CareTeam.class, Organization.class, Patient.class, Practitioner.class, RelatedPerson.class})
    public static final String SP_PERFORMER = "performer";
    public static final ReferenceClientParam PERFORMER = new ReferenceClientParam("performer");
    public static final Include INCLUDE_PERFORMER = new Include("CarePlan:performer").toLocked();
    @SearchParamDefinition(name="goal", path="CarePlan.goal", description="Desired outcome of plan", type="reference", target={Goal.class})
    public static final String SP_GOAL = "goal";
    public static final ReferenceClientParam GOAL = new ReferenceClientParam("goal");
    public static final Include INCLUDE_GOAL = new Include("CarePlan:goal").toLocked();
    @SearchParamDefinition(name="subject", path="CarePlan.subject", description="Who care plan is for", type="reference", target={Group.class, Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("CarePlan:subject").toLocked();
    @SearchParamDefinition(name="replaces", path="CarePlan.replaces", description="CarePlan replaced by this CarePlan", type="reference", target={CarePlan.class})
    public static final String SP_REPLACES = "replaces";
    public static final ReferenceClientParam REPLACES = new ReferenceClientParam("replaces");
    public static final Include INCLUDE_REPLACES = new Include("CarePlan:replaces").toLocked();
    @SearchParamDefinition(name="part-of", path="CarePlan.partOf", description="Part of referenced CarePlan", type="reference", target={CarePlan.class})
    public static final String SP_PART_OF = "part-of";
    public static final ReferenceClientParam PART_OF = new ReferenceClientParam("part-of");
    public static final Include INCLUDE_PART_OF = new Include("CarePlan:part-of").toLocked();
    @SearchParamDefinition(name="encounter", path="CarePlan.context", description="Created in context of", type="reference", target={Encounter.class})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("CarePlan:encounter").toLocked();
    @SearchParamDefinition(name="intent", path="CarePlan.intent", description="proposal | plan | order | option", type="token")
    public static final String SP_INTENT = "intent";
    public static final TokenClientParam INTENT = new TokenClientParam("intent");
    @SearchParamDefinition(name="activity-reference", path="CarePlan.activity.reference", description="Activity details defined in specific resource", type="reference", target={Appointment.class, CommunicationRequest.class, DeviceRequest.class, MedicationRequest.class, NutritionOrder.class, ProcedureRequest.class, ReferralRequest.class, RequestGroup.class, Task.class, VisionPrescription.class})
    public static final String SP_ACTIVITY_REFERENCE = "activity-reference";
    public static final ReferenceClientParam ACTIVITY_REFERENCE = new ReferenceClientParam("activity-reference");
    public static final Include INCLUDE_ACTIVITY_REFERENCE = new Include("CarePlan:activity-reference").toLocked();
    @SearchParamDefinition(name="condition", path="CarePlan.addresses", description="Health issues this plan addresses", type="reference", target={Condition.class})
    public static final String SP_CONDITION = "condition";
    public static final ReferenceClientParam CONDITION = new ReferenceClientParam("condition");
    public static final Include INCLUDE_CONDITION = new Include("CarePlan:condition").toLocked();
    @SearchParamDefinition(name="based-on", path="CarePlan.basedOn", description="Fulfills care plan", type="reference", target={CarePlan.class})
    public static final String SP_BASED_ON = "based-on";
    public static final ReferenceClientParam BASED_ON = new ReferenceClientParam("based-on");
    public static final Include INCLUDE_BASED_ON = new Include("CarePlan:based-on").toLocked();
    @SearchParamDefinition(name="patient", path="CarePlan.subject", description="Who care plan is for", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("CarePlan:patient").toLocked();
    @SearchParamDefinition(name="context", path="CarePlan.context", description="Created in context of", type="reference", target={Encounter.class, EpisodeOfCare.class})
    public static final String SP_CONTEXT = "context";
    public static final ReferenceClientParam CONTEXT = new ReferenceClientParam("context");
    public static final Include INCLUDE_CONTEXT = new Include("CarePlan:context").toLocked();
    @SearchParamDefinition(name="activity-date", path="CarePlan.activity.detail.scheduled", description="Specified date occurs within period specified by CarePlan.activity.timingSchedule", type="date")
    public static final String SP_ACTIVITY_DATE = "activity-date";
    public static final DateClientParam ACTIVITY_DATE = new DateClientParam("activity-date");
    @SearchParamDefinition(name="definition", path="CarePlan.definition", description="Protocol or definition", type="reference", target={PlanDefinition.class, Questionnaire.class})
    public static final String SP_DEFINITION = "definition";
    public static final ReferenceClientParam DEFINITION = new ReferenceClientParam("definition");
    public static final Include INCLUDE_DEFINITION = new Include("CarePlan:definition").toLocked();
    @SearchParamDefinition(name="category", path="CarePlan.category", description="Type of plan", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="activity-code", path="CarePlan.activity.detail.code", description="Detail type of activity", type="token")
    public static final String SP_ACTIVITY_CODE = "activity-code";
    public static final TokenClientParam ACTIVITY_CODE = new TokenClientParam("activity-code");
    @SearchParamDefinition(name="status", path="CarePlan.status", description="draft | active | suspended | completed | entered-in-error | cancelled | unknown", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public CarePlan() {
    }

    public CarePlan(Enumeration<CarePlanStatus> status, Enumeration<CarePlanIntent> intent, Reference subject) {
        this.status = status;
        this.intent = intent;
        this.subject = subject;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public CarePlan setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public CarePlan addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<Reference> getDefinition() {
        if (this.definition == null) {
            this.definition = new ArrayList<Reference>();
        }
        return this.definition;
    }

    public CarePlan setDefinition(List<Reference> theDefinition) {
        this.definition = theDefinition;
        return this;
    }

    public boolean hasDefinition() {
        if (this.definition == null) {
            return false;
        }
        for (Reference item : this.definition) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addDefinition() {
        Reference t = new Reference();
        if (this.definition == null) {
            this.definition = new ArrayList<Reference>();
        }
        this.definition.add(t);
        return t;
    }

    public CarePlan addDefinition(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.definition == null) {
            this.definition = new ArrayList<Reference>();
        }
        this.definition.add(t);
        return this;
    }

    public Reference getDefinitionFirstRep() {
        if (this.getDefinition().isEmpty()) {
            this.addDefinition();
        }
        return this.getDefinition().get(0);
    }

    @Deprecated
    public List<Resource> getDefinitionTarget() {
        if (this.definitionTarget == null) {
            this.definitionTarget = new ArrayList<Resource>();
        }
        return this.definitionTarget;
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public CarePlan setBasedOn(List<Reference> theBasedOn) {
        this.basedOn = theBasedOn;
        return this;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public CarePlan addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public Reference getBasedOnFirstRep() {
        if (this.getBasedOn().isEmpty()) {
            this.addBasedOn();
        }
        return this.getBasedOn().get(0);
    }

    @Deprecated
    public List<CarePlan> getBasedOnTarget() {
        if (this.basedOnTarget == null) {
            this.basedOnTarget = new ArrayList<CarePlan>();
        }
        return this.basedOnTarget;
    }

    @Deprecated
    public CarePlan addBasedOnTarget() {
        CarePlan r = new CarePlan();
        if (this.basedOnTarget == null) {
            this.basedOnTarget = new ArrayList<CarePlan>();
        }
        this.basedOnTarget.add(r);
        return r;
    }

    public List<Reference> getReplaces() {
        if (this.replaces == null) {
            this.replaces = new ArrayList<Reference>();
        }
        return this.replaces;
    }

    public CarePlan setReplaces(List<Reference> theReplaces) {
        this.replaces = theReplaces;
        return this;
    }

    public boolean hasReplaces() {
        if (this.replaces == null) {
            return false;
        }
        for (Reference item : this.replaces) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addReplaces() {
        Reference t = new Reference();
        if (this.replaces == null) {
            this.replaces = new ArrayList<Reference>();
        }
        this.replaces.add(t);
        return t;
    }

    public CarePlan addReplaces(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.replaces == null) {
            this.replaces = new ArrayList<Reference>();
        }
        this.replaces.add(t);
        return this;
    }

    public Reference getReplacesFirstRep() {
        if (this.getReplaces().isEmpty()) {
            this.addReplaces();
        }
        return this.getReplaces().get(0);
    }

    @Deprecated
    public List<CarePlan> getReplacesTarget() {
        if (this.replacesTarget == null) {
            this.replacesTarget = new ArrayList<CarePlan>();
        }
        return this.replacesTarget;
    }

    @Deprecated
    public CarePlan addReplacesTarget() {
        CarePlan r = new CarePlan();
        if (this.replacesTarget == null) {
            this.replacesTarget = new ArrayList<CarePlan>();
        }
        this.replacesTarget.add(r);
        return r;
    }

    public List<Reference> getPartOf() {
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        return this.partOf;
    }

    public CarePlan setPartOf(List<Reference> thePartOf) {
        this.partOf = thePartOf;
        return this;
    }

    public boolean hasPartOf() {
        if (this.partOf == null) {
            return false;
        }
        for (Reference item : this.partOf) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPartOf() {
        Reference t = new Reference();
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return t;
    }

    public CarePlan addPartOf(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return this;
    }

    public Reference getPartOfFirstRep() {
        if (this.getPartOf().isEmpty()) {
            this.addPartOf();
        }
        return this.getPartOf().get(0);
    }

    @Deprecated
    public List<CarePlan> getPartOfTarget() {
        if (this.partOfTarget == null) {
            this.partOfTarget = new ArrayList<CarePlan>();
        }
        return this.partOfTarget;
    }

    @Deprecated
    public CarePlan addPartOfTarget() {
        CarePlan r = new CarePlan();
        if (this.partOfTarget == null) {
            this.partOfTarget = new ArrayList<CarePlan>();
        }
        this.partOfTarget.add(r);
        return r;
    }

    public Enumeration<CarePlanStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CarePlan.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<CarePlanStatus>(new CarePlanStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public CarePlan setStatusElement(Enumeration<CarePlanStatus> value) {
        this.status = value;
        return this;
    }

    public CarePlanStatus getStatus() {
        return this.status == null ? null : (CarePlanStatus)((Object)this.status.getValue());
    }

    public CarePlan setStatus(CarePlanStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<CarePlanStatus>(new CarePlanStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public Enumeration<CarePlanIntent> getIntentElement() {
        if (this.intent == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CarePlan.intent");
            }
            if (Configuration.doAutoCreate()) {
                this.intent = new Enumeration<CarePlanIntent>(new CarePlanIntentEnumFactory());
            }
        }
        return this.intent;
    }

    public boolean hasIntentElement() {
        return this.intent != null && !this.intent.isEmpty();
    }

    public boolean hasIntent() {
        return this.intent != null && !this.intent.isEmpty();
    }

    public CarePlan setIntentElement(Enumeration<CarePlanIntent> value) {
        this.intent = value;
        return this;
    }

    public CarePlanIntent getIntent() {
        return this.intent == null ? null : (CarePlanIntent)((Object)this.intent.getValue());
    }

    public CarePlan setIntent(CarePlanIntent value) {
        if (this.intent == null) {
            this.intent = new Enumeration<CarePlanIntent>(new CarePlanIntentEnumFactory());
        }
        this.intent.setValue((Object)value);
        return this;
    }

    public List<CodeableConcept> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        return this.category;
    }

    public CarePlan setCategory(List<CodeableConcept> theCategory) {
        this.category = theCategory;
        return this;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (CodeableConcept item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return t;
    }

    public CarePlan addCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return this;
    }

    public CodeableConcept getCategoryFirstRep() {
        if (this.getCategory().isEmpty()) {
            this.addCategory();
        }
        return this.getCategory().get(0);
    }

    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CarePlan.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    public CarePlan setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    public CarePlan setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CarePlan.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public CarePlan setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public CarePlan setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CarePlan.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public CarePlan setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public CarePlan setSubjectTarget(Resource value) {
        this.subjectTarget = value;
        return this;
    }

    public Reference getContext() {
        if (this.context == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CarePlan.context");
            }
            if (Configuration.doAutoCreate()) {
                this.context = new Reference();
            }
        }
        return this.context;
    }

    public boolean hasContext() {
        return this.context != null && !this.context.isEmpty();
    }

    public CarePlan setContext(Reference value) {
        this.context = value;
        return this;
    }

    public Resource getContextTarget() {
        return this.contextTarget;
    }

    public CarePlan setContextTarget(Resource value) {
        this.contextTarget = value;
        return this;
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CarePlan.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public CarePlan setPeriod(Period value) {
        this.period = value;
        return this;
    }

    public List<Reference> getAuthor() {
        if (this.author == null) {
            this.author = new ArrayList<Reference>();
        }
        return this.author;
    }

    public CarePlan setAuthor(List<Reference> theAuthor) {
        this.author = theAuthor;
        return this;
    }

    public boolean hasAuthor() {
        if (this.author == null) {
            return false;
        }
        for (Reference item : this.author) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addAuthor() {
        Reference t = new Reference();
        if (this.author == null) {
            this.author = new ArrayList<Reference>();
        }
        this.author.add(t);
        return t;
    }

    public CarePlan addAuthor(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.author == null) {
            this.author = new ArrayList<Reference>();
        }
        this.author.add(t);
        return this;
    }

    public Reference getAuthorFirstRep() {
        if (this.getAuthor().isEmpty()) {
            this.addAuthor();
        }
        return this.getAuthor().get(0);
    }

    @Deprecated
    public List<Resource> getAuthorTarget() {
        if (this.authorTarget == null) {
            this.authorTarget = new ArrayList<Resource>();
        }
        return this.authorTarget;
    }

    public List<Reference> getCareTeam() {
        if (this.careTeam == null) {
            this.careTeam = new ArrayList<Reference>();
        }
        return this.careTeam;
    }

    public CarePlan setCareTeam(List<Reference> theCareTeam) {
        this.careTeam = theCareTeam;
        return this;
    }

    public boolean hasCareTeam() {
        if (this.careTeam == null) {
            return false;
        }
        for (Reference item : this.careTeam) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addCareTeam() {
        Reference t = new Reference();
        if (this.careTeam == null) {
            this.careTeam = new ArrayList<Reference>();
        }
        this.careTeam.add(t);
        return t;
    }

    public CarePlan addCareTeam(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.careTeam == null) {
            this.careTeam = new ArrayList<Reference>();
        }
        this.careTeam.add(t);
        return this;
    }

    public Reference getCareTeamFirstRep() {
        if (this.getCareTeam().isEmpty()) {
            this.addCareTeam();
        }
        return this.getCareTeam().get(0);
    }

    @Deprecated
    public List<CareTeam> getCareTeamTarget() {
        if (this.careTeamTarget == null) {
            this.careTeamTarget = new ArrayList<CareTeam>();
        }
        return this.careTeamTarget;
    }

    @Deprecated
    public CareTeam addCareTeamTarget() {
        CareTeam r = new CareTeam();
        if (this.careTeamTarget == null) {
            this.careTeamTarget = new ArrayList<CareTeam>();
        }
        this.careTeamTarget.add(r);
        return r;
    }

    public List<Reference> getAddresses() {
        if (this.addresses == null) {
            this.addresses = new ArrayList<Reference>();
        }
        return this.addresses;
    }

    public CarePlan setAddresses(List<Reference> theAddresses) {
        this.addresses = theAddresses;
        return this;
    }

    public boolean hasAddresses() {
        if (this.addresses == null) {
            return false;
        }
        for (Reference item : this.addresses) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addAddresses() {
        Reference t = new Reference();
        if (this.addresses == null) {
            this.addresses = new ArrayList<Reference>();
        }
        this.addresses.add(t);
        return t;
    }

    public CarePlan addAddresses(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.addresses == null) {
            this.addresses = new ArrayList<Reference>();
        }
        this.addresses.add(t);
        return this;
    }

    public Reference getAddressesFirstRep() {
        if (this.getAddresses().isEmpty()) {
            this.addAddresses();
        }
        return this.getAddresses().get(0);
    }

    @Deprecated
    public List<Condition> getAddressesTarget() {
        if (this.addressesTarget == null) {
            this.addressesTarget = new ArrayList<Condition>();
        }
        return this.addressesTarget;
    }

    @Deprecated
    public Condition addAddressesTarget() {
        Condition r = new Condition();
        if (this.addressesTarget == null) {
            this.addressesTarget = new ArrayList<Condition>();
        }
        this.addressesTarget.add(r);
        return r;
    }

    public List<Reference> getSupportingInfo() {
        if (this.supportingInfo == null) {
            this.supportingInfo = new ArrayList<Reference>();
        }
        return this.supportingInfo;
    }

    public CarePlan setSupportingInfo(List<Reference> theSupportingInfo) {
        this.supportingInfo = theSupportingInfo;
        return this;
    }

    public boolean hasSupportingInfo() {
        if (this.supportingInfo == null) {
            return false;
        }
        for (Reference item : this.supportingInfo) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSupportingInfo() {
        Reference t = new Reference();
        if (this.supportingInfo == null) {
            this.supportingInfo = new ArrayList<Reference>();
        }
        this.supportingInfo.add(t);
        return t;
    }

    public CarePlan addSupportingInfo(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.supportingInfo == null) {
            this.supportingInfo = new ArrayList<Reference>();
        }
        this.supportingInfo.add(t);
        return this;
    }

    public Reference getSupportingInfoFirstRep() {
        if (this.getSupportingInfo().isEmpty()) {
            this.addSupportingInfo();
        }
        return this.getSupportingInfo().get(0);
    }

    @Deprecated
    public List<Resource> getSupportingInfoTarget() {
        if (this.supportingInfoTarget == null) {
            this.supportingInfoTarget = new ArrayList<Resource>();
        }
        return this.supportingInfoTarget;
    }

    public List<Reference> getGoal() {
        if (this.goal == null) {
            this.goal = new ArrayList<Reference>();
        }
        return this.goal;
    }

    public CarePlan setGoal(List<Reference> theGoal) {
        this.goal = theGoal;
        return this;
    }

    public boolean hasGoal() {
        if (this.goal == null) {
            return false;
        }
        for (Reference item : this.goal) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addGoal() {
        Reference t = new Reference();
        if (this.goal == null) {
            this.goal = new ArrayList<Reference>();
        }
        this.goal.add(t);
        return t;
    }

    public CarePlan addGoal(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.goal == null) {
            this.goal = new ArrayList<Reference>();
        }
        this.goal.add(t);
        return this;
    }

    public Reference getGoalFirstRep() {
        if (this.getGoal().isEmpty()) {
            this.addGoal();
        }
        return this.getGoal().get(0);
    }

    @Deprecated
    public List<Goal> getGoalTarget() {
        if (this.goalTarget == null) {
            this.goalTarget = new ArrayList<Goal>();
        }
        return this.goalTarget;
    }

    @Deprecated
    public Goal addGoalTarget() {
        Goal r = new Goal();
        if (this.goalTarget == null) {
            this.goalTarget = new ArrayList<Goal>();
        }
        this.goalTarget.add(r);
        return r;
    }

    public List<CarePlanActivityComponent> getActivity() {
        if (this.activity == null) {
            this.activity = new ArrayList<CarePlanActivityComponent>();
        }
        return this.activity;
    }

    public CarePlan setActivity(List<CarePlanActivityComponent> theActivity) {
        this.activity = theActivity;
        return this;
    }

    public boolean hasActivity() {
        if (this.activity == null) {
            return false;
        }
        for (CarePlanActivityComponent item : this.activity) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CarePlanActivityComponent addActivity() {
        CarePlanActivityComponent t = new CarePlanActivityComponent();
        if (this.activity == null) {
            this.activity = new ArrayList<CarePlanActivityComponent>();
        }
        this.activity.add(t);
        return t;
    }

    public CarePlan addActivity(CarePlanActivityComponent t) {
        if (t == null) {
            return this;
        }
        if (this.activity == null) {
            this.activity = new ArrayList<CarePlanActivityComponent>();
        }
        this.activity.add(t);
        return this;
    }

    public CarePlanActivityComponent getActivityFirstRep() {
        if (this.getActivity().isEmpty()) {
            this.addActivity();
        }
        return this.getActivity().get(0);
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public CarePlan setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public CarePlan addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "This records identifiers associated with this care plan that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_DEFINITION, "Reference(PlanDefinition|Questionnaire)", "Identifies the protocol, questionnaire, guideline or other specification the care plan should be conducted in accordance with.", 0, Integer.MAX_VALUE, this.definition));
        children.add(new Property("basedOn", "Reference(CarePlan)", "A care plan that is fulfilled in whole or in part by this care plan.", 0, Integer.MAX_VALUE, this.basedOn));
        children.add(new Property(SP_REPLACES, "Reference(CarePlan)", "Completed or terminated care plan whose function is taken by this new care plan.", 0, Integer.MAX_VALUE, this.replaces));
        children.add(new Property("partOf", "Reference(CarePlan)", "A larger care plan of which this particular care plan is a component or step.", 0, Integer.MAX_VALUE, this.partOf));
        children.add(new Property(SP_STATUS, "code", "Indicates whether the plan is currently being acted upon, represents future intentions or is now a historical record.", 0, 1, this.status));
        children.add(new Property(SP_INTENT, "code", "Indicates the level of authority/intentionality associated with the care plan and where the care plan fits into the workflow chain.", 0, 1, this.intent));
        children.add(new Property(SP_CATEGORY, "CodeableConcept", "Identifies what \"kind\" of plan this is to support differentiation between multiple co-existing plans; e.g. \"Home health\", \"psychiatric\", \"asthma\", \"disease management\", \"wellness plan\", etc.", 0, Integer.MAX_VALUE, this.category));
        children.add(new Property("title", "string", "Human-friendly name for the CarePlan.", 0, 1, this.title));
        children.add(new Property("description", "string", "A description of the scope and nature of the plan.", 0, 1, this.description));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group)", "Identifies the patient or group whose intended care is described by the plan.", 0, 1, this.subject));
        children.add(new Property(SP_CONTEXT, "Reference(Encounter|EpisodeOfCare)", "Identifies the original context in which this particular CarePlan was created.", 0, 1, this.context));
        children.add(new Property("period", "Period", "Indicates when the plan did (or is intended to) come into effect and end.", 0, 1, this.period));
        children.add(new Property("author", "Reference(Patient|Practitioner|RelatedPerson|Organization|CareTeam)", "Identifies the individual(s) or ogranization who is responsible for the content of the care plan.", 0, Integer.MAX_VALUE, this.author));
        children.add(new Property("careTeam", "Reference(CareTeam)", "Identifies all people and organizations who are expected to be involved in the care envisioned by this plan.", 0, Integer.MAX_VALUE, this.careTeam));
        children.add(new Property("addresses", "Reference(Condition)", "Identifies the conditions/problems/concerns/diagnoses/etc. whose management and/or mitigation are handled by this plan.", 0, Integer.MAX_VALUE, this.addresses));
        children.add(new Property("supportingInfo", "Reference(Any)", "Identifies portions of the patient's record that specifically influenced the formation of the plan.  These might include co-morbidities, recent procedures, limitations, recent assessments, etc.", 0, Integer.MAX_VALUE, this.supportingInfo));
        children.add(new Property(SP_GOAL, "Reference(Goal)", "Describes the intended objective(s) of carrying out the care plan.", 0, Integer.MAX_VALUE, this.goal));
        children.add(new Property("activity", "", "Identifies a planned action to occur as part of the plan.  For example, a medication to be used, lab tests to perform, self-monitoring, education, etc.", 0, Integer.MAX_VALUE, this.activity));
        children.add(new Property("note", "Annotation", "General notes about the care plan not covered elsewhere.", 0, Integer.MAX_VALUE, this.note));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "This records identifiers associated with this care plan that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -1014418093: {
                return new Property(SP_DEFINITION, "Reference(PlanDefinition|Questionnaire)", "Identifies the protocol, questionnaire, guideline or other specification the care plan should be conducted in accordance with.", 0, Integer.MAX_VALUE, this.definition);
            }
            case -332612366: {
                return new Property("basedOn", "Reference(CarePlan)", "A care plan that is fulfilled in whole or in part by this care plan.", 0, Integer.MAX_VALUE, this.basedOn);
            }
            case -430332865: {
                return new Property(SP_REPLACES, "Reference(CarePlan)", "Completed or terminated care plan whose function is taken by this new care plan.", 0, Integer.MAX_VALUE, this.replaces);
            }
            case -995410646: {
                return new Property("partOf", "Reference(CarePlan)", "A larger care plan of which this particular care plan is a component or step.", 0, Integer.MAX_VALUE, this.partOf);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "Indicates whether the plan is currently being acted upon, represents future intentions or is now a historical record.", 0, 1, this.status);
            }
            case -1183762788: {
                return new Property(SP_INTENT, "code", "Indicates the level of authority/intentionality associated with the care plan and where the care plan fits into the workflow chain.", 0, 1, this.intent);
            }
            case 50511102: {
                return new Property(SP_CATEGORY, "CodeableConcept", "Identifies what \"kind\" of plan this is to support differentiation between multiple co-existing plans; e.g. \"Home health\", \"psychiatric\", \"asthma\", \"disease management\", \"wellness plan\", etc.", 0, Integer.MAX_VALUE, this.category);
            }
            case 110371416: {
                return new Property("title", "string", "Human-friendly name for the CarePlan.", 0, 1, this.title);
            }
            case -1724546052: {
                return new Property("description", "string", "A description of the scope and nature of the plan.", 0, 1, this.description);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group)", "Identifies the patient or group whose intended care is described by the plan.", 0, 1, this.subject);
            }
            case 951530927: {
                return new Property(SP_CONTEXT, "Reference(Encounter|EpisodeOfCare)", "Identifies the original context in which this particular CarePlan was created.", 0, 1, this.context);
            }
            case -991726143: {
                return new Property("period", "Period", "Indicates when the plan did (or is intended to) come into effect and end.", 0, 1, this.period);
            }
            case -1406328437: {
                return new Property("author", "Reference(Patient|Practitioner|RelatedPerson|Organization|CareTeam)", "Identifies the individual(s) or ogranization who is responsible for the content of the care plan.", 0, Integer.MAX_VALUE, this.author);
            }
            case -7323378: {
                return new Property("careTeam", "Reference(CareTeam)", "Identifies all people and organizations who are expected to be involved in the care envisioned by this plan.", 0, Integer.MAX_VALUE, this.careTeam);
            }
            case 874544034: {
                return new Property("addresses", "Reference(Condition)", "Identifies the conditions/problems/concerns/diagnoses/etc. whose management and/or mitigation are handled by this plan.", 0, Integer.MAX_VALUE, this.addresses);
            }
            case 1922406657: {
                return new Property("supportingInfo", "Reference(Any)", "Identifies portions of the patient's record that specifically influenced the formation of the plan.  These might include co-morbidities, recent procedures, limitations, recent assessments, etc.", 0, Integer.MAX_VALUE, this.supportingInfo);
            }
            case 3178259: {
                return new Property(SP_GOAL, "Reference(Goal)", "Describes the intended objective(s) of carrying out the care plan.", 0, Integer.MAX_VALUE, this.goal);
            }
            case -1655966961: {
                return new Property("activity", "", "Identifies a planned action to occur as part of the plan.  For example, a medication to be used, lab tests to perform, self-monitoring, education, etc.", 0, Integer.MAX_VALUE, this.activity);
            }
            case 3387378: {
                return new Property("note", "Annotation", "General notes about the care plan not covered elsewhere.", 0, Integer.MAX_VALUE, this.note);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -1014418093: {
                return this.definition == null ? new Base[]{} : this.definition.toArray(new Base[this.definition.size()]);
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case -430332865: {
                return this.replaces == null ? new Base[]{} : this.replaces.toArray(new Base[this.replaces.size()]);
            }
            case -995410646: {
                return this.partOf == null ? new Base[]{} : this.partOf.toArray(new Base[this.partOf.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case -1183762788: {
                Base[] baseArray;
                if (this.intent == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.intent;
                }
                return baseArray;
            }
            case 50511102: {
                return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.title;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.description;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.subject;
                }
                return baseArray;
            }
            case 951530927: {
                Base[] baseArray;
                if (this.context == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.context;
                }
                return baseArray;
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.period;
                }
                return baseArray;
            }
            case -1406328437: {
                return this.author == null ? new Base[]{} : this.author.toArray(new Base[this.author.size()]);
            }
            case -7323378: {
                return this.careTeam == null ? new Base[]{} : this.careTeam.toArray(new Base[this.careTeam.size()]);
            }
            case 874544034: {
                return this.addresses == null ? new Base[]{} : this.addresses.toArray(new Base[this.addresses.size()]);
            }
            case 1922406657: {
                return this.supportingInfo == null ? new Base[]{} : this.supportingInfo.toArray(new Base[this.supportingInfo.size()]);
            }
            case 3178259: {
                return this.goal == null ? new Base[]{} : this.goal.toArray(new Base[this.goal.size()]);
            }
            case -1655966961: {
                return this.activity == null ? new Base[]{} : this.activity.toArray(new Base[this.activity.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -1014418093: {
                this.getDefinition().add(this.castToReference(value));
                return value;
            }
            case -332612366: {
                this.getBasedOn().add(this.castToReference(value));
                return value;
            }
            case -430332865: {
                this.getReplaces().add(this.castToReference(value));
                return value;
            }
            case -995410646: {
                this.getPartOf().add(this.castToReference(value));
                return value;
            }
            case -892481550: {
                value = new CarePlanStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case -1183762788: {
                value = new CarePlanIntentEnumFactory().fromType(this.castToCode(value));
                this.intent = value;
                return value;
            }
            case 50511102: {
                this.getCategory().add(this.castToCodeableConcept(value));
                return value;
            }
            case 110371416: {
                this.title = this.castToString(value);
                return value;
            }
            case -1724546052: {
                this.description = this.castToString(value);
                return value;
            }
            case -1867885268: {
                this.subject = this.castToReference(value);
                return value;
            }
            case 951530927: {
                this.context = this.castToReference(value);
                return value;
            }
            case -991726143: {
                this.period = this.castToPeriod(value);
                return value;
            }
            case -1406328437: {
                this.getAuthor().add(this.castToReference(value));
                return value;
            }
            case -7323378: {
                this.getCareTeam().add(this.castToReference(value));
                return value;
            }
            case 874544034: {
                this.getAddresses().add(this.castToReference(value));
                return value;
            }
            case 1922406657: {
                this.getSupportingInfo().add(this.castToReference(value));
                return value;
            }
            case 3178259: {
                this.getGoal().add(this.castToReference(value));
                return value;
            }
            case -1655966961: {
                this.getActivity().add((CarePlanActivityComponent)((Object)value));
                return value;
            }
            case 3387378: {
                this.getNote().add(this.castToAnnotation(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_DEFINITION)) {
            this.getDefinition().add(this.castToReference(value));
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(this.castToReference(value));
        } else if (name.equals(SP_REPLACES)) {
            this.getReplaces().add(this.castToReference(value));
        } else if (name.equals("partOf")) {
            this.getPartOf().add(this.castToReference(value));
        } else if (name.equals(SP_STATUS)) {
            value = new CarePlanStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_INTENT)) {
            value = new CarePlanIntentEnumFactory().fromType(this.castToCode(value));
            this.intent = value;
        } else if (name.equals(SP_CATEGORY)) {
            this.getCategory().add(this.castToCodeableConcept(value));
        } else if (name.equals("title")) {
            this.title = this.castToString(value);
        } else if (name.equals("description")) {
            this.description = this.castToString(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals(SP_CONTEXT)) {
            this.context = this.castToReference(value);
        } else if (name.equals("period")) {
            this.period = this.castToPeriod(value);
        } else if (name.equals("author")) {
            this.getAuthor().add(this.castToReference(value));
        } else if (name.equals("careTeam")) {
            this.getCareTeam().add(this.castToReference(value));
        } else if (name.equals("addresses")) {
            this.getAddresses().add(this.castToReference(value));
        } else if (name.equals("supportingInfo")) {
            this.getSupportingInfo().add(this.castToReference(value));
        } else if (name.equals(SP_GOAL)) {
            this.getGoal().add(this.castToReference(value));
        } else if (name.equals("activity")) {
            this.getActivity().add((CarePlanActivityComponent)((Object)value));
        } else if (name.equals("note")) {
            this.getNote().add(this.castToAnnotation(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -1014418093: {
                return this.addDefinition();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case -430332865: {
                return this.addReplaces();
            }
            case -995410646: {
                return this.addPartOf();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -1183762788: {
                return this.getIntentElement();
            }
            case 50511102: {
                return this.addCategory();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 951530927: {
                return this.getContext();
            }
            case -991726143: {
                return this.getPeriod();
            }
            case -1406328437: {
                return this.addAuthor();
            }
            case -7323378: {
                return this.addCareTeam();
            }
            case 874544034: {
                return this.addAddresses();
            }
            case 1922406657: {
                return this.addSupportingInfo();
            }
            case 3178259: {
                return this.addGoal();
            }
            case -1655966961: {
                return this.addActivity();
            }
            case 3387378: {
                return this.addNote();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -1014418093: {
                return new String[]{"Reference"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case -430332865: {
                return new String[]{"Reference"};
            }
            case -995410646: {
                return new String[]{"Reference"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -1183762788: {
                return new String[]{"code"};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case -1724546052: {
                return new String[]{"string"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 951530927: {
                return new String[]{"Reference"};
            }
            case -991726143: {
                return new String[]{"Period"};
            }
            case -1406328437: {
                return new String[]{"Reference"};
            }
            case -7323378: {
                return new String[]{"Reference"};
            }
            case 874544034: {
                return new String[]{"Reference"};
            }
            case 1922406657: {
                return new String[]{"Reference"};
            }
            case 3178259: {
                return new String[]{"Reference"};
            }
            case -1655966961: {
                return new String[0];
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_DEFINITION)) {
            return this.addDefinition();
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals(SP_REPLACES)) {
            return this.addReplaces();
        }
        if (name.equals("partOf")) {
            return this.addPartOf();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type CarePlan.status");
        }
        if (name.equals(SP_INTENT)) {
            throw new FHIRException("Cannot call addChild on a primitive type CarePlan.intent");
        }
        if (name.equals(SP_CATEGORY)) {
            return this.addCategory();
        }
        if (name.equals("title")) {
            throw new FHIRException("Cannot call addChild on a primitive type CarePlan.title");
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type CarePlan.description");
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_CONTEXT)) {
            this.context = new Reference();
            return this.context;
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        if (name.equals("author")) {
            return this.addAuthor();
        }
        if (name.equals("careTeam")) {
            return this.addCareTeam();
        }
        if (name.equals("addresses")) {
            return this.addAddresses();
        }
        if (name.equals("supportingInfo")) {
            return this.addSupportingInfo();
        }
        if (name.equals(SP_GOAL)) {
            return this.addGoal();
        }
        if (name.equals("activity")) {
            return this.addActivity();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "CarePlan";
    }

    @Override
    public CarePlan copy() {
        CarePlan dst = new CarePlan();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.definition != null) {
            dst.definition = new ArrayList<Reference>();
            for (Reference reference : this.definition) {
                dst.definition.add(reference.copy());
            }
        }
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference reference : this.basedOn) {
                dst.basedOn.add(reference.copy());
            }
        }
        if (this.replaces != null) {
            dst.replaces = new ArrayList<Reference>();
            for (Reference reference : this.replaces) {
                dst.replaces.add(reference.copy());
            }
        }
        if (this.partOf != null) {
            dst.partOf = new ArrayList<Reference>();
            for (Reference reference : this.partOf) {
                dst.partOf.add(reference.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        Enumeration<CarePlanIntent> enumeration = dst.intent = this.intent == null ? null : this.intent.copy();
        if (this.category != null) {
            dst.category = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.category) {
                dst.category.add(codeableConcept.copy());
            }
        }
        dst.title = this.title == null ? null : this.title.copy();
        dst.description = this.description == null ? null : this.description.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.context = this.context == null ? null : this.context.copy();
        Period period = dst.period = this.period == null ? null : this.period.copy();
        if (this.author != null) {
            dst.author = new ArrayList<Reference>();
            for (Reference reference : this.author) {
                dst.author.add(reference.copy());
            }
        }
        if (this.careTeam != null) {
            dst.careTeam = new ArrayList<Reference>();
            for (Reference reference : this.careTeam) {
                dst.careTeam.add(reference.copy());
            }
        }
        if (this.addresses != null) {
            dst.addresses = new ArrayList<Reference>();
            for (Reference reference : this.addresses) {
                dst.addresses.add(reference.copy());
            }
        }
        if (this.supportingInfo != null) {
            dst.supportingInfo = new ArrayList<Reference>();
            for (Reference reference : this.supportingInfo) {
                dst.supportingInfo.add(reference.copy());
            }
        }
        if (this.goal != null) {
            dst.goal = new ArrayList<Reference>();
            for (Reference reference : this.goal) {
                dst.goal.add(reference.copy());
            }
        }
        if (this.activity != null) {
            dst.activity = new ArrayList<CarePlanActivityComponent>();
            for (CarePlanActivityComponent carePlanActivityComponent : this.activity) {
                dst.activity.add(carePlanActivityComponent.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        return dst;
    }

    protected CarePlan typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof CarePlan)) {
            return false;
        }
        CarePlan o = (CarePlan)other_;
        return CarePlan.compareDeep(this.identifier, o.identifier, true) && CarePlan.compareDeep(this.definition, o.definition, true) && CarePlan.compareDeep(this.basedOn, o.basedOn, true) && CarePlan.compareDeep(this.replaces, o.replaces, true) && CarePlan.compareDeep(this.partOf, o.partOf, true) && CarePlan.compareDeep(this.status, o.status, true) && CarePlan.compareDeep(this.intent, o.intent, true) && CarePlan.compareDeep(this.category, o.category, true) && CarePlan.compareDeep(this.title, o.title, true) && CarePlan.compareDeep(this.description, o.description, true) && CarePlan.compareDeep(this.subject, o.subject, true) && CarePlan.compareDeep(this.context, o.context, true) && CarePlan.compareDeep(this.period, o.period, true) && CarePlan.compareDeep(this.author, o.author, true) && CarePlan.compareDeep(this.careTeam, o.careTeam, true) && CarePlan.compareDeep(this.addresses, o.addresses, true) && CarePlan.compareDeep(this.supportingInfo, o.supportingInfo, true) && CarePlan.compareDeep(this.goal, o.goal, true) && CarePlan.compareDeep(this.activity, o.activity, true) && CarePlan.compareDeep(this.note, o.note, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof CarePlan)) {
            return false;
        }
        CarePlan o = (CarePlan)other_;
        return CarePlan.compareValues(this.status, o.status, true) && CarePlan.compareValues(this.intent, o.intent, true) && CarePlan.compareValues(this.title, o.title, true) && CarePlan.compareValues(this.description, o.description, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.definition, this.basedOn, this.replaces, this.partOf, this.status, this.intent, this.category, this.title, this.description, this.subject, this.context, this.period, this.author, this.careTeam, this.addresses, this.supportingInfo, this.goal, this.activity, this.note});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.CarePlan;
    }

    @Block
    public static class CarePlanActivityDetailComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="category", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="diet | drug | encounter | observation | procedure | supply | other", formalDefinition="High-level categorization of the type of activity in a care plan.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/care-plan-activity-category")
        protected CodeableConcept category;
        @Child(name="definition", type={PlanDefinition.class, ActivityDefinition.class, Questionnaire.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Protocol or definition", formalDefinition="Identifies the protocol, questionnaire, guideline or other specification the planned activity should be conducted in accordance with.")
        protected Reference definition;
        protected Resource definitionTarget;
        @Child(name="code", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Detail type of activity", formalDefinition="Detailed description of the type of planned activity; e.g. What lab test, what procedure, what kind of encounter.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/care-plan-activity")
        protected CodeableConcept code;
        @Child(name="reasonCode", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Why activity should be done or why activity was prohibited", formalDefinition="Provides the rationale that drove the inclusion of this particular activity as part of the plan or the reason why the activity was prohibited.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/activity-reason")
        protected List<CodeableConcept> reasonCode;
        @Child(name="reasonReference", type={Condition.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Condition triggering need for activity", formalDefinition="Provides the health condition(s) that drove the inclusion of this particular activity as part of the plan.")
        protected List<Reference> reasonReference;
        protected List<Condition> reasonReferenceTarget;
        @Child(name="goal", type={Goal.class}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Goals this activity relates to", formalDefinition="Internal reference that identifies the goals that this activity is intended to contribute towards meeting.")
        protected List<Reference> goal;
        protected List<Goal> goalTarget;
        @Child(name="status", type={CodeType.class}, order=7, min=1, max=1, modifier=true, summary=false)
        @Description(shortDefinition="not-started | scheduled | in-progress | on-hold | completed | cancelled | unknown", formalDefinition="Identifies what progress is being made for the specific activity.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/care-plan-activity-status")
        protected Enumeration<CarePlanActivityStatus> status;
        @Child(name="statusReason", type={StringType.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reason for current status", formalDefinition="Provides reason why the activity isn't yet started, is on hold, was cancelled, etc.")
        protected StringType statusReason;
        @Child(name="prohibited", type={BooleanType.class}, order=9, min=0, max=1, modifier=true, summary=false)
        @Description(shortDefinition="Do NOT do", formalDefinition="If true, indicates that the described activity is one that must NOT be engaged in when following the plan.  If false, indicates that the described activity is one that should be engaged in when following the plan.")
        protected BooleanType prohibited;
        @Child(name="scheduled", type={Timing.class, Period.class, StringType.class}, order=10, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When activity is to occur", formalDefinition="The period, timing or frequency upon which the described activity is to occur.")
        protected Type scheduled;
        @Child(name="location", type={Location.class}, order=11, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Where it should happen", formalDefinition="Identifies the facility where the activity will occur; e.g. home, hospital, specific clinic, etc.")
        protected Reference location;
        protected Location locationTarget;
        @Child(name="performer", type={Practitioner.class, Organization.class, RelatedPerson.class, Patient.class, CareTeam.class}, order=12, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Who will be responsible?", formalDefinition="Identifies who's expected to be involved in the activity.")
        protected List<Reference> performer;
        protected List<Resource> performerTarget;
        @Child(name="product", type={CodeableConcept.class, Medication.class, Substance.class}, order=13, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What is to be administered/supplied", formalDefinition="Identifies the food, drug or other product to be consumed or supplied in the activity.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-codes")
        protected Type product;
        @Child(name="dailyAmount", type={SimpleQuantity.class}, order=14, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="How to consume/day?", formalDefinition="Identifies the quantity expected to be consumed in a given day.")
        protected SimpleQuantity dailyAmount;
        @Child(name="quantity", type={SimpleQuantity.class}, order=15, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="How much to administer/supply/consume", formalDefinition="Identifies the quantity expected to be supplied, administered or consumed by the subject.")
        protected SimpleQuantity quantity;
        @Child(name="description", type={StringType.class}, order=16, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Extra info describing activity to perform", formalDefinition="This provides a textual description of constraints on the intended activity occurrence, including relation to other activities.  It may also include objectives, pre-conditions and end-conditions.  Finally, it may convey specifics about the activity such as body site, method, route, etc.")
        protected StringType description;
        private static final long serialVersionUID = -549984462L;

        public CarePlanActivityDetailComponent() {
        }

        public CarePlanActivityDetailComponent(Enumeration<CarePlanActivityStatus> status) {
            this.status = status;
        }

        public CodeableConcept getCategory() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CarePlanActivityDetailComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new CodeableConcept();
                }
            }
            return this.category;
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public CarePlanActivityDetailComponent setCategory(CodeableConcept value) {
            this.category = value;
            return this;
        }

        public Reference getDefinition() {
            if (this.definition == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CarePlanActivityDetailComponent.definition");
                }
                if (Configuration.doAutoCreate()) {
                    this.definition = new Reference();
                }
            }
            return this.definition;
        }

        public boolean hasDefinition() {
            return this.definition != null && !this.definition.isEmpty();
        }

        public CarePlanActivityDetailComponent setDefinition(Reference value) {
            this.definition = value;
            return this;
        }

        public Resource getDefinitionTarget() {
            return this.definitionTarget;
        }

        public CarePlanActivityDetailComponent setDefinitionTarget(Resource value) {
            this.definitionTarget = value;
            return this;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CarePlanActivityDetailComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public CarePlanActivityDetailComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public List<CodeableConcept> getReasonCode() {
            if (this.reasonCode == null) {
                this.reasonCode = new ArrayList<CodeableConcept>();
            }
            return this.reasonCode;
        }

        public CarePlanActivityDetailComponent setReasonCode(List<CodeableConcept> theReasonCode) {
            this.reasonCode = theReasonCode;
            return this;
        }

        public boolean hasReasonCode() {
            if (this.reasonCode == null) {
                return false;
            }
            for (CodeableConcept item : this.reasonCode) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addReasonCode() {
            CodeableConcept t = new CodeableConcept();
            if (this.reasonCode == null) {
                this.reasonCode = new ArrayList<CodeableConcept>();
            }
            this.reasonCode.add(t);
            return t;
        }

        public CarePlanActivityDetailComponent addReasonCode(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.reasonCode == null) {
                this.reasonCode = new ArrayList<CodeableConcept>();
            }
            this.reasonCode.add(t);
            return this;
        }

        public CodeableConcept getReasonCodeFirstRep() {
            if (this.getReasonCode().isEmpty()) {
                this.addReasonCode();
            }
            return this.getReasonCode().get(0);
        }

        public List<Reference> getReasonReference() {
            if (this.reasonReference == null) {
                this.reasonReference = new ArrayList<Reference>();
            }
            return this.reasonReference;
        }

        public CarePlanActivityDetailComponent setReasonReference(List<Reference> theReasonReference) {
            this.reasonReference = theReasonReference;
            return this;
        }

        public boolean hasReasonReference() {
            if (this.reasonReference == null) {
                return false;
            }
            for (Reference item : this.reasonReference) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addReasonReference() {
            Reference t = new Reference();
            if (this.reasonReference == null) {
                this.reasonReference = new ArrayList<Reference>();
            }
            this.reasonReference.add(t);
            return t;
        }

        public CarePlanActivityDetailComponent addReasonReference(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.reasonReference == null) {
                this.reasonReference = new ArrayList<Reference>();
            }
            this.reasonReference.add(t);
            return this;
        }

        public Reference getReasonReferenceFirstRep() {
            if (this.getReasonReference().isEmpty()) {
                this.addReasonReference();
            }
            return this.getReasonReference().get(0);
        }

        @Deprecated
        public List<Condition> getReasonReferenceTarget() {
            if (this.reasonReferenceTarget == null) {
                this.reasonReferenceTarget = new ArrayList<Condition>();
            }
            return this.reasonReferenceTarget;
        }

        @Deprecated
        public Condition addReasonReferenceTarget() {
            Condition r = new Condition();
            if (this.reasonReferenceTarget == null) {
                this.reasonReferenceTarget = new ArrayList<Condition>();
            }
            this.reasonReferenceTarget.add(r);
            return r;
        }

        public List<Reference> getGoal() {
            if (this.goal == null) {
                this.goal = new ArrayList<Reference>();
            }
            return this.goal;
        }

        public CarePlanActivityDetailComponent setGoal(List<Reference> theGoal) {
            this.goal = theGoal;
            return this;
        }

        public boolean hasGoal() {
            if (this.goal == null) {
                return false;
            }
            for (Reference item : this.goal) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addGoal() {
            Reference t = new Reference();
            if (this.goal == null) {
                this.goal = new ArrayList<Reference>();
            }
            this.goal.add(t);
            return t;
        }

        public CarePlanActivityDetailComponent addGoal(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.goal == null) {
                this.goal = new ArrayList<Reference>();
            }
            this.goal.add(t);
            return this;
        }

        public Reference getGoalFirstRep() {
            if (this.getGoal().isEmpty()) {
                this.addGoal();
            }
            return this.getGoal().get(0);
        }

        @Deprecated
        public List<Goal> getGoalTarget() {
            if (this.goalTarget == null) {
                this.goalTarget = new ArrayList<Goal>();
            }
            return this.goalTarget;
        }

        @Deprecated
        public Goal addGoalTarget() {
            Goal r = new Goal();
            if (this.goalTarget == null) {
                this.goalTarget = new ArrayList<Goal>();
            }
            this.goalTarget.add(r);
            return r;
        }

        public Enumeration<CarePlanActivityStatus> getStatusElement() {
            if (this.status == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CarePlanActivityDetailComponent.status");
                }
                if (Configuration.doAutoCreate()) {
                    this.status = new Enumeration<CarePlanActivityStatus>(new CarePlanActivityStatusEnumFactory());
                }
            }
            return this.status;
        }

        public boolean hasStatusElement() {
            return this.status != null && !this.status.isEmpty();
        }

        public boolean hasStatus() {
            return this.status != null && !this.status.isEmpty();
        }

        public CarePlanActivityDetailComponent setStatusElement(Enumeration<CarePlanActivityStatus> value) {
            this.status = value;
            return this;
        }

        public CarePlanActivityStatus getStatus() {
            return this.status == null ? null : (CarePlanActivityStatus)((Object)this.status.getValue());
        }

        public CarePlanActivityDetailComponent setStatus(CarePlanActivityStatus value) {
            if (this.status == null) {
                this.status = new Enumeration<CarePlanActivityStatus>(new CarePlanActivityStatusEnumFactory());
            }
            this.status.setValue((Object)value);
            return this;
        }

        public StringType getStatusReasonElement() {
            if (this.statusReason == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CarePlanActivityDetailComponent.statusReason");
                }
                if (Configuration.doAutoCreate()) {
                    this.statusReason = new StringType();
                }
            }
            return this.statusReason;
        }

        public boolean hasStatusReasonElement() {
            return this.statusReason != null && !this.statusReason.isEmpty();
        }

        public boolean hasStatusReason() {
            return this.statusReason != null && !this.statusReason.isEmpty();
        }

        public CarePlanActivityDetailComponent setStatusReasonElement(StringType value) {
            this.statusReason = value;
            return this;
        }

        public String getStatusReason() {
            return this.statusReason == null ? null : (String)this.statusReason.getValue();
        }

        public CarePlanActivityDetailComponent setStatusReason(String value) {
            if (Utilities.noString((String)value)) {
                this.statusReason = null;
            } else {
                if (this.statusReason == null) {
                    this.statusReason = new StringType();
                }
                this.statusReason.setValue(value);
            }
            return this;
        }

        public BooleanType getProhibitedElement() {
            if (this.prohibited == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CarePlanActivityDetailComponent.prohibited");
                }
                if (Configuration.doAutoCreate()) {
                    this.prohibited = new BooleanType();
                }
            }
            return this.prohibited;
        }

        public boolean hasProhibitedElement() {
            return this.prohibited != null && !this.prohibited.isEmpty();
        }

        public boolean hasProhibited() {
            return this.prohibited != null && !this.prohibited.isEmpty();
        }

        public CarePlanActivityDetailComponent setProhibitedElement(BooleanType value) {
            this.prohibited = value;
            return this;
        }

        public boolean getProhibited() {
            return this.prohibited == null || this.prohibited.isEmpty() ? false : (Boolean)this.prohibited.getValue();
        }

        public CarePlanActivityDetailComponent setProhibited(boolean value) {
            if (this.prohibited == null) {
                this.prohibited = new BooleanType();
            }
            this.prohibited.setValue((Object)value);
            return this;
        }

        public Type getScheduled() {
            return this.scheduled;
        }

        public Timing getScheduledTiming() throws FHIRException {
            if (this.scheduled == null) {
                return null;
            }
            if (!(this.scheduled instanceof Timing)) {
                throw new FHIRException("Type mismatch: the type Timing was expected, but " + this.scheduled.getClass().getName() + " was encountered");
            }
            return (Timing)this.scheduled;
        }

        public boolean hasScheduledTiming() {
            return this != null && this.scheduled instanceof Timing;
        }

        public Period getScheduledPeriod() throws FHIRException {
            if (this.scheduled == null) {
                return null;
            }
            if (!(this.scheduled instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.scheduled.getClass().getName() + " was encountered");
            }
            return (Period)this.scheduled;
        }

        public boolean hasScheduledPeriod() {
            return this != null && this.scheduled instanceof Period;
        }

        public StringType getScheduledStringType() throws FHIRException {
            if (this.scheduled == null) {
                return null;
            }
            if (!(this.scheduled instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.scheduled.getClass().getName() + " was encountered");
            }
            return (StringType)this.scheduled;
        }

        public boolean hasScheduledStringType() {
            return this != null && this.scheduled instanceof StringType;
        }

        public boolean hasScheduled() {
            return this.scheduled != null && !this.scheduled.isEmpty();
        }

        public CarePlanActivityDetailComponent setScheduled(Type value) throws FHIRFormatError {
            if (!(value == null || value instanceof Timing || value instanceof Period || value instanceof StringType)) {
                throw new FHIRFormatError("Not the right type for CarePlan.activity.detail.scheduled[x]: " + value.fhirType());
            }
            this.scheduled = value;
            return this;
        }

        public Reference getLocation() {
            if (this.location == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CarePlanActivityDetailComponent.location");
                }
                if (Configuration.doAutoCreate()) {
                    this.location = new Reference();
                }
            }
            return this.location;
        }

        public boolean hasLocation() {
            return this.location != null && !this.location.isEmpty();
        }

        public CarePlanActivityDetailComponent setLocation(Reference value) {
            this.location = value;
            return this;
        }

        public Location getLocationTarget() {
            if (this.locationTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CarePlanActivityDetailComponent.location");
                }
                if (Configuration.doAutoCreate()) {
                    this.locationTarget = new Location();
                }
            }
            return this.locationTarget;
        }

        public CarePlanActivityDetailComponent setLocationTarget(Location value) {
            this.locationTarget = value;
            return this;
        }

        public List<Reference> getPerformer() {
            if (this.performer == null) {
                this.performer = new ArrayList<Reference>();
            }
            return this.performer;
        }

        public CarePlanActivityDetailComponent setPerformer(List<Reference> thePerformer) {
            this.performer = thePerformer;
            return this;
        }

        public boolean hasPerformer() {
            if (this.performer == null) {
                return false;
            }
            for (Reference item : this.performer) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addPerformer() {
            Reference t = new Reference();
            if (this.performer == null) {
                this.performer = new ArrayList<Reference>();
            }
            this.performer.add(t);
            return t;
        }

        public CarePlanActivityDetailComponent addPerformer(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.performer == null) {
                this.performer = new ArrayList<Reference>();
            }
            this.performer.add(t);
            return this;
        }

        public Reference getPerformerFirstRep() {
            if (this.getPerformer().isEmpty()) {
                this.addPerformer();
            }
            return this.getPerformer().get(0);
        }

        @Deprecated
        public List<Resource> getPerformerTarget() {
            if (this.performerTarget == null) {
                this.performerTarget = new ArrayList<Resource>();
            }
            return this.performerTarget;
        }

        public Type getProduct() {
            return this.product;
        }

        public CodeableConcept getProductCodeableConcept() throws FHIRException {
            if (this.product == null) {
                return null;
            }
            if (!(this.product instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.product.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.product;
        }

        public boolean hasProductCodeableConcept() {
            return this != null && this.product instanceof CodeableConcept;
        }

        public Reference getProductReference() throws FHIRException {
            if (this.product == null) {
                return null;
            }
            if (!(this.product instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.product.getClass().getName() + " was encountered");
            }
            return (Reference)this.product;
        }

        public boolean hasProductReference() {
            return this != null && this.product instanceof Reference;
        }

        public boolean hasProduct() {
            return this.product != null && !this.product.isEmpty();
        }

        public CarePlanActivityDetailComponent setProduct(Type value) throws FHIRFormatError {
            if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
                throw new FHIRFormatError("Not the right type for CarePlan.activity.detail.product[x]: " + value.fhirType());
            }
            this.product = value;
            return this;
        }

        public SimpleQuantity getDailyAmount() {
            if (this.dailyAmount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CarePlanActivityDetailComponent.dailyAmount");
                }
                if (Configuration.doAutoCreate()) {
                    this.dailyAmount = new SimpleQuantity();
                }
            }
            return this.dailyAmount;
        }

        public boolean hasDailyAmount() {
            return this.dailyAmount != null && !this.dailyAmount.isEmpty();
        }

        public CarePlanActivityDetailComponent setDailyAmount(SimpleQuantity value) {
            this.dailyAmount = value;
            return this;
        }

        public SimpleQuantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CarePlanActivityDetailComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new SimpleQuantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public CarePlanActivityDetailComponent setQuantity(SimpleQuantity value) {
            this.quantity = value;
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CarePlanActivityDetailComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public CarePlanActivityDetailComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public CarePlanActivityDetailComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(CarePlan.SP_CATEGORY, "CodeableConcept", "High-level categorization of the type of activity in a care plan.", 0, 1, this.category));
            children.add(new Property(CarePlan.SP_DEFINITION, "Reference(PlanDefinition|ActivityDefinition|Questionnaire)", "Identifies the protocol, questionnaire, guideline or other specification the planned activity should be conducted in accordance with.", 0, 1, this.definition));
            children.add(new Property("code", "CodeableConcept", "Detailed description of the type of planned activity; e.g. What lab test, what procedure, what kind of encounter.", 0, 1, this.code));
            children.add(new Property("reasonCode", "CodeableConcept", "Provides the rationale that drove the inclusion of this particular activity as part of the plan or the reason why the activity was prohibited.", 0, Integer.MAX_VALUE, this.reasonCode));
            children.add(new Property("reasonReference", "Reference(Condition)", "Provides the health condition(s) that drove the inclusion of this particular activity as part of the plan.", 0, Integer.MAX_VALUE, this.reasonReference));
            children.add(new Property(CarePlan.SP_GOAL, "Reference(Goal)", "Internal reference that identifies the goals that this activity is intended to contribute towards meeting.", 0, Integer.MAX_VALUE, this.goal));
            children.add(new Property(CarePlan.SP_STATUS, "code", "Identifies what progress is being made for the specific activity.", 0, 1, this.status));
            children.add(new Property("statusReason", "string", "Provides reason why the activity isn't yet started, is on hold, was cancelled, etc.", 0, 1, this.statusReason));
            children.add(new Property("prohibited", "boolean", "If true, indicates that the described activity is one that must NOT be engaged in when following the plan.  If false, indicates that the described activity is one that should be engaged in when following the plan.", 0, 1, this.prohibited));
            children.add(new Property("scheduled[x]", "Timing|Period|string", "The period, timing or frequency upon which the described activity is to occur.", 0, 1, this.scheduled));
            children.add(new Property("location", "Reference(Location)", "Identifies the facility where the activity will occur; e.g. home, hospital, specific clinic, etc.", 0, 1, this.location));
            children.add(new Property(CarePlan.SP_PERFORMER, "Reference(Practitioner|Organization|RelatedPerson|Patient|CareTeam)", "Identifies who's expected to be involved in the activity.", 0, Integer.MAX_VALUE, this.performer));
            children.add(new Property("product[x]", "CodeableConcept|Reference(Medication|Substance)", "Identifies the food, drug or other product to be consumed or supplied in the activity.", 0, 1, this.product));
            children.add(new Property("dailyAmount", "SimpleQuantity", "Identifies the quantity expected to be consumed in a given day.", 0, 1, this.dailyAmount));
            children.add(new Property("quantity", "SimpleQuantity", "Identifies the quantity expected to be supplied, administered or consumed by the subject.", 0, 1, this.quantity));
            children.add(new Property("description", "string", "This provides a textual description of constraints on the intended activity occurrence, including relation to other activities.  It may also include objectives, pre-conditions and end-conditions.  Finally, it may convey specifics about the activity such as body site, method, route, etc.", 0, 1, this.description));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 50511102: {
                    return new Property(CarePlan.SP_CATEGORY, "CodeableConcept", "High-level categorization of the type of activity in a care plan.", 0, 1, this.category);
                }
                case -1014418093: {
                    return new Property(CarePlan.SP_DEFINITION, "Reference(PlanDefinition|ActivityDefinition|Questionnaire)", "Identifies the protocol, questionnaire, guideline or other specification the planned activity should be conducted in accordance with.", 0, 1, this.definition);
                }
                case 3059181: {
                    return new Property("code", "CodeableConcept", "Detailed description of the type of planned activity; e.g. What lab test, what procedure, what kind of encounter.", 0, 1, this.code);
                }
                case 722137681: {
                    return new Property("reasonCode", "CodeableConcept", "Provides the rationale that drove the inclusion of this particular activity as part of the plan or the reason why the activity was prohibited.", 0, Integer.MAX_VALUE, this.reasonCode);
                }
                case -1146218137: {
                    return new Property("reasonReference", "Reference(Condition)", "Provides the health condition(s) that drove the inclusion of this particular activity as part of the plan.", 0, Integer.MAX_VALUE, this.reasonReference);
                }
                case 3178259: {
                    return new Property(CarePlan.SP_GOAL, "Reference(Goal)", "Internal reference that identifies the goals that this activity is intended to contribute towards meeting.", 0, Integer.MAX_VALUE, this.goal);
                }
                case -892481550: {
                    return new Property(CarePlan.SP_STATUS, "code", "Identifies what progress is being made for the specific activity.", 0, 1, this.status);
                }
                case 2051346646: {
                    return new Property("statusReason", "string", "Provides reason why the activity isn't yet started, is on hold, was cancelled, etc.", 0, 1, this.statusReason);
                }
                case 663275198: {
                    return new Property("prohibited", "boolean", "If true, indicates that the described activity is one that must NOT be engaged in when following the plan.  If false, indicates that the described activity is one that should be engaged in when following the plan.", 0, 1, this.prohibited);
                }
                case 1162627251: {
                    return new Property("scheduled[x]", "Timing|Period|string", "The period, timing or frequency upon which the described activity is to occur.", 0, 1, this.scheduled);
                }
                case -160710483: {
                    return new Property("scheduled[x]", "Timing|Period|string", "The period, timing or frequency upon which the described activity is to occur.", 0, 1, this.scheduled);
                }
                case 998483799: {
                    return new Property("scheduled[x]", "Timing|Period|string", "The period, timing or frequency upon which the described activity is to occur.", 0, 1, this.scheduled);
                }
                case 880422094: {
                    return new Property("scheduled[x]", "Timing|Period|string", "The period, timing or frequency upon which the described activity is to occur.", 0, 1, this.scheduled);
                }
                case 980162334: {
                    return new Property("scheduled[x]", "Timing|Period|string", "The period, timing or frequency upon which the described activity is to occur.", 0, 1, this.scheduled);
                }
                case 1901043637: {
                    return new Property("location", "Reference(Location)", "Identifies the facility where the activity will occur; e.g. home, hospital, specific clinic, etc.", 0, 1, this.location);
                }
                case 481140686: {
                    return new Property(CarePlan.SP_PERFORMER, "Reference(Practitioner|Organization|RelatedPerson|Patient|CareTeam)", "Identifies who's expected to be involved in the activity.", 0, Integer.MAX_VALUE, this.performer);
                }
                case 1753005361: {
                    return new Property("product[x]", "CodeableConcept|Reference(Medication|Substance)", "Identifies the food, drug or other product to be consumed or supplied in the activity.", 0, 1, this.product);
                }
                case -309474065: {
                    return new Property("product[x]", "CodeableConcept|Reference(Medication|Substance)", "Identifies the food, drug or other product to be consumed or supplied in the activity.", 0, 1, this.product);
                }
                case 906854066: {
                    return new Property("product[x]", "CodeableConcept|Reference(Medication|Substance)", "Identifies the food, drug or other product to be consumed or supplied in the activity.", 0, 1, this.product);
                }
                case -669667556: {
                    return new Property("product[x]", "CodeableConcept|Reference(Medication|Substance)", "Identifies the food, drug or other product to be consumed or supplied in the activity.", 0, 1, this.product);
                }
                case -768908335: {
                    return new Property("dailyAmount", "SimpleQuantity", "Identifies the quantity expected to be consumed in a given day.", 0, 1, this.dailyAmount);
                }
                case -1285004149: {
                    return new Property("quantity", "SimpleQuantity", "Identifies the quantity expected to be supplied, administered or consumed by the subject.", 0, 1, this.quantity);
                }
                case -1724546052: {
                    return new Property("description", "string", "This provides a textual description of constraints on the intended activity occurrence, including relation to other activities.  It may also include objectives, pre-conditions and end-conditions.  Finally, it may convey specifics about the activity such as body site, method, route, etc.", 0, 1, this.description);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.category;
                    }
                    return baseArray;
                }
                case -1014418093: {
                    Base[] baseArray;
                    if (this.definition == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.definition;
                    }
                    return baseArray;
                }
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.code;
                    }
                    return baseArray;
                }
                case 722137681: {
                    return this.reasonCode == null ? new Base[]{} : this.reasonCode.toArray(new Base[this.reasonCode.size()]);
                }
                case -1146218137: {
                    return this.reasonReference == null ? new Base[]{} : this.reasonReference.toArray(new Base[this.reasonReference.size()]);
                }
                case 3178259: {
                    return this.goal == null ? new Base[]{} : this.goal.toArray(new Base[this.goal.size()]);
                }
                case -892481550: {
                    Base[] baseArray;
                    if (this.status == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.status;
                    }
                    return baseArray;
                }
                case 2051346646: {
                    Base[] baseArray;
                    if (this.statusReason == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.statusReason;
                    }
                    return baseArray;
                }
                case 663275198: {
                    Base[] baseArray;
                    if (this.prohibited == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.prohibited;
                    }
                    return baseArray;
                }
                case -160710483: {
                    Base[] baseArray;
                    if (this.scheduled == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.scheduled;
                    }
                    return baseArray;
                }
                case 1901043637: {
                    Base[] baseArray;
                    if (this.location == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.location;
                    }
                    return baseArray;
                }
                case 481140686: {
                    return this.performer == null ? new Base[]{} : this.performer.toArray(new Base[this.performer.size()]);
                }
                case -309474065: {
                    Base[] baseArray;
                    if (this.product == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray10 = new Base[1];
                        baseArray = baseArray10;
                        baseArray10[0] = this.product;
                    }
                    return baseArray;
                }
                case -768908335: {
                    Base[] baseArray;
                    if (this.dailyAmount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray11 = new Base[1];
                        baseArray = baseArray11;
                        baseArray11[0] = this.dailyAmount;
                    }
                    return baseArray;
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray12 = new Base[1];
                        baseArray = baseArray12;
                        baseArray12[0] = this.quantity;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray13 = new Base[1];
                        baseArray = baseArray13;
                        baseArray13[0] = this.description;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    this.category = this.castToCodeableConcept(value);
                    return value;
                }
                case -1014418093: {
                    this.definition = this.castToReference(value);
                    return value;
                }
                case 3059181: {
                    this.code = this.castToCodeableConcept(value);
                    return value;
                }
                case 722137681: {
                    this.getReasonCode().add(this.castToCodeableConcept(value));
                    return value;
                }
                case -1146218137: {
                    this.getReasonReference().add(this.castToReference(value));
                    return value;
                }
                case 3178259: {
                    this.getGoal().add(this.castToReference(value));
                    return value;
                }
                case -892481550: {
                    value = new CarePlanActivityStatusEnumFactory().fromType(this.castToCode(value));
                    this.status = value;
                    return value;
                }
                case 2051346646: {
                    this.statusReason = this.castToString(value);
                    return value;
                }
                case 663275198: {
                    this.prohibited = this.castToBoolean(value);
                    return value;
                }
                case -160710483: {
                    this.scheduled = this.castToType(value);
                    return value;
                }
                case 1901043637: {
                    this.location = this.castToReference(value);
                    return value;
                }
                case 481140686: {
                    this.getPerformer().add(this.castToReference(value));
                    return value;
                }
                case -309474065: {
                    this.product = this.castToType(value);
                    return value;
                }
                case -768908335: {
                    this.dailyAmount = this.castToSimpleQuantity(value);
                    return value;
                }
                case -1285004149: {
                    this.quantity = this.castToSimpleQuantity(value);
                    return value;
                }
                case -1724546052: {
                    this.description = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(CarePlan.SP_CATEGORY)) {
                this.category = this.castToCodeableConcept(value);
            } else if (name.equals(CarePlan.SP_DEFINITION)) {
                this.definition = this.castToReference(value);
            } else if (name.equals("code")) {
                this.code = this.castToCodeableConcept(value);
            } else if (name.equals("reasonCode")) {
                this.getReasonCode().add(this.castToCodeableConcept(value));
            } else if (name.equals("reasonReference")) {
                this.getReasonReference().add(this.castToReference(value));
            } else if (name.equals(CarePlan.SP_GOAL)) {
                this.getGoal().add(this.castToReference(value));
            } else if (name.equals(CarePlan.SP_STATUS)) {
                value = new CarePlanActivityStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
            } else if (name.equals("statusReason")) {
                this.statusReason = this.castToString(value);
            } else if (name.equals("prohibited")) {
                this.prohibited = this.castToBoolean(value);
            } else if (name.equals("scheduled[x]")) {
                this.scheduled = this.castToType(value);
            } else if (name.equals("location")) {
                this.location = this.castToReference(value);
            } else if (name.equals(CarePlan.SP_PERFORMER)) {
                this.getPerformer().add(this.castToReference(value));
            } else if (name.equals("product[x]")) {
                this.product = this.castToType(value);
            } else if (name.equals("dailyAmount")) {
                this.dailyAmount = this.castToSimpleQuantity(value);
            } else if (name.equals("quantity")) {
                this.quantity = this.castToSimpleQuantity(value);
            } else if (name.equals("description")) {
                this.description = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return this.getCategory();
                }
                case -1014418093: {
                    return this.getDefinition();
                }
                case 3059181: {
                    return this.getCode();
                }
                case 722137681: {
                    return this.addReasonCode();
                }
                case -1146218137: {
                    return this.addReasonReference();
                }
                case 3178259: {
                    return this.addGoal();
                }
                case -892481550: {
                    return this.getStatusElement();
                }
                case 2051346646: {
                    return this.getStatusReasonElement();
                }
                case 663275198: {
                    return this.getProhibitedElement();
                }
                case 1162627251: {
                    return this.getScheduled();
                }
                case -160710483: {
                    return this.getScheduled();
                }
                case 1901043637: {
                    return this.getLocation();
                }
                case 481140686: {
                    return this.addPerformer();
                }
                case 1753005361: {
                    return this.getProduct();
                }
                case -309474065: {
                    return this.getProduct();
                }
                case -768908335: {
                    return this.getDailyAmount();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return new String[]{"CodeableConcept"};
                }
                case -1014418093: {
                    return new String[]{"Reference"};
                }
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case 722137681: {
                    return new String[]{"CodeableConcept"};
                }
                case -1146218137: {
                    return new String[]{"Reference"};
                }
                case 3178259: {
                    return new String[]{"Reference"};
                }
                case -892481550: {
                    return new String[]{"code"};
                }
                case 2051346646: {
                    return new String[]{"string"};
                }
                case 663275198: {
                    return new String[]{"boolean"};
                }
                case -160710483: {
                    return new String[]{"Timing", "Period", "string"};
                }
                case 1901043637: {
                    return new String[]{"Reference"};
                }
                case 481140686: {
                    return new String[]{"Reference"};
                }
                case -309474065: {
                    return new String[]{"CodeableConcept", "Reference"};
                }
                case -768908335: {
                    return new String[]{"SimpleQuantity"};
                }
                case -1285004149: {
                    return new String[]{"SimpleQuantity"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(CarePlan.SP_CATEGORY)) {
                this.category = new CodeableConcept();
                return this.category;
            }
            if (name.equals(CarePlan.SP_DEFINITION)) {
                this.definition = new Reference();
                return this.definition;
            }
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("reasonCode")) {
                return this.addReasonCode();
            }
            if (name.equals("reasonReference")) {
                return this.addReasonReference();
            }
            if (name.equals(CarePlan.SP_GOAL)) {
                return this.addGoal();
            }
            if (name.equals(CarePlan.SP_STATUS)) {
                throw new FHIRException("Cannot call addChild on a primitive type CarePlan.status");
            }
            if (name.equals("statusReason")) {
                throw new FHIRException("Cannot call addChild on a primitive type CarePlan.statusReason");
            }
            if (name.equals("prohibited")) {
                throw new FHIRException("Cannot call addChild on a primitive type CarePlan.prohibited");
            }
            if (name.equals("scheduledTiming")) {
                this.scheduled = new Timing();
                return this.scheduled;
            }
            if (name.equals("scheduledPeriod")) {
                this.scheduled = new Period();
                return this.scheduled;
            }
            if (name.equals("scheduledString")) {
                this.scheduled = new StringType();
                return this.scheduled;
            }
            if (name.equals("location")) {
                this.location = new Reference();
                return this.location;
            }
            if (name.equals(CarePlan.SP_PERFORMER)) {
                return this.addPerformer();
            }
            if (name.equals("productCodeableConcept")) {
                this.product = new CodeableConcept();
                return this.product;
            }
            if (name.equals("productReference")) {
                this.product = new Reference();
                return this.product;
            }
            if (name.equals("dailyAmount")) {
                this.dailyAmount = new SimpleQuantity();
                return this.dailyAmount;
            }
            if (name.equals("quantity")) {
                this.quantity = new SimpleQuantity();
                return this.quantity;
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type CarePlan.description");
            }
            return super.addChild(name);
        }

        @Override
        public CarePlanActivityDetailComponent copy() {
            CarePlanActivityDetailComponent dst = new CarePlanActivityDetailComponent();
            this.copyValues(dst);
            dst.category = this.category == null ? null : this.category.copy();
            dst.definition = this.definition == null ? null : this.definition.copy();
            CodeableConcept codeableConcept = dst.code = this.code == null ? null : this.code.copy();
            if (this.reasonCode != null) {
                dst.reasonCode = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.reasonCode) {
                    dst.reasonCode.add(codeableConcept2.copy());
                }
            }
            if (this.reasonReference != null) {
                dst.reasonReference = new ArrayList<Reference>();
                for (Reference reference : this.reasonReference) {
                    dst.reasonReference.add(reference.copy());
                }
            }
            if (this.goal != null) {
                dst.goal = new ArrayList<Reference>();
                for (Reference reference : this.goal) {
                    dst.goal.add(reference.copy());
                }
            }
            dst.status = this.status == null ? null : this.status.copy();
            dst.statusReason = this.statusReason == null ? null : this.statusReason.copy();
            dst.prohibited = this.prohibited == null ? null : this.prohibited.copy();
            dst.scheduled = this.scheduled == null ? null : this.scheduled.copy();
            Reference reference = dst.location = this.location == null ? null : this.location.copy();
            if (this.performer != null) {
                dst.performer = new ArrayList<Reference>();
                for (Reference reference2 : this.performer) {
                    dst.performer.add(reference2.copy());
                }
            }
            dst.product = this.product == null ? null : this.product.copy();
            dst.dailyAmount = this.dailyAmount == null ? null : this.dailyAmount.copy();
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.description = this.description == null ? null : this.description.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CarePlanActivityDetailComponent)) {
                return false;
            }
            CarePlanActivityDetailComponent o = (CarePlanActivityDetailComponent)other_;
            return CarePlanActivityDetailComponent.compareDeep(this.category, o.category, true) && CarePlanActivityDetailComponent.compareDeep(this.definition, o.definition, true) && CarePlanActivityDetailComponent.compareDeep(this.code, o.code, true) && CarePlanActivityDetailComponent.compareDeep(this.reasonCode, o.reasonCode, true) && CarePlanActivityDetailComponent.compareDeep(this.reasonReference, o.reasonReference, true) && CarePlanActivityDetailComponent.compareDeep(this.goal, o.goal, true) && CarePlanActivityDetailComponent.compareDeep(this.status, o.status, true) && CarePlanActivityDetailComponent.compareDeep(this.statusReason, o.statusReason, true) && CarePlanActivityDetailComponent.compareDeep(this.prohibited, o.prohibited, true) && CarePlanActivityDetailComponent.compareDeep(this.scheduled, o.scheduled, true) && CarePlanActivityDetailComponent.compareDeep(this.location, o.location, true) && CarePlanActivityDetailComponent.compareDeep(this.performer, o.performer, true) && CarePlanActivityDetailComponent.compareDeep(this.product, o.product, true) && CarePlanActivityDetailComponent.compareDeep(this.dailyAmount, o.dailyAmount, true) && CarePlanActivityDetailComponent.compareDeep(this.quantity, o.quantity, true) && CarePlanActivityDetailComponent.compareDeep(this.description, o.description, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CarePlanActivityDetailComponent)) {
                return false;
            }
            CarePlanActivityDetailComponent o = (CarePlanActivityDetailComponent)other_;
            return CarePlanActivityDetailComponent.compareValues(this.status, o.status, true) && CarePlanActivityDetailComponent.compareValues(this.statusReason, o.statusReason, true) && CarePlanActivityDetailComponent.compareValues(this.prohibited, o.prohibited, true) && CarePlanActivityDetailComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.category, this.definition, this.code, this.reasonCode, this.reasonReference, this.goal, this.status, this.statusReason, this.prohibited, this.scheduled, this.location, this.performer, this.product, this.dailyAmount, this.quantity, this.description});
        }

        @Override
        public String fhirType() {
            return "CarePlan.activity.detail";
        }
    }

    @Block
    public static class CarePlanActivityComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="outcomeCodeableConcept", type={CodeableConcept.class}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Results of the activity", formalDefinition="Identifies the outcome at the point when the status of the activity is assessed.  For example, the outcome of an education activity could be patient understands (or not).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/care-plan-activity-outcome")
        protected List<CodeableConcept> outcomeCodeableConcept;
        @Child(name="outcomeReference", type={Reference.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Appointment, Encounter, Procedure, etc.", formalDefinition="Details of the outcome or action resulting from the activity.  The reference to an \"event\" resource, such as Procedure or Encounter or Observation, is the result/outcome of the activity itself.  The activity can be conveyed using CarePlan.activity.detail OR using the CarePlan.activity.reference (a reference to a \u201crequest\u201d resource).")
        protected List<Reference> outcomeReference;
        protected List<Resource> outcomeReferenceTarget;
        @Child(name="progress", type={Annotation.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Comments about the activity status/progress", formalDefinition="Notes about the adherence/status/progress of the activity.")
        protected List<Annotation> progress;
        @Child(name="reference", type={Appointment.class, CommunicationRequest.class, DeviceRequest.class, MedicationRequest.class, NutritionOrder.class, Task.class, ProcedureRequest.class, ReferralRequest.class, VisionPrescription.class, RequestGroup.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Activity details defined in specific resource", formalDefinition="The details of the proposed activity represented in a specific resource.")
        protected Reference reference;
        protected Resource referenceTarget;
        @Child(name="detail", type={}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="In-line definition of activity", formalDefinition="A simple summary of a planned activity suitable for a general care plan system (e.g. form driven) that doesn't know about specific resources such as procedure etc.")
        protected CarePlanActivityDetailComponent detail;
        private static final long serialVersionUID = -609287300L;

        public List<CodeableConcept> getOutcomeCodeableConcept() {
            if (this.outcomeCodeableConcept == null) {
                this.outcomeCodeableConcept = new ArrayList<CodeableConcept>();
            }
            return this.outcomeCodeableConcept;
        }

        public CarePlanActivityComponent setOutcomeCodeableConcept(List<CodeableConcept> theOutcomeCodeableConcept) {
            this.outcomeCodeableConcept = theOutcomeCodeableConcept;
            return this;
        }

        public boolean hasOutcomeCodeableConcept() {
            if (this.outcomeCodeableConcept == null) {
                return false;
            }
            for (CodeableConcept item : this.outcomeCodeableConcept) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addOutcomeCodeableConcept() {
            CodeableConcept t = new CodeableConcept();
            if (this.outcomeCodeableConcept == null) {
                this.outcomeCodeableConcept = new ArrayList<CodeableConcept>();
            }
            this.outcomeCodeableConcept.add(t);
            return t;
        }

        public CarePlanActivityComponent addOutcomeCodeableConcept(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.outcomeCodeableConcept == null) {
                this.outcomeCodeableConcept = new ArrayList<CodeableConcept>();
            }
            this.outcomeCodeableConcept.add(t);
            return this;
        }

        public CodeableConcept getOutcomeCodeableConceptFirstRep() {
            if (this.getOutcomeCodeableConcept().isEmpty()) {
                this.addOutcomeCodeableConcept();
            }
            return this.getOutcomeCodeableConcept().get(0);
        }

        public List<Reference> getOutcomeReference() {
            if (this.outcomeReference == null) {
                this.outcomeReference = new ArrayList<Reference>();
            }
            return this.outcomeReference;
        }

        public CarePlanActivityComponent setOutcomeReference(List<Reference> theOutcomeReference) {
            this.outcomeReference = theOutcomeReference;
            return this;
        }

        public boolean hasOutcomeReference() {
            if (this.outcomeReference == null) {
                return false;
            }
            for (Reference item : this.outcomeReference) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addOutcomeReference() {
            Reference t = new Reference();
            if (this.outcomeReference == null) {
                this.outcomeReference = new ArrayList<Reference>();
            }
            this.outcomeReference.add(t);
            return t;
        }

        public CarePlanActivityComponent addOutcomeReference(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.outcomeReference == null) {
                this.outcomeReference = new ArrayList<Reference>();
            }
            this.outcomeReference.add(t);
            return this;
        }

        public Reference getOutcomeReferenceFirstRep() {
            if (this.getOutcomeReference().isEmpty()) {
                this.addOutcomeReference();
            }
            return this.getOutcomeReference().get(0);
        }

        @Deprecated
        public List<Resource> getOutcomeReferenceTarget() {
            if (this.outcomeReferenceTarget == null) {
                this.outcomeReferenceTarget = new ArrayList<Resource>();
            }
            return this.outcomeReferenceTarget;
        }

        public List<Annotation> getProgress() {
            if (this.progress == null) {
                this.progress = new ArrayList<Annotation>();
            }
            return this.progress;
        }

        public CarePlanActivityComponent setProgress(List<Annotation> theProgress) {
            this.progress = theProgress;
            return this;
        }

        public boolean hasProgress() {
            if (this.progress == null) {
                return false;
            }
            for (Annotation item : this.progress) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Annotation addProgress() {
            Annotation t = new Annotation();
            if (this.progress == null) {
                this.progress = new ArrayList<Annotation>();
            }
            this.progress.add(t);
            return t;
        }

        public CarePlanActivityComponent addProgress(Annotation t) {
            if (t == null) {
                return this;
            }
            if (this.progress == null) {
                this.progress = new ArrayList<Annotation>();
            }
            this.progress.add(t);
            return this;
        }

        public Annotation getProgressFirstRep() {
            if (this.getProgress().isEmpty()) {
                this.addProgress();
            }
            return this.getProgress().get(0);
        }

        public Reference getReference() {
            if (this.reference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CarePlanActivityComponent.reference");
                }
                if (Configuration.doAutoCreate()) {
                    this.reference = new Reference();
                }
            }
            return this.reference;
        }

        public boolean hasReference() {
            return this.reference != null && !this.reference.isEmpty();
        }

        public CarePlanActivityComponent setReference(Reference value) {
            this.reference = value;
            return this;
        }

        public Resource getReferenceTarget() {
            return this.referenceTarget;
        }

        public CarePlanActivityComponent setReferenceTarget(Resource value) {
            this.referenceTarget = value;
            return this;
        }

        public CarePlanActivityDetailComponent getDetail() {
            if (this.detail == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CarePlanActivityComponent.detail");
                }
                if (Configuration.doAutoCreate()) {
                    this.detail = new CarePlanActivityDetailComponent();
                }
            }
            return this.detail;
        }

        public boolean hasDetail() {
            return this.detail != null && !this.detail.isEmpty();
        }

        public CarePlanActivityComponent setDetail(CarePlanActivityDetailComponent value) {
            this.detail = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("outcomeCodeableConcept", "CodeableConcept", "Identifies the outcome at the point when the status of the activity is assessed.  For example, the outcome of an education activity could be patient understands (or not).", 0, Integer.MAX_VALUE, this.outcomeCodeableConcept));
            children.add(new Property("outcomeReference", "Reference(Any)", "Details of the outcome or action resulting from the activity.  The reference to an \"event\" resource, such as Procedure or Encounter or Observation, is the result/outcome of the activity itself.  The activity can be conveyed using CarePlan.activity.detail OR using the CarePlan.activity.reference (a reference to a \u201crequest\u201d resource).", 0, Integer.MAX_VALUE, this.outcomeReference));
            children.add(new Property("progress", "Annotation", "Notes about the adherence/status/progress of the activity.", 0, Integer.MAX_VALUE, this.progress));
            children.add(new Property("reference", "Reference(Appointment|CommunicationRequest|DeviceRequest|MedicationRequest|NutritionOrder|Task|ProcedureRequest|ReferralRequest|VisionPrescription|RequestGroup)", "The details of the proposed activity represented in a specific resource.", 0, 1, this.reference));
            children.add(new Property("detail", "", "A simple summary of a planned activity suitable for a general care plan system (e.g. form driven) that doesn't know about specific resources such as procedure etc.", 0, 1, this.detail));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -511913489: {
                    return new Property("outcomeCodeableConcept", "CodeableConcept", "Identifies the outcome at the point when the status of the activity is assessed.  For example, the outcome of an education activity could be patient understands (or not).", 0, Integer.MAX_VALUE, this.outcomeCodeableConcept);
                }
                case -782273511: {
                    return new Property("outcomeReference", "Reference(Any)", "Details of the outcome or action resulting from the activity.  The reference to an \"event\" resource, such as Procedure or Encounter or Observation, is the result/outcome of the activity itself.  The activity can be conveyed using CarePlan.activity.detail OR using the CarePlan.activity.reference (a reference to a \u201crequest\u201d resource).", 0, Integer.MAX_VALUE, this.outcomeReference);
                }
                case -1001078227: {
                    return new Property("progress", "Annotation", "Notes about the adherence/status/progress of the activity.", 0, Integer.MAX_VALUE, this.progress);
                }
                case -925155509: {
                    return new Property("reference", "Reference(Appointment|CommunicationRequest|DeviceRequest|MedicationRequest|NutritionOrder|Task|ProcedureRequest|ReferralRequest|VisionPrescription|RequestGroup)", "The details of the proposed activity represented in a specific resource.", 0, 1, this.reference);
                }
                case -1335224239: {
                    return new Property("detail", "", "A simple summary of a planned activity suitable for a general care plan system (e.g. form driven) that doesn't know about specific resources such as procedure etc.", 0, 1, this.detail);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -511913489: {
                    return this.outcomeCodeableConcept == null ? new Base[]{} : this.outcomeCodeableConcept.toArray(new Base[this.outcomeCodeableConcept.size()]);
                }
                case -782273511: {
                    return this.outcomeReference == null ? new Base[]{} : this.outcomeReference.toArray(new Base[this.outcomeReference.size()]);
                }
                case -1001078227: {
                    return this.progress == null ? new Base[]{} : this.progress.toArray(new Base[this.progress.size()]);
                }
                case -925155509: {
                    Base[] baseArray;
                    if (this.reference == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.reference;
                    }
                    return baseArray;
                }
                case -1335224239: {
                    Base[] baseArray;
                    if (this.detail == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.detail;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -511913489: {
                    this.getOutcomeCodeableConcept().add(this.castToCodeableConcept(value));
                    return value;
                }
                case -782273511: {
                    this.getOutcomeReference().add(this.castToReference(value));
                    return value;
                }
                case -1001078227: {
                    this.getProgress().add(this.castToAnnotation(value));
                    return value;
                }
                case -925155509: {
                    this.reference = this.castToReference(value);
                    return value;
                }
                case -1335224239: {
                    this.detail = (CarePlanActivityDetailComponent)value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("outcomeCodeableConcept")) {
                this.getOutcomeCodeableConcept().add(this.castToCodeableConcept(value));
            } else if (name.equals("outcomeReference")) {
                this.getOutcomeReference().add(this.castToReference(value));
            } else if (name.equals("progress")) {
                this.getProgress().add(this.castToAnnotation(value));
            } else if (name.equals("reference")) {
                this.reference = this.castToReference(value);
            } else if (name.equals("detail")) {
                this.detail = (CarePlanActivityDetailComponent)value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -511913489: {
                    return this.addOutcomeCodeableConcept();
                }
                case -782273511: {
                    return this.addOutcomeReference();
                }
                case -1001078227: {
                    return this.addProgress();
                }
                case -925155509: {
                    return this.getReference();
                }
                case -1335224239: {
                    return this.getDetail();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -511913489: {
                    return new String[]{"CodeableConcept"};
                }
                case -782273511: {
                    return new String[]{"Reference"};
                }
                case -1001078227: {
                    return new String[]{"Annotation"};
                }
                case -925155509: {
                    return new String[]{"Reference"};
                }
                case -1335224239: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("outcomeCodeableConcept")) {
                return this.addOutcomeCodeableConcept();
            }
            if (name.equals("outcomeReference")) {
                return this.addOutcomeReference();
            }
            if (name.equals("progress")) {
                return this.addProgress();
            }
            if (name.equals("reference")) {
                this.reference = new Reference();
                return this.reference;
            }
            if (name.equals("detail")) {
                this.detail = new CarePlanActivityDetailComponent();
                return this.detail;
            }
            return super.addChild(name);
        }

        @Override
        public CarePlanActivityComponent copy() {
            CarePlanActivityComponent dst = new CarePlanActivityComponent();
            this.copyValues(dst);
            if (this.outcomeCodeableConcept != null) {
                dst.outcomeCodeableConcept = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.outcomeCodeableConcept) {
                    dst.outcomeCodeableConcept.add(codeableConcept.copy());
                }
            }
            if (this.outcomeReference != null) {
                dst.outcomeReference = new ArrayList<Reference>();
                for (Reference reference : this.outcomeReference) {
                    dst.outcomeReference.add(reference.copy());
                }
            }
            if (this.progress != null) {
                dst.progress = new ArrayList<Annotation>();
                for (Annotation annotation : this.progress) {
                    dst.progress.add(annotation.copy());
                }
            }
            dst.reference = this.reference == null ? null : this.reference.copy();
            dst.detail = this.detail == null ? null : this.detail.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CarePlanActivityComponent)) {
                return false;
            }
            CarePlanActivityComponent o = (CarePlanActivityComponent)other_;
            return CarePlanActivityComponent.compareDeep(this.outcomeCodeableConcept, o.outcomeCodeableConcept, true) && CarePlanActivityComponent.compareDeep(this.outcomeReference, o.outcomeReference, true) && CarePlanActivityComponent.compareDeep(this.progress, o.progress, true) && CarePlanActivityComponent.compareDeep(this.reference, o.reference, true) && CarePlanActivityComponent.compareDeep(this.detail, o.detail, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CarePlanActivityComponent)) {
                return false;
            }
            CarePlanActivityComponent o = (CarePlanActivityComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.outcomeCodeableConcept, this.outcomeReference, this.progress, this.reference, this.detail});
        }

        @Override
        public String fhirType() {
            return "CarePlan.activity";
        }
    }

    public static class CarePlanActivityStatusEnumFactory
    implements EnumFactory<CarePlanActivityStatus> {
        @Override
        public CarePlanActivityStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("not-started".equals(codeString)) {
                return CarePlanActivityStatus.NOTSTARTED;
            }
            if ("scheduled".equals(codeString)) {
                return CarePlanActivityStatus.SCHEDULED;
            }
            if ("in-progress".equals(codeString)) {
                return CarePlanActivityStatus.INPROGRESS;
            }
            if ("on-hold".equals(codeString)) {
                return CarePlanActivityStatus.ONHOLD;
            }
            if ("completed".equals(codeString)) {
                return CarePlanActivityStatus.COMPLETED;
            }
            if ("cancelled".equals(codeString)) {
                return CarePlanActivityStatus.CANCELLED;
            }
            if ("unknown".equals(codeString)) {
                return CarePlanActivityStatus.UNKNOWN;
            }
            throw new IllegalArgumentException("Unknown CarePlanActivityStatus code '" + codeString + "'");
        }

        public Enumeration<CarePlanActivityStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<CarePlanActivityStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("not-started".equals(codeString)) {
                return new Enumeration<CarePlanActivityStatus>(this, CarePlanActivityStatus.NOTSTARTED);
            }
            if ("scheduled".equals(codeString)) {
                return new Enumeration<CarePlanActivityStatus>(this, CarePlanActivityStatus.SCHEDULED);
            }
            if ("in-progress".equals(codeString)) {
                return new Enumeration<CarePlanActivityStatus>(this, CarePlanActivityStatus.INPROGRESS);
            }
            if ("on-hold".equals(codeString)) {
                return new Enumeration<CarePlanActivityStatus>(this, CarePlanActivityStatus.ONHOLD);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<CarePlanActivityStatus>(this, CarePlanActivityStatus.COMPLETED);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<CarePlanActivityStatus>(this, CarePlanActivityStatus.CANCELLED);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<CarePlanActivityStatus>(this, CarePlanActivityStatus.UNKNOWN);
            }
            throw new FHIRException("Unknown CarePlanActivityStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(CarePlanActivityStatus code) {
            if (code == CarePlanActivityStatus.NOTSTARTED) {
                return "not-started";
            }
            if (code == CarePlanActivityStatus.SCHEDULED) {
                return "scheduled";
            }
            if (code == CarePlanActivityStatus.INPROGRESS) {
                return "in-progress";
            }
            if (code == CarePlanActivityStatus.ONHOLD) {
                return "on-hold";
            }
            if (code == CarePlanActivityStatus.COMPLETED) {
                return "completed";
            }
            if (code == CarePlanActivityStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == CarePlanActivityStatus.UNKNOWN) {
                return "unknown";
            }
            return "?";
        }

        @Override
        public String toSystem(CarePlanActivityStatus code) {
            return code.getSystem();
        }
    }

    public static enum CarePlanActivityStatus {
        NOTSTARTED,
        SCHEDULED,
        INPROGRESS,
        ONHOLD,
        COMPLETED,
        CANCELLED,
        UNKNOWN,
        NULL;


        public static CarePlanActivityStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("not-started".equals(codeString)) {
                return NOTSTARTED;
            }
            if ("scheduled".equals(codeString)) {
                return SCHEDULED;
            }
            if ("in-progress".equals(codeString)) {
                return INPROGRESS;
            }
            if ("on-hold".equals(codeString)) {
                return ONHOLD;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown CarePlanActivityStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case NOTSTARTED: {
                    return "not-started";
                }
                case SCHEDULED: {
                    return "scheduled";
                }
                case INPROGRESS: {
                    return "in-progress";
                }
                case ONHOLD: {
                    return "on-hold";
                }
                case COMPLETED: {
                    return "completed";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case UNKNOWN: {
                    return "unknown";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case NOTSTARTED: {
                    return "http://hl7.org/fhir/care-plan-activity-status";
                }
                case SCHEDULED: {
                    return "http://hl7.org/fhir/care-plan-activity-status";
                }
                case INPROGRESS: {
                    return "http://hl7.org/fhir/care-plan-activity-status";
                }
                case ONHOLD: {
                    return "http://hl7.org/fhir/care-plan-activity-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/care-plan-activity-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/care-plan-activity-status";
                }
                case UNKNOWN: {
                    return "http://hl7.org/fhir/care-plan-activity-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case NOTSTARTED: {
                    return "Activity is planned but no action has yet been taken.";
                }
                case SCHEDULED: {
                    return "Appointment or other booking has occurred but activity has not yet begun.";
                }
                case INPROGRESS: {
                    return "Activity has been started but is not yet complete.";
                }
                case ONHOLD: {
                    return "Activity was started but has temporarily ceased with an expectation of resumption at a future time.";
                }
                case COMPLETED: {
                    return "The activities have been completed (more or less) as planned.";
                }
                case CANCELLED: {
                    return "The activities have been ended prior to completion (perhaps even before they were started).";
                }
                case UNKNOWN: {
                    return "The authoring system doesn't know the current state of the activity.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case NOTSTARTED: {
                    return "Not Started";
                }
                case SCHEDULED: {
                    return "Scheduled";
                }
                case INPROGRESS: {
                    return "In Progress";
                }
                case ONHOLD: {
                    return "On Hold";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case UNKNOWN: {
                    return "Unknown";
                }
            }
            return "?";
        }
    }

    public static class CarePlanIntentEnumFactory
    implements EnumFactory<CarePlanIntent> {
        @Override
        public CarePlanIntent fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("proposal".equals(codeString)) {
                return CarePlanIntent.PROPOSAL;
            }
            if ("plan".equals(codeString)) {
                return CarePlanIntent.PLAN;
            }
            if ("order".equals(codeString)) {
                return CarePlanIntent.ORDER;
            }
            if ("option".equals(codeString)) {
                return CarePlanIntent.OPTION;
            }
            throw new IllegalArgumentException("Unknown CarePlanIntent code '" + codeString + "'");
        }

        public Enumeration<CarePlanIntent> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<CarePlanIntent>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("proposal".equals(codeString)) {
                return new Enumeration<CarePlanIntent>(this, CarePlanIntent.PROPOSAL);
            }
            if ("plan".equals(codeString)) {
                return new Enumeration<CarePlanIntent>(this, CarePlanIntent.PLAN);
            }
            if ("order".equals(codeString)) {
                return new Enumeration<CarePlanIntent>(this, CarePlanIntent.ORDER);
            }
            if ("option".equals(codeString)) {
                return new Enumeration<CarePlanIntent>(this, CarePlanIntent.OPTION);
            }
            throw new FHIRException("Unknown CarePlanIntent code '" + codeString + "'");
        }

        @Override
        public String toCode(CarePlanIntent code) {
            if (code == CarePlanIntent.PROPOSAL) {
                return "proposal";
            }
            if (code == CarePlanIntent.PLAN) {
                return "plan";
            }
            if (code == CarePlanIntent.ORDER) {
                return "order";
            }
            if (code == CarePlanIntent.OPTION) {
                return "option";
            }
            return "?";
        }

        @Override
        public String toSystem(CarePlanIntent code) {
            return code.getSystem();
        }
    }

    public static enum CarePlanIntent {
        PROPOSAL,
        PLAN,
        ORDER,
        OPTION,
        NULL;


        public static CarePlanIntent fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("proposal".equals(codeString)) {
                return PROPOSAL;
            }
            if ("plan".equals(codeString)) {
                return PLAN;
            }
            if ("order".equals(codeString)) {
                return ORDER;
            }
            if ("option".equals(codeString)) {
                return OPTION;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown CarePlanIntent code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PROPOSAL: {
                    return "proposal";
                }
                case PLAN: {
                    return "plan";
                }
                case ORDER: {
                    return "order";
                }
                case OPTION: {
                    return "option";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PROPOSAL: {
                    return "http://hl7.org/fhir/care-plan-intent";
                }
                case PLAN: {
                    return "http://hl7.org/fhir/care-plan-intent";
                }
                case ORDER: {
                    return "http://hl7.org/fhir/care-plan-intent";
                }
                case OPTION: {
                    return "http://hl7.org/fhir/care-plan-intent";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PROPOSAL: {
                    return "The care plan is a suggestion made by someone/something that doesn't have an intention to ensure it occurs and without providing an authorization to act";
                }
                case PLAN: {
                    return "The care plan represents an intention to ensure something occurs without providing an authorization for others to act";
                }
                case ORDER: {
                    return "The care plan represents a request/demand and authorization for action";
                }
                case OPTION: {
                    return "The care plan represents a component or option for a RequestGroup that establishes timing, conditionality and/or other constraints among a set of requests.\n\nRefer to [[[RequestGroup]]] for additional information on how this status is used";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PROPOSAL: {
                    return "Proposal";
                }
                case PLAN: {
                    return "Plan";
                }
                case ORDER: {
                    return "Order";
                }
                case OPTION: {
                    return "Option";
                }
            }
            return "?";
        }
    }

    public static class CarePlanStatusEnumFactory
    implements EnumFactory<CarePlanStatus> {
        @Override
        public CarePlanStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return CarePlanStatus.DRAFT;
            }
            if ("active".equals(codeString)) {
                return CarePlanStatus.ACTIVE;
            }
            if ("suspended".equals(codeString)) {
                return CarePlanStatus.SUSPENDED;
            }
            if ("completed".equals(codeString)) {
                return CarePlanStatus.COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return CarePlanStatus.ENTEREDINERROR;
            }
            if ("cancelled".equals(codeString)) {
                return CarePlanStatus.CANCELLED;
            }
            if ("unknown".equals(codeString)) {
                return CarePlanStatus.UNKNOWN;
            }
            throw new IllegalArgumentException("Unknown CarePlanStatus code '" + codeString + "'");
        }

        public Enumeration<CarePlanStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<CarePlanStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<CarePlanStatus>(this, CarePlanStatus.DRAFT);
            }
            if ("active".equals(codeString)) {
                return new Enumeration<CarePlanStatus>(this, CarePlanStatus.ACTIVE);
            }
            if ("suspended".equals(codeString)) {
                return new Enumeration<CarePlanStatus>(this, CarePlanStatus.SUSPENDED);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<CarePlanStatus>(this, CarePlanStatus.COMPLETED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<CarePlanStatus>(this, CarePlanStatus.ENTEREDINERROR);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<CarePlanStatus>(this, CarePlanStatus.CANCELLED);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<CarePlanStatus>(this, CarePlanStatus.UNKNOWN);
            }
            throw new FHIRException("Unknown CarePlanStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(CarePlanStatus code) {
            if (code == CarePlanStatus.DRAFT) {
                return "draft";
            }
            if (code == CarePlanStatus.ACTIVE) {
                return "active";
            }
            if (code == CarePlanStatus.SUSPENDED) {
                return "suspended";
            }
            if (code == CarePlanStatus.COMPLETED) {
                return "completed";
            }
            if (code == CarePlanStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == CarePlanStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == CarePlanStatus.UNKNOWN) {
                return "unknown";
            }
            return "?";
        }

        @Override
        public String toSystem(CarePlanStatus code) {
            return code.getSystem();
        }
    }

    public static enum CarePlanStatus {
        DRAFT,
        ACTIVE,
        SUSPENDED,
        COMPLETED,
        ENTEREDINERROR,
        CANCELLED,
        UNKNOWN,
        NULL;


        public static CarePlanStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("suspended".equals(codeString)) {
                return SUSPENDED;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown CarePlanStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case DRAFT: {
                    return "draft";
                }
                case ACTIVE: {
                    return "active";
                }
                case SUSPENDED: {
                    return "suspended";
                }
                case COMPLETED: {
                    return "completed";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case UNKNOWN: {
                    return "unknown";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case DRAFT: {
                    return "http://hl7.org/fhir/care-plan-status";
                }
                case ACTIVE: {
                    return "http://hl7.org/fhir/care-plan-status";
                }
                case SUSPENDED: {
                    return "http://hl7.org/fhir/care-plan-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/care-plan-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/care-plan-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/care-plan-status";
                }
                case UNKNOWN: {
                    return "http://hl7.org/fhir/care-plan-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case DRAFT: {
                    return "The plan is in development or awaiting use but is not yet intended to be acted upon.";
                }
                case ACTIVE: {
                    return "The plan is intended to be followed and used as part of patient care.";
                }
                case SUSPENDED: {
                    return "The plan has been temporarily stopped but is expected to resume in the future.";
                }
                case COMPLETED: {
                    return "The plan is no longer in use and is not expected to be followed or used in patient care.";
                }
                case ENTEREDINERROR: {
                    return "The plan was entered in error and voided.";
                }
                case CANCELLED: {
                    return "The plan has been terminated prior to reaching completion (though it may have been replaced by a new plan).";
                }
                case UNKNOWN: {
                    return "The authoring system doesn't know the current state of the care plan.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case DRAFT: {
                    return "Pending";
                }
                case ACTIVE: {
                    return "Active";
                }
                case SUSPENDED: {
                    return "Suspended";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case ENTEREDINERROR: {
                    return "Entered In Error";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case UNKNOWN: {
                    return "Unknown";
                }
            }
            return "?";
        }
    }
}

