/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu3.model.Age;
import org.hl7.fhir.dstu3.model.Annotation;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Patient;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.Practitioner;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Range;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.RelatedPerson;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="AllergyIntolerance", profile="http://hl7.org/fhir/StructureDefinition/AllergyIntolerance")
public class AllergyIntolerance
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="External ids for this item", formalDefinition="This records identifiers associated with this allergy/intolerance concern that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).")
    protected List<Identifier> identifier;
    @Child(name="clinicalStatus", type={CodeType.class}, order=1, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | inactive | resolved", formalDefinition="The clinical status of the allergy or intolerance.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/allergy-clinical-status")
    protected Enumeration<AllergyIntoleranceClinicalStatus> clinicalStatus;
    @Child(name="verificationStatus", type={CodeType.class}, order=2, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="unconfirmed | confirmed | refuted | entered-in-error", formalDefinition="Assertion about certainty associated with the propensity, or potential risk, of a reaction to the identified substance (including pharmaceutical product).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/allergy-verification-status")
    protected Enumeration<AllergyIntoleranceVerificationStatus> verificationStatus;
    @Child(name="type", type={CodeType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="allergy | intolerance - Underlying mechanism (if known)", formalDefinition="Identification of the underlying physiological mechanism for the reaction risk.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/allergy-intolerance-type")
    protected Enumeration<AllergyIntoleranceType> type;
    @Child(name="category", type={CodeType.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="food | medication | environment | biologic", formalDefinition="Category of the identified substance.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/allergy-intolerance-category")
    protected List<Enumeration<AllergyIntoleranceCategory>> category;
    @Child(name="criticality", type={CodeType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="low | high | unable-to-assess", formalDefinition="Estimate of the potential clinical harm, or seriousness, of the reaction to the identified substance.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/allergy-intolerance-criticality")
    protected Enumeration<AllergyIntoleranceCriticality> criticality;
    @Child(name="code", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Code that identifies the allergy or intolerance", formalDefinition="Code for an allergy or intolerance statement (either a positive or a negated/excluded statement).  This may be a code for a substance or pharmaceutical product that is considered to be responsible for the adverse reaction risk (e.g., \"Latex\"), an allergy or intolerance condition (e.g., \"Latex allergy\"), or a negated/excluded code for a specific substance or class (e.g., \"No latex allergy\") or a general or categorical negated statement (e.g.,  \"No known allergy\", \"No known drug allergies\").")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/allergyintolerance-code")
    protected CodeableConcept code;
    @Child(name="patient", type={Patient.class}, order=7, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who the sensitivity is for", formalDefinition="The patient who has the allergy or intolerance.")
    protected Reference patient;
    protected Patient patientTarget;
    @Child(name="onset", type={DateTimeType.class, Age.class, Period.class, Range.class, StringType.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When allergy or intolerance was identified", formalDefinition="Estimated or actual date,  date-time, or age when allergy or intolerance was identified.")
    protected Type onset;
    @Child(name="assertedDate", type={DateTimeType.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Date record was believed accurate", formalDefinition="The date on which the existance of the AllergyIntolerance was first asserted or acknowledged.")
    protected DateTimeType assertedDate;
    @Child(name="recorder", type={Practitioner.class, Patient.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Who recorded the sensitivity", formalDefinition="Individual who recorded the record and takes responsibility for its content.")
    protected Reference recorder;
    protected Resource recorderTarget;
    @Child(name="asserter", type={Patient.class, RelatedPerson.class, Practitioner.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Source of the information about the allergy", formalDefinition="The source of the information about the allergy that is recorded.")
    protected Reference asserter;
    protected Resource asserterTarget;
    @Child(name="lastOccurrence", type={DateTimeType.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Date(/time) of last known occurrence of a reaction", formalDefinition="Represents the date and/or time of the last known occurrence of a reaction event.")
    protected DateTimeType lastOccurrence;
    @Child(name="note", type={Annotation.class}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional text not captured in other fields", formalDefinition="Additional narrative about the propensity for the Adverse Reaction, not captured in other fields.")
    protected List<Annotation> note;
    @Child(name="reaction", type={}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Adverse Reaction Events linked to exposure to substance", formalDefinition="Details about each adverse reaction event linked to exposure to the identified substance.")
    protected List<AllergyIntoleranceReactionComponent> reaction;
    private static final long serialVersionUID = 948924623L;
    @SearchParamDefinition(name="severity", path="AllergyIntolerance.reaction.severity", description="mild | moderate | severe (of event as a whole)", type="token")
    public static final String SP_SEVERITY = "severity";
    public static final TokenClientParam SEVERITY = new TokenClientParam("severity");
    @SearchParamDefinition(name="date", path="AllergyIntolerance.assertedDate", description="Date record was believed accurate", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="AllergyIntolerance.identifier", description="External ids for this item", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="manifestation", path="AllergyIntolerance.reaction.manifestation", description="Clinical symptoms/signs associated with the Event", type="token")
    public static final String SP_MANIFESTATION = "manifestation";
    public static final TokenClientParam MANIFESTATION = new TokenClientParam("manifestation");
    @SearchParamDefinition(name="recorder", path="AllergyIntolerance.recorder", description="Who recorded the sensitivity", type="reference", providesMembershipIn={@Compartment(name="Patient"), @Compartment(name="Practitioner")}, target={Patient.class, Practitioner.class})
    public static final String SP_RECORDER = "recorder";
    public static final ReferenceClientParam RECORDER = new ReferenceClientParam("recorder");
    public static final Include INCLUDE_RECORDER = new Include("AllergyIntolerance:recorder").toLocked();
    @SearchParamDefinition(name="code", path="AllergyIntolerance.code | AllergyIntolerance.reaction.substance", description="Code that identifies the allergy or intolerance", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="verification-status", path="AllergyIntolerance.verificationStatus", description="unconfirmed | confirmed | refuted | entered-in-error", type="token")
    public static final String SP_VERIFICATION_STATUS = "verification-status";
    public static final TokenClientParam VERIFICATION_STATUS = new TokenClientParam("verification-status");
    @SearchParamDefinition(name="criticality", path="AllergyIntolerance.criticality", description="low | high | unable-to-assess", type="token")
    public static final String SP_CRITICALITY = "criticality";
    public static final TokenClientParam CRITICALITY = new TokenClientParam("criticality");
    @SearchParamDefinition(name="clinical-status", path="AllergyIntolerance.clinicalStatus", description="active | inactive | resolved", type="token")
    public static final String SP_CLINICAL_STATUS = "clinical-status";
    public static final TokenClientParam CLINICAL_STATUS = new TokenClientParam("clinical-status");
    @SearchParamDefinition(name="type", path="AllergyIntolerance.type", description="allergy | intolerance - Underlying mechanism (if known)", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="onset", path="AllergyIntolerance.reaction.onset", description="Date(/time) when manifestations showed", type="date")
    public static final String SP_ONSET = "onset";
    public static final DateClientParam ONSET = new DateClientParam("onset");
    @SearchParamDefinition(name="route", path="AllergyIntolerance.reaction.exposureRoute", description="How the subject was exposed to the substance", type="token")
    public static final String SP_ROUTE = "route";
    public static final TokenClientParam ROUTE = new TokenClientParam("route");
    @SearchParamDefinition(name="asserter", path="AllergyIntolerance.asserter", description="Source of the information about the allergy", type="reference", providesMembershipIn={@Compartment(name="Patient"), @Compartment(name="Practitioner"), @Compartment(name="RelatedPerson")}, target={Patient.class, Practitioner.class, RelatedPerson.class})
    public static final String SP_ASSERTER = "asserter";
    public static final ReferenceClientParam ASSERTER = new ReferenceClientParam("asserter");
    public static final Include INCLUDE_ASSERTER = new Include("AllergyIntolerance:asserter").toLocked();
    @SearchParamDefinition(name="patient", path="AllergyIntolerance.patient", description="Who the sensitivity is for", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("AllergyIntolerance:patient").toLocked();
    @SearchParamDefinition(name="category", path="AllergyIntolerance.category", description="food | medication | environment | biologic", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="last-date", path="AllergyIntolerance.lastOccurrence", description="Date(/time) of last known occurrence of a reaction", type="date")
    public static final String SP_LAST_DATE = "last-date";
    public static final DateClientParam LAST_DATE = new DateClientParam("last-date");

    public AllergyIntolerance() {
    }

    public AllergyIntolerance(Enumeration<AllergyIntoleranceVerificationStatus> verificationStatus, Reference patient) {
        this.verificationStatus = verificationStatus;
        this.patient = patient;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public AllergyIntolerance setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public AllergyIntolerance addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<AllergyIntoleranceClinicalStatus> getClinicalStatusElement() {
        if (this.clinicalStatus == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AllergyIntolerance.clinicalStatus");
            }
            if (Configuration.doAutoCreate()) {
                this.clinicalStatus = new Enumeration<AllergyIntoleranceClinicalStatus>(new AllergyIntoleranceClinicalStatusEnumFactory());
            }
        }
        return this.clinicalStatus;
    }

    public boolean hasClinicalStatusElement() {
        return this.clinicalStatus != null && !this.clinicalStatus.isEmpty();
    }

    public boolean hasClinicalStatus() {
        return this.clinicalStatus != null && !this.clinicalStatus.isEmpty();
    }

    public AllergyIntolerance setClinicalStatusElement(Enumeration<AllergyIntoleranceClinicalStatus> value) {
        this.clinicalStatus = value;
        return this;
    }

    public AllergyIntoleranceClinicalStatus getClinicalStatus() {
        return this.clinicalStatus == null ? null : (AllergyIntoleranceClinicalStatus)((Object)this.clinicalStatus.getValue());
    }

    public AllergyIntolerance setClinicalStatus(AllergyIntoleranceClinicalStatus value) {
        if (value == null) {
            this.clinicalStatus = null;
        } else {
            if (this.clinicalStatus == null) {
                this.clinicalStatus = new Enumeration<AllergyIntoleranceClinicalStatus>(new AllergyIntoleranceClinicalStatusEnumFactory());
            }
            this.clinicalStatus.setValue((Object)value);
        }
        return this;
    }

    public Enumeration<AllergyIntoleranceVerificationStatus> getVerificationStatusElement() {
        if (this.verificationStatus == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AllergyIntolerance.verificationStatus");
            }
            if (Configuration.doAutoCreate()) {
                this.verificationStatus = new Enumeration<AllergyIntoleranceVerificationStatus>(new AllergyIntoleranceVerificationStatusEnumFactory());
            }
        }
        return this.verificationStatus;
    }

    public boolean hasVerificationStatusElement() {
        return this.verificationStatus != null && !this.verificationStatus.isEmpty();
    }

    public boolean hasVerificationStatus() {
        return this.verificationStatus != null && !this.verificationStatus.isEmpty();
    }

    public AllergyIntolerance setVerificationStatusElement(Enumeration<AllergyIntoleranceVerificationStatus> value) {
        this.verificationStatus = value;
        return this;
    }

    public AllergyIntoleranceVerificationStatus getVerificationStatus() {
        return this.verificationStatus == null ? null : (AllergyIntoleranceVerificationStatus)((Object)this.verificationStatus.getValue());
    }

    public AllergyIntolerance setVerificationStatus(AllergyIntoleranceVerificationStatus value) {
        if (this.verificationStatus == null) {
            this.verificationStatus = new Enumeration<AllergyIntoleranceVerificationStatus>(new AllergyIntoleranceVerificationStatusEnumFactory());
        }
        this.verificationStatus.setValue((Object)value);
        return this;
    }

    public Enumeration<AllergyIntoleranceType> getTypeElement() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AllergyIntolerance.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new Enumeration<AllergyIntoleranceType>(new AllergyIntoleranceTypeEnumFactory());
            }
        }
        return this.type;
    }

    public boolean hasTypeElement() {
        return this.type != null && !this.type.isEmpty();
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public AllergyIntolerance setTypeElement(Enumeration<AllergyIntoleranceType> value) {
        this.type = value;
        return this;
    }

    public AllergyIntoleranceType getType() {
        return this.type == null ? null : (AllergyIntoleranceType)((Object)this.type.getValue());
    }

    public AllergyIntolerance setType(AllergyIntoleranceType value) {
        if (value == null) {
            this.type = null;
        } else {
            if (this.type == null) {
                this.type = new Enumeration<AllergyIntoleranceType>(new AllergyIntoleranceTypeEnumFactory());
            }
            this.type.setValue((Object)value);
        }
        return this;
    }

    public List<Enumeration<AllergyIntoleranceCategory>> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<Enumeration<AllergyIntoleranceCategory>>();
        }
        return this.category;
    }

    public AllergyIntolerance setCategory(List<Enumeration<AllergyIntoleranceCategory>> theCategory) {
        this.category = theCategory;
        return this;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (Enumeration<AllergyIntoleranceCategory> item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Enumeration<AllergyIntoleranceCategory> addCategoryElement() {
        Enumeration<AllergyIntoleranceCategory> t = new Enumeration<AllergyIntoleranceCategory>(new AllergyIntoleranceCategoryEnumFactory());
        if (this.category == null) {
            this.category = new ArrayList<Enumeration<AllergyIntoleranceCategory>>();
        }
        this.category.add(t);
        return t;
    }

    public AllergyIntolerance addCategory(AllergyIntoleranceCategory value) {
        Enumeration<AllergyIntoleranceCategory> t = new Enumeration<AllergyIntoleranceCategory>(new AllergyIntoleranceCategoryEnumFactory());
        t.setValue((Object)value);
        if (this.category == null) {
            this.category = new ArrayList<Enumeration<AllergyIntoleranceCategory>>();
        }
        this.category.add(t);
        return this;
    }

    public boolean hasCategory(AllergyIntoleranceCategory value) {
        if (this.category == null) {
            return false;
        }
        for (Enumeration<AllergyIntoleranceCategory> v : this.category) {
            if (!((AllergyIntoleranceCategory)((Object)v.getValue())).equals((Object)value)) continue;
            return true;
        }
        return false;
    }

    public Enumeration<AllergyIntoleranceCriticality> getCriticalityElement() {
        if (this.criticality == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AllergyIntolerance.criticality");
            }
            if (Configuration.doAutoCreate()) {
                this.criticality = new Enumeration<AllergyIntoleranceCriticality>(new AllergyIntoleranceCriticalityEnumFactory());
            }
        }
        return this.criticality;
    }

    public boolean hasCriticalityElement() {
        return this.criticality != null && !this.criticality.isEmpty();
    }

    public boolean hasCriticality() {
        return this.criticality != null && !this.criticality.isEmpty();
    }

    public AllergyIntolerance setCriticalityElement(Enumeration<AllergyIntoleranceCriticality> value) {
        this.criticality = value;
        return this;
    }

    public AllergyIntoleranceCriticality getCriticality() {
        return this.criticality == null ? null : (AllergyIntoleranceCriticality)((Object)this.criticality.getValue());
    }

    public AllergyIntolerance setCriticality(AllergyIntoleranceCriticality value) {
        if (value == null) {
            this.criticality = null;
        } else {
            if (this.criticality == null) {
                this.criticality = new Enumeration<AllergyIntoleranceCriticality>(new AllergyIntoleranceCriticalityEnumFactory());
            }
            this.criticality.setValue((Object)value);
        }
        return this;
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AllergyIntolerance.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public AllergyIntolerance setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AllergyIntolerance.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public AllergyIntolerance setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AllergyIntolerance.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public AllergyIntolerance setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    public Type getOnset() {
        return this.onset;
    }

    public DateTimeType getOnsetDateTimeType() throws FHIRException {
        if (this.onset == null) {
            return null;
        }
        if (!(this.onset instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.onset.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.onset;
    }

    public boolean hasOnsetDateTimeType() {
        return this != null && this.onset instanceof DateTimeType;
    }

    public Age getOnsetAge() throws FHIRException {
        if (this.onset == null) {
            return null;
        }
        if (!(this.onset instanceof Age)) {
            throw new FHIRException("Type mismatch: the type Age was expected, but " + this.onset.getClass().getName() + " was encountered");
        }
        return (Age)this.onset;
    }

    public boolean hasOnsetAge() {
        return this != null && this.onset instanceof Age;
    }

    public Period getOnsetPeriod() throws FHIRException {
        if (this.onset == null) {
            return null;
        }
        if (!(this.onset instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.onset.getClass().getName() + " was encountered");
        }
        return (Period)this.onset;
    }

    public boolean hasOnsetPeriod() {
        return this != null && this.onset instanceof Period;
    }

    public Range getOnsetRange() throws FHIRException {
        if (this.onset == null) {
            return null;
        }
        if (!(this.onset instanceof Range)) {
            throw new FHIRException("Type mismatch: the type Range was expected, but " + this.onset.getClass().getName() + " was encountered");
        }
        return (Range)this.onset;
    }

    public boolean hasOnsetRange() {
        return this != null && this.onset instanceof Range;
    }

    public StringType getOnsetStringType() throws FHIRException {
        if (this.onset == null) {
            return null;
        }
        if (!(this.onset instanceof StringType)) {
            throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.onset.getClass().getName() + " was encountered");
        }
        return (StringType)this.onset;
    }

    public boolean hasOnsetStringType() {
        return this != null && this.onset instanceof StringType;
    }

    public boolean hasOnset() {
        return this.onset != null && !this.onset.isEmpty();
    }

    public AllergyIntolerance setOnset(Type value) throws FHIRFormatError {
        if (!(value == null || value instanceof DateTimeType || value instanceof Age || value instanceof Period || value instanceof Range || value instanceof StringType)) {
            throw new FHIRFormatError("Not the right type for AllergyIntolerance.onset[x]: " + value.fhirType());
        }
        this.onset = value;
        return this;
    }

    public DateTimeType getAssertedDateElement() {
        if (this.assertedDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AllergyIntolerance.assertedDate");
            }
            if (Configuration.doAutoCreate()) {
                this.assertedDate = new DateTimeType();
            }
        }
        return this.assertedDate;
    }

    public boolean hasAssertedDateElement() {
        return this.assertedDate != null && !this.assertedDate.isEmpty();
    }

    public boolean hasAssertedDate() {
        return this.assertedDate != null && !this.assertedDate.isEmpty();
    }

    public AllergyIntolerance setAssertedDateElement(DateTimeType value) {
        this.assertedDate = value;
        return this;
    }

    public Date getAssertedDate() {
        return this.assertedDate == null ? null : (Date)this.assertedDate.getValue();
    }

    public AllergyIntolerance setAssertedDate(Date value) {
        if (value == null) {
            this.assertedDate = null;
        } else {
            if (this.assertedDate == null) {
                this.assertedDate = new DateTimeType();
            }
            this.assertedDate.setValue(value);
        }
        return this;
    }

    public Reference getRecorder() {
        if (this.recorder == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AllergyIntolerance.recorder");
            }
            if (Configuration.doAutoCreate()) {
                this.recorder = new Reference();
            }
        }
        return this.recorder;
    }

    public boolean hasRecorder() {
        return this.recorder != null && !this.recorder.isEmpty();
    }

    public AllergyIntolerance setRecorder(Reference value) {
        this.recorder = value;
        return this;
    }

    public Resource getRecorderTarget() {
        return this.recorderTarget;
    }

    public AllergyIntolerance setRecorderTarget(Resource value) {
        this.recorderTarget = value;
        return this;
    }

    public Reference getAsserter() {
        if (this.asserter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AllergyIntolerance.asserter");
            }
            if (Configuration.doAutoCreate()) {
                this.asserter = new Reference();
            }
        }
        return this.asserter;
    }

    public boolean hasAsserter() {
        return this.asserter != null && !this.asserter.isEmpty();
    }

    public AllergyIntolerance setAsserter(Reference value) {
        this.asserter = value;
        return this;
    }

    public Resource getAsserterTarget() {
        return this.asserterTarget;
    }

    public AllergyIntolerance setAsserterTarget(Resource value) {
        this.asserterTarget = value;
        return this;
    }

    public DateTimeType getLastOccurrenceElement() {
        if (this.lastOccurrence == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AllergyIntolerance.lastOccurrence");
            }
            if (Configuration.doAutoCreate()) {
                this.lastOccurrence = new DateTimeType();
            }
        }
        return this.lastOccurrence;
    }

    public boolean hasLastOccurrenceElement() {
        return this.lastOccurrence != null && !this.lastOccurrence.isEmpty();
    }

    public boolean hasLastOccurrence() {
        return this.lastOccurrence != null && !this.lastOccurrence.isEmpty();
    }

    public AllergyIntolerance setLastOccurrenceElement(DateTimeType value) {
        this.lastOccurrence = value;
        return this;
    }

    public Date getLastOccurrence() {
        return this.lastOccurrence == null ? null : (Date)this.lastOccurrence.getValue();
    }

    public AllergyIntolerance setLastOccurrence(Date value) {
        if (value == null) {
            this.lastOccurrence = null;
        } else {
            if (this.lastOccurrence == null) {
                this.lastOccurrence = new DateTimeType();
            }
            this.lastOccurrence.setValue(value);
        }
        return this;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public AllergyIntolerance setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public AllergyIntolerance addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public List<AllergyIntoleranceReactionComponent> getReaction() {
        if (this.reaction == null) {
            this.reaction = new ArrayList<AllergyIntoleranceReactionComponent>();
        }
        return this.reaction;
    }

    public AllergyIntolerance setReaction(List<AllergyIntoleranceReactionComponent> theReaction) {
        this.reaction = theReaction;
        return this;
    }

    public boolean hasReaction() {
        if (this.reaction == null) {
            return false;
        }
        for (AllergyIntoleranceReactionComponent item : this.reaction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public AllergyIntoleranceReactionComponent addReaction() {
        AllergyIntoleranceReactionComponent t = new AllergyIntoleranceReactionComponent();
        if (this.reaction == null) {
            this.reaction = new ArrayList<AllergyIntoleranceReactionComponent>();
        }
        this.reaction.add(t);
        return t;
    }

    public AllergyIntolerance addReaction(AllergyIntoleranceReactionComponent t) {
        if (t == null) {
            return this;
        }
        if (this.reaction == null) {
            this.reaction = new ArrayList<AllergyIntoleranceReactionComponent>();
        }
        this.reaction.add(t);
        return this;
    }

    public AllergyIntoleranceReactionComponent getReactionFirstRep() {
        if (this.getReaction().isEmpty()) {
            this.addReaction();
        }
        return this.getReaction().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "This records identifiers associated with this allergy/intolerance concern that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("clinicalStatus", SP_CODE, "The clinical status of the allergy or intolerance.", 0, 1, this.clinicalStatus));
        children.add(new Property("verificationStatus", SP_CODE, "Assertion about certainty associated with the propensity, or potential risk, of a reaction to the identified substance (including pharmaceutical product).", 0, 1, this.verificationStatus));
        children.add(new Property(SP_TYPE, SP_CODE, "Identification of the underlying physiological mechanism for the reaction risk.", 0, 1, this.type));
        children.add(new Property(SP_CATEGORY, SP_CODE, "Category of the identified substance.", 0, Integer.MAX_VALUE, this.category));
        children.add(new Property(SP_CRITICALITY, SP_CODE, "Estimate of the potential clinical harm, or seriousness, of the reaction to the identified substance.", 0, 1, this.criticality));
        children.add(new Property(SP_CODE, "CodeableConcept", "Code for an allergy or intolerance statement (either a positive or a negated/excluded statement).  This may be a code for a substance or pharmaceutical product that is considered to be responsible for the adverse reaction risk (e.g., \"Latex\"), an allergy or intolerance condition (e.g., \"Latex allergy\"), or a negated/excluded code for a specific substance or class (e.g., \"No latex allergy\") or a general or categorical negated statement (e.g.,  \"No known allergy\", \"No known drug allergies\").", 0, 1, this.code));
        children.add(new Property(SP_PATIENT, "Reference(Patient)", "The patient who has the allergy or intolerance.", 0, 1, this.patient));
        children.add(new Property("onset[x]", "dateTime|Age|Period|Range|string", "Estimated or actual date,  date-time, or age when allergy or intolerance was identified.", 0, 1, this.onset));
        children.add(new Property("assertedDate", "dateTime", "The date on which the existance of the AllergyIntolerance was first asserted or acknowledged.", 0, 1, this.assertedDate));
        children.add(new Property(SP_RECORDER, "Reference(Practitioner|Patient)", "Individual who recorded the record and takes responsibility for its content.", 0, 1, this.recorder));
        children.add(new Property(SP_ASSERTER, "Reference(Patient|RelatedPerson|Practitioner)", "The source of the information about the allergy that is recorded.", 0, 1, this.asserter));
        children.add(new Property("lastOccurrence", "dateTime", "Represents the date and/or time of the last known occurrence of a reaction event.", 0, 1, this.lastOccurrence));
        children.add(new Property("note", "Annotation", "Additional narrative about the propensity for the Adverse Reaction, not captured in other fields.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("reaction", "", "Details about each adverse reaction event linked to exposure to the identified substance.", 0, Integer.MAX_VALUE, this.reaction));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "This records identifiers associated with this allergy/intolerance concern that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -462853915: {
                return new Property("clinicalStatus", SP_CODE, "The clinical status of the allergy or intolerance.", 0, 1, this.clinicalStatus);
            }
            case -842509843: {
                return new Property("verificationStatus", SP_CODE, "Assertion about certainty associated with the propensity, or potential risk, of a reaction to the identified substance (including pharmaceutical product).", 0, 1, this.verificationStatus);
            }
            case 3575610: {
                return new Property(SP_TYPE, SP_CODE, "Identification of the underlying physiological mechanism for the reaction risk.", 0, 1, this.type);
            }
            case 50511102: {
                return new Property(SP_CATEGORY, SP_CODE, "Category of the identified substance.", 0, Integer.MAX_VALUE, this.category);
            }
            case -1608054609: {
                return new Property(SP_CRITICALITY, SP_CODE, "Estimate of the potential clinical harm, or seriousness, of the reaction to the identified substance.", 0, 1, this.criticality);
            }
            case 3059181: {
                return new Property(SP_CODE, "CodeableConcept", "Code for an allergy or intolerance statement (either a positive or a negated/excluded statement).  This may be a code for a substance or pharmaceutical product that is considered to be responsible for the adverse reaction risk (e.g., \"Latex\"), an allergy or intolerance condition (e.g., \"Latex allergy\"), or a negated/excluded code for a specific substance or class (e.g., \"No latex allergy\") or a general or categorical negated statement (e.g.,  \"No known allergy\", \"No known drug allergies\").", 0, 1, this.code);
            }
            case -791418107: {
                return new Property(SP_PATIENT, "Reference(Patient)", "The patient who has the allergy or intolerance.", 0, 1, this.patient);
            }
            case -1886216323: {
                return new Property("onset[x]", "dateTime|Age|Period|Range|string", "Estimated or actual date,  date-time, or age when allergy or intolerance was identified.", 0, 1, this.onset);
            }
            case 105901603: {
                return new Property("onset[x]", "dateTime|Age|Period|Range|string", "Estimated or actual date,  date-time, or age when allergy or intolerance was identified.", 0, 1, this.onset);
            }
            case -1701663010: {
                return new Property("onset[x]", "dateTime|Age|Period|Range|string", "Estimated or actual date,  date-time, or age when allergy or intolerance was identified.", 0, 1, this.onset);
            }
            case -1886241828: {
                return new Property("onset[x]", "dateTime|Age|Period|Range|string", "Estimated or actual date,  date-time, or age when allergy or intolerance was identified.", 0, 1, this.onset);
            }
            case -1545082428: {
                return new Property("onset[x]", "dateTime|Age|Period|Range|string", "Estimated or actual date,  date-time, or age when allergy or intolerance was identified.", 0, 1, this.onset);
            }
            case -186664742: {
                return new Property("onset[x]", "dateTime|Age|Period|Range|string", "Estimated or actual date,  date-time, or age when allergy or intolerance was identified.", 0, 1, this.onset);
            }
            case -1445342188: {
                return new Property("onset[x]", "dateTime|Age|Period|Range|string", "Estimated or actual date,  date-time, or age when allergy or intolerance was identified.", 0, 1, this.onset);
            }
            case -174231629: {
                return new Property("assertedDate", "dateTime", "The date on which the existance of the AllergyIntolerance was first asserted or acknowledged.", 0, 1, this.assertedDate);
            }
            case -799233858: {
                return new Property(SP_RECORDER, "Reference(Practitioner|Patient)", "Individual who recorded the record and takes responsibility for its content.", 0, 1, this.recorder);
            }
            case -373242253: {
                return new Property(SP_ASSERTER, "Reference(Patient|RelatedPerson|Practitioner)", "The source of the information about the allergy that is recorded.", 0, 1, this.asserter);
            }
            case 1896977671: {
                return new Property("lastOccurrence", "dateTime", "Represents the date and/or time of the last known occurrence of a reaction event.", 0, 1, this.lastOccurrence);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Additional narrative about the propensity for the Adverse Reaction, not captured in other fields.", 0, Integer.MAX_VALUE, this.note);
            }
            case -867509719: {
                return new Property("reaction", "", "Details about each adverse reaction event linked to exposure to the identified substance.", 0, Integer.MAX_VALUE, this.reaction);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -462853915: {
                Base[] baseArray;
                if (this.clinicalStatus == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.clinicalStatus;
                }
                return baseArray;
            }
            case -842509843: {
                Base[] baseArray;
                if (this.verificationStatus == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.verificationStatus;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.type;
                }
                return baseArray;
            }
            case 50511102: {
                return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
            }
            case -1608054609: {
                Base[] baseArray;
                if (this.criticality == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.criticality;
                }
                return baseArray;
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.code;
                }
                return baseArray;
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.patient;
                }
                return baseArray;
            }
            case 105901603: {
                Base[] baseArray;
                if (this.onset == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.onset;
                }
                return baseArray;
            }
            case -174231629: {
                Base[] baseArray;
                if (this.assertedDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.assertedDate;
                }
                return baseArray;
            }
            case -799233858: {
                Base[] baseArray;
                if (this.recorder == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.recorder;
                }
                return baseArray;
            }
            case -373242253: {
                Base[] baseArray;
                if (this.asserter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.asserter;
                }
                return baseArray;
            }
            case 1896977671: {
                Base[] baseArray;
                if (this.lastOccurrence == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.lastOccurrence;
                }
                return baseArray;
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case -867509719: {
                return this.reaction == null ? new Base[]{} : this.reaction.toArray(new Base[this.reaction.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -462853915: {
                value = new AllergyIntoleranceClinicalStatusEnumFactory().fromType(this.castToCode(value));
                this.clinicalStatus = value;
                return value;
            }
            case -842509843: {
                value = new AllergyIntoleranceVerificationStatusEnumFactory().fromType(this.castToCode(value));
                this.verificationStatus = value;
                return value;
            }
            case 3575610: {
                value = new AllergyIntoleranceTypeEnumFactory().fromType(this.castToCode(value));
                this.type = value;
                return value;
            }
            case 50511102: {
                value = new AllergyIntoleranceCategoryEnumFactory().fromType(this.castToCode(value));
                this.getCategory().add(value);
                return value;
            }
            case -1608054609: {
                value = new AllergyIntoleranceCriticalityEnumFactory().fromType(this.castToCode(value));
                this.criticality = value;
                return value;
            }
            case 3059181: {
                this.code = this.castToCodeableConcept(value);
                return value;
            }
            case -791418107: {
                this.patient = this.castToReference(value);
                return value;
            }
            case 105901603: {
                this.onset = this.castToType(value);
                return value;
            }
            case -174231629: {
                this.assertedDate = this.castToDateTime(value);
                return value;
            }
            case -799233858: {
                this.recorder = this.castToReference(value);
                return value;
            }
            case -373242253: {
                this.asserter = this.castToReference(value);
                return value;
            }
            case 1896977671: {
                this.lastOccurrence = this.castToDateTime(value);
                return value;
            }
            case 3387378: {
                this.getNote().add(this.castToAnnotation(value));
                return value;
            }
            case -867509719: {
                this.getReaction().add((AllergyIntoleranceReactionComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("clinicalStatus")) {
            value = new AllergyIntoleranceClinicalStatusEnumFactory().fromType(this.castToCode(value));
            this.clinicalStatus = value;
        } else if (name.equals("verificationStatus")) {
            value = new AllergyIntoleranceVerificationStatusEnumFactory().fromType(this.castToCode(value));
            this.verificationStatus = value;
        } else if (name.equals(SP_TYPE)) {
            value = new AllergyIntoleranceTypeEnumFactory().fromType(this.castToCode(value));
            this.type = value;
        } else if (name.equals(SP_CATEGORY)) {
            value = new AllergyIntoleranceCategoryEnumFactory().fromType(this.castToCode(value));
            this.getCategory().add(value);
        } else if (name.equals(SP_CRITICALITY)) {
            value = new AllergyIntoleranceCriticalityEnumFactory().fromType(this.castToCode(value));
            this.criticality = value;
        } else if (name.equals(SP_CODE)) {
            this.code = this.castToCodeableConcept(value);
        } else if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals("onset[x]")) {
            this.onset = this.castToType(value);
        } else if (name.equals("assertedDate")) {
            this.assertedDate = this.castToDateTime(value);
        } else if (name.equals(SP_RECORDER)) {
            this.recorder = this.castToReference(value);
        } else if (name.equals(SP_ASSERTER)) {
            this.asserter = this.castToReference(value);
        } else if (name.equals("lastOccurrence")) {
            this.lastOccurrence = this.castToDateTime(value);
        } else if (name.equals("note")) {
            this.getNote().add(this.castToAnnotation(value));
        } else if (name.equals("reaction")) {
            this.getReaction().add((AllergyIntoleranceReactionComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -462853915: {
                return this.getClinicalStatusElement();
            }
            case -842509843: {
                return this.getVerificationStatusElement();
            }
            case 3575610: {
                return this.getTypeElement();
            }
            case 50511102: {
                return this.addCategoryElement();
            }
            case -1608054609: {
                return this.getCriticalityElement();
            }
            case 3059181: {
                return this.getCode();
            }
            case -791418107: {
                return this.getPatient();
            }
            case -1886216323: {
                return this.getOnset();
            }
            case 105901603: {
                return this.getOnset();
            }
            case -174231629: {
                return this.getAssertedDateElement();
            }
            case -799233858: {
                return this.getRecorder();
            }
            case -373242253: {
                return this.getAsserter();
            }
            case 1896977671: {
                return this.getLastOccurrenceElement();
            }
            case 3387378: {
                return this.addNote();
            }
            case -867509719: {
                return this.addReaction();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -462853915: {
                return new String[]{SP_CODE};
            }
            case -842509843: {
                return new String[]{SP_CODE};
            }
            case 3575610: {
                return new String[]{SP_CODE};
            }
            case 50511102: {
                return new String[]{SP_CODE};
            }
            case -1608054609: {
                return new String[]{SP_CODE};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case -791418107: {
                return new String[]{"Reference"};
            }
            case 105901603: {
                return new String[]{"dateTime", "Age", "Period", "Range", "string"};
            }
            case -174231629: {
                return new String[]{"dateTime"};
            }
            case -799233858: {
                return new String[]{"Reference"};
            }
            case -373242253: {
                return new String[]{"Reference"};
            }
            case 1896977671: {
                return new String[]{"dateTime"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case -867509719: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("clinicalStatus")) {
            throw new FHIRException("Cannot call addChild on a primitive type AllergyIntolerance.clinicalStatus");
        }
        if (name.equals("verificationStatus")) {
            throw new FHIRException("Cannot call addChild on a primitive type AllergyIntolerance.verificationStatus");
        }
        if (name.equals(SP_TYPE)) {
            throw new FHIRException("Cannot call addChild on a primitive type AllergyIntolerance.type");
        }
        if (name.equals(SP_CATEGORY)) {
            throw new FHIRException("Cannot call addChild on a primitive type AllergyIntolerance.category");
        }
        if (name.equals(SP_CRITICALITY)) {
            throw new FHIRException("Cannot call addChild on a primitive type AllergyIntolerance.criticality");
        }
        if (name.equals(SP_CODE)) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals("onsetDateTime")) {
            this.onset = new DateTimeType();
            return this.onset;
        }
        if (name.equals("onsetAge")) {
            this.onset = new Age();
            return this.onset;
        }
        if (name.equals("onsetPeriod")) {
            this.onset = new Period();
            return this.onset;
        }
        if (name.equals("onsetRange")) {
            this.onset = new Range();
            return this.onset;
        }
        if (name.equals("onsetString")) {
            this.onset = new StringType();
            return this.onset;
        }
        if (name.equals("assertedDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type AllergyIntolerance.assertedDate");
        }
        if (name.equals(SP_RECORDER)) {
            this.recorder = new Reference();
            return this.recorder;
        }
        if (name.equals(SP_ASSERTER)) {
            this.asserter = new Reference();
            return this.asserter;
        }
        if (name.equals("lastOccurrence")) {
            throw new FHIRException("Cannot call addChild on a primitive type AllergyIntolerance.lastOccurrence");
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("reaction")) {
            return this.addReaction();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "AllergyIntolerance";
    }

    @Override
    public AllergyIntolerance copy() {
        AllergyIntolerance dst = new AllergyIntolerance();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.clinicalStatus = this.clinicalStatus == null ? null : this.clinicalStatus.copy();
        dst.verificationStatus = this.verificationStatus == null ? null : this.verificationStatus.copy();
        Enumeration<AllergyIntoleranceType> enumeration = dst.type = this.type == null ? null : this.type.copy();
        if (this.category != null) {
            dst.category = new ArrayList<Enumeration<AllergyIntoleranceCategory>>();
            for (Enumeration enumeration2 : this.category) {
                dst.category.add((Enumeration<AllergyIntoleranceCategory>)enumeration2.copy());
            }
        }
        dst.criticality = this.criticality == null ? null : this.criticality.copy();
        dst.code = this.code == null ? null : this.code.copy();
        dst.patient = this.patient == null ? null : this.patient.copy();
        dst.onset = this.onset == null ? null : this.onset.copy();
        dst.assertedDate = this.assertedDate == null ? null : this.assertedDate.copy();
        dst.recorder = this.recorder == null ? null : this.recorder.copy();
        dst.asserter = this.asserter == null ? null : this.asserter.copy();
        DateTimeType dateTimeType = dst.lastOccurrence = this.lastOccurrence == null ? null : this.lastOccurrence.copy();
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        if (this.reaction != null) {
            dst.reaction = new ArrayList<AllergyIntoleranceReactionComponent>();
            for (AllergyIntoleranceReactionComponent allergyIntoleranceReactionComponent : this.reaction) {
                dst.reaction.add(allergyIntoleranceReactionComponent.copy());
            }
        }
        return dst;
    }

    protected AllergyIntolerance typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof AllergyIntolerance)) {
            return false;
        }
        AllergyIntolerance o = (AllergyIntolerance)other_;
        return AllergyIntolerance.compareDeep(this.identifier, o.identifier, true) && AllergyIntolerance.compareDeep(this.clinicalStatus, o.clinicalStatus, true) && AllergyIntolerance.compareDeep(this.verificationStatus, o.verificationStatus, true) && AllergyIntolerance.compareDeep(this.type, o.type, true) && AllergyIntolerance.compareDeep(this.category, o.category, true) && AllergyIntolerance.compareDeep(this.criticality, o.criticality, true) && AllergyIntolerance.compareDeep(this.code, o.code, true) && AllergyIntolerance.compareDeep(this.patient, o.patient, true) && AllergyIntolerance.compareDeep(this.onset, o.onset, true) && AllergyIntolerance.compareDeep(this.assertedDate, o.assertedDate, true) && AllergyIntolerance.compareDeep(this.recorder, o.recorder, true) && AllergyIntolerance.compareDeep(this.asserter, o.asserter, true) && AllergyIntolerance.compareDeep(this.lastOccurrence, o.lastOccurrence, true) && AllergyIntolerance.compareDeep(this.note, o.note, true) && AllergyIntolerance.compareDeep(this.reaction, o.reaction, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof AllergyIntolerance)) {
            return false;
        }
        AllergyIntolerance o = (AllergyIntolerance)other_;
        return AllergyIntolerance.compareValues(this.clinicalStatus, o.clinicalStatus, true) && AllergyIntolerance.compareValues(this.verificationStatus, o.verificationStatus, true) && AllergyIntolerance.compareValues(this.type, o.type, true) && AllergyIntolerance.compareValues(this.category, o.category, true) && AllergyIntolerance.compareValues(this.criticality, o.criticality, true) && AllergyIntolerance.compareValues(this.assertedDate, o.assertedDate, true) && AllergyIntolerance.compareValues(this.lastOccurrence, o.lastOccurrence, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.clinicalStatus, this.verificationStatus, this.type, this.category, this.criticality, this.code, this.patient, this.onset, this.assertedDate, this.recorder, this.asserter, this.lastOccurrence, this.note, this.reaction});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.AllergyIntolerance;
    }

    @Block
    public static class AllergyIntoleranceReactionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="substance", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Specific substance or pharmaceutical product considered to be responsible for event", formalDefinition="Identification of the specific substance (or pharmaceutical product) considered to be responsible for the Adverse Reaction event. Note: the substance for a specific reaction may be different from the substance identified as the cause of the risk, but it must be consistent with it. For instance, it may be a more specific substance (e.g. a brand medication) or a composite product that includes the identified substance. It must be clinically safe to only process the 'code' and ignore the 'reaction.substance'.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/substance-code")
        protected CodeableConcept substance;
        @Child(name="manifestation", type={CodeableConcept.class}, order=2, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Clinical symptoms/signs associated with the Event", formalDefinition="Clinical symptoms and/or signs that are observed or associated with the adverse reaction event.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/clinical-findings")
        protected List<CodeableConcept> manifestation;
        @Child(name="description", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of the event as a whole", formalDefinition="Text description about the reaction as a whole, including details of the manifestation if required.")
        protected StringType description;
        @Child(name="onset", type={DateTimeType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Date(/time) when manifestations showed", formalDefinition="Record of the date and/or time of the onset of the Reaction.")
        protected DateTimeType onset;
        @Child(name="severity", type={CodeType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="mild | moderate | severe (of event as a whole)", formalDefinition="Clinical assessment of the severity of the reaction event as a whole, potentially considering multiple different manifestations.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/reaction-event-severity")
        protected Enumeration<AllergyIntoleranceSeverity> severity;
        @Child(name="exposureRoute", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="How the subject was exposed to the substance", formalDefinition="Identification of the route by which the subject was exposed to the substance.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/route-codes")
        protected CodeableConcept exposureRoute;
        @Child(name="note", type={Annotation.class}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Text about event not captured in other fields", formalDefinition="Additional text about the adverse reaction event not captured in other fields.")
        protected List<Annotation> note;
        private static final long serialVersionUID = -752118516L;

        public CodeableConcept getSubstance() {
            if (this.substance == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AllergyIntoleranceReactionComponent.substance");
                }
                if (Configuration.doAutoCreate()) {
                    this.substance = new CodeableConcept();
                }
            }
            return this.substance;
        }

        public boolean hasSubstance() {
            return this.substance != null && !this.substance.isEmpty();
        }

        public AllergyIntoleranceReactionComponent setSubstance(CodeableConcept value) {
            this.substance = value;
            return this;
        }

        public List<CodeableConcept> getManifestation() {
            if (this.manifestation == null) {
                this.manifestation = new ArrayList<CodeableConcept>();
            }
            return this.manifestation;
        }

        public AllergyIntoleranceReactionComponent setManifestation(List<CodeableConcept> theManifestation) {
            this.manifestation = theManifestation;
            return this;
        }

        public boolean hasManifestation() {
            if (this.manifestation == null) {
                return false;
            }
            for (CodeableConcept item : this.manifestation) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addManifestation() {
            CodeableConcept t = new CodeableConcept();
            if (this.manifestation == null) {
                this.manifestation = new ArrayList<CodeableConcept>();
            }
            this.manifestation.add(t);
            return t;
        }

        public AllergyIntoleranceReactionComponent addManifestation(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.manifestation == null) {
                this.manifestation = new ArrayList<CodeableConcept>();
            }
            this.manifestation.add(t);
            return this;
        }

        public CodeableConcept getManifestationFirstRep() {
            if (this.getManifestation().isEmpty()) {
                this.addManifestation();
            }
            return this.getManifestation().get(0);
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AllergyIntoleranceReactionComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public AllergyIntoleranceReactionComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public AllergyIntoleranceReactionComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public DateTimeType getOnsetElement() {
            if (this.onset == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AllergyIntoleranceReactionComponent.onset");
                }
                if (Configuration.doAutoCreate()) {
                    this.onset = new DateTimeType();
                }
            }
            return this.onset;
        }

        public boolean hasOnsetElement() {
            return this.onset != null && !this.onset.isEmpty();
        }

        public boolean hasOnset() {
            return this.onset != null && !this.onset.isEmpty();
        }

        public AllergyIntoleranceReactionComponent setOnsetElement(DateTimeType value) {
            this.onset = value;
            return this;
        }

        public Date getOnset() {
            return this.onset == null ? null : (Date)this.onset.getValue();
        }

        public AllergyIntoleranceReactionComponent setOnset(Date value) {
            if (value == null) {
                this.onset = null;
            } else {
                if (this.onset == null) {
                    this.onset = new DateTimeType();
                }
                this.onset.setValue(value);
            }
            return this;
        }

        public Enumeration<AllergyIntoleranceSeverity> getSeverityElement() {
            if (this.severity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AllergyIntoleranceReactionComponent.severity");
                }
                if (Configuration.doAutoCreate()) {
                    this.severity = new Enumeration<AllergyIntoleranceSeverity>(new AllergyIntoleranceSeverityEnumFactory());
                }
            }
            return this.severity;
        }

        public boolean hasSeverityElement() {
            return this.severity != null && !this.severity.isEmpty();
        }

        public boolean hasSeverity() {
            return this.severity != null && !this.severity.isEmpty();
        }

        public AllergyIntoleranceReactionComponent setSeverityElement(Enumeration<AllergyIntoleranceSeverity> value) {
            this.severity = value;
            return this;
        }

        public AllergyIntoleranceSeverity getSeverity() {
            return this.severity == null ? null : (AllergyIntoleranceSeverity)((Object)this.severity.getValue());
        }

        public AllergyIntoleranceReactionComponent setSeverity(AllergyIntoleranceSeverity value) {
            if (value == null) {
                this.severity = null;
            } else {
                if (this.severity == null) {
                    this.severity = new Enumeration<AllergyIntoleranceSeverity>(new AllergyIntoleranceSeverityEnumFactory());
                }
                this.severity.setValue((Object)value);
            }
            return this;
        }

        public CodeableConcept getExposureRoute() {
            if (this.exposureRoute == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AllergyIntoleranceReactionComponent.exposureRoute");
                }
                if (Configuration.doAutoCreate()) {
                    this.exposureRoute = new CodeableConcept();
                }
            }
            return this.exposureRoute;
        }

        public boolean hasExposureRoute() {
            return this.exposureRoute != null && !this.exposureRoute.isEmpty();
        }

        public AllergyIntoleranceReactionComponent setExposureRoute(CodeableConcept value) {
            this.exposureRoute = value;
            return this;
        }

        public List<Annotation> getNote() {
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            return this.note;
        }

        public AllergyIntoleranceReactionComponent setNote(List<Annotation> theNote) {
            this.note = theNote;
            return this;
        }

        public boolean hasNote() {
            if (this.note == null) {
                return false;
            }
            for (Annotation item : this.note) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Annotation addNote() {
            Annotation t = new Annotation();
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return t;
        }

        public AllergyIntoleranceReactionComponent addNote(Annotation t) {
            if (t == null) {
                return this;
            }
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return this;
        }

        public Annotation getNoteFirstRep() {
            if (this.getNote().isEmpty()) {
                this.addNote();
            }
            return this.getNote().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("substance", "CodeableConcept", "Identification of the specific substance (or pharmaceutical product) considered to be responsible for the Adverse Reaction event. Note: the substance for a specific reaction may be different from the substance identified as the cause of the risk, but it must be consistent with it. For instance, it may be a more specific substance (e.g. a brand medication) or a composite product that includes the identified substance. It must be clinically safe to only process the 'code' and ignore the 'reaction.substance'.", 0, 1, this.substance));
            children.add(new Property(AllergyIntolerance.SP_MANIFESTATION, "CodeableConcept", "Clinical symptoms and/or signs that are observed or associated with the adverse reaction event.", 0, Integer.MAX_VALUE, this.manifestation));
            children.add(new Property("description", "string", "Text description about the reaction as a whole, including details of the manifestation if required.", 0, 1, this.description));
            children.add(new Property(AllergyIntolerance.SP_ONSET, "dateTime", "Record of the date and/or time of the onset of the Reaction.", 0, 1, this.onset));
            children.add(new Property(AllergyIntolerance.SP_SEVERITY, AllergyIntolerance.SP_CODE, "Clinical assessment of the severity of the reaction event as a whole, potentially considering multiple different manifestations.", 0, 1, this.severity));
            children.add(new Property("exposureRoute", "CodeableConcept", "Identification of the route by which the subject was exposed to the substance.", 0, 1, this.exposureRoute));
            children.add(new Property("note", "Annotation", "Additional text about the adverse reaction event not captured in other fields.", 0, Integer.MAX_VALUE, this.note));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 530040176: {
                    return new Property("substance", "CodeableConcept", "Identification of the specific substance (or pharmaceutical product) considered to be responsible for the Adverse Reaction event. Note: the substance for a specific reaction may be different from the substance identified as the cause of the risk, but it must be consistent with it. For instance, it may be a more specific substance (e.g. a brand medication) or a composite product that includes the identified substance. It must be clinically safe to only process the 'code' and ignore the 'reaction.substance'.", 0, 1, this.substance);
                }
                case 1115984422: {
                    return new Property(AllergyIntolerance.SP_MANIFESTATION, "CodeableConcept", "Clinical symptoms and/or signs that are observed or associated with the adverse reaction event.", 0, Integer.MAX_VALUE, this.manifestation);
                }
                case -1724546052: {
                    return new Property("description", "string", "Text description about the reaction as a whole, including details of the manifestation if required.", 0, 1, this.description);
                }
                case 105901603: {
                    return new Property(AllergyIntolerance.SP_ONSET, "dateTime", "Record of the date and/or time of the onset of the Reaction.", 0, 1, this.onset);
                }
                case 1478300413: {
                    return new Property(AllergyIntolerance.SP_SEVERITY, AllergyIntolerance.SP_CODE, "Clinical assessment of the severity of the reaction event as a whole, potentially considering multiple different manifestations.", 0, 1, this.severity);
                }
                case 421286274: {
                    return new Property("exposureRoute", "CodeableConcept", "Identification of the route by which the subject was exposed to the substance.", 0, 1, this.exposureRoute);
                }
                case 3387378: {
                    return new Property("note", "Annotation", "Additional text about the adverse reaction event not captured in other fields.", 0, Integer.MAX_VALUE, this.note);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 530040176: {
                    Base[] baseArray;
                    if (this.substance == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.substance;
                    }
                    return baseArray;
                }
                case 1115984422: {
                    return this.manifestation == null ? new Base[]{} : this.manifestation.toArray(new Base[this.manifestation.size()]);
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.description;
                    }
                    return baseArray;
                }
                case 105901603: {
                    Base[] baseArray;
                    if (this.onset == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.onset;
                    }
                    return baseArray;
                }
                case 1478300413: {
                    Base[] baseArray;
                    if (this.severity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.severity;
                    }
                    return baseArray;
                }
                case 421286274: {
                    Base[] baseArray;
                    if (this.exposureRoute == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.exposureRoute;
                    }
                    return baseArray;
                }
                case 3387378: {
                    return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 530040176: {
                    this.substance = this.castToCodeableConcept(value);
                    return value;
                }
                case 1115984422: {
                    this.getManifestation().add(this.castToCodeableConcept(value));
                    return value;
                }
                case -1724546052: {
                    this.description = this.castToString(value);
                    return value;
                }
                case 105901603: {
                    this.onset = this.castToDateTime(value);
                    return value;
                }
                case 1478300413: {
                    value = new AllergyIntoleranceSeverityEnumFactory().fromType(this.castToCode(value));
                    this.severity = value;
                    return value;
                }
                case 421286274: {
                    this.exposureRoute = this.castToCodeableConcept(value);
                    return value;
                }
                case 3387378: {
                    this.getNote().add(this.castToAnnotation(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("substance")) {
                this.substance = this.castToCodeableConcept(value);
            } else if (name.equals(AllergyIntolerance.SP_MANIFESTATION)) {
                this.getManifestation().add(this.castToCodeableConcept(value));
            } else if (name.equals("description")) {
                this.description = this.castToString(value);
            } else if (name.equals(AllergyIntolerance.SP_ONSET)) {
                this.onset = this.castToDateTime(value);
            } else if (name.equals(AllergyIntolerance.SP_SEVERITY)) {
                value = new AllergyIntoleranceSeverityEnumFactory().fromType(this.castToCode(value));
                this.severity = value;
            } else if (name.equals("exposureRoute")) {
                this.exposureRoute = this.castToCodeableConcept(value);
            } else if (name.equals("note")) {
                this.getNote().add(this.castToAnnotation(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 530040176: {
                    return this.getSubstance();
                }
                case 1115984422: {
                    return this.addManifestation();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 105901603: {
                    return this.getOnsetElement();
                }
                case 1478300413: {
                    return this.getSeverityElement();
                }
                case 421286274: {
                    return this.getExposureRoute();
                }
                case 3387378: {
                    return this.addNote();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 530040176: {
                    return new String[]{"CodeableConcept"};
                }
                case 1115984422: {
                    return new String[]{"CodeableConcept"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case 105901603: {
                    return new String[]{"dateTime"};
                }
                case 1478300413: {
                    return new String[]{AllergyIntolerance.SP_CODE};
                }
                case 421286274: {
                    return new String[]{"CodeableConcept"};
                }
                case 3387378: {
                    return new String[]{"Annotation"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("substance")) {
                this.substance = new CodeableConcept();
                return this.substance;
            }
            if (name.equals(AllergyIntolerance.SP_MANIFESTATION)) {
                return this.addManifestation();
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type AllergyIntolerance.description");
            }
            if (name.equals(AllergyIntolerance.SP_ONSET)) {
                throw new FHIRException("Cannot call addChild on a primitive type AllergyIntolerance.onset");
            }
            if (name.equals(AllergyIntolerance.SP_SEVERITY)) {
                throw new FHIRException("Cannot call addChild on a primitive type AllergyIntolerance.severity");
            }
            if (name.equals("exposureRoute")) {
                this.exposureRoute = new CodeableConcept();
                return this.exposureRoute;
            }
            if (name.equals("note")) {
                return this.addNote();
            }
            return super.addChild(name);
        }

        @Override
        public AllergyIntoleranceReactionComponent copy() {
            AllergyIntoleranceReactionComponent dst = new AllergyIntoleranceReactionComponent();
            this.copyValues(dst);
            CodeableConcept codeableConcept = dst.substance = this.substance == null ? null : this.substance.copy();
            if (this.manifestation != null) {
                dst.manifestation = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.manifestation) {
                    dst.manifestation.add(codeableConcept2.copy());
                }
            }
            dst.description = this.description == null ? null : this.description.copy();
            dst.onset = this.onset == null ? null : this.onset.copy();
            dst.severity = this.severity == null ? null : this.severity.copy();
            CodeableConcept codeableConcept3 = dst.exposureRoute = this.exposureRoute == null ? null : this.exposureRoute.copy();
            if (this.note != null) {
                dst.note = new ArrayList<Annotation>();
                for (Annotation annotation : this.note) {
                    dst.note.add(annotation.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AllergyIntoleranceReactionComponent)) {
                return false;
            }
            AllergyIntoleranceReactionComponent o = (AllergyIntoleranceReactionComponent)other_;
            return AllergyIntoleranceReactionComponent.compareDeep(this.substance, o.substance, true) && AllergyIntoleranceReactionComponent.compareDeep(this.manifestation, o.manifestation, true) && AllergyIntoleranceReactionComponent.compareDeep(this.description, o.description, true) && AllergyIntoleranceReactionComponent.compareDeep(this.onset, o.onset, true) && AllergyIntoleranceReactionComponent.compareDeep(this.severity, o.severity, true) && AllergyIntoleranceReactionComponent.compareDeep(this.exposureRoute, o.exposureRoute, true) && AllergyIntoleranceReactionComponent.compareDeep(this.note, o.note, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AllergyIntoleranceReactionComponent)) {
                return false;
            }
            AllergyIntoleranceReactionComponent o = (AllergyIntoleranceReactionComponent)other_;
            return AllergyIntoleranceReactionComponent.compareValues(this.description, o.description, true) && AllergyIntoleranceReactionComponent.compareValues(this.onset, o.onset, true) && AllergyIntoleranceReactionComponent.compareValues(this.severity, o.severity, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.substance, this.manifestation, this.description, this.onset, this.severity, this.exposureRoute, this.note});
        }

        @Override
        public String fhirType() {
            return "AllergyIntolerance.reaction";
        }
    }

    public static class AllergyIntoleranceSeverityEnumFactory
    implements EnumFactory<AllergyIntoleranceSeverity> {
        @Override
        public AllergyIntoleranceSeverity fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("mild".equals(codeString)) {
                return AllergyIntoleranceSeverity.MILD;
            }
            if ("moderate".equals(codeString)) {
                return AllergyIntoleranceSeverity.MODERATE;
            }
            if ("severe".equals(codeString)) {
                return AllergyIntoleranceSeverity.SEVERE;
            }
            throw new IllegalArgumentException("Unknown AllergyIntoleranceSeverity code '" + codeString + "'");
        }

        public Enumeration<AllergyIntoleranceSeverity> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<AllergyIntoleranceSeverity>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("mild".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceSeverity>(this, AllergyIntoleranceSeverity.MILD);
            }
            if ("moderate".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceSeverity>(this, AllergyIntoleranceSeverity.MODERATE);
            }
            if ("severe".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceSeverity>(this, AllergyIntoleranceSeverity.SEVERE);
            }
            throw new FHIRException("Unknown AllergyIntoleranceSeverity code '" + codeString + "'");
        }

        @Override
        public String toCode(AllergyIntoleranceSeverity code) {
            if (code == AllergyIntoleranceSeverity.MILD) {
                return "mild";
            }
            if (code == AllergyIntoleranceSeverity.MODERATE) {
                return "moderate";
            }
            if (code == AllergyIntoleranceSeverity.SEVERE) {
                return "severe";
            }
            return "?";
        }

        @Override
        public String toSystem(AllergyIntoleranceSeverity code) {
            return code.getSystem();
        }
    }

    public static enum AllergyIntoleranceSeverity {
        MILD,
        MODERATE,
        SEVERE,
        NULL;


        public static AllergyIntoleranceSeverity fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("mild".equals(codeString)) {
                return MILD;
            }
            if ("moderate".equals(codeString)) {
                return MODERATE;
            }
            if ("severe".equals(codeString)) {
                return SEVERE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown AllergyIntoleranceSeverity code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case MILD: {
                    return "mild";
                }
                case MODERATE: {
                    return "moderate";
                }
                case SEVERE: {
                    return "severe";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case MILD: {
                    return "http://hl7.org/fhir/reaction-event-severity";
                }
                case MODERATE: {
                    return "http://hl7.org/fhir/reaction-event-severity";
                }
                case SEVERE: {
                    return "http://hl7.org/fhir/reaction-event-severity";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case MILD: {
                    return "Causes mild physiological effects.";
                }
                case MODERATE: {
                    return "Causes moderate physiological effects.";
                }
                case SEVERE: {
                    return "Causes severe physiological effects.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case MILD: {
                    return "Mild";
                }
                case MODERATE: {
                    return "Moderate";
                }
                case SEVERE: {
                    return "Severe";
                }
            }
            return "?";
        }
    }

    public static class AllergyIntoleranceCriticalityEnumFactory
    implements EnumFactory<AllergyIntoleranceCriticality> {
        @Override
        public AllergyIntoleranceCriticality fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("low".equals(codeString)) {
                return AllergyIntoleranceCriticality.LOW;
            }
            if ("high".equals(codeString)) {
                return AllergyIntoleranceCriticality.HIGH;
            }
            if ("unable-to-assess".equals(codeString)) {
                return AllergyIntoleranceCriticality.UNABLETOASSESS;
            }
            throw new IllegalArgumentException("Unknown AllergyIntoleranceCriticality code '" + codeString + "'");
        }

        public Enumeration<AllergyIntoleranceCriticality> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<AllergyIntoleranceCriticality>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("low".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceCriticality>(this, AllergyIntoleranceCriticality.LOW);
            }
            if ("high".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceCriticality>(this, AllergyIntoleranceCriticality.HIGH);
            }
            if ("unable-to-assess".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceCriticality>(this, AllergyIntoleranceCriticality.UNABLETOASSESS);
            }
            throw new FHIRException("Unknown AllergyIntoleranceCriticality code '" + codeString + "'");
        }

        @Override
        public String toCode(AllergyIntoleranceCriticality code) {
            if (code == AllergyIntoleranceCriticality.LOW) {
                return "low";
            }
            if (code == AllergyIntoleranceCriticality.HIGH) {
                return "high";
            }
            if (code == AllergyIntoleranceCriticality.UNABLETOASSESS) {
                return "unable-to-assess";
            }
            return "?";
        }

        @Override
        public String toSystem(AllergyIntoleranceCriticality code) {
            return code.getSystem();
        }
    }

    public static enum AllergyIntoleranceCriticality {
        LOW,
        HIGH,
        UNABLETOASSESS,
        NULL;


        public static AllergyIntoleranceCriticality fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("low".equals(codeString)) {
                return LOW;
            }
            if ("high".equals(codeString)) {
                return HIGH;
            }
            if ("unable-to-assess".equals(codeString)) {
                return UNABLETOASSESS;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown AllergyIntoleranceCriticality code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case LOW: {
                    return "low";
                }
                case HIGH: {
                    return "high";
                }
                case UNABLETOASSESS: {
                    return "unable-to-assess";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case LOW: {
                    return "http://hl7.org/fhir/allergy-intolerance-criticality";
                }
                case HIGH: {
                    return "http://hl7.org/fhir/allergy-intolerance-criticality";
                }
                case UNABLETOASSESS: {
                    return "http://hl7.org/fhir/allergy-intolerance-criticality";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case LOW: {
                    return "Worst case result of a future exposure is not assessed to be life-threatening or having high potential for organ system failure.";
                }
                case HIGH: {
                    return "Worst case result of a future exposure is assessed to be life-threatening or having high potential for organ system failure.";
                }
                case UNABLETOASSESS: {
                    return "Unable to assess the worst case result of a future exposure.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case LOW: {
                    return "Low Risk";
                }
                case HIGH: {
                    return "High Risk";
                }
                case UNABLETOASSESS: {
                    return "Unable to Assess Risk";
                }
            }
            return "?";
        }
    }

    public static class AllergyIntoleranceCategoryEnumFactory
    implements EnumFactory<AllergyIntoleranceCategory> {
        @Override
        public AllergyIntoleranceCategory fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("food".equals(codeString)) {
                return AllergyIntoleranceCategory.FOOD;
            }
            if ("medication".equals(codeString)) {
                return AllergyIntoleranceCategory.MEDICATION;
            }
            if ("environment".equals(codeString)) {
                return AllergyIntoleranceCategory.ENVIRONMENT;
            }
            if ("biologic".equals(codeString)) {
                return AllergyIntoleranceCategory.BIOLOGIC;
            }
            throw new IllegalArgumentException("Unknown AllergyIntoleranceCategory code '" + codeString + "'");
        }

        public Enumeration<AllergyIntoleranceCategory> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<AllergyIntoleranceCategory>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("food".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceCategory>(this, AllergyIntoleranceCategory.FOOD);
            }
            if ("medication".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceCategory>(this, AllergyIntoleranceCategory.MEDICATION);
            }
            if ("environment".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceCategory>(this, AllergyIntoleranceCategory.ENVIRONMENT);
            }
            if ("biologic".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceCategory>(this, AllergyIntoleranceCategory.BIOLOGIC);
            }
            throw new FHIRException("Unknown AllergyIntoleranceCategory code '" + codeString + "'");
        }

        @Override
        public String toCode(AllergyIntoleranceCategory code) {
            if (code == AllergyIntoleranceCategory.FOOD) {
                return "food";
            }
            if (code == AllergyIntoleranceCategory.MEDICATION) {
                return "medication";
            }
            if (code == AllergyIntoleranceCategory.ENVIRONMENT) {
                return "environment";
            }
            if (code == AllergyIntoleranceCategory.BIOLOGIC) {
                return "biologic";
            }
            return "?";
        }

        @Override
        public String toSystem(AllergyIntoleranceCategory code) {
            return code.getSystem();
        }
    }

    public static enum AllergyIntoleranceCategory {
        FOOD,
        MEDICATION,
        ENVIRONMENT,
        BIOLOGIC,
        NULL;


        public static AllergyIntoleranceCategory fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("food".equals(codeString)) {
                return FOOD;
            }
            if ("medication".equals(codeString)) {
                return MEDICATION;
            }
            if ("environment".equals(codeString)) {
                return ENVIRONMENT;
            }
            if ("biologic".equals(codeString)) {
                return BIOLOGIC;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown AllergyIntoleranceCategory code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case FOOD: {
                    return "food";
                }
                case MEDICATION: {
                    return "medication";
                }
                case ENVIRONMENT: {
                    return "environment";
                }
                case BIOLOGIC: {
                    return "biologic";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case FOOD: {
                    return "http://hl7.org/fhir/allergy-intolerance-category";
                }
                case MEDICATION: {
                    return "http://hl7.org/fhir/allergy-intolerance-category";
                }
                case ENVIRONMENT: {
                    return "http://hl7.org/fhir/allergy-intolerance-category";
                }
                case BIOLOGIC: {
                    return "http://hl7.org/fhir/allergy-intolerance-category";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case FOOD: {
                    return "Any substance consumed to provide nutritional support for the body.";
                }
                case MEDICATION: {
                    return "Substances administered to achieve a physiological effect.";
                }
                case ENVIRONMENT: {
                    return "Any substances that are encountered in the environment, including any substance not already classified as food, medication, or biologic.";
                }
                case BIOLOGIC: {
                    return "A preparation that is synthesized from living organisms or their products, especially a human or animal protein, such as a hormone or antitoxin, that is used as a diagnostic, preventive, or therapeutic agent. Examples of biologic medications include: vaccines; allergenic extracts, which are used for both diagnosis and treatment (for example, allergy shots); gene therapies; cellular therapies.  There are other biologic products, such as tissues, that are not typically associated with allergies.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case FOOD: {
                    return "Food";
                }
                case MEDICATION: {
                    return "Medication";
                }
                case ENVIRONMENT: {
                    return "Environment";
                }
                case BIOLOGIC: {
                    return "Biologic";
                }
            }
            return "?";
        }
    }

    public static class AllergyIntoleranceTypeEnumFactory
    implements EnumFactory<AllergyIntoleranceType> {
        @Override
        public AllergyIntoleranceType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("allergy".equals(codeString)) {
                return AllergyIntoleranceType.ALLERGY;
            }
            if ("intolerance".equals(codeString)) {
                return AllergyIntoleranceType.INTOLERANCE;
            }
            throw new IllegalArgumentException("Unknown AllergyIntoleranceType code '" + codeString + "'");
        }

        public Enumeration<AllergyIntoleranceType> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<AllergyIntoleranceType>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("allergy".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceType>(this, AllergyIntoleranceType.ALLERGY);
            }
            if ("intolerance".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceType>(this, AllergyIntoleranceType.INTOLERANCE);
            }
            throw new FHIRException("Unknown AllergyIntoleranceType code '" + codeString + "'");
        }

        @Override
        public String toCode(AllergyIntoleranceType code) {
            if (code == AllergyIntoleranceType.ALLERGY) {
                return "allergy";
            }
            if (code == AllergyIntoleranceType.INTOLERANCE) {
                return "intolerance";
            }
            return "?";
        }

        @Override
        public String toSystem(AllergyIntoleranceType code) {
            return code.getSystem();
        }
    }

    public static enum AllergyIntoleranceType {
        ALLERGY,
        INTOLERANCE,
        NULL;


        public static AllergyIntoleranceType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("allergy".equals(codeString)) {
                return ALLERGY;
            }
            if ("intolerance".equals(codeString)) {
                return INTOLERANCE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown AllergyIntoleranceType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ALLERGY: {
                    return "allergy";
                }
                case INTOLERANCE: {
                    return "intolerance";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ALLERGY: {
                    return "http://hl7.org/fhir/allergy-intolerance-type";
                }
                case INTOLERANCE: {
                    return "http://hl7.org/fhir/allergy-intolerance-type";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ALLERGY: {
                    return "A propensity for hypersensitivity reaction(s) to a substance.  These reactions are most typically type I hypersensitivity, plus other \"allergy-like\" reactions, including pseudoallergy.";
                }
                case INTOLERANCE: {
                    return "A propensity for adverse reactions to a substance that is not judged to be allergic or \"allergy-like\".  These reactions are typically (but not necessarily) non-immune.  They are to some degree idiosyncratic and/or individually specific (i.e. are not a reaction that is expected to occur with most or all patients given similar circumstances).";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ALLERGY: {
                    return "Allergy";
                }
                case INTOLERANCE: {
                    return "Intolerance";
                }
            }
            return "?";
        }
    }

    public static class AllergyIntoleranceVerificationStatusEnumFactory
    implements EnumFactory<AllergyIntoleranceVerificationStatus> {
        @Override
        public AllergyIntoleranceVerificationStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("unconfirmed".equals(codeString)) {
                return AllergyIntoleranceVerificationStatus.UNCONFIRMED;
            }
            if ("confirmed".equals(codeString)) {
                return AllergyIntoleranceVerificationStatus.CONFIRMED;
            }
            if ("refuted".equals(codeString)) {
                return AllergyIntoleranceVerificationStatus.REFUTED;
            }
            if ("entered-in-error".equals(codeString)) {
                return AllergyIntoleranceVerificationStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown AllergyIntoleranceVerificationStatus code '" + codeString + "'");
        }

        public Enumeration<AllergyIntoleranceVerificationStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<AllergyIntoleranceVerificationStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("unconfirmed".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceVerificationStatus>(this, AllergyIntoleranceVerificationStatus.UNCONFIRMED);
            }
            if ("confirmed".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceVerificationStatus>(this, AllergyIntoleranceVerificationStatus.CONFIRMED);
            }
            if ("refuted".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceVerificationStatus>(this, AllergyIntoleranceVerificationStatus.REFUTED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceVerificationStatus>(this, AllergyIntoleranceVerificationStatus.ENTEREDINERROR);
            }
            throw new FHIRException("Unknown AllergyIntoleranceVerificationStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(AllergyIntoleranceVerificationStatus code) {
            if (code == AllergyIntoleranceVerificationStatus.UNCONFIRMED) {
                return "unconfirmed";
            }
            if (code == AllergyIntoleranceVerificationStatus.CONFIRMED) {
                return "confirmed";
            }
            if (code == AllergyIntoleranceVerificationStatus.REFUTED) {
                return "refuted";
            }
            if (code == AllergyIntoleranceVerificationStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(AllergyIntoleranceVerificationStatus code) {
            return code.getSystem();
        }
    }

    public static enum AllergyIntoleranceVerificationStatus {
        UNCONFIRMED,
        CONFIRMED,
        REFUTED,
        ENTEREDINERROR,
        NULL;


        public static AllergyIntoleranceVerificationStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("unconfirmed".equals(codeString)) {
                return UNCONFIRMED;
            }
            if ("confirmed".equals(codeString)) {
                return CONFIRMED;
            }
            if ("refuted".equals(codeString)) {
                return REFUTED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown AllergyIntoleranceVerificationStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case UNCONFIRMED: {
                    return "unconfirmed";
                }
                case CONFIRMED: {
                    return "confirmed";
                }
                case REFUTED: {
                    return "refuted";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case UNCONFIRMED: {
                    return "http://hl7.org/fhir/allergy-verification-status";
                }
                case CONFIRMED: {
                    return "http://hl7.org/fhir/allergy-verification-status";
                }
                case REFUTED: {
                    return "http://hl7.org/fhir/allergy-verification-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/allergy-verification-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case UNCONFIRMED: {
                    return "A low level of certainty about the propensity for a reaction to the identified substance.";
                }
                case CONFIRMED: {
                    return "A high level of certainty about the propensity for a reaction to the identified substance, which may include clinical evidence by testing or rechallenge.";
                }
                case REFUTED: {
                    return "A propensity for a reaction to the identified substance has been disproven with a high level of clinical certainty, which may include testing or rechallenge, and is refuted.";
                }
                case ENTEREDINERROR: {
                    return "The statement was entered in error and is not valid.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case UNCONFIRMED: {
                    return "Unconfirmed";
                }
                case CONFIRMED: {
                    return "Confirmed";
                }
                case REFUTED: {
                    return "Refuted";
                }
                case ENTEREDINERROR: {
                    return "Entered In Error";
                }
            }
            return "?";
        }
    }

    public static class AllergyIntoleranceClinicalStatusEnumFactory
    implements EnumFactory<AllergyIntoleranceClinicalStatus> {
        @Override
        public AllergyIntoleranceClinicalStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return AllergyIntoleranceClinicalStatus.ACTIVE;
            }
            if ("inactive".equals(codeString)) {
                return AllergyIntoleranceClinicalStatus.INACTIVE;
            }
            if ("resolved".equals(codeString)) {
                return AllergyIntoleranceClinicalStatus.RESOLVED;
            }
            throw new IllegalArgumentException("Unknown AllergyIntoleranceClinicalStatus code '" + codeString + "'");
        }

        public Enumeration<AllergyIntoleranceClinicalStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<AllergyIntoleranceClinicalStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceClinicalStatus>(this, AllergyIntoleranceClinicalStatus.ACTIVE);
            }
            if ("inactive".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceClinicalStatus>(this, AllergyIntoleranceClinicalStatus.INACTIVE);
            }
            if ("resolved".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceClinicalStatus>(this, AllergyIntoleranceClinicalStatus.RESOLVED);
            }
            throw new FHIRException("Unknown AllergyIntoleranceClinicalStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(AllergyIntoleranceClinicalStatus code) {
            if (code == AllergyIntoleranceClinicalStatus.ACTIVE) {
                return "active";
            }
            if (code == AllergyIntoleranceClinicalStatus.INACTIVE) {
                return "inactive";
            }
            if (code == AllergyIntoleranceClinicalStatus.RESOLVED) {
                return "resolved";
            }
            return "?";
        }

        @Override
        public String toSystem(AllergyIntoleranceClinicalStatus code) {
            return code.getSystem();
        }
    }

    public static enum AllergyIntoleranceClinicalStatus {
        ACTIVE,
        INACTIVE,
        RESOLVED,
        NULL;


        public static AllergyIntoleranceClinicalStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("inactive".equals(codeString)) {
                return INACTIVE;
            }
            if ("resolved".equals(codeString)) {
                return RESOLVED;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown AllergyIntoleranceClinicalStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case INACTIVE: {
                    return "inactive";
                }
                case RESOLVED: {
                    return "resolved";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/allergy-clinical-status";
                }
                case INACTIVE: {
                    return "http://hl7.org/fhir/allergy-clinical-status";
                }
                case RESOLVED: {
                    return "http://hl7.org/fhir/allergy-clinical-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "An active record of a risk of a reaction to the identified substance.";
                }
                case INACTIVE: {
                    return "An inactivated record of a risk of a reaction to the identified substance.";
                }
                case RESOLVED: {
                    return "A reaction to the identified substance has been clinically reassessed by testing or re-exposure and considered to be resolved.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case INACTIVE: {
                    return "Inactive";
                }
                case RESOLVED: {
                    return "Resolved";
                }
            }
            return "?";
        }
    }
}

