/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ServicePharmacy {
    SMOKECESS,
    FLUSHOT,
    DRUGCOST,
    MARKUP,
    DISPENSEFEE,
    COMPOUNDFEE,
    NULL;


    public static ServicePharmacy fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("smokecess".equals(codeString)) {
            return SMOKECESS;
        }
        if ("flushot".equals(codeString)) {
            return FLUSHOT;
        }
        if ("drugcost".equals(codeString)) {
            return DRUGCOST;
        }
        if ("markup".equals(codeString)) {
            return MARKUP;
        }
        if ("dispensefee".equals(codeString)) {
            return DISPENSEFEE;
        }
        if ("compoundfee".equals(codeString)) {
            return COMPOUNDFEE;
        }
        throw new FHIRException("Unknown ServicePharmacy code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case SMOKECESS: {
                return "smokecess";
            }
            case FLUSHOT: {
                return "flushot";
            }
            case DRUGCOST: {
                return "drugcost";
            }
            case MARKUP: {
                return "markup";
            }
            case DISPENSEFEE: {
                return "dispensefee";
            }
            case COMPOUNDFEE: {
                return "compoundfee";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/ex-pharmaservice";
    }

    public String getDefinition() {
        switch (this) {
            case SMOKECESS: {
                return "Smoking cessation";
            }
            case FLUSHOT: {
                return "Flu Shot";
            }
            case DRUGCOST: {
                return "The wholesale price of the medication.";
            }
            case MARKUP: {
                return "The additional cost assessed on the drug.";
            }
            case DISPENSEFEE: {
                return "The professional fee charged for dispensing the product or service.";
            }
            case COMPOUNDFEE: {
                return "The professional fee charged for compounding the medication.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case SMOKECESS: {
                return "Smoking cessation";
            }
            case FLUSHOT: {
                return "Flu Shot";
            }
            case DRUGCOST: {
                return "Drug Cost";
            }
            case MARKUP: {
                return "Markup";
            }
            case DISPENSEFEE: {
                return "Dispense Fee";
            }
            case COMPOUNDFEE: {
                return "Compounding Fee";
            }
        }
        return "?";
    }
}

