/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.MeasureScoring;

public class MeasureScoringEnumFactory
implements EnumFactory<MeasureScoring> {
    @Override
    public MeasureScoring fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("proportion".equals(codeString)) {
            return MeasureScoring.PROPORTION;
        }
        if ("ratio".equals(codeString)) {
            return MeasureScoring.RATIO;
        }
        if ("continuous-variable".equals(codeString)) {
            return MeasureScoring.CONTINUOUSVARIABLE;
        }
        if ("cohort".equals(codeString)) {
            return MeasureScoring.COHORT;
        }
        throw new IllegalArgumentException("Unknown MeasureScoring code '" + codeString + "'");
    }

    @Override
    public String toCode(MeasureScoring code) {
        if (code == MeasureScoring.PROPORTION) {
            return "proportion";
        }
        if (code == MeasureScoring.RATIO) {
            return "ratio";
        }
        if (code == MeasureScoring.CONTINUOUSVARIABLE) {
            return "continuous-variable";
        }
        if (code == MeasureScoring.COHORT) {
            return "cohort";
        }
        return "?";
    }

    @Override
    public String toSystem(MeasureScoring code) {
        return code.getSystem();
    }
}

