/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.Patient;
import org.hl7.fhir.dstu3.model.Practitioner;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.RelatedPerson;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.instance.model.api.ICompositeType;

@DatatypeDef(name="Annotation")
public class Annotation
extends Type
implements ICompositeType {
    @Child(name="author", type={Practitioner.class, Patient.class, RelatedPerson.class, StringType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Individual responsible for the annotation", formalDefinition="The individual responsible for making the annotation.")
    protected Type author;
    @Child(name="time", type={DateTimeType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the annotation was made", formalDefinition="Indicates when this particular annotation was made.")
    protected DateTimeType time;
    @Child(name="text", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The annotation  - text content", formalDefinition="The text of the annotation.")
    protected StringType text;
    private static final long serialVersionUID = -575590381L;

    public Annotation() {
    }

    public Annotation(StringType text) {
        this.text = text;
    }

    public Type getAuthor() {
        return this.author;
    }

    public Reference getAuthorReference() throws FHIRException {
        if (this.author == null) {
            return null;
        }
        if (!(this.author instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.author.getClass().getName() + " was encountered");
        }
        return (Reference)this.author;
    }

    public boolean hasAuthorReference() {
        return this != null && this.author instanceof Reference;
    }

    public StringType getAuthorStringType() throws FHIRException {
        if (this.author == null) {
            return null;
        }
        if (!(this.author instanceof StringType)) {
            throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.author.getClass().getName() + " was encountered");
        }
        return (StringType)this.author;
    }

    public boolean hasAuthorStringType() {
        return this != null && this.author instanceof StringType;
    }

    public boolean hasAuthor() {
        return this.author != null && !this.author.isEmpty();
    }

    public Annotation setAuthor(Type value) throws FHIRFormatError {
        if (value != null && !(value instanceof Reference) && !(value instanceof StringType)) {
            throw new FHIRFormatError("Not the right type for Annotation.author[x]: " + value.fhirType());
        }
        this.author = value;
        return this;
    }

    public DateTimeType getTimeElement() {
        if (this.time == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Annotation.time");
            }
            if (Configuration.doAutoCreate()) {
                this.time = new DateTimeType();
            }
        }
        return this.time;
    }

    public boolean hasTimeElement() {
        return this.time != null && !this.time.isEmpty();
    }

    public boolean hasTime() {
        return this.time != null && !this.time.isEmpty();
    }

    public Annotation setTimeElement(DateTimeType value) {
        this.time = value;
        return this;
    }

    public Date getTime() {
        return this.time == null ? null : (Date)this.time.getValue();
    }

    public Annotation setTime(Date value) {
        if (value == null) {
            this.time = null;
        } else {
            if (this.time == null) {
                this.time = new DateTimeType();
            }
            this.time.setValue(value);
        }
        return this;
    }

    public StringType getTextElement() {
        if (this.text == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Annotation.text");
            }
            if (Configuration.doAutoCreate()) {
                this.text = new StringType();
            }
        }
        return this.text;
    }

    public boolean hasTextElement() {
        return this.text != null && !this.text.isEmpty();
    }

    public boolean hasText() {
        return this.text != null && !this.text.isEmpty();
    }

    public Annotation setTextElement(StringType value) {
        this.text = value;
        return this;
    }

    public String getText() {
        return this.text == null ? null : (String)this.text.getValue();
    }

    public Annotation setText(String value) {
        if (this.text == null) {
            this.text = new StringType();
        }
        this.text.setValue(value);
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("author[x]", "Reference(Practitioner|Patient|RelatedPerson)|string", "The individual responsible for making the annotation.", 0, 1, this.author));
        children.add(new Property("time", "dateTime", "Indicates when this particular annotation was made.", 0, 1, this.time));
        children.add(new Property("text", "string", "The text of the annotation.", 0, 1, this.text));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 1475597077: {
                return new Property("author[x]", "Reference(Practitioner|Patient|RelatedPerson)|string", "The individual responsible for making the annotation.", 0, 1, this.author);
            }
            case -1406328437: {
                return new Property("author[x]", "Reference(Practitioner|Patient|RelatedPerson)|string", "The individual responsible for making the annotation.", 0, 1, this.author);
            }
            case 305515008: {
                return new Property("author[x]", "Reference(Practitioner|Patient|RelatedPerson)|string", "The individual responsible for making the annotation.", 0, 1, this.author);
            }
            case 290249084: {
                return new Property("author[x]", "Reference(Practitioner|Patient|RelatedPerson)|string", "The individual responsible for making the annotation.", 0, 1, this.author);
            }
            case 3560141: {
                return new Property("time", "dateTime", "Indicates when this particular annotation was made.", 0, 1, this.time);
            }
            case 3556653: {
                return new Property("text", "string", "The text of the annotation.", 0, 1, this.text);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1406328437: {
                Base[] baseArray;
                if (this.author == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.author;
                }
                return baseArray;
            }
            case 3560141: {
                Base[] baseArray;
                if (this.time == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.time;
                }
                return baseArray;
            }
            case 3556653: {
                Base[] baseArray;
                if (this.text == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.text;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1406328437: {
                this.author = this.castToType(value);
                return value;
            }
            case 3560141: {
                this.time = this.castToDateTime(value);
                return value;
            }
            case 3556653: {
                this.text = this.castToString(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("author[x]")) {
            this.author = this.castToType(value);
        } else if (name.equals("time")) {
            this.time = this.castToDateTime(value);
        } else if (name.equals("text")) {
            this.text = this.castToString(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1475597077: {
                return this.getAuthor();
            }
            case -1406328437: {
                return this.getAuthor();
            }
            case 3560141: {
                return this.getTimeElement();
            }
            case 3556653: {
                return this.getTextElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1406328437: {
                return new String[]{"Reference", "string"};
            }
            case 3560141: {
                return new String[]{"dateTime"};
            }
            case 3556653: {
                return new String[]{"string"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("authorReference")) {
            this.author = new Reference();
            return this.author;
        }
        if (name.equals("authorString")) {
            this.author = new StringType();
            return this.author;
        }
        if (name.equals("time")) {
            throw new FHIRException("Cannot call addChild on a primitive type Annotation.time");
        }
        if (name.equals("text")) {
            throw new FHIRException("Cannot call addChild on a primitive type Annotation.text");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Annotation";
    }

    @Override
    public Annotation copy() {
        Annotation dst = new Annotation();
        this.copyValues(dst);
        dst.author = this.author == null ? null : this.author.copy();
        dst.time = this.time == null ? null : this.time.copy();
        dst.text = this.text == null ? null : this.text.copy();
        return dst;
    }

    @Override
    protected Annotation typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Annotation)) {
            return false;
        }
        Annotation o = (Annotation)other_;
        return Annotation.compareDeep(this.author, o.author, true) && Annotation.compareDeep(this.time, o.time, true) && Annotation.compareDeep(this.text, o.text, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Annotation)) {
            return false;
        }
        Annotation o = (Annotation)other_;
        return Annotation.compareValues(this.time, o.time, true) && Annotation.compareValues(this.text, o.text, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.author, this.time, this.text});
    }
}

