/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.terminologies;

import java.util.List;
import org.hl7.fhir.dstu3.model.BooleanType;
import org.hl7.fhir.dstu3.model.CodeSystem;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Meta;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;

public class CodeSystemUtilities {
    public static boolean isDeprecated(CodeSystem cs, CodeSystem.ConceptDefinitionComponent def) {
        for (CodeSystem.ConceptPropertyComponent p : def.getProperty()) {
            if (!p.getCode().equals("deprecated") || !p.hasValue() || !(p.getValue() instanceof BooleanType)) continue;
            return (Boolean)((BooleanType)p.getValue()).getValue();
        }
        return false;
    }

    public static boolean isNotSelectable(CodeSystem cs, CodeSystem.ConceptDefinitionComponent def) {
        for (CodeSystem.ConceptPropertyComponent p : def.getProperty()) {
            if (!p.getCode().equals("notSelectable") || !p.hasValue() || !(p.getValue() instanceof BooleanType)) continue;
            return (Boolean)((BooleanType)p.getValue()).getValue();
        }
        return false;
    }

    public static void setNotSelectable(CodeSystem cs, CodeSystem.ConceptDefinitionComponent concept) {
        CodeSystemUtilities.defineNotSelectableProperty(cs);
        concept.addProperty().setCode("notSelectable").setValue(new BooleanType(true));
    }

    public static void setInactive(CodeSystem cs, CodeSystem.ConceptDefinitionComponent concept) {
        CodeSystemUtilities.defineInactiveProperty(cs);
        concept.addProperty().setCode("inactive").setValue(new BooleanType(true));
    }

    public static void setDeprecated(CodeSystem cs, CodeSystem.ConceptDefinitionComponent concept, DateTimeType date) {
        CodeSystemUtilities.defineDeprecatedProperty(cs);
        concept.addProperty().setCode("deprecated").setValue(date);
    }

    public static void defineNotSelectableProperty(CodeSystem cs) {
        CodeSystemUtilities.defineCodeSystemProperty(cs, "notSelectable", "Indicates that the code is abstract - only intended to be used as a selector for other concepts", CodeSystem.PropertyType.BOOLEAN);
    }

    public static void defineInactiveProperty(CodeSystem cs) {
        CodeSystemUtilities.defineCodeSystemProperty(cs, "inactive", "True if the concept is not considered active - e.g. not a valid concept any more", CodeSystem.PropertyType.BOOLEAN);
    }

    public static void defineDeprecatedProperty(CodeSystem cs) {
        CodeSystemUtilities.defineCodeSystemProperty(cs, "deprecated", "The date at which a concept was deprecated. Concepts that are deprecated but not inactive can still be used, but their use is discouraged", CodeSystem.PropertyType.DATETIME);
    }

    public static void defineCodeSystemProperty(CodeSystem cs, String code, String description, CodeSystem.PropertyType type) {
        for (CodeSystem.PropertyComponent p : cs.getProperty()) {
            if (!p.getCode().equals(code)) continue;
            return;
        }
        cs.addProperty().setCode(code).setDescription(description).setType(type).setUri("http://hl7.org/fhir/concept-properties#" + code);
    }

    public static String getCodeDefinition(CodeSystem cs, String code) {
        return CodeSystemUtilities.getCodeDefinition(cs.getConcept(), code);
    }

    private static String getCodeDefinition(List<CodeSystem.ConceptDefinitionComponent> list, String code) {
        for (CodeSystem.ConceptDefinitionComponent c : list) {
            if (c.getCode().equals(code)) {
                return c.getDefinition();
            }
            String s = CodeSystemUtilities.getCodeDefinition(c.getConcept(), code);
            if (s == null) continue;
            return s;
        }
        return null;
    }

    public static CodeSystem makeShareable(CodeSystem cs) {
        if (!cs.hasMeta()) {
            cs.setMeta(new Meta());
        }
        for (UriType t : cs.getMeta().getProfile()) {
            if (!((String)t.getValue()).equals("http://hl7.org/fhir/StructureDefinition/shareablecodesystem")) continue;
            return cs;
        }
        cs.getMeta().getProfile().add(new UriType("http://hl7.org/fhir/StructureDefinition/shareablecodesystem"));
        return cs;
    }

    public static void setOID(CodeSystem cs, String oid) {
        if (!oid.startsWith("urn:oid:")) {
            oid = "urn:oid:" + oid;
        }
        if (!cs.hasIdentifier()) {
            cs.setIdentifier(new Identifier().setSystem("urn:ietf:rfc:3986").setValue(oid));
        } else if ("urn:ietf:rfc:3986".equals(cs.getIdentifier().getSystem()) && cs.getIdentifier().hasValue() && cs.getIdentifier().getValue().startsWith("urn:oid:")) {
            cs.getIdentifier().setValue(oid);
        } else {
            throw new Error("unable to set OID on code system");
        }
    }

    public static boolean hasOID(CodeSystem cs) {
        return CodeSystemUtilities.getOID(cs) != null;
    }

    public static String getOID(CodeSystem cs) {
        if (cs.hasIdentifier() && "urn:ietf:rfc:3986".equals(cs.getIdentifier().getSystem()) && cs.getIdentifier().hasValue() && cs.getIdentifier().getValue().startsWith("urn:oid:")) {
            return cs.getIdentifier().getValue().substring(8);
        }
        return null;
    }

    public static boolean isInactive(CodeSystem cs, CodeSystem.ConceptDefinitionComponent def) throws FHIRException {
        for (CodeSystem.ConceptPropertyComponent p : def.getProperty()) {
            if (!p.getCode().equals("status") || !p.hasValueStringType()) continue;
            return "inactive".equals(p.getValueStringType());
        }
        return false;
    }

    public static boolean isInactive(CodeSystem cs, String code) throws FHIRException {
        CodeSystem.ConceptDefinitionComponent def = CodeSystemUtilities.findCode(cs.getConcept(), code);
        if (def == null) {
            return true;
        }
        return CodeSystemUtilities.isInactive(cs, def);
    }

    private static CodeSystem.ConceptDefinitionComponent findCode(List<CodeSystem.ConceptDefinitionComponent> list, String code) {
        for (CodeSystem.ConceptDefinitionComponent c : list) {
            if (c.getCode().equals(code)) {
                return c;
            }
            CodeSystem.ConceptDefinitionComponent s = CodeSystemUtilities.findCode(c.getConcept(), code);
            if (s == null) continue;
            return s;
        }
        return null;
    }

    public static void markStatus(CodeSystem cs, String wg, String status, String fmm) {
    }

    private static int ssval(String status) {
        if ("Draft".equals("status")) {
            return 1;
        }
        if ("Informative".equals("status")) {
            return 2;
        }
        if ("External".equals("status")) {
            return 3;
        }
        if ("Trial Use".equals("status")) {
            return 3;
        }
        if ("Normative".equals("status")) {
            return 4;
        }
        return -1;
    }
}

