/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum VaccinationProtocolDoseStatus {
    COUNT,
    NOCOUNT,
    NULL;


    public static VaccinationProtocolDoseStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("count".equals(codeString)) {
            return COUNT;
        }
        if ("nocount".equals(codeString)) {
            return NOCOUNT;
        }
        throw new FHIRException("Unknown VaccinationProtocolDoseStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case COUNT: {
                return "count";
            }
            case NOCOUNT: {
                return "nocount";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/vaccination-protocol-dose-status";
    }

    public String getDefinition() {
        switch (this) {
            case COUNT: {
                return "The dose counts toward fulfilling a path to immunity for a patient, providing protection against the target disease.";
            }
            case NOCOUNT: {
                return "The dose does not count toward fulfilling a path to immunity for a patient.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case COUNT: {
                return "Counts";
            }
            case NOCOUNT: {
                return "Does not Count";
            }
        }
        return "?";
    }
}

