/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.DataRequirement;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.DateType;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.Schedule;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.Timing;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="TriggerDefinition")
public class TriggerDefinition
extends Type
implements ICompositeType {
    @Child(name="type", type={CodeType.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="named-event | periodic | data-added | data-modified | data-removed | data-accessed | data-access-ended", formalDefinition="The type of triggering event.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/trigger-type")
    protected Enumeration<TriggerType> type;
    @Child(name="eventName", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Triggering event name", formalDefinition="The name of the event (if this is a named-event trigger).")
    protected StringType eventName;
    @Child(name="eventTiming", type={Timing.class, Schedule.class, DateType.class, DateTimeType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Timing of the event", formalDefinition="The timing of the event (if this is a period trigger).")
    protected Type eventTiming;
    @Child(name="eventData", type={DataRequirement.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Triggering data of the event", formalDefinition="The triggering data of the event (if this is a data trigger).")
    protected DataRequirement eventData;
    private static final long serialVersionUID = -1695534864L;

    public TriggerDefinition() {
    }

    public TriggerDefinition(Enumeration<TriggerType> type) {
        this.type = type;
    }

    public Enumeration<TriggerType> getTypeElement() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TriggerDefinition.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new Enumeration<TriggerType>(new TriggerTypeEnumFactory());
            }
        }
        return this.type;
    }

    public boolean hasTypeElement() {
        return this.type != null && !this.type.isEmpty();
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public TriggerDefinition setTypeElement(Enumeration<TriggerType> value) {
        this.type = value;
        return this;
    }

    public TriggerType getType() {
        return this.type == null ? null : (TriggerType)((Object)this.type.getValue());
    }

    public TriggerDefinition setType(TriggerType value) {
        if (this.type == null) {
            this.type = new Enumeration<TriggerType>(new TriggerTypeEnumFactory());
        }
        this.type.setValue((Object)value);
        return this;
    }

    public StringType getEventNameElement() {
        if (this.eventName == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TriggerDefinition.eventName");
            }
            if (Configuration.doAutoCreate()) {
                this.eventName = new StringType();
            }
        }
        return this.eventName;
    }

    public boolean hasEventNameElement() {
        return this.eventName != null && !this.eventName.isEmpty();
    }

    public boolean hasEventName() {
        return this.eventName != null && !this.eventName.isEmpty();
    }

    public TriggerDefinition setEventNameElement(StringType value) {
        this.eventName = value;
        return this;
    }

    public String getEventName() {
        return this.eventName == null ? null : (String)this.eventName.getValue();
    }

    public TriggerDefinition setEventName(String value) {
        if (Utilities.noString((String)value)) {
            this.eventName = null;
        } else {
            if (this.eventName == null) {
                this.eventName = new StringType();
            }
            this.eventName.setValue(value);
        }
        return this;
    }

    public Type getEventTiming() {
        return this.eventTiming;
    }

    public Timing getEventTimingTiming() throws FHIRException {
        if (!(this.eventTiming instanceof Timing)) {
            throw new FHIRException("Type mismatch: the type Timing was expected, but " + this.eventTiming.getClass().getName() + " was encountered");
        }
        return (Timing)this.eventTiming;
    }

    public boolean hasEventTimingTiming() {
        return this.eventTiming instanceof Timing;
    }

    public Reference getEventTimingReference() throws FHIRException {
        if (!(this.eventTiming instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.eventTiming.getClass().getName() + " was encountered");
        }
        return (Reference)this.eventTiming;
    }

    public boolean hasEventTimingReference() {
        return this.eventTiming instanceof Reference;
    }

    public DateType getEventTimingDateType() throws FHIRException {
        if (!(this.eventTiming instanceof DateType)) {
            throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.eventTiming.getClass().getName() + " was encountered");
        }
        return (DateType)this.eventTiming;
    }

    public boolean hasEventTimingDateType() {
        return this.eventTiming instanceof DateType;
    }

    public DateTimeType getEventTimingDateTimeType() throws FHIRException {
        if (!(this.eventTiming instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.eventTiming.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.eventTiming;
    }

    public boolean hasEventTimingDateTimeType() {
        return this.eventTiming instanceof DateTimeType;
    }

    public boolean hasEventTiming() {
        return this.eventTiming != null && !this.eventTiming.isEmpty();
    }

    public TriggerDefinition setEventTiming(Type value) {
        this.eventTiming = value;
        return this;
    }

    public DataRequirement getEventData() {
        if (this.eventData == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TriggerDefinition.eventData");
            }
            if (Configuration.doAutoCreate()) {
                this.eventData = new DataRequirement();
            }
        }
        return this.eventData;
    }

    public boolean hasEventData() {
        return this.eventData != null && !this.eventData.isEmpty();
    }

    public TriggerDefinition setEventData(DataRequirement value) {
        this.eventData = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property("type", "code", "The type of triggering event.", 0, Integer.MAX_VALUE, this.type));
        childrenList.add(new Property("eventName", "string", "The name of the event (if this is a named-event trigger).", 0, Integer.MAX_VALUE, this.eventName));
        childrenList.add(new Property("eventTiming[x]", "Timing|Reference(Schedule)|date|dateTime", "The timing of the event (if this is a period trigger).", 0, Integer.MAX_VALUE, this.eventTiming));
        childrenList.add(new Property("eventData", "DataRequirement", "The triggering data of the event (if this is a data trigger).", 0, Integer.MAX_VALUE, this.eventData));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.type;
                }
                return baseArray;
            }
            case 31228997: {
                Base[] baseArray;
                if (this.eventName == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.eventName;
                }
                return baseArray;
            }
            case 125465476: {
                Base[] baseArray;
                if (this.eventTiming == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.eventTiming;
                }
                return baseArray;
            }
            case 30931300: {
                Base[] baseArray;
                if (this.eventData == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.eventData;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 3575610: {
                value = new TriggerTypeEnumFactory().fromType(this.castToCode(value));
                this.type = value;
                return value;
            }
            case 31228997: {
                this.eventName = this.castToString(value);
                return value;
            }
            case 125465476: {
                this.eventTiming = this.castToType(value);
                return value;
            }
            case 30931300: {
                this.eventData = this.castToDataRequirement(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("type")) {
            value = new TriggerTypeEnumFactory().fromType(this.castToCode(value));
            this.type = value;
        } else if (name.equals("eventName")) {
            this.eventName = this.castToString(value);
        } else if (name.equals("eventTiming[x]")) {
            this.eventTiming = this.castToType(value);
        } else if (name.equals("eventData")) {
            this.eventData = this.castToDataRequirement(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3575610: {
                return this.getTypeElement();
            }
            case 31228997: {
                return this.getEventNameElement();
            }
            case 1120539260: {
                return this.getEventTiming();
            }
            case 125465476: {
                return this.getEventTiming();
            }
            case 30931300: {
                return this.getEventData();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3575610: {
                return new String[]{"code"};
            }
            case 31228997: {
                return new String[]{"string"};
            }
            case 125465476: {
                return new String[]{"Timing", "Reference", "date", "dateTime"};
            }
            case 30931300: {
                return new String[]{"DataRequirement"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("type")) {
            throw new FHIRException("Cannot call addChild on a primitive type TriggerDefinition.type");
        }
        if (name.equals("eventName")) {
            throw new FHIRException("Cannot call addChild on a primitive type TriggerDefinition.eventName");
        }
        if (name.equals("eventTimingTiming")) {
            this.eventTiming = new Timing();
            return this.eventTiming;
        }
        if (name.equals("eventTimingReference")) {
            this.eventTiming = new Reference();
            return this.eventTiming;
        }
        if (name.equals("eventTimingDate")) {
            this.eventTiming = new DateType();
            return this.eventTiming;
        }
        if (name.equals("eventTimingDateTime")) {
            this.eventTiming = new DateTimeType();
            return this.eventTiming;
        }
        if (name.equals("eventData")) {
            this.eventData = new DataRequirement();
            return this.eventData;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "TriggerDefinition";
    }

    @Override
    public TriggerDefinition copy() {
        TriggerDefinition dst = new TriggerDefinition();
        this.copyValues(dst);
        dst.type = this.type == null ? null : this.type.copy();
        dst.eventName = this.eventName == null ? null : this.eventName.copy();
        dst.eventTiming = this.eventTiming == null ? null : this.eventTiming.copy();
        dst.eventData = this.eventData == null ? null : this.eventData.copy();
        return dst;
    }

    @Override
    protected TriggerDefinition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof TriggerDefinition)) {
            return false;
        }
        TriggerDefinition o = (TriggerDefinition)other;
        return TriggerDefinition.compareDeep(this.type, o.type, true) && TriggerDefinition.compareDeep(this.eventName, o.eventName, true) && TriggerDefinition.compareDeep(this.eventTiming, o.eventTiming, true) && TriggerDefinition.compareDeep(this.eventData, o.eventData, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof TriggerDefinition)) {
            return false;
        }
        TriggerDefinition o = (TriggerDefinition)other;
        return TriggerDefinition.compareValues(this.type, o.type, true) && TriggerDefinition.compareValues(this.eventName, o.eventName, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.eventName, this.eventTiming, this.eventData});
    }

    public static class TriggerTypeEnumFactory
    implements EnumFactory<TriggerType> {
        @Override
        public TriggerType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("named-event".equals(codeString)) {
                return TriggerType.NAMEDEVENT;
            }
            if ("periodic".equals(codeString)) {
                return TriggerType.PERIODIC;
            }
            if ("data-added".equals(codeString)) {
                return TriggerType.DATAADDED;
            }
            if ("data-modified".equals(codeString)) {
                return TriggerType.DATAMODIFIED;
            }
            if ("data-removed".equals(codeString)) {
                return TriggerType.DATAREMOVED;
            }
            if ("data-accessed".equals(codeString)) {
                return TriggerType.DATAACCESSED;
            }
            if ("data-access-ended".equals(codeString)) {
                return TriggerType.DATAACCESSENDED;
            }
            throw new IllegalArgumentException("Unknown TriggerType code '" + codeString + "'");
        }

        public Enumeration<TriggerType> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<TriggerType>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("named-event".equals(codeString)) {
                return new Enumeration<TriggerType>(this, TriggerType.NAMEDEVENT);
            }
            if ("periodic".equals(codeString)) {
                return new Enumeration<TriggerType>(this, TriggerType.PERIODIC);
            }
            if ("data-added".equals(codeString)) {
                return new Enumeration<TriggerType>(this, TriggerType.DATAADDED);
            }
            if ("data-modified".equals(codeString)) {
                return new Enumeration<TriggerType>(this, TriggerType.DATAMODIFIED);
            }
            if ("data-removed".equals(codeString)) {
                return new Enumeration<TriggerType>(this, TriggerType.DATAREMOVED);
            }
            if ("data-accessed".equals(codeString)) {
                return new Enumeration<TriggerType>(this, TriggerType.DATAACCESSED);
            }
            if ("data-access-ended".equals(codeString)) {
                return new Enumeration<TriggerType>(this, TriggerType.DATAACCESSENDED);
            }
            throw new FHIRException("Unknown TriggerType code '" + codeString + "'");
        }

        @Override
        public String toCode(TriggerType code) {
            if (code == TriggerType.NAMEDEVENT) {
                return "named-event";
            }
            if (code == TriggerType.PERIODIC) {
                return "periodic";
            }
            if (code == TriggerType.DATAADDED) {
                return "data-added";
            }
            if (code == TriggerType.DATAMODIFIED) {
                return "data-modified";
            }
            if (code == TriggerType.DATAREMOVED) {
                return "data-removed";
            }
            if (code == TriggerType.DATAACCESSED) {
                return "data-accessed";
            }
            if (code == TriggerType.DATAACCESSENDED) {
                return "data-access-ended";
            }
            return "?";
        }

        @Override
        public String toSystem(TriggerType code) {
            return code.getSystem();
        }
    }

    public static enum TriggerType {
        NAMEDEVENT,
        PERIODIC,
        DATAADDED,
        DATAMODIFIED,
        DATAREMOVED,
        DATAACCESSED,
        DATAACCESSENDED,
        NULL;


        public static TriggerType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("named-event".equals(codeString)) {
                return NAMEDEVENT;
            }
            if ("periodic".equals(codeString)) {
                return PERIODIC;
            }
            if ("data-added".equals(codeString)) {
                return DATAADDED;
            }
            if ("data-modified".equals(codeString)) {
                return DATAMODIFIED;
            }
            if ("data-removed".equals(codeString)) {
                return DATAREMOVED;
            }
            if ("data-accessed".equals(codeString)) {
                return DATAACCESSED;
            }
            if ("data-access-ended".equals(codeString)) {
                return DATAACCESSENDED;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown TriggerType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case NAMEDEVENT: {
                    return "named-event";
                }
                case PERIODIC: {
                    return "periodic";
                }
                case DATAADDED: {
                    return "data-added";
                }
                case DATAMODIFIED: {
                    return "data-modified";
                }
                case DATAREMOVED: {
                    return "data-removed";
                }
                case DATAACCESSED: {
                    return "data-accessed";
                }
                case DATAACCESSENDED: {
                    return "data-access-ended";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case NAMEDEVENT: {
                    return "http://hl7.org/fhir/trigger-type";
                }
                case PERIODIC: {
                    return "http://hl7.org/fhir/trigger-type";
                }
                case DATAADDED: {
                    return "http://hl7.org/fhir/trigger-type";
                }
                case DATAMODIFIED: {
                    return "http://hl7.org/fhir/trigger-type";
                }
                case DATAREMOVED: {
                    return "http://hl7.org/fhir/trigger-type";
                }
                case DATAACCESSED: {
                    return "http://hl7.org/fhir/trigger-type";
                }
                case DATAACCESSENDED: {
                    return "http://hl7.org/fhir/trigger-type";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case NAMEDEVENT: {
                    return "The trigger occurs in response to a specific named event";
                }
                case PERIODIC: {
                    return "The trigger occurs at a specific time or periodically as described by a timing or schedule";
                }
                case DATAADDED: {
                    return "The trigger occurs whenever data of a particular type is added";
                }
                case DATAMODIFIED: {
                    return "The trigger occurs whenever data of a particular type is modified";
                }
                case DATAREMOVED: {
                    return "The trigger occurs whenever data of a particular type is removed";
                }
                case DATAACCESSED: {
                    return "The trigger occurs whenever data of a particular type is accessed";
                }
                case DATAACCESSENDED: {
                    return "The trigger occurs whenever access to data of a particular type is completed";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case NAMEDEVENT: {
                    return "Named Event";
                }
                case PERIODIC: {
                    return "Periodic";
                }
                case DATAADDED: {
                    return "Data Added";
                }
                case DATAMODIFIED: {
                    return "Data Modified";
                }
                case DATAREMOVED: {
                    return "Data Removed";
                }
                case DATAACCESSED: {
                    return "Data Accessed";
                }
                case DATAACCESSENDED: {
                    return "Data Access Ended";
                }
            }
            return "?";
        }
    }
}

