/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu3.model.ActivityDefinition;
import org.hl7.fhir.dstu3.model.Annotation;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.CarePlan;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Condition;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.Device;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.Encounter;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.EpisodeOfCare;
import org.hl7.fhir.dstu3.model.Group;
import org.hl7.fhir.dstu3.model.HealthcareService;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Observation;
import org.hl7.fhir.dstu3.model.Organization;
import org.hl7.fhir.dstu3.model.Patient;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.PlanDefinition;
import org.hl7.fhir.dstu3.model.Practitioner;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.ProcedureRequest;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Provenance;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.RelatedPerson;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ReferralRequest", profile="http://hl7.org/fhir/Profile/ReferralRequest")
public class ReferralRequest
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business identifier", formalDefinition="Business identifier that uniquely identifies the referral/care transfer request instance.")
    protected List<Identifier> identifier;
    @Child(name="definition", type={ActivityDefinition.class, PlanDefinition.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Instantiates protocol or definition", formalDefinition="A protocol, guideline, orderset or other definition that is adhered to in whole or in part by this request.")
    protected List<Reference> definition;
    protected List<Resource> definitionTarget;
    @Child(name="basedOn", type={ReferralRequest.class, CarePlan.class, ProcedureRequest.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Request fulfilled by this request", formalDefinition="Indicates any plans, proposals or orders that this request is intended to satisfy - in whole or in part.")
    protected List<Reference> basedOn;
    protected List<Resource> basedOnTarget;
    @Child(name="replaces", type={ReferralRequest.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Request(s) replaced by this request", formalDefinition="Completed or terminated request(s) whose function is taken by this new request.")
    protected List<Reference> replaces;
    protected List<ReferralRequest> replacesTarget;
    @Child(name="groupIdentifier", type={Identifier.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Composite request this is part of", formalDefinition="The business identifier of the logical \"grouping\" request/order that this referral is a part of.")
    protected Identifier groupIdentifier;
    @Child(name="status", type={CodeType.class}, order=5, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | suspended | cancelled | completed | entered-in-error | unknown", formalDefinition="The status of the authorization/intention reflected by the referral request record.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/request-status")
    protected Enumeration<ReferralRequestStatus> status;
    @Child(name="intent", type={CodeType.class}, order=6, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="proposal | plan | order", formalDefinition="Distinguishes the \"level\" of authorization/demand implicit in this request.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/request-intent")
    protected Enumeration<ReferralCategory> intent;
    @Child(name="type", type={CodeableConcept.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Referral/Transition of care request type", formalDefinition="An indication of the type of referral (or where applicable the type of transfer of care) request.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/referral-type")
    protected CodeableConcept type;
    @Child(name="priority", type={CodeType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Urgency of referral / transfer of care request", formalDefinition="An indication of the urgency of referral (or where applicable the type of transfer of care) request.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/request-priority")
    protected Enumeration<ReferralPriority> priority;
    @Child(name="serviceRequested", type={CodeableConcept.class}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Actions requested as part of the referral", formalDefinition="The service(s) that is/are requested to be provided to the patient.  For example: cardiac pacemaker insertion.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/c80-practice-codes")
    protected List<CodeableConcept> serviceRequested;
    @Child(name="subject", type={Patient.class, Group.class}, order=10, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Patient referred to care or transfer", formalDefinition="The patient who is the subject of a referral or transfer of care request.")
    protected Reference subject;
    protected Resource subjectTarget;
    @Child(name="context", type={Encounter.class, EpisodeOfCare.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Originating encounter", formalDefinition="The encounter at which the request for referral or transfer of care is initiated.")
    protected Reference context;
    protected Resource contextTarget;
    @Child(name="occurrence", type={DateTimeType.class, Period.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the service(s) requested in the referral should occur", formalDefinition="The period of time within which the services identified in the referral/transfer of care is specified or required to occur.")
    protected Type occurrence;
    @Child(name="authoredOn", type={DateTimeType.class}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date of creation/activation", formalDefinition="Date/DateTime of creation for draft requests and date of activation for active requests.")
    protected DateTimeType authoredOn;
    @Child(name="requester", type={}, order=14, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who/what is requesting service", formalDefinition="The individual who initiated the request and has responsibility for its activation.")
    protected ReferralRequestRequesterComponent requester;
    @Child(name="specialty", type={CodeableConcept.class}, order=15, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The clinical specialty (discipline) that the referral is requested for", formalDefinition="Indication of the clinical domain or discipline to which the referral or transfer of care request is sent.  For example: Cardiology Gastroenterology Diabetology.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/practitioner-specialty")
    protected CodeableConcept specialty;
    @Child(name="recipient", type={Practitioner.class, Organization.class, HealthcareService.class}, order=16, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Receiver of referral / transfer of care request", formalDefinition="The healthcare provider(s) or provider organization(s) who/which is to receive the referral/transfer of care request.")
    protected List<Reference> recipient;
    protected List<Resource> recipientTarget;
    @Child(name="reasonCode", type={CodeableConcept.class}, order=17, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Reason for referral / transfer of care request", formalDefinition="Description of clinical condition indicating why referral/transfer of care is requested.  For example:  Pathological Anomalies, Disabled (physical or mental),  Behavioral Management.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/clinical-findings")
    protected List<CodeableConcept> reasonCode;
    @Child(name="reasonReference", type={Condition.class, Observation.class}, order=18, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Why is service needed?", formalDefinition="Indicates another resource whose existence justifies this request.")
    protected List<Reference> reasonReference;
    protected List<Resource> reasonReferenceTarget;
    @Child(name="description", type={StringType.class}, order=19, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="A textual description of the referral", formalDefinition="The reason element gives a short description of why the referral is being made, the description expands on this to support a more complete clinical summary.")
    protected StringType description;
    @Child(name="supportingInfo", type={Reference.class}, order=20, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additonal information to support referral or transfer of care request", formalDefinition="Any additional (administrative, financial or clinical) information required to support request for referral or transfer of care.  For example: Presenting problems/chief complaints Medical History Family History Alerts Allergy/Intolerance and Adverse Reactions Medications Observations/Assessments (may include cognitive and fundtional assessments) Diagnostic Reports Care Plan.")
    protected List<Reference> supportingInfo;
    protected List<Resource> supportingInfoTarget;
    @Child(name="note", type={Annotation.class}, order=21, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Comments made about referral request", formalDefinition="Comments made about the referral request by any of the participants.")
    protected List<Annotation> note;
    @Child(name="relevantHistory", type={Provenance.class}, order=22, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Key events in history of request", formalDefinition="Links to Provenance records for past versions of this resource or fulfilling request or event resources that identify key state transitions or updates that are likely to be relevant to a user looking at the current version of the resource.")
    protected List<Reference> relevantHistory;
    protected List<Provenance> relevantHistoryTarget;
    private static final long serialVersionUID = -404424161L;
    @SearchParamDefinition(name="requester", path="ReferralRequest.requester.agent", description="Individual making the request", type="reference", providesMembershipIn={@Compartment(name="Patient"), @Compartment(name="Practitioner")}, target={Device.class, Organization.class, Patient.class, Practitioner.class, RelatedPerson.class})
    public static final String SP_REQUESTER = "requester";
    public static final ReferenceClientParam REQUESTER = new ReferenceClientParam("requester");
    public static final Include INCLUDE_REQUESTER = new Include("ReferralRequest:requester").toLocked();
    @SearchParamDefinition(name="identifier", path="ReferralRequest.identifier", description="Business identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="specialty", path="ReferralRequest.specialty", description="The specialty that the referral is for", type="token")
    public static final String SP_SPECIALTY = "specialty";
    public static final TokenClientParam SPECIALTY = new TokenClientParam("specialty");
    @SearchParamDefinition(name="replaces", path="ReferralRequest.replaces", description="Request(s) replaced by this request", type="reference", target={ReferralRequest.class})
    public static final String SP_REPLACES = "replaces";
    public static final ReferenceClientParam REPLACES = new ReferenceClientParam("replaces");
    public static final Include INCLUDE_REPLACES = new Include("ReferralRequest:replaces").toLocked();
    @SearchParamDefinition(name="subject", path="ReferralRequest.subject", description="Patient referred to care or transfer", type="reference", target={Group.class, Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("ReferralRequest:subject").toLocked();
    @SearchParamDefinition(name="encounter", path="ReferralRequest.context", description="Originating encounter", type="reference", target={Encounter.class})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("ReferralRequest:encounter").toLocked();
    @SearchParamDefinition(name="authored-on", path="ReferralRequest.authoredOn", description="Creation or activation date", type="date")
    public static final String SP_AUTHORED_ON = "authored-on";
    public static final DateClientParam AUTHORED_ON = new DateClientParam("authored-on");
    @SearchParamDefinition(name="type", path="ReferralRequest.type", description="The type of the referral", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="priority", path="ReferralRequest.priority", description="The priority assigned to the referral", type="token")
    public static final String SP_PRIORITY = "priority";
    public static final TokenClientParam PRIORITY = new TokenClientParam("priority");
    @SearchParamDefinition(name="intent", path="ReferralRequest.intent", description="Proposal, plan or order", type="token")
    public static final String SP_INTENT = "intent";
    public static final TokenClientParam INTENT = new TokenClientParam("intent");
    @SearchParamDefinition(name="group-identifier", path="ReferralRequest.groupIdentifier", description="Part of common request", type="token")
    public static final String SP_GROUP_IDENTIFIER = "group-identifier";
    public static final TokenClientParam GROUP_IDENTIFIER = new TokenClientParam("group-identifier");
    @SearchParamDefinition(name="based-on", path="ReferralRequest.basedOn", description="Request being fulfilled", type="reference", target={CarePlan.class, ProcedureRequest.class, ReferralRequest.class})
    public static final String SP_BASED_ON = "based-on";
    public static final ReferenceClientParam BASED_ON = new ReferenceClientParam("based-on");
    public static final Include INCLUDE_BASED_ON = new Include("ReferralRequest:based-on").toLocked();
    @SearchParamDefinition(name="patient", path="ReferralRequest.subject", description="Who the referral is about", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("ReferralRequest:patient").toLocked();
    @SearchParamDefinition(name="service", path="ReferralRequest.serviceRequested", description="Actions requested as part of the referral", type="token")
    public static final String SP_SERVICE = "service";
    public static final TokenClientParam SERVICE = new TokenClientParam("service");
    @SearchParamDefinition(name="occurrence-date", path="ReferralRequest.occurrence", description="When the service(s) requested in the referral should occur", type="date")
    public static final String SP_OCCURRENCE_DATE = "occurrence-date";
    public static final DateClientParam OCCURRENCE_DATE = new DateClientParam("occurrence-date");
    @SearchParamDefinition(name="recipient", path="ReferralRequest.recipient", description="The person that the referral was sent to", type="reference", providesMembershipIn={@Compartment(name="Practitioner")}, target={HealthcareService.class, Organization.class, Practitioner.class})
    public static final String SP_RECIPIENT = "recipient";
    public static final ReferenceClientParam RECIPIENT = new ReferenceClientParam("recipient");
    public static final Include INCLUDE_RECIPIENT = new Include("ReferralRequest:recipient").toLocked();
    @SearchParamDefinition(name="context", path="ReferralRequest.context", description="Part of encounter or episode of care", type="reference", target={Encounter.class, EpisodeOfCare.class})
    public static final String SP_CONTEXT = "context";
    public static final ReferenceClientParam CONTEXT = new ReferenceClientParam("context");
    public static final Include INCLUDE_CONTEXT = new Include("ReferralRequest:context").toLocked();
    @SearchParamDefinition(name="definition", path="ReferralRequest.definition", description="Instantiates protocol or definition", type="reference", target={ActivityDefinition.class, PlanDefinition.class})
    public static final String SP_DEFINITION = "definition";
    public static final ReferenceClientParam DEFINITION = new ReferenceClientParam("definition");
    public static final Include INCLUDE_DEFINITION = new Include("ReferralRequest:definition").toLocked();
    @SearchParamDefinition(name="status", path="ReferralRequest.status", description="The status of the referral", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public ReferralRequest() {
    }

    public ReferralRequest(Enumeration<ReferralRequestStatus> status, Enumeration<ReferralCategory> intent, Reference subject) {
        this.status = status;
        this.intent = intent;
        this.subject = subject;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public ReferralRequest setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public ReferralRequest addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<Reference> getDefinition() {
        if (this.definition == null) {
            this.definition = new ArrayList<Reference>();
        }
        return this.definition;
    }

    public ReferralRequest setDefinition(List<Reference> theDefinition) {
        this.definition = theDefinition;
        return this;
    }

    public boolean hasDefinition() {
        if (this.definition == null) {
            return false;
        }
        for (Reference item : this.definition) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addDefinition() {
        Reference t = new Reference();
        if (this.definition == null) {
            this.definition = new ArrayList<Reference>();
        }
        this.definition.add(t);
        return t;
    }

    public ReferralRequest addDefinition(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.definition == null) {
            this.definition = new ArrayList<Reference>();
        }
        this.definition.add(t);
        return this;
    }

    public Reference getDefinitionFirstRep() {
        if (this.getDefinition().isEmpty()) {
            this.addDefinition();
        }
        return this.getDefinition().get(0);
    }

    @Deprecated
    public List<Resource> getDefinitionTarget() {
        if (this.definitionTarget == null) {
            this.definitionTarget = new ArrayList<Resource>();
        }
        return this.definitionTarget;
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public ReferralRequest setBasedOn(List<Reference> theBasedOn) {
        this.basedOn = theBasedOn;
        return this;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public ReferralRequest addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public Reference getBasedOnFirstRep() {
        if (this.getBasedOn().isEmpty()) {
            this.addBasedOn();
        }
        return this.getBasedOn().get(0);
    }

    @Deprecated
    public List<Resource> getBasedOnTarget() {
        if (this.basedOnTarget == null) {
            this.basedOnTarget = new ArrayList<Resource>();
        }
        return this.basedOnTarget;
    }

    public List<Reference> getReplaces() {
        if (this.replaces == null) {
            this.replaces = new ArrayList<Reference>();
        }
        return this.replaces;
    }

    public ReferralRequest setReplaces(List<Reference> theReplaces) {
        this.replaces = theReplaces;
        return this;
    }

    public boolean hasReplaces() {
        if (this.replaces == null) {
            return false;
        }
        for (Reference item : this.replaces) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addReplaces() {
        Reference t = new Reference();
        if (this.replaces == null) {
            this.replaces = new ArrayList<Reference>();
        }
        this.replaces.add(t);
        return t;
    }

    public ReferralRequest addReplaces(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.replaces == null) {
            this.replaces = new ArrayList<Reference>();
        }
        this.replaces.add(t);
        return this;
    }

    public Reference getReplacesFirstRep() {
        if (this.getReplaces().isEmpty()) {
            this.addReplaces();
        }
        return this.getReplaces().get(0);
    }

    @Deprecated
    public List<ReferralRequest> getReplacesTarget() {
        if (this.replacesTarget == null) {
            this.replacesTarget = new ArrayList<ReferralRequest>();
        }
        return this.replacesTarget;
    }

    @Deprecated
    public ReferralRequest addReplacesTarget() {
        ReferralRequest r = new ReferralRequest();
        if (this.replacesTarget == null) {
            this.replacesTarget = new ArrayList<ReferralRequest>();
        }
        this.replacesTarget.add(r);
        return r;
    }

    public Identifier getGroupIdentifier() {
        if (this.groupIdentifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ReferralRequest.groupIdentifier");
            }
            if (Configuration.doAutoCreate()) {
                this.groupIdentifier = new Identifier();
            }
        }
        return this.groupIdentifier;
    }

    public boolean hasGroupIdentifier() {
        return this.groupIdentifier != null && !this.groupIdentifier.isEmpty();
    }

    public ReferralRequest setGroupIdentifier(Identifier value) {
        this.groupIdentifier = value;
        return this;
    }

    public Enumeration<ReferralRequestStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ReferralRequest.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<ReferralRequestStatus>(new ReferralRequestStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public ReferralRequest setStatusElement(Enumeration<ReferralRequestStatus> value) {
        this.status = value;
        return this;
    }

    public ReferralRequestStatus getStatus() {
        return this.status == null ? null : (ReferralRequestStatus)((Object)this.status.getValue());
    }

    public ReferralRequest setStatus(ReferralRequestStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<ReferralRequestStatus>(new ReferralRequestStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public Enumeration<ReferralCategory> getIntentElement() {
        if (this.intent == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ReferralRequest.intent");
            }
            if (Configuration.doAutoCreate()) {
                this.intent = new Enumeration<ReferralCategory>(new ReferralCategoryEnumFactory());
            }
        }
        return this.intent;
    }

    public boolean hasIntentElement() {
        return this.intent != null && !this.intent.isEmpty();
    }

    public boolean hasIntent() {
        return this.intent != null && !this.intent.isEmpty();
    }

    public ReferralRequest setIntentElement(Enumeration<ReferralCategory> value) {
        this.intent = value;
        return this;
    }

    public ReferralCategory getIntent() {
        return this.intent == null ? null : (ReferralCategory)((Object)this.intent.getValue());
    }

    public ReferralRequest setIntent(ReferralCategory value) {
        if (this.intent == null) {
            this.intent = new Enumeration<ReferralCategory>(new ReferralCategoryEnumFactory());
        }
        this.intent.setValue((Object)value);
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ReferralRequest.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public ReferralRequest setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public Enumeration<ReferralPriority> getPriorityElement() {
        if (this.priority == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ReferralRequest.priority");
            }
            if (Configuration.doAutoCreate()) {
                this.priority = new Enumeration<ReferralPriority>(new ReferralPriorityEnumFactory());
            }
        }
        return this.priority;
    }

    public boolean hasPriorityElement() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public boolean hasPriority() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public ReferralRequest setPriorityElement(Enumeration<ReferralPriority> value) {
        this.priority = value;
        return this;
    }

    public ReferralPriority getPriority() {
        return this.priority == null ? null : (ReferralPriority)((Object)this.priority.getValue());
    }

    public ReferralRequest setPriority(ReferralPriority value) {
        if (value == null) {
            this.priority = null;
        } else {
            if (this.priority == null) {
                this.priority = new Enumeration<ReferralPriority>(new ReferralPriorityEnumFactory());
            }
            this.priority.setValue((Object)value);
        }
        return this;
    }

    public List<CodeableConcept> getServiceRequested() {
        if (this.serviceRequested == null) {
            this.serviceRequested = new ArrayList<CodeableConcept>();
        }
        return this.serviceRequested;
    }

    public ReferralRequest setServiceRequested(List<CodeableConcept> theServiceRequested) {
        this.serviceRequested = theServiceRequested;
        return this;
    }

    public boolean hasServiceRequested() {
        if (this.serviceRequested == null) {
            return false;
        }
        for (CodeableConcept item : this.serviceRequested) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addServiceRequested() {
        CodeableConcept t = new CodeableConcept();
        if (this.serviceRequested == null) {
            this.serviceRequested = new ArrayList<CodeableConcept>();
        }
        this.serviceRequested.add(t);
        return t;
    }

    public ReferralRequest addServiceRequested(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.serviceRequested == null) {
            this.serviceRequested = new ArrayList<CodeableConcept>();
        }
        this.serviceRequested.add(t);
        return this;
    }

    public CodeableConcept getServiceRequestedFirstRep() {
        if (this.getServiceRequested().isEmpty()) {
            this.addServiceRequested();
        }
        return this.getServiceRequested().get(0);
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ReferralRequest.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public ReferralRequest setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public ReferralRequest setSubjectTarget(Resource value) {
        this.subjectTarget = value;
        return this;
    }

    public Reference getContext() {
        if (this.context == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ReferralRequest.context");
            }
            if (Configuration.doAutoCreate()) {
                this.context = new Reference();
            }
        }
        return this.context;
    }

    public boolean hasContext() {
        return this.context != null && !this.context.isEmpty();
    }

    public ReferralRequest setContext(Reference value) {
        this.context = value;
        return this;
    }

    public Resource getContextTarget() {
        return this.contextTarget;
    }

    public ReferralRequest setContextTarget(Resource value) {
        this.contextTarget = value;
        return this;
    }

    public Type getOccurrence() {
        return this.occurrence;
    }

    public DateTimeType getOccurrenceDateTimeType() throws FHIRException {
        if (!(this.occurrence instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.occurrence.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.occurrence;
    }

    public boolean hasOccurrenceDateTimeType() {
        return this.occurrence instanceof DateTimeType;
    }

    public Period getOccurrencePeriod() throws FHIRException {
        if (!(this.occurrence instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.occurrence.getClass().getName() + " was encountered");
        }
        return (Period)this.occurrence;
    }

    public boolean hasOccurrencePeriod() {
        return this.occurrence instanceof Period;
    }

    public boolean hasOccurrence() {
        return this.occurrence != null && !this.occurrence.isEmpty();
    }

    public ReferralRequest setOccurrence(Type value) {
        this.occurrence = value;
        return this;
    }

    public DateTimeType getAuthoredOnElement() {
        if (this.authoredOn == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ReferralRequest.authoredOn");
            }
            if (Configuration.doAutoCreate()) {
                this.authoredOn = new DateTimeType();
            }
        }
        return this.authoredOn;
    }

    public boolean hasAuthoredOnElement() {
        return this.authoredOn != null && !this.authoredOn.isEmpty();
    }

    public boolean hasAuthoredOn() {
        return this.authoredOn != null && !this.authoredOn.isEmpty();
    }

    public ReferralRequest setAuthoredOnElement(DateTimeType value) {
        this.authoredOn = value;
        return this;
    }

    public Date getAuthoredOn() {
        return this.authoredOn == null ? null : (Date)this.authoredOn.getValue();
    }

    public ReferralRequest setAuthoredOn(Date value) {
        if (value == null) {
            this.authoredOn = null;
        } else {
            if (this.authoredOn == null) {
                this.authoredOn = new DateTimeType();
            }
            this.authoredOn.setValue(value);
        }
        return this;
    }

    public ReferralRequestRequesterComponent getRequester() {
        if (this.requester == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ReferralRequest.requester");
            }
            if (Configuration.doAutoCreate()) {
                this.requester = new ReferralRequestRequesterComponent();
            }
        }
        return this.requester;
    }

    public boolean hasRequester() {
        return this.requester != null && !this.requester.isEmpty();
    }

    public ReferralRequest setRequester(ReferralRequestRequesterComponent value) {
        this.requester = value;
        return this;
    }

    public CodeableConcept getSpecialty() {
        if (this.specialty == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ReferralRequest.specialty");
            }
            if (Configuration.doAutoCreate()) {
                this.specialty = new CodeableConcept();
            }
        }
        return this.specialty;
    }

    public boolean hasSpecialty() {
        return this.specialty != null && !this.specialty.isEmpty();
    }

    public ReferralRequest setSpecialty(CodeableConcept value) {
        this.specialty = value;
        return this;
    }

    public List<Reference> getRecipient() {
        if (this.recipient == null) {
            this.recipient = new ArrayList<Reference>();
        }
        return this.recipient;
    }

    public ReferralRequest setRecipient(List<Reference> theRecipient) {
        this.recipient = theRecipient;
        return this;
    }

    public boolean hasRecipient() {
        if (this.recipient == null) {
            return false;
        }
        for (Reference item : this.recipient) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addRecipient() {
        Reference t = new Reference();
        if (this.recipient == null) {
            this.recipient = new ArrayList<Reference>();
        }
        this.recipient.add(t);
        return t;
    }

    public ReferralRequest addRecipient(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.recipient == null) {
            this.recipient = new ArrayList<Reference>();
        }
        this.recipient.add(t);
        return this;
    }

    public Reference getRecipientFirstRep() {
        if (this.getRecipient().isEmpty()) {
            this.addRecipient();
        }
        return this.getRecipient().get(0);
    }

    @Deprecated
    public List<Resource> getRecipientTarget() {
        if (this.recipientTarget == null) {
            this.recipientTarget = new ArrayList<Resource>();
        }
        return this.recipientTarget;
    }

    public List<CodeableConcept> getReasonCode() {
        if (this.reasonCode == null) {
            this.reasonCode = new ArrayList<CodeableConcept>();
        }
        return this.reasonCode;
    }

    public ReferralRequest setReasonCode(List<CodeableConcept> theReasonCode) {
        this.reasonCode = theReasonCode;
        return this;
    }

    public boolean hasReasonCode() {
        if (this.reasonCode == null) {
            return false;
        }
        for (CodeableConcept item : this.reasonCode) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addReasonCode() {
        CodeableConcept t = new CodeableConcept();
        if (this.reasonCode == null) {
            this.reasonCode = new ArrayList<CodeableConcept>();
        }
        this.reasonCode.add(t);
        return t;
    }

    public ReferralRequest addReasonCode(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.reasonCode == null) {
            this.reasonCode = new ArrayList<CodeableConcept>();
        }
        this.reasonCode.add(t);
        return this;
    }

    public CodeableConcept getReasonCodeFirstRep() {
        if (this.getReasonCode().isEmpty()) {
            this.addReasonCode();
        }
        return this.getReasonCode().get(0);
    }

    public List<Reference> getReasonReference() {
        if (this.reasonReference == null) {
            this.reasonReference = new ArrayList<Reference>();
        }
        return this.reasonReference;
    }

    public ReferralRequest setReasonReference(List<Reference> theReasonReference) {
        this.reasonReference = theReasonReference;
        return this;
    }

    public boolean hasReasonReference() {
        if (this.reasonReference == null) {
            return false;
        }
        for (Reference item : this.reasonReference) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addReasonReference() {
        Reference t = new Reference();
        if (this.reasonReference == null) {
            this.reasonReference = new ArrayList<Reference>();
        }
        this.reasonReference.add(t);
        return t;
    }

    public ReferralRequest addReasonReference(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.reasonReference == null) {
            this.reasonReference = new ArrayList<Reference>();
        }
        this.reasonReference.add(t);
        return this;
    }

    public Reference getReasonReferenceFirstRep() {
        if (this.getReasonReference().isEmpty()) {
            this.addReasonReference();
        }
        return this.getReasonReference().get(0);
    }

    @Deprecated
    public List<Resource> getReasonReferenceTarget() {
        if (this.reasonReferenceTarget == null) {
            this.reasonReferenceTarget = new ArrayList<Resource>();
        }
        return this.reasonReferenceTarget;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ReferralRequest.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public ReferralRequest setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public ReferralRequest setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<Reference> getSupportingInfo() {
        if (this.supportingInfo == null) {
            this.supportingInfo = new ArrayList<Reference>();
        }
        return this.supportingInfo;
    }

    public ReferralRequest setSupportingInfo(List<Reference> theSupportingInfo) {
        this.supportingInfo = theSupportingInfo;
        return this;
    }

    public boolean hasSupportingInfo() {
        if (this.supportingInfo == null) {
            return false;
        }
        for (Reference item : this.supportingInfo) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSupportingInfo() {
        Reference t = new Reference();
        if (this.supportingInfo == null) {
            this.supportingInfo = new ArrayList<Reference>();
        }
        this.supportingInfo.add(t);
        return t;
    }

    public ReferralRequest addSupportingInfo(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.supportingInfo == null) {
            this.supportingInfo = new ArrayList<Reference>();
        }
        this.supportingInfo.add(t);
        return this;
    }

    public Reference getSupportingInfoFirstRep() {
        if (this.getSupportingInfo().isEmpty()) {
            this.addSupportingInfo();
        }
        return this.getSupportingInfo().get(0);
    }

    @Deprecated
    public List<Resource> getSupportingInfoTarget() {
        if (this.supportingInfoTarget == null) {
            this.supportingInfoTarget = new ArrayList<Resource>();
        }
        return this.supportingInfoTarget;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public ReferralRequest setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public ReferralRequest addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public List<Reference> getRelevantHistory() {
        if (this.relevantHistory == null) {
            this.relevantHistory = new ArrayList<Reference>();
        }
        return this.relevantHistory;
    }

    public ReferralRequest setRelevantHistory(List<Reference> theRelevantHistory) {
        this.relevantHistory = theRelevantHistory;
        return this;
    }

    public boolean hasRelevantHistory() {
        if (this.relevantHistory == null) {
            return false;
        }
        for (Reference item : this.relevantHistory) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addRelevantHistory() {
        Reference t = new Reference();
        if (this.relevantHistory == null) {
            this.relevantHistory = new ArrayList<Reference>();
        }
        this.relevantHistory.add(t);
        return t;
    }

    public ReferralRequest addRelevantHistory(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.relevantHistory == null) {
            this.relevantHistory = new ArrayList<Reference>();
        }
        this.relevantHistory.add(t);
        return this;
    }

    public Reference getRelevantHistoryFirstRep() {
        if (this.getRelevantHistory().isEmpty()) {
            this.addRelevantHistory();
        }
        return this.getRelevantHistory().get(0);
    }

    @Deprecated
    public List<Provenance> getRelevantHistoryTarget() {
        if (this.relevantHistoryTarget == null) {
            this.relevantHistoryTarget = new ArrayList<Provenance>();
        }
        return this.relevantHistoryTarget;
    }

    @Deprecated
    public Provenance addRelevantHistoryTarget() {
        Provenance r = new Provenance();
        if (this.relevantHistoryTarget == null) {
            this.relevantHistoryTarget = new ArrayList<Provenance>();
        }
        this.relevantHistoryTarget.add(r);
        return r;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "Business identifier that uniquely identifies the referral/care transfer request instance.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_DEFINITION, "Reference(ActivityDefinition|PlanDefinition)", "A protocol, guideline, orderset or other definition that is adhered to in whole or in part by this request.", 0, Integer.MAX_VALUE, this.definition));
        childrenList.add(new Property("basedOn", "Reference(ReferralRequest|CarePlan|ProcedureRequest)", "Indicates any plans, proposals or orders that this request is intended to satisfy - in whole or in part.", 0, Integer.MAX_VALUE, this.basedOn));
        childrenList.add(new Property(SP_REPLACES, "Reference(ReferralRequest)", "Completed or terminated request(s) whose function is taken by this new request.", 0, Integer.MAX_VALUE, this.replaces));
        childrenList.add(new Property("groupIdentifier", "Identifier", "The business identifier of the logical \"grouping\" request/order that this referral is a part of.", 0, Integer.MAX_VALUE, this.groupIdentifier));
        childrenList.add(new Property(SP_STATUS, "code", "The status of the authorization/intention reflected by the referral request record.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property(SP_INTENT, "code", "Distinguishes the \"level\" of authorization/demand implicit in this request.", 0, Integer.MAX_VALUE, this.intent));
        childrenList.add(new Property(SP_TYPE, "CodeableConcept", "An indication of the type of referral (or where applicable the type of transfer of care) request.", 0, Integer.MAX_VALUE, this.type));
        childrenList.add(new Property(SP_PRIORITY, "code", "An indication of the urgency of referral (or where applicable the type of transfer of care) request.", 0, Integer.MAX_VALUE, this.priority));
        childrenList.add(new Property("serviceRequested", "CodeableConcept", "The service(s) that is/are requested to be provided to the patient.  For example: cardiac pacemaker insertion.", 0, Integer.MAX_VALUE, this.serviceRequested));
        childrenList.add(new Property(SP_SUBJECT, "Reference(Patient|Group)", "The patient who is the subject of a referral or transfer of care request.", 0, Integer.MAX_VALUE, this.subject));
        childrenList.add(new Property(SP_CONTEXT, "Reference(Encounter|EpisodeOfCare)", "The encounter at which the request for referral or transfer of care is initiated.", 0, Integer.MAX_VALUE, this.context));
        childrenList.add(new Property("occurrence[x]", "dateTime|Period", "The period of time within which the services identified in the referral/transfer of care is specified or required to occur.", 0, Integer.MAX_VALUE, this.occurrence));
        childrenList.add(new Property("authoredOn", "dateTime", "Date/DateTime of creation for draft requests and date of activation for active requests.", 0, Integer.MAX_VALUE, this.authoredOn));
        childrenList.add(new Property(SP_REQUESTER, "", "The individual who initiated the request and has responsibility for its activation.", 0, Integer.MAX_VALUE, this.requester));
        childrenList.add(new Property(SP_SPECIALTY, "CodeableConcept", "Indication of the clinical domain or discipline to which the referral or transfer of care request is sent.  For example: Cardiology Gastroenterology Diabetology.", 0, Integer.MAX_VALUE, this.specialty));
        childrenList.add(new Property(SP_RECIPIENT, "Reference(Practitioner|Organization|HealthcareService)", "The healthcare provider(s) or provider organization(s) who/which is to receive the referral/transfer of care request.", 0, Integer.MAX_VALUE, this.recipient));
        childrenList.add(new Property("reasonCode", "CodeableConcept", "Description of clinical condition indicating why referral/transfer of care is requested.  For example:  Pathological Anomalies, Disabled (physical or mental),  Behavioral Management.", 0, Integer.MAX_VALUE, this.reasonCode));
        childrenList.add(new Property("reasonReference", "Reference(Condition|Observation)", "Indicates another resource whose existence justifies this request.", 0, Integer.MAX_VALUE, this.reasonReference));
        childrenList.add(new Property("description", "string", "The reason element gives a short description of why the referral is being made, the description expands on this to support a more complete clinical summary.", 0, Integer.MAX_VALUE, this.description));
        childrenList.add(new Property("supportingInfo", "Reference(Any)", "Any additional (administrative, financial or clinical) information required to support request for referral or transfer of care.  For example: Presenting problems/chief complaints Medical History Family History Alerts Allergy/Intolerance and Adverse Reactions Medications Observations/Assessments (may include cognitive and fundtional assessments) Diagnostic Reports Care Plan.", 0, Integer.MAX_VALUE, this.supportingInfo));
        childrenList.add(new Property("note", "Annotation", "Comments made about the referral request by any of the participants.", 0, Integer.MAX_VALUE, this.note));
        childrenList.add(new Property("relevantHistory", "Reference(Provenance)", "Links to Provenance records for past versions of this resource or fulfilling request or event resources that identify key state transitions or updates that are likely to be relevant to a user looking at the current version of the resource.", 0, Integer.MAX_VALUE, this.relevantHistory));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -1014418093: {
                return this.definition == null ? new Base[]{} : this.definition.toArray(new Base[this.definition.size()]);
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case -430332865: {
                return this.replaces == null ? new Base[]{} : this.replaces.toArray(new Base[this.replaces.size()]);
            }
            case -445338488: {
                Base[] baseArray;
                if (this.groupIdentifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.groupIdentifier;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case -1183762788: {
                Base[] baseArray;
                if (this.intent == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.intent;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.type;
                }
                return baseArray;
            }
            case -1165461084: {
                Base[] baseArray;
                if (this.priority == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.priority;
                }
                return baseArray;
            }
            case 190229561: {
                return this.serviceRequested == null ? new Base[]{} : this.serviceRequested.toArray(new Base[this.serviceRequested.size()]);
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.subject;
                }
                return baseArray;
            }
            case 951530927: {
                Base[] baseArray;
                if (this.context == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.context;
                }
                return baseArray;
            }
            case 1687874001: {
                Base[] baseArray;
                if (this.occurrence == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.occurrence;
                }
                return baseArray;
            }
            case -1500852503: {
                Base[] baseArray;
                if (this.authoredOn == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.authoredOn;
                }
                return baseArray;
            }
            case 693933948: {
                Base[] baseArray;
                if (this.requester == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.requester;
                }
                return baseArray;
            }
            case -1694759682: {
                Base[] baseArray;
                if (this.specialty == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.specialty;
                }
                return baseArray;
            }
            case 820081177: {
                return this.recipient == null ? new Base[]{} : this.recipient.toArray(new Base[this.recipient.size()]);
            }
            case 722137681: {
                return this.reasonCode == null ? new Base[]{} : this.reasonCode.toArray(new Base[this.reasonCode.size()]);
            }
            case -1146218137: {
                return this.reasonReference == null ? new Base[]{} : this.reasonReference.toArray(new Base[this.reasonReference.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.description;
                }
                return baseArray;
            }
            case 1922406657: {
                return this.supportingInfo == null ? new Base[]{} : this.supportingInfo.toArray(new Base[this.supportingInfo.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case 1538891575: {
                return this.relevantHistory == null ? new Base[]{} : this.relevantHistory.toArray(new Base[this.relevantHistory.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -1014418093: {
                this.getDefinition().add(this.castToReference(value));
                return value;
            }
            case -332612366: {
                this.getBasedOn().add(this.castToReference(value));
                return value;
            }
            case -430332865: {
                this.getReplaces().add(this.castToReference(value));
                return value;
            }
            case -445338488: {
                this.groupIdentifier = this.castToIdentifier(value);
                return value;
            }
            case -892481550: {
                value = new ReferralRequestStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case -1183762788: {
                value = new ReferralCategoryEnumFactory().fromType(this.castToCode(value));
                this.intent = value;
                return value;
            }
            case 3575610: {
                this.type = this.castToCodeableConcept(value);
                return value;
            }
            case -1165461084: {
                value = new ReferralPriorityEnumFactory().fromType(this.castToCode(value));
                this.priority = value;
                return value;
            }
            case 190229561: {
                this.getServiceRequested().add(this.castToCodeableConcept(value));
                return value;
            }
            case -1867885268: {
                this.subject = this.castToReference(value);
                return value;
            }
            case 951530927: {
                this.context = this.castToReference(value);
                return value;
            }
            case 1687874001: {
                this.occurrence = this.castToType(value);
                return value;
            }
            case -1500852503: {
                this.authoredOn = this.castToDateTime(value);
                return value;
            }
            case 693933948: {
                this.requester = (ReferralRequestRequesterComponent)((Object)value);
                return value;
            }
            case -1694759682: {
                this.specialty = this.castToCodeableConcept(value);
                return value;
            }
            case 820081177: {
                this.getRecipient().add(this.castToReference(value));
                return value;
            }
            case 722137681: {
                this.getReasonCode().add(this.castToCodeableConcept(value));
                return value;
            }
            case -1146218137: {
                this.getReasonReference().add(this.castToReference(value));
                return value;
            }
            case -1724546052: {
                this.description = this.castToString(value);
                return value;
            }
            case 1922406657: {
                this.getSupportingInfo().add(this.castToReference(value));
                return value;
            }
            case 3387378: {
                this.getNote().add(this.castToAnnotation(value));
                return value;
            }
            case 1538891575: {
                this.getRelevantHistory().add(this.castToReference(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_DEFINITION)) {
            this.getDefinition().add(this.castToReference(value));
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(this.castToReference(value));
        } else if (name.equals(SP_REPLACES)) {
            this.getReplaces().add(this.castToReference(value));
        } else if (name.equals("groupIdentifier")) {
            this.groupIdentifier = this.castToIdentifier(value);
        } else if (name.equals(SP_STATUS)) {
            value = new ReferralRequestStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_INTENT)) {
            value = new ReferralCategoryEnumFactory().fromType(this.castToCode(value));
            this.intent = value;
        } else if (name.equals(SP_TYPE)) {
            this.type = this.castToCodeableConcept(value);
        } else if (name.equals(SP_PRIORITY)) {
            value = new ReferralPriorityEnumFactory().fromType(this.castToCode(value));
            this.priority = value;
        } else if (name.equals("serviceRequested")) {
            this.getServiceRequested().add(this.castToCodeableConcept(value));
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals(SP_CONTEXT)) {
            this.context = this.castToReference(value);
        } else if (name.equals("occurrence[x]")) {
            this.occurrence = this.castToType(value);
        } else if (name.equals("authoredOn")) {
            this.authoredOn = this.castToDateTime(value);
        } else if (name.equals(SP_REQUESTER)) {
            this.requester = (ReferralRequestRequesterComponent)((Object)value);
        } else if (name.equals(SP_SPECIALTY)) {
            this.specialty = this.castToCodeableConcept(value);
        } else if (name.equals(SP_RECIPIENT)) {
            this.getRecipient().add(this.castToReference(value));
        } else if (name.equals("reasonCode")) {
            this.getReasonCode().add(this.castToCodeableConcept(value));
        } else if (name.equals("reasonReference")) {
            this.getReasonReference().add(this.castToReference(value));
        } else if (name.equals("description")) {
            this.description = this.castToString(value);
        } else if (name.equals("supportingInfo")) {
            this.getSupportingInfo().add(this.castToReference(value));
        } else if (name.equals("note")) {
            this.getNote().add(this.castToAnnotation(value));
        } else if (name.equals("relevantHistory")) {
            this.getRelevantHistory().add(this.castToReference(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -1014418093: {
                return this.addDefinition();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case -430332865: {
                return this.addReplaces();
            }
            case -445338488: {
                return this.getGroupIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -1183762788: {
                return this.getIntentElement();
            }
            case 3575610: {
                return this.getType();
            }
            case -1165461084: {
                return this.getPriorityElement();
            }
            case 190229561: {
                return this.addServiceRequested();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 951530927: {
                return this.getContext();
            }
            case -2022646513: {
                return this.getOccurrence();
            }
            case 1687874001: {
                return this.getOccurrence();
            }
            case -1500852503: {
                return this.getAuthoredOnElement();
            }
            case 693933948: {
                return this.getRequester();
            }
            case -1694759682: {
                return this.getSpecialty();
            }
            case 820081177: {
                return this.addRecipient();
            }
            case 722137681: {
                return this.addReasonCode();
            }
            case -1146218137: {
                return this.addReasonReference();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case 1922406657: {
                return this.addSupportingInfo();
            }
            case 3387378: {
                return this.addNote();
            }
            case 1538891575: {
                return this.addRelevantHistory();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -1014418093: {
                return new String[]{"Reference"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case -430332865: {
                return new String[]{"Reference"};
            }
            case -445338488: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -1183762788: {
                return new String[]{"code"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case -1165461084: {
                return new String[]{"code"};
            }
            case 190229561: {
                return new String[]{"CodeableConcept"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 951530927: {
                return new String[]{"Reference"};
            }
            case 1687874001: {
                return new String[]{"dateTime", "Period"};
            }
            case -1500852503: {
                return new String[]{"dateTime"};
            }
            case 693933948: {
                return new String[0];
            }
            case -1694759682: {
                return new String[]{"CodeableConcept"};
            }
            case 820081177: {
                return new String[]{"Reference"};
            }
            case 722137681: {
                return new String[]{"CodeableConcept"};
            }
            case -1146218137: {
                return new String[]{"Reference"};
            }
            case -1724546052: {
                return new String[]{"string"};
            }
            case 1922406657: {
                return new String[]{"Reference"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case 1538891575: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_DEFINITION)) {
            return this.addDefinition();
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals(SP_REPLACES)) {
            return this.addReplaces();
        }
        if (name.equals("groupIdentifier")) {
            this.groupIdentifier = new Identifier();
            return this.groupIdentifier;
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type ReferralRequest.status");
        }
        if (name.equals(SP_INTENT)) {
            throw new FHIRException("Cannot call addChild on a primitive type ReferralRequest.intent");
        }
        if (name.equals(SP_TYPE)) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals(SP_PRIORITY)) {
            throw new FHIRException("Cannot call addChild on a primitive type ReferralRequest.priority");
        }
        if (name.equals("serviceRequested")) {
            return this.addServiceRequested();
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_CONTEXT)) {
            this.context = new Reference();
            return this.context;
        }
        if (name.equals("occurrenceDateTime")) {
            this.occurrence = new DateTimeType();
            return this.occurrence;
        }
        if (name.equals("occurrencePeriod")) {
            this.occurrence = new Period();
            return this.occurrence;
        }
        if (name.equals("authoredOn")) {
            throw new FHIRException("Cannot call addChild on a primitive type ReferralRequest.authoredOn");
        }
        if (name.equals(SP_REQUESTER)) {
            this.requester = new ReferralRequestRequesterComponent();
            return this.requester;
        }
        if (name.equals(SP_SPECIALTY)) {
            this.specialty = new CodeableConcept();
            return this.specialty;
        }
        if (name.equals(SP_RECIPIENT)) {
            return this.addRecipient();
        }
        if (name.equals("reasonCode")) {
            return this.addReasonCode();
        }
        if (name.equals("reasonReference")) {
            return this.addReasonReference();
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type ReferralRequest.description");
        }
        if (name.equals("supportingInfo")) {
            return this.addSupportingInfo();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("relevantHistory")) {
            return this.addRelevantHistory();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ReferralRequest";
    }

    @Override
    public ReferralRequest copy() {
        ReferralRequest dst = new ReferralRequest();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.definition != null) {
            dst.definition = new ArrayList<Reference>();
            for (Reference reference : this.definition) {
                dst.definition.add(reference.copy());
            }
        }
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference reference : this.basedOn) {
                dst.basedOn.add(reference.copy());
            }
        }
        if (this.replaces != null) {
            dst.replaces = new ArrayList<Reference>();
            for (Reference reference : this.replaces) {
                dst.replaces.add(reference.copy());
            }
        }
        dst.groupIdentifier = this.groupIdentifier == null ? null : this.groupIdentifier.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.intent = this.intent == null ? null : this.intent.copy();
        dst.type = this.type == null ? null : this.type.copy();
        Enumeration<ReferralPriority> enumeration = dst.priority = this.priority == null ? null : this.priority.copy();
        if (this.serviceRequested != null) {
            dst.serviceRequested = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.serviceRequested) {
                dst.serviceRequested.add(codeableConcept.copy());
            }
        }
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.context = this.context == null ? null : this.context.copy();
        dst.occurrence = this.occurrence == null ? null : this.occurrence.copy();
        dst.authoredOn = this.authoredOn == null ? null : this.authoredOn.copy();
        dst.requester = this.requester == null ? null : this.requester.copy();
        CodeableConcept codeableConcept = dst.specialty = this.specialty == null ? null : this.specialty.copy();
        if (this.recipient != null) {
            dst.recipient = new ArrayList<Reference>();
            for (Reference reference : this.recipient) {
                dst.recipient.add(reference.copy());
            }
        }
        if (this.reasonCode != null) {
            dst.reasonCode = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.reasonCode) {
                dst.reasonCode.add(codeableConcept2.copy());
            }
        }
        if (this.reasonReference != null) {
            dst.reasonReference = new ArrayList<Reference>();
            for (Reference reference : this.reasonReference) {
                dst.reasonReference.add(reference.copy());
            }
        }
        StringType stringType = dst.description = this.description == null ? null : this.description.copy();
        if (this.supportingInfo != null) {
            dst.supportingInfo = new ArrayList<Reference>();
            for (Reference reference : this.supportingInfo) {
                dst.supportingInfo.add(reference.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        if (this.relevantHistory != null) {
            dst.relevantHistory = new ArrayList<Reference>();
            for (Reference reference : this.relevantHistory) {
                dst.relevantHistory.add(reference.copy());
            }
        }
        return dst;
    }

    protected ReferralRequest typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof ReferralRequest)) {
            return false;
        }
        ReferralRequest o = (ReferralRequest)other;
        return ReferralRequest.compareDeep(this.identifier, o.identifier, true) && ReferralRequest.compareDeep(this.definition, o.definition, true) && ReferralRequest.compareDeep(this.basedOn, o.basedOn, true) && ReferralRequest.compareDeep(this.replaces, o.replaces, true) && ReferralRequest.compareDeep(this.groupIdentifier, o.groupIdentifier, true) && ReferralRequest.compareDeep(this.status, o.status, true) && ReferralRequest.compareDeep(this.intent, o.intent, true) && ReferralRequest.compareDeep(this.type, o.type, true) && ReferralRequest.compareDeep(this.priority, o.priority, true) && ReferralRequest.compareDeep(this.serviceRequested, o.serviceRequested, true) && ReferralRequest.compareDeep(this.subject, o.subject, true) && ReferralRequest.compareDeep(this.context, o.context, true) && ReferralRequest.compareDeep(this.occurrence, o.occurrence, true) && ReferralRequest.compareDeep(this.authoredOn, o.authoredOn, true) && ReferralRequest.compareDeep(this.requester, o.requester, true) && ReferralRequest.compareDeep(this.specialty, o.specialty, true) && ReferralRequest.compareDeep(this.recipient, o.recipient, true) && ReferralRequest.compareDeep(this.reasonCode, o.reasonCode, true) && ReferralRequest.compareDeep(this.reasonReference, o.reasonReference, true) && ReferralRequest.compareDeep(this.description, o.description, true) && ReferralRequest.compareDeep(this.supportingInfo, o.supportingInfo, true) && ReferralRequest.compareDeep(this.note, o.note, true) && ReferralRequest.compareDeep(this.relevantHistory, o.relevantHistory, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof ReferralRequest)) {
            return false;
        }
        ReferralRequest o = (ReferralRequest)other;
        return ReferralRequest.compareValues(this.status, o.status, true) && ReferralRequest.compareValues(this.intent, o.intent, true) && ReferralRequest.compareValues(this.priority, o.priority, true) && ReferralRequest.compareValues(this.authoredOn, o.authoredOn, true) && ReferralRequest.compareValues(this.description, o.description, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.definition, this.basedOn, this.replaces, this.groupIdentifier, this.status, this.intent, this.type, this.priority, this.serviceRequested, this.subject, this.context, this.occurrence, this.authoredOn, this.requester, this.specialty, this.recipient, this.reasonCode, this.reasonReference, this.description, this.supportingInfo, this.note, this.relevantHistory});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ReferralRequest;
    }

    @Block
    public static class ReferralRequestRequesterComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="agent", type={Practitioner.class, Organization.class, Patient.class, RelatedPerson.class, Device.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Individual making the request", formalDefinition="The device, practitioner, etc. who initiated the request.")
        protected Reference agent;
        protected Resource agentTarget;
        @Child(name="onBehalfOf", type={Organization.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Organization agent is acting for", formalDefinition="The organization the device or practitioner was acting on behalf of.")
        protected Reference onBehalfOf;
        protected Organization onBehalfOfTarget;
        private static final long serialVersionUID = -71453027L;

        public ReferralRequestRequesterComponent() {
        }

        public ReferralRequestRequesterComponent(Reference agent) {
            this.agent = agent;
        }

        public Reference getAgent() {
            if (this.agent == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ReferralRequestRequesterComponent.agent");
                }
                if (Configuration.doAutoCreate()) {
                    this.agent = new Reference();
                }
            }
            return this.agent;
        }

        public boolean hasAgent() {
            return this.agent != null && !this.agent.isEmpty();
        }

        public ReferralRequestRequesterComponent setAgent(Reference value) {
            this.agent = value;
            return this;
        }

        public Resource getAgentTarget() {
            return this.agentTarget;
        }

        public ReferralRequestRequesterComponent setAgentTarget(Resource value) {
            this.agentTarget = value;
            return this;
        }

        public Reference getOnBehalfOf() {
            if (this.onBehalfOf == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ReferralRequestRequesterComponent.onBehalfOf");
                }
                if (Configuration.doAutoCreate()) {
                    this.onBehalfOf = new Reference();
                }
            }
            return this.onBehalfOf;
        }

        public boolean hasOnBehalfOf() {
            return this.onBehalfOf != null && !this.onBehalfOf.isEmpty();
        }

        public ReferralRequestRequesterComponent setOnBehalfOf(Reference value) {
            this.onBehalfOf = value;
            return this;
        }

        public Organization getOnBehalfOfTarget() {
            if (this.onBehalfOfTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ReferralRequestRequesterComponent.onBehalfOf");
                }
                if (Configuration.doAutoCreate()) {
                    this.onBehalfOfTarget = new Organization();
                }
            }
            return this.onBehalfOfTarget;
        }

        public ReferralRequestRequesterComponent setOnBehalfOfTarget(Organization value) {
            this.onBehalfOfTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("agent", "Reference(Practitioner|Organization|Patient|RelatedPerson|Device)", "The device, practitioner, etc. who initiated the request.", 0, Integer.MAX_VALUE, this.agent));
            childrenList.add(new Property("onBehalfOf", "Reference(Organization)", "The organization the device or practitioner was acting on behalf of.", 0, Integer.MAX_VALUE, this.onBehalfOf));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 92750597: {
                    Base[] baseArray;
                    if (this.agent == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.agent;
                    }
                    return baseArray;
                }
                case -14402964: {
                    Base[] baseArray;
                    if (this.onBehalfOf == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.onBehalfOf;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 92750597: {
                    this.agent = this.castToReference(value);
                    return value;
                }
                case -14402964: {
                    this.onBehalfOf = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("agent")) {
                this.agent = this.castToReference(value);
            } else if (name.equals("onBehalfOf")) {
                this.onBehalfOf = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 92750597: {
                    return this.getAgent();
                }
                case -14402964: {
                    return this.getOnBehalfOf();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 92750597: {
                    return new String[]{"Reference"};
                }
                case -14402964: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("agent")) {
                this.agent = new Reference();
                return this.agent;
            }
            if (name.equals("onBehalfOf")) {
                this.onBehalfOf = new Reference();
                return this.onBehalfOf;
            }
            return super.addChild(name);
        }

        @Override
        public ReferralRequestRequesterComponent copy() {
            ReferralRequestRequesterComponent dst = new ReferralRequestRequesterComponent();
            this.copyValues(dst);
            dst.agent = this.agent == null ? null : this.agent.copy();
            dst.onBehalfOf = this.onBehalfOf == null ? null : this.onBehalfOf.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ReferralRequestRequesterComponent)) {
                return false;
            }
            ReferralRequestRequesterComponent o = (ReferralRequestRequesterComponent)other;
            return ReferralRequestRequesterComponent.compareDeep(this.agent, o.agent, true) && ReferralRequestRequesterComponent.compareDeep(this.onBehalfOf, o.onBehalfOf, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ReferralRequestRequesterComponent)) {
                return false;
            }
            ReferralRequestRequesterComponent o = (ReferralRequestRequesterComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.agent, this.onBehalfOf});
        }

        @Override
        public String fhirType() {
            return "ReferralRequest.requester";
        }
    }

    public static class ReferralPriorityEnumFactory
    implements EnumFactory<ReferralPriority> {
        @Override
        public ReferralPriority fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("routine".equals(codeString)) {
                return ReferralPriority.ROUTINE;
            }
            if ("urgent".equals(codeString)) {
                return ReferralPriority.URGENT;
            }
            if ("asap".equals(codeString)) {
                return ReferralPriority.ASAP;
            }
            if ("stat".equals(codeString)) {
                return ReferralPriority.STAT;
            }
            throw new IllegalArgumentException("Unknown ReferralPriority code '" + codeString + "'");
        }

        public Enumeration<ReferralPriority> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ReferralPriority>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("routine".equals(codeString)) {
                return new Enumeration<ReferralPriority>(this, ReferralPriority.ROUTINE);
            }
            if ("urgent".equals(codeString)) {
                return new Enumeration<ReferralPriority>(this, ReferralPriority.URGENT);
            }
            if ("asap".equals(codeString)) {
                return new Enumeration<ReferralPriority>(this, ReferralPriority.ASAP);
            }
            if ("stat".equals(codeString)) {
                return new Enumeration<ReferralPriority>(this, ReferralPriority.STAT);
            }
            throw new FHIRException("Unknown ReferralPriority code '" + codeString + "'");
        }

        @Override
        public String toCode(ReferralPriority code) {
            if (code == ReferralPriority.ROUTINE) {
                return "routine";
            }
            if (code == ReferralPriority.URGENT) {
                return "urgent";
            }
            if (code == ReferralPriority.ASAP) {
                return "asap";
            }
            if (code == ReferralPriority.STAT) {
                return "stat";
            }
            return "?";
        }

        @Override
        public String toSystem(ReferralPriority code) {
            return code.getSystem();
        }
    }

    public static enum ReferralPriority {
        ROUTINE,
        URGENT,
        ASAP,
        STAT,
        NULL;


        public static ReferralPriority fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("routine".equals(codeString)) {
                return ROUTINE;
            }
            if ("urgent".equals(codeString)) {
                return URGENT;
            }
            if ("asap".equals(codeString)) {
                return ASAP;
            }
            if ("stat".equals(codeString)) {
                return STAT;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ReferralPriority code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ROUTINE: {
                    return "routine";
                }
                case URGENT: {
                    return "urgent";
                }
                case ASAP: {
                    return "asap";
                }
                case STAT: {
                    return "stat";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ROUTINE: {
                    return "http://hl7.org/fhir/request-priority";
                }
                case URGENT: {
                    return "http://hl7.org/fhir/request-priority";
                }
                case ASAP: {
                    return "http://hl7.org/fhir/request-priority";
                }
                case STAT: {
                    return "http://hl7.org/fhir/request-priority";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ROUTINE: {
                    return "The request has normal priority";
                }
                case URGENT: {
                    return "The request should be actioned promptly - higher priority than routine";
                }
                case ASAP: {
                    return "The request should be actioned as soon as possible - higher priority than urgent";
                }
                case STAT: {
                    return "The request should be actioned immediately - highest possible priority.  E.g. an emergency";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ROUTINE: {
                    return "Routine";
                }
                case URGENT: {
                    return "Urgent";
                }
                case ASAP: {
                    return "ASAP";
                }
                case STAT: {
                    return "STAT";
                }
            }
            return "?";
        }
    }

    public static class ReferralCategoryEnumFactory
    implements EnumFactory<ReferralCategory> {
        @Override
        public ReferralCategory fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("proposal".equals(codeString)) {
                return ReferralCategory.PROPOSAL;
            }
            if ("plan".equals(codeString)) {
                return ReferralCategory.PLAN;
            }
            if ("order".equals(codeString)) {
                return ReferralCategory.ORDER;
            }
            if ("original-order".equals(codeString)) {
                return ReferralCategory.ORIGINALORDER;
            }
            if ("reflex-order".equals(codeString)) {
                return ReferralCategory.REFLEXORDER;
            }
            if ("filler-order".equals(codeString)) {
                return ReferralCategory.FILLERORDER;
            }
            if ("instance-order".equals(codeString)) {
                return ReferralCategory.INSTANCEORDER;
            }
            if ("option".equals(codeString)) {
                return ReferralCategory.OPTION;
            }
            throw new IllegalArgumentException("Unknown ReferralCategory code '" + codeString + "'");
        }

        public Enumeration<ReferralCategory> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ReferralCategory>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("proposal".equals(codeString)) {
                return new Enumeration<ReferralCategory>(this, ReferralCategory.PROPOSAL);
            }
            if ("plan".equals(codeString)) {
                return new Enumeration<ReferralCategory>(this, ReferralCategory.PLAN);
            }
            if ("order".equals(codeString)) {
                return new Enumeration<ReferralCategory>(this, ReferralCategory.ORDER);
            }
            if ("original-order".equals(codeString)) {
                return new Enumeration<ReferralCategory>(this, ReferralCategory.ORIGINALORDER);
            }
            if ("reflex-order".equals(codeString)) {
                return new Enumeration<ReferralCategory>(this, ReferralCategory.REFLEXORDER);
            }
            if ("filler-order".equals(codeString)) {
                return new Enumeration<ReferralCategory>(this, ReferralCategory.FILLERORDER);
            }
            if ("instance-order".equals(codeString)) {
                return new Enumeration<ReferralCategory>(this, ReferralCategory.INSTANCEORDER);
            }
            if ("option".equals(codeString)) {
                return new Enumeration<ReferralCategory>(this, ReferralCategory.OPTION);
            }
            throw new FHIRException("Unknown ReferralCategory code '" + codeString + "'");
        }

        @Override
        public String toCode(ReferralCategory code) {
            if (code == ReferralCategory.PROPOSAL) {
                return "proposal";
            }
            if (code == ReferralCategory.PLAN) {
                return "plan";
            }
            if (code == ReferralCategory.ORDER) {
                return "order";
            }
            if (code == ReferralCategory.ORIGINALORDER) {
                return "original-order";
            }
            if (code == ReferralCategory.REFLEXORDER) {
                return "reflex-order";
            }
            if (code == ReferralCategory.FILLERORDER) {
                return "filler-order";
            }
            if (code == ReferralCategory.INSTANCEORDER) {
                return "instance-order";
            }
            if (code == ReferralCategory.OPTION) {
                return "option";
            }
            return "?";
        }

        @Override
        public String toSystem(ReferralCategory code) {
            return code.getSystem();
        }
    }

    public static enum ReferralCategory {
        PROPOSAL,
        PLAN,
        ORDER,
        ORIGINALORDER,
        REFLEXORDER,
        FILLERORDER,
        INSTANCEORDER,
        OPTION,
        NULL;


        public static ReferralCategory fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("proposal".equals(codeString)) {
                return PROPOSAL;
            }
            if ("plan".equals(codeString)) {
                return PLAN;
            }
            if ("order".equals(codeString)) {
                return ORDER;
            }
            if ("original-order".equals(codeString)) {
                return ORIGINALORDER;
            }
            if ("reflex-order".equals(codeString)) {
                return REFLEXORDER;
            }
            if ("filler-order".equals(codeString)) {
                return FILLERORDER;
            }
            if ("instance-order".equals(codeString)) {
                return INSTANCEORDER;
            }
            if ("option".equals(codeString)) {
                return OPTION;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ReferralCategory code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PROPOSAL: {
                    return "proposal";
                }
                case PLAN: {
                    return "plan";
                }
                case ORDER: {
                    return "order";
                }
                case ORIGINALORDER: {
                    return "original-order";
                }
                case REFLEXORDER: {
                    return "reflex-order";
                }
                case FILLERORDER: {
                    return "filler-order";
                }
                case INSTANCEORDER: {
                    return "instance-order";
                }
                case OPTION: {
                    return "option";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PROPOSAL: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case PLAN: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case ORDER: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case ORIGINALORDER: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case REFLEXORDER: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case FILLERORDER: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case INSTANCEORDER: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case OPTION: {
                    return "http://hl7.org/fhir/request-intent";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PROPOSAL: {
                    return "The request is a suggestion made by someone/something that doesn't have an intention to ensure it occurs and without providing an authorization to act";
                }
                case PLAN: {
                    return "The request represents an intension to ensure something occurs without providing an authorization for others to act";
                }
                case ORDER: {
                    return "The request represents a request/demand and authorization for action";
                }
                case ORIGINALORDER: {
                    return "The request represents an original authorization for action";
                }
                case REFLEXORDER: {
                    return "The request represents an automatically generated supplemental authorization for action based on a parent authorization together with initial results of the action taken against that parent authorization";
                }
                case FILLERORDER: {
                    return "The request represents the view of an authorization instantiated by a fulfilling system representing the details of the fulfiller's intention to act upon a submitted order";
                }
                case INSTANCEORDER: {
                    return "An order created in fulfillment of a broader order that represents the authorization for a single activity occurrence.  E.g. The administration of a single dose of a drug.";
                }
                case OPTION: {
                    return "The request represents a component or option for a RequestGroup that establishes timing, conditionality and/or other constraints among a set of requests.\n\nRefer to [[[RequestGroup]]] for additional information on how this status is used";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PROPOSAL: {
                    return "Proposal";
                }
                case PLAN: {
                    return "Plan";
                }
                case ORDER: {
                    return "Order";
                }
                case ORIGINALORDER: {
                    return "Original Order";
                }
                case REFLEXORDER: {
                    return "Reflex Order";
                }
                case FILLERORDER: {
                    return "Filler Order";
                }
                case INSTANCEORDER: {
                    return "Instance Order";
                }
                case OPTION: {
                    return "Option";
                }
            }
            return "?";
        }
    }

    public static class ReferralRequestStatusEnumFactory
    implements EnumFactory<ReferralRequestStatus> {
        @Override
        public ReferralRequestStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return ReferralRequestStatus.DRAFT;
            }
            if ("active".equals(codeString)) {
                return ReferralRequestStatus.ACTIVE;
            }
            if ("suspended".equals(codeString)) {
                return ReferralRequestStatus.SUSPENDED;
            }
            if ("cancelled".equals(codeString)) {
                return ReferralRequestStatus.CANCELLED;
            }
            if ("completed".equals(codeString)) {
                return ReferralRequestStatus.COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ReferralRequestStatus.ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return ReferralRequestStatus.UNKNOWN;
            }
            throw new IllegalArgumentException("Unknown ReferralRequestStatus code '" + codeString + "'");
        }

        public Enumeration<ReferralRequestStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ReferralRequestStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<ReferralRequestStatus>(this, ReferralRequestStatus.DRAFT);
            }
            if ("active".equals(codeString)) {
                return new Enumeration<ReferralRequestStatus>(this, ReferralRequestStatus.ACTIVE);
            }
            if ("suspended".equals(codeString)) {
                return new Enumeration<ReferralRequestStatus>(this, ReferralRequestStatus.SUSPENDED);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<ReferralRequestStatus>(this, ReferralRequestStatus.CANCELLED);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<ReferralRequestStatus>(this, ReferralRequestStatus.COMPLETED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<ReferralRequestStatus>(this, ReferralRequestStatus.ENTEREDINERROR);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<ReferralRequestStatus>(this, ReferralRequestStatus.UNKNOWN);
            }
            throw new FHIRException("Unknown ReferralRequestStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(ReferralRequestStatus code) {
            if (code == ReferralRequestStatus.DRAFT) {
                return "draft";
            }
            if (code == ReferralRequestStatus.ACTIVE) {
                return "active";
            }
            if (code == ReferralRequestStatus.SUSPENDED) {
                return "suspended";
            }
            if (code == ReferralRequestStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == ReferralRequestStatus.COMPLETED) {
                return "completed";
            }
            if (code == ReferralRequestStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == ReferralRequestStatus.UNKNOWN) {
                return "unknown";
            }
            return "?";
        }

        @Override
        public String toSystem(ReferralRequestStatus code) {
            return code.getSystem();
        }
    }

    public static enum ReferralRequestStatus {
        DRAFT,
        ACTIVE,
        SUSPENDED,
        CANCELLED,
        COMPLETED,
        ENTEREDINERROR,
        UNKNOWN,
        NULL;


        public static ReferralRequestStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("suspended".equals(codeString)) {
                return SUSPENDED;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ReferralRequestStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case DRAFT: {
                    return "draft";
                }
                case ACTIVE: {
                    return "active";
                }
                case SUSPENDED: {
                    return "suspended";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case COMPLETED: {
                    return "completed";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case UNKNOWN: {
                    return "unknown";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case DRAFT: {
                    return "http://hl7.org/fhir/request-status";
                }
                case ACTIVE: {
                    return "http://hl7.org/fhir/request-status";
                }
                case SUSPENDED: {
                    return "http://hl7.org/fhir/request-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/request-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/request-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/request-status";
                }
                case UNKNOWN: {
                    return "http://hl7.org/fhir/request-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case DRAFT: {
                    return "The request has been created but is not yet complete or ready for action";
                }
                case ACTIVE: {
                    return "The request is ready to be acted upon";
                }
                case SUSPENDED: {
                    return "The authorization/request to act has been temporarily withdrawn but is expected to resume in the future";
                }
                case CANCELLED: {
                    return "The authorization/request to act has been terminated prior to the full completion of the intended actions.  No further activity should occur.";
                }
                case COMPLETED: {
                    return "Activity against the request has been sufficiently completed to the satisfaction of the requester";
                }
                case ENTEREDINERROR: {
                    return "This electronic record should never have existed, though it is possible that real-world decisions were based on it.  (If real-world activity has occurred, the status should be \"cancelled\" rather than \"entered-in-error\".)";
                }
                case UNKNOWN: {
                    return "The authoring system does not know which of the status values currently applies for this request.  Note: This concept is not to be used for \"other\" . One of the listed statuses is presumed to apply,  but the system creating the request doesn't know.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case DRAFT: {
                    return "Draft";
                }
                case ACTIVE: {
                    return "Active";
                }
                case SUSPENDED: {
                    return "Suspended";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case UNKNOWN: {
                    return "Unknown";
                }
            }
            return "?";
        }
    }
}

