/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu3.model.Address;
import org.hl7.fhir.dstu3.model.Attachment;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.BooleanType;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.ContactPoint;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.DateType;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.Enumerations;
import org.hl7.fhir.dstu3.model.HumanName;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.IntegerType;
import org.hl7.fhir.dstu3.model.Organization;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.Practitioner;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.RelatedPerson;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;

@ResourceDef(name="Patient", profile="http://hl7.org/fhir/Profile/Patient")
public class Patient
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="An identifier for this patient", formalDefinition="An identifier for this patient.")
    protected List<Identifier> identifier;
    @Child(name="active", type={BooleanType.class}, order=1, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="Whether this patient's record is in active use", formalDefinition="Whether this patient record is in active use.")
    protected BooleanType active;
    @Child(name="name", type={HumanName.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A name associated with the patient", formalDefinition="A name associated with the individual.")
    protected List<HumanName> name;
    @Child(name="telecom", type={ContactPoint.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A contact detail for the individual", formalDefinition="A contact detail (e.g. a telephone number or an email address) by which the individual may be contacted.")
    protected List<ContactPoint> telecom;
    @Child(name="gender", type={CodeType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="male | female | other | unknown", formalDefinition="Administrative Gender - the gender that the patient is considered to have for administration and record keeping purposes.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/administrative-gender")
    protected Enumeration<Enumerations.AdministrativeGender> gender;
    @Child(name="birthDate", type={DateType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The date of birth for the individual", formalDefinition="The date of birth for the individual.")
    protected DateType birthDate;
    @Child(name="deceased", type={BooleanType.class, DateTimeType.class}, order=6, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="Indicates if the individual is deceased or not", formalDefinition="Indicates if the individual is deceased or not.")
    protected Type deceased;
    @Child(name="address", type={Address.class}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Addresses for the individual", formalDefinition="Addresses for the individual.")
    protected List<Address> address;
    @Child(name="maritalStatus", type={CodeableConcept.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Marital (civil) status of a patient", formalDefinition="This field contains a patient's most recent marital (civil) status.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/marital-status")
    protected CodeableConcept maritalStatus;
    @Child(name="multipleBirth", type={BooleanType.class, IntegerType.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Whether patient is part of a multiple birth", formalDefinition="Indicates whether the patient is part of a multiple (bool) or indicates the actual birth order (integer).")
    protected Type multipleBirth;
    @Child(name="photo", type={Attachment.class}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Image of the patient", formalDefinition="Image of the patient.")
    protected List<Attachment> photo;
    @Child(name="contact", type={}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A contact party (e.g. guardian, partner, friend) for the patient", formalDefinition="A contact party (e.g. guardian, partner, friend) for the patient.")
    protected List<ContactComponent> contact;
    @Child(name="animal", type={}, order=12, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="This patient is known to be an animal (non-human)", formalDefinition="This patient is known to be an animal.")
    protected AnimalComponent animal;
    @Child(name="communication", type={}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A list of Languages which may be used to communicate with the patient about his or her health", formalDefinition="Languages which may be used to communicate with the patient about his or her health.")
    protected List<PatientCommunicationComponent> communication;
    @Child(name="generalPractitioner", type={Organization.class, Practitioner.class}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Patient's nominated primary care provider", formalDefinition="Patient's nominated care provider.")
    protected List<Reference> generalPractitioner;
    protected List<Resource> generalPractitionerTarget;
    @Child(name="managingOrganization", type={Organization.class}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Organization that is the custodian of the patient record", formalDefinition="Organization that is the custodian of the patient record.")
    protected Reference managingOrganization;
    protected Organization managingOrganizationTarget;
    @Child(name="link", type={}, order=16, min=0, max=-1, modifier=true, summary=true)
    @Description(shortDefinition="Link to another patient resource that concerns the same actual person", formalDefinition="Link to another patient resource that concerns the same actual patient.")
    protected List<PatientLinkComponent> link;
    private static final long serialVersionUID = -1985061666L;
    @SearchParamDefinition(name="birthdate", path="Patient.birthDate", description="The patient's date of birth", type="date")
    public static final String SP_BIRTHDATE = "birthdate";
    public static final DateClientParam BIRTHDATE = new DateClientParam("birthdate");
    @SearchParamDefinition(name="deceased", path="Patient.deceased.exists()", description="This patient has been marked as deceased, or as a death date entered", type="token")
    public static final String SP_DECEASED = "deceased";
    public static final TokenClientParam DECEASED = new TokenClientParam("deceased");
    @SearchParamDefinition(name="address-state", path="Patient.address.state", description="A state specified in an address", type="string")
    public static final String SP_ADDRESS_STATE = "address-state";
    public static final StringClientParam ADDRESS_STATE = new StringClientParam("address-state");
    @SearchParamDefinition(name="gender", path="Patient.gender", description="Gender of the patient", type="token")
    public static final String SP_GENDER = "gender";
    public static final TokenClientParam GENDER = new TokenClientParam("gender");
    @SearchParamDefinition(name="animal-species", path="Patient.animal.species", description="The species for animal patients", type="token")
    public static final String SP_ANIMAL_SPECIES = "animal-species";
    public static final TokenClientParam ANIMAL_SPECIES = new TokenClientParam("animal-species");
    @SearchParamDefinition(name="link", path="Patient.link.other", description="All patients linked to the given patient", type="reference", providesMembershipIn={@Compartment(name="Patient"), @Compartment(name="RelatedPerson")}, target={Patient.class, RelatedPerson.class})
    public static final String SP_LINK = "link";
    public static final ReferenceClientParam LINK = new ReferenceClientParam("link");
    public static final Include INCLUDE_LINK = new Include("Patient:link").toLocked();
    @SearchParamDefinition(name="language", path="Patient.communication.language", description="Language code (irrespective of use value)", type="token")
    public static final String SP_LANGUAGE = "language";
    public static final TokenClientParam LANGUAGE = new TokenClientParam("language");
    @SearchParamDefinition(name="animal-breed", path="Patient.animal.breed", description="The breed for animal patients", type="token")
    public static final String SP_ANIMAL_BREED = "animal-breed";
    public static final TokenClientParam ANIMAL_BREED = new TokenClientParam("animal-breed");
    @SearchParamDefinition(name="address-country", path="Patient.address.country", description="A country specified in an address", type="string")
    public static final String SP_ADDRESS_COUNTRY = "address-country";
    public static final StringClientParam ADDRESS_COUNTRY = new StringClientParam("address-country");
    @SearchParamDefinition(name="death-date", path="Patient.deceased.as(DateTime)", description="The date of death has been provided and satisfies this search value", type="date")
    public static final String SP_DEATH_DATE = "death-date";
    public static final DateClientParam DEATH_DATE = new DateClientParam("death-date");
    @SearchParamDefinition(name="phonetic", path="Patient.name", description="A portion of either family or given name using some kind of phonetic matching algorithm", type="string")
    public static final String SP_PHONETIC = "phonetic";
    public static final StringClientParam PHONETIC = new StringClientParam("phonetic");
    @SearchParamDefinition(name="telecom", path="Patient.telecom", description="The value in any kind of telecom details of the patient", type="token")
    public static final String SP_TELECOM = "telecom";
    public static final TokenClientParam TELECOM = new TokenClientParam("telecom");
    @SearchParamDefinition(name="address-city", path="Patient.address.city", description="A city specified in an address", type="string")
    public static final String SP_ADDRESS_CITY = "address-city";
    public static final StringClientParam ADDRESS_CITY = new StringClientParam("address-city");
    @SearchParamDefinition(name="email", path="Patient.telecom.where(system='email')", description="A value in an email contact", type="token")
    public static final String SP_EMAIL = "email";
    public static final TokenClientParam EMAIL = new TokenClientParam("email");
    @SearchParamDefinition(name="identifier", path="Patient.identifier", description="A patient identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="given", path="Patient.name.given", description="A portion of the given name of the patient", type="string")
    public static final String SP_GIVEN = "given";
    public static final StringClientParam GIVEN = new StringClientParam("given");
    @SearchParamDefinition(name="address", path="Patient.address", description="A server defined search that may match any of the string fields in the Address, including line, city, state, country, postalCode, and/or text", type="string")
    public static final String SP_ADDRESS = "address";
    public static final StringClientParam ADDRESS = new StringClientParam("address");
    @SearchParamDefinition(name="general-practitioner", path="Patient.generalPractitioner", description="Patient's nominated general practitioner, not the organization that manages the record", type="reference", providesMembershipIn={@Compartment(name="Practitioner")}, target={Organization.class, Practitioner.class})
    public static final String SP_GENERAL_PRACTITIONER = "general-practitioner";
    public static final ReferenceClientParam GENERAL_PRACTITIONER = new ReferenceClientParam("general-practitioner");
    public static final Include INCLUDE_GENERAL_PRACTITIONER = new Include("Patient:general-practitioner").toLocked();
    @SearchParamDefinition(name="active", path="Patient.active", description="Whether the patient record is active", type="token")
    public static final String SP_ACTIVE = "active";
    public static final TokenClientParam ACTIVE = new TokenClientParam("active");
    @SearchParamDefinition(name="address-postalcode", path="Patient.address.postalCode", description="A postalCode specified in an address", type="string")
    public static final String SP_ADDRESS_POSTALCODE = "address-postalcode";
    public static final StringClientParam ADDRESS_POSTALCODE = new StringClientParam("address-postalcode");
    @SearchParamDefinition(name="phone", path="Patient.telecom.where(system='phone')", description="A value in a phone contact", type="token")
    public static final String SP_PHONE = "phone";
    public static final TokenClientParam PHONE = new TokenClientParam("phone");
    @SearchParamDefinition(name="organization", path="Patient.managingOrganization", description="The organization at which this person is a patient", type="reference", target={Organization.class})
    public static final String SP_ORGANIZATION = "organization";
    public static final ReferenceClientParam ORGANIZATION = new ReferenceClientParam("organization");
    public static final Include INCLUDE_ORGANIZATION = new Include("Patient:organization").toLocked();
    @SearchParamDefinition(name="name", path="Patient.name", description="A server defined search that may match any of the string fields in the HumanName, including family, give, prefix, suffix, suffix, and/or text", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="address-use", path="Patient.address.use", description="A use code specified in an address", type="token")
    public static final String SP_ADDRESS_USE = "address-use";
    public static final TokenClientParam ADDRESS_USE = new TokenClientParam("address-use");
    @SearchParamDefinition(name="family", path="Patient.name.family", description="A portion of the family name of the patient", type="string")
    public static final String SP_FAMILY = "family";
    public static final StringClientParam FAMILY = new StringClientParam("family");

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Patient setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Patient addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public BooleanType getActiveElement() {
        if (this.active == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Patient.active");
            }
            if (Configuration.doAutoCreate()) {
                this.active = new BooleanType();
            }
        }
        return this.active;
    }

    public boolean hasActiveElement() {
        return this.active != null && !this.active.isEmpty();
    }

    public boolean hasActive() {
        return this.active != null && !this.active.isEmpty();
    }

    public Patient setActiveElement(BooleanType value) {
        this.active = value;
        return this;
    }

    public boolean getActive() {
        return this.active == null || this.active.isEmpty() ? false : (Boolean)this.active.getValue();
    }

    public Patient setActive(boolean value) {
        if (this.active == null) {
            this.active = new BooleanType();
        }
        this.active.setValue((Object)value);
        return this;
    }

    public List<HumanName> getName() {
        if (this.name == null) {
            this.name = new ArrayList<HumanName>();
        }
        return this.name;
    }

    public Patient setName(List<HumanName> theName) {
        this.name = theName;
        return this;
    }

    public boolean hasName() {
        if (this.name == null) {
            return false;
        }
        for (HumanName item : this.name) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public HumanName addName() {
        HumanName t = new HumanName();
        if (this.name == null) {
            this.name = new ArrayList<HumanName>();
        }
        this.name.add(t);
        return t;
    }

    public Patient addName(HumanName t) {
        if (t == null) {
            return this;
        }
        if (this.name == null) {
            this.name = new ArrayList<HumanName>();
        }
        this.name.add(t);
        return this;
    }

    public HumanName getNameFirstRep() {
        if (this.getName().isEmpty()) {
            this.addName();
        }
        return this.getName().get(0);
    }

    public List<ContactPoint> getTelecom() {
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        return this.telecom;
    }

    public Patient setTelecom(List<ContactPoint> theTelecom) {
        this.telecom = theTelecom;
        return this;
    }

    public boolean hasTelecom() {
        if (this.telecom == null) {
            return false;
        }
        for (ContactPoint item : this.telecom) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactPoint addTelecom() {
        ContactPoint t = new ContactPoint();
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        this.telecom.add(t);
        return t;
    }

    public Patient addTelecom(ContactPoint t) {
        if (t == null) {
            return this;
        }
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        this.telecom.add(t);
        return this;
    }

    public ContactPoint getTelecomFirstRep() {
        if (this.getTelecom().isEmpty()) {
            this.addTelecom();
        }
        return this.getTelecom().get(0);
    }

    public Enumeration<Enumerations.AdministrativeGender> getGenderElement() {
        if (this.gender == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Patient.gender");
            }
            if (Configuration.doAutoCreate()) {
                this.gender = new Enumeration<Enumerations.AdministrativeGender>(new Enumerations.AdministrativeGenderEnumFactory());
            }
        }
        return this.gender;
    }

    public boolean hasGenderElement() {
        return this.gender != null && !this.gender.isEmpty();
    }

    public boolean hasGender() {
        return this.gender != null && !this.gender.isEmpty();
    }

    public Patient setGenderElement(Enumeration<Enumerations.AdministrativeGender> value) {
        this.gender = value;
        return this;
    }

    public Enumerations.AdministrativeGender getGender() {
        return this.gender == null ? null : (Enumerations.AdministrativeGender)((Object)this.gender.getValue());
    }

    public Patient setGender(Enumerations.AdministrativeGender value) {
        if (value == null) {
            this.gender = null;
        } else {
            if (this.gender == null) {
                this.gender = new Enumeration<Enumerations.AdministrativeGender>(new Enumerations.AdministrativeGenderEnumFactory());
            }
            this.gender.setValue((Object)value);
        }
        return this;
    }

    public DateType getBirthDateElement() {
        if (this.birthDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Patient.birthDate");
            }
            if (Configuration.doAutoCreate()) {
                this.birthDate = new DateType();
            }
        }
        return this.birthDate;
    }

    public boolean hasBirthDateElement() {
        return this.birthDate != null && !this.birthDate.isEmpty();
    }

    public boolean hasBirthDate() {
        return this.birthDate != null && !this.birthDate.isEmpty();
    }

    public Patient setBirthDateElement(DateType value) {
        this.birthDate = value;
        return this;
    }

    public Date getBirthDate() {
        return this.birthDate == null ? null : (Date)this.birthDate.getValue();
    }

    public Patient setBirthDate(Date value) {
        if (value == null) {
            this.birthDate = null;
        } else {
            if (this.birthDate == null) {
                this.birthDate = new DateType();
            }
            this.birthDate.setValue(value);
        }
        return this;
    }

    public Type getDeceased() {
        return this.deceased;
    }

    public BooleanType getDeceasedBooleanType() throws FHIRException {
        if (!(this.deceased instanceof BooleanType)) {
            throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.deceased.getClass().getName() + " was encountered");
        }
        return (BooleanType)this.deceased;
    }

    public boolean hasDeceasedBooleanType() {
        return this.deceased instanceof BooleanType;
    }

    public DateTimeType getDeceasedDateTimeType() throws FHIRException {
        if (!(this.deceased instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.deceased.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.deceased;
    }

    public boolean hasDeceasedDateTimeType() {
        return this.deceased instanceof DateTimeType;
    }

    public boolean hasDeceased() {
        return this.deceased != null && !this.deceased.isEmpty();
    }

    public Patient setDeceased(Type value) {
        this.deceased = value;
        return this;
    }

    public List<Address> getAddress() {
        if (this.address == null) {
            this.address = new ArrayList<Address>();
        }
        return this.address;
    }

    public Patient setAddress(List<Address> theAddress) {
        this.address = theAddress;
        return this;
    }

    public boolean hasAddress() {
        if (this.address == null) {
            return false;
        }
        for (Address item : this.address) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Address addAddress() {
        Address t = new Address();
        if (this.address == null) {
            this.address = new ArrayList<Address>();
        }
        this.address.add(t);
        return t;
    }

    public Patient addAddress(Address t) {
        if (t == null) {
            return this;
        }
        if (this.address == null) {
            this.address = new ArrayList<Address>();
        }
        this.address.add(t);
        return this;
    }

    public Address getAddressFirstRep() {
        if (this.getAddress().isEmpty()) {
            this.addAddress();
        }
        return this.getAddress().get(0);
    }

    public CodeableConcept getMaritalStatus() {
        if (this.maritalStatus == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Patient.maritalStatus");
            }
            if (Configuration.doAutoCreate()) {
                this.maritalStatus = new CodeableConcept();
            }
        }
        return this.maritalStatus;
    }

    public boolean hasMaritalStatus() {
        return this.maritalStatus != null && !this.maritalStatus.isEmpty();
    }

    public Patient setMaritalStatus(CodeableConcept value) {
        this.maritalStatus = value;
        return this;
    }

    public Type getMultipleBirth() {
        return this.multipleBirth;
    }

    public BooleanType getMultipleBirthBooleanType() throws FHIRException {
        if (!(this.multipleBirth instanceof BooleanType)) {
            throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.multipleBirth.getClass().getName() + " was encountered");
        }
        return (BooleanType)this.multipleBirth;
    }

    public boolean hasMultipleBirthBooleanType() {
        return this.multipleBirth instanceof BooleanType;
    }

    public IntegerType getMultipleBirthIntegerType() throws FHIRException {
        if (!(this.multipleBirth instanceof IntegerType)) {
            throw new FHIRException("Type mismatch: the type IntegerType was expected, but " + this.multipleBirth.getClass().getName() + " was encountered");
        }
        return (IntegerType)this.multipleBirth;
    }

    public boolean hasMultipleBirthIntegerType() {
        return this.multipleBirth instanceof IntegerType;
    }

    public boolean hasMultipleBirth() {
        return this.multipleBirth != null && !this.multipleBirth.isEmpty();
    }

    public Patient setMultipleBirth(Type value) {
        this.multipleBirth = value;
        return this;
    }

    public List<Attachment> getPhoto() {
        if (this.photo == null) {
            this.photo = new ArrayList<Attachment>();
        }
        return this.photo;
    }

    public Patient setPhoto(List<Attachment> thePhoto) {
        this.photo = thePhoto;
        return this;
    }

    public boolean hasPhoto() {
        if (this.photo == null) {
            return false;
        }
        for (Attachment item : this.photo) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Attachment addPhoto() {
        Attachment t = new Attachment();
        if (this.photo == null) {
            this.photo = new ArrayList<Attachment>();
        }
        this.photo.add(t);
        return t;
    }

    public Patient addPhoto(Attachment t) {
        if (t == null) {
            return this;
        }
        if (this.photo == null) {
            this.photo = new ArrayList<Attachment>();
        }
        this.photo.add(t);
        return this;
    }

    public Attachment getPhotoFirstRep() {
        if (this.getPhoto().isEmpty()) {
            this.addPhoto();
        }
        return this.getPhoto().get(0);
    }

    public List<ContactComponent> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactComponent>();
        }
        return this.contact;
    }

    public Patient setContact(List<ContactComponent> theContact) {
        this.contact = theContact;
        return this;
    }

    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactComponent item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactComponent addContact() {
        ContactComponent t = new ContactComponent();
        if (this.contact == null) {
            this.contact = new ArrayList<ContactComponent>();
        }
        this.contact.add(t);
        return t;
    }

    public Patient addContact(ContactComponent t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ContactComponent>();
        }
        this.contact.add(t);
        return this;
    }

    public ContactComponent getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    public AnimalComponent getAnimal() {
        if (this.animal == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Patient.animal");
            }
            if (Configuration.doAutoCreate()) {
                this.animal = new AnimalComponent();
            }
        }
        return this.animal;
    }

    public boolean hasAnimal() {
        return this.animal != null && !this.animal.isEmpty();
    }

    public Patient setAnimal(AnimalComponent value) {
        this.animal = value;
        return this;
    }

    public List<PatientCommunicationComponent> getCommunication() {
        if (this.communication == null) {
            this.communication = new ArrayList<PatientCommunicationComponent>();
        }
        return this.communication;
    }

    public Patient setCommunication(List<PatientCommunicationComponent> theCommunication) {
        this.communication = theCommunication;
        return this;
    }

    public boolean hasCommunication() {
        if (this.communication == null) {
            return false;
        }
        for (PatientCommunicationComponent item : this.communication) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public PatientCommunicationComponent addCommunication() {
        PatientCommunicationComponent t = new PatientCommunicationComponent();
        if (this.communication == null) {
            this.communication = new ArrayList<PatientCommunicationComponent>();
        }
        this.communication.add(t);
        return t;
    }

    public Patient addCommunication(PatientCommunicationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.communication == null) {
            this.communication = new ArrayList<PatientCommunicationComponent>();
        }
        this.communication.add(t);
        return this;
    }

    public PatientCommunicationComponent getCommunicationFirstRep() {
        if (this.getCommunication().isEmpty()) {
            this.addCommunication();
        }
        return this.getCommunication().get(0);
    }

    public List<Reference> getGeneralPractitioner() {
        if (this.generalPractitioner == null) {
            this.generalPractitioner = new ArrayList<Reference>();
        }
        return this.generalPractitioner;
    }

    public Patient setGeneralPractitioner(List<Reference> theGeneralPractitioner) {
        this.generalPractitioner = theGeneralPractitioner;
        return this;
    }

    public boolean hasGeneralPractitioner() {
        if (this.generalPractitioner == null) {
            return false;
        }
        for (Reference item : this.generalPractitioner) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addGeneralPractitioner() {
        Reference t = new Reference();
        if (this.generalPractitioner == null) {
            this.generalPractitioner = new ArrayList<Reference>();
        }
        this.generalPractitioner.add(t);
        return t;
    }

    public Patient addGeneralPractitioner(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.generalPractitioner == null) {
            this.generalPractitioner = new ArrayList<Reference>();
        }
        this.generalPractitioner.add(t);
        return this;
    }

    public Reference getGeneralPractitionerFirstRep() {
        if (this.getGeneralPractitioner().isEmpty()) {
            this.addGeneralPractitioner();
        }
        return this.getGeneralPractitioner().get(0);
    }

    @Deprecated
    public List<Resource> getGeneralPractitionerTarget() {
        if (this.generalPractitionerTarget == null) {
            this.generalPractitionerTarget = new ArrayList<Resource>();
        }
        return this.generalPractitionerTarget;
    }

    public Reference getManagingOrganization() {
        if (this.managingOrganization == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Patient.managingOrganization");
            }
            if (Configuration.doAutoCreate()) {
                this.managingOrganization = new Reference();
            }
        }
        return this.managingOrganization;
    }

    public boolean hasManagingOrganization() {
        return this.managingOrganization != null && !this.managingOrganization.isEmpty();
    }

    public Patient setManagingOrganization(Reference value) {
        this.managingOrganization = value;
        return this;
    }

    public Organization getManagingOrganizationTarget() {
        if (this.managingOrganizationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Patient.managingOrganization");
            }
            if (Configuration.doAutoCreate()) {
                this.managingOrganizationTarget = new Organization();
            }
        }
        return this.managingOrganizationTarget;
    }

    public Patient setManagingOrganizationTarget(Organization value) {
        this.managingOrganizationTarget = value;
        return this;
    }

    public List<PatientLinkComponent> getLink() {
        if (this.link == null) {
            this.link = new ArrayList<PatientLinkComponent>();
        }
        return this.link;
    }

    public Patient setLink(List<PatientLinkComponent> theLink) {
        this.link = theLink;
        return this;
    }

    public boolean hasLink() {
        if (this.link == null) {
            return false;
        }
        for (PatientLinkComponent item : this.link) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public PatientLinkComponent addLink() {
        PatientLinkComponent t = new PatientLinkComponent();
        if (this.link == null) {
            this.link = new ArrayList<PatientLinkComponent>();
        }
        this.link.add(t);
        return t;
    }

    public Patient addLink(PatientLinkComponent t) {
        if (t == null) {
            return this;
        }
        if (this.link == null) {
            this.link = new ArrayList<PatientLinkComponent>();
        }
        this.link.add(t);
        return this;
    }

    public PatientLinkComponent getLinkFirstRep() {
        if (this.getLink().isEmpty()) {
            this.addLink();
        }
        return this.getLink().get(0);
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "An identifier for this patient.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_ACTIVE, "boolean", "Whether this patient record is in active use.", 0, Integer.MAX_VALUE, this.active));
        childrenList.add(new Property(SP_NAME, "HumanName", "A name associated with the individual.", 0, Integer.MAX_VALUE, this.name));
        childrenList.add(new Property(SP_TELECOM, "ContactPoint", "A contact detail (e.g. a telephone number or an email address) by which the individual may be contacted.", 0, Integer.MAX_VALUE, this.telecom));
        childrenList.add(new Property(SP_GENDER, "code", "Administrative Gender - the gender that the patient is considered to have for administration and record keeping purposes.", 0, Integer.MAX_VALUE, this.gender));
        childrenList.add(new Property("birthDate", "date", "The date of birth for the individual.", 0, Integer.MAX_VALUE, this.birthDate));
        childrenList.add(new Property("deceased[x]", "boolean|dateTime", "Indicates if the individual is deceased or not.", 0, Integer.MAX_VALUE, this.deceased));
        childrenList.add(new Property(SP_ADDRESS, "Address", "Addresses for the individual.", 0, Integer.MAX_VALUE, this.address));
        childrenList.add(new Property("maritalStatus", "CodeableConcept", "This field contains a patient's most recent marital (civil) status.", 0, Integer.MAX_VALUE, this.maritalStatus));
        childrenList.add(new Property("multipleBirth[x]", "boolean|integer", "Indicates whether the patient is part of a multiple (bool) or indicates the actual birth order (integer).", 0, Integer.MAX_VALUE, this.multipleBirth));
        childrenList.add(new Property("photo", "Attachment", "Image of the patient.", 0, Integer.MAX_VALUE, this.photo));
        childrenList.add(new Property("contact", "", "A contact party (e.g. guardian, partner, friend) for the patient.", 0, Integer.MAX_VALUE, this.contact));
        childrenList.add(new Property("animal", "", "This patient is known to be an animal.", 0, Integer.MAX_VALUE, this.animal));
        childrenList.add(new Property("communication", "", "Languages which may be used to communicate with the patient about his or her health.", 0, Integer.MAX_VALUE, this.communication));
        childrenList.add(new Property("generalPractitioner", "Reference(Organization|Practitioner)", "Patient's nominated care provider.", 0, Integer.MAX_VALUE, this.generalPractitioner));
        childrenList.add(new Property("managingOrganization", "Reference(Organization)", "Organization that is the custodian of the patient record.", 0, Integer.MAX_VALUE, this.managingOrganization));
        childrenList.add(new Property(SP_LINK, "", "Link to another patient resource that concerns the same actual patient.", 0, Integer.MAX_VALUE, this.link));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -1422950650: {
                Base[] baseArray;
                if (this.active == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.active;
                }
                return baseArray;
            }
            case 3373707: {
                return this.name == null ? new Base[]{} : this.name.toArray(new Base[this.name.size()]);
            }
            case -1429363305: {
                return this.telecom == null ? new Base[]{} : this.telecom.toArray(new Base[this.telecom.size()]);
            }
            case -1249512767: {
                Base[] baseArray;
                if (this.gender == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.gender;
                }
                return baseArray;
            }
            case -1210031859: {
                Base[] baseArray;
                if (this.birthDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.birthDate;
                }
                return baseArray;
            }
            case 561497972: {
                Base[] baseArray;
                if (this.deceased == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.deceased;
                }
                return baseArray;
            }
            case -1147692044: {
                return this.address == null ? new Base[]{} : this.address.toArray(new Base[this.address.size()]);
            }
            case 1756919302: {
                Base[] baseArray;
                if (this.maritalStatus == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.maritalStatus;
                }
                return baseArray;
            }
            case -677369713: {
                Base[] baseArray;
                if (this.multipleBirth == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.multipleBirth;
                }
                return baseArray;
            }
            case 106642994: {
                return this.photo == null ? new Base[]{} : this.photo.toArray(new Base[this.photo.size()]);
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1413116420: {
                Base[] baseArray;
                if (this.animal == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.animal;
                }
                return baseArray;
            }
            case -1035284522: {
                return this.communication == null ? new Base[]{} : this.communication.toArray(new Base[this.communication.size()]);
            }
            case 1488292898: {
                return this.generalPractitioner == null ? new Base[]{} : this.generalPractitioner.toArray(new Base[this.generalPractitioner.size()]);
            }
            case -2058947787: {
                Base[] baseArray;
                if (this.managingOrganization == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.managingOrganization;
                }
                return baseArray;
            }
            case 3321850: {
                return this.link == null ? new Base[]{} : this.link.toArray(new Base[this.link.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -1422950650: {
                this.active = this.castToBoolean(value);
                return value;
            }
            case 3373707: {
                this.getName().add(this.castToHumanName(value));
                return value;
            }
            case -1429363305: {
                this.getTelecom().add(this.castToContactPoint(value));
                return value;
            }
            case -1249512767: {
                value = new Enumerations.AdministrativeGenderEnumFactory().fromType(this.castToCode(value));
                this.gender = value;
                return value;
            }
            case -1210031859: {
                this.birthDate = this.castToDate(value);
                return value;
            }
            case 561497972: {
                this.deceased = this.castToType(value);
                return value;
            }
            case -1147692044: {
                this.getAddress().add(this.castToAddress(value));
                return value;
            }
            case 1756919302: {
                this.maritalStatus = this.castToCodeableConcept(value);
                return value;
            }
            case -677369713: {
                this.multipleBirth = this.castToType(value);
                return value;
            }
            case 106642994: {
                this.getPhoto().add(this.castToAttachment(value));
                return value;
            }
            case 951526432: {
                this.getContact().add((ContactComponent)((Object)value));
                return value;
            }
            case -1413116420: {
                this.animal = (AnimalComponent)((Object)value);
                return value;
            }
            case -1035284522: {
                this.getCommunication().add((PatientCommunicationComponent)((Object)value));
                return value;
            }
            case 1488292898: {
                this.getGeneralPractitioner().add(this.castToReference(value));
                return value;
            }
            case -2058947787: {
                this.managingOrganization = this.castToReference(value);
                return value;
            }
            case 3321850: {
                this.getLink().add((PatientLinkComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_ACTIVE)) {
            this.active = this.castToBoolean(value);
        } else if (name.equals(SP_NAME)) {
            this.getName().add(this.castToHumanName(value));
        } else if (name.equals(SP_TELECOM)) {
            this.getTelecom().add(this.castToContactPoint(value));
        } else if (name.equals(SP_GENDER)) {
            value = new Enumerations.AdministrativeGenderEnumFactory().fromType(this.castToCode(value));
            this.gender = value;
        } else if (name.equals("birthDate")) {
            this.birthDate = this.castToDate(value);
        } else if (name.equals("deceased[x]")) {
            this.deceased = this.castToType(value);
        } else if (name.equals(SP_ADDRESS)) {
            this.getAddress().add(this.castToAddress(value));
        } else if (name.equals("maritalStatus")) {
            this.maritalStatus = this.castToCodeableConcept(value);
        } else if (name.equals("multipleBirth[x]")) {
            this.multipleBirth = this.castToType(value);
        } else if (name.equals("photo")) {
            this.getPhoto().add(this.castToAttachment(value));
        } else if (name.equals("contact")) {
            this.getContact().add((ContactComponent)((Object)value));
        } else if (name.equals("animal")) {
            this.animal = (AnimalComponent)((Object)value);
        } else if (name.equals("communication")) {
            this.getCommunication().add((PatientCommunicationComponent)((Object)value));
        } else if (name.equals("generalPractitioner")) {
            this.getGeneralPractitioner().add(this.castToReference(value));
        } else if (name.equals("managingOrganization")) {
            this.managingOrganization = this.castToReference(value);
        } else if (name.equals(SP_LINK)) {
            this.getLink().add((PatientLinkComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -1422950650: {
                return this.getActiveElement();
            }
            case 3373707: {
                return this.addName();
            }
            case -1429363305: {
                return this.addTelecom();
            }
            case -1249512767: {
                return this.getGenderElement();
            }
            case -1210031859: {
                return this.getBirthDateElement();
            }
            case -1311442804: {
                return this.getDeceased();
            }
            case 561497972: {
                return this.getDeceased();
            }
            case -1147692044: {
                return this.addAddress();
            }
            case 1756919302: {
                return this.getMaritalStatus();
            }
            case -1764672111: {
                return this.getMultipleBirth();
            }
            case -677369713: {
                return this.getMultipleBirth();
            }
            case 106642994: {
                return this.addPhoto();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1413116420: {
                return this.getAnimal();
            }
            case -1035284522: {
                return this.addCommunication();
            }
            case 1488292898: {
                return this.addGeneralPractitioner();
            }
            case -2058947787: {
                return this.getManagingOrganization();
            }
            case 3321850: {
                return this.addLink();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -1422950650: {
                return new String[]{"boolean"};
            }
            case 3373707: {
                return new String[]{"HumanName"};
            }
            case -1429363305: {
                return new String[]{"ContactPoint"};
            }
            case -1249512767: {
                return new String[]{"code"};
            }
            case -1210031859: {
                return new String[]{"date"};
            }
            case 561497972: {
                return new String[]{"boolean", "dateTime"};
            }
            case -1147692044: {
                return new String[]{"Address"};
            }
            case 1756919302: {
                return new String[]{"CodeableConcept"};
            }
            case -677369713: {
                return new String[]{"boolean", "integer"};
            }
            case 106642994: {
                return new String[]{"Attachment"};
            }
            case 951526432: {
                return new String[0];
            }
            case -1413116420: {
                return new String[0];
            }
            case -1035284522: {
                return new String[0];
            }
            case 1488292898: {
                return new String[]{"Reference"};
            }
            case -2058947787: {
                return new String[]{"Reference"};
            }
            case 3321850: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_ACTIVE)) {
            throw new FHIRException("Cannot call addChild on a primitive type Patient.active");
        }
        if (name.equals(SP_NAME)) {
            return this.addName();
        }
        if (name.equals(SP_TELECOM)) {
            return this.addTelecom();
        }
        if (name.equals(SP_GENDER)) {
            throw new FHIRException("Cannot call addChild on a primitive type Patient.gender");
        }
        if (name.equals("birthDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type Patient.birthDate");
        }
        if (name.equals("deceasedBoolean")) {
            this.deceased = new BooleanType();
            return this.deceased;
        }
        if (name.equals("deceasedDateTime")) {
            this.deceased = new DateTimeType();
            return this.deceased;
        }
        if (name.equals(SP_ADDRESS)) {
            return this.addAddress();
        }
        if (name.equals("maritalStatus")) {
            this.maritalStatus = new CodeableConcept();
            return this.maritalStatus;
        }
        if (name.equals("multipleBirthBoolean")) {
            this.multipleBirth = new BooleanType();
            return this.multipleBirth;
        }
        if (name.equals("multipleBirthInteger")) {
            this.multipleBirth = new IntegerType();
            return this.multipleBirth;
        }
        if (name.equals("photo")) {
            return this.addPhoto();
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals("animal")) {
            this.animal = new AnimalComponent();
            return this.animal;
        }
        if (name.equals("communication")) {
            return this.addCommunication();
        }
        if (name.equals("generalPractitioner")) {
            return this.addGeneralPractitioner();
        }
        if (name.equals("managingOrganization")) {
            this.managingOrganization = new Reference();
            return this.managingOrganization;
        }
        if (name.equals(SP_LINK)) {
            return this.addLink();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Patient";
    }

    @Override
    public Patient copy() {
        Patient dst = new Patient();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        BooleanType booleanType = dst.active = this.active == null ? null : this.active.copy();
        if (this.name != null) {
            dst.name = new ArrayList<HumanName>();
            for (HumanName humanName : this.name) {
                dst.name.add(humanName.copy());
            }
        }
        if (this.telecom != null) {
            dst.telecom = new ArrayList<ContactPoint>();
            for (ContactPoint contactPoint : this.telecom) {
                dst.telecom.add(contactPoint.copy());
            }
        }
        dst.gender = this.gender == null ? null : this.gender.copy();
        dst.birthDate = this.birthDate == null ? null : this.birthDate.copy();
        Type type = dst.deceased = this.deceased == null ? null : this.deceased.copy();
        if (this.address != null) {
            dst.address = new ArrayList<Address>();
            for (Address address : this.address) {
                dst.address.add(address.copy());
            }
        }
        dst.maritalStatus = this.maritalStatus == null ? null : this.maritalStatus.copy();
        Type type2 = dst.multipleBirth = this.multipleBirth == null ? null : this.multipleBirth.copy();
        if (this.photo != null) {
            dst.photo = new ArrayList<Attachment>();
            for (Attachment attachment : this.photo) {
                dst.photo.add(attachment.copy());
            }
        }
        if (this.contact != null) {
            dst.contact = new ArrayList<ContactComponent>();
            for (ContactComponent contactComponent : this.contact) {
                dst.contact.add(contactComponent.copy());
            }
        }
        AnimalComponent animalComponent = dst.animal = this.animal == null ? null : this.animal.copy();
        if (this.communication != null) {
            dst.communication = new ArrayList<PatientCommunicationComponent>();
            for (PatientCommunicationComponent patientCommunicationComponent : this.communication) {
                dst.communication.add(patientCommunicationComponent.copy());
            }
        }
        if (this.generalPractitioner != null) {
            dst.generalPractitioner = new ArrayList<Reference>();
            for (Reference reference : this.generalPractitioner) {
                dst.generalPractitioner.add(reference.copy());
            }
        }
        Reference reference = dst.managingOrganization = this.managingOrganization == null ? null : this.managingOrganization.copy();
        if (this.link != null) {
            dst.link = new ArrayList<PatientLinkComponent>();
            for (PatientLinkComponent patientLinkComponent : this.link) {
                dst.link.add(patientLinkComponent.copy());
            }
        }
        return dst;
    }

    protected Patient typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Patient)) {
            return false;
        }
        Patient o = (Patient)other;
        return Patient.compareDeep(this.identifier, o.identifier, true) && Patient.compareDeep(this.active, o.active, true) && Patient.compareDeep(this.name, o.name, true) && Patient.compareDeep(this.telecom, o.telecom, true) && Patient.compareDeep(this.gender, o.gender, true) && Patient.compareDeep(this.birthDate, o.birthDate, true) && Patient.compareDeep(this.deceased, o.deceased, true) && Patient.compareDeep(this.address, o.address, true) && Patient.compareDeep(this.maritalStatus, o.maritalStatus, true) && Patient.compareDeep(this.multipleBirth, o.multipleBirth, true) && Patient.compareDeep(this.photo, o.photo, true) && Patient.compareDeep(this.contact, o.contact, true) && Patient.compareDeep(this.animal, o.animal, true) && Patient.compareDeep(this.communication, o.communication, true) && Patient.compareDeep(this.generalPractitioner, o.generalPractitioner, true) && Patient.compareDeep(this.managingOrganization, o.managingOrganization, true) && Patient.compareDeep(this.link, o.link, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Patient)) {
            return false;
        }
        Patient o = (Patient)other;
        return Patient.compareValues(this.active, o.active, true) && Patient.compareValues(this.gender, o.gender, true) && Patient.compareValues(this.birthDate, o.birthDate, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.active, this.name, this.telecom, this.gender, this.birthDate, this.deceased, this.address, this.maritalStatus, this.multipleBirth, this.photo, this.contact, this.animal, this.communication, this.generalPractitioner, this.managingOrganization, this.link});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Patient;
    }

    @Block
    public static class PatientLinkComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="other", type={Patient.class, RelatedPerson.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The other patient or related person resource that the link refers to", formalDefinition="The other patient resource that the link refers to.")
        protected Reference other;
        protected Resource otherTarget;
        @Child(name="type", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="replaced-by | replaces | refer | seealso - type of link", formalDefinition="The type of link between this patient resource and another patient resource.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/link-type")
        protected Enumeration<LinkType> type;
        private static final long serialVersionUID = 1083576633L;

        public PatientLinkComponent() {
        }

        public PatientLinkComponent(Reference other, Enumeration<LinkType> type) {
            this.other = other;
            this.type = type;
        }

        public Reference getOther() {
            if (this.other == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PatientLinkComponent.other");
                }
                if (Configuration.doAutoCreate()) {
                    this.other = new Reference();
                }
            }
            return this.other;
        }

        public boolean hasOther() {
            return this.other != null && !this.other.isEmpty();
        }

        public PatientLinkComponent setOther(Reference value) {
            this.other = value;
            return this;
        }

        public Resource getOtherTarget() {
            return this.otherTarget;
        }

        public PatientLinkComponent setOtherTarget(Resource value) {
            this.otherTarget = value;
            return this;
        }

        public Enumeration<LinkType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PatientLinkComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<LinkType>(new LinkTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public PatientLinkComponent setTypeElement(Enumeration<LinkType> value) {
            this.type = value;
            return this;
        }

        public LinkType getType() {
            return this.type == null ? null : (LinkType)((Object)this.type.getValue());
        }

        public PatientLinkComponent setType(LinkType value) {
            if (this.type == null) {
                this.type = new Enumeration<LinkType>(new LinkTypeEnumFactory());
            }
            this.type.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("other", "Reference(Patient|RelatedPerson)", "The other patient resource that the link refers to.", 0, Integer.MAX_VALUE, this.other));
            childrenList.add(new Property("type", "code", "The type of link between this patient resource and another patient resource.", 0, Integer.MAX_VALUE, this.type));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 106069776: {
                    Base[] baseArray;
                    if (this.other == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.other;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 106069776: {
                    this.other = this.castToReference(value);
                    return value;
                }
                case 3575610: {
                    value = new LinkTypeEnumFactory().fromType(this.castToCode(value));
                    this.type = value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("other")) {
                this.other = this.castToReference(value);
            } else if (name.equals("type")) {
                value = new LinkTypeEnumFactory().fromType(this.castToCode(value));
                this.type = value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 106069776: {
                    return this.getOther();
                }
                case 3575610: {
                    return this.getTypeElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 106069776: {
                    return new String[]{"Reference"};
                }
                case 3575610: {
                    return new String[]{"code"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("other")) {
                this.other = new Reference();
                return this.other;
            }
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type Patient.type");
            }
            return super.addChild(name);
        }

        @Override
        public PatientLinkComponent copy() {
            PatientLinkComponent dst = new PatientLinkComponent();
            this.copyValues(dst);
            dst.other = this.other == null ? null : this.other.copy();
            dst.type = this.type == null ? null : this.type.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof PatientLinkComponent)) {
                return false;
            }
            PatientLinkComponent o = (PatientLinkComponent)other;
            return PatientLinkComponent.compareDeep(other, o.other, true) && PatientLinkComponent.compareDeep(this.type, o.type, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof PatientLinkComponent)) {
                return false;
            }
            PatientLinkComponent o = (PatientLinkComponent)other;
            return PatientLinkComponent.compareValues(this.type, o.type, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.other, this.type});
        }

        @Override
        public String fhirType() {
            return "Patient.link";
        }
    }

    @Block
    public static class PatientCommunicationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="language", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The language which can be used to communicate with the patient about his or her health", formalDefinition="The ISO-639-1 alpha 2 code in lower case for the language, optionally followed by a hyphen and the ISO-3166-1 alpha 2 code for the region in upper case; e.g. \"en\" for English, or \"en-US\" for American English versus \"en-EN\" for England English.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/languages")
        protected CodeableConcept language;
        @Child(name="preferred", type={BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Language preference indicator", formalDefinition="Indicates whether or not the patient prefers this language (over other languages he masters up a certain level).")
        protected BooleanType preferred;
        private static final long serialVersionUID = 633792918L;

        public PatientCommunicationComponent() {
        }

        public PatientCommunicationComponent(CodeableConcept language) {
            this.language = language;
        }

        public CodeableConcept getLanguage() {
            if (this.language == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PatientCommunicationComponent.language");
                }
                if (Configuration.doAutoCreate()) {
                    this.language = new CodeableConcept();
                }
            }
            return this.language;
        }

        public boolean hasLanguage() {
            return this.language != null && !this.language.isEmpty();
        }

        public PatientCommunicationComponent setLanguage(CodeableConcept value) {
            this.language = value;
            return this;
        }

        public BooleanType getPreferredElement() {
            if (this.preferred == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PatientCommunicationComponent.preferred");
                }
                if (Configuration.doAutoCreate()) {
                    this.preferred = new BooleanType();
                }
            }
            return this.preferred;
        }

        public boolean hasPreferredElement() {
            return this.preferred != null && !this.preferred.isEmpty();
        }

        public boolean hasPreferred() {
            return this.preferred != null && !this.preferred.isEmpty();
        }

        public PatientCommunicationComponent setPreferredElement(BooleanType value) {
            this.preferred = value;
            return this;
        }

        public boolean getPreferred() {
            return this.preferred == null || this.preferred.isEmpty() ? false : (Boolean)this.preferred.getValue();
        }

        public PatientCommunicationComponent setPreferred(boolean value) {
            if (this.preferred == null) {
                this.preferred = new BooleanType();
            }
            this.preferred.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(Patient.SP_LANGUAGE, "CodeableConcept", "The ISO-639-1 alpha 2 code in lower case for the language, optionally followed by a hyphen and the ISO-3166-1 alpha 2 code for the region in upper case; e.g. \"en\" for English, or \"en-US\" for American English versus \"en-EN\" for England English.", 0, Integer.MAX_VALUE, this.language));
            childrenList.add(new Property("preferred", "boolean", "Indicates whether or not the patient prefers this language (over other languages he masters up a certain level).", 0, Integer.MAX_VALUE, this.preferred));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1613589672: {
                    Base[] baseArray;
                    if (this.language == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.language;
                    }
                    return baseArray;
                }
                case -1294005119: {
                    Base[] baseArray;
                    if (this.preferred == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.preferred;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1613589672: {
                    this.language = this.castToCodeableConcept(value);
                    return value;
                }
                case -1294005119: {
                    this.preferred = this.castToBoolean(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Patient.SP_LANGUAGE)) {
                this.language = this.castToCodeableConcept(value);
            } else if (name.equals("preferred")) {
                this.preferred = this.castToBoolean(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1613589672: {
                    return this.getLanguage();
                }
                case -1294005119: {
                    return this.getPreferredElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1613589672: {
                    return new String[]{"CodeableConcept"};
                }
                case -1294005119: {
                    return new String[]{"boolean"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Patient.SP_LANGUAGE)) {
                this.language = new CodeableConcept();
                return this.language;
            }
            if (name.equals("preferred")) {
                throw new FHIRException("Cannot call addChild on a primitive type Patient.preferred");
            }
            return super.addChild(name);
        }

        @Override
        public PatientCommunicationComponent copy() {
            PatientCommunicationComponent dst = new PatientCommunicationComponent();
            this.copyValues(dst);
            dst.language = this.language == null ? null : this.language.copy();
            dst.preferred = this.preferred == null ? null : this.preferred.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof PatientCommunicationComponent)) {
                return false;
            }
            PatientCommunicationComponent o = (PatientCommunicationComponent)other;
            return PatientCommunicationComponent.compareDeep(this.language, o.language, true) && PatientCommunicationComponent.compareDeep(this.preferred, o.preferred, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof PatientCommunicationComponent)) {
                return false;
            }
            PatientCommunicationComponent o = (PatientCommunicationComponent)other;
            return PatientCommunicationComponent.compareValues(this.preferred, o.preferred, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.language, this.preferred});
        }

        @Override
        public String fhirType() {
            return "Patient.communication";
        }
    }

    @Block
    public static class AnimalComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="species", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="E.g. Dog, Cow", formalDefinition="Identifies the high level taxonomic categorization of the kind of animal.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/animal-species")
        protected CodeableConcept species;
        @Child(name="breed", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="E.g. Poodle, Angus", formalDefinition="Identifies the detailed categorization of the kind of animal.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/animal-breeds")
        protected CodeableConcept breed;
        @Child(name="genderStatus", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="E.g. Neutered, Intact", formalDefinition="Indicates the current state of the animal's reproductive organs.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/animal-genderstatus")
        protected CodeableConcept genderStatus;
        private static final long serialVersionUID = -549738382L;

        public AnimalComponent() {
        }

        public AnimalComponent(CodeableConcept species) {
            this.species = species;
        }

        public CodeableConcept getSpecies() {
            if (this.species == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AnimalComponent.species");
                }
                if (Configuration.doAutoCreate()) {
                    this.species = new CodeableConcept();
                }
            }
            return this.species;
        }

        public boolean hasSpecies() {
            return this.species != null && !this.species.isEmpty();
        }

        public AnimalComponent setSpecies(CodeableConcept value) {
            this.species = value;
            return this;
        }

        public CodeableConcept getBreed() {
            if (this.breed == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AnimalComponent.breed");
                }
                if (Configuration.doAutoCreate()) {
                    this.breed = new CodeableConcept();
                }
            }
            return this.breed;
        }

        public boolean hasBreed() {
            return this.breed != null && !this.breed.isEmpty();
        }

        public AnimalComponent setBreed(CodeableConcept value) {
            this.breed = value;
            return this;
        }

        public CodeableConcept getGenderStatus() {
            if (this.genderStatus == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AnimalComponent.genderStatus");
                }
                if (Configuration.doAutoCreate()) {
                    this.genderStatus = new CodeableConcept();
                }
            }
            return this.genderStatus;
        }

        public boolean hasGenderStatus() {
            return this.genderStatus != null && !this.genderStatus.isEmpty();
        }

        public AnimalComponent setGenderStatus(CodeableConcept value) {
            this.genderStatus = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("species", "CodeableConcept", "Identifies the high level taxonomic categorization of the kind of animal.", 0, Integer.MAX_VALUE, this.species));
            childrenList.add(new Property("breed", "CodeableConcept", "Identifies the detailed categorization of the kind of animal.", 0, Integer.MAX_VALUE, this.breed));
            childrenList.add(new Property("genderStatus", "CodeableConcept", "Indicates the current state of the animal's reproductive organs.", 0, Integer.MAX_VALUE, this.genderStatus));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -2008465092: {
                    Base[] baseArray;
                    if (this.species == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.species;
                    }
                    return baseArray;
                }
                case 94001524: {
                    Base[] baseArray;
                    if (this.breed == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.breed;
                    }
                    return baseArray;
                }
                case -678569453: {
                    Base[] baseArray;
                    if (this.genderStatus == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.genderStatus;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -2008465092: {
                    this.species = this.castToCodeableConcept(value);
                    return value;
                }
                case 94001524: {
                    this.breed = this.castToCodeableConcept(value);
                    return value;
                }
                case -678569453: {
                    this.genderStatus = this.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("species")) {
                this.species = this.castToCodeableConcept(value);
            } else if (name.equals("breed")) {
                this.breed = this.castToCodeableConcept(value);
            } else if (name.equals("genderStatus")) {
                this.genderStatus = this.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -2008465092: {
                    return this.getSpecies();
                }
                case 94001524: {
                    return this.getBreed();
                }
                case -678569453: {
                    return this.getGenderStatus();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -2008465092: {
                    return new String[]{"CodeableConcept"};
                }
                case 94001524: {
                    return new String[]{"CodeableConcept"};
                }
                case -678569453: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("species")) {
                this.species = new CodeableConcept();
                return this.species;
            }
            if (name.equals("breed")) {
                this.breed = new CodeableConcept();
                return this.breed;
            }
            if (name.equals("genderStatus")) {
                this.genderStatus = new CodeableConcept();
                return this.genderStatus;
            }
            return super.addChild(name);
        }

        @Override
        public AnimalComponent copy() {
            AnimalComponent dst = new AnimalComponent();
            this.copyValues(dst);
            dst.species = this.species == null ? null : this.species.copy();
            dst.breed = this.breed == null ? null : this.breed.copy();
            dst.genderStatus = this.genderStatus == null ? null : this.genderStatus.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof AnimalComponent)) {
                return false;
            }
            AnimalComponent o = (AnimalComponent)other;
            return AnimalComponent.compareDeep(this.species, o.species, true) && AnimalComponent.compareDeep(this.breed, o.breed, true) && AnimalComponent.compareDeep(this.genderStatus, o.genderStatus, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof AnimalComponent)) {
                return false;
            }
            AnimalComponent o = (AnimalComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.species, this.breed, this.genderStatus});
        }

        @Override
        public String fhirType() {
            return "Patient.animal";
        }
    }

    @Block
    public static class ContactComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="relationship", type={CodeableConcept.class}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The kind of relationship", formalDefinition="The nature of the relationship between the patient and the contact person.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/v2-0131")
        protected List<CodeableConcept> relationship;
        @Child(name="name", type={HumanName.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="A name associated with the contact person", formalDefinition="A name associated with the contact person.")
        protected HumanName name;
        @Child(name="telecom", type={ContactPoint.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="A contact detail for the person", formalDefinition="A contact detail for the person, e.g. a telephone number or an email address.")
        protected List<ContactPoint> telecom;
        @Child(name="address", type={Address.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Address for the contact person", formalDefinition="Address for the contact person.")
        protected Address address;
        @Child(name="gender", type={CodeType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="male | female | other | unknown", formalDefinition="Administrative Gender - the gender that the contact person is considered to have for administration and record keeping purposes.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/administrative-gender")
        protected Enumeration<Enumerations.AdministrativeGender> gender;
        @Child(name="organization", type={Organization.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Organization that is associated with the contact", formalDefinition="Organization on behalf of which the contact is acting or for which the contact is working.")
        protected Reference organization;
        protected Organization organizationTarget;
        @Child(name="period", type={Period.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The period during which this contact person or organization is valid to be contacted relating to this patient", formalDefinition="The period during which this contact person or organization is valid to be contacted relating to this patient.")
        protected Period period;
        private static final long serialVersionUID = 364269017L;

        public List<CodeableConcept> getRelationship() {
            if (this.relationship == null) {
                this.relationship = new ArrayList<CodeableConcept>();
            }
            return this.relationship;
        }

        public ContactComponent setRelationship(List<CodeableConcept> theRelationship) {
            this.relationship = theRelationship;
            return this;
        }

        public boolean hasRelationship() {
            if (this.relationship == null) {
                return false;
            }
            for (CodeableConcept item : this.relationship) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addRelationship() {
            CodeableConcept t = new CodeableConcept();
            if (this.relationship == null) {
                this.relationship = new ArrayList<CodeableConcept>();
            }
            this.relationship.add(t);
            return t;
        }

        public ContactComponent addRelationship(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.relationship == null) {
                this.relationship = new ArrayList<CodeableConcept>();
            }
            this.relationship.add(t);
            return this;
        }

        public CodeableConcept getRelationshipFirstRep() {
            if (this.getRelationship().isEmpty()) {
                this.addRelationship();
            }
            return this.getRelationship().get(0);
        }

        public HumanName getName() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ContactComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new HumanName();
                }
            }
            return this.name;
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ContactComponent setName(HumanName value) {
            this.name = value;
            return this;
        }

        public List<ContactPoint> getTelecom() {
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            return this.telecom;
        }

        public ContactComponent setTelecom(List<ContactPoint> theTelecom) {
            this.telecom = theTelecom;
            return this;
        }

        public boolean hasTelecom() {
            if (this.telecom == null) {
                return false;
            }
            for (ContactPoint item : this.telecom) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ContactPoint addTelecom() {
            ContactPoint t = new ContactPoint();
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return t;
        }

        public ContactComponent addTelecom(ContactPoint t) {
            if (t == null) {
                return this;
            }
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return this;
        }

        public ContactPoint getTelecomFirstRep() {
            if (this.getTelecom().isEmpty()) {
                this.addTelecom();
            }
            return this.getTelecom().get(0);
        }

        public Address getAddress() {
            if (this.address == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ContactComponent.address");
                }
                if (Configuration.doAutoCreate()) {
                    this.address = new Address();
                }
            }
            return this.address;
        }

        public boolean hasAddress() {
            return this.address != null && !this.address.isEmpty();
        }

        public ContactComponent setAddress(Address value) {
            this.address = value;
            return this;
        }

        public Enumeration<Enumerations.AdministrativeGender> getGenderElement() {
            if (this.gender == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ContactComponent.gender");
                }
                if (Configuration.doAutoCreate()) {
                    this.gender = new Enumeration<Enumerations.AdministrativeGender>(new Enumerations.AdministrativeGenderEnumFactory());
                }
            }
            return this.gender;
        }

        public boolean hasGenderElement() {
            return this.gender != null && !this.gender.isEmpty();
        }

        public boolean hasGender() {
            return this.gender != null && !this.gender.isEmpty();
        }

        public ContactComponent setGenderElement(Enumeration<Enumerations.AdministrativeGender> value) {
            this.gender = value;
            return this;
        }

        public Enumerations.AdministrativeGender getGender() {
            return this.gender == null ? null : (Enumerations.AdministrativeGender)((Object)this.gender.getValue());
        }

        public ContactComponent setGender(Enumerations.AdministrativeGender value) {
            if (value == null) {
                this.gender = null;
            } else {
                if (this.gender == null) {
                    this.gender = new Enumeration<Enumerations.AdministrativeGender>(new Enumerations.AdministrativeGenderEnumFactory());
                }
                this.gender.setValue((Object)value);
            }
            return this;
        }

        public Reference getOrganization() {
            if (this.organization == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ContactComponent.organization");
                }
                if (Configuration.doAutoCreate()) {
                    this.organization = new Reference();
                }
            }
            return this.organization;
        }

        public boolean hasOrganization() {
            return this.organization != null && !this.organization.isEmpty();
        }

        public ContactComponent setOrganization(Reference value) {
            this.organization = value;
            return this;
        }

        public Organization getOrganizationTarget() {
            if (this.organizationTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ContactComponent.organization");
                }
                if (Configuration.doAutoCreate()) {
                    this.organizationTarget = new Organization();
                }
            }
            return this.organizationTarget;
        }

        public ContactComponent setOrganizationTarget(Organization value) {
            this.organizationTarget = value;
            return this;
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ContactComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public ContactComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("relationship", "CodeableConcept", "The nature of the relationship between the patient and the contact person.", 0, Integer.MAX_VALUE, this.relationship));
            childrenList.add(new Property(Patient.SP_NAME, "HumanName", "A name associated with the contact person.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property(Patient.SP_TELECOM, "ContactPoint", "A contact detail for the person, e.g. a telephone number or an email address.", 0, Integer.MAX_VALUE, this.telecom));
            childrenList.add(new Property(Patient.SP_ADDRESS, "Address", "Address for the contact person.", 0, Integer.MAX_VALUE, this.address));
            childrenList.add(new Property(Patient.SP_GENDER, "code", "Administrative Gender - the gender that the contact person is considered to have for administration and record keeping purposes.", 0, Integer.MAX_VALUE, this.gender));
            childrenList.add(new Property(Patient.SP_ORGANIZATION, "Reference(Organization)", "Organization on behalf of which the contact is acting or for which the contact is working.", 0, Integer.MAX_VALUE, this.organization));
            childrenList.add(new Property("period", "Period", "The period during which this contact person or organization is valid to be contacted relating to this patient.", 0, Integer.MAX_VALUE, this.period));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -261851592: {
                    return this.relationship == null ? new Base[]{} : this.relationship.toArray(new Base[this.relationship.size()]);
                }
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case -1429363305: {
                    return this.telecom == null ? new Base[]{} : this.telecom.toArray(new Base[this.telecom.size()]);
                }
                case -1147692044: {
                    Base[] baseArray;
                    if (this.address == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.address;
                    }
                    return baseArray;
                }
                case -1249512767: {
                    Base[] baseArray;
                    if (this.gender == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.gender;
                    }
                    return baseArray;
                }
                case 1178922291: {
                    Base[] baseArray;
                    if (this.organization == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.organization;
                    }
                    return baseArray;
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.period;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -261851592: {
                    this.getRelationship().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 3373707: {
                    this.name = this.castToHumanName(value);
                    return value;
                }
                case -1429363305: {
                    this.getTelecom().add(this.castToContactPoint(value));
                    return value;
                }
                case -1147692044: {
                    this.address = this.castToAddress(value);
                    return value;
                }
                case -1249512767: {
                    value = new Enumerations.AdministrativeGenderEnumFactory().fromType(this.castToCode(value));
                    this.gender = value;
                    return value;
                }
                case 1178922291: {
                    this.organization = this.castToReference(value);
                    return value;
                }
                case -991726143: {
                    this.period = this.castToPeriod(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("relationship")) {
                this.getRelationship().add(this.castToCodeableConcept(value));
            } else if (name.equals(Patient.SP_NAME)) {
                this.name = this.castToHumanName(value);
            } else if (name.equals(Patient.SP_TELECOM)) {
                this.getTelecom().add(this.castToContactPoint(value));
            } else if (name.equals(Patient.SP_ADDRESS)) {
                this.address = this.castToAddress(value);
            } else if (name.equals(Patient.SP_GENDER)) {
                value = new Enumerations.AdministrativeGenderEnumFactory().fromType(this.castToCode(value));
                this.gender = value;
            } else if (name.equals(Patient.SP_ORGANIZATION)) {
                this.organization = this.castToReference(value);
            } else if (name.equals("period")) {
                this.period = this.castToPeriod(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -261851592: {
                    return this.addRelationship();
                }
                case 3373707: {
                    return this.getName();
                }
                case -1429363305: {
                    return this.addTelecom();
                }
                case -1147692044: {
                    return this.getAddress();
                }
                case -1249512767: {
                    return this.getGenderElement();
                }
                case 1178922291: {
                    return this.getOrganization();
                }
                case -991726143: {
                    return this.getPeriod();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -261851592: {
                    return new String[]{"CodeableConcept"};
                }
                case 3373707: {
                    return new String[]{"HumanName"};
                }
                case -1429363305: {
                    return new String[]{"ContactPoint"};
                }
                case -1147692044: {
                    return new String[]{"Address"};
                }
                case -1249512767: {
                    return new String[]{"code"};
                }
                case 1178922291: {
                    return new String[]{"Reference"};
                }
                case -991726143: {
                    return new String[]{"Period"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("relationship")) {
                return this.addRelationship();
            }
            if (name.equals(Patient.SP_NAME)) {
                this.name = new HumanName();
                return this.name;
            }
            if (name.equals(Patient.SP_TELECOM)) {
                return this.addTelecom();
            }
            if (name.equals(Patient.SP_ADDRESS)) {
                this.address = new Address();
                return this.address;
            }
            if (name.equals(Patient.SP_GENDER)) {
                throw new FHIRException("Cannot call addChild on a primitive type Patient.gender");
            }
            if (name.equals(Patient.SP_ORGANIZATION)) {
                this.organization = new Reference();
                return this.organization;
            }
            if (name.equals("period")) {
                this.period = new Period();
                return this.period;
            }
            return super.addChild(name);
        }

        @Override
        public ContactComponent copy() {
            ContactComponent dst = new ContactComponent();
            this.copyValues(dst);
            if (this.relationship != null) {
                dst.relationship = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.relationship) {
                    dst.relationship.add(codeableConcept.copy());
                }
            }
            HumanName humanName = dst.name = this.name == null ? null : this.name.copy();
            if (this.telecom != null) {
                dst.telecom = new ArrayList<ContactPoint>();
                for (ContactPoint contactPoint : this.telecom) {
                    dst.telecom.add(contactPoint.copy());
                }
            }
            dst.address = this.address == null ? null : this.address.copy();
            dst.gender = this.gender == null ? null : this.gender.copy();
            dst.organization = this.organization == null ? null : this.organization.copy();
            dst.period = this.period == null ? null : this.period.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ContactComponent)) {
                return false;
            }
            ContactComponent o = (ContactComponent)other;
            return ContactComponent.compareDeep(this.relationship, o.relationship, true) && ContactComponent.compareDeep(this.name, o.name, true) && ContactComponent.compareDeep(this.telecom, o.telecom, true) && ContactComponent.compareDeep(this.address, o.address, true) && ContactComponent.compareDeep(this.gender, o.gender, true) && ContactComponent.compareDeep(this.organization, o.organization, true) && ContactComponent.compareDeep(this.period, o.period, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ContactComponent)) {
                return false;
            }
            ContactComponent o = (ContactComponent)other;
            return ContactComponent.compareValues(this.gender, o.gender, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.relationship, this.name, this.telecom, this.address, this.gender, this.organization, this.period});
        }

        @Override
        public String fhirType() {
            return "Patient.contact";
        }
    }

    public static class LinkTypeEnumFactory
    implements EnumFactory<LinkType> {
        @Override
        public LinkType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("replaced-by".equals(codeString)) {
                return LinkType.REPLACEDBY;
            }
            if ("replaces".equals(codeString)) {
                return LinkType.REPLACES;
            }
            if ("refer".equals(codeString)) {
                return LinkType.REFER;
            }
            if ("seealso".equals(codeString)) {
                return LinkType.SEEALSO;
            }
            throw new IllegalArgumentException("Unknown LinkType code '" + codeString + "'");
        }

        public Enumeration<LinkType> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<LinkType>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("replaced-by".equals(codeString)) {
                return new Enumeration<LinkType>(this, LinkType.REPLACEDBY);
            }
            if ("replaces".equals(codeString)) {
                return new Enumeration<LinkType>(this, LinkType.REPLACES);
            }
            if ("refer".equals(codeString)) {
                return new Enumeration<LinkType>(this, LinkType.REFER);
            }
            if ("seealso".equals(codeString)) {
                return new Enumeration<LinkType>(this, LinkType.SEEALSO);
            }
            throw new FHIRException("Unknown LinkType code '" + codeString + "'");
        }

        @Override
        public String toCode(LinkType code) {
            if (code == LinkType.REPLACEDBY) {
                return "replaced-by";
            }
            if (code == LinkType.REPLACES) {
                return "replaces";
            }
            if (code == LinkType.REFER) {
                return "refer";
            }
            if (code == LinkType.SEEALSO) {
                return "seealso";
            }
            return "?";
        }

        @Override
        public String toSystem(LinkType code) {
            return code.getSystem();
        }
    }

    public static enum LinkType {
        REPLACEDBY,
        REPLACES,
        REFER,
        SEEALSO,
        NULL;


        public static LinkType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("replaced-by".equals(codeString)) {
                return REPLACEDBY;
            }
            if ("replaces".equals(codeString)) {
                return REPLACES;
            }
            if ("refer".equals(codeString)) {
                return REFER;
            }
            if ("seealso".equals(codeString)) {
                return SEEALSO;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown LinkType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case REPLACEDBY: {
                    return "replaced-by";
                }
                case REPLACES: {
                    return "replaces";
                }
                case REFER: {
                    return "refer";
                }
                case SEEALSO: {
                    return "seealso";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case REPLACEDBY: {
                    return "http://hl7.org/fhir/link-type";
                }
                case REPLACES: {
                    return "http://hl7.org/fhir/link-type";
                }
                case REFER: {
                    return "http://hl7.org/fhir/link-type";
                }
                case SEEALSO: {
                    return "http://hl7.org/fhir/link-type";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case REPLACEDBY: {
                    return "The patient resource containing this link must no longer be used. The link points forward to another patient resource that must be used in lieu of the patient resource that contains this link.";
                }
                case REPLACES: {
                    return "The patient resource containing this link is the current active patient record. The link points back to an inactive patient resource that has been merged into this resource, and should be consulted to retrieve additional referenced information.";
                }
                case REFER: {
                    return "The patient resource containing this link is in use and valid but not considered the main source of information about a patient. The link points forward to another patient resource that should be consulted to retrieve additional patient information.";
                }
                case SEEALSO: {
                    return "The patient resource containing this link is in use and valid, but points to another patient resource that is known to contain data about the same person. Data in this resource might overlap or contradict information found in the other patient resource. This link does not indicate any relative importance of the resources concerned, and both should be regarded as equally valid.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case REPLACEDBY: {
                    return "Replaced-by";
                }
                case REPLACES: {
                    return "Replaces";
                }
                case REFER: {
                    return "Refer";
                }
                case SEEALSO: {
                    return "See also";
                }
            }
            return "?";
        }
    }
}

