/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu3.model.Annotation;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.Device;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.Group;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Patient;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.Practitioner;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.RelatedPerson;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.Timing;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.exceptions.FHIRException;

@ResourceDef(name="DeviceUseStatement", profile="http://hl7.org/fhir/Profile/DeviceUseStatement")
public class DeviceUseStatement
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="External identifier for this record", formalDefinition="An external identifier for this statement such as an IRI.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | completed | entered-in-error +", formalDefinition="A code representing the patient or other source's judgment about the state of the device used that this statement is about.  Generally this will be active or completed.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/device-statement-status")
    protected Enumeration<DeviceUseStatementStatus> status;
    @Child(name="subject", type={Patient.class, Group.class}, order=2, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Patient using device", formalDefinition="The patient who used the device.")
    protected Reference subject;
    protected Resource subjectTarget;
    @Child(name="whenUsed", type={Period.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Period device was used", formalDefinition="The time period over which the device was used.")
    protected Period whenUsed;
    @Child(name="timing", type={Timing.class, Period.class, DateTimeType.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="How often  the device was used", formalDefinition="How often the device was used.")
    protected Type timing;
    @Child(name="recordedOn", type={DateTimeType.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When statement was recorded", formalDefinition="The time at which the statement was made/recorded.")
    protected DateTimeType recordedOn;
    @Child(name="source", type={Patient.class, Practitioner.class, RelatedPerson.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Who made the statement", formalDefinition="Who reported the device was being used by the patient.")
    protected Reference source;
    protected Resource sourceTarget;
    @Child(name="device", type={Device.class}, order=7, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Reference to device used", formalDefinition="The details of the device used.")
    protected Reference device;
    protected Device deviceTarget;
    @Child(name="indication", type={CodeableConcept.class}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Why device was used", formalDefinition="Reason or justification for the use of the device.")
    protected List<CodeableConcept> indication;
    @Child(name="bodySite", type={CodeableConcept.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Target body site", formalDefinition="Indicates the site on the subject's body where the device was used ( i.e. the target site).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/body-site")
    protected CodeableConcept bodySite;
    @Child(name="note", type={Annotation.class}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Addition details (comments, instructions)", formalDefinition="Details about the device statement that were not represented at all or sufficiently in one of the attributes provided in a class. These may include for example a comment, an instruction, or a note associated with the statement.")
    protected List<Annotation> note;
    private static final long serialVersionUID = 2144163845L;
    @SearchParamDefinition(name="identifier", path="DeviceUseStatement.identifier", description="Search by identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="subject", path="DeviceUseStatement.subject", description="Search by subject", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Group.class, Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("DeviceUseStatement:subject").toLocked();
    @SearchParamDefinition(name="patient", path="DeviceUseStatement.subject", description="Search by subject - a patient", type="reference", target={Group.class, Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("DeviceUseStatement:patient").toLocked();
    @SearchParamDefinition(name="device", path="DeviceUseStatement.device", description="Search by device", type="reference", providesMembershipIn={@Compartment(name="Device")}, target={Device.class})
    public static final String SP_DEVICE = "device";
    public static final ReferenceClientParam DEVICE = new ReferenceClientParam("device");
    public static final Include INCLUDE_DEVICE = new Include("DeviceUseStatement:device").toLocked();

    public DeviceUseStatement() {
    }

    public DeviceUseStatement(Enumeration<DeviceUseStatementStatus> status, Reference subject, Reference device) {
        this.status = status;
        this.subject = subject;
        this.device = device;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public DeviceUseStatement setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public DeviceUseStatement addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<DeviceUseStatementStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceUseStatement.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<DeviceUseStatementStatus>(new DeviceUseStatementStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public DeviceUseStatement setStatusElement(Enumeration<DeviceUseStatementStatus> value) {
        this.status = value;
        return this;
    }

    public DeviceUseStatementStatus getStatus() {
        return this.status == null ? null : (DeviceUseStatementStatus)((Object)this.status.getValue());
    }

    public DeviceUseStatement setStatus(DeviceUseStatementStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<DeviceUseStatementStatus>(new DeviceUseStatementStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceUseStatement.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public DeviceUseStatement setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public DeviceUseStatement setSubjectTarget(Resource value) {
        this.subjectTarget = value;
        return this;
    }

    public Period getWhenUsed() {
        if (this.whenUsed == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceUseStatement.whenUsed");
            }
            if (Configuration.doAutoCreate()) {
                this.whenUsed = new Period();
            }
        }
        return this.whenUsed;
    }

    public boolean hasWhenUsed() {
        return this.whenUsed != null && !this.whenUsed.isEmpty();
    }

    public DeviceUseStatement setWhenUsed(Period value) {
        this.whenUsed = value;
        return this;
    }

    public Type getTiming() {
        return this.timing;
    }

    public Timing getTimingTiming() throws FHIRException {
        if (!(this.timing instanceof Timing)) {
            throw new FHIRException("Type mismatch: the type Timing was expected, but " + this.timing.getClass().getName() + " was encountered");
        }
        return (Timing)this.timing;
    }

    public boolean hasTimingTiming() {
        return this.timing instanceof Timing;
    }

    public Period getTimingPeriod() throws FHIRException {
        if (!(this.timing instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.timing.getClass().getName() + " was encountered");
        }
        return (Period)this.timing;
    }

    public boolean hasTimingPeriod() {
        return this.timing instanceof Period;
    }

    public DateTimeType getTimingDateTimeType() throws FHIRException {
        if (!(this.timing instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.timing.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.timing;
    }

    public boolean hasTimingDateTimeType() {
        return this.timing instanceof DateTimeType;
    }

    public boolean hasTiming() {
        return this.timing != null && !this.timing.isEmpty();
    }

    public DeviceUseStatement setTiming(Type value) {
        this.timing = value;
        return this;
    }

    public DateTimeType getRecordedOnElement() {
        if (this.recordedOn == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceUseStatement.recordedOn");
            }
            if (Configuration.doAutoCreate()) {
                this.recordedOn = new DateTimeType();
            }
        }
        return this.recordedOn;
    }

    public boolean hasRecordedOnElement() {
        return this.recordedOn != null && !this.recordedOn.isEmpty();
    }

    public boolean hasRecordedOn() {
        return this.recordedOn != null && !this.recordedOn.isEmpty();
    }

    public DeviceUseStatement setRecordedOnElement(DateTimeType value) {
        this.recordedOn = value;
        return this;
    }

    public Date getRecordedOn() {
        return this.recordedOn == null ? null : (Date)this.recordedOn.getValue();
    }

    public DeviceUseStatement setRecordedOn(Date value) {
        if (value == null) {
            this.recordedOn = null;
        } else {
            if (this.recordedOn == null) {
                this.recordedOn = new DateTimeType();
            }
            this.recordedOn.setValue(value);
        }
        return this;
    }

    public Reference getSource() {
        if (this.source == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceUseStatement.source");
            }
            if (Configuration.doAutoCreate()) {
                this.source = new Reference();
            }
        }
        return this.source;
    }

    public boolean hasSource() {
        return this.source != null && !this.source.isEmpty();
    }

    public DeviceUseStatement setSource(Reference value) {
        this.source = value;
        return this;
    }

    public Resource getSourceTarget() {
        return this.sourceTarget;
    }

    public DeviceUseStatement setSourceTarget(Resource value) {
        this.sourceTarget = value;
        return this;
    }

    public Reference getDevice() {
        if (this.device == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceUseStatement.device");
            }
            if (Configuration.doAutoCreate()) {
                this.device = new Reference();
            }
        }
        return this.device;
    }

    public boolean hasDevice() {
        return this.device != null && !this.device.isEmpty();
    }

    public DeviceUseStatement setDevice(Reference value) {
        this.device = value;
        return this;
    }

    public Device getDeviceTarget() {
        if (this.deviceTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceUseStatement.device");
            }
            if (Configuration.doAutoCreate()) {
                this.deviceTarget = new Device();
            }
        }
        return this.deviceTarget;
    }

    public DeviceUseStatement setDeviceTarget(Device value) {
        this.deviceTarget = value;
        return this;
    }

    public List<CodeableConcept> getIndication() {
        if (this.indication == null) {
            this.indication = new ArrayList<CodeableConcept>();
        }
        return this.indication;
    }

    public DeviceUseStatement setIndication(List<CodeableConcept> theIndication) {
        this.indication = theIndication;
        return this;
    }

    public boolean hasIndication() {
        if (this.indication == null) {
            return false;
        }
        for (CodeableConcept item : this.indication) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addIndication() {
        CodeableConcept t = new CodeableConcept();
        if (this.indication == null) {
            this.indication = new ArrayList<CodeableConcept>();
        }
        this.indication.add(t);
        return t;
    }

    public DeviceUseStatement addIndication(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.indication == null) {
            this.indication = new ArrayList<CodeableConcept>();
        }
        this.indication.add(t);
        return this;
    }

    public CodeableConcept getIndicationFirstRep() {
        if (this.getIndication().isEmpty()) {
            this.addIndication();
        }
        return this.getIndication().get(0);
    }

    public CodeableConcept getBodySite() {
        if (this.bodySite == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceUseStatement.bodySite");
            }
            if (Configuration.doAutoCreate()) {
                this.bodySite = new CodeableConcept();
            }
        }
        return this.bodySite;
    }

    public boolean hasBodySite() {
        return this.bodySite != null && !this.bodySite.isEmpty();
    }

    public DeviceUseStatement setBodySite(CodeableConcept value) {
        this.bodySite = value;
        return this;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public DeviceUseStatement setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public DeviceUseStatement addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "An external identifier for this statement such as an IRI.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property("status", "code", "A code representing the patient or other source's judgment about the state of the device used that this statement is about.  Generally this will be active or completed.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property(SP_SUBJECT, "Reference(Patient|Group)", "The patient who used the device.", 0, Integer.MAX_VALUE, this.subject));
        childrenList.add(new Property("whenUsed", "Period", "The time period over which the device was used.", 0, Integer.MAX_VALUE, this.whenUsed));
        childrenList.add(new Property("timing[x]", "Timing|Period|dateTime", "How often the device was used.", 0, Integer.MAX_VALUE, this.timing));
        childrenList.add(new Property("recordedOn", "dateTime", "The time at which the statement was made/recorded.", 0, Integer.MAX_VALUE, this.recordedOn));
        childrenList.add(new Property("source", "Reference(Patient|Practitioner|RelatedPerson)", "Who reported the device was being used by the patient.", 0, Integer.MAX_VALUE, this.source));
        childrenList.add(new Property(SP_DEVICE, "Reference(Device)", "The details of the device used.", 0, Integer.MAX_VALUE, this.device));
        childrenList.add(new Property("indication", "CodeableConcept", "Reason or justification for the use of the device.", 0, Integer.MAX_VALUE, this.indication));
        childrenList.add(new Property("bodySite", "CodeableConcept", "Indicates the site on the subject's body where the device was used ( i.e. the target site).", 0, Integer.MAX_VALUE, this.bodySite));
        childrenList.add(new Property("note", "Annotation", "Details about the device statement that were not represented at all or sufficiently in one of the attributes provided in a class. These may include for example a comment, an instruction, or a note associated with the statement.", 0, Integer.MAX_VALUE, this.note));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.subject;
                }
                return baseArray;
            }
            case 2042879511: {
                Base[] baseArray;
                if (this.whenUsed == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.whenUsed;
                }
                return baseArray;
            }
            case -873664438: {
                Base[] baseArray;
                if (this.timing == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.timing;
                }
                return baseArray;
            }
            case 735397551: {
                Base[] baseArray;
                if (this.recordedOn == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.recordedOn;
                }
                return baseArray;
            }
            case -896505829: {
                Base[] baseArray;
                if (this.source == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.source;
                }
                return baseArray;
            }
            case -1335157162: {
                Base[] baseArray;
                if (this.device == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.device;
                }
                return baseArray;
            }
            case -597168804: {
                return this.indication == null ? new Base[]{} : this.indication.toArray(new Base[this.indication.size()]);
            }
            case 1702620169: {
                Base[] baseArray;
                if (this.bodySite == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.bodySite;
                }
                return baseArray;
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new DeviceUseStatementStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case -1867885268: {
                this.subject = this.castToReference(value);
                return value;
            }
            case 2042879511: {
                this.whenUsed = this.castToPeriod(value);
                return value;
            }
            case -873664438: {
                this.timing = this.castToType(value);
                return value;
            }
            case 735397551: {
                this.recordedOn = this.castToDateTime(value);
                return value;
            }
            case -896505829: {
                this.source = this.castToReference(value);
                return value;
            }
            case -1335157162: {
                this.device = this.castToReference(value);
                return value;
            }
            case -597168804: {
                this.getIndication().add(this.castToCodeableConcept(value));
                return value;
            }
            case 1702620169: {
                this.bodySite = this.castToCodeableConcept(value);
                return value;
            }
            case 3387378: {
                this.getNote().add(this.castToAnnotation(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("status")) {
            value = new DeviceUseStatementStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals("whenUsed")) {
            this.whenUsed = this.castToPeriod(value);
        } else if (name.equals("timing[x]")) {
            this.timing = this.castToType(value);
        } else if (name.equals("recordedOn")) {
            this.recordedOn = this.castToDateTime(value);
        } else if (name.equals("source")) {
            this.source = this.castToReference(value);
        } else if (name.equals(SP_DEVICE)) {
            this.device = this.castToReference(value);
        } else if (name.equals("indication")) {
            this.getIndication().add(this.castToCodeableConcept(value));
        } else if (name.equals("bodySite")) {
            this.bodySite = this.castToCodeableConcept(value);
        } else if (name.equals("note")) {
            this.getNote().add(this.castToAnnotation(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 2042879511: {
                return this.getWhenUsed();
            }
            case 164632566: {
                return this.getTiming();
            }
            case -873664438: {
                return this.getTiming();
            }
            case 735397551: {
                return this.getRecordedOnElement();
            }
            case -896505829: {
                return this.getSource();
            }
            case -1335157162: {
                return this.getDevice();
            }
            case -597168804: {
                return this.addIndication();
            }
            case 1702620169: {
                return this.getBodySite();
            }
            case 3387378: {
                return this.addNote();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 2042879511: {
                return new String[]{"Period"};
            }
            case -873664438: {
                return new String[]{"Timing", "Period", "dateTime"};
            }
            case 735397551: {
                return new String[]{"dateTime"};
            }
            case -896505829: {
                return new String[]{"Reference"};
            }
            case -1335157162: {
                return new String[]{"Reference"};
            }
            case -597168804: {
                return new String[]{"CodeableConcept"};
            }
            case 1702620169: {
                return new String[]{"CodeableConcept"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("status")) {
            throw new FHIRException("Cannot call addChild on a primitive type DeviceUseStatement.status");
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals("whenUsed")) {
            this.whenUsed = new Period();
            return this.whenUsed;
        }
        if (name.equals("timingTiming")) {
            this.timing = new Timing();
            return this.timing;
        }
        if (name.equals("timingPeriod")) {
            this.timing = new Period();
            return this.timing;
        }
        if (name.equals("timingDateTime")) {
            this.timing = new DateTimeType();
            return this.timing;
        }
        if (name.equals("recordedOn")) {
            throw new FHIRException("Cannot call addChild on a primitive type DeviceUseStatement.recordedOn");
        }
        if (name.equals("source")) {
            this.source = new Reference();
            return this.source;
        }
        if (name.equals(SP_DEVICE)) {
            this.device = new Reference();
            return this.device;
        }
        if (name.equals("indication")) {
            return this.addIndication();
        }
        if (name.equals("bodySite")) {
            this.bodySite = new CodeableConcept();
            return this.bodySite;
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DeviceUseStatement";
    }

    @Override
    public DeviceUseStatement copy() {
        DeviceUseStatement dst = new DeviceUseStatement();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.whenUsed = this.whenUsed == null ? null : this.whenUsed.copy();
        dst.timing = this.timing == null ? null : this.timing.copy();
        dst.recordedOn = this.recordedOn == null ? null : this.recordedOn.copy();
        dst.source = this.source == null ? null : this.source.copy();
        Reference reference = dst.device = this.device == null ? null : this.device.copy();
        if (this.indication != null) {
            dst.indication = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.indication) {
                dst.indication.add(codeableConcept.copy());
            }
        }
        CodeableConcept codeableConcept = dst.bodySite = this.bodySite == null ? null : this.bodySite.copy();
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        return dst;
    }

    protected DeviceUseStatement typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof DeviceUseStatement)) {
            return false;
        }
        DeviceUseStatement o = (DeviceUseStatement)other;
        return DeviceUseStatement.compareDeep(this.identifier, o.identifier, true) && DeviceUseStatement.compareDeep(this.status, o.status, true) && DeviceUseStatement.compareDeep(this.subject, o.subject, true) && DeviceUseStatement.compareDeep(this.whenUsed, o.whenUsed, true) && DeviceUseStatement.compareDeep(this.timing, o.timing, true) && DeviceUseStatement.compareDeep(this.recordedOn, o.recordedOn, true) && DeviceUseStatement.compareDeep(this.source, o.source, true) && DeviceUseStatement.compareDeep(this.device, o.device, true) && DeviceUseStatement.compareDeep(this.indication, o.indication, true) && DeviceUseStatement.compareDeep(this.bodySite, o.bodySite, true) && DeviceUseStatement.compareDeep(this.note, o.note, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof DeviceUseStatement)) {
            return false;
        }
        DeviceUseStatement o = (DeviceUseStatement)other;
        return DeviceUseStatement.compareValues(this.status, o.status, true) && DeviceUseStatement.compareValues(this.recordedOn, o.recordedOn, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.subject, this.whenUsed, this.timing, this.recordedOn, this.source, this.device, this.indication, this.bodySite, this.note});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.DeviceUseStatement;
    }

    public static class DeviceUseStatementStatusEnumFactory
    implements EnumFactory<DeviceUseStatementStatus> {
        @Override
        public DeviceUseStatementStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return DeviceUseStatementStatus.ACTIVE;
            }
            if ("completed".equals(codeString)) {
                return DeviceUseStatementStatus.COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return DeviceUseStatementStatus.ENTEREDINERROR;
            }
            if ("intended".equals(codeString)) {
                return DeviceUseStatementStatus.INTENDED;
            }
            if ("stopped".equals(codeString)) {
                return DeviceUseStatementStatus.STOPPED;
            }
            if ("on-hold".equals(codeString)) {
                return DeviceUseStatementStatus.ONHOLD;
            }
            throw new IllegalArgumentException("Unknown DeviceUseStatementStatus code '" + codeString + "'");
        }

        public Enumeration<DeviceUseStatementStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<DeviceUseStatementStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return new Enumeration<DeviceUseStatementStatus>(this, DeviceUseStatementStatus.ACTIVE);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<DeviceUseStatementStatus>(this, DeviceUseStatementStatus.COMPLETED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<DeviceUseStatementStatus>(this, DeviceUseStatementStatus.ENTEREDINERROR);
            }
            if ("intended".equals(codeString)) {
                return new Enumeration<DeviceUseStatementStatus>(this, DeviceUseStatementStatus.INTENDED);
            }
            if ("stopped".equals(codeString)) {
                return new Enumeration<DeviceUseStatementStatus>(this, DeviceUseStatementStatus.STOPPED);
            }
            if ("on-hold".equals(codeString)) {
                return new Enumeration<DeviceUseStatementStatus>(this, DeviceUseStatementStatus.ONHOLD);
            }
            throw new FHIRException("Unknown DeviceUseStatementStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(DeviceUseStatementStatus code) {
            if (code == DeviceUseStatementStatus.ACTIVE) {
                return "active";
            }
            if (code == DeviceUseStatementStatus.COMPLETED) {
                return "completed";
            }
            if (code == DeviceUseStatementStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == DeviceUseStatementStatus.INTENDED) {
                return "intended";
            }
            if (code == DeviceUseStatementStatus.STOPPED) {
                return "stopped";
            }
            if (code == DeviceUseStatementStatus.ONHOLD) {
                return "on-hold";
            }
            return "?";
        }

        @Override
        public String toSystem(DeviceUseStatementStatus code) {
            return code.getSystem();
        }
    }

    public static enum DeviceUseStatementStatus {
        ACTIVE,
        COMPLETED,
        ENTEREDINERROR,
        INTENDED,
        STOPPED,
        ONHOLD,
        NULL;


        public static DeviceUseStatementStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("intended".equals(codeString)) {
                return INTENDED;
            }
            if ("stopped".equals(codeString)) {
                return STOPPED;
            }
            if ("on-hold".equals(codeString)) {
                return ONHOLD;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown DeviceUseStatementStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case COMPLETED: {
                    return "completed";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case INTENDED: {
                    return "intended";
                }
                case STOPPED: {
                    return "stopped";
                }
                case ONHOLD: {
                    return "on-hold";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/device-statement-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/device-statement-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/device-statement-status";
                }
                case INTENDED: {
                    return "http://hl7.org/fhir/device-statement-status";
                }
                case STOPPED: {
                    return "http://hl7.org/fhir/device-statement-status";
                }
                case ONHOLD: {
                    return "http://hl7.org/fhir/device-statement-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "The device is still being used.";
                }
                case COMPLETED: {
                    return "The device is no longer being used.";
                }
                case ENTEREDINERROR: {
                    return "The statement was recorded incorrectly.";
                }
                case INTENDED: {
                    return "The device may be used at some time in the future.";
                }
                case STOPPED: {
                    return "Actions implied by the statement have been permanently halted, before all of them occurred.";
                }
                case ONHOLD: {
                    return "Actions implied by the statement have been temporarily halted, but are expected to continue later. May also be called \"suspended\".";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case INTENDED: {
                    return "Intended";
                }
                case STOPPED: {
                    return "Stopped";
                }
                case ONHOLD: {
                    return "On Hold";
                }
            }
            return "?";
        }
    }
}

