/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.context;

import java.util.List;
import java.util.Set;
import org.hl7.fhir.dstu3.formats.IParser;
import org.hl7.fhir.dstu3.formats.ParserType;
import org.hl7.fhir.dstu3.model.CodeSystem;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.ConceptMap;
import org.hl7.fhir.dstu3.model.ExpansionProfile;
import org.hl7.fhir.dstu3.model.MetadataResource;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.StructureDefinition;
import org.hl7.fhir.dstu3.model.ValueSet;
import org.hl7.fhir.dstu3.terminologies.ValueSetExpander;
import org.hl7.fhir.dstu3.utils.INarrativeGenerator;
import org.hl7.fhir.dstu3.utils.IResourceValidator;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.TerminologyServiceException;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public interface IWorkerContext {
    public String getVersion();

    public IParser getParser(ParserType var1);

    public IParser getParser(String var1);

    public IParser newJsonParser();

    public IParser newXmlParser();

    public INarrativeGenerator getNarrativeGenerator(String var1, String var2);

    public IResourceValidator newValidator() throws FHIRException;

    public <T extends Resource> T fetchResource(Class<T> var1, String var2);

    public <T extends Resource> T fetchResourceWithException(Class<T> var1, String var2) throws FHIRException;

    public <T extends Resource> boolean hasResource(Class<T> var1, String var2);

    public List<String> getResourceNames();

    public List<String> getTypeNames();

    public List<StructureDefinition> allStructures();

    public List<MetadataResource> allConformanceResources();

    public ExpansionProfile getExpansionProfile();

    public void setExpansionProfile(ExpansionProfile var1);

    public CodeSystem fetchCodeSystem(String var1);

    public boolean supportsSystem(String var1) throws TerminologyServiceException;

    public List<ConceptMap> findMapsForSource(String var1);

    public ValueSetExpander.ValueSetExpansionOutcome expandVS(ValueSet var1, boolean var2, boolean var3);

    public ValueSet.ValueSetExpansionComponent expandVS(ValueSet.ConceptSetComponent var1, boolean var2) throws TerminologyServiceException;

    public ValidationResult validateCode(String var1, String var2, String var3);

    public ValidationResult validateCode(String var1, String var2, String var3, ValueSet var4);

    public ValidationResult validateCode(Coding var1, ValueSet var2);

    public ValidationResult validateCode(CodeableConcept var1, ValueSet var2);

    public ValidationResult validateCode(String var1, String var2, String var3, ValueSet.ConceptSetComponent var4);

    public String getAbbreviation(String var1);

    public Set<String> typeTails();

    public String oid2Uri(String var1);

    public boolean hasCache();

    public void setLogger(ILoggingService var1);

    public boolean isNoTerminologyServer();

    public static interface ILoggingService {
        public void logMessage(String var1);

        public void logDebugMessage(LogCategory var1, String var2);

        public static enum LogCategory {
            PROGRESS,
            TX,
            INIT,
            CONTEXT,
            HTML;

        }
    }

    public static class ValidationResult {
        private CodeSystem.ConceptDefinitionComponent definition;
        private ValidationMessage.IssueSeverity severity;
        private String message;
        private ValueSetExpander.TerminologyServiceErrorClass errorClass;

        public ValidationResult(ValidationMessage.IssueSeverity severity, String message) {
            this.severity = severity;
            this.message = message;
        }

        public ValidationResult(CodeSystem.ConceptDefinitionComponent definition) {
            this.definition = definition;
        }

        public ValidationResult(ValidationMessage.IssueSeverity severity, String message, CodeSystem.ConceptDefinitionComponent definition) {
            this.severity = severity;
            this.message = message;
            this.definition = definition;
        }

        public ValidationResult(ValidationMessage.IssueSeverity severity, String message, ValueSetExpander.TerminologyServiceErrorClass errorClass) {
            this.severity = severity;
            this.message = message;
            this.errorClass = errorClass;
        }

        public boolean isOk() {
            return this.definition != null;
        }

        public String getDisplay() {
            return this.definition == null ? null : this.definition.getDisplay();
        }

        public CodeSystem.ConceptDefinitionComponent asConceptDefinition() {
            return this.definition;
        }

        public ValidationMessage.IssueSeverity getSeverity() {
            return this.severity;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean IsNoService() {
            return this.errorClass == ValueSetExpander.TerminologyServiceErrorClass.NOSERVICE;
        }

        public ValueSetExpander.TerminologyServiceErrorClass getErrorClass() {
            return this.errorClass;
        }
    }
}

