/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.composite;

import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.ICompositeDatatype;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.dstu2.composite.BoundCodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.DurationDt;
import ca.uhn.fhir.model.dstu2.composite.PeriodDt;
import ca.uhn.fhir.model.dstu2.composite.RangeDt;
import ca.uhn.fhir.model.dstu2.valueset.EventTimingEnum;
import ca.uhn.fhir.model.dstu2.valueset.TimingAbbreviationEnum;
import ca.uhn.fhir.model.dstu2.valueset.UnitsOfTimeEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.DecimalDt;
import ca.uhn.fhir.model.primitive.IntegerDt;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@DatatypeDef(name="Timing")
public class TimingDt
extends BaseIdentifiableElement
implements ICompositeDatatype {
    @Child(name="event", type={DateTimeDt.class}, order=0, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Identifies specific times when the event occurs")
    private List<DateTimeDt> myEvent;
    @Child(name="repeat", order=1, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A set of rules that describe when the event should occur")
    private Repeat myRepeat;
    @Child(name="code", type={CodeableConceptDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A code for the timing pattern. Some codes such as BID are ubiquitous, but many institutions define their own additional codes")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/timing-abbreviation")
    private BoundCodeableConceptDt<TimingAbbreviationEnum> myCode;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myEvent, this.myRepeat, this.myCode});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myEvent, this.myRepeat, this.myCode});
    }

    public List<DateTimeDt> getEvent() {
        if (this.myEvent == null) {
            this.myEvent = new ArrayList<DateTimeDt>();
        }
        return this.myEvent;
    }

    public TimingDt setEvent(List<DateTimeDt> theValue) {
        this.myEvent = theValue;
        return this;
    }

    public DateTimeDt addEvent() {
        DateTimeDt newType = new DateTimeDt();
        this.getEvent().add(newType);
        return newType;
    }

    public TimingDt addEvent(DateTimeDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getEvent().add(theValue);
        return this;
    }

    public DateTimeDt getEventFirstRep() {
        if (this.getEvent().isEmpty()) {
            return this.addEvent();
        }
        return this.getEvent().get(0);
    }

    public TimingDt addEvent(Date theDate) {
        if (this.myEvent == null) {
            this.myEvent = new ArrayList<DateTimeDt>();
        }
        this.myEvent.add(new DateTimeDt(theDate));
        return this;
    }

    public TimingDt addEvent(Date theDate, TemporalPrecisionEnum thePrecision) {
        if (this.myEvent == null) {
            this.myEvent = new ArrayList<DateTimeDt>();
        }
        this.myEvent.add(new DateTimeDt(theDate, thePrecision));
        return this;
    }

    public Repeat getRepeat() {
        if (this.myRepeat == null) {
            this.myRepeat = new Repeat();
        }
        return this.myRepeat;
    }

    public TimingDt setRepeat(Repeat theValue) {
        this.myRepeat = theValue;
        return this;
    }

    public BoundCodeableConceptDt<TimingAbbreviationEnum> getCode() {
        if (this.myCode == null) {
            this.myCode = new BoundCodeableConceptDt<TimingAbbreviationEnum>(TimingAbbreviationEnum.VALUESET_BINDER);
        }
        return this.myCode;
    }

    public TimingDt setCode(BoundCodeableConceptDt<TimingAbbreviationEnum> theValue) {
        this.myCode = theValue;
        return this;
    }

    public TimingDt setCode(TimingAbbreviationEnum theValue) {
        this.setCode(new BoundCodeableConceptDt<TimingAbbreviationEnum>(TimingAbbreviationEnum.VALUESET_BINDER, theValue));
        return this;
    }

    @Block
    public static class Repeat
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="bounds", order=0, min=0, max=1, summary=true, modifier=false, type={DurationDt.class, RangeDt.class, PeriodDt.class})
        @Description(shortDefinition="", formalDefinition="Either a duration for the length of the timing schedule, a range of possible length, or outer bounds for start and/or end limits of the timing schedule")
        private IDatatype myBounds;
        @Child(name="count", type={IntegerDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="A total count of the desired number of repetitions")
        private IntegerDt myCount;
        @Child(name="duration", type={DecimalDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="How long this thing happens for when it happens")
        private DecimalDt myDuration;
        @Child(name="durationMax", type={DecimalDt.class}, order=3, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="The upper limit of how long this thing happens for when it happens")
        private DecimalDt myDurationMax;
        @Child(name="durationUnits", type={CodeDt.class}, order=4, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="The units of time for the duration, in UCUM units")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/units-of-time")
        private BoundCodeDt<UnitsOfTimeEnum> myDurationUnits;
        @Child(name="frequency", type={IntegerDt.class}, order=5, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="The number of times to repeat the action within the specified period / period range (i.e. both period and periodMax provided)")
        private IntegerDt myFrequency;
        @Child(name="frequencyMax", type={IntegerDt.class}, order=6, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="")
        private IntegerDt myFrequencyMax;
        @Child(name="period", type={DecimalDt.class}, order=7, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Indicates the duration of time over which repetitions are to occur; e.g. to express \"3 times per day\", 3 would be the frequency and \"1 day\" would be the period")
        private DecimalDt myPeriod;
        @Child(name="periodMax", type={DecimalDt.class}, order=8, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="If present, indicates that the period is a range from [period] to [periodMax], allowing expressing concepts such as \"do this once every 3-5 days")
        private DecimalDt myPeriodMax;
        @Child(name="periodUnits", type={CodeDt.class}, order=9, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="The units of time for the period in UCUM units")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/units-of-time")
        private BoundCodeDt<UnitsOfTimeEnum> myPeriodUnits;
        @Child(name="when", type={CodeDt.class}, order=10, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="A real world event that the occurrence of the event should be tied to.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/event-timing")
        private BoundCodeDt<EventTimingEnum> myWhen;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myBounds, this.myCount, this.myDuration, this.myDurationMax, this.myDurationUnits, this.myFrequency, this.myFrequencyMax, this.myPeriod, this.myPeriodMax, this.myPeriodUnits, this.myWhen});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myBounds, this.myCount, this.myDuration, this.myDurationMax, this.myDurationUnits, this.myFrequency, this.myFrequencyMax, this.myPeriod, this.myPeriodMax, this.myPeriodUnits, this.myWhen});
        }

        public IDatatype getBounds() {
            return this.myBounds;
        }

        public Repeat setBounds(IDatatype theValue) {
            this.myBounds = theValue;
            return this;
        }

        public IntegerDt getCountElement() {
            if (this.myCount == null) {
                this.myCount = new IntegerDt();
            }
            return this.myCount;
        }

        public Integer getCount() {
            return (Integer)this.getCountElement().getValue();
        }

        public Repeat setCount(IntegerDt theValue) {
            this.myCount = theValue;
            return this;
        }

        public Repeat setCount(int theInteger) {
            this.myCount = new IntegerDt(theInteger);
            return this;
        }

        public DecimalDt getDurationElement() {
            if (this.myDuration == null) {
                this.myDuration = new DecimalDt();
            }
            return this.myDuration;
        }

        public BigDecimal getDuration() {
            return (BigDecimal)this.getDurationElement().getValue();
        }

        public Repeat setDuration(DecimalDt theValue) {
            this.myDuration = theValue;
            return this;
        }

        public Repeat setDuration(long theValue) {
            this.myDuration = new DecimalDt(theValue);
            return this;
        }

        public Repeat setDuration(double theValue) {
            this.myDuration = new DecimalDt(theValue);
            return this;
        }

        public Repeat setDuration(BigDecimal theValue) {
            this.myDuration = new DecimalDt(theValue);
            return this;
        }

        public DecimalDt getDurationMaxElement() {
            if (this.myDurationMax == null) {
                this.myDurationMax = new DecimalDt();
            }
            return this.myDurationMax;
        }

        public BigDecimal getDurationMax() {
            return (BigDecimal)this.getDurationMaxElement().getValue();
        }

        public Repeat setDurationMax(DecimalDt theValue) {
            this.myDurationMax = theValue;
            return this;
        }

        public Repeat setDurationMax(long theValue) {
            this.myDurationMax = new DecimalDt(theValue);
            return this;
        }

        public Repeat setDurationMax(double theValue) {
            this.myDurationMax = new DecimalDt(theValue);
            return this;
        }

        public Repeat setDurationMax(BigDecimal theValue) {
            this.myDurationMax = new DecimalDt(theValue);
            return this;
        }

        public BoundCodeDt<UnitsOfTimeEnum> getDurationUnitsElement() {
            if (this.myDurationUnits == null) {
                this.myDurationUnits = new BoundCodeDt(UnitsOfTimeEnum.VALUESET_BINDER);
            }
            return this.myDurationUnits;
        }

        public String getDurationUnits() {
            return (String)this.getDurationUnitsElement().getValue();
        }

        public Repeat setDurationUnits(BoundCodeDt<UnitsOfTimeEnum> theValue) {
            this.myDurationUnits = theValue;
            return this;
        }

        public Repeat setDurationUnits(UnitsOfTimeEnum theValue) {
            this.setDurationUnits((BoundCodeDt<UnitsOfTimeEnum>)new BoundCodeDt(UnitsOfTimeEnum.VALUESET_BINDER, (Enum)theValue));
            return this;
        }

        public IntegerDt getFrequencyElement() {
            if (this.myFrequency == null) {
                this.myFrequency = new IntegerDt();
            }
            return this.myFrequency;
        }

        public Integer getFrequency() {
            return (Integer)this.getFrequencyElement().getValue();
        }

        public Repeat setFrequency(IntegerDt theValue) {
            this.myFrequency = theValue;
            return this;
        }

        public Repeat setFrequency(int theInteger) {
            this.myFrequency = new IntegerDt(theInteger);
            return this;
        }

        public IntegerDt getFrequencyMaxElement() {
            if (this.myFrequencyMax == null) {
                this.myFrequencyMax = new IntegerDt();
            }
            return this.myFrequencyMax;
        }

        public Integer getFrequencyMax() {
            return (Integer)this.getFrequencyMaxElement().getValue();
        }

        public Repeat setFrequencyMax(IntegerDt theValue) {
            this.myFrequencyMax = theValue;
            return this;
        }

        public Repeat setFrequencyMax(int theInteger) {
            this.myFrequencyMax = new IntegerDt(theInteger);
            return this;
        }

        public DecimalDt getPeriodElement() {
            if (this.myPeriod == null) {
                this.myPeriod = new DecimalDt();
            }
            return this.myPeriod;
        }

        public BigDecimal getPeriod() {
            return (BigDecimal)this.getPeriodElement().getValue();
        }

        public Repeat setPeriod(DecimalDt theValue) {
            this.myPeriod = theValue;
            return this;
        }

        public Repeat setPeriod(long theValue) {
            this.myPeriod = new DecimalDt(theValue);
            return this;
        }

        public Repeat setPeriod(double theValue) {
            this.myPeriod = new DecimalDt(theValue);
            return this;
        }

        public Repeat setPeriod(BigDecimal theValue) {
            this.myPeriod = new DecimalDt(theValue);
            return this;
        }

        public DecimalDt getPeriodMaxElement() {
            if (this.myPeriodMax == null) {
                this.myPeriodMax = new DecimalDt();
            }
            return this.myPeriodMax;
        }

        public BigDecimal getPeriodMax() {
            return (BigDecimal)this.getPeriodMaxElement().getValue();
        }

        public Repeat setPeriodMax(DecimalDt theValue) {
            this.myPeriodMax = theValue;
            return this;
        }

        public Repeat setPeriodMax(long theValue) {
            this.myPeriodMax = new DecimalDt(theValue);
            return this;
        }

        public Repeat setPeriodMax(double theValue) {
            this.myPeriodMax = new DecimalDt(theValue);
            return this;
        }

        public Repeat setPeriodMax(BigDecimal theValue) {
            this.myPeriodMax = new DecimalDt(theValue);
            return this;
        }

        public BoundCodeDt<UnitsOfTimeEnum> getPeriodUnitsElement() {
            if (this.myPeriodUnits == null) {
                this.myPeriodUnits = new BoundCodeDt(UnitsOfTimeEnum.VALUESET_BINDER);
            }
            return this.myPeriodUnits;
        }

        public String getPeriodUnits() {
            return (String)this.getPeriodUnitsElement().getValue();
        }

        public Repeat setPeriodUnits(BoundCodeDt<UnitsOfTimeEnum> theValue) {
            this.myPeriodUnits = theValue;
            return this;
        }

        public Repeat setPeriodUnits(UnitsOfTimeEnum theValue) {
            this.setPeriodUnits((BoundCodeDt<UnitsOfTimeEnum>)new BoundCodeDt(UnitsOfTimeEnum.VALUESET_BINDER, (Enum)theValue));
            return this;
        }

        public BoundCodeDt<EventTimingEnum> getWhenElement() {
            if (this.myWhen == null) {
                this.myWhen = new BoundCodeDt(EventTimingEnum.VALUESET_BINDER);
            }
            return this.myWhen;
        }

        public String getWhen() {
            return (String)this.getWhenElement().getValue();
        }

        public Repeat setWhen(BoundCodeDt<EventTimingEnum> theValue) {
            this.myWhen = theValue;
            return this;
        }

        public Repeat setWhen(EventTimingEnum theValue) {
            this.setWhen((BoundCodeDt<EventTimingEnum>)new BoundCodeDt(EventTimingEnum.VALUESET_BINDER, (Enum)theValue));
            return this;
        }
    }
}

