/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.AddressDt;
import ca.uhn.fhir.model.dstu2.composite.BoundCodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.ContactPointDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Organization;
import ca.uhn.fhir.model.dstu2.valueset.LocationModeEnum;
import ca.uhn.fhir.model.dstu2.valueset.LocationStatusEnum;
import ca.uhn.fhir.model.dstu2.valueset.LocationTypeEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DecimalDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@ResourceDef(name="Location", profile="http://hl7.org/fhir/profiles/Location", id="location")
public class Location
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="identifier", path="Location.identifier", description="", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="name", path="Location.name", description="A (portion of the) name of the location", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="type", path="Location.type", description="A code for the type of location", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="address", path="Location.address", description="A (part of the) address of the location", type="string")
    public static final String SP_ADDRESS = "address";
    public static final StringClientParam ADDRESS = new StringClientParam("address");
    @SearchParamDefinition(name="address-city", path="Location.address.city", description="A city specified in an address", type="string")
    public static final String SP_ADDRESS_CITY = "address-city";
    public static final StringClientParam ADDRESS_CITY = new StringClientParam("address-city");
    @SearchParamDefinition(name="address-state", path="Location.address.state", description="A state specified in an address", type="string")
    public static final String SP_ADDRESS_STATE = "address-state";
    public static final StringClientParam ADDRESS_STATE = new StringClientParam("address-state");
    @SearchParamDefinition(name="address-postalcode", path="Location.address.postalCode", description="A postal code specified in an address", type="string")
    public static final String SP_ADDRESS_POSTALCODE = "address-postalcode";
    public static final StringClientParam ADDRESS_POSTALCODE = new StringClientParam("address-postalcode");
    @SearchParamDefinition(name="address-country", path="Location.address.country", description="A country specified in an address", type="string")
    public static final String SP_ADDRESS_COUNTRY = "address-country";
    public static final StringClientParam ADDRESS_COUNTRY = new StringClientParam("address-country");
    @SearchParamDefinition(name="address-use", path="Location.address.use", description="A use code specified in an address", type="token")
    public static final String SP_ADDRESS_USE = "address-use";
    public static final TokenClientParam ADDRESS_USE = new TokenClientParam("address-use");
    @SearchParamDefinition(name="status", path="Location.status", description="Searches for locations with a specific kind of status", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="partof", path="Location.partOf", description="The location of which this location is a part", type="reference")
    public static final String SP_PARTOF = "partof";
    public static final ReferenceClientParam PARTOF = new ReferenceClientParam("partof");
    @SearchParamDefinition(name="near", path="Location.position", description="The coordinates expressed as [lat],[long] (using the WGS84 datum, see notes) to find locations near to (servers may search using a square rather than a circle for efficiency)", type="token")
    public static final String SP_NEAR = "near";
    public static final TokenClientParam NEAR = new TokenClientParam("near");
    @SearchParamDefinition(name="near-distance", path="Location.position", description="A distance quantity to limit the near search to locations within a specific distance", type="token")
    public static final String SP_NEAR_DISTANCE = "near-distance";
    public static final TokenClientParam NEAR_DISTANCE = new TokenClientParam("near-distance");
    @SearchParamDefinition(name="organization", path="Location.managingOrganization", description="Searches for locations that are managed by the provided organization", type="reference")
    public static final String SP_ORGANIZATION = "organization";
    public static final ReferenceClientParam ORGANIZATION = new ReferenceClientParam("organization");
    public static final Include INCLUDE_ORGANIZATION = new Include("Location:organization");
    public static final Include INCLUDE_PARTOF = new Include("Location:partof");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="id", formalDefinition="Unique code or number identifying the location to its users")
    private List<IdentifierDt> myIdentifier;
    @Child(name="status", type={CodeDt.class}, order=1, min=0, max=1, summary=true, modifier=true)
    @Description(shortDefinition="status", formalDefinition="")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/location-status")
    private BoundCodeDt<LocationStatusEnum> myStatus;
    @Child(name="name", type={StringDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Name of the location as used by humans. Does not need to be unique.")
    private StringDt myName;
    @Child(name="description", type={StringDt.class}, order=3, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Description of the Location, which helps in finding or referencing the place")
    private StringDt myDescription;
    @Child(name="mode", type={CodeDt.class}, order=4, min=0, max=1, summary=true, modifier=true)
    @Description(shortDefinition="class", formalDefinition="Indicates whether a resource instance represents a specific location or a class of locations")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/location-mode")
    private BoundCodeDt<LocationModeEnum> myMode;
    @Child(name="type", type={CodeableConceptDt.class}, order=5, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="class", formalDefinition="Indicates the type of function performed at the location")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/v3-ServiceDeliveryLocationRoleType")
    private BoundCodeableConceptDt<LocationTypeEnum> myType;
    @Child(name="telecom", type={ContactPointDt.class}, order=6, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The contact details of communication devices available at the location. This can include phone numbers, fax numbers, mobile numbers, email addresses and web sites")
    private List<ContactPointDt> myTelecom;
    @Child(name="address", type={AddressDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="")
    private AddressDt myAddress;
    @Child(name="physicalType", type={CodeableConceptDt.class}, order=8, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="class", formalDefinition="Physical form of the location, e.g. building, room, vehicle, road")
    private CodeableConceptDt myPhysicalType;
    @Child(name="position", order=9, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The absolute geographic location of the Location, expressed using the WGS84 datum (This is the same co-ordinate system used in KML)")
    private Position myPosition;
    @Child(name="managingOrganization", order=10, min=0, max=1, summary=true, modifier=false, type={Organization.class})
    @Description(shortDefinition="", formalDefinition="The organization responsible for the provisioning and upkeep of the location")
    private ResourceReferenceDt myManagingOrganization;
    @Child(name="partOf", order=11, min=0, max=1, summary=false, modifier=false, type={Location.class})
    @Description(shortDefinition="", formalDefinition="Another Location which this Location is physically part of")
    private ResourceReferenceDt myPartOf;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myStatus, this.myName, this.myDescription, this.myMode, this.myType, this.myTelecom, this.myAddress, this.myPhysicalType, this.myPosition, this.myManagingOrganization, this.myPartOf});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myStatus, this.myName, this.myDescription, this.myMode, this.myType, this.myTelecom, this.myAddress, this.myPhysicalType, this.myPosition, this.myManagingOrganization, this.myPartOf});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public Location setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public Location addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public BoundCodeDt<LocationStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(LocationStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public String getStatus() {
        return (String)this.getStatusElement().getValue();
    }

    public Location setStatus(BoundCodeDt<LocationStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public Location setStatus(LocationStatusEnum theValue) {
        this.setStatus((BoundCodeDt<LocationStatusEnum>)new BoundCodeDt(LocationStatusEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public StringDt getNameElement() {
        if (this.myName == null) {
            this.myName = new StringDt();
        }
        return this.myName;
    }

    public String getName() {
        return (String)this.getNameElement().getValue();
    }

    public Location setName(StringDt theValue) {
        this.myName = theValue;
        return this;
    }

    public Location setName(String theString) {
        this.myName = new StringDt(theString);
        return this;
    }

    public StringDt getDescriptionElement() {
        if (this.myDescription == null) {
            this.myDescription = new StringDt();
        }
        return this.myDescription;
    }

    public String getDescription() {
        return (String)this.getDescriptionElement().getValue();
    }

    public Location setDescription(StringDt theValue) {
        this.myDescription = theValue;
        return this;
    }

    public Location setDescription(String theString) {
        this.myDescription = new StringDt(theString);
        return this;
    }

    public BoundCodeDt<LocationModeEnum> getModeElement() {
        if (this.myMode == null) {
            this.myMode = new BoundCodeDt(LocationModeEnum.VALUESET_BINDER);
        }
        return this.myMode;
    }

    public String getMode() {
        return (String)this.getModeElement().getValue();
    }

    public Location setMode(BoundCodeDt<LocationModeEnum> theValue) {
        this.myMode = theValue;
        return this;
    }

    public Location setMode(LocationModeEnum theValue) {
        this.setMode((BoundCodeDt<LocationModeEnum>)new BoundCodeDt(LocationModeEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public BoundCodeableConceptDt<LocationTypeEnum> getType() {
        if (this.myType == null) {
            this.myType = new BoundCodeableConceptDt<LocationTypeEnum>(LocationTypeEnum.VALUESET_BINDER);
        }
        return this.myType;
    }

    public Location setType(BoundCodeableConceptDt<LocationTypeEnum> theValue) {
        this.myType = theValue;
        return this;
    }

    public Location setType(LocationTypeEnum theValue) {
        this.setType(new BoundCodeableConceptDt<LocationTypeEnum>(LocationTypeEnum.VALUESET_BINDER, theValue));
        return this;
    }

    public List<ContactPointDt> getTelecom() {
        if (this.myTelecom == null) {
            this.myTelecom = new ArrayList<ContactPointDt>();
        }
        return this.myTelecom;
    }

    public Location setTelecom(List<ContactPointDt> theValue) {
        this.myTelecom = theValue;
        return this;
    }

    public ContactPointDt addTelecom() {
        ContactPointDt newType = new ContactPointDt();
        this.getTelecom().add(newType);
        return newType;
    }

    public Location addTelecom(ContactPointDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getTelecom().add(theValue);
        return this;
    }

    public ContactPointDt getTelecomFirstRep() {
        if (this.getTelecom().isEmpty()) {
            return this.addTelecom();
        }
        return this.getTelecom().get(0);
    }

    public AddressDt getAddress() {
        if (this.myAddress == null) {
            this.myAddress = new AddressDt();
        }
        return this.myAddress;
    }

    public Location setAddress(AddressDt theValue) {
        this.myAddress = theValue;
        return this;
    }

    public CodeableConceptDt getPhysicalType() {
        if (this.myPhysicalType == null) {
            this.myPhysicalType = new CodeableConceptDt();
        }
        return this.myPhysicalType;
    }

    public Location setPhysicalType(CodeableConceptDt theValue) {
        this.myPhysicalType = theValue;
        return this;
    }

    public Position getPosition() {
        if (this.myPosition == null) {
            this.myPosition = new Position();
        }
        return this.myPosition;
    }

    public Location setPosition(Position theValue) {
        this.myPosition = theValue;
        return this;
    }

    public ResourceReferenceDt getManagingOrganization() {
        if (this.myManagingOrganization == null) {
            this.myManagingOrganization = new ResourceReferenceDt();
        }
        return this.myManagingOrganization;
    }

    public Location setManagingOrganization(ResourceReferenceDt theValue) {
        this.myManagingOrganization = theValue;
        return this;
    }

    public ResourceReferenceDt getPartOf() {
        if (this.myPartOf == null) {
            this.myPartOf = new ResourceReferenceDt();
        }
        return this.myPartOf;
    }

    public Location setPartOf(ResourceReferenceDt theValue) {
        this.myPartOf = theValue;
        return this;
    }

    public String getResourceName() {
        return "Location";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Position
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="longitude", type={DecimalDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Longitude. The value domain and the interpretation are the same as for the text of the longitude element in KML (see notes below)")
        private DecimalDt myLongitude;
        @Child(name="latitude", type={DecimalDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Latitude. The value domain and the interpretation are the same as for the text of the latitude element in KML (see notes below)")
        private DecimalDt myLatitude;
        @Child(name="altitude", type={DecimalDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Altitude. The value domain and the interpretation are the same as for the text of the altitude element in KML (see notes below)")
        private DecimalDt myAltitude;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myLongitude, this.myLatitude, this.myAltitude});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myLongitude, this.myLatitude, this.myAltitude});
        }

        public DecimalDt getLongitudeElement() {
            if (this.myLongitude == null) {
                this.myLongitude = new DecimalDt();
            }
            return this.myLongitude;
        }

        public BigDecimal getLongitude() {
            return (BigDecimal)this.getLongitudeElement().getValue();
        }

        public Position setLongitude(DecimalDt theValue) {
            this.myLongitude = theValue;
            return this;
        }

        public Position setLongitude(double theValue) {
            this.myLongitude = new DecimalDt(theValue);
            return this;
        }

        public Position setLongitude(BigDecimal theValue) {
            this.myLongitude = new DecimalDt(theValue);
            return this;
        }

        public Position setLongitude(long theValue) {
            this.myLongitude = new DecimalDt(theValue);
            return this;
        }

        public DecimalDt getLatitudeElement() {
            if (this.myLatitude == null) {
                this.myLatitude = new DecimalDt();
            }
            return this.myLatitude;
        }

        public BigDecimal getLatitude() {
            return (BigDecimal)this.getLatitudeElement().getValue();
        }

        public Position setLatitude(DecimalDt theValue) {
            this.myLatitude = theValue;
            return this;
        }

        public Position setLatitude(double theValue) {
            this.myLatitude = new DecimalDt(theValue);
            return this;
        }

        public Position setLatitude(BigDecimal theValue) {
            this.myLatitude = new DecimalDt(theValue);
            return this;
        }

        public Position setLatitude(long theValue) {
            this.myLatitude = new DecimalDt(theValue);
            return this;
        }

        public DecimalDt getAltitudeElement() {
            if (this.myAltitude == null) {
                this.myAltitude = new DecimalDt();
            }
            return this.myAltitude;
        }

        public BigDecimal getAltitude() {
            return (BigDecimal)this.getAltitudeElement().getValue();
        }

        public Position setAltitude(DecimalDt theValue) {
            this.myAltitude = theValue;
            return this;
        }

        public Position setAltitude(double theValue) {
            this.myAltitude = new DecimalDt(theValue);
            return this;
        }

        public Position setAltitude(BigDecimal theValue) {
            this.myAltitude = new DecimalDt(theValue);
            return this;
        }

        public Position setAltitude(long theValue) {
            this.myAltitude = new DecimalDt(theValue);
            return this;
        }
    }
}

