/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.PeriodDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.composite.TimingDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.BodySite;
import ca.uhn.fhir.model.dstu2.resource.Device;
import ca.uhn.fhir.model.dstu2.resource.Encounter;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.valueset.DeviceUseRequestPriorityEnum;
import ca.uhn.fhir.model.dstu2.valueset.DeviceUseRequestStatusEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="DeviceUseRequest", profile="http://hl7.org/fhir/profiles/DeviceUseRequest", id="deviceuserequest")
public class DeviceUseRequest
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="subject", path="DeviceUseRequest.subject", description="Search by subject", type="reference", providesMembershipIn={@Compartment(name="Patient")})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    @SearchParamDefinition(name="patient", path="DeviceUseRequest.subject", description="Search by subject - a patient", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    @SearchParamDefinition(name="device", path="DeviceUseRequest.device", description="", type="reference", providesMembershipIn={@Compartment(name="Encounter")})
    public static final String SP_DEVICE = "device";
    public static final ReferenceClientParam DEVICE = new ReferenceClientParam("device");
    public static final Include INCLUDE_DEVICE = new Include("DeviceUseRequest:device");
    public static final Include INCLUDE_PATIENT = new Include("DeviceUseRequest:patient");
    public static final Include INCLUDE_SUBJECT = new Include("DeviceUseRequest:subject");
    @Child(name="bodySite", order=0, min=0, max=1, summary=false, modifier=false, type={CodeableConceptDt.class, BodySite.class})
    @Description(shortDefinition="", formalDefinition="Indicates the site on the subject's body where the device should be used ( i.e. the target site).")
    private IDatatype myBodySite;
    @Child(name="status", type={CodeDt.class}, order=1, min=0, max=1, summary=false, modifier=true)
    @Description(shortDefinition="status", formalDefinition="The status of the request.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/device-use-request-status")
    private BoundCodeDt<DeviceUseRequestStatusEnum> myStatus;
    @Child(name="device", order=2, min=1, max=1, summary=false, modifier=false, type={Device.class})
    @Description(shortDefinition="", formalDefinition="The details of the device  to be used.")
    private ResourceReferenceDt myDevice;
    @Child(name="encounter", order=3, min=0, max=1, summary=false, modifier=false, type={Encounter.class})
    @Description(shortDefinition="context", formalDefinition="An encounter that provides additional context in which this request is made.")
    private ResourceReferenceDt myEncounter;
    @Child(name="identifier", type={IdentifierDt.class}, order=4, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="id", formalDefinition="Identifiers assigned to this order by the orderer or by the receiver.")
    private List<IdentifierDt> myIdentifier;
    @Child(name="indication", type={CodeableConceptDt.class}, order=5, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="why", formalDefinition="Reason or justification for the use of this device.")
    private List<CodeableConceptDt> myIndication;
    @Child(name="notes", type={StringDt.class}, order=6, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Details about this request that were not represented at all or sufficiently in one of the attributes provided in a class. These may include for example a comment, an instruction, or a note associated with the statement.")
    private List<StringDt> myNotes;
    @Child(name="prnReason", type={CodeableConceptDt.class}, order=7, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The proposed act must be performed if the indicated conditions occur, e.g.., shortness of breath, SpO2 less than x%.")
    private List<CodeableConceptDt> myPrnReason;
    @Child(name="orderedOn", type={DateTimeDt.class}, order=8, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="when.init", formalDefinition="The time when the request was made.")
    private DateTimeDt myOrderedOn;
    @Child(name="recordedOn", type={DateTimeDt.class}, order=9, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="when.recorded", formalDefinition="The time at which the request was made/recorded.")
    private DateTimeDt myRecordedOn;
    @Child(name="subject", order=10, min=1, max=1, summary=false, modifier=false, type={Patient.class})
    @Description(shortDefinition="who.focus", formalDefinition="The patient who will use the device.")
    private ResourceReferenceDt mySubject;
    @Child(name="timing", order=11, min=0, max=1, summary=false, modifier=false, type={TimingDt.class, PeriodDt.class, DateTimeDt.class})
    @Description(shortDefinition="when.planned", formalDefinition="The timing schedule for the use of the device The Schedule data type allows many different expressions, for example. \"Every 8 hours\"; \"Three times a day\"; \"1/2 an hour before breakfast for 10 days from 23-Dec 2011:\"; \"15 Oct 2013, 17 Oct 2013 and 1 Nov 2013\".")
    private IDatatype myTiming;
    @Child(name="priority", type={CodeDt.class}, order=12, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="grade", formalDefinition="Characterizes how quickly the  use of device must be initiated. Includes concepts such as stat, urgent, routine.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/device-use-request-priority")
    private BoundCodeDt<DeviceUseRequestPriorityEnum> myPriority;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myBodySite, this.myStatus, this.myDevice, this.myEncounter, this.myIdentifier, this.myIndication, this.myNotes, this.myPrnReason, this.myOrderedOn, this.myRecordedOn, this.mySubject, this.myTiming, this.myPriority});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myBodySite, this.myStatus, this.myDevice, this.myEncounter, this.myIdentifier, this.myIndication, this.myNotes, this.myPrnReason, this.myOrderedOn, this.myRecordedOn, this.mySubject, this.myTiming, this.myPriority});
    }

    public IDatatype getBodySite() {
        return this.myBodySite;
    }

    public DeviceUseRequest setBodySite(IDatatype theValue) {
        this.myBodySite = theValue;
        return this;
    }

    public BoundCodeDt<DeviceUseRequestStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(DeviceUseRequestStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public String getStatus() {
        return (String)this.getStatusElement().getValue();
    }

    public DeviceUseRequest setStatus(BoundCodeDt<DeviceUseRequestStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public DeviceUseRequest setStatus(DeviceUseRequestStatusEnum theValue) {
        this.setStatus((BoundCodeDt<DeviceUseRequestStatusEnum>)new BoundCodeDt(DeviceUseRequestStatusEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public ResourceReferenceDt getDevice() {
        if (this.myDevice == null) {
            this.myDevice = new ResourceReferenceDt();
        }
        return this.myDevice;
    }

    public DeviceUseRequest setDevice(ResourceReferenceDt theValue) {
        this.myDevice = theValue;
        return this;
    }

    public ResourceReferenceDt getEncounter() {
        if (this.myEncounter == null) {
            this.myEncounter = new ResourceReferenceDt();
        }
        return this.myEncounter;
    }

    public DeviceUseRequest setEncounter(ResourceReferenceDt theValue) {
        this.myEncounter = theValue;
        return this;
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public DeviceUseRequest setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public DeviceUseRequest addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<CodeableConceptDt> getIndication() {
        if (this.myIndication == null) {
            this.myIndication = new ArrayList<CodeableConceptDt>();
        }
        return this.myIndication;
    }

    public DeviceUseRequest setIndication(List<CodeableConceptDt> theValue) {
        this.myIndication = theValue;
        return this;
    }

    public CodeableConceptDt addIndication() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getIndication().add(newType);
        return newType;
    }

    public DeviceUseRequest addIndication(CodeableConceptDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIndication().add(theValue);
        return this;
    }

    public CodeableConceptDt getIndicationFirstRep() {
        if (this.getIndication().isEmpty()) {
            return this.addIndication();
        }
        return this.getIndication().get(0);
    }

    public List<StringDt> getNotes() {
        if (this.myNotes == null) {
            this.myNotes = new ArrayList<StringDt>();
        }
        return this.myNotes;
    }

    public DeviceUseRequest setNotes(List<StringDt> theValue) {
        this.myNotes = theValue;
        return this;
    }

    public StringDt addNotes() {
        StringDt newType = new StringDt();
        this.getNotes().add(newType);
        return newType;
    }

    public DeviceUseRequest addNotes(StringDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getNotes().add(theValue);
        return this;
    }

    public StringDt getNotesFirstRep() {
        if (this.getNotes().isEmpty()) {
            return this.addNotes();
        }
        return this.getNotes().get(0);
    }

    public DeviceUseRequest addNotes(String theString) {
        if (this.myNotes == null) {
            this.myNotes = new ArrayList<StringDt>();
        }
        this.myNotes.add(new StringDt(theString));
        return this;
    }

    public List<CodeableConceptDt> getPrnReason() {
        if (this.myPrnReason == null) {
            this.myPrnReason = new ArrayList<CodeableConceptDt>();
        }
        return this.myPrnReason;
    }

    public DeviceUseRequest setPrnReason(List<CodeableConceptDt> theValue) {
        this.myPrnReason = theValue;
        return this;
    }

    public CodeableConceptDt addPrnReason() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getPrnReason().add(newType);
        return newType;
    }

    public DeviceUseRequest addPrnReason(CodeableConceptDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getPrnReason().add(theValue);
        return this;
    }

    public CodeableConceptDt getPrnReasonFirstRep() {
        if (this.getPrnReason().isEmpty()) {
            return this.addPrnReason();
        }
        return this.getPrnReason().get(0);
    }

    public DateTimeDt getOrderedOnElement() {
        if (this.myOrderedOn == null) {
            this.myOrderedOn = new DateTimeDt();
        }
        return this.myOrderedOn;
    }

    public Date getOrderedOn() {
        return (Date)this.getOrderedOnElement().getValue();
    }

    public DeviceUseRequest setOrderedOn(DateTimeDt theValue) {
        this.myOrderedOn = theValue;
        return this;
    }

    public DeviceUseRequest setOrderedOnWithSecondsPrecision(Date theDate) {
        this.myOrderedOn = new DateTimeDt(theDate);
        return this;
    }

    public DeviceUseRequest setOrderedOn(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myOrderedOn = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public DateTimeDt getRecordedOnElement() {
        if (this.myRecordedOn == null) {
            this.myRecordedOn = new DateTimeDt();
        }
        return this.myRecordedOn;
    }

    public Date getRecordedOn() {
        return (Date)this.getRecordedOnElement().getValue();
    }

    public DeviceUseRequest setRecordedOn(DateTimeDt theValue) {
        this.myRecordedOn = theValue;
        return this;
    }

    public DeviceUseRequest setRecordedOnWithSecondsPrecision(Date theDate) {
        this.myRecordedOn = new DateTimeDt(theDate);
        return this;
    }

    public DeviceUseRequest setRecordedOn(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myRecordedOn = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public DeviceUseRequest setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public IDatatype getTiming() {
        return this.myTiming;
    }

    public DeviceUseRequest setTiming(IDatatype theValue) {
        this.myTiming = theValue;
        return this;
    }

    public BoundCodeDt<DeviceUseRequestPriorityEnum> getPriorityElement() {
        if (this.myPriority == null) {
            this.myPriority = new BoundCodeDt(DeviceUseRequestPriorityEnum.VALUESET_BINDER);
        }
        return this.myPriority;
    }

    public String getPriority() {
        return (String)this.getPriorityElement().getValue();
    }

    public DeviceUseRequest setPriority(BoundCodeDt<DeviceUseRequestPriorityEnum> theValue) {
        this.myPriority = theValue;
        return this;
    }

    public DeviceUseRequest setPriority(DeviceUseRequestPriorityEnum theValue) {
        this.setPriority((BoundCodeDt<DeviceUseRequestPriorityEnum>)new BoundCodeDt(DeviceUseRequestPriorityEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public String getResourceName() {
        return "DeviceUseRequest";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }
}

