/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum AuditEventSourceTypeEnum {
    USER_DEVICE("1", "http://hl7.org/fhir/security-source-type"),
    DATA_INTERFACE("2", "http://hl7.org/fhir/security-source-type"),
    WEB_SERVER("3", "http://hl7.org/fhir/security-source-type"),
    APPLICATION_SERVER("4", "http://hl7.org/fhir/security-source-type"),
    DATABASE_SERVER("5", "http://hl7.org/fhir/security-source-type"),
    SECURITY_SERVER("6", "http://hl7.org/fhir/security-source-type"),
    NETWORK_DEVICE("7", "http://hl7.org/fhir/security-source-type"),
    NETWORK_ROUTER("8", "http://hl7.org/fhir/security-source-type"),
    OTHER("9", "http://hl7.org/fhir/security-source-type");

    public static final String VALUESET_IDENTIFIER = "";
    public static final String VALUESET_NAME = "Audit Event Source Type";
    private static Map<String, AuditEventSourceTypeEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, AuditEventSourceTypeEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<AuditEventSourceTypeEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static AuditEventSourceTypeEnum forCode(String theCode) {
        AuditEventSourceTypeEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private AuditEventSourceTypeEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, AuditEventSourceTypeEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, AuditEventSourceTypeEnum>>();
        for (AuditEventSourceTypeEnum next : AuditEventSourceTypeEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<AuditEventSourceTypeEnum>(){

            public String toCodeString(AuditEventSourceTypeEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(AuditEventSourceTypeEnum theEnum) {
                return theEnum.getSystem();
            }

            public AuditEventSourceTypeEnum fromCodeString(String theCodeString) {
                return CODE_TO_ENUM.get(theCodeString);
            }

            public AuditEventSourceTypeEnum fromCodeString(String theCodeString, String theSystemString) {
                Map<String, AuditEventSourceTypeEnum> map = SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return map.get(theCodeString);
            }
        };
    }
}

