/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum RulesetCodesEnum {
    X12_4010("x12-4010", "http://hl7.org/fhir/ruleset"),
    X12_5010("x12-5010", "http://hl7.org/fhir/ruleset"),
    X12_7010("x12-7010", "http://hl7.org/fhir/ruleset"),
    CDANET_V2("cdanet-v2", "http://hl7.org/fhir/ruleset"),
    CDANET_V4("cdanet-v4", "http://hl7.org/fhir/ruleset"),
    CPHA_3("cpha-3", "http://hl7.org/fhir/ruleset");

    public static final String VALUESET_IDENTIFIER = "";
    public static final String VALUESET_NAME = "Ruleset Codes";
    private static Map<String, RulesetCodesEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, RulesetCodesEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<RulesetCodesEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static RulesetCodesEnum forCode(String theCode) {
        RulesetCodesEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private RulesetCodesEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, RulesetCodesEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, RulesetCodesEnum>>();
        for (RulesetCodesEnum next : RulesetCodesEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<RulesetCodesEnum>(){

            public String toCodeString(RulesetCodesEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(RulesetCodesEnum theEnum) {
                return theEnum.getSystem();
            }

            public RulesetCodesEnum fromCodeString(String theCodeString) {
                return CODE_TO_ENUM.get(theCodeString);
            }

            public RulesetCodesEnum fromCodeString(String theCodeString, String theSystemString) {
                Map<String, RulesetCodesEnum> map = SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return map.get(theCodeString);
            }
        };
    }
}

