/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum HTTPVerbEnum {
    GET("GET", "http://hl7.org/fhir/http-verb"),
    POST("POST", "http://hl7.org/fhir/http-verb"),
    PUT("PUT", "http://hl7.org/fhir/http-verb"),
    DELETE("DELETE", "http://hl7.org/fhir/http-verb");

    public static final String VALUESET_IDENTIFIER = "";
    public static final String VALUESET_NAME = "HTTPVerb";
    private static Map<String, HTTPVerbEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, HTTPVerbEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<HTTPVerbEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static HTTPVerbEnum forCode(String theCode) {
        HTTPVerbEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private HTTPVerbEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, HTTPVerbEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, HTTPVerbEnum>>();
        for (HTTPVerbEnum next : HTTPVerbEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<HTTPVerbEnum>(){

            public String toCodeString(HTTPVerbEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(HTTPVerbEnum theEnum) {
                return theEnum.getSystem();
            }

            public HTTPVerbEnum fromCodeString(String theCodeString) {
                return CODE_TO_ENUM.get(theCodeString);
            }

            public HTTPVerbEnum fromCodeString(String theCodeString, String theSystemString) {
                Map<String, HTTPVerbEnum> map = SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return map.get(theCodeString);
            }
        };
    }
}

