/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum DocumentModeEnum {
    PRODUCER("producer", "http://hl7.org/fhir/document-mode"),
    CONSUMER("consumer", "http://hl7.org/fhir/document-mode");

    public static final String VALUESET_IDENTIFIER = "";
    public static final String VALUESET_NAME = "DocumentMode";
    private static Map<String, DocumentModeEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, DocumentModeEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<DocumentModeEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static DocumentModeEnum forCode(String theCode) {
        DocumentModeEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private DocumentModeEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, DocumentModeEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, DocumentModeEnum>>();
        for (DocumentModeEnum next : DocumentModeEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<DocumentModeEnum>(){

            public String toCodeString(DocumentModeEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(DocumentModeEnum theEnum) {
                return theEnum.getSystem();
            }

            public DocumentModeEnum fromCodeString(String theCodeString) {
                return CODE_TO_ENUM.get(theCodeString);
            }

            public DocumentModeEnum fromCodeString(String theCodeString, String theSystemString) {
                Map<String, DocumentModeEnum> map = SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return map.get(theCodeString);
            }
        };
    }
}

