/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum AnswerFormatEnum {
    BOOLEAN("boolean", "http://hl7.org/fhir/answer-format"),
    DECIMAL("decimal", "http://hl7.org/fhir/answer-format"),
    INTEGER("integer", "http://hl7.org/fhir/answer-format"),
    DATE("date", "http://hl7.org/fhir/answer-format"),
    DATE_TIME("dateTime", "http://hl7.org/fhir/answer-format"),
    INSTANT("instant", "http://hl7.org/fhir/answer-format"),
    TIME("time", "http://hl7.org/fhir/answer-format"),
    STRING("string", "http://hl7.org/fhir/answer-format"),
    TEXT("text", "http://hl7.org/fhir/answer-format"),
    URL("url", "http://hl7.org/fhir/answer-format"),
    CHOICE("choice", "http://hl7.org/fhir/answer-format"),
    OPEN_CHOICE("open-choice", "http://hl7.org/fhir/answer-format"),
    ATTACHMENT("attachment", "http://hl7.org/fhir/answer-format"),
    REFERENCE("reference", "http://hl7.org/fhir/answer-format"),
    QUANTITY("quantity", "http://hl7.org/fhir/answer-format");

    public static final String VALUESET_IDENTIFIER = "";
    public static final String VALUESET_NAME = "AnswerFormat";
    private static Map<String, AnswerFormatEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, AnswerFormatEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<AnswerFormatEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static AnswerFormatEnum forCode(String theCode) {
        AnswerFormatEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private AnswerFormatEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, AnswerFormatEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, AnswerFormatEnum>>();
        for (AnswerFormatEnum next : AnswerFormatEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<AnswerFormatEnum>(){

            public String toCodeString(AnswerFormatEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(AnswerFormatEnum theEnum) {
                return theEnum.getSystem();
            }

            public AnswerFormatEnum fromCodeString(String theCodeString) {
                return CODE_TO_ENUM.get(theCodeString);
            }

            public AnswerFormatEnum fromCodeString(String theCodeString, String theSystemString) {
                Map<String, AnswerFormatEnum> map = SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return map.get(theCodeString);
            }
        };
    }
}

