/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.CodingDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.MoneyDt;
import ca.uhn.fhir.model.dstu2.composite.PeriodDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Organization;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.resource.ProcessRequest;
import ca.uhn.fhir.model.dstu2.valueset.RemittanceOutcomeEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="PaymentReconciliation", profile="http://hl7.org/fhir/profiles/PaymentReconciliation", id="paymentreconciliation")
public class PaymentReconciliation
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="identifier", path="PaymentReconciliation.identifier", description="The business identifier of the Explanation of Benefit", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The Response business identifier")
    private List<IdentifierDt> myIdentifier;
    @Child(name="request", order=1, min=0, max=1, summary=false, modifier=false, type={ProcessRequest.class})
    @Description(shortDefinition="", formalDefinition="Original request resource reference")
    private ResourceReferenceDt myRequest;
    @Child(name="outcome", type={CodeDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Transaction status: error, complete")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/remittance-outcome")
    private BoundCodeDt<RemittanceOutcomeEnum> myOutcome;
    @Child(name="disposition", type={StringDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A description of the status of the adjudication.")
    private StringDt myDisposition;
    @Child(name="ruleset", type={CodingDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The version of the style of resource contents. This should be mapped to the allowable profiles for this and supporting resources.")
    private CodingDt myRuleset;
    @Child(name="originalRuleset", type={CodingDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The style (standard) and version of the original material which was converted into this resource.")
    private CodingDt myOriginalRuleset;
    @Child(name="created", type={DateTimeDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The date when the enclosed suite of services were performed or completed")
    private DateTimeDt myCreated;
    @Child(name="period", type={PeriodDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The period of time for which payments have been gathered into this bulk payment for settlement.")
    private PeriodDt myPeriod;
    @Child(name="organization", order=8, min=0, max=1, summary=false, modifier=false, type={Organization.class})
    @Description(shortDefinition="", formalDefinition="The Insurer who produced this adjudicated response.")
    private ResourceReferenceDt myOrganization;
    @Child(name="requestProvider", order=9, min=0, max=1, summary=false, modifier=false, type={Practitioner.class})
    @Description(shortDefinition="", formalDefinition="The practitioner who is responsible for the services rendered to the patient.")
    private ResourceReferenceDt myRequestProvider;
    @Child(name="requestOrganization", order=10, min=0, max=1, summary=false, modifier=false, type={Organization.class})
    @Description(shortDefinition="", formalDefinition="The organization which is responsible for the services rendered to the patient.")
    private ResourceReferenceDt myRequestOrganization;
    @Child(name="detail", order=11, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="List of individual settlement amounts and the corresponding transaction.")
    private List<Detail> myDetail;
    @Child(name="form", type={CodingDt.class}, order=12, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The form to be used for printing the content.")
    private CodingDt myForm;
    @Child(name="total", type={MoneyDt.class}, order=13, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Total payment amount.")
    private MoneyDt myTotal;
    @Child(name="note", order=14, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Suite of notes")
    private List<Note> myNote;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myRequest, this.myOutcome, this.myDisposition, this.myRuleset, this.myOriginalRuleset, this.myCreated, this.myPeriod, this.myOrganization, this.myRequestProvider, this.myRequestOrganization, this.myDetail, this.myForm, this.myTotal, this.myNote});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myRequest, this.myOutcome, this.myDisposition, this.myRuleset, this.myOriginalRuleset, this.myCreated, this.myPeriod, this.myOrganization, this.myRequestProvider, this.myRequestOrganization, this.myDetail, this.myForm, this.myTotal, this.myNote});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public PaymentReconciliation setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public PaymentReconciliation addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public ResourceReferenceDt getRequest() {
        if (this.myRequest == null) {
            this.myRequest = new ResourceReferenceDt();
        }
        return this.myRequest;
    }

    public PaymentReconciliation setRequest(ResourceReferenceDt theValue) {
        this.myRequest = theValue;
        return this;
    }

    public BoundCodeDt<RemittanceOutcomeEnum> getOutcomeElement() {
        if (this.myOutcome == null) {
            this.myOutcome = new BoundCodeDt(RemittanceOutcomeEnum.VALUESET_BINDER);
        }
        return this.myOutcome;
    }

    public String getOutcome() {
        return (String)this.getOutcomeElement().getValue();
    }

    public PaymentReconciliation setOutcome(BoundCodeDt<RemittanceOutcomeEnum> theValue) {
        this.myOutcome = theValue;
        return this;
    }

    public PaymentReconciliation setOutcome(RemittanceOutcomeEnum theValue) {
        this.setOutcome((BoundCodeDt<RemittanceOutcomeEnum>)new BoundCodeDt(RemittanceOutcomeEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public StringDt getDispositionElement() {
        if (this.myDisposition == null) {
            this.myDisposition = new StringDt();
        }
        return this.myDisposition;
    }

    public String getDisposition() {
        return (String)this.getDispositionElement().getValue();
    }

    public PaymentReconciliation setDisposition(StringDt theValue) {
        this.myDisposition = theValue;
        return this;
    }

    public PaymentReconciliation setDisposition(String theString) {
        this.myDisposition = new StringDt(theString);
        return this;
    }

    public CodingDt getRuleset() {
        if (this.myRuleset == null) {
            this.myRuleset = new CodingDt();
        }
        return this.myRuleset;
    }

    public PaymentReconciliation setRuleset(CodingDt theValue) {
        this.myRuleset = theValue;
        return this;
    }

    public CodingDt getOriginalRuleset() {
        if (this.myOriginalRuleset == null) {
            this.myOriginalRuleset = new CodingDt();
        }
        return this.myOriginalRuleset;
    }

    public PaymentReconciliation setOriginalRuleset(CodingDt theValue) {
        this.myOriginalRuleset = theValue;
        return this;
    }

    public DateTimeDt getCreatedElement() {
        if (this.myCreated == null) {
            this.myCreated = new DateTimeDt();
        }
        return this.myCreated;
    }

    public Date getCreated() {
        return (Date)this.getCreatedElement().getValue();
    }

    public PaymentReconciliation setCreated(DateTimeDt theValue) {
        this.myCreated = theValue;
        return this;
    }

    public PaymentReconciliation setCreatedWithSecondsPrecision(Date theDate) {
        this.myCreated = new DateTimeDt(theDate);
        return this;
    }

    public PaymentReconciliation setCreated(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myCreated = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public PeriodDt getPeriod() {
        if (this.myPeriod == null) {
            this.myPeriod = new PeriodDt();
        }
        return this.myPeriod;
    }

    public PaymentReconciliation setPeriod(PeriodDt theValue) {
        this.myPeriod = theValue;
        return this;
    }

    public ResourceReferenceDt getOrganization() {
        if (this.myOrganization == null) {
            this.myOrganization = new ResourceReferenceDt();
        }
        return this.myOrganization;
    }

    public PaymentReconciliation setOrganization(ResourceReferenceDt theValue) {
        this.myOrganization = theValue;
        return this;
    }

    public ResourceReferenceDt getRequestProvider() {
        if (this.myRequestProvider == null) {
            this.myRequestProvider = new ResourceReferenceDt();
        }
        return this.myRequestProvider;
    }

    public PaymentReconciliation setRequestProvider(ResourceReferenceDt theValue) {
        this.myRequestProvider = theValue;
        return this;
    }

    public ResourceReferenceDt getRequestOrganization() {
        if (this.myRequestOrganization == null) {
            this.myRequestOrganization = new ResourceReferenceDt();
        }
        return this.myRequestOrganization;
    }

    public PaymentReconciliation setRequestOrganization(ResourceReferenceDt theValue) {
        this.myRequestOrganization = theValue;
        return this;
    }

    public List<Detail> getDetail() {
        if (this.myDetail == null) {
            this.myDetail = new ArrayList<Detail>();
        }
        return this.myDetail;
    }

    public PaymentReconciliation setDetail(List<Detail> theValue) {
        this.myDetail = theValue;
        return this;
    }

    public Detail addDetail() {
        Detail newType = new Detail();
        this.getDetail().add(newType);
        return newType;
    }

    public PaymentReconciliation addDetail(Detail theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getDetail().add(theValue);
        return this;
    }

    public Detail getDetailFirstRep() {
        if (this.getDetail().isEmpty()) {
            return this.addDetail();
        }
        return this.getDetail().get(0);
    }

    public CodingDt getForm() {
        if (this.myForm == null) {
            this.myForm = new CodingDt();
        }
        return this.myForm;
    }

    public PaymentReconciliation setForm(CodingDt theValue) {
        this.myForm = theValue;
        return this;
    }

    public MoneyDt getTotal() {
        if (this.myTotal == null) {
            this.myTotal = new MoneyDt();
        }
        return this.myTotal;
    }

    public PaymentReconciliation setTotal(MoneyDt theValue) {
        this.myTotal = theValue;
        return this;
    }

    public List<Note> getNote() {
        if (this.myNote == null) {
            this.myNote = new ArrayList<Note>();
        }
        return this.myNote;
    }

    public PaymentReconciliation setNote(List<Note> theValue) {
        this.myNote = theValue;
        return this;
    }

    public Note addNote() {
        Note newType = new Note();
        this.getNote().add(newType);
        return newType;
    }

    public PaymentReconciliation addNote(Note theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getNote().add(theValue);
        return this;
    }

    public Note getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            return this.addNote();
        }
        return this.getNote().get(0);
    }

    public String getResourceName() {
        return "PaymentReconciliation";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Detail
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="type", type={CodingDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Code to indicate the nature of the payment, adjustment, funds advance, etc.")
        private CodingDt myType;
        @Child(name="request", order=1, min=0, max=1, summary=false, modifier=false, type={IResource.class})
        @Description(shortDefinition="", formalDefinition="The claim or financial resource.")
        private ResourceReferenceDt myRequest;
        @Child(name="responce", order=2, min=0, max=1, summary=false, modifier=false, type={IResource.class})
        @Description(shortDefinition="", formalDefinition="The claim response resource.")
        private ResourceReferenceDt myResponce;
        @Child(name="submitter", order=3, min=0, max=1, summary=false, modifier=false, type={Organization.class})
        @Description(shortDefinition="", formalDefinition="The Organization which submitted the invoice or financial transaction.")
        private ResourceReferenceDt mySubmitter;
        @Child(name="payee", order=4, min=0, max=1, summary=false, modifier=false, type={Organization.class})
        @Description(shortDefinition="", formalDefinition="The organization which is receiving the payment.")
        private ResourceReferenceDt myPayee;
        @Child(name="date", type={DateDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The date of the invoice or financial resource.")
        private DateDt myDate;
        @Child(name="amount", type={MoneyDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Amount paid for this detail.")
        private MoneyDt myAmount;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myType, this.myRequest, this.myResponce, this.mySubmitter, this.myPayee, this.myDate, this.myAmount});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myType, this.myRequest, this.myResponce, this.mySubmitter, this.myPayee, this.myDate, this.myAmount});
        }

        public CodingDt getType() {
            if (this.myType == null) {
                this.myType = new CodingDt();
            }
            return this.myType;
        }

        public Detail setType(CodingDt theValue) {
            this.myType = theValue;
            return this;
        }

        public ResourceReferenceDt getRequest() {
            if (this.myRequest == null) {
                this.myRequest = new ResourceReferenceDt();
            }
            return this.myRequest;
        }

        public Detail setRequest(ResourceReferenceDt theValue) {
            this.myRequest = theValue;
            return this;
        }

        public ResourceReferenceDt getResponce() {
            if (this.myResponce == null) {
                this.myResponce = new ResourceReferenceDt();
            }
            return this.myResponce;
        }

        public Detail setResponce(ResourceReferenceDt theValue) {
            this.myResponce = theValue;
            return this;
        }

        public ResourceReferenceDt getSubmitter() {
            if (this.mySubmitter == null) {
                this.mySubmitter = new ResourceReferenceDt();
            }
            return this.mySubmitter;
        }

        public Detail setSubmitter(ResourceReferenceDt theValue) {
            this.mySubmitter = theValue;
            return this;
        }

        public ResourceReferenceDt getPayee() {
            if (this.myPayee == null) {
                this.myPayee = new ResourceReferenceDt();
            }
            return this.myPayee;
        }

        public Detail setPayee(ResourceReferenceDt theValue) {
            this.myPayee = theValue;
            return this;
        }

        public DateDt getDateElement() {
            if (this.myDate == null) {
                this.myDate = new DateDt();
            }
            return this.myDate;
        }

        public Date getDate() {
            return (Date)this.getDateElement().getValue();
        }

        public Detail setDate(DateDt theValue) {
            this.myDate = theValue;
            return this;
        }

        public Detail setDateWithDayPrecision(Date theDate) {
            this.myDate = new DateDt(theDate);
            return this;
        }

        public Detail setDate(Date theDate, TemporalPrecisionEnum thePrecision) {
            this.myDate = new DateDt(theDate, thePrecision);
            return this;
        }

        public MoneyDt getAmount() {
            if (this.myAmount == null) {
                this.myAmount = new MoneyDt();
            }
            return this.myAmount;
        }

        public Detail setAmount(MoneyDt theValue) {
            this.myAmount = theValue;
            return this;
        }
    }

    @Block
    public static class Note
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="type", type={CodingDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The note purpose: Print/Display.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/note-type")
        private CodingDt myType;
        @Child(name="text", type={StringDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The note text.")
        private StringDt myText;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myType, this.myText});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myType, this.myText});
        }

        public CodingDt getType() {
            if (this.myType == null) {
                this.myType = new CodingDt();
            }
            return this.myType;
        }

        public Note setType(CodingDt theValue) {
            this.myType = theValue;
            return this;
        }

        public StringDt getTextElement() {
            if (this.myText == null) {
                this.myText = new StringDt();
            }
            return this.myText;
        }

        public String getText() {
            return (String)this.getTextElement().getValue();
        }

        public Note setText(StringDt theValue) {
            this.myText = theValue;
            return this;
        }

        public Note setText(String theString) {
            this.myText = new StringDt(theString);
            return this;
        }
    }
}

